/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.ValueChangedEvent;
import buoy.widget.Widget;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JScrollBar;

public class BScrollBar
extends Widget {
    private DefaultBoundedRangeModel model;
    private int suppressEvents;
    public static final Orientation HORIZONTAL = new Orientation(0);
    public static final Orientation VERTICAL = new Orientation(1);

    public BScrollBar() {
        this(0, 10, 0, 100, VERTICAL);
    }

    public BScrollBar(int n, int n2, int n3, int n4, Orientation orientation) {
        this.component = this.createComponent(orientation);
        this.model = new DefaultBoundedRangeModel(n, n2, n3, n4);
        this.getComponent().setModel(this.model);
    }

    protected JScrollBar createComponent(Orientation orientation) {
        return new BScrollBarComponent(orientation);
    }

    @Override
    public JScrollBar getComponent() {
        return (JScrollBar)this.component;
    }

    public int getMinimum() {
        return this.model.getMinimum();
    }

    public void setMinimum(int n) {
        this.model.setMinimum(n);
    }

    public int getMaximum() {
        return this.model.getMaximum();
    }

    public void setMaximum(int n) {
        this.model.setMaximum(n);
    }

    public int getValue() {
        return this.model.getValue();
    }

    public void setValue(int n) {
        try {
            ++this.suppressEvents;
            this.model.setValue(n);
        }
        finally {
            --this.suppressEvents;
        }
    }

    public int getExtent() {
        return this.model.getExtent();
    }

    public void setExtent(int n) {
        this.model.setExtent(n);
    }

    public Orientation getOrientation() {
        int n = this.getComponent().getOrientation();
        return n == BScrollBar.HORIZONTAL.value ? HORIZONTAL : VERTICAL;
    }

    public void setOrientation(Orientation orientation) {
        this.getComponent().setOrientation(orientation.value);
        this.invalidateSize();
    }

    public int getUnitIncrement() {
        return this.getComponent().getUnitIncrement();
    }

    protected int getUnitIncrement(int n) {
        return this.getUnitIncrement();
    }

    public void setUnitIncrement(int n) {
        this.getComponent().setUnitIncrement(n);
    }

    public int getBlockIncrement() {
        return this.getComponent().getBlockIncrement();
    }

    protected int getBlockIncrement(int n) {
        return this.getBlockIncrement();
    }

    public void setBlockIncrement(int n) {
        this.getComponent().setBlockIncrement(n);
    }

    static {
        WidgetEncoder.setPersistenceDelegate(Orientation.class, new StaticFieldDelegate(BScrollBar.class));
    }

    public static class Orientation {
        protected int value;

        private Orientation(int n) {
            this.value = n;
        }
    }

    private class BScrollBarComponent
    extends JScrollBar
    implements AdjustmentListener {
        public BScrollBarComponent(Orientation orientation) {
            super(orientation.value);
            this.addAdjustmentListener(this);
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (BScrollBar.this.suppressEvents == 0) {
                BScrollBar.this.dispatchEvent(new ValueChangedEvent(BScrollBar.this, BScrollBar.this.getComponent().getValueIsAdjusting()));
            }
        }

        @Override
        public int getUnitIncrement(int n) {
            return BScrollBar.this.getUnitIncrement(n);
        }

        @Override
        public int getBlockIncrement(int n) {
            return BScrollBar.this.getBlockIncrement(n);
        }
    }
}

