/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.RepaintEvent;
import buoy.event.WindowResizedEvent;
import buoy.widget.BMenuBar;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JRootPane;

public class BFrame
extends WindowWidget {
    private BMenuBar menubar;
    private ImageIcon icon;
    private static WeakHashMap<Frame, WeakReference<BFrame>> frameMap = new WeakHashMap();

    public BFrame() {
        this.component = this.createComponent();
        this.getComponent().getContentPane().setLayout(null);
        this.getComponent().setDefaultCloseOperation(0);
        frameMap.put(this.getComponent(), new WeakReference<BFrame>(this));
    }

    public BFrame(String string) {
        this();
        this.getComponent().setTitle(string);
    }

    protected JFrame createComponent() {
        return new BFrameComponent();
    }

    @Override
    public JFrame getComponent() {
        return (JFrame)this.component;
    }

    @Override
    public int getChildCount() {
        return (this.menubar == null ? 0 : 1) + (this.content == null ? 0 : 1);
    }

    @Override
    public Collection<Widget> getChildren() {
        ArrayList<Widget> arrayList = new ArrayList<Widget>(3);
        if (this.menubar != null) {
            arrayList.add(this.menubar);
        }
        if (this.content != null) {
            arrayList.add(this.content);
        }
        return arrayList;
    }

    public BMenuBar getMenuBar() {
        return this.menubar;
    }

    public void setMenuBar(BMenuBar bMenuBar) {
        if (this.menubar != null) {
            this.remove(this.menubar);
        }
        if (bMenuBar == null) {
            return;
        }
        if (bMenuBar.getParent() != null) {
            bMenuBar.getParent().remove(bMenuBar);
        }
        this.menubar = bMenuBar;
        this.getComponent().setJMenuBar(this.menubar.getComponent());
        this.setAsParent(this.menubar);
    }

    @Override
    public void remove(Widget widget) {
        if (this.menubar == widget) {
            this.getComponent().setJMenuBar(null);
            this.removeAsParent(this.menubar);
            this.menubar = null;
        } else if (this.content == widget) {
            this.getComponent().getContentPane().remove(widget.getComponent());
            this.removeAsParent(this.content);
            this.content = null;
        }
    }

    @Override
    public void removeAll() {
        if (this.menubar != null) {
            this.remove(this.menubar);
        }
        if (this.content != null) {
            this.remove(this.content);
        }
    }

    public String getTitle() {
        return this.getComponent().getTitle();
    }

    public void setTitle(String string) {
        this.getComponent().setTitle(string);
    }

    public boolean isResizable() {
        return this.getComponent().isResizable();
    }

    public void setResizable(boolean bl) {
        this.getComponent().setResizable(bl);
    }

    public boolean isIconified() {
        return (this.getComponent().getExtendedState() & 1) != 0;
    }

    public void setIconified(boolean bl) {
        JFrame jFrame = this.getComponent();
        int n = jFrame.getExtendedState();
        if (bl) {
            jFrame.setExtendedState(n | 1);
        } else {
            jFrame.setExtendedState(n - n & 1);
        }
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon imageIcon) {
        this.icon = imageIcon;
        this.getComponent().setIconImage(imageIcon.getImage());
    }

    public boolean isMaximized() {
        return (this.getComponent().getExtendedState() & 6) != 0;
    }

    public void setMaximized(boolean bl) {
        JFrame jFrame = this.getComponent();
        int n = jFrame.getExtendedState();
        if (bl) {
            jFrame.setExtendedState(n | 6);
        } else {
            jFrame.setExtendedState(n - n & 6);
        }
        this.lastSize = jFrame.getSize();
    }

    @Override
    protected JRootPane getRootPane() {
        return this.getComponent().getRootPane();
    }

    public static List<BFrame> getFrames() {
        ArrayList<BFrame> arrayList = new ArrayList<BFrame>();
        for (Frame frame : Frame.getFrames()) {
            BFrame bFrame;
            WeakReference<BFrame> weakReference = frameMap.get(frame);
            if (weakReference == null || (bFrame = (BFrame)weakReference.get()) == null) continue;
            arrayList.add(bFrame);
        }
        return arrayList;
    }

    private class BFrameComponent
    extends JFrame {
        public void paintComponent(Graphics graphics) {
            BFrame.this.dispatchEvent(new RepaintEvent(BFrame.this, (Graphics2D)graphics));
        }

        @Override
        public void validate() {
            super.validate();
            BFrame.this.layoutChildren();
            if (!BFrame.this.getComponent().getSize().equals(BFrame.this.lastSize)) {
                BFrame.this.lastSize = BFrame.this.getComponent().getSize();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BFrame.this.dispatchEvent(new WindowResizedEvent(BFrame.this));
                    }
                });
            }
        }
    }
}

