/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.SelectionChangedEvent;
import buoy.widget.Widget;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class BFileChooser
extends Widget {
    private SelectionMode selectMode;
    private static File lastDirectory = FileSystemView.getFileSystemView().getDefaultDirectory();
    public static final SelectionMode OPEN_FILE = new SelectionMode();
    public static final SelectionMode SAVE_FILE = new SelectionMode();
    public static final SelectionMode SELECT_FOLDER = new SelectionMode();

    public BFileChooser() {
        this(OPEN_FILE, null, lastDirectory);
    }

    public BFileChooser(SelectionMode selectionMode, String string) {
        this(selectionMode, string, lastDirectory);
    }

    public BFileChooser(SelectionMode selectionMode, String string, File file) {
        this.component = this.createComponent();
        this.setMode(selectionMode);
        this.setTitle(string);
        this.setDirectory(file);
        this.getComponent().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("SelectedFilesChangedProperty".equals(string) || "SelectedFileChangedProperty".equals(string) && !BFileChooser.this.isMultipleSelectionEnabled()) {
                    BFileChooser.this.dispatchEvent(new SelectionChangedEvent(BFileChooser.this));
                }
            }
        });
    }

    protected JFileChooser createComponent() {
        return new JFileChooser();
    }

    @Override
    public JFileChooser getComponent() {
        return (JFileChooser)this.component;
    }

    public String getTitle() {
        return this.getComponent().getDialogTitle();
    }

    public void setTitle(String string) {
        this.getComponent().setDialogTitle(string);
    }

    public SelectionMode getMode() {
        return this.selectMode;
    }

    public void setMode(SelectionMode selectionMode) {
        this.selectMode = selectionMode;
        this.getComponent().setFileSelectionMode(selectionMode == SELECT_FOLDER ? 1 : 0);
    }

    public boolean isMultipleSelectionEnabled() {
        return this.getComponent().isMultiSelectionEnabled();
    }

    public void setMultipleSelectionEnabled(boolean bl) {
        this.getComponent().setMultiSelectionEnabled(bl);
    }

    public FileFilter getFileFilter() {
        return this.getComponent().getFileFilter();
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.getComponent().setFileFilter(fileFilter);
    }

    public File getDirectory() {
        return this.getComponent().getCurrentDirectory();
    }

    public void setDirectory(File file) {
        this.getComponent().setCurrentDirectory(file);
        lastDirectory = file;
    }

    public File getSelectedFile() {
        return this.getComponent().getSelectedFile();
    }

    public void setSelectedFile(File file) {
        this.getComponent().setSelectedFile(file);
    }

    public File[] getSelectedFiles() {
        return this.getComponent().getSelectedFiles();
    }

    public void setSelectedFiles(File[] fileArray) throws IllegalArgumentException {
        if (!this.isMultipleSelectionEnabled()) {
            throw new IllegalArgumentException();
        }
        this.getComponent().setSelectedFiles(fileArray);
    }

    public boolean showDialog(Widget widget) {
        JFileChooser jFileChooser = this.getComponent();
        Component component = widget == null ? null : widget.getComponent();
        int n = this.selectMode == SAVE_FILE ? jFileChooser.showSaveDialog(component) : jFileChooser.showOpenDialog(component);
        lastDirectory = jFileChooser.getCurrentDirectory();
        return n == 0;
    }

    static {
        WidgetEncoder.setPersistenceDelegate(SelectionMode.class, new StaticFieldDelegate(SelectionMode.class));
    }

    public static class SelectionMode {
        private SelectionMode() {
        }
    }
}

