/*
 * Decompiled with CFR 0.152.
 */
package buoy.internal;

import buoy.event.FocusGainedEvent;
import buoy.event.FocusLostEvent;
import buoy.event.KeyPressedEvent;
import buoy.event.KeyReleasedEvent;
import buoy.event.KeyTypedEvent;
import buoy.event.MouseClickedEvent;
import buoy.event.MouseDraggedEvent;
import buoy.event.MouseEnteredEvent;
import buoy.event.MouseExitedEvent;
import buoy.event.MouseMovedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.event.MouseScrolledEvent;
import buoy.event.ToolTipEvent;
import buoy.event.WindowActivatedEvent;
import buoy.event.WindowClosingEvent;
import buoy.event.WindowDeactivatedEvent;
import buoy.event.WindowDeiconifiedEvent;
import buoy.event.WindowIconifiedEvent;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class EventLinkAdapter
implements FocusListener,
KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
WindowListener {
    private Widget widget;
    private int eventFlags;
    private static final int MOUSE_EVENT = 1;
    private static final int MOUSE_MOTION_EVENT = 2;
    private static final int MOUSE_WHEEL_EVENT = 4;
    private static final int KEY_EVENT = 8;
    private static final int FOCUS_EVENT = 16;
    private static final int WINDOW_EVENT = 32;

    public EventLinkAdapter(Widget widget) {
        this.widget = widget;
    }

    public void newEventType(Class clazz) {
        if ((this.eventFlags & 1) == 0 && (clazz.isAssignableFrom(MousePressedEvent.class) || clazz.isAssignableFrom(MouseReleasedEvent.class) || clazz.isAssignableFrom(MouseClickedEvent.class) || clazz.isAssignableFrom(MouseEnteredEvent.class) || clazz.isAssignableFrom(MouseExitedEvent.class) || clazz.isAssignableFrom(ToolTipEvent.class))) {
            this.eventFlags |= 1;
            this.widget.getComponent().addMouseListener(this);
        }
        if ((this.eventFlags & 2) == 0 && (clazz.isAssignableFrom(MouseMovedEvent.class) || clazz.isAssignableFrom(MouseDraggedEvent.class) || clazz.isAssignableFrom(ToolTipEvent.class))) {
            this.eventFlags |= 2;
            this.widget.getComponent().addMouseMotionListener(this);
        }
        if ((this.eventFlags & 4) == 0 && clazz.isAssignableFrom(MouseScrolledEvent.class)) {
            this.eventFlags |= 4;
            this.widget.getComponent().addMouseWheelListener(this);
        }
        if ((this.eventFlags & 8) == 0 && (clazz.isAssignableFrom(KeyPressedEvent.class) || clazz.isAssignableFrom(KeyReleasedEvent.class) || clazz.isAssignableFrom(KeyTypedEvent.class))) {
            this.eventFlags |= 8;
            this.widget.getComponent().addKeyListener(this);
        }
        if ((this.eventFlags & 0x10) == 0 && (clazz.isAssignableFrom(FocusGainedEvent.class) || clazz.isAssignableFrom(FocusLostEvent.class))) {
            this.eventFlags |= 0x10;
            this.widget.getComponent().addFocusListener(this);
        }
        if ((this.eventFlags & 0x20) == 0 && this.widget instanceof WindowWidget && this.widget.getComponent() instanceof Window && (clazz.isAssignableFrom(WindowActivatedEvent.class) || clazz.isAssignableFrom(WindowClosingEvent.class) || clazz.isAssignableFrom(WindowDeactivatedEvent.class) || clazz.isAssignableFrom(WindowDeiconifiedEvent.class) || clazz.isAssignableFrom(WindowIconifiedEvent.class))) {
            this.eventFlags |= 0x20;
            ((Window)this.widget.getComponent()).addWindowListener(this);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent, new MousePressedEvent(this.widget, mouseEvent.getWhen(), mouseEvent.getModifiersEx(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent, new MouseReleasedEvent(this.widget, mouseEvent.getWhen(), mouseEvent.getModifiersEx(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent, new MouseClickedEvent(this.widget, mouseEvent.getWhen(), mouseEvent.getModifiersEx(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent, new MouseEnteredEvent(this.widget, mouseEvent.getWhen(), mouseEvent.getModifiersEx(), mouseEvent.getX(), mouseEvent.getY()));
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent, new MouseExitedEvent(this.widget, mouseEvent.getWhen(), mouseEvent.getModifiersEx(), mouseEvent.getX(), mouseEvent.getY()));
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent, new MouseMovedEvent(this.widget, mouseEvent.getWhen(), mouseEvent.getModifiersEx(), mouseEvent.getX(), mouseEvent.getY()));
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent, new MouseDraggedEvent(this.widget, mouseEvent.getWhen(), mouseEvent.getModifiersEx(), mouseEvent.getX(), mouseEvent.getY()));
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.dispatchEvent(mouseWheelEvent, new MouseScrolledEvent(this.widget, mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiersEx(), mouseWheelEvent.getX(), mouseWheelEvent.getY(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation()));
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.dispatchEvent(keyEvent, new KeyPressedEvent(this.widget, keyEvent.getWhen(), keyEvent.getModifiersEx(), keyEvent.getKeyCode()));
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.dispatchEvent(keyEvent, new KeyReleasedEvent(this.widget, keyEvent.getWhen(), keyEvent.getModifiersEx(), keyEvent.getKeyCode()));
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.dispatchEvent(keyEvent, new KeyTypedEvent(this.widget, keyEvent.getWhen(), keyEvent.getModifiersEx(), keyEvent.getKeyChar()));
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.widget.dispatchEvent(new FocusGainedEvent(this.widget, focusEvent.isTemporary()));
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.widget.dispatchEvent(new FocusLostEvent(this.widget, focusEvent.isTemporary()));
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        this.widget.dispatchEvent(new WindowActivatedEvent((WindowWidget)this.widget));
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.widget.dispatchEvent(new WindowClosingEvent((WindowWidget)this.widget));
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        this.widget.dispatchEvent(new WindowDeactivatedEvent((WindowWidget)this.widget));
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
        this.widget.dispatchEvent(new WindowDeiconifiedEvent((WindowWidget)this.widget));
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
        this.widget.dispatchEvent(new WindowIconifiedEvent((WindowWidget)this.widget));
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    private void dispatchEvent(InputEvent inputEvent, InputEvent inputEvent2) {
        if (inputEvent.isConsumed()) {
            inputEvent2.consume();
        }
        this.widget.dispatchEvent(inputEvent2);
        if (inputEvent2.isConsumed()) {
            inputEvent.consume();
        }
    }
}

