# 1. Get the current logged-in user email (UPN)
$upn = az account show --query user.name -o tsv

# Check if we got a user, otherwise stop
if (-not $upn) {
    Write-Error "No user found. Please run 'az login'."
    exit 1
}

Write-Output "User found: $upn"
Write-Output "Fetching permissions for current subscription..."

# 2. List role assignments for this user in CURRENT subscription only (much faster)
# Removed --all flag to avoid scanning all subscriptions
az role assignment list --assignee $upn --output table

Write-Output "`nNote: Showing permissions for current subscription only. Use 'az account list --output table' to see all subscriptions."