"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualGatewayListener = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const utils_1 = require("./private/utils");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * Represents the properties needed to define listeners for a VirtualGateway
 */
class VirtualGatewayListener {
    /**
     * Returns an HTTP Listener for a VirtualGateway
     */
    static http(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_HttpGatewayListenerOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.http);
            }
            throw error;
        }
        return new VirtualGatewayListenerImpl(shared_interfaces_1.Protocol.HTTP, options.healthCheck, options.port, options.tls, options.connectionPool);
    }
    /**
     * Returns an HTTP2 Listener for a VirtualGateway
     */
    static http2(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_Http2GatewayListenerOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.http2);
            }
            throw error;
        }
        return new VirtualGatewayListenerImpl(shared_interfaces_1.Protocol.HTTP2, options.healthCheck, options.port, options.tls, options.connectionPool);
    }
    /**
     * Returns a GRPC Listener for a VirtualGateway
     */
    static grpc(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_GrpcGatewayListenerOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.grpc);
            }
            throw error;
        }
        return new VirtualGatewayListenerImpl(shared_interfaces_1.Protocol.GRPC, options.healthCheck, options.port, options.tls, options.connectionPool);
    }
}
exports.VirtualGatewayListener = VirtualGatewayListener;
_a = JSII_RTTI_SYMBOL_1;
VirtualGatewayListener[_a] = { fqn: "@aws-cdk/aws-appmesh.VirtualGatewayListener", version: "1.198.0" };
/**
 * Represents the properties needed to define an HTTP Listener for a VirtualGateway
 */
class VirtualGatewayListenerImpl extends VirtualGatewayListener {
    constructor(protocol, healthCheck, port = 8080, listenerTls, connectionPool) {
        super();
        this.protocol = protocol;
        this.healthCheck = healthCheck;
        this.port = port;
        this.listenerTls = listenerTls;
        this.connectionPool = connectionPool;
    }
    /**
     * Called when the GatewayListener type is initialized. Can be used to enforce
     * mutual exclusivity
     */
    bind(scope) {
        return {
            listener: {
                portMapping: {
                    port: this.port,
                    protocol: this.protocol,
                },
                healthCheck: this.healthCheck?.bind(scope, { defaultPort: this.port }).virtualGatewayHealthCheck,
                tls: utils_1.renderListenerTlsOptions(scope, this.listenerTls),
                connectionPool: this.connectionPool ? renderConnectionPool(this.connectionPool, this.protocol) : undefined,
            },
        };
    }
}
function renderConnectionPool(connectionPool, listenerProtocol) {
    return ({
        [listenerProtocol]: {
            maxRequests: connectionPool?.maxRequests !== undefined ? connectionPool.maxRequests : undefined,
            maxConnections: connectionPool?.maxConnections !== undefined ? connectionPool.maxConnections : undefined,
            maxPendingRequests: connectionPool?.maxPendingRequests !== undefined ? connectionPool.maxPendingRequests : undefined,
        },
    });
}
//# sourceMappingURL=data:application/json;base64,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