# -*- coding: utf-8 -*-
import os
import six
from setuptools import find_packages, setup

if six.PY2:
    with open(os.path.join(os.path.dirname(__file__), 'README.md')) as readme:
        README = readme.read()
else:
    with open(os.path.join(os.path.dirname(__file__), 'README.md'), encoding='utf8') as readme:
        README = readme.read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

setup(
    name='django2go',
    version='0.1.3',
    packages=find_packages(),
    include_package_data=True,
    description='Translate django model to go struct.',
    long_description=README,
    author='treeoph',
    author_email="treeoph@gmail.com",
    long_description_content_type='text/markdown',
    data_files=[
        ('django2go/templates', [])],
    classifiers=[
        'Environment :: Web Environment',
        'Framework :: Django',
        'Framework :: Django :: 1.10',  # replace "X.Y" as appropriate
        'Framework :: Django :: 3.2',  # replace "X.Y" as appropriate
        'Intended Audience :: Developers',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        # Replace these appropriately if you are stuck on Python 2.
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.9',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
    ],
)
