from typing import Any

from ...connectors.pyodbc import PyODBCConnector
from ...types import DateTime, Float, Numeric
from .base import BINARY, DATETIMEOFFSET, VARBINARY, MSDialect, MSExecutionContext

class _ms_numeric_pyodbc:
    def bind_processor(self, dialect): ...

class _MSNumeric_pyodbc(_ms_numeric_pyodbc, Numeric): ...
class _MSFloat_pyodbc(_ms_numeric_pyodbc, Float): ...

class _ms_binary_pyodbc:
    def bind_processor(self, dialect): ...

class _ODBCDateTimeBindProcessor:
    has_tz: bool
    def bind_processor(self, dialect): ...

class _ODBCDateTime(_ODBCDateTimeBindProcessor, DateTime): ...

class _ODBCDATETIMEOFFSET(_ODBCDateTimeBindProcessor, DATETIMEOFFSET):
    has_tz: bool

class _VARBINARY_pyodbc(_ms_binary_pyodbc, VARBINARY): ...
class _BINARY_pyodbc(_ms_binary_pyodbc, BINARY): ...

class MSExecutionContext_pyodbc(MSExecutionContext):
    def pre_exec(self) -> None: ...
    def post_exec(self) -> None: ...

# pyright complains about incompatible definitions of "supports_sane_rowcount_returning" in the base classes,
# hence the type: ignore
class MSDialect_pyodbc(PyODBCConnector, MSDialect):  # type: ignore
    supports_statement_cache: bool
    supports_sane_rowcount_returning: bool
    colspecs: Any
    description_encoding: Any
    use_scope_identity: Any
    fast_executemany: Any
    def __init__(self, description_encoding: Any | None = ..., fast_executemany: bool = ..., **params) -> None: ...
    def on_connect(self): ...
    def do_executemany(self, cursor, statement, parameters, context: Any | None = ...) -> None: ...
    def is_disconnect(self, e, connection, cursor): ...

dialect = MSDialect_pyodbc
