"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventbridgeToKinesisStreams = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const events = require("aws-cdk-lib/aws-events");
const iam = require("aws-cdk-lib/aws-iam");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-solutions-constructs/core");
class EventbridgeToKinesisStreams extends constructs_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the EventbridgeToKinesisStreams class.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        // Set up the Kinesis Stream
        this.kinesisStream = defaults.buildKinesisStream(this, {
            existingStreamObj: props.existingStreamObj,
            kinesisStreamProps: props.kinesisStreamProps,
        });
        // Create an events service role
        this.eventsRole = new iam.Role(this, 'eventsRole', {
            assumedBy: new iam.ServicePrincipal('events.amazonaws.com'),
            description: 'Events Rule Role',
        });
        // Grant permission to events service role to allow event rule to send events data to the kinesis stream
        this.kinesisStream.grantWrite(this.eventsRole);
        // Set up the Kinesis Stream as the target for event rule
        const kinesisStreamEventTarget = {
            bind: () => ({
                id: '',
                arn: this.kinesisStream.streamArn,
                role: this.eventsRole
            })
        };
        // build an event bus if existingEventBus is provided or eventBusProps are provided
        this.eventBus = defaults.buildEventBus(this, {
            existingEventBusInterface: props.existingEventBusInterface,
            eventBusProps: props.eventBusProps
        });
        // Set up the events rule props
        const defaultEventsRuleProps = defaults.DefaultEventsRuleProps([kinesisStreamEventTarget], this.eventBus);
        const eventsRuleProps = core_1.overrideProps(defaultEventsRuleProps, props.eventRuleProps, true);
        // Setup up the event rule
        this.eventsRule = new events.Rule(this, 'EventsRule', eventsRuleProps);
        if (props.createCloudWatchAlarms === undefined || props.createCloudWatchAlarms) {
            // Deploy best practices CW Alarms for Kinesis Stream
            this.cloudwatchAlarms = defaults.buildKinesisStreamCWAlarms(this);
        }
    }
}
exports.EventbridgeToKinesisStreams = EventbridgeToKinesisStreams;
_a = JSII_RTTI_SYMBOL_1;
EventbridgeToKinesisStreams[_a] = { fqn: "@aws-solutions-constructs/aws-eventbridge-kinesisstreams.EventbridgeToKinesisStreams", version: "2.2.0" };
//# sourceMappingURL=data:application/json;base64,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