# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkloadArgs', 'Workload']

@pulumi.input_type
class WorkloadArgs:
    def __init__(__self__, *,
                 containers: pulumi.Input[Sequence[pulumi.Input['WorkloadContainerArgs']]],
                 gvc: pulumi.Input[str],
                 options: pulumi.Input['WorkloadOptionsArgs'],
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 firewall_spec: Optional[pulumi.Input['WorkloadFirewallSpecArgs']] = None,
                 identity_link: Optional[pulumi.Input[str]] = None,
                 job: Optional[pulumi.Input['WorkloadJobArgs']] = None,
                 local_options: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadLocalOptionArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rollout_options: Optional[pulumi.Input['WorkloadRolloutOptionsArgs']] = None,
                 security_options: Optional[pulumi.Input['WorkloadSecurityOptionsArgs']] = None,
                 sidecar: Optional[pulumi.Input['WorkloadSidecarArgs']] = None,
                 support_dynamic_tags: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Workload resource.
        """
        WorkloadArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            containers=containers,
            gvc=gvc,
            options=options,
            type=type,
            description=description,
            firewall_spec=firewall_spec,
            identity_link=identity_link,
            job=job,
            local_options=local_options,
            name=name,
            rollout_options=rollout_options,
            security_options=security_options,
            sidecar=sidecar,
            support_dynamic_tags=support_dynamic_tags,
            tags=tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             containers: pulumi.Input[Sequence[pulumi.Input['WorkloadContainerArgs']]],
             gvc: pulumi.Input[str],
             options: pulumi.Input['WorkloadOptionsArgs'],
             type: pulumi.Input[str],
             description: Optional[pulumi.Input[str]] = None,
             firewall_spec: Optional[pulumi.Input['WorkloadFirewallSpecArgs']] = None,
             identity_link: Optional[pulumi.Input[str]] = None,
             job: Optional[pulumi.Input['WorkloadJobArgs']] = None,
             local_options: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadLocalOptionArgs']]]] = None,
             name: Optional[pulumi.Input[str]] = None,
             rollout_options: Optional[pulumi.Input['WorkloadRolloutOptionsArgs']] = None,
             security_options: Optional[pulumi.Input['WorkloadSecurityOptionsArgs']] = None,
             sidecar: Optional[pulumi.Input['WorkloadSidecarArgs']] = None,
             support_dynamic_tags: Optional[pulumi.Input[bool]] = None,
             tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'firewallSpec' in kwargs:
            firewall_spec = kwargs['firewallSpec']
        if 'identityLink' in kwargs:
            identity_link = kwargs['identityLink']
        if 'localOptions' in kwargs:
            local_options = kwargs['localOptions']
        if 'rolloutOptions' in kwargs:
            rollout_options = kwargs['rolloutOptions']
        if 'securityOptions' in kwargs:
            security_options = kwargs['securityOptions']
        if 'supportDynamicTags' in kwargs:
            support_dynamic_tags = kwargs['supportDynamicTags']

        _setter("containers", containers)
        _setter("gvc", gvc)
        _setter("options", options)
        _setter("type", type)
        if description is not None:
            _setter("description", description)
        if firewall_spec is not None:
            _setter("firewall_spec", firewall_spec)
        if identity_link is not None:
            _setter("identity_link", identity_link)
        if job is not None:
            _setter("job", job)
        if local_options is not None:
            _setter("local_options", local_options)
        if name is not None:
            _setter("name", name)
        if rollout_options is not None:
            _setter("rollout_options", rollout_options)
        if security_options is not None:
            _setter("security_options", security_options)
        if sidecar is not None:
            _setter("sidecar", sidecar)
        if support_dynamic_tags is not None:
            _setter("support_dynamic_tags", support_dynamic_tags)
        if tags is not None:
            _setter("tags", tags)

    @property
    @pulumi.getter
    def containers(self) -> pulumi.Input[Sequence[pulumi.Input['WorkloadContainerArgs']]]:
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: pulumi.Input[Sequence[pulumi.Input['WorkloadContainerArgs']]]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter
    def gvc(self) -> pulumi.Input[str]:
        return pulumi.get(self, "gvc")

    @gvc.setter
    def gvc(self, value: pulumi.Input[str]):
        pulumi.set(self, "gvc", value)

    @property
    @pulumi.getter
    def options(self) -> pulumi.Input['WorkloadOptionsArgs']:
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: pulumi.Input['WorkloadOptionsArgs']):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="firewallSpec")
    def firewall_spec(self) -> Optional[pulumi.Input['WorkloadFirewallSpecArgs']]:
        return pulumi.get(self, "firewall_spec")

    @firewall_spec.setter
    def firewall_spec(self, value: Optional[pulumi.Input['WorkloadFirewallSpecArgs']]):
        pulumi.set(self, "firewall_spec", value)

    @property
    @pulumi.getter(name="identityLink")
    def identity_link(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "identity_link")

    @identity_link.setter
    def identity_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_link", value)

    @property
    @pulumi.getter
    def job(self) -> Optional[pulumi.Input['WorkloadJobArgs']]:
        return pulumi.get(self, "job")

    @job.setter
    def job(self, value: Optional[pulumi.Input['WorkloadJobArgs']]):
        pulumi.set(self, "job", value)

    @property
    @pulumi.getter(name="localOptions")
    def local_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadLocalOptionArgs']]]]:
        return pulumi.get(self, "local_options")

    @local_options.setter
    def local_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadLocalOptionArgs']]]]):
        pulumi.set(self, "local_options", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="rolloutOptions")
    def rollout_options(self) -> Optional[pulumi.Input['WorkloadRolloutOptionsArgs']]:
        return pulumi.get(self, "rollout_options")

    @rollout_options.setter
    def rollout_options(self, value: Optional[pulumi.Input['WorkloadRolloutOptionsArgs']]):
        pulumi.set(self, "rollout_options", value)

    @property
    @pulumi.getter(name="securityOptions")
    def security_options(self) -> Optional[pulumi.Input['WorkloadSecurityOptionsArgs']]:
        return pulumi.get(self, "security_options")

    @security_options.setter
    def security_options(self, value: Optional[pulumi.Input['WorkloadSecurityOptionsArgs']]):
        pulumi.set(self, "security_options", value)

    @property
    @pulumi.getter
    def sidecar(self) -> Optional[pulumi.Input['WorkloadSidecarArgs']]:
        return pulumi.get(self, "sidecar")

    @sidecar.setter
    def sidecar(self, value: Optional[pulumi.Input['WorkloadSidecarArgs']]):
        pulumi.set(self, "sidecar", value)

    @property
    @pulumi.getter(name="supportDynamicTags")
    def support_dynamic_tags(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "support_dynamic_tags")

    @support_dynamic_tags.setter
    def support_dynamic_tags(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "support_dynamic_tags", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _WorkloadState:
    def __init__(__self__, *,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadContainerArgs']]]] = None,
                 cpln_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 firewall_spec: Optional[pulumi.Input['WorkloadFirewallSpecArgs']] = None,
                 gvc: Optional[pulumi.Input[str]] = None,
                 identity_link: Optional[pulumi.Input[str]] = None,
                 job: Optional[pulumi.Input['WorkloadJobArgs']] = None,
                 local_options: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadLocalOptionArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input['WorkloadOptionsArgs']] = None,
                 rollout_options: Optional[pulumi.Input['WorkloadRolloutOptionsArgs']] = None,
                 security_options: Optional[pulumi.Input['WorkloadSecurityOptionsArgs']] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 sidecar: Optional[pulumi.Input['WorkloadSidecarArgs']] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadStatusArgs']]]] = None,
                 support_dynamic_tags: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Workload resources.
        """
        _WorkloadState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            containers=containers,
            cpln_id=cpln_id,
            description=description,
            firewall_spec=firewall_spec,
            gvc=gvc,
            identity_link=identity_link,
            job=job,
            local_options=local_options,
            name=name,
            options=options,
            rollout_options=rollout_options,
            security_options=security_options,
            self_link=self_link,
            sidecar=sidecar,
            statuses=statuses,
            support_dynamic_tags=support_dynamic_tags,
            tags=tags,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             containers: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadContainerArgs']]]] = None,
             cpln_id: Optional[pulumi.Input[str]] = None,
             description: Optional[pulumi.Input[str]] = None,
             firewall_spec: Optional[pulumi.Input['WorkloadFirewallSpecArgs']] = None,
             gvc: Optional[pulumi.Input[str]] = None,
             identity_link: Optional[pulumi.Input[str]] = None,
             job: Optional[pulumi.Input['WorkloadJobArgs']] = None,
             local_options: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadLocalOptionArgs']]]] = None,
             name: Optional[pulumi.Input[str]] = None,
             options: Optional[pulumi.Input['WorkloadOptionsArgs']] = None,
             rollout_options: Optional[pulumi.Input['WorkloadRolloutOptionsArgs']] = None,
             security_options: Optional[pulumi.Input['WorkloadSecurityOptionsArgs']] = None,
             self_link: Optional[pulumi.Input[str]] = None,
             sidecar: Optional[pulumi.Input['WorkloadSidecarArgs']] = None,
             statuses: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadStatusArgs']]]] = None,
             support_dynamic_tags: Optional[pulumi.Input[bool]] = None,
             tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
             type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'cplnId' in kwargs:
            cpln_id = kwargs['cplnId']
        if 'firewallSpec' in kwargs:
            firewall_spec = kwargs['firewallSpec']
        if 'identityLink' in kwargs:
            identity_link = kwargs['identityLink']
        if 'localOptions' in kwargs:
            local_options = kwargs['localOptions']
        if 'rolloutOptions' in kwargs:
            rollout_options = kwargs['rolloutOptions']
        if 'securityOptions' in kwargs:
            security_options = kwargs['securityOptions']
        if 'selfLink' in kwargs:
            self_link = kwargs['selfLink']
        if 'supportDynamicTags' in kwargs:
            support_dynamic_tags = kwargs['supportDynamicTags']

        if containers is not None:
            _setter("containers", containers)
        if cpln_id is not None:
            _setter("cpln_id", cpln_id)
        if description is not None:
            _setter("description", description)
        if firewall_spec is not None:
            _setter("firewall_spec", firewall_spec)
        if gvc is not None:
            _setter("gvc", gvc)
        if identity_link is not None:
            _setter("identity_link", identity_link)
        if job is not None:
            _setter("job", job)
        if local_options is not None:
            _setter("local_options", local_options)
        if name is not None:
            _setter("name", name)
        if options is not None:
            _setter("options", options)
        if rollout_options is not None:
            _setter("rollout_options", rollout_options)
        if security_options is not None:
            _setter("security_options", security_options)
        if self_link is not None:
            _setter("self_link", self_link)
        if sidecar is not None:
            _setter("sidecar", sidecar)
        if statuses is not None:
            _setter("statuses", statuses)
        if support_dynamic_tags is not None:
            _setter("support_dynamic_tags", support_dynamic_tags)
        if tags is not None:
            _setter("tags", tags)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadContainerArgs']]]]:
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadContainerArgs']]]]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cpln_id")

    @cpln_id.setter
    def cpln_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpln_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="firewallSpec")
    def firewall_spec(self) -> Optional[pulumi.Input['WorkloadFirewallSpecArgs']]:
        return pulumi.get(self, "firewall_spec")

    @firewall_spec.setter
    def firewall_spec(self, value: Optional[pulumi.Input['WorkloadFirewallSpecArgs']]):
        pulumi.set(self, "firewall_spec", value)

    @property
    @pulumi.getter
    def gvc(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "gvc")

    @gvc.setter
    def gvc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gvc", value)

    @property
    @pulumi.getter(name="identityLink")
    def identity_link(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "identity_link")

    @identity_link.setter
    def identity_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_link", value)

    @property
    @pulumi.getter
    def job(self) -> Optional[pulumi.Input['WorkloadJobArgs']]:
        return pulumi.get(self, "job")

    @job.setter
    def job(self, value: Optional[pulumi.Input['WorkloadJobArgs']]):
        pulumi.set(self, "job", value)

    @property
    @pulumi.getter(name="localOptions")
    def local_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadLocalOptionArgs']]]]:
        return pulumi.get(self, "local_options")

    @local_options.setter
    def local_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadLocalOptionArgs']]]]):
        pulumi.set(self, "local_options", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['WorkloadOptionsArgs']]:
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['WorkloadOptionsArgs']]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="rolloutOptions")
    def rollout_options(self) -> Optional[pulumi.Input['WorkloadRolloutOptionsArgs']]:
        return pulumi.get(self, "rollout_options")

    @rollout_options.setter
    def rollout_options(self, value: Optional[pulumi.Input['WorkloadRolloutOptionsArgs']]):
        pulumi.set(self, "rollout_options", value)

    @property
    @pulumi.getter(name="securityOptions")
    def security_options(self) -> Optional[pulumi.Input['WorkloadSecurityOptionsArgs']]:
        return pulumi.get(self, "security_options")

    @security_options.setter
    def security_options(self, value: Optional[pulumi.Input['WorkloadSecurityOptionsArgs']]):
        pulumi.set(self, "security_options", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def sidecar(self) -> Optional[pulumi.Input['WorkloadSidecarArgs']]:
        return pulumi.get(self, "sidecar")

    @sidecar.setter
    def sidecar(self, value: Optional[pulumi.Input['WorkloadSidecarArgs']]):
        pulumi.set(self, "sidecar", value)

    @property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadStatusArgs']]]]:
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @property
    @pulumi.getter(name="supportDynamicTags")
    def support_dynamic_tags(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "support_dynamic_tags")

    @support_dynamic_tags.setter
    def support_dynamic_tags(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "support_dynamic_tags", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class Workload(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkloadContainerArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 firewall_spec: Optional[pulumi.Input[pulumi.InputType['WorkloadFirewallSpecArgs']]] = None,
                 gvc: Optional[pulumi.Input[str]] = None,
                 identity_link: Optional[pulumi.Input[str]] = None,
                 job: Optional[pulumi.Input[pulumi.InputType['WorkloadJobArgs']]] = None,
                 local_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkloadLocalOptionArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[pulumi.InputType['WorkloadOptionsArgs']]] = None,
                 rollout_options: Optional[pulumi.Input[pulumi.InputType['WorkloadRolloutOptionsArgs']]] = None,
                 security_options: Optional[pulumi.Input[pulumi.InputType['WorkloadSecurityOptionsArgs']]] = None,
                 sidecar: Optional[pulumi.Input[pulumi.InputType['WorkloadSidecarArgs']]] = None,
                 support_dynamic_tags: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a Workload resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkloadArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Workload resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param WorkloadArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkloadArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            WorkloadArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkloadContainerArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 firewall_spec: Optional[pulumi.Input[pulumi.InputType['WorkloadFirewallSpecArgs']]] = None,
                 gvc: Optional[pulumi.Input[str]] = None,
                 identity_link: Optional[pulumi.Input[str]] = None,
                 job: Optional[pulumi.Input[pulumi.InputType['WorkloadJobArgs']]] = None,
                 local_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkloadLocalOptionArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[pulumi.InputType['WorkloadOptionsArgs']]] = None,
                 rollout_options: Optional[pulumi.Input[pulumi.InputType['WorkloadRolloutOptionsArgs']]] = None,
                 security_options: Optional[pulumi.Input[pulumi.InputType['WorkloadSecurityOptionsArgs']]] = None,
                 sidecar: Optional[pulumi.Input[pulumi.InputType['WorkloadSidecarArgs']]] = None,
                 support_dynamic_tags: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkloadArgs.__new__(WorkloadArgs)

            if containers is None and not opts.urn:
                raise TypeError("Missing required property 'containers'")
            __props__.__dict__["containers"] = containers
            __props__.__dict__["description"] = description
            if firewall_spec is not None and not isinstance(firewall_spec, WorkloadFirewallSpecArgs):
                firewall_spec = firewall_spec or {}
                def _setter(key, value):
                    firewall_spec[key] = value
                WorkloadFirewallSpecArgs._configure(_setter, **firewall_spec)
            __props__.__dict__["firewall_spec"] = firewall_spec
            if gvc is None and not opts.urn:
                raise TypeError("Missing required property 'gvc'")
            __props__.__dict__["gvc"] = gvc
            __props__.__dict__["identity_link"] = identity_link
            if job is not None and not isinstance(job, WorkloadJobArgs):
                job = job or {}
                def _setter(key, value):
                    job[key] = value
                WorkloadJobArgs._configure(_setter, **job)
            __props__.__dict__["job"] = job
            __props__.__dict__["local_options"] = local_options
            __props__.__dict__["name"] = name
            if options is not None and not isinstance(options, WorkloadOptionsArgs):
                options = options or {}
                def _setter(key, value):
                    options[key] = value
                WorkloadOptionsArgs._configure(_setter, **options)
            if options is None and not opts.urn:
                raise TypeError("Missing required property 'options'")
            __props__.__dict__["options"] = options
            if rollout_options is not None and not isinstance(rollout_options, WorkloadRolloutOptionsArgs):
                rollout_options = rollout_options or {}
                def _setter(key, value):
                    rollout_options[key] = value
                WorkloadRolloutOptionsArgs._configure(_setter, **rollout_options)
            __props__.__dict__["rollout_options"] = rollout_options
            if security_options is not None and not isinstance(security_options, WorkloadSecurityOptionsArgs):
                security_options = security_options or {}
                def _setter(key, value):
                    security_options[key] = value
                WorkloadSecurityOptionsArgs._configure(_setter, **security_options)
            __props__.__dict__["security_options"] = security_options
            if sidecar is not None and not isinstance(sidecar, WorkloadSidecarArgs):
                sidecar = sidecar or {}
                def _setter(key, value):
                    sidecar[key] = value
                WorkloadSidecarArgs._configure(_setter, **sidecar)
            __props__.__dict__["sidecar"] = sidecar
            __props__.__dict__["support_dynamic_tags"] = support_dynamic_tags
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["cpln_id"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["statuses"] = None
        super(Workload, __self__).__init__(
            'cpln:index/workload:Workload',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            containers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkloadContainerArgs']]]]] = None,
            cpln_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            firewall_spec: Optional[pulumi.Input[pulumi.InputType['WorkloadFirewallSpecArgs']]] = None,
            gvc: Optional[pulumi.Input[str]] = None,
            identity_link: Optional[pulumi.Input[str]] = None,
            job: Optional[pulumi.Input[pulumi.InputType['WorkloadJobArgs']]] = None,
            local_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkloadLocalOptionArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            options: Optional[pulumi.Input[pulumi.InputType['WorkloadOptionsArgs']]] = None,
            rollout_options: Optional[pulumi.Input[pulumi.InputType['WorkloadRolloutOptionsArgs']]] = None,
            security_options: Optional[pulumi.Input[pulumi.InputType['WorkloadSecurityOptionsArgs']]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            sidecar: Optional[pulumi.Input[pulumi.InputType['WorkloadSidecarArgs']]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkloadStatusArgs']]]]] = None,
            support_dynamic_tags: Optional[pulumi.Input[bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'Workload':
        """
        Get an existing Workload resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkloadState.__new__(_WorkloadState)

        __props__.__dict__["containers"] = containers
        __props__.__dict__["cpln_id"] = cpln_id
        __props__.__dict__["description"] = description
        __props__.__dict__["firewall_spec"] = firewall_spec
        __props__.__dict__["gvc"] = gvc
        __props__.__dict__["identity_link"] = identity_link
        __props__.__dict__["job"] = job
        __props__.__dict__["local_options"] = local_options
        __props__.__dict__["name"] = name
        __props__.__dict__["options"] = options
        __props__.__dict__["rollout_options"] = rollout_options
        __props__.__dict__["security_options"] = security_options
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["sidecar"] = sidecar
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["support_dynamic_tags"] = support_dynamic_tags
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        return Workload(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def containers(self) -> pulumi.Output[Sequence['outputs.WorkloadContainer']]:
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "cpln_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="firewallSpec")
    def firewall_spec(self) -> pulumi.Output[Optional['outputs.WorkloadFirewallSpec']]:
        return pulumi.get(self, "firewall_spec")

    @property
    @pulumi.getter
    def gvc(self) -> pulumi.Output[str]:
        return pulumi.get(self, "gvc")

    @property
    @pulumi.getter(name="identityLink")
    def identity_link(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "identity_link")

    @property
    @pulumi.getter
    def job(self) -> pulumi.Output[Optional['outputs.WorkloadJob']]:
        return pulumi.get(self, "job")

    @property
    @pulumi.getter(name="localOptions")
    def local_options(self) -> pulumi.Output[Optional[Sequence['outputs.WorkloadLocalOption']]]:
        return pulumi.get(self, "local_options")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> pulumi.Output['outputs.WorkloadOptions']:
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="rolloutOptions")
    def rollout_options(self) -> pulumi.Output[Optional['outputs.WorkloadRolloutOptions']]:
        return pulumi.get(self, "rollout_options")

    @property
    @pulumi.getter(name="securityOptions")
    def security_options(self) -> pulumi.Output[Optional['outputs.WorkloadSecurityOptions']]:
        return pulumi.get(self, "security_options")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def sidecar(self) -> pulumi.Output[Optional['outputs.WorkloadSidecar']]:
        return pulumi.get(self, "sidecar")

    @property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.WorkloadStatus']]:
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter(name="supportDynamicTags")
    def support_dynamic_tags(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "support_dynamic_tags")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        return pulumi.get(self, "type")

