# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetLocationsResult',
    'AwaitableGetLocationsResult',
    'get_locations',
    'get_locations_output',
]

@pulumi.output_type
class GetLocationsResult:
    """
    A collection of values returned by getLocations.
    """
    def __init__(__self__, id=None, locations=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if locations and not isinstance(locations, list):
            raise TypeError("Expected argument 'locations' to be a list")
        pulumi.set(__self__, "locations", locations)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def locations(self) -> Sequence['outputs.GetLocationsLocationResult']:
        return pulumi.get(self, "locations")


class AwaitableGetLocationsResult(GetLocationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLocationsResult(
            id=self.id,
            locations=self.locations)


def get_locations(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLocationsResult:
    """
    Use this data source to access information about all [Locations](https://docs.controlplane.com/reference/location) within Control Plane.

    ## Outputs

    The following attributes are exported:

    - **locations** (Block List, Max: 1) (see below).

    <a id="nestedblock--locations"></a>

    ### `locations`

    - **cpln_id** (String) The ID, in GUID format, of the location.
    - **name** (String) Name of the location.
    - **description** (String) Description of the location.
    - **tags** (Map of String) Key-value map of resource tags.
    - **cloud_provider** (String) Cloud Provider of the location.
    - **region** (String) Region of the location.
    - **enabled** (Boolean) Indication if location is enabled.
    - **geo** (Block List, Max: 1) (see below)
    - **ip_ranges** (List of String) A list of IP ranges of the location.
    - **self_link** (String) Full link to this resource. Can be referenced by other resources.

    <a id="nestedblock--geo"></a>

    ### `geo`

    Location geographical details

    - **lat** (Number) Latitude.
    - **lon** (Number) Longitude.
    - **country** (String) Country.
    - **state** (String) State.
    - **city** (String) City.
    - **continent** (String) Continent.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cpln as cpln

    locations_locations = cpln.get_locations()
    pulumi.export("locations", locations_locations.locations)
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cpln:index/getLocations:getLocations', __args__, opts=opts, typ=GetLocationsResult).value

    return AwaitableGetLocationsResult(
        id=pulumi.get(__ret__, 'id'),
        locations=pulumi.get(__ret__, 'locations'))


@_utilities.lift_output_func(get_locations)
def get_locations_output(opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLocationsResult]:
    """
    Use this data source to access information about all [Locations](https://docs.controlplane.com/reference/location) within Control Plane.

    ## Outputs

    The following attributes are exported:

    - **locations** (Block List, Max: 1) (see below).

    <a id="nestedblock--locations"></a>

    ### `locations`

    - **cpln_id** (String) The ID, in GUID format, of the location.
    - **name** (String) Name of the location.
    - **description** (String) Description of the location.
    - **tags** (Map of String) Key-value map of resource tags.
    - **cloud_provider** (String) Cloud Provider of the location.
    - **region** (String) Region of the location.
    - **enabled** (Boolean) Indication if location is enabled.
    - **geo** (Block List, Max: 1) (see below)
    - **ip_ranges** (List of String) A list of IP ranges of the location.
    - **self_link** (String) Full link to this resource. Can be referenced by other resources.

    <a id="nestedblock--geo"></a>

    ### `geo`

    Location geographical details

    - **lat** (Number) Latitude.
    - **lon** (Number) Longitude.
    - **country** (String) Country.
    - **state** (String) State.
    - **city** (String) City.
    - **continent** (String) Continent.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cpln as cpln

    locations_locations = cpln.get_locations()
    pulumi.export("locations", locations_locations.locations)
    ```
    """
    ...
