# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudAccountArgs', 'CloudAccount']

@pulumi.input_type
class CloudAccountArgs:
    def __init__(__self__, *,
                 aws: Optional[pulumi.Input['CloudAccountAwsArgs']] = None,
                 azure: Optional[pulumi.Input['CloudAccountAzureArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 gcp: Optional[pulumi.Input['CloudAccountGcpArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ngs: Optional[pulumi.Input['CloudAccountNgsArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a CloudAccount resource.
        """
        CloudAccountArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            aws=aws,
            azure=azure,
            description=description,
            gcp=gcp,
            name=name,
            ngs=ngs,
            tags=tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             aws: Optional[pulumi.Input['CloudAccountAwsArgs']] = None,
             azure: Optional[pulumi.Input['CloudAccountAzureArgs']] = None,
             description: Optional[pulumi.Input[str]] = None,
             gcp: Optional[pulumi.Input['CloudAccountGcpArgs']] = None,
             name: Optional[pulumi.Input[str]] = None,
             ngs: Optional[pulumi.Input['CloudAccountNgsArgs']] = None,
             tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if aws is not None:
            _setter("aws", aws)
        if azure is not None:
            _setter("azure", azure)
        if description is not None:
            _setter("description", description)
        if gcp is not None:
            _setter("gcp", gcp)
        if name is not None:
            _setter("name", name)
        if ngs is not None:
            _setter("ngs", ngs)
        if tags is not None:
            _setter("tags", tags)

    @property
    @pulumi.getter
    def aws(self) -> Optional[pulumi.Input['CloudAccountAwsArgs']]:
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: Optional[pulumi.Input['CloudAccountAwsArgs']]):
        pulumi.set(self, "aws", value)

    @property
    @pulumi.getter
    def azure(self) -> Optional[pulumi.Input['CloudAccountAzureArgs']]:
        return pulumi.get(self, "azure")

    @azure.setter
    def azure(self, value: Optional[pulumi.Input['CloudAccountAzureArgs']]):
        pulumi.set(self, "azure", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def gcp(self) -> Optional[pulumi.Input['CloudAccountGcpArgs']]:
        return pulumi.get(self, "gcp")

    @gcp.setter
    def gcp(self, value: Optional[pulumi.Input['CloudAccountGcpArgs']]):
        pulumi.set(self, "gcp", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ngs(self) -> Optional[pulumi.Input['CloudAccountNgsArgs']]:
        return pulumi.get(self, "ngs")

    @ngs.setter
    def ngs(self, value: Optional[pulumi.Input['CloudAccountNgsArgs']]):
        pulumi.set(self, "ngs", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _CloudAccountState:
    def __init__(__self__, *,
                 aws: Optional[pulumi.Input['CloudAccountAwsArgs']] = None,
                 azure: Optional[pulumi.Input['CloudAccountAzureArgs']] = None,
                 cpln_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 gcp: Optional[pulumi.Input['CloudAccountGcpArgs']] = None,
                 gcp_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gcp_service_account_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ngs: Optional[pulumi.Input['CloudAccountNgsArgs']] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering CloudAccount resources.
        """
        _CloudAccountState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            aws=aws,
            azure=azure,
            cpln_id=cpln_id,
            description=description,
            gcp=gcp,
            gcp_roles=gcp_roles,
            gcp_service_account_name=gcp_service_account_name,
            name=name,
            ngs=ngs,
            self_link=self_link,
            tags=tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             aws: Optional[pulumi.Input['CloudAccountAwsArgs']] = None,
             azure: Optional[pulumi.Input['CloudAccountAzureArgs']] = None,
             cpln_id: Optional[pulumi.Input[str]] = None,
             description: Optional[pulumi.Input[str]] = None,
             gcp: Optional[pulumi.Input['CloudAccountGcpArgs']] = None,
             gcp_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             gcp_service_account_name: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             ngs: Optional[pulumi.Input['CloudAccountNgsArgs']] = None,
             self_link: Optional[pulumi.Input[str]] = None,
             tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'cplnId' in kwargs:
            cpln_id = kwargs['cplnId']
        if 'gcpRoles' in kwargs:
            gcp_roles = kwargs['gcpRoles']
        if 'gcpServiceAccountName' in kwargs:
            gcp_service_account_name = kwargs['gcpServiceAccountName']
        if 'selfLink' in kwargs:
            self_link = kwargs['selfLink']

        if aws is not None:
            _setter("aws", aws)
        if azure is not None:
            _setter("azure", azure)
        if cpln_id is not None:
            _setter("cpln_id", cpln_id)
        if description is not None:
            _setter("description", description)
        if gcp is not None:
            _setter("gcp", gcp)
        if gcp_roles is not None:
            _setter("gcp_roles", gcp_roles)
        if gcp_service_account_name is not None:
            _setter("gcp_service_account_name", gcp_service_account_name)
        if name is not None:
            _setter("name", name)
        if ngs is not None:
            _setter("ngs", ngs)
        if self_link is not None:
            _setter("self_link", self_link)
        if tags is not None:
            _setter("tags", tags)

    @property
    @pulumi.getter
    def aws(self) -> Optional[pulumi.Input['CloudAccountAwsArgs']]:
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: Optional[pulumi.Input['CloudAccountAwsArgs']]):
        pulumi.set(self, "aws", value)

    @property
    @pulumi.getter
    def azure(self) -> Optional[pulumi.Input['CloudAccountAzureArgs']]:
        return pulumi.get(self, "azure")

    @azure.setter
    def azure(self, value: Optional[pulumi.Input['CloudAccountAzureArgs']]):
        pulumi.set(self, "azure", value)

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cpln_id")

    @cpln_id.setter
    def cpln_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpln_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def gcp(self) -> Optional[pulumi.Input['CloudAccountGcpArgs']]:
        return pulumi.get(self, "gcp")

    @gcp.setter
    def gcp(self, value: Optional[pulumi.Input['CloudAccountGcpArgs']]):
        pulumi.set(self, "gcp", value)

    @property
    @pulumi.getter(name="gcpRoles")
    def gcp_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "gcp_roles")

    @gcp_roles.setter
    def gcp_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gcp_roles", value)

    @property
    @pulumi.getter(name="gcpServiceAccountName")
    def gcp_service_account_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "gcp_service_account_name")

    @gcp_service_account_name.setter
    def gcp_service_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gcp_service_account_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ngs(self) -> Optional[pulumi.Input['CloudAccountNgsArgs']]:
        return pulumi.get(self, "ngs")

    @ngs.setter
    def ngs(self, value: Optional[pulumi.Input['CloudAccountNgsArgs']]):
        pulumi.set(self, "ngs", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class CloudAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws: Optional[pulumi.Input[pulumi.InputType['CloudAccountAwsArgs']]] = None,
                 azure: Optional[pulumi.Input[pulumi.InputType['CloudAccountAzureArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 gcp: Optional[pulumi.Input[pulumi.InputType['CloudAccountGcpArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ngs: Optional[pulumi.Input[pulumi.InputType['CloudAccountNgsArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Create a CloudAccount resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CloudAccountArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a CloudAccount resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param CloudAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            CloudAccountArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws: Optional[pulumi.Input[pulumi.InputType['CloudAccountAwsArgs']]] = None,
                 azure: Optional[pulumi.Input[pulumi.InputType['CloudAccountAzureArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 gcp: Optional[pulumi.Input[pulumi.InputType['CloudAccountGcpArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ngs: Optional[pulumi.Input[pulumi.InputType['CloudAccountNgsArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudAccountArgs.__new__(CloudAccountArgs)

            if aws is not None and not isinstance(aws, CloudAccountAwsArgs):
                aws = aws or {}
                def _setter(key, value):
                    aws[key] = value
                CloudAccountAwsArgs._configure(_setter, **aws)
            __props__.__dict__["aws"] = aws
            if azure is not None and not isinstance(azure, CloudAccountAzureArgs):
                azure = azure or {}
                def _setter(key, value):
                    azure[key] = value
                CloudAccountAzureArgs._configure(_setter, **azure)
            __props__.__dict__["azure"] = azure
            __props__.__dict__["description"] = description
            if gcp is not None and not isinstance(gcp, CloudAccountGcpArgs):
                gcp = gcp or {}
                def _setter(key, value):
                    gcp[key] = value
                CloudAccountGcpArgs._configure(_setter, **gcp)
            __props__.__dict__["gcp"] = gcp
            __props__.__dict__["name"] = name
            if ngs is not None and not isinstance(ngs, CloudAccountNgsArgs):
                ngs = ngs or {}
                def _setter(key, value):
                    ngs[key] = value
                CloudAccountNgsArgs._configure(_setter, **ngs)
            __props__.__dict__["ngs"] = ngs
            __props__.__dict__["tags"] = tags
            __props__.__dict__["cpln_id"] = None
            __props__.__dict__["gcp_roles"] = None
            __props__.__dict__["gcp_service_account_name"] = None
            __props__.__dict__["self_link"] = None
        super(CloudAccount, __self__).__init__(
            'cpln:index/cloudAccount:CloudAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws: Optional[pulumi.Input[pulumi.InputType['CloudAccountAwsArgs']]] = None,
            azure: Optional[pulumi.Input[pulumi.InputType['CloudAccountAzureArgs']]] = None,
            cpln_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            gcp: Optional[pulumi.Input[pulumi.InputType['CloudAccountGcpArgs']]] = None,
            gcp_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            gcp_service_account_name: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            ngs: Optional[pulumi.Input[pulumi.InputType['CloudAccountNgsArgs']]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'CloudAccount':
        """
        Get an existing CloudAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudAccountState.__new__(_CloudAccountState)

        __props__.__dict__["aws"] = aws
        __props__.__dict__["azure"] = azure
        __props__.__dict__["cpln_id"] = cpln_id
        __props__.__dict__["description"] = description
        __props__.__dict__["gcp"] = gcp
        __props__.__dict__["gcp_roles"] = gcp_roles
        __props__.__dict__["gcp_service_account_name"] = gcp_service_account_name
        __props__.__dict__["name"] = name
        __props__.__dict__["ngs"] = ngs
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["tags"] = tags
        return CloudAccount(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def aws(self) -> pulumi.Output[Optional['outputs.CloudAccountAws']]:
        return pulumi.get(self, "aws")

    @property
    @pulumi.getter
    def azure(self) -> pulumi.Output[Optional['outputs.CloudAccountAzure']]:
        return pulumi.get(self, "azure")

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "cpln_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def gcp(self) -> pulumi.Output[Optional['outputs.CloudAccountGcp']]:
        return pulumi.get(self, "gcp")

    @property
    @pulumi.getter(name="gcpRoles")
    def gcp_roles(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "gcp_roles")

    @property
    @pulumi.getter(name="gcpServiceAccountName")
    def gcp_service_account_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "gcp_service_account_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ngs(self) -> pulumi.Output[Optional['outputs.CloudAccountNgs']]:
        return pulumi.get(self, "ngs")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "tags")

