# -*- coding: utf-8 -*-
# Generated by Django 1.11.11 on 2018-03-13 10:56
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import djangocms_attributes_field.fields
import djangocms_layouttools.models
import filer.fields.image


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('cms', '0018_pagenode'),
        migrations.swappable_dependency(settings.FILER_IMAGE_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Section',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='djangocms_layouttools_section', serialize=False, to='cms.CMSPlugin')),
                ('name', models.CharField(blank=True, default='', help_text='Descriptive name [not rendered on page]', max_length=25, null=True, verbose_name='Section Name')),
                ('min_height', models.CharField(default='0px', help_text='0 is default. Set it larger to expand height of section.', max_length=25, verbose_name='Minimum Section Height')),
                ('bg_external_image', models.URLField(blank=True, help_text='If provided, overrides the embedded image.', max_length=255, verbose_name='External URL Background Image')),
                ('bg_color', models.CharField(default='transparent', help_text='(e.g., #RRGGBB, rgba(120,120,120,0.3))', max_length=25, verbose_name='CSS Background Color')),
                ('bg_size', models.CharField(choices=[('100% auto', 'fit width: 100% auto'), ('auto 100%', 'fit height: auto 100%'), ('cover', 'fill: cover '), ('auto', 'default: auto')], default='cover', max_length=25, verbose_name='Background Size')),
                ('bg_position', models.CharField(blank=True, default='center', max_length=25, verbose_name='Background Position')),
                ('bg_repeat', models.CharField(blank=True, choices=[('no-repeat', 'no-repeat'), ('repeat', 'repeat'), ('repeat-x', 'repeat-x'), ('repeat-y', 'repeat-y')], default='no-repeat', max_length=25, verbose_name='Background Repeat')),
                ('bg_attachment', models.CharField(blank=True, choices=[('scroll', 'scroll'), ('fixed', 'fixed')], default='scroll', max_length=25, verbose_name='Background Attachment')),
                ('container', models.CharField(blank=True, choices=[('', 'No container (full-width)'), ('container', '.container (smaller content width based on device size)'), ('container-fluid', '.container-fluid (full-width with slight padding on sides)')], default='container', help_text='Adds a ".container" or ".container-fluid" element inside the section. Use it to have a full-page-width styled <section> with an inner container with a constrained width. All child plugins render inside the container.', max_length=25, verbose_name='Add nested .container or .container-fluid child element')),
                ('classes', djangocms_layouttools.models.Classes(blank=True, default='', help_text='Space separated classes that are added to the class. See <a href="http://getbootstrap.com/css/" target="_blank">Bootstrap 3 documentation</a>.', verbose_name='Classes')),
                ('attributes', djangocms_attributes_field.fields.AttributesField(blank=True, default=dict, verbose_name='Attributes')),
                ('bg_image', filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.FILER_IMAGE_MODEL, verbose_name='Background Image')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
    ]
