"use strict";
// Copyright (c) cdr4eelz
// Distributed under the terms of the Modified BSD License.
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const base_1 = require("@jupyter-widgets/base");
const version_1 = require("./version");
// Import the CSS
require("../css/widget.css");
const utils = __importStar(require("@jupyter-widgets/base"));
const coreutils_1 = require("@lumino/coreutils");
const webseriallink_1 = require("./webseriallink");
class SerialHubModel extends base_1.DOMWidgetModel {
    defaults() {
        return Object.assign(Object.assign({}, super.defaults()), { _model_name: SerialHubModel.model_name, _model_module: SerialHubModel.model_module, _model_module_version: SerialHubModel.model_module_version, _view_name: SerialHubModel.view_name, _view_module: SerialHubModel.view_module, _view_module_version: SerialHubModel.view_module_version, isSupported: false, status: 'Initializing...', value: 'Loading...' });
    }
    static get mytempid() {
        return SerialHubModel._mytempid;
    }
}
exports.SerialHubModel = SerialHubModel;
SerialHubModel._mytempid = utils.uuid();
SerialHubModel.serializers = Object.assign({}, base_1.DOMWidgetModel.serializers);
SerialHubModel.model_name = 'SerialHubModel';
SerialHubModel.model_module = version_1.MODULE_NAME;
SerialHubModel.model_module_version = version_1.MODULE_VERSION;
SerialHubModel.view_name = 'SerialHubView'; // Set to null if no view
SerialHubModel.view_module = version_1.MODULE_NAME; // Set to null if no view
SerialHubModel.view_module_version = version_1.MODULE_VERSION;
class SerialHubView extends base_1.DOMWidgetView {
    constructor() {
        super(...arguments);
        this._el_status = null;
        this._el_value = null;
    }
    render() {
        this.el.id = this.id || coreutils_1.UUID.uuid4();
        this.el.classList.add('xx-serialhub-widget');
        /* Create a couple sub-Elements for our custom widget */
        this._el_status = window.document.createElement("div");
        this._el_status.classList.add('xx-serialhub-status');
        this._el_value = window.document.createElement("pre");
        this._el_value.classList.add('xx-serialhub-value');
        /* Click events wrapped to capture "this" object */
        this._el_status.onclick = (ev) => this.click_status(ev);
        this._el_value.onclick = (ev) => this.click_value(ev);
        /* Maybe is more appropriate append() function availablie? */
        this.$el.append(this._el_status, this._el_value);
        this.changed_status();
        this.changed_value();
        this.model.on('change:status', this.changed_status, this);
        this.model.on('change:value', this.changed_value, this);
        this.model.on('msg:custom', this.msg_custom, this);
        this.model.set('isSupported', webseriallink_1.SerialHubPort.isSupported());
        this.model.set('status', (webseriallink_1.SerialHubPort.isSupported()) ? 'Supported' : 'Unsupported');
        this.touch();
        return this;
    }
    changed_status() {
        if (!this._el_status)
            return;
        this._el_status.textContent = this.model.get('status');
    }
    changed_value() {
        if (!this._el_value)
            return;
        this._el_value.textContent = this.model.get('value');
    }
    click_status(ev) {
        //console.log(this, arguments, this.model);
        let SHP = webseriallink_1.SerialHubPort.test((value) => {
            console.log(value);
            this.model.send({ 'type': "binary" }, {}, [value]);
        });
        console.log("DONE", SHP);
    }
    click_value(ev) {
        if (!this || !this.model)
            return;
        this.model.send({ 'type': "text", 'text': "DATA\n" }, {}, []);
        window.serPort.writeToStream("6");
    }
    msg_custom(mData, mBuffs) {
        console.log(this, mData, mBuffs);
        let msgType = mData['type'];
        if (msgType == 'text') {
            window.serPort.writeToStream(mData['text']);
        }
    }
}
exports.SerialHubView = SerialHubView;
//# sourceMappingURL=widget.js.map