# generated by datamodel-codegen:
#   filename:  structurizr.yaml
#   timestamp: 2025-05-20T13:19:11+00:00

from __future__ import annotations

from dataclasses import dataclass
from enum import Enum
from typing import Any, Dict, List, Optional


@dataclass
class Enterprise:
    """
    The enterprise associated with this model.
    """

    name: Optional[str] = None
    """
    The name of the enterprise.
    """


class Location(Enum):
    """
    The location of this person.
    """

    External = 'External'
    Internal = 'Internal'
    Unspecified = 'Unspecified'


class Location1(Enum):
    """
    The location of this software system.
    """

    External = 'External'
    Internal = 'Internal'
    Unspecified = 'Unspecified'


@dataclass
class HttpHealthCheck:
    """
    Describes a HTTP based health check.
    """

    name: Optional[str] = None
    """
    The name of the health check.
    """
    url: Optional[str] = None
    """
    The health check URL/endpoint.
    """
    interval: Optional[float] = None
    """
    The polling interval, in seconds.
    """
    timeout: Optional[float] = None
    """
    The timeout after which a health check is deemed as failed, in milliseconds.
    """
    headers: Optional[Dict[str, Any]] = None
    """
    A set of name-value pairs corresponding to HTTP headers that should be sent with the request.
    """


class InteractionStyle(Enum):
    """
    The interaction style (synchronous or asynchronous).
    """

    Synchronous = 'Synchronous'
    Asynchronous = 'Asynchronous'


@dataclass
class Perspective:
    """
    Represents an architectural perspective, that can be applied to elements and relationships.
    """

    name: Optional[str] = None
    """
    The name of this perspective (e.g. "Security").
    """
    description: Optional[str] = None
    """
    The description of this perspective.
    """
    value: Optional[str] = None
    """
    The value of this perspective (optional).
    """


class PaperSize(Enum):
    """
    The paper size that should be used to render this view.
    """

    A6_Portrait = 'A6_Portrait'
    A6_Landscape = 'A6_Landscape'
    A5_Portrait = 'A5_Portrait'
    A5_Landscape = 'A5_Landscape'
    A4_Portrait = 'A4_Portrait'
    A4_Landscape = 'A4_Landscape'
    A3_Portrait = 'A3_Portrait'
    A3_Landscape = 'A3_Landscape'
    A2_Portrait = 'A2_Portrait'
    A2_Landscape = 'A2_Landscape'
    A1_Portrait = 'A1_Portrait'
    A1_Landscape = 'A1_Landscape'
    A0_Portrait = 'A0_Portrait'
    A0_Landscape = 'A0_Landscape'
    Letter_Portrait = 'Letter_Portrait'
    Letter_Landscape = 'Letter_Landscape'
    Legal_Portrait = 'Legal_Portrait'
    Legal_Landscape = 'Legal_Landscape'
    Slide_4_3 = 'Slide_4_3'
    Slide_16_9 = 'Slide_16_9'
    Slide_16_10 = 'Slide_16_10'


class Mode(Enum):
    """
    Whether elements/relationships are being included or excluded based upon the set of tags.
    """

    Include = 'Include'
    Exclude = 'Exclude'


@dataclass
class FilteredView:
    """
    Represents a view on top of a view, which can be used to include or exclude specific elements.
    """

    key: Optional[str] = None
    """
    A unique identifier for this view.
    """
    order: Optional[float] = None
    """
    An integer representing the creation order of this view.
    """
    title: Optional[str] = None
    """
    The title of this view (optional).
    """
    description: Optional[str] = None
    """
    The description of this view.
    """
    properties: Optional[Dict[str, Any]] = None
    """
    A set of arbitrary name-value properties.
    """
    baseViewKey: Optional[str] = None
    """
    The key of the view on which this filtered view is based.
    """
    mode: Optional[Mode] = None
    """
    Whether elements/relationships are being included or excluded based upon the set of tags.
    """
    tags: Optional[List[str]] = None
    """
    The set of tags to include/exclude elements/relationships when rendering this filtered view.
    """


@dataclass
class ImageView:
    """
    A view that has been rendered elsewhere (e.g. PlantUML, Mermaid, Kroki, etc) as a image (e.g. PNG).
    """

    key: Optional[str] = None
    """
    A unique identifier for this view.
    """
    order: Optional[float] = None
    """
    An integer representing the creation order of this view.
    """
    title: Optional[str] = None
    """
    The title of this view (optional).
    """
    description: Optional[str] = None
    """
    The description of this view.
    """
    properties: Optional[Dict[str, Any]] = None
    """
    A set of arbitrary name-value properties.
    """
    elementId: Optional[str] = None
    """
    The ID of the element this view is associated with (optional).
    """
    content: Optional[str] = None
    """
    The content of this image view, which needs to be a URL or a data URI.
    """
    contentType: Optional[str] = None
    """
    The content type of this view (e.g. "image/png").
    """


@dataclass
class ElementView:
    """
    An instance of a model element (Person, Software System, Container or Component) in a View.
    """

    id: Optional[str] = None
    """
    The ID of the element.
    """
    x: Optional[float] = None
    """
    The horizontal position of the element when rendered.
    """
    y: Optional[float] = None
    """
    The vertical position of the element when rendered.
    """


class Routing(Enum):
    """
    The routing algorithm used when rendering this individual relationship.
    """

    Direct = 'Direct'
    Curved = 'Curved'
    Orthogonal = 'Orthogonal'


@dataclass
class Vertex:
    """
    The X, Y coordinate of a bend in a line.
    """

    x: Optional[float] = None
    """
    The horizontal position of the vertex when rendered.
    """
    y: Optional[float] = None
    """
    The vertical position of the vertex when rendered.
    """


@dataclass
class AnimationStep:
    """
    An animation step
    """

    order: Optional[float] = None
    """
    The order of this animation step.
    """
    elements: Optional[List[str]] = None
    """
    The set of element IDs that should be included in this animation step.
    """
    relationships: Optional[List[str]] = None
    """
    The set of relationship IDs that should be included in this animation step.
    """


@dataclass
class Dimensions:
    """
    Represents a width and height pair.
    """

    width: Optional[float] = None
    """
    The width (pixels).
    """
    height: Optional[float] = None
    """
    The height (pixels).
    """


class Implementation(Enum):
    """
    The automatic layout implementation.
    """

    Graphviz = 'Graphviz'
    Dagre = 'Dagre'


class RankDirection(Enum):
    """
    The algorithm rank direction.
    """

    TopBottom = 'TopBottom'
    BottomTop = 'BottomTop'
    LeftRight = 'LeftRight'
    RightLeft = 'RightLeft'


@dataclass
class AutomaticLayout:
    """
    Represents the auto-layout configuration for a given view.
    """

    implementation: Optional[Implementation] = None
    """
    The automatic layout implementation.
    """
    rankDirection: Optional[RankDirection] = None
    """
    The algorithm rank direction.
    """
    rankSeparation: Optional[float] = None
    """
    The separation between ranks (pixels).
    """
    nodeSeparation: Optional[float] = None
    """
    The separation between nodes in the same rank (pixels).
    """
    edgeSeparation: Optional[float] = None
    """
    The separation between edges (pixels).
    """
    vertices: Optional[bool] = None
    """
    Whether vertices should be created during automatic layout.
    """


class MetadataSymbols(Enum):
    """
    The type of symbols to use when rendering metadata.
    """

    SquareBrackets_ = 'SquareBrackets,'
    RoundBrackets_ = 'RoundBrackets,'
    CurlyBrackets_ = 'CurlyBrackets,'
    AngleBrackets_ = 'AngleBrackets,'
    DoubleAngleBrackets_ = 'DoubleAngleBrackets,'
    None_ = 'None'


@dataclass
class Font:
    """
    Represents a font, including a name and an optional URL for web fonts.
    """

    name: Optional[str] = None
    """
    The font name (e.g. "Times New Roman", "Open Sans", etc).
    """
    url: Optional[str] = None
    """
    For web fonts, the URL where the font can be found.
    """


@dataclass
class Branding:
    """
    A wrapper for the font and logo for diagram/documentation branding purposes.
    """

    logo: Optional[str] = None
    """
    A Base64 data URI representation of a PNG/JPG/GIF file.
    """
    font: Optional[Font] = None
    """
    Represents a font, including a name and an optional URL for web fonts.
    """


class Shape(Enum):
    """
    The shape used to render the element.
    """

    Box = 'Box'
    RoundedBox = 'RoundedBox'
    Component = 'Component'
    Circle = 'Circle'
    Ellipse = 'Ellipse'
    Hexagon = 'Hexagon'
    Diamond = 'Diamond'
    Folder = 'Folder'
    Cylinder = 'Cylinder'
    Pipe = 'Pipe'
    WebBrowser = 'WebBrowser'
    Window = 'Window'
    MobileDevicePortrait = 'MobileDevicePortrait'
    MobileDeviceLandscape = 'MobileDeviceLandscape'
    Person = 'Person'
    Robot = 'Robot'


class Border(Enum):
    """
    The type of border used to render the element.
    """

    Solid = 'Solid'
    Dashed = 'Dashed'
    Dotted = 'Dotted'


@dataclass
class ElementStyle:
    """
    A definition of an element style.
    """

    tag: Optional[str] = None
    """
    The tag to which this element style applies.
    """
    width: Optional[float] = None
    """
    The width of the element, in pixels.
    """
    height: Optional[float] = None
    """
    The height of the element, in pixels.
    """
    background: Optional[str] = None
    """
    The background colour of the element, as a HTML RGB hex string (e.g. '#ffffff').
    """
    stroke: Optional[str] = None
    """
    The stroke colour of the element, as a HTML RGB hex string (e.g. '#000000').
    """
    strokeWidth: Optional[float] = None
    """
    The width of the stroke, in pixels.
    """
    color: Optional[str] = None
    """
    The foreground (text) colour of the element, as a HTML RGB hex string (e.g. '#ffffff').
    """
    fontSize: Optional[float] = None
    """
    The standard font size used to render text, in pixels.
    """
    shape: Optional[Shape] = None
    """
    The shape used to render the element.
    """
    icon: Optional[str] = None
    """
    A Base64 data URI representation of a PNG/JPG/GIF file.
    """
    border: Optional[Border] = None
    """
    The type of border used to render the element.
    """
    opacity: Optional[float] = None
    """
    The opacity used when rendering the element; 0-100.
    """
    metadata: Optional[bool] = None
    """
    Whether the element metadata should be shown or not.
    """
    description: Optional[bool] = None
    """
    Whether the element description should be shown or not.
    """


class Routing1(Enum):
    """
    The routing algorithm used when rendering lines.
    """

    Direct = 'Direct'
    Curved = 'Curved'
    Orthogonal = 'Orthogonal'


@dataclass
class RelationshipStyle:
    """
    A definition of a relationship style.
    """

    tag: Optional[str] = None
    """
    The tag to which this relationship style applies.
    """
    thickness: Optional[float] = None
    """
    The thickness of the line, in pixels.
    """
    color: Optional[str] = None
    """
    The colour of the line, as a HTML RGB hex string (e.g. '#ffffff').
    """
    fontSize: Optional[float] = None
    """
    The standard font size used to render the relationship annotation, in pixels.
    """
    width: Optional[float] = None
    """
    The width of the relationship annotation, in pixels.
    """
    dashed: Optional[bool] = None
    """
    A flag to indicate whether the line is rendered as dashed or not.
    """
    routing: Optional[Routing1] = None
    """
    The routing algorithm used when rendering lines.
    """
    position: Optional[float] = None
    """
    The position of the annotation along the line; 0 (start) to 100 (end).
    """
    opacity: Optional[float] = None
    """
    The opacity used when rendering the line; 0-100.
    """


class Format(Enum):
    """
    The content format type.
    """

    Markdown = 'Markdown'
    AsciiDoc = 'AsciiDoc'


@dataclass
class DocumentationSection:
    """
    A documentation section.
    """

    content: Optional[str] = None
    """
    The Markdown or AsciiDoc content of the section.
    """
    format: Optional[Format] = None
    """
    The content format type.
    """
    order: Optional[float] = None
    """
    The order (index) of the section in the document.
    """


class Status(Enum):
    """
    The status of the decision.
    """

    Proposed = 'Proposed'
    Accepted = 'Accepted'
    Superseded = 'Superseded'
    Deprecated = 'Deprecated'
    Rejected = 'Rejected'


@dataclass
class Decision:
    """
    A decision record (e.g. architecture decision record).
    """

    id: Optional[str] = None
    """
    The ID of the decision.
    """
    date: Optional[str] = None
    """
    The date that the decision was made (ISO 8601 format).
    """
    status: Optional[Status] = None
    """
    The status of the decision.
    """
    title: Optional[str] = None
    """
    The title of the decision.
    """
    content: Optional[str] = None
    """
    The Markdown or AsciiDoc content of the section.
    """
    format: Optional[Format] = None
    """
    The content format type.
    """
    elementId: Optional[str] = None
    """
    The ID of the element (in the model) that this decision applies to (optional).
    """


@dataclass
class Image:
    """
    Represents a base64 encoded image (png/jpg/gif).
    """

    name: Optional[str] = None
    """
    The name of the image.
    """
    content: Optional[str] = None
    """
    The (base64 encoded) content of the image.
    """
    type: Optional[str] = None
    """
    The image MIME type (e.g. "image/png").
    """


@dataclass
class Terminology:
    """
    Provides a way for the terminology on diagrams, etc to be modified (e.g. language translations).
    """

    enterprise: Optional[str] = None
    """
    The terminology used when rendering the enterprise boundary.
    """
    person: Optional[str] = None
    """
    The terminology used when rendering people.
    """
    softwareSystem: Optional[str] = None
    """
    The terminology used when rendering software systems.
    """
    container: Optional[str] = None
    """
    The terminology used when rendering containers.
    """
    component: Optional[str] = None
    """
    The terminology used when rendering components.
    """
    code: Optional[str] = None
    """
    The terminology used when rendering code elements.
    """
    deploymentNode: Optional[str] = None
    """
    The terminology used when rendering deployment nodes.
    """
    relationship: Optional[str] = None
    """
    The terminology used when rendering relationships.
    """


class Visibility(Enum):
    """
    The visibility of the workspace
    """

    Public = 'Public'
    Private = 'Private'


class Scope(Enum):
    """
    The scope of the workspace (can be unset for unscoped).
    """

    Landscape = 'Landscape'
    SoftwareSystem = 'SoftwareSystem'


class Role(Enum):
    """
    The user's role.
    """

    ReadWrite = 'ReadWrite'
    ReadOnly = 'ReadOnly'


@dataclass
class User:
    """
    Represents a user who should have access to a workspace.
    """

    username: Optional[str] = None
    """
    The username of the user (e.g. e-mail address).
    """
    role: Optional[Role] = None
    """
    The user's role.
    """


@dataclass
class APIResponse:
    """
    An API response.
    """

    success: Optional[bool] = None
    """
    true if the API call was successful, false otherwise.
    """
    message: Optional[str] = None
    """
    A human readable response message.
    """
    revision: Optional[int] = None
    """
    The internal revision number.
    """


@dataclass
class Relationship:
    """
    A relationship between two elements.
    """

    id: Optional[str] = None
    """
    The ID of this relationship in the model.
    """
    description: Optional[str] = None
    """
    A short description of this relationship.
    """
    tags: Optional[str] = None
    """
    A comma separated list of tags associated with this relationship.
    """
    url: Optional[str] = None
    """
    The URL where more information about this relationship can be found.
    """
    properties: Optional[Dict[str, Any]] = None
    """
    A set of arbitrary name-value properties.
    """
    perspectives: Optional[List[Perspective]] = None
    """
    The set of perspectives associated with this relationship.
    """
    sourceId: Optional[str] = None
    """
    The ID of the source element.
    """
    destinationId: Optional[str] = None
    """
    The ID of the destination element.
    """
    technology: Optional[str] = None
    """
    The technology associated with this relationship (e.g. HTTPS, JDBC, etc).
    """
    interactionStyle: Optional[InteractionStyle] = None
    """
    The interaction style (synchronous or asynchronous).
    """
    linkedRelationshipId: Optional[str] = None
    """
    The ID of the container-container relationship upon which this container instance-container instance relationship is based.
    """


@dataclass
class RelationshipView:
    """
    An instance of a model relationship in a View.
    """

    id: Optional[str] = None
    """
    The ID of the relationship.
    """
    description: Optional[str] = None
    """
    The description of this relationship (used in dynamic views only).
    """
    response: Optional[bool] = None
    """
    Signifies whether this relationship represents a return/response message (used in dynamic views only).
    """
    order: Optional[str] = None
    """
    Gets the order of this relationship (used in dynamic views only; e.g. 1.0, 1.1, 2.0, etc).
    """
    vertices: Optional[List[Vertex]] = None
    """
    The set of vertices used to render the relationship.
    """
    routing: Optional[Routing] = None
    """
    The routing algorithm used when rendering this individual relationship.
    """
    position: Optional[float] = None
    """
    The position of the annotation along the line; 0 (start) to 100 (end).
    """


@dataclass
class Styles:
    """
    The styles associated with this set of views.
    """

    elements: Optional[List[ElementStyle]] = None
    """
    The set of element styles.
    """
    relationships: Optional[List[RelationshipStyle]] = None
    """
    The set of relationship styles.
    """


@dataclass
class Configuration:
    """
    The configuration associated with a set of views.
    """

    styles: Optional[Styles] = None
    """
    The styles associated with this set of views.
    """
    lastSavedView: Optional[str] = None
    """
    The key of the view that was saved most recently.
    """
    defaultView: Optional[str] = None
    """
    The key of the view that should be shown by default.
    """
    themes: Optional[List[str]] = None
    """
    The URL(s) of the theme(s) to be used when rendering diagrams.
    """
    branding: Optional[Branding] = None
    terminology: Optional[Terminology] = None
    metadataSymbols: Optional[MetadataSymbols] = None
    """
    The type of symbols to use when rendering metadata.
    """
    properties: Optional[Dict[str, Any]] = None
    """
    A set of arbitrary name-value properties.
    """


@dataclass
class Documentation:
    """
    A wrapper for documentation.
    """

    sections: Optional[List[DocumentationSection]] = None
    decisions: Optional[List[Decision]] = None
    images: Optional[List[Image]] = None


@dataclass
class WorkspaceConfiguration:
    """
    The workspace configuration (for Structurizr cloud service and on-premises installation).
    """

    users: Optional[List[User]] = None
    visibility: Optional[Visibility] = None
    """
    The visibility of the workspace
    """
    scope: Optional[Scope] = None
    """
    The scope of the workspace (can be unset for unscoped).
    """


@dataclass
class Person:
    """
    A person who uses a software system.
    """

    id: Optional[str] = None
    """
    The ID of this person in the model.
    """
    name: Optional[str] = None
    """
    The name of this person.
    """
    description: Optional[str] = None
    """
    A short description of this person.
    """
    tags: Optional[str] = None
    """
    A comma separated list of tags associated with this person.
    """
    url: Optional[str] = None
    """
    The URL where more information about this element can be found.
    """
    location: Optional[Location] = None
    """
    The location of this person.
    """
    group: Optional[str] = None
    """
    The name of the group in which this person should be included in.
    """
    properties: Optional[Dict[str, Any]] = None
    """
    A set of arbitrary name-value properties.
    """
    perspectives: Optional[List[Perspective]] = None
    """
    The set of perspectives associated with this element.
    """
    relationships: Optional[List[Relationship]] = None
    """
    The set of relationships from this person to other elements.
    """


@dataclass
class Component:
    """
    A component (a grouping of related functionality behind an interface that runs inside a container).
    """

    id: Optional[str] = None
    """
    The ID of this component in the model.
    """
    name: Optional[str] = None
    """
    The name of this component.
    """
    description: Optional[str] = None
    """
    A short description of this component.
    """
    technology: Optional[str] = None
    """
    The technology associated with this component (e.g. Spring Bean).
    """
    tags: Optional[str] = None
    """
    A comma separated list of tags associated with this component.
    """
    url: Optional[str] = None
    """
    The URL where more information about this element can be found.
    """
    group: Optional[str] = None
    """
    The name of the group in which this component should be included in.
    """
    properties: Optional[Dict[str, Any]] = None
    """
    A set of arbitrary name-value properties.
    """
    perspectives: Optional[List[Perspective]] = None
    """
    The set of perspectives associated with this element.
    """
    relationships: Optional[List[Relationship]] = None
    """
    The set of relationships from this component to other elements.
    """
    documentation: Optional[Documentation] = None


@dataclass
class InfrastructureNode:
    """
    An infrastructure node.
    """

    id: Optional[str] = None
    """
    The ID of this infrastructure node in the model.
    """
    name: Optional[str] = None
    """
    The name of this infrastructure node.
    """
    description: Optional[str] = None
    """
    A short description of this infrastructure node.
    """
    technology: Optional[str] = None
    """
    The technology associated with this infrastructure node (e.g. "Route 53").
    """
    environment: Optional[str] = None
    """
    The deployment environment in which this infrastructure node resides (e.g. "Development", "Live", etc).
    """
    tags: Optional[str] = None
    """
    A comma separated list of tags associated with this infrastructure node.
    """
    url: Optional[str] = None
    """
    The URL where more information about this element can be found.
    """
    properties: Optional[Dict[str, Any]] = None
    """
    A set of arbitrary name-value properties.
    """
    perspectives: Optional[List[Perspective]] = None
    """
    The set of perspectives associated with this element.
    """
    relationships: Optional[List[Relationship]] = None
    """
    The set of relationships from this infrastructure node to other elements.
    """


@dataclass
class SoftwareSystemInstance:
    """
    An instance of a software system, running on a deployment node.
    """

    id: Optional[str] = None
    """
    The ID of this software system instance in the model.
    """
    softwareSystemId: Optional[str] = None
    """
    The ID of the software system this is an instance of.
    """
    instanceId: Optional[float] = None
    """
    The number/index of this instance.
    """
    environment: Optional[str] = None
    """
    The deployment environment in which this software system instance resides (e.g. "Development", "Live", etc).
    """
    tags: Optional[str] = None
    """
    A comma separated list of tags associated with this software system instance.
    """
    properties: Optional[Dict[str, Any]] = None
    """
    A set of arbitrary name-value properties.
    """
    perspectives: Optional[List[Perspective]] = None
    """
    The set of perspectives associated with this element.
    """
    relationships: Optional[List[Relationship]] = None
    """
    The set of relationships from this software system instance to other elements.
    """
    healthChecks: Optional[List[HttpHealthCheck]] = None
    """
    The set of HTTP-based health checks for this software system instance.
    """
    deploymentGroups: Optional[List[str]] = None


@dataclass
class ContainerInstance:
    """
    An instance of a container, running on a deployment node.
    """

    id: Optional[str] = None
    """
    The ID of this container instance in the model.
    """
    containerId: Optional[str] = None
    """
    The ID of the container this is an instance of.
    """
    instanceId: Optional[float] = None
    """
    The number/index of this instance.
    """
    environment: Optional[str] = None
    """
    The deployment environment in which this container instance resides (e.g. "Development", "Live", etc).
    """
    tags: Optional[str] = None
    """
    A comma separated list of tags associated with this container instance.
    """
    properties: Optional[Dict[str, Any]] = None
    """
    A set of arbitrary name-value properties.
    """
    perspectives: Optional[List[Perspective]] = None
    """
    The set of perspectives associated with this element.
    """
    relationships: Optional[List[Relationship]] = None
    """
    The set of relationships from this container instance to other elements.
    """
    healthChecks: Optional[List[HttpHealthCheck]] = None
    """
    The set of HTTP-based health checks for this container instance.
    """
    deploymentGroups: Optional[List[str]] = None


@dataclass
class SystemLandscapeView:
    """
    A system landscape view.
    """

    key: Optional[str] = None
    """
    A unique identifier for this view.
    """
    order: Optional[float] = None
    """
    An integer representing the creation order of this view.
    """
    title: Optional[str] = None
    """
    The title of this view (optional).
    """
    description: Optional[str] = None
    """
    The description of this view.
    """
    properties: Optional[Dict[str, Any]] = None
    """
    A set of arbitrary name-value properties.
    """
    paperSize: Optional[PaperSize] = None
    """
    The paper size that should be used to render this view.
    """
    dimensions: Optional[Dimensions] = None
    automaticLayout: Optional[AutomaticLayout] = None
    enterpriseBoundaryVisible: Optional[bool] = None
    """
    Specifies whether the enterprise boundary (to differentiate internal elements from external elements) should be visible on the resulting diagram.
    """
    elements: Optional[List[ElementView]] = None
    """
    The set of elements in this views.
    """
    relationships: Optional[List[RelationshipView]] = None
    """
    The set of relationships in this views.
    """
    animations: Optional[List[AnimationStep]] = None
    """
    The set of animation steps (optional).
    """


@dataclass
class SystemContextView:
    """
    A system context view.
    """

    key: Optional[str] = None
    """
    A unique identifier for this view.
    """
    order: Optional[float] = None
    """
    An integer representing the creation order of this view.
    """
    title: Optional[str] = None
    """
    The title of this view (optional).
    """
    description: Optional[str] = None
    """
    The description of this view.
    """
    properties: Optional[Dict[str, Any]] = None
    """
    A set of arbitrary name-value properties.
    """
    softwareSystemId: Optional[str] = None
    """
    The ID of the software system this view is associated with.
    """
    paperSize: Optional[PaperSize] = None
    """
    The paper size that should be used to render this view.
    """
    dimensions: Optional[Dimensions] = None
    automaticLayout: Optional[AutomaticLayout] = None
    enterpriseBoundaryVisible: Optional[bool] = None
    """
    Specifies whether the enterprise boundary (to differentiate internal elements from external elements") should be visible on the resulting diagram.
    """
    elements: Optional[List[ElementView]] = None
    """
    The set of elements in this view.
    """
    relationships: Optional[List[RelationshipView]] = None
    """
    The set of relationships in this view.
    """
    animations: Optional[List[AnimationStep]] = None
    """
    The set of animation steps (optional).
    """


@dataclass
class ContainerView:
    """
    A container view.
    """

    key: Optional[str] = None
    """
    A unique identifier for this view.
    """
    order: Optional[float] = None
    """
    An integer representing the creation order of this view.
    """
    title: Optional[str] = None
    """
    The title of this view (optional).
    """
    description: Optional[str] = None
    """
    The description of this view.
    """
    properties: Optional[Dict[str, Any]] = None
    """
    A set of arbitrary name-value properties.
    """
    softwareSystemId: Optional[str] = None
    """
    The ID of the software system this view is associated with.
    """
    paperSize: Optional[PaperSize] = None
    """
    The paper size that should be used to render this view.
    """
    dimensions: Optional[Dimensions] = None
    automaticLayout: Optional[AutomaticLayout] = None
    elements: Optional[List[ElementView]] = None
    """
    The set of elements in this views.
    """
    relationships: Optional[List[RelationshipView]] = None
    """
    The set of relationships in this views.
    """
    animations: Optional[List[AnimationStep]] = None
    """
    The set of animation steps (optional).
    """
    externalSoftwareSystemBoundariesVisible: Optional[bool] = None
    """
    Specifies whether software system boundaries should be visible for "external" containers (those outside the software system in scope).
    """


@dataclass
class ComponentView:
    """
    A component view.
    """

    key: Optional[str] = None
    """
    A unique identifier for this view.
    """
    order: Optional[float] = None
    """
    An integer representing the creation order of this view.
    """
    title: Optional[str] = None
    """
    The title of this view (optional).
    """
    description: Optional[str] = None
    """
    The description of this view.
    """
    properties: Optional[Dict[str, Any]] = None
    """
    A set of arbitrary name-value properties.
    """
    containerId: Optional[str] = None
    """
    The ID of the container this view is associated with.
    """
    paperSize: Optional[PaperSize] = None
    """
    The paper size that should be used to render this view.
    """
    dimensions: Optional[Dimensions] = None
    automaticLayout: Optional[AutomaticLayout] = None
    elements: Optional[List[ElementView]] = None
    """
    The set of elements in this views.
    """
    relationships: Optional[List[RelationshipView]] = None
    """
    The set of relationships in this views.
    """
    animations: Optional[List[AnimationStep]] = None
    """
    The set of animation steps (optional).
    """
    externalContainerBoundariesVisible: Optional[bool] = None
    """
    Specifies whether container boundaries should be visible for "external" components (those outside the container in scope).
    """


@dataclass
class DynamicView:
    """
    A dynamic view.
    """

    key: Optional[str] = None
    """
    A unique identifier for this view.
    """
    order: Optional[float] = None
    """
    An integer representing the creation order of this view.
    """
    title: Optional[str] = None
    """
    The title of this view (optional).
    """
    description: Optional[str] = None
    """
    The description of this view.
    """
    properties: Optional[Dict[str, Any]] = None
    """
    A set of arbitrary name-value properties.
    """
    elementId: Optional[str] = None
    """
    The ID of the element this view is associated with (optional).
    """
    paperSize: Optional[PaperSize] = None
    """
    The paper size that should be used to render this view.
    """
    dimensions: Optional[Dimensions] = None
    automaticLayout: Optional[AutomaticLayout] = None
    elements: Optional[List[ElementView]] = None
    """
    The set of elements in this views.
    """
    relationships: Optional[List[RelationshipView]] = None
    """
    The set of relationships in this views.
    """
    externalBoundariesVisible: Optional[bool] = None
    """
    Specifies software system/container boundaries should be visible for "external" containers/components (those outside the element in scope)
    """


@dataclass
class DeploymentView:
    """
    A deployment view.
    """

    key: Optional[str] = None
    """
    A unique identifier for this view.
    """
    order: Optional[float] = None
    """
    An integer representing the creation order of this view.
    """
    title: Optional[str] = None
    """
    The title of this view (optional).
    """
    description: Optional[str] = None
    """
    The description of this view.
    """
    properties: Optional[Dict[str, Any]] = None
    """
    A set of arbitrary name-value properties.
    """
    softwareSystemId: Optional[str] = None
    """
    The ID of the software system this view is associated with (optional).
    """
    environment: Optional[str] = None
    """
    The name of the environment that this deployment view is for (e.g. "Development", "Live", etc).
    """
    paperSize: Optional[PaperSize] = None
    """
    The paper size that should be used to render this view.
    """
    dimensions: Optional[Dimensions] = None
    automaticLayout: Optional[AutomaticLayout] = None
    elements: Optional[List[ElementView]] = None
    """
    The set of elements in this views.
    """
    relationships: Optional[List[RelationshipView]] = None
    """
    The set of relationships in this views.
    """
    animations: Optional[List[AnimationStep]] = None
    """
    The set of animation steps (optional).
    """


@dataclass
class Container:
    """
    A container (something that can execute code or host data).
    """

    id: Optional[str] = None
    """
    The ID of this container in the model.
    """
    name: Optional[str] = None
    """
    The name of this container.
    """
    description: Optional[str] = None
    """
    A short description of this container.
    """
    technology: Optional[str] = None
    """
    The technology associated with this container (e.g. Apache Tomcat).
    """
    tags: Optional[str] = None
    """
    A comma separated list of tags associated with this container.
    """
    url: Optional[str] = None
    """
    The URL where more information about this element can be found.
    """
    components: Optional[List[Component]] = None
    """
    The set of components within this container.
    """
    group: Optional[str] = None
    """
    The name of the group in which this container should be included in.
    """
    properties: Optional[Dict[str, Any]] = None
    """
    A set of arbitrary name-value properties.
    """
    perspectives: Optional[List[Perspective]] = None
    """
    The set of perspectives associated with this element.
    """
    relationships: Optional[List[Relationship]] = None
    """
    The set of relationships from this container to other elements.
    """
    documentation: Optional[Documentation] = None


@dataclass
class DeploymentNode:
    """
    A deployment node.
    """

    id: Optional[str] = None
    """
    The ID of this deployment node in the model.
    """
    name: Optional[str] = None
    """
    The name of this deployment node.
    """
    description: Optional[str] = None
    """
    A short description of this deployment node.
    """
    technology: Optional[str] = None
    """
    The technology associated with this deployment node (e.g. Apache Tomcat).
    """
    environment: Optional[str] = None
    """
    The deployment environment in which this deployment node resides (e.g. "Development", "Live", etc).
    """
    instances: Optional[str] = None
    """
    The number of instances; either a number (e.g. 1, 2, etc) or a range (e.g. 0..N, 0..*, 1..3, etc).
    """
    tags: Optional[str] = None
    """
    A comma separated list of tags associated with this deployment node.
    """
    url: Optional[str] = None
    """
    The URL where more information about this element can be found.
    """
    children: Optional[List[DeploymentNode]] = None
    """
    The set of child/nested deployment nodes.
    """
    infrastructureNodes: Optional[List[InfrastructureNode]] = None
    softwareSystemInstances: Optional[List[SoftwareSystemInstance]] = None
    """
    The set of software systems instances running in this deployment node..
    """
    containerInstances: Optional[List[ContainerInstance]] = None
    """
    The set of container instances running in this deployment node..
    """
    properties: Optional[Dict[str, Any]] = None
    """
    A set of arbitrary name-value properties.
    """
    perspectives: Optional[List[Perspective]] = None
    """
    The set of perspectives associated with this element.
    """
    relationships: Optional[List[Relationship]] = None
    """
    The set of relationships from this deployment node to other elements.
    """


@dataclass
class Views:
    """
    The set of views onto a software architecture model.
    """

    systemLandscapeViews: Optional[List[SystemLandscapeView]] = None
    """
    The set of system landscape views.
    """
    systemContextViews: Optional[List[SystemContextView]] = None
    """
    The set of system context views.
    """
    containerViews: Optional[List[ContainerView]] = None
    """
    The set of container views.
    """
    componentViews: Optional[List[ComponentView]] = None
    """
    The set of component views.
    """
    dynamicViews: Optional[List[DynamicView]] = None
    """
    The set of dynamic views.
    """
    deploymentViews: Optional[List[DeploymentView]] = None
    """
    The set of deployment views.
    """
    filteredViews: Optional[List[FilteredView]] = None
    """
    The set of filtered views.
    """
    imageViews: Optional[List[ImageView]] = None
    """
    The set of image views.
    """
    configuration: Optional[Configuration] = None


@dataclass
class SoftwareSystem:
    """
    A software system.
    """

    id: Optional[str] = None
    """
    The ID of this software system in the model.
    """
    name: Optional[str] = None
    """
    The name of this software system.
    """
    description: Optional[str] = None
    """
    A short description of this software system.
    """
    location: Optional[Location1] = None
    """
    The location of this software system.
    """
    tags: Optional[str] = None
    """
    A comma separated list of tags associated with this software system.
    """
    url: Optional[str] = None
    """
    The URL where more information about this element can be found.
    """
    containers: Optional[List[Container]] = None
    """
    The set of containers within this software system.
    """
    group: Optional[str] = None
    """
    The name of the group in which this software system should be included in.
    """
    properties: Optional[Dict[str, Any]] = None
    """
    A set of arbitrary name-value properties.
    """
    perspectives: Optional[List[Perspective]] = None
    """
    The set of perspectives associated with this element.
    """
    relationships: Optional[List[Relationship]] = None
    """
    The set of relationships from this software system to other elements.
    """
    documentation: Optional[Documentation] = None


@dataclass
class Model:
    """
    A software architecture model.
    """

    enterprise: Optional[Enterprise] = None
    """
    The enterprise associated with this model.
    """
    people: Optional[List[Person]] = None
    softwareSystems: Optional[List[SoftwareSystem]] = None
    deploymentNodes: Optional[List[DeploymentNode]] = None
    properties: Optional[Dict[str, Any]] = None
    """
    A set of arbitrary name-value properties.
    """


@dataclass
class Workspace:
    """
    Represents a Structurizr workspace, which is a wrapper for a software architecture model, views, and documentation.
    """

    id: Optional[int] = None
    """
    The workspace ID.
    """
    name: Optional[str] = None
    """
    The name of the workspace.
    """
    description: Optional[str] = None
    """
    A short description of the workspace.
    """
    version: Optional[str] = None
    """
    A version number for the workspace.
    """
    thumbnail: Optional[str] = None
    """
    The thumbnail associated with the workspace; a Base64 encoded PNG file as a data URI (data:image/png;base64).
    """
    lastModifiedDate: Optional[str] = None
    """
    The last modified date, in ISO 8601 format (e.g. "2018-09-08T12:40:03Z").
    """
    lastModifiedUser: Optional[str] = None
    """
    A string identifying the user who last modified the workspace (e.g. an e-mail address or username).
    """
    lastModifiedAgent: Optional[str] = None
    """
    A string identifying the agent that was last used to modify the workspace (e.g. "structurizr-java/1.2.0").
    """
    model: Optional[Model] = None
    views: Optional[Views] = None
    documentation: Optional[Documentation] = None
    configuration: Optional[WorkspaceConfiguration] = None
    properties: Optional[Dict[str, Any]] = None
    """
    A set of arbitrary name-value properties.
    """
