"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import google.protobuf.wrappers_pb2
import frogml_proto.qwak.audience.v1.audience_pb2
import frogml_proto.qwak.auto_scaling.v1.auto_scaling_pb2
import frogml_proto.qwak.user_application.common.v0.resources_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _ModelDeploymentStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ModelDeploymentStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ModelDeploymentStatus.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INVALID_DEPLOYMENT: _ModelDeploymentStatus.ValueType  # 0
    """Invalid deployment status"""
    INITIATING_DEPLOYMENT: _ModelDeploymentStatus.ValueType  # 1
    """Deployment is initiating"""
    FAILED_INITIATING_DEPLOYMENT: _ModelDeploymentStatus.ValueType  # 8
    """Failed to initiate a deployment process"""
    PENDING_DEPLOYMENT: _ModelDeploymentStatus.ValueType  # 2
    """Deployment is in progress"""
    SUCCESSFUL_DEPLOYMENT: _ModelDeploymentStatus.ValueType  # 3
    """Deployment has finished successfully"""
    FAILED_DEPLOYMENT: _ModelDeploymentStatus.ValueType  # 4
    """Deployment has failed"""
    INITIATING_UNDEPLOYMENT: _ModelDeploymentStatus.ValueType  # 9
    """Undeployment is initiating"""
    PENDING_UNDEPLOYMENT: _ModelDeploymentStatus.ValueType  # 10
    """Undeployment is in progress"""
    SUCCESSFUL_UNDEPLOYMENT: _ModelDeploymentStatus.ValueType  # 5
    """Model is undeployed"""
    FAILED_UNDEPLOYMENT: _ModelDeploymentStatus.ValueType  # 6
    """Undeployment has failed"""
    UNSET: _ModelDeploymentStatus.ValueType  # 7
    """TODO Or - Migration code - to be remove
    Deployment is unset
    """
    ALL_BUILDS_UNDEPLOYED: _ModelDeploymentStatus.ValueType  # 11
    """All builds in a model are undeployed"""
    CANCELLED_DEPLOYMENT: _ModelDeploymentStatus.ValueType  # 12
    """Deployment Cancel"""
    INITIATING_CANCEL_DEPLOYMENT: _ModelDeploymentStatus.ValueType  # 13
    """deployment marked for cancel"""

class ModelDeploymentStatus(_ModelDeploymentStatus, metaclass=_ModelDeploymentStatusEnumTypeWrapper): ...

INVALID_DEPLOYMENT: ModelDeploymentStatus.ValueType  # 0
"""Invalid deployment status"""
INITIATING_DEPLOYMENT: ModelDeploymentStatus.ValueType  # 1
"""Deployment is initiating"""
FAILED_INITIATING_DEPLOYMENT: ModelDeploymentStatus.ValueType  # 8
"""Failed to initiate a deployment process"""
PENDING_DEPLOYMENT: ModelDeploymentStatus.ValueType  # 2
"""Deployment is in progress"""
SUCCESSFUL_DEPLOYMENT: ModelDeploymentStatus.ValueType  # 3
"""Deployment has finished successfully"""
FAILED_DEPLOYMENT: ModelDeploymentStatus.ValueType  # 4
"""Deployment has failed"""
INITIATING_UNDEPLOYMENT: ModelDeploymentStatus.ValueType  # 9
"""Undeployment is initiating"""
PENDING_UNDEPLOYMENT: ModelDeploymentStatus.ValueType  # 10
"""Undeployment is in progress"""
SUCCESSFUL_UNDEPLOYMENT: ModelDeploymentStatus.ValueType  # 5
"""Model is undeployed"""
FAILED_UNDEPLOYMENT: ModelDeploymentStatus.ValueType  # 6
"""Undeployment has failed"""
UNSET: ModelDeploymentStatus.ValueType  # 7
"""TODO Or - Migration code - to be remove
Deployment is unset
"""
ALL_BUILDS_UNDEPLOYED: ModelDeploymentStatus.ValueType  # 11
"""All builds in a model are undeployed"""
CANCELLED_DEPLOYMENT: ModelDeploymentStatus.ValueType  # 12
"""Deployment Cancel"""
INITIATING_CANCEL_DEPLOYMENT: ModelDeploymentStatus.ValueType  # 13
"""deployment marked for cancel"""
global___ModelDeploymentStatus = ModelDeploymentStatus

class _DeploymentHostingServiceType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DeploymentHostingServiceTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DeploymentHostingServiceType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INVALID: _DeploymentHostingServiceType.ValueType  # 0
    SAGEMAKER: _DeploymentHostingServiceType.ValueType  # 1
    KUBE_DEPLOYMENT: _DeploymentHostingServiceType.ValueType  # 2

class DeploymentHostingServiceType(_DeploymentHostingServiceType, metaclass=_DeploymentHostingServiceTypeEnumTypeWrapper): ...

INVALID: DeploymentHostingServiceType.ValueType  # 0
SAGEMAKER: DeploymentHostingServiceType.ValueType  # 1
KUBE_DEPLOYMENT: DeploymentHostingServiceType.ValueType  # 2
global___DeploymentHostingServiceType = DeploymentHostingServiceType

class _KubeDeploymentType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _KubeDeploymentTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_KubeDeploymentType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNDEFINED: _KubeDeploymentType.ValueType  # 0
    ONLINE: _KubeDeploymentType.ValueType  # 1
    STREAM: _KubeDeploymentType.ValueType  # 2
    BATCH: _KubeDeploymentType.ValueType  # 3

class KubeDeploymentType(_KubeDeploymentType, metaclass=_KubeDeploymentTypeEnumTypeWrapper): ...

UNDEFINED: KubeDeploymentType.ValueType  # 0
ONLINE: KubeDeploymentType.ValueType  # 1
STREAM: KubeDeploymentType.ValueType  # 2
BATCH: KubeDeploymentType.ValueType  # 3
global___KubeDeploymentType = KubeDeploymentType

class _GpuType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _GpuTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_GpuType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INVALID_GPU: _GpuType.ValueType  # 0
    NVIDIA_K80: _GpuType.ValueType  # 1
    NVIDIA_V100: _GpuType.ValueType  # 2
    NVIDIA_A100: _GpuType.ValueType  # 3
    NVIDIA_T4: _GpuType.ValueType  # 4
    NVIDIA_A10G: _GpuType.ValueType  # 5
    NVIDIA_L4: _GpuType.ValueType  # 6

class GpuType(_GpuType, metaclass=_GpuTypeEnumTypeWrapper): ...

INVALID_GPU: GpuType.ValueType  # 0
NVIDIA_K80: GpuType.ValueType  # 1
NVIDIA_V100: GpuType.ValueType  # 2
NVIDIA_A100: GpuType.ValueType  # 3
NVIDIA_T4: GpuType.ValueType  # 4
NVIDIA_A10G: GpuType.ValueType  # 5
NVIDIA_L4: GpuType.ValueType  # 6
global___GpuType = GpuType

class _MemoryUnit:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _MemoryUnitEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_MemoryUnit.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNKNOWN: _MemoryUnit.ValueType  # 0
    MIB: _MemoryUnit.ValueType  # 1
    GIB: _MemoryUnit.ValueType  # 2

class MemoryUnit(_MemoryUnit, metaclass=_MemoryUnitEnumTypeWrapper): ...

UNKNOWN: MemoryUnit.ValueType  # 0
MIB: MemoryUnit.ValueType  # 1
GIB: MemoryUnit.ValueType  # 2
global___MemoryUnit = MemoryUnit

class _DeploymentManagedBy:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DeploymentManagedByEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DeploymentManagedBy.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    DEPLOYMENT_MANAGED_BY_INVALID: _DeploymentManagedBy.ValueType  # 0
    DEPLOYMENT_MANAGED_BY_KUBE_CAPTAIN: _DeploymentManagedBy.ValueType  # 1
    DEPLOYMENT_MANAGED_BY_ADMIRAL: _DeploymentManagedBy.ValueType  # 2

class DeploymentManagedBy(_DeploymentManagedBy, metaclass=_DeploymentManagedByEnumTypeWrapper): ...

DEPLOYMENT_MANAGED_BY_INVALID: DeploymentManagedBy.ValueType  # 0
DEPLOYMENT_MANAGED_BY_KUBE_CAPTAIN: DeploymentManagedBy.ValueType  # 1
DEPLOYMENT_MANAGED_BY_ADMIRAL: DeploymentManagedBy.ValueType  # 2
global___DeploymentManagedBy = DeploymentManagedBy

class _DeploymentFailureReasonCode:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DeploymentFailureReasonCodeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DeploymentFailureReasonCode.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INVALID_FAILURE_CODE: _DeploymentFailureReasonCode.ValueType  # 0
    """Invalid failure reason"""
    UNKNOWN_REASON: _DeploymentFailureReasonCode.ValueType  # 1
    """Unknown failure reason"""
    NO_REPLICA_SETS_PODS_FOUND: _DeploymentFailureReasonCode.ValueType  # 2
    """No replica sets pods found reason"""
    MODEL_CONTAINER_NOT_FOUND: _DeploymentFailureReasonCode.ValueType  # 3
    """Model container not found reason"""
    UNSCHEDULABLE: _DeploymentFailureReasonCode.ValueType  # 4
    """Unschedulable reason"""
    DOCKER_IMAGE_NOT_FOUND: _DeploymentFailureReasonCode.ValueType  # 5
    """Docker image not found reason"""
    MEMORY_LIMIT_EXCEEDED: _DeploymentFailureReasonCode.ValueType  # 6
    """Memory limit exceeded reason"""
    CRASH_LOOP: _DeploymentFailureReasonCode.ValueType  # 7
    """Crash loop reason"""
    CONTAINER_FAIL_TO_LOAD_FOR_UNKNOWN_REASON: _DeploymentFailureReasonCode.ValueType  # 8
    """Container fail to load for unknown reason"""

class DeploymentFailureReasonCode(_DeploymentFailureReasonCode, metaclass=_DeploymentFailureReasonCodeEnumTypeWrapper): ...

INVALID_FAILURE_CODE: DeploymentFailureReasonCode.ValueType  # 0
"""Invalid failure reason"""
UNKNOWN_REASON: DeploymentFailureReasonCode.ValueType  # 1
"""Unknown failure reason"""
NO_REPLICA_SETS_PODS_FOUND: DeploymentFailureReasonCode.ValueType  # 2
"""No replica sets pods found reason"""
MODEL_CONTAINER_NOT_FOUND: DeploymentFailureReasonCode.ValueType  # 3
"""Model container not found reason"""
UNSCHEDULABLE: DeploymentFailureReasonCode.ValueType  # 4
"""Unschedulable reason"""
DOCKER_IMAGE_NOT_FOUND: DeploymentFailureReasonCode.ValueType  # 5
"""Docker image not found reason"""
MEMORY_LIMIT_EXCEEDED: DeploymentFailureReasonCode.ValueType  # 6
"""Memory limit exceeded reason"""
CRASH_LOOP: DeploymentFailureReasonCode.ValueType  # 7
"""Crash loop reason"""
CONTAINER_FAIL_TO_LOAD_FOR_UNKNOWN_REASON: DeploymentFailureReasonCode.ValueType  # 8
"""Container fail to load for unknown reason"""
global___DeploymentFailureReasonCode = DeploymentFailureReasonCode

class _ModelPodPhase:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ModelPodPhaseEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ModelPodPhase.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INVALID_POD_PHASE: _ModelPodPhase.ValueType  # 0
    MODEL_POD_PHASE_PROVISIONING_INSTANCE: _ModelPodPhase.ValueType  # 1
    MODEL_POD_PHASE_PULLING_IMAGE: _ModelPodPhase.ValueType  # 2
    MODEL_POD_PHASE_INITIALIZING_MODEL: _ModelPodPhase.ValueType  # 3
    MODEL_POD_PHASE_READY: _ModelPodPhase.ValueType  # 4

class ModelPodPhase(_ModelPodPhase, metaclass=_ModelPodPhaseEnumTypeWrapper): ...

INVALID_POD_PHASE: ModelPodPhase.ValueType  # 0
MODEL_POD_PHASE_PROVISIONING_INSTANCE: ModelPodPhase.ValueType  # 1
MODEL_POD_PHASE_PULLING_IMAGE: ModelPodPhase.ValueType  # 2
MODEL_POD_PHASE_INITIALIZING_MODEL: ModelPodPhase.ValueType  # 3
MODEL_POD_PHASE_READY: ModelPodPhase.ValueType  # 4
global___ModelPodPhase = ModelPodPhase

class _DeploymentPhaseType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DeploymentPhaseTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DeploymentPhaseType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INVALID_DEPLOYMENT_PHASE: _DeploymentPhaseType.ValueType  # 0
    DEPLOYMENT_PHASE_PROVISIONING_INSTANCE: _DeploymentPhaseType.ValueType  # 1
    DEPLOYMENT_PHASE_PULLING_IMAGE: _DeploymentPhaseType.ValueType  # 2
    DEPLOYMENT_PHASE_INITIALIZING_MODEL: _DeploymentPhaseType.ValueType  # 3

class DeploymentPhaseType(_DeploymentPhaseType, metaclass=_DeploymentPhaseTypeEnumTypeWrapper): ...

INVALID_DEPLOYMENT_PHASE: DeploymentPhaseType.ValueType  # 0
DEPLOYMENT_PHASE_PROVISIONING_INSTANCE: DeploymentPhaseType.ValueType  # 1
DEPLOYMENT_PHASE_PULLING_IMAGE: DeploymentPhaseType.ValueType  # 2
DEPLOYMENT_PHASE_INITIALIZING_MODEL: DeploymentPhaseType.ValueType  # 3
global___DeploymentPhaseType = DeploymentPhaseType

class _DeploymentPhaseStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DeploymentPhaseStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DeploymentPhaseStatus.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INVALID_DEPLOYMENT_PHASE_STATUS: _DeploymentPhaseStatus.ValueType  # 0
    DEPLOYMENT_PHASE_NOT_STARTED: _DeploymentPhaseStatus.ValueType  # 1
    DEPLOYMENT_PHASE_STARTED: _DeploymentPhaseStatus.ValueType  # 2
    DEPLOYMENT_PHASE_FINISHED: _DeploymentPhaseStatus.ValueType  # 3
    DEPLOYMENT_PHASE_CANCELED: _DeploymentPhaseStatus.ValueType  # 4
    DEPLOYMENT_PHASE_FAILED: _DeploymentPhaseStatus.ValueType  # 5
    DEPLOYMENT_PHASE_ABORTED: _DeploymentPhaseStatus.ValueType  # 6

class DeploymentPhaseStatus(_DeploymentPhaseStatus, metaclass=_DeploymentPhaseStatusEnumTypeWrapper): ...

INVALID_DEPLOYMENT_PHASE_STATUS: DeploymentPhaseStatus.ValueType  # 0
DEPLOYMENT_PHASE_NOT_STARTED: DeploymentPhaseStatus.ValueType  # 1
DEPLOYMENT_PHASE_STARTED: DeploymentPhaseStatus.ValueType  # 2
DEPLOYMENT_PHASE_FINISHED: DeploymentPhaseStatus.ValueType  # 3
DEPLOYMENT_PHASE_CANCELED: DeploymentPhaseStatus.ValueType  # 4
DEPLOYMENT_PHASE_FAILED: DeploymentPhaseStatus.ValueType  # 5
DEPLOYMENT_PHASE_ABORTED: DeploymentPhaseStatus.ValueType  # 6
global___DeploymentPhaseStatus = DeploymentPhaseStatus

class QwakModeRegistryIdentifier(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The model registry id"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___QwakModeRegistryIdentifier = QwakModeRegistryIdentifier

class HostingService(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SAGEMAKER_FIELD_NUMBER: builtins.int
    KUBE_DEPLOYMENT_FIELD_NUMBER: builtins.int
    @property
    def sagemaker(self) -> global___SageMaker: ...
    @property
    def kube_deployment(self) -> global___KubeDeployment: ...
    def __init__(
        self,
        *,
        sagemaker: global___SageMaker | None = ...,
        kube_deployment: global___KubeDeployment | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["kube_deployment", b"kube_deployment", "sagemaker", b"sagemaker", "val", b"val"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["kube_deployment", b"kube_deployment", "sagemaker", b"sagemaker", "val", b"val"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["val", b"val"]) -> typing_extensions.Literal["sagemaker", "kube_deployment"] | None: ...

global___HostingService = HostingService

class KubeDeployment(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class EnvironmentVariablesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    POD_COUNT_FIELD_NUMBER: builtins.int
    DEPLOYMENT_SIZE_FIELD_NUMBER: builtins.int
    ADVANCED_DEPLOYMENT_OPTIONS_FIELD_NUMBER: builtins.int
    KUBE_DEPLOYMENT_TYPE_FIELD_NUMBER: builtins.int
    SERVING_STRATEGY_FIELD_NUMBER: builtins.int
    ENVIRONMENT_VARIABLES_FIELD_NUMBER: builtins.int
    pod_count: builtins.int
    """Count of pods to deploy."""
    @property
    def deployment_size(self) -> global___DeploymentSize:
        """Size of deployments"""
    @property
    def advanced_deployment_options(self) -> global___AdvancedDeploymentOptions:
        """Advanced deployment options"""
    kube_deployment_type: global___KubeDeploymentType.ValueType
    @property
    def serving_strategy(self) -> global___ServingStrategy: ...
    @property
    def environment_variables(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    def __init__(
        self,
        *,
        pod_count: builtins.int = ...,
        deployment_size: global___DeploymentSize | None = ...,
        advanced_deployment_options: global___AdvancedDeploymentOptions | None = ...,
        kube_deployment_type: global___KubeDeploymentType.ValueType = ...,
        serving_strategy: global___ServingStrategy | None = ...,
        environment_variables: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["advanced_deployment_options", b"advanced_deployment_options", "deployment_size", b"deployment_size", "serving_strategy", b"serving_strategy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["advanced_deployment_options", b"advanced_deployment_options", "deployment_size", b"deployment_size", "environment_variables", b"environment_variables", "kube_deployment_type", b"kube_deployment_type", "pod_count", b"pod_count", "serving_strategy", b"serving_strategy"]) -> None: ...

global___KubeDeployment = KubeDeployment

class ServingStrategy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REALTIME_CONFIG_FIELD_NUMBER: builtins.int
    STREAM_CONFIG_FIELD_NUMBER: builtins.int
    BATCH_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def realtime_config(self) -> global___RealTimeConfig: ...
    @property
    def stream_config(self) -> global___StreamConfig: ...
    @property
    def batch_config(self) -> global___BatchConfig: ...
    def __init__(
        self,
        *,
        realtime_config: global___RealTimeConfig | None = ...,
        stream_config: global___StreamConfig | None = ...,
        batch_config: global___BatchConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["Strategy", b"Strategy", "batch_config", b"batch_config", "realtime_config", b"realtime_config", "stream_config", b"stream_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["Strategy", b"Strategy", "batch_config", b"batch_config", "realtime_config", b"realtime_config", "stream_config", b"stream_config"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["Strategy", b"Strategy"]) -> typing_extensions.Literal["realtime_config", "stream_config", "batch_config"] | None: ...

global___ServingStrategy = ServingStrategy

class RealTimeConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRAFFIC_CONFIG_FIELD_NUMBER: builtins.int
    AUTO_SCALING_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def traffic_config(self) -> global___TrafficConfig: ...
    @property
    def auto_scaling_config(self) -> frogml_proto.qwak.auto_scaling.v1.auto_scaling_pb2.AutoScalingConfig:
        """Auto scaling config"""
    def __init__(
        self,
        *,
        traffic_config: global___TrafficConfig | None = ...,
        auto_scaling_config: frogml_proto.qwak.auto_scaling.v1.auto_scaling_pb2.AutoScalingConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["auto_scaling_config", b"auto_scaling_config", "traffic_config", b"traffic_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["auto_scaling_config", b"auto_scaling_config", "traffic_config", b"traffic_config"]) -> None: ...

global___RealTimeConfig = RealTimeConfig

class TrafficConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SELECTED_VARIATION_NAME_FIELD_NUMBER: builtins.int
    VARIATIONS_FIELD_NUMBER: builtins.int
    AUDIENCE_ROUTES_ENTRIES_FIELD_NUMBER: builtins.int
    FALLBACK_VARIATION_FIELD_NUMBER: builtins.int
    SELECTED_VARIATION_PROTECT_STATE_FIELD_NUMBER: builtins.int
    selected_variation_name: builtins.str
    """Variation name"""
    @property
    def variations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Variation]:
        """The variations config"""
    @property
    def audience_routes_entries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[qwak.audience.v1.audience_pb2.AudienceRoutesEntry]:
        """Audiences Routes."""
    fallback_variation: builtins.str
    selected_variation_protect_state: builtins.bool
    def __init__(
        self,
        *,
        selected_variation_name: builtins.str = ...,
        variations: collections.abc.Iterable[global___Variation] | None = ...,
        audience_routes_entries: collections.abc.Iterable[qwak.audience.v1.audience_pb2.AudienceRoutesEntry] | None = ...,
        fallback_variation: builtins.str = ...,
        selected_variation_protect_state: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["audience_routes_entries", b"audience_routes_entries", "fallback_variation", b"fallback_variation", "selected_variation_name", b"selected_variation_name", "selected_variation_protect_state", b"selected_variation_protect_state", "variations", b"variations"]) -> None: ...

global___TrafficConfig = TrafficConfig

class StreamConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KAFKA_FIELD_NUMBER: builtins.int
    @property
    def kafka(self) -> global___KafkaConfig: ...
    def __init__(
        self,
        *,
        kafka: global___KafkaConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["kafka", b"kafka"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["kafka", b"kafka"]) -> None: ...

global___StreamConfig = StreamConfig

class BatchConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___BatchConfig = BatchConfig

class KafkaConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class Consumer(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _AutoOffSetType:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _AutoOffSetTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[KafkaConfig.Consumer._AutoOffSetType.ValueType], builtins.type):  # noqa: F821
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            UNKNOWN: KafkaConfig.Consumer._AutoOffSetType.ValueType  # 0
            EARLIEST: KafkaConfig.Consumer._AutoOffSetType.ValueType  # 1
            LATEST: KafkaConfig.Consumer._AutoOffSetType.ValueType  # 2

        class AutoOffSetType(_AutoOffSetType, metaclass=_AutoOffSetTypeEnumTypeWrapper): ...
        UNKNOWN: KafkaConfig.Consumer.AutoOffSetType.ValueType  # 0
        EARLIEST: KafkaConfig.Consumer.AutoOffSetType.ValueType  # 1
        LATEST: KafkaConfig.Consumer.AutoOffSetType.ValueType  # 2

        BOOTSTRAP_SERVER_FIELD_NUMBER: builtins.int
        TOPIC_FIELD_NUMBER: builtins.int
        GROUP_FIELD_NUMBER: builtins.int
        TIMEOUT_FIELD_NUMBER: builtins.int
        AUTO_OFFSET_TYPE_FIELD_NUMBER: builtins.int
        MAX_BATCH_SIZE_FIELD_NUMBER: builtins.int
        MAX_POLL_LATENCY_FIELD_NUMBER: builtins.int
        @property
        def bootstrap_server(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        topic: builtins.str
        group: builtins.str
        timeout: builtins.int
        auto_offset_type: global___KafkaConfig.Consumer.AutoOffSetType.ValueType
        max_batch_size: builtins.int
        max_poll_latency: builtins.float
        def __init__(
            self,
            *,
            bootstrap_server: collections.abc.Iterable[builtins.str] | None = ...,
            topic: builtins.str = ...,
            group: builtins.str = ...,
            timeout: builtins.int = ...,
            auto_offset_type: global___KafkaConfig.Consumer.AutoOffSetType.ValueType = ...,
            max_batch_size: builtins.int = ...,
            max_poll_latency: builtins.float = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["auto_offset_type", b"auto_offset_type", "bootstrap_server", b"bootstrap_server", "group", b"group", "max_batch_size", b"max_batch_size", "max_poll_latency", b"max_poll_latency", "timeout", b"timeout", "topic", b"topic"]) -> None: ...

    class Producer(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _CompressionType:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _CompressionTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[KafkaConfig.Producer._CompressionType.ValueType], builtins.type):  # noqa: F821
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            UNKNOWN: KafkaConfig.Producer._CompressionType.ValueType  # 0
            UNCOMPRESSED: KafkaConfig.Producer._CompressionType.ValueType  # 1
            GZIP: KafkaConfig.Producer._CompressionType.ValueType  # 2
            SNAPPY: KafkaConfig.Producer._CompressionType.ValueType  # 3
            LZ4: KafkaConfig.Producer._CompressionType.ValueType  # 4
            ZSTD: KafkaConfig.Producer._CompressionType.ValueType  # 5

        class CompressionType(_CompressionType, metaclass=_CompressionTypeEnumTypeWrapper): ...
        UNKNOWN: KafkaConfig.Producer.CompressionType.ValueType  # 0
        UNCOMPRESSED: KafkaConfig.Producer.CompressionType.ValueType  # 1
        GZIP: KafkaConfig.Producer.CompressionType.ValueType  # 2
        SNAPPY: KafkaConfig.Producer.CompressionType.ValueType  # 3
        LZ4: KafkaConfig.Producer.CompressionType.ValueType  # 4
        ZSTD: KafkaConfig.Producer.CompressionType.ValueType  # 5

        BOOTSTRAP_SERVER_FIELD_NUMBER: builtins.int
        TOPIC_FIELD_NUMBER: builtins.int
        COMPRESSION_TYPE_FIELD_NUMBER: builtins.int
        @property
        def bootstrap_server(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        topic: builtins.str
        compression_type: global___KafkaConfig.Producer.CompressionType.ValueType
        def __init__(
            self,
            *,
            bootstrap_server: collections.abc.Iterable[builtins.str] | None = ...,
            topic: builtins.str = ...,
            compression_type: global___KafkaConfig.Producer.CompressionType.ValueType = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["bootstrap_server", b"bootstrap_server", "compression_type", b"compression_type", "topic", b"topic"]) -> None: ...

    CONSUMER_FIELD_NUMBER: builtins.int
    PRODUCER_FIELD_NUMBER: builtins.int
    WORKERS_FIELD_NUMBER: builtins.int
    @property
    def consumer(self) -> global___KafkaConfig.Consumer: ...
    @property
    def producer(self) -> global___KafkaConfig.Producer: ...
    workers: builtins.int
    def __init__(
        self,
        *,
        consumer: global___KafkaConfig.Consumer | None = ...,
        producer: global___KafkaConfig.Producer | None = ...,
        workers: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["consumer", b"consumer", "producer", b"producer"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["consumer", b"consumer", "producer", b"producer", "workers", b"workers"]) -> None: ...

global___KafkaConfig = KafkaConfig

class SageMaker(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_COUNT_FIELD_NUMBER: builtins.int
    INSTANCE_TYPE_FIELD_NUMBER: builtins.int
    instance_count: builtins.int
    """Count of instances to deploy."""
    instance_type: builtins.str
    """Machine type which the model will be hosted on, supported by AWS Sagemaker
    More information can be found here - https://aws.amazon.com/sagemaker/pricing/
    """
    def __init__(
        self,
        *,
        instance_count: builtins.int = ...,
        instance_type: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["instance_count", b"instance_count", "instance_type", b"instance_type"]) -> None: ...

global___SageMaker = SageMaker

class DeploymentSize(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NUMBER_OF_PODS_FIELD_NUMBER: builtins.int
    CPU_FIELD_NUMBER: builtins.int
    MEMORY_AMOUNT_FIELD_NUMBER: builtins.int
    MEMORY_UNITS_FIELD_NUMBER: builtins.int
    GPU_RESOURCES_FIELD_NUMBER: builtins.int
    CLIENT_POD_COMPUTE_RESOURCES_FIELD_NUMBER: builtins.int
    number_of_pods: builtins.int
    """Count of pods to deploy."""
    cpu: builtins.float
    """Amount of CPU cores"""
    memory_amount: builtins.int
    """Amount of memory"""
    memory_units: global___MemoryUnit.ValueType
    """Units type of memory"""
    @property
    def gpu_resources(self) -> frogml_proto.qwak.user_application.common.v0.resources_pb2.GpuResources:
        """GPU Resource for deployed model"""
    @property
    def client_pod_compute_resources(self) -> frogml_proto.qwak.user_application.common.v0.resources_pb2.ClientPodComputeResources:
        """Deployment pod compute resources"""
    def __init__(
        self,
        *,
        number_of_pods: builtins.int = ...,
        cpu: builtins.float = ...,
        memory_amount: builtins.int = ...,
        memory_units: global___MemoryUnit.ValueType = ...,
        gpu_resources: frogml_proto.qwak.user_application.common.v0.resources_pb2.GpuResources | None = ...,
        client_pod_compute_resources: frogml_proto.qwak.user_application.common.v0.resources_pb2.ClientPodComputeResources | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["client_pod_compute_resources", b"client_pod_compute_resources", "gpu_resources", b"gpu_resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["client_pod_compute_resources", b"client_pod_compute_resources", "cpu", b"cpu", "gpu_resources", b"gpu_resources", "memory_amount", b"memory_amount", "memory_units", b"memory_units", "number_of_pods", b"number_of_pods"]) -> None: ...

global___DeploymentSize = DeploymentSize

class GpuResources(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GPU_TYPE_FIELD_NUMBER: builtins.int
    GPU_AMOUNT_FIELD_NUMBER: builtins.int
    gpu_type: global___GpuType.ValueType
    """The type of the GPU"""
    gpu_amount: builtins.int
    """Amount of GPUs"""
    def __init__(
        self,
        *,
        gpu_type: global___GpuType.ValueType = ...,
        gpu_amount: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["gpu_amount", b"gpu_amount", "gpu_type", b"gpu_type"]) -> None: ...

global___GpuResources = GpuResources

class AdvancedDeploymentOptions(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NUMBER_OF_HTTP_SERVER_WORKERS_FIELD_NUMBER: builtins.int
    HTTP_REQUEST_TIMEOUT_MS_FIELD_NUMBER: builtins.int
    DAEMON_MODE_FIELD_NUMBER: builtins.int
    CUSTOM_IAM_ROLE_ARN_FIELD_NUMBER: builtins.int
    MAX_BATCH_SIZE_FIELD_NUMBER: builtins.int
    DEPLOYMENT_PROCESS_TIMEOUT_LIMIT_FIELD_NUMBER: builtins.int
    PURCHASE_OPTION_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_KEY_SECRET_NAME_FIELD_NUMBER: builtins.int
    number_of_http_server_workers: builtins.int
    """Amount of http server workers"""
    http_request_timeout_ms: builtins.int
    """Http request timeout in ms"""
    @property
    def daemon_mode(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Serve model container in daemon mode"""
    custom_iam_role_arn: builtins.str
    """Custom IAM Role ARN"""
    max_batch_size: builtins.int
    """Max batch size of records"""
    deployment_process_timeout_limit: builtins.int
    """The timeout for the deployment (in seconds)"""
    purchase_option: builtins.str
    """Whether it is spot/ondemand (default - spot)"""
    service_account_key_secret_name: builtins.str
    """Service account key secret name for gcp"""
    def __init__(
        self,
        *,
        number_of_http_server_workers: builtins.int = ...,
        http_request_timeout_ms: builtins.int = ...,
        daemon_mode: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        custom_iam_role_arn: builtins.str = ...,
        max_batch_size: builtins.int = ...,
        deployment_process_timeout_limit: builtins.int = ...,
        purchase_option: builtins.str = ...,
        service_account_key_secret_name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["daemon_mode", b"daemon_mode"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["custom_iam_role_arn", b"custom_iam_role_arn", "daemon_mode", b"daemon_mode", "deployment_process_timeout_limit", b"deployment_process_timeout_limit", "http_request_timeout_ms", b"http_request_timeout_ms", "max_batch_size", b"max_batch_size", "number_of_http_server_workers", b"number_of_http_server_workers", "purchase_option", b"purchase_option", "service_account_key_secret_name", b"service_account_key_secret_name"]) -> None: ...

global___AdvancedDeploymentOptions = AdvancedDeploymentOptions

class DeploymentDetails(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class EnvironmentVariablesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    LAST_DEPLOYED_FIELD_NUMBER: builtins.int
    BUILD_ID_FIELD_NUMBER: builtins.int
    QWAK_MODEL_REGISTRY_IDENTIFIER_FIELD_NUMBER: builtins.int
    NUMBER_OF_PODS_FIELD_NUMBER: builtins.int
    CPU_FRACTION_FIELD_NUMBER: builtins.int
    MEMORY_AMOUNT_FIELD_NUMBER: builtins.int
    MEMORY_UNITS_FIELD_NUMBER: builtins.int
    NUMBER_OF_WORKERS_FIELD_NUMBER: builtins.int
    HTTP_REQUEST_TIMEOUT_MS_FIELD_NUMBER: builtins.int
    KUBE_DEPLOYMENT_TYPE_FIELD_NUMBER: builtins.int
    SERVING_STRATEGY_FIELD_NUMBER: builtins.int
    VARIATION_FIELD_NUMBER: builtins.int
    CUSTOM_IAM_ROLE_ARN_FIELD_NUMBER: builtins.int
    MAX_BATCH_SIZE_FIELD_NUMBER: builtins.int
    GPU_TYPE_FIELD_NUMBER: builtins.int
    GPU_AMOUNT_FIELD_NUMBER: builtins.int
    ENVIRONMENT_ID_FIELD_NUMBER: builtins.int
    AVAILABLE_REPLICAS_FIELD_NUMBER: builtins.int
    DAEMON_MODE_FIELD_NUMBER: builtins.int
    DEPLOYMENT_PROCESS_TIMEOUT_LIMIT_FIELD_NUMBER: builtins.int
    PURCHASE_OPTION_FIELD_NUMBER: builtins.int
    ENVIRONMENT_VARIABLES_FIELD_NUMBER: builtins.int
    UNDEPLOYMENT_TIME_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    DEPLOYMENT_ID_FIELD_NUMBER: builtins.int
    FAILURE_DETAILS_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_KEY_SECRET_NAME_FIELD_NUMBER: builtins.int
    @property
    def last_deployed(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Deployed date"""
    build_id: builtins.str
    """The build id that deployed"""
    @property
    def qwak_model_registry_identifier(self) -> global___QwakModeRegistryIdentifier: ...
    number_of_pods: builtins.int
    """Number of pods to deploy"""
    cpu_fraction: builtins.float
    """Cpu"""
    memory_amount: builtins.int
    """Amount of memory"""
    memory_units: global___MemoryUnit.ValueType
    """Units type of memory"""
    number_of_workers: builtins.int
    """Number of workers"""
    http_request_timeout_ms: builtins.int
    """Timeout for request timeout"""
    kube_deployment_type: global___KubeDeploymentType.ValueType
    """Kube deployment type"""
    @property
    def serving_strategy(self) -> global___ServingStrategy:
        """Serving strategy"""
    @property
    def variation(self) -> global___Variation:
        """Variation details"""
    custom_iam_role_arn: builtins.str
    """Custom IAM Role"""
    max_batch_size: builtins.int
    """Max batch size"""
    gpu_type: frogml_proto.qwak.user_application.common.v0.resources_pb2.GpuType.ValueType
    """The type of the GPU"""
    gpu_amount: builtins.int
    """Amount of GPUs"""
    environment_id: builtins.str
    """The environment the deployment is on"""
    available_replicas: builtins.int
    """Amount of available replicas"""
    @property
    def daemon_mode(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Serve model container in daemon mode"""
    deployment_process_timeout_limit: builtins.int
    """The timeout for the deployment (in seconds)"""
    purchase_option: builtins.str
    """Whether it is spot/ondemand (default - spot)"""
    @property
    def environment_variables(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Environment variables"""
    @property
    def undeployment_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time that the deployment was changed."""
    status: global___ModelDeploymentStatus.ValueType
    """The status of the deployment"""
    deployment_id: builtins.str
    """Deployment id"""
    @property
    def failure_details(self) -> global___DeploymentFailureDetails: ...
    service_account_key_secret_name: builtins.str
    """Service account key secret name for gcp"""
    def __init__(
        self,
        *,
        last_deployed: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        build_id: builtins.str = ...,
        qwak_model_registry_identifier: global___QwakModeRegistryIdentifier | None = ...,
        number_of_pods: builtins.int = ...,
        cpu_fraction: builtins.float = ...,
        memory_amount: builtins.int = ...,
        memory_units: global___MemoryUnit.ValueType = ...,
        number_of_workers: builtins.int = ...,
        http_request_timeout_ms: builtins.int = ...,
        kube_deployment_type: global___KubeDeploymentType.ValueType = ...,
        serving_strategy: global___ServingStrategy | None = ...,
        variation: global___Variation | None = ...,
        custom_iam_role_arn: builtins.str = ...,
        max_batch_size: builtins.int = ...,
        gpu_type: frogml_proto.qwak.user_application.common.v0.resources_pb2.GpuType.ValueType = ...,
        gpu_amount: builtins.int = ...,
        environment_id: builtins.str = ...,
        available_replicas: builtins.int = ...,
        daemon_mode: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        deployment_process_timeout_limit: builtins.int = ...,
        purchase_option: builtins.str = ...,
        environment_variables: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        undeployment_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        status: global___ModelDeploymentStatus.ValueType = ...,
        deployment_id: builtins.str = ...,
        failure_details: global___DeploymentFailureDetails | None = ...,
        service_account_key_secret_name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["build_id", b"build_id", "daemon_mode", b"daemon_mode", "failure_details", b"failure_details", "image_identifier", b"image_identifier", "last_deployed", b"last_deployed", "qwak_model_registry_identifier", b"qwak_model_registry_identifier", "serving_strategy", b"serving_strategy", "undeployment_time", b"undeployment_time", "variation", b"variation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["available_replicas", b"available_replicas", "build_id", b"build_id", "cpu_fraction", b"cpu_fraction", "custom_iam_role_arn", b"custom_iam_role_arn", "daemon_mode", b"daemon_mode", "deployment_id", b"deployment_id", "deployment_process_timeout_limit", b"deployment_process_timeout_limit", "environment_id", b"environment_id", "environment_variables", b"environment_variables", "failure_details", b"failure_details", "gpu_amount", b"gpu_amount", "gpu_type", b"gpu_type", "http_request_timeout_ms", b"http_request_timeout_ms", "image_identifier", b"image_identifier", "kube_deployment_type", b"kube_deployment_type", "last_deployed", b"last_deployed", "max_batch_size", b"max_batch_size", "memory_amount", b"memory_amount", "memory_units", b"memory_units", "number_of_pods", b"number_of_pods", "number_of_workers", b"number_of_workers", "purchase_option", b"purchase_option", "qwak_model_registry_identifier", b"qwak_model_registry_identifier", "service_account_key_secret_name", b"service_account_key_secret_name", "serving_strategy", b"serving_strategy", "status", b"status", "undeployment_time", b"undeployment_time", "variation", b"variation"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["image_identifier", b"image_identifier"]) -> typing_extensions.Literal["build_id", "qwak_model_registry_identifier"] | None: ...

global___DeploymentDetails = DeploymentDetails

class DeploymentFailureDetails(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FAILURE_MESSAGE_FIELD_NUMBER: builtins.int
    failure_message: builtins.str
    """User friendly message about the failure if deployment failed"""
    def __init__(
        self,
        *,
        failure_message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["failure_message", b"failure_message"]) -> None: ...

global___DeploymentFailureDetails = DeploymentFailureDetails

class RuntimeDeploymentSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _LogLevel:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _LogLevelEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[RuntimeDeploymentSettings._LogLevel.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        NOT_SET: RuntimeDeploymentSettings._LogLevel.ValueType  # 0
        ERROR: RuntimeDeploymentSettings._LogLevel.ValueType  # 1
        WARN: RuntimeDeploymentSettings._LogLevel.ValueType  # 2
        INFO: RuntimeDeploymentSettings._LogLevel.ValueType  # 3
        DEBUG: RuntimeDeploymentSettings._LogLevel.ValueType  # 4

    class LogLevel(_LogLevel, metaclass=_LogLevelEnumTypeWrapper): ...
    NOT_SET: RuntimeDeploymentSettings.LogLevel.ValueType  # 0
    ERROR: RuntimeDeploymentSettings.LogLevel.ValueType  # 1
    WARN: RuntimeDeploymentSettings.LogLevel.ValueType  # 2
    INFO: RuntimeDeploymentSettings.LogLevel.ValueType  # 3
    DEBUG: RuntimeDeploymentSettings.LogLevel.ValueType  # 4

    ROOT_LOGGER_LEVEL_FIELD_NUMBER: builtins.int
    root_logger_level: global___RuntimeDeploymentSettings.LogLevel.ValueType
    """Set a log level"""
    def __init__(
        self,
        *,
        root_logger_level: global___RuntimeDeploymentSettings.LogLevel.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["root_logger_level", b"root_logger_level"]) -> None: ...

global___RuntimeDeploymentSettings = RuntimeDeploymentSettings

class DeploymentBrief(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUILD_ID_FIELD_NUMBER: builtins.int
    QWAK_MODEL_REGISTRY_IDENTIFIER_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    DEPLOYED_BY_FIELD_NUMBER: builtins.int
    FAILURE_REASON_CODE_FIELD_NUMBER: builtins.int
    FAILURE_MESSAGE_FIELD_NUMBER: builtins.int
    TECHNICAL_DETAILS_FIELD_NUMBER: builtins.int
    DEPLOYMENT_TIMESTAMP_FIELD_NUMBER: builtins.int
    ENVIRONMENT_ID_FIELD_NUMBER: builtins.int
    VARIATION_NAME_FIELD_NUMBER: builtins.int
    VARIATION_PROTECT_STATE_FIELD_NUMBER: builtins.int
    DEPLOYMENT_ID_FIELD_NUMBER: builtins.int
    build_id: builtins.str
    """the deployed build id"""
    @property
    def qwak_model_registry_identifier(self) -> global___QwakModeRegistryIdentifier: ...
    status: global___ModelDeploymentStatus.ValueType
    """The Deployment status - SUCCESSFUL_DEPLOYMENT or FAILED_DEPLOYMENT"""
    deployed_by: builtins.str
    """The user id that did the deployment"""
    failure_reason_code: builtins.str
    """The failure reason code if deployment failed"""
    failure_message: builtins.str
    """User friendly message about the failure if deployment failed"""
    technical_details: builtins.str
    """Technical Details about the failure details."""
    @property
    def deployment_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The deployment date"""
    environment_id: builtins.str
    """The deployment environment id"""
    variation_name: builtins.str
    """Variation Name"""
    variation_protect_state: builtins.bool
    """If this Variation is protected"""
    deployment_id: builtins.str
    def __init__(
        self,
        *,
        build_id: builtins.str = ...,
        qwak_model_registry_identifier: global___QwakModeRegistryIdentifier | None = ...,
        status: global___ModelDeploymentStatus.ValueType = ...,
        deployed_by: builtins.str = ...,
        failure_reason_code: builtins.str = ...,
        failure_message: builtins.str = ...,
        technical_details: builtins.str = ...,
        deployment_timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        environment_id: builtins.str = ...,
        variation_name: builtins.str = ...,
        variation_protect_state: builtins.bool = ...,
        deployment_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["build_id", b"build_id", "deployment_timestamp", b"deployment_timestamp", "image_identifier", b"image_identifier", "qwak_model_registry_identifier", b"qwak_model_registry_identifier"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["build_id", b"build_id", "deployed_by", b"deployed_by", "deployment_id", b"deployment_id", "deployment_timestamp", b"deployment_timestamp", "environment_id", b"environment_id", "failure_message", b"failure_message", "failure_reason_code", b"failure_reason_code", "image_identifier", b"image_identifier", "qwak_model_registry_identifier", b"qwak_model_registry_identifier", "status", b"status", "technical_details", b"technical_details", "variation_name", b"variation_name", "variation_protect_state", b"variation_protect_state"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["image_identifier", b"image_identifier"]) -> typing_extensions.Literal["build_id", "qwak_model_registry_identifier"] | None: ...

global___DeploymentBrief = DeploymentBrief

class KubernetesModelDeploymentState(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_ID_FIELD_NUMBER: builtins.int
    BRANCH_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    STATUS_DETAILS_FIELD_NUMBER: builtins.int
    VARIATION_NAME_FIELD_NUMBER: builtins.int
    DEPLOYMENT_ID_FIELD_NUMBER: builtins.int
    MODEL_UUID_FIELD_NUMBER: builtins.int
    MANAGED_BY_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """The ID of the model to deploy"""
    branch_id: builtins.str
    """Branch ID to deploy the model under"""
    status: global___ModelDeploymentStatus.ValueType
    """The Model status"""
    @property
    def status_details(self) -> global___StatusDetails:
        """Status details of the Kubernetes current state"""
    variation_name: builtins.str
    deployment_id: builtins.str
    model_uuid: builtins.str
    managed_by: global___DeploymentManagedBy.ValueType
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
        branch_id: builtins.str = ...,
        status: global___ModelDeploymentStatus.ValueType = ...,
        status_details: global___StatusDetails | None = ...,
        variation_name: builtins.str = ...,
        deployment_id: builtins.str = ...,
        model_uuid: builtins.str = ...,
        managed_by: global___DeploymentManagedBy.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["status_details", b"status_details"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch_id", b"branch_id", "deployment_id", b"deployment_id", "managed_by", b"managed_by", "model_id", b"model_id", "model_uuid", b"model_uuid", "status", b"status", "status_details", b"status_details", "variation_name", b"variation_name"]) -> None: ...

global___KubernetesModelDeploymentState = KubernetesModelDeploymentState

class StatusDetails(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PENDING_STATUS_DETAILS_FIELD_NUMBER: builtins.int
    SUCCESS_STATUS_DETAILS_FIELD_NUMBER: builtins.int
    FAILED_STATUS_DETAILS_FIELD_NUMBER: builtins.int
    @property
    def pending_status_details(self) -> global___PendingStatusDetails:
        """Detailed information about the Kubernetes pending status"""
    @property
    def success_status_details(self) -> global___SuccessfulStatusDetails:
        """Detailed information about the Kubernetes successful status"""
    @property
    def failed_status_details(self) -> global___FailedStatusDetails:
        """Detailed information about the Kubernetes failed status"""
    def __init__(
        self,
        *,
        pending_status_details: global___PendingStatusDetails | None = ...,
        success_status_details: global___SuccessfulStatusDetails | None = ...,
        failed_status_details: global___FailedStatusDetails | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["failed_status_details", b"failed_status_details", "pending_status_details", b"pending_status_details", "status_details", b"status_details", "success_status_details", b"success_status_details"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["failed_status_details", b"failed_status_details", "pending_status_details", b"pending_status_details", "status_details", b"status_details", "success_status_details", b"success_status_details"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["status_details", b"status_details"]) -> typing_extensions.Literal["pending_status_details", "success_status_details", "failed_status_details"] | None: ...

global___StatusDetails = StatusDetails

class PendingStatusDetails(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OLD_INSTANCE_FIELD_NUMBER: builtins.int
    NEW_INSTANCE_FIELD_NUMBER: builtins.int
    @property
    def old_instance(self) -> global___InstanceDetails:
        """Detailed information about the Kubernetes old instance"""
    @property
    def new_instance(self) -> global___InstanceDetails:
        """Detailed information about the Kubernetes new instance"""
    def __init__(
        self,
        *,
        old_instance: global___InstanceDetails | None = ...,
        new_instance: global___InstanceDetails | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["new_instance", b"new_instance", "old_instance", b"old_instance"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["new_instance", b"new_instance", "old_instance", b"old_instance"]) -> None: ...

global___PendingStatusDetails = PendingStatusDetails

class SuccessfulStatusDetails(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUNNING_INSTANCE_FIELD_NUMBER: builtins.int
    @property
    def running_instance(self) -> global___InstanceDetails:
        """Detailed information about the Kubernetes running instance"""
    def __init__(
        self,
        *,
        running_instance: global___InstanceDetails | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["running_instance", b"running_instance"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["running_instance", b"running_instance"]) -> None: ...

global___SuccessfulStatusDetails = SuccessfulStatusDetails

class FailedStatusDetails(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FAILURE_DETAILS_FIELD_NUMBER: builtins.int
    OLD_INSTANCE_FIELD_NUMBER: builtins.int
    FAILED_INSTANCE_FIELD_NUMBER: builtins.int
    @property
    def failure_details(self) -> global___FailureDetails:
        """Detailed information about the Kubernetes failure status"""
    @property
    def old_instance(self) -> global___InstanceDetails:
        """Detailed information about the Kubernetes old instance"""
    @property
    def failed_instance(self) -> global___InstanceDetails:
        """Detailed information about the Kubernetes failed instance"""
    def __init__(
        self,
        *,
        failure_details: global___FailureDetails | None = ...,
        old_instance: global___InstanceDetails | None = ...,
        failed_instance: global___InstanceDetails | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["failed_instance", b"failed_instance", "failure_details", b"failure_details", "old_instance", b"old_instance"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["failed_instance", b"failed_instance", "failure_details", b"failure_details", "old_instance", b"old_instance"]) -> None: ...

global___FailedStatusDetails = FailedStatusDetails

class FailureDetails(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEPLOYMENT_FAILURE_REASON_CODE_FIELD_NUMBER: builtins.int
    FAILURE_REASON_DETAILS_FIELD_NUMBER: builtins.int
    deployment_failure_reason_code: global___DeploymentFailureReasonCode.ValueType
    """The failure reason - Machine-readable"""
    failure_reason_details: builtins.str
    """The message describing the reason"""
    def __init__(
        self,
        *,
        deployment_failure_reason_code: global___DeploymentFailureReasonCode.ValueType = ...,
        failure_reason_details: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["deployment_failure_reason_code", b"deployment_failure_reason_code", "failure_reason_details", b"failure_reason_details"]) -> None: ...

global___FailureDetails = FailureDetails

class InstanceDetails(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEPLOYMENT_ID_FIELD_NUMBER: builtins.int
    BUILD_ID_FIELD_NUMBER: builtins.int
    AVAILABLE_REPLICAS_FIELD_NUMBER: builtins.int
    PODS_FIELD_NUMBER: builtins.int
    deployment_id: builtins.str
    """The deployment ID"""
    build_id: builtins.str
    """Build ID to deploy"""
    available_replicas: builtins.int
    """Available replicas"""
    @property
    def pods(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___ModelPodPhase.ValueType]:
        """The available pods"""
    def __init__(
        self,
        *,
        deployment_id: builtins.str = ...,
        build_id: builtins.str = ...,
        available_replicas: builtins.int = ...,
        pods: collections.abc.Iterable[global___ModelPodPhase.ValueType] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["available_replicas", b"available_replicas", "build_id", b"build_id", "deployment_id", b"deployment_id", "pods", b"pods"]) -> None: ...

global___InstanceDetails = InstanceDetails

class DeploymentPhasesDetails(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEPLOYMENT_PHASES_FIELD_NUMBER: builtins.int
    @property
    def deployment_phases(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DeploymentPhase]: ...
    def __init__(
        self,
        *,
        deployment_phases: collections.abc.Iterable[global___DeploymentPhase] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["deployment_phases", b"deployment_phases"]) -> None: ...

global___DeploymentPhasesDetails = DeploymentPhasesDetails

class DeploymentPhase(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEPLOYMENT_PHASE_TYPE_FIELD_NUMBER: builtins.int
    DEPLOYMENT_PHASE_STATUS_FIELD_NUMBER: builtins.int
    PHASE_DURATION_IN_SECONDS_FIELD_NUMBER: builtins.int
    STARTED_AT_FIELD_NUMBER: builtins.int
    LAST_MODIFIED_AT_FIELD_NUMBER: builtins.int
    DISPLAY_MESSAGE_FIELD_NUMBER: builtins.int
    deployment_phase_type: global___DeploymentPhaseType.ValueType
    """The deployment phase type"""
    deployment_phase_status: global___DeploymentPhaseStatus.ValueType
    """The deployment phase status"""
    phase_duration_in_seconds: builtins.int
    """The time the phase is running"""
    @property
    def started_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time the phase started at"""
    @property
    def last_modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When The phase last modified at"""
    display_message: builtins.str
    """The message to display about the phase."""
    def __init__(
        self,
        *,
        deployment_phase_type: global___DeploymentPhaseType.ValueType = ...,
        deployment_phase_status: global___DeploymentPhaseStatus.ValueType = ...,
        phase_duration_in_seconds: builtins.int = ...,
        started_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        last_modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        display_message: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["last_modified_at", b"last_modified_at", "started_at", b"started_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["deployment_phase_status", b"deployment_phase_status", "deployment_phase_type", b"deployment_phase_type", "display_message", b"display_message", "last_modified_at", b"last_modified_at", "phase_duration_in_seconds", b"phase_duration_in_seconds", "started_at", b"started_at"]) -> None: ...

global___DeploymentPhase = DeploymentPhase

class Variation(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    ENVIRONMENT_ID_FIELD_NUMBER: builtins.int
    TRAFFIC_FIELD_NUMBER: builtins.int
    PROTECTED_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The variation name"""
    environment_id: builtins.str
    """The environment the variation is deployed on"""
    @property
    def traffic(self) -> global___TrafficSpec:
        """Network traffic based spec"""
    protected: builtins.bool
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        environment_id: builtins.str = ...,
        traffic: global___TrafficSpec | None = ...,
        protected: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["spec", b"spec", "traffic", b"traffic"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["environment_id", b"environment_id", "name", b"name", "protected", b"protected", "spec", b"spec", "traffic", b"traffic"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["spec", b"spec"]) -> typing_extensions.Literal["traffic"] | None: ...

global___Variation = Variation

class TrafficSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERCENTAGE_FIELD_NUMBER: builtins.int
    IS_SHADOW_FIELD_NUMBER: builtins.int
    percentage: builtins.int
    """The percentage of network requests to take"""
    is_shadow: builtins.bool
    """Is the traffic of shadow type"""
    def __init__(
        self,
        *,
        percentage: builtins.int = ...,
        is_shadow: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["is_shadow", b"is_shadow", "percentage", b"percentage"]) -> None: ...

global___TrafficSpec = TrafficSpec

class FutureDeploymentSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRAFFIC_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def traffic_config(self) -> global___TrafficConfig:
        """The traffic config"""
    def __init__(
        self,
        *,
        traffic_config: global___TrafficConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["traffic_config", b"traffic_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["traffic_config", b"traffic_config"]) -> None: ...

global___FutureDeploymentSettings = FutureDeploymentSettings

class EnvironmentDeploymentMessage(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_ID_FIELD_NUMBER: builtins.int
    BRANCH_ID_FIELD_NUMBER: builtins.int
    BUILD_ID_FIELD_NUMBER: builtins.int
    QWAK_MODEL_REGISTRY_IDENTIFIER_FIELD_NUMBER: builtins.int
    HOSTING_SERVICE_FIELD_NUMBER: builtins.int
    MODEL_UUID_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """Model named ID, which will be used as a routing key for the model"""
    branch_id: builtins.str
    """Branch ID to deploy the model under"""
    build_id: builtins.str
    """Build ID (which must be successful) to deploy"""
    @property
    def qwak_model_registry_identifier(self) -> global___QwakModeRegistryIdentifier: ...
    @property
    def hosting_service(self) -> global___HostingService:
        """Downstream hosting service that will serve the Qwak model"""
    model_uuid: builtins.str
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
        branch_id: builtins.str = ...,
        build_id: builtins.str = ...,
        qwak_model_registry_identifier: global___QwakModeRegistryIdentifier | None = ...,
        hosting_service: global___HostingService | None = ...,
        model_uuid: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["build_id", b"build_id", "hosting_service", b"hosting_service", "image_identifier", b"image_identifier", "qwak_model_registry_identifier", b"qwak_model_registry_identifier"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch_id", b"branch_id", "build_id", b"build_id", "hosting_service", b"hosting_service", "image_identifier", b"image_identifier", "model_id", b"model_id", "model_uuid", b"model_uuid", "qwak_model_registry_identifier", b"qwak_model_registry_identifier"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["image_identifier", b"image_identifier"]) -> typing_extensions.Literal["build_id", "qwak_model_registry_identifier"] | None: ...

global___EnvironmentDeploymentMessage = EnvironmentDeploymentMessage

class EnvironmentDeploymentResultMessage(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEPLOYMENT_NAMED_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    INFO_FIELD_NUMBER: builtins.int
    deployment_named_id: builtins.str
    """ID of deployment - in order to check up on status changes"""
    status: global___ModelDeploymentStatus.ValueType
    """Status of deployment"""
    info: builtins.str
    """Additional info on the deployment"""
    def __init__(
        self,
        *,
        deployment_named_id: builtins.str = ...,
        status: global___ModelDeploymentStatus.ValueType = ...,
        info: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["deployment_named_id", b"deployment_named_id", "info", b"info", "status", b"status"]) -> None: ...

global___EnvironmentDeploymentResultMessage = EnvironmentDeploymentResultMessage

class EnvironmentUndeploymentMessage(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_ID_FIELD_NUMBER: builtins.int
    BRANCH_ID_FIELD_NUMBER: builtins.int
    HOSTING_SERVICE_TYPE_FIELD_NUMBER: builtins.int
    TRAFFIC_CONFIG_FIELD_NUMBER: builtins.int
    VARIATION_NAME_FIELD_NUMBER: builtins.int
    MODEL_UUID_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """Model named ID to undeploy"""
    branch_id: builtins.str
    """Branch ID to undeploy from"""
    hosting_service_type: global___DeploymentHostingServiceType.ValueType
    """The Hosting service to undeploy from"""
    @property
    def traffic_config(self) -> global___TrafficConfig:
        """Traffic Config"""
    variation_name: builtins.str
    """Deployment variation name"""
    model_uuid: builtins.str
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
        branch_id: builtins.str = ...,
        hosting_service_type: global___DeploymentHostingServiceType.ValueType = ...,
        traffic_config: global___TrafficConfig | None = ...,
        variation_name: builtins.str = ...,
        model_uuid: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["traffic_config", b"traffic_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch_id", b"branch_id", "hosting_service_type", b"hosting_service_type", "model_id", b"model_id", "model_uuid", b"model_uuid", "traffic_config", b"traffic_config", "variation_name", b"variation_name"]) -> None: ...

global___EnvironmentUndeploymentMessage = EnvironmentUndeploymentMessage

class EnvironmentUndeploymentResultMessage(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATUS_FIELD_NUMBER: builtins.int
    INFO_FIELD_NUMBER: builtins.int
    status: global___ModelDeploymentStatus.ValueType
    """Status of un-deployment"""
    info: builtins.str
    """Additional info on the undeployment"""
    def __init__(
        self,
        *,
        status: global___ModelDeploymentStatus.ValueType = ...,
        info: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["info", b"info", "status", b"status"]) -> None: ...

global___EnvironmentUndeploymentResultMessage = EnvironmentUndeploymentResultMessage

class EnvironmentRuntimeDeploymentSettingsMessage(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_ID_FIELD_NUMBER: builtins.int
    BRANCH_ID_FIELD_NUMBER: builtins.int
    DEPLOYMENT_SETTINGS_FIELD_NUMBER: builtins.int
    VARIATION_NAME_FIELD_NUMBER: builtins.int
    MODEL_UUID_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """Model named ID, which will be used as a routing key for the model"""
    branch_id: builtins.str
    """Branch ID which the model was deployed under"""
    @property
    def deployment_settings(self) -> global___RuntimeDeploymentSettings:
        """The new  deployment settings"""
    variation_name: builtins.str
    """Variation name"""
    model_uuid: builtins.str
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
        branch_id: builtins.str = ...,
        deployment_settings: global___RuntimeDeploymentSettings | None = ...,
        variation_name: builtins.str = ...,
        model_uuid: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["deployment_settings", b"deployment_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch_id", b"branch_id", "deployment_settings", b"deployment_settings", "model_id", b"model_id", "model_uuid", b"model_uuid", "variation_name", b"variation_name"]) -> None: ...

global___EnvironmentRuntimeDeploymentSettingsMessage = EnvironmentRuntimeDeploymentSettingsMessage

class EnvironmentRuntimeDeploymentSettingsResultMessage(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ERROR_INFO_FIELD_NUMBER: builtins.int
    error_info: builtins.str
    """Additional info"""
    def __init__(
        self,
        *,
        error_info: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["error_info", b"error_info"]) -> None: ...

global___EnvironmentRuntimeDeploymentSettingsResultMessage = EnvironmentRuntimeDeploymentSettingsResultMessage

class EnvironmentApplyModelTrafficResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INFO_FIELD_NUMBER: builtins.int
    info: builtins.str
    """Additional info"""
    def __init__(
        self,
        *,
        info: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["info", b"info"]) -> None: ...

global___EnvironmentApplyModelTrafficResponse = EnvironmentApplyModelTrafficResponse

class EnvironmentDeploymentDetailsMessage(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEPLOYMENTS_DETAILS_FIELD_NUMBER: builtins.int
    AUDIENCES_ROUTES_FIELD_NUMBER: builtins.int
    FALLBACK_VARIATION_FIELD_NUMBER: builtins.int
    @property
    def deployments_details(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DeploymentDetails]:
        """The current active deployments details"""
    @property
    def audiences_routes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[qwak.audience.v1.audience_pb2.AudienceRoutesEntry]:
        """audiences in the environment."""
    fallback_variation: builtins.str
    """fallback Variation saved for the model."""
    def __init__(
        self,
        *,
        deployments_details: collections.abc.Iterable[global___DeploymentDetails] | None = ...,
        audiences_routes: collections.abc.Iterable[qwak.audience.v1.audience_pb2.AudienceRoutesEntry] | None = ...,
        fallback_variation: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["audiences_routes", b"audiences_routes", "deployments_details", b"deployments_details", "fallback_variation", b"fallback_variation"]) -> None: ...

global___EnvironmentDeploymentDetailsMessage = EnvironmentDeploymentDetailsMessage

class EnvironmentDeploymentHistoryMessage(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEPLOYMENTS_FIELD_NUMBER: builtins.int
    @property
    def deployments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DeploymentBrief]:
        """All finalized deployments for specific branch"""
    def __init__(
        self,
        *,
        deployments: collections.abc.Iterable[global___DeploymentBrief] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["deployments", b"deployments"]) -> None: ...

global___EnvironmentDeploymentHistoryMessage = EnvironmentDeploymentHistoryMessage

class EnvironmentTrafficMessage(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VARIATIONS_FIELD_NUMBER: builtins.int
    @property
    def variations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Variation]:
        """The variations config"""
    def __init__(
        self,
        *,
        variations: collections.abc.Iterable[global___Variation] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["variations", b"variations"]) -> None: ...

global___EnvironmentTrafficMessage = EnvironmentTrafficMessage

class BuildDeploymentEnvironmentStatus(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class EnvironmentToDeploymentBriefEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___DeploymentBrief: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___DeploymentBrief | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ENVIRONMENT_TO_DEPLOYMENT_BRIEF_FIELD_NUMBER: builtins.int
    @property
    def environment_to_deployment_brief(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___DeploymentBrief]:
        """Environment id to deployment brief"""
    def __init__(
        self,
        *,
        environment_to_deployment_brief: collections.abc.Mapping[builtins.str, global___DeploymentBrief] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["environment_to_deployment_brief", b"environment_to_deployment_brief"]) -> None: ...

global___BuildDeploymentEnvironmentStatus = BuildDeploymentEnvironmentStatus

class BuildDeploymentStatus(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUILD_UUID_FIELD_NUMBER: builtins.int
    IS_DEPLOYED_FIELD_NUMBER: builtins.int
    IS_IN_USE_FIELD_NUMBER: builtins.int
    build_uuid: builtins.str
    is_deployed: builtins.bool
    is_in_use: builtins.bool
    def __init__(
        self,
        *,
        build_uuid: builtins.str = ...,
        is_deployed: builtins.bool = ...,
        is_in_use: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["build_uuid", b"build_uuid", "is_deployed", b"is_deployed", "is_in_use", b"is_in_use"]) -> None: ...

global___BuildDeploymentStatus = BuildDeploymentStatus

class CancelDeploymentRequestStatus(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CANCEL_REQUESTED_SUCCESSFULLY_FIELD_NUMBER: builtins.int
    ERROR_MESSAGE_FIELD_NUMBER: builtins.int
    cancel_requested_successfully: builtins.bool
    """Is requested successfully"""
    error_message: builtins.str
    """The error message"""
    def __init__(
        self,
        *,
        cancel_requested_successfully: builtins.bool = ...,
        error_message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cancel_requested_successfully", b"cancel_requested_successfully", "error_message", b"error_message"]) -> None: ...

global___CancelDeploymentRequestStatus = CancelDeploymentRequestStatus
