# fs-map

#### 项目简介
    Python内置文件和路径处理函数的集合和扩展。

#### 安装教程
```
pip install fs-map
```

#### 功能说明
* 集成函数
1. os 模块
``` python
# 函数列表
'''
listdir, 
mkdir, 
rename, 
replace, 
rmdir,
remove,
makedirs,
removedirs,
renames
'''

# 参考文档 
# https://docs.python.org/zh-cn/3/library/os.html#module-os
``` 
2. os.path 模块
``` python
# 函数列表
'''
exists, 
getsize, 
isdir, 
isfile, 
normcase, 
isabs, 
join, 
splitdrive, 
split, 
splitext, 
basename, 
dirname, 
normpath, 
abspath, 
realpath, 
relpath
'''

# 参考文档 
# https://docs.python.org/zh-cn/3/library/os.path.html#module-os.path
``` 
3. shutil 模块
``` python
# 函数列表
'''
copyfileobj, 
copyfile, 
copymode, 
copy, 
copy2, 
ignore_patterns, 
copytree, 
rmtree, 
move
'''

# 参考文档 
# https://docs.python.org/zh-cn/3/library/shutil.html#module-shutil
```
4. glob 模块
``` python
# 函数列表
'''
glob, 
glob0, 
glob1, 
iglob,
escape
'''

# 参考文档 
# https://docs.python.org/zh-cn/3/library/glob.html#module-glob
```

* 扩展函数
``` python
def get_filename(path):
    '''
    Returns a file name with a suffix
    '''

    _, filename = split(path)
    return filename


def get_filename1(path):
    '''
    Returns a file name that does not contain a suffix
    '''

    filename = get_filename(path)
    filename, _ = splitext(filename)
    return filename


def get_ext(path):
    '''
    Returns the file suffix
    '''

    _, ext = splitext(get_filename(path))
    return ext


def normcase1(path):
    '''
    Converts all characters in the path to lowercase and forward slashes to backslashes
    '''

    return normcase(path).replace('\\', '/')


def normpath1(path):
    '''
    Converts forward slashes in a path to backslashes
    '''

    return normpath(path).replace('\\', '/')
```

#### 实例
``` python
import fs


'''
集成函数实例
'''
# 判断文件是否存在
print(fs.exists('file.txt'))


'''
扩展函数实例
'''
# 获取文件后缀
print(fs.get_ext('c:/a/b/c.txt'))
# 输出结果：.txt

# 获取带后缀的文件名
print(fs.get_filename('c:/a/b/c.txt'))
# 输出结果：'c.txt'

# 获取不带后缀的文件名
print(fs.get_filename1('a.c.txt'))
# 输出结果：'a.c'

# 路径标准化的
print(fs.normcase1('c:\\A/b/c.txt'))
# 输出结果：c:/a/b/c.txt
print(fs.normpath1('c:\\A/b/c.txt'))
# 输出结果：c:/A/b/c.txt
```

#### 参考文献
https://docs.python.org/zh-cn/3/py-modindex.html