import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * Set to true if you want to treat skipped pipelines as if they finished with success.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#allow_merge_on_skipped_pipeline Project#allow_merge_on_skipped_pipeline}
    */
    readonly allowMergeOnSkippedPipeline?: boolean | cdktf.IResolvable;
    /**
    * Set the analytics access level. Valid values are `disabled`, `private`, `enabled`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#analytics_access_level Project#analytics_access_level}
    */
    readonly analyticsAccessLevel?: string;
    /**
    * Number of merge request approvals required for merging. Default is 0.
    This field **does not** work well in combination with the `gitlab_project_approval_rule` resource
    and is most likely gonna be deprecated in a future GitLab version (see [this upstream epic](https://gitlab.com/groups/gitlab-org/-/epics/7572)).
    In the meantime we recommend against using this attribute and use `gitlab_project_approval_rule` instead.
  
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#approvals_before_merge Project#approvals_before_merge}
    */
    readonly approvalsBeforeMerge?: number;
    /**
    * Set to `true` to archive the project instead of deleting on destroy. If set to `true` it will entire omit the `DELETE` operation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#archive_on_destroy Project#archive_on_destroy}
    */
    readonly archiveOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * Whether the project is in read-only mode (archived). Repositories can be archived/unarchived by toggling this parameter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#archived Project#archived}
    */
    readonly archived?: boolean | cdktf.IResolvable;
    /**
    * Auto-cancel pending pipelines. This isn’t a boolean, but enabled/disabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#auto_cancel_pending_pipelines Project#auto_cancel_pending_pipelines}
    */
    readonly autoCancelPendingPipelines?: string;
    /**
    * Auto Deploy strategy. Valid values are `continuous`, `manual`, `timed_incremental`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#auto_devops_deploy_strategy Project#auto_devops_deploy_strategy}
    */
    readonly autoDevopsDeployStrategy?: string;
    /**
    * Enable Auto DevOps for this project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#auto_devops_enabled Project#auto_devops_enabled}
    */
    readonly autoDevopsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Set whether auto-closing referenced issues on default branch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#autoclose_referenced_issues Project#autoclose_referenced_issues}
    */
    readonly autocloseReferencedIssues?: boolean | cdktf.IResolvable;
    /**
    * Test coverage parsing for the project. This is deprecated feature in GitLab 15.0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#build_coverage_regex Project#build_coverage_regex}
    */
    readonly buildCoverageRegex?: string;
    /**
    * The Git strategy. Defaults to fetch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#build_git_strategy Project#build_git_strategy}
    */
    readonly buildGitStrategy?: string;
    /**
    * The maximum amount of time, in seconds, that a job can run.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#build_timeout Project#build_timeout}
    */
    readonly buildTimeout?: number;
    /**
    * Set the builds access level. Valid values are `disabled`, `private`, `enabled`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#builds_access_level Project#builds_access_level}
    */
    readonly buildsAccessLevel?: string;
    /**
    * Custom Path to CI config file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#ci_config_path Project#ci_config_path}
    */
    readonly ciConfigPath?: string;
    /**
    * Default number of revisions for shallow cloning.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#ci_default_git_depth Project#ci_default_git_depth}
    */
    readonly ciDefaultGitDepth?: number;
    /**
    * When a new deployment job starts, skip older deployment jobs that are still pending.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#ci_forward_deployment_enabled Project#ci_forward_deployment_enabled}
    */
    readonly ciForwardDeploymentEnabled?: boolean | cdktf.IResolvable;
    /**
    * Set visibility of container registry, for this project. Valid values are `disabled`, `private`, `enabled`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#container_registry_access_level Project#container_registry_access_level}
    */
    readonly containerRegistryAccessLevel?: string;
    /**
    * Enable container registry for the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#container_registry_enabled Project#container_registry_enabled}
    */
    readonly containerRegistryEnabled?: boolean | cdktf.IResolvable;
    /**
    * The default branch for the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#default_branch Project#default_branch}
    */
    readonly defaultBranch?: string;
    /**
    * A description of the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#description Project#description}
    */
    readonly description?: string;
    /**
    * Disable email notifications.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#emails_disabled Project#emails_disabled}
    */
    readonly emailsDisabled?: boolean | cdktf.IResolvable;
    /**
    * The classification label for the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#external_authorization_classification_label Project#external_authorization_classification_label}
    */
    readonly externalAuthorizationClassificationLabel?: string;
    /**
    * Set the forking access level. Valid values are `disabled`, `private`, `enabled`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#forking_access_level Project#forking_access_level}
    */
    readonly forkingAccessLevel?: string;
    /**
    * For group-level custom templates, specifies ID of group from which all the custom project templates are sourced. Leave empty for instance-level templates. Requires use_custom_template to be true (enterprise edition).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#group_with_project_templates_id Project#group_with_project_templates_id}
    */
    readonly groupWithProjectTemplatesId?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#id Project#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Git URL to a repository to be imported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#import_url Project#import_url}
    */
    readonly importUrl?: string;
    /**
    * Create main branch with first commit containing a README.md file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#initialize_with_readme Project#initialize_with_readme}
    */
    readonly initializeWithReadme?: boolean | cdktf.IResolvable;
    /**
    * Set the issues access level. Valid values are `disabled`, `private`, `enabled`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#issues_access_level Project#issues_access_level}
    */
    readonly issuesAccessLevel?: string;
    /**
    * Enable issue tracking for the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#issues_enabled Project#issues_enabled}
    */
    readonly issuesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Sets the template for new issues in the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#issues_template Project#issues_template}
    */
    readonly issuesTemplate?: string;
    /**
    * Enable LFS for the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#lfs_enabled Project#lfs_enabled}
    */
    readonly lfsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Template used to create merge commit message in merge requests. (Introduced in GitLab 14.5.)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#merge_commit_template Project#merge_commit_template}
    */
    readonly mergeCommitTemplate?: string;
    /**
    * Set to `ff` to create fast-forward merges
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#merge_method Project#merge_method}
    */
    readonly mergeMethod?: string;
    /**
    * Enable or disable merge pipelines.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#merge_pipelines_enabled Project#merge_pipelines_enabled}
    */
    readonly mergePipelinesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Set the merge requests access level. Valid values are `disabled`, `private`, `enabled`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#merge_requests_access_level Project#merge_requests_access_level}
    */
    readonly mergeRequestsAccessLevel?: string;
    /**
    * Enable merge requests for the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#merge_requests_enabled Project#merge_requests_enabled}
    */
    readonly mergeRequestsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Sets the template for new merge requests in the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#merge_requests_template Project#merge_requests_template}
    */
    readonly mergeRequestsTemplate?: string;
    /**
    * Enable or disable merge trains. Requires `merge_pipelines_enabled` to be set to `true` to take effect.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#merge_trains_enabled Project#merge_trains_enabled}
    */
    readonly mergeTrainsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Enable project pull mirror.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#mirror Project#mirror}
    */
    readonly mirror?: boolean | cdktf.IResolvable;
    /**
    * Enable overwrite diverged branches for a mirrored project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#mirror_overwrites_diverged_branches Project#mirror_overwrites_diverged_branches}
    */
    readonly mirrorOverwritesDivergedBranches?: boolean | cdktf.IResolvable;
    /**
    * Enable trigger builds on pushes for a mirrored project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#mirror_trigger_builds Project#mirror_trigger_builds}
    */
    readonly mirrorTriggerBuilds?: boolean | cdktf.IResolvable;
    /**
    * The name of the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#name Project#name}
    */
    readonly name: string;
    /**
    * The namespace (group or user) of the project. Defaults to your user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#namespace_id Project#namespace_id}
    */
    readonly namespaceId?: number;
    /**
    * Set to true if you want allow merges only if all discussions are resolved.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#only_allow_merge_if_all_discussions_are_resolved Project#only_allow_merge_if_all_discussions_are_resolved}
    */
    readonly onlyAllowMergeIfAllDiscussionsAreResolved?: boolean | cdktf.IResolvable;
    /**
    * Set to true if you want allow merges only if a pipeline succeeds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#only_allow_merge_if_pipeline_succeeds Project#only_allow_merge_if_pipeline_succeeds}
    */
    readonly onlyAllowMergeIfPipelineSucceeds?: boolean | cdktf.IResolvable;
    /**
    * Enable only mirror protected branches for a mirrored project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#only_mirror_protected_branches Project#only_mirror_protected_branches}
    */
    readonly onlyMirrorProtectedBranches?: boolean | cdktf.IResolvable;
    /**
    * Set the operations access level. Valid values are `disabled`, `private`, `enabled`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#operations_access_level Project#operations_access_level}
    */
    readonly operationsAccessLevel?: string;
    /**
    * Enable packages repository for the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#packages_enabled Project#packages_enabled}
    */
    readonly packagesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Enable pages access control
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#pages_access_level Project#pages_access_level}
    */
    readonly pagesAccessLevel?: string;
    /**
    * The path of the repository.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#path Project#path}
    */
    readonly path?: string;
    /**
    * Enable pipelines for the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#pipelines_enabled Project#pipelines_enabled}
    */
    readonly pipelinesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Show link to create/view merge request when pushing from the command line
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#printing_merge_request_link_enabled Project#printing_merge_request_link_enabled}
    */
    readonly printingMergeRequestLinkEnabled?: boolean | cdktf.IResolvable;
    /**
    * If true, jobs can be viewed by non-project members.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#public_builds Project#public_builds}
    */
    readonly publicBuilds?: boolean | cdktf.IResolvable;
    /**
    * Enable `Delete source branch` option by default for all new merge requests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#remove_source_branch_after_merge Project#remove_source_branch_after_merge}
    */
    readonly removeSourceBranchAfterMerge?: boolean | cdktf.IResolvable;
    /**
    * Set the repository access level. Valid values are `disabled`, `private`, `enabled`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#repository_access_level Project#repository_access_level}
    */
    readonly repositoryAccessLevel?: string;
    /**
    * 	Which storage shard the repository is on. (administrator only)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#repository_storage Project#repository_storage}
    */
    readonly repositoryStorage?: string;
    /**
    * Allow users to request member access.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#request_access_enabled Project#request_access_enabled}
    */
    readonly requestAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Set the requirements access level. Valid values are `disabled`, `private`, `enabled`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#requirements_access_level Project#requirements_access_level}
    */
    readonly requirementsAccessLevel?: string;
    /**
    * Automatically resolve merge request diffs discussions on lines changed with a push.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#resolve_outdated_diff_discussions Project#resolve_outdated_diff_discussions}
    */
    readonly resolveOutdatedDiffDiscussions?: boolean | cdktf.IResolvable;
    /**
    * Set the security and compliance access level. Valid values are `disabled`, `private`, `enabled`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#security_and_compliance_access_level Project#security_and_compliance_access_level}
    */
    readonly securityAndComplianceAccessLevel?: string;
    /**
    * Enable shared runners for this project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#shared_runners_enabled Project#shared_runners_enabled}
    */
    readonly sharedRunnersEnabled?: boolean | cdktf.IResolvable;
    /**
    * If `true`, the default behavior to wait for the default branch protection to be created is skipped.
  This is necessary if the current user is not an admin and the default branch protection is disabled on an instance-level.
  There is currently no known way to determine if the default branch protection is disabled on an instance-level for non-admin users.
  This attribute is only used during resource creation, thus changes are suppressed and the attribute cannot be imported.
  
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#skip_wait_for_default_branch_protection Project#skip_wait_for_default_branch_protection}
    */
    readonly skipWaitForDefaultBranchProtection?: boolean | cdktf.IResolvable;
    /**
    * Set the snippets access level. Valid values are `disabled`, `private`, `enabled`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#snippets_access_level Project#snippets_access_level}
    */
    readonly snippetsAccessLevel?: string;
    /**
    * Enable snippets for the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#snippets_enabled Project#snippets_enabled}
    */
    readonly snippetsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Template used to create squash commit message in merge requests. (Introduced in GitLab 14.6.)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#squash_commit_template Project#squash_commit_template}
    */
    readonly squashCommitTemplate?: string;
    /**
    * Squash commits when merge request. Valid values are `never`, `always`, `default_on`, or `default_off`. The default value is `default_off`. [GitLab >= 14.1]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#squash_option Project#squash_option}
    */
    readonly squashOption?: string;
    /**
    * The list of tags for a project; put array of tags, that should be finally assigned to a project. Use topics instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#tags Project#tags}
    */
    readonly tags?: string[];
    /**
    * When used without use_custom_template, name of a built-in project template. When used with use_custom_template, name of a custom project template. This option is mutually exclusive with `template_project_id`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#template_name Project#template_name}
    */
    readonly templateName?: string;
    /**
    * When used with use_custom_template, project ID of a custom project template. This is preferable to using template_name since template_name may be ambiguous (enterprise edition). This option is mutually exclusive with `template_name`. See `gitlab_group_project_file_template` to set a project as a template project. If a project has not been set as a template, using it here will result in an error.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#template_project_id Project#template_project_id}
    */
    readonly templateProjectId?: number;
    /**
    * The list of topics for the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#topics Project#topics}
    */
    readonly topics?: string[];
    /**
    * Use either custom instance or group (with group_with_project_templates_id) project template (enterprise edition).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#use_custom_template Project#use_custom_template}
    */
    readonly useCustomTemplate?: boolean | cdktf.IResolvable;
    /**
    * Set to `public` to create a public project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#visibility_level Project#visibility_level}
    */
    readonly visibilityLevel?: string;
    /**
    * Set the wiki access level. Valid values are `disabled`, `private`, `enabled`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#wiki_access_level Project#wiki_access_level}
    */
    readonly wikiAccessLevel?: string;
    /**
    * Enable wiki for the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#wiki_enabled Project#wiki_enabled}
    */
    readonly wikiEnabled?: boolean | cdktf.IResolvable;
    /**
    * container_expiration_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#container_expiration_policy Project#container_expiration_policy}
    */
    readonly containerExpirationPolicy?: ProjectContainerExpirationPolicy;
    /**
    * push_rules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#push_rules Project#push_rules}
    */
    readonly pushRules?: ProjectPushRules;
}
export interface ProjectContainerExpirationPolicy {
    /**
    * The cadence of the policy. Valid values are: `1d`, `7d`, `14d`, `1month`, `3month`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#cadence Project#cadence}
    */
    readonly cadence?: string;
    /**
    * If true, the policy is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#enabled Project#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The number of images to keep.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#keep_n Project#keep_n}
    */
    readonly keepN?: number;
    /**
    * The regular expression to match image names to delete. **Note**: the upstream API has some inconsistencies with the `name_regex` field here. It's basically unusable at the moment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#name_regex_delete Project#name_regex_delete}
    */
    readonly nameRegexDelete?: string;
    /**
    * The regular expression to match image names to keep.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#name_regex_keep Project#name_regex_keep}
    */
    readonly nameRegexKeep?: string;
    /**
    * The number of days to keep images.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#older_than Project#older_than}
    */
    readonly olderThan?: string;
}
export declare function projectContainerExpirationPolicyToTerraform(struct?: ProjectContainerExpirationPolicyOutputReference | ProjectContainerExpirationPolicy): any;
export declare class ProjectContainerExpirationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ProjectContainerExpirationPolicy | undefined;
    set internalValue(value: ProjectContainerExpirationPolicy | undefined);
    private _cadence?;
    get cadence(): string;
    set cadence(value: string);
    resetCadence(): void;
    get cadenceInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _keepN?;
    get keepN(): number;
    set keepN(value: number);
    resetKeepN(): void;
    get keepNInput(): number | undefined;
    private _nameRegexDelete?;
    get nameRegexDelete(): string;
    set nameRegexDelete(value: string);
    resetNameRegexDelete(): void;
    get nameRegexDeleteInput(): string | undefined;
    private _nameRegexKeep?;
    get nameRegexKeep(): string;
    set nameRegexKeep(value: string);
    resetNameRegexKeep(): void;
    get nameRegexKeepInput(): string | undefined;
    get nextRunAt(): string;
    private _olderThan?;
    get olderThan(): string;
    set olderThan(value: string);
    resetOlderThan(): void;
    get olderThanInput(): string | undefined;
}
export interface ProjectPushRules {
    /**
    * All commit author emails must match this regex, e.g. `@my-company.com$`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#author_email_regex Project#author_email_regex}
    */
    readonly authorEmailRegex?: string;
    /**
    * All branch names must match this regex, e.g. `(feature|hotfix)\/*`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#branch_name_regex Project#branch_name_regex}
    */
    readonly branchNameRegex?: string;
    /**
    * Users can only push commits to this repository that were committed with one of their own verified emails.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#commit_committer_check Project#commit_committer_check}
    */
    readonly commitCommitterCheck?: boolean | cdktf.IResolvable;
    /**
    * No commit message is allowed to match this regex, for example `ssh\:\/\/`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#commit_message_negative_regex Project#commit_message_negative_regex}
    */
    readonly commitMessageNegativeRegex?: string;
    /**
    * All commit messages must match this regex, e.g. `Fixed \d+\..*`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#commit_message_regex Project#commit_message_regex}
    */
    readonly commitMessageRegex?: string;
    /**
    * Deny deleting a tag.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#deny_delete_tag Project#deny_delete_tag}
    */
    readonly denyDeleteTag?: boolean | cdktf.IResolvable;
    /**
    * All commited filenames must not match this regex, e.g. `(jar|exe)$`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#file_name_regex Project#file_name_regex}
    */
    readonly fileNameRegex?: string;
    /**
    * Maximum file size (MB).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#max_file_size Project#max_file_size}
    */
    readonly maxFileSize?: number;
    /**
    * Restrict commits by author (email) to existing GitLab users.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#member_check Project#member_check}
    */
    readonly memberCheck?: boolean | cdktf.IResolvable;
    /**
    * GitLab will reject any files that are likely to contain secrets.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#prevent_secrets Project#prevent_secrets}
    */
    readonly preventSecrets?: boolean | cdktf.IResolvable;
    /**
    * Reject commit when it’s not signed through GPG.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project#reject_unsigned_commits Project#reject_unsigned_commits}
    */
    readonly rejectUnsignedCommits?: boolean | cdktf.IResolvable;
}
export declare function projectPushRulesToTerraform(struct?: ProjectPushRulesOutputReference | ProjectPushRules): any;
export declare class ProjectPushRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ProjectPushRules | undefined;
    set internalValue(value: ProjectPushRules | undefined);
    private _authorEmailRegex?;
    get authorEmailRegex(): string;
    set authorEmailRegex(value: string);
    resetAuthorEmailRegex(): void;
    get authorEmailRegexInput(): string | undefined;
    private _branchNameRegex?;
    get branchNameRegex(): string;
    set branchNameRegex(value: string);
    resetBranchNameRegex(): void;
    get branchNameRegexInput(): string | undefined;
    private _commitCommitterCheck?;
    get commitCommitterCheck(): boolean | cdktf.IResolvable;
    set commitCommitterCheck(value: boolean | cdktf.IResolvable);
    resetCommitCommitterCheck(): void;
    get commitCommitterCheckInput(): boolean | cdktf.IResolvable | undefined;
    private _commitMessageNegativeRegex?;
    get commitMessageNegativeRegex(): string;
    set commitMessageNegativeRegex(value: string);
    resetCommitMessageNegativeRegex(): void;
    get commitMessageNegativeRegexInput(): string | undefined;
    private _commitMessageRegex?;
    get commitMessageRegex(): string;
    set commitMessageRegex(value: string);
    resetCommitMessageRegex(): void;
    get commitMessageRegexInput(): string | undefined;
    private _denyDeleteTag?;
    get denyDeleteTag(): boolean | cdktf.IResolvable;
    set denyDeleteTag(value: boolean | cdktf.IResolvable);
    resetDenyDeleteTag(): void;
    get denyDeleteTagInput(): boolean | cdktf.IResolvable | undefined;
    private _fileNameRegex?;
    get fileNameRegex(): string;
    set fileNameRegex(value: string);
    resetFileNameRegex(): void;
    get fileNameRegexInput(): string | undefined;
    private _maxFileSize?;
    get maxFileSize(): number;
    set maxFileSize(value: number);
    resetMaxFileSize(): void;
    get maxFileSizeInput(): number | undefined;
    private _memberCheck?;
    get memberCheck(): boolean | cdktf.IResolvable;
    set memberCheck(value: boolean | cdktf.IResolvable);
    resetMemberCheck(): void;
    get memberCheckInput(): boolean | cdktf.IResolvable | undefined;
    private _preventSecrets?;
    get preventSecrets(): boolean | cdktf.IResolvable;
    set preventSecrets(value: boolean | cdktf.IResolvable);
    resetPreventSecrets(): void;
    get preventSecretsInput(): boolean | cdktf.IResolvable | undefined;
    private _rejectUnsignedCommits?;
    get rejectUnsignedCommits(): boolean | cdktf.IResolvable;
    set rejectUnsignedCommits(value: boolean | cdktf.IResolvable);
    resetRejectUnsignedCommits(): void;
    get rejectUnsignedCommitsInput(): boolean | cdktf.IResolvable | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project gitlab_project}
*/
export declare class Project extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_project";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project gitlab_project} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectConfig
    */
    constructor(scope: Construct, id: string, config: ProjectConfig);
    private _allowMergeOnSkippedPipeline?;
    get allowMergeOnSkippedPipeline(): boolean | cdktf.IResolvable;
    set allowMergeOnSkippedPipeline(value: boolean | cdktf.IResolvable);
    resetAllowMergeOnSkippedPipeline(): void;
    get allowMergeOnSkippedPipelineInput(): boolean | cdktf.IResolvable | undefined;
    private _analyticsAccessLevel?;
    get analyticsAccessLevel(): string;
    set analyticsAccessLevel(value: string);
    resetAnalyticsAccessLevel(): void;
    get analyticsAccessLevelInput(): string | undefined;
    private _approvalsBeforeMerge?;
    get approvalsBeforeMerge(): number;
    set approvalsBeforeMerge(value: number);
    resetApprovalsBeforeMerge(): void;
    get approvalsBeforeMergeInput(): number | undefined;
    private _archiveOnDestroy?;
    get archiveOnDestroy(): boolean | cdktf.IResolvable;
    set archiveOnDestroy(value: boolean | cdktf.IResolvable);
    resetArchiveOnDestroy(): void;
    get archiveOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _archived?;
    get archived(): boolean | cdktf.IResolvable;
    set archived(value: boolean | cdktf.IResolvable);
    resetArchived(): void;
    get archivedInput(): boolean | cdktf.IResolvable | undefined;
    private _autoCancelPendingPipelines?;
    get autoCancelPendingPipelines(): string;
    set autoCancelPendingPipelines(value: string);
    resetAutoCancelPendingPipelines(): void;
    get autoCancelPendingPipelinesInput(): string | undefined;
    private _autoDevopsDeployStrategy?;
    get autoDevopsDeployStrategy(): string;
    set autoDevopsDeployStrategy(value: string);
    resetAutoDevopsDeployStrategy(): void;
    get autoDevopsDeployStrategyInput(): string | undefined;
    private _autoDevopsEnabled?;
    get autoDevopsEnabled(): boolean | cdktf.IResolvable;
    set autoDevopsEnabled(value: boolean | cdktf.IResolvable);
    resetAutoDevopsEnabled(): void;
    get autoDevopsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _autocloseReferencedIssues?;
    get autocloseReferencedIssues(): boolean | cdktf.IResolvable;
    set autocloseReferencedIssues(value: boolean | cdktf.IResolvable);
    resetAutocloseReferencedIssues(): void;
    get autocloseReferencedIssuesInput(): boolean | cdktf.IResolvable | undefined;
    private _buildCoverageRegex?;
    get buildCoverageRegex(): string;
    set buildCoverageRegex(value: string);
    resetBuildCoverageRegex(): void;
    get buildCoverageRegexInput(): string | undefined;
    private _buildGitStrategy?;
    get buildGitStrategy(): string;
    set buildGitStrategy(value: string);
    resetBuildGitStrategy(): void;
    get buildGitStrategyInput(): string | undefined;
    private _buildTimeout?;
    get buildTimeout(): number;
    set buildTimeout(value: number);
    resetBuildTimeout(): void;
    get buildTimeoutInput(): number | undefined;
    private _buildsAccessLevel?;
    get buildsAccessLevel(): string;
    set buildsAccessLevel(value: string);
    resetBuildsAccessLevel(): void;
    get buildsAccessLevelInput(): string | undefined;
    private _ciConfigPath?;
    get ciConfigPath(): string;
    set ciConfigPath(value: string);
    resetCiConfigPath(): void;
    get ciConfigPathInput(): string | undefined;
    private _ciDefaultGitDepth?;
    get ciDefaultGitDepth(): number;
    set ciDefaultGitDepth(value: number);
    resetCiDefaultGitDepth(): void;
    get ciDefaultGitDepthInput(): number | undefined;
    private _ciForwardDeploymentEnabled?;
    get ciForwardDeploymentEnabled(): boolean | cdktf.IResolvable;
    set ciForwardDeploymentEnabled(value: boolean | cdktf.IResolvable);
    resetCiForwardDeploymentEnabled(): void;
    get ciForwardDeploymentEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _containerRegistryAccessLevel?;
    get containerRegistryAccessLevel(): string;
    set containerRegistryAccessLevel(value: string);
    resetContainerRegistryAccessLevel(): void;
    get containerRegistryAccessLevelInput(): string | undefined;
    private _containerRegistryEnabled?;
    get containerRegistryEnabled(): boolean | cdktf.IResolvable;
    set containerRegistryEnabled(value: boolean | cdktf.IResolvable);
    resetContainerRegistryEnabled(): void;
    get containerRegistryEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultBranch?;
    get defaultBranch(): string;
    set defaultBranch(value: string);
    resetDefaultBranch(): void;
    get defaultBranchInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _emailsDisabled?;
    get emailsDisabled(): boolean | cdktf.IResolvable;
    set emailsDisabled(value: boolean | cdktf.IResolvable);
    resetEmailsDisabled(): void;
    get emailsDisabledInput(): boolean | cdktf.IResolvable | undefined;
    private _externalAuthorizationClassificationLabel?;
    get externalAuthorizationClassificationLabel(): string;
    set externalAuthorizationClassificationLabel(value: string);
    resetExternalAuthorizationClassificationLabel(): void;
    get externalAuthorizationClassificationLabelInput(): string | undefined;
    private _forkingAccessLevel?;
    get forkingAccessLevel(): string;
    set forkingAccessLevel(value: string);
    resetForkingAccessLevel(): void;
    get forkingAccessLevelInput(): string | undefined;
    private _groupWithProjectTemplatesId?;
    get groupWithProjectTemplatesId(): number;
    set groupWithProjectTemplatesId(value: number);
    resetGroupWithProjectTemplatesId(): void;
    get groupWithProjectTemplatesIdInput(): number | undefined;
    get httpUrlToRepo(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _importUrl?;
    get importUrl(): string;
    set importUrl(value: string);
    resetImportUrl(): void;
    get importUrlInput(): string | undefined;
    private _initializeWithReadme?;
    get initializeWithReadme(): boolean | cdktf.IResolvable;
    set initializeWithReadme(value: boolean | cdktf.IResolvable);
    resetInitializeWithReadme(): void;
    get initializeWithReadmeInput(): boolean | cdktf.IResolvable | undefined;
    private _issuesAccessLevel?;
    get issuesAccessLevel(): string;
    set issuesAccessLevel(value: string);
    resetIssuesAccessLevel(): void;
    get issuesAccessLevelInput(): string | undefined;
    private _issuesEnabled?;
    get issuesEnabled(): boolean | cdktf.IResolvable;
    set issuesEnabled(value: boolean | cdktf.IResolvable);
    resetIssuesEnabled(): void;
    get issuesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _issuesTemplate?;
    get issuesTemplate(): string;
    set issuesTemplate(value: string);
    resetIssuesTemplate(): void;
    get issuesTemplateInput(): string | undefined;
    private _lfsEnabled?;
    get lfsEnabled(): boolean | cdktf.IResolvable;
    set lfsEnabled(value: boolean | cdktf.IResolvable);
    resetLfsEnabled(): void;
    get lfsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _mergeCommitTemplate?;
    get mergeCommitTemplate(): string;
    set mergeCommitTemplate(value: string);
    resetMergeCommitTemplate(): void;
    get mergeCommitTemplateInput(): string | undefined;
    private _mergeMethod?;
    get mergeMethod(): string;
    set mergeMethod(value: string);
    resetMergeMethod(): void;
    get mergeMethodInput(): string | undefined;
    private _mergePipelinesEnabled?;
    get mergePipelinesEnabled(): boolean | cdktf.IResolvable;
    set mergePipelinesEnabled(value: boolean | cdktf.IResolvable);
    resetMergePipelinesEnabled(): void;
    get mergePipelinesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _mergeRequestsAccessLevel?;
    get mergeRequestsAccessLevel(): string;
    set mergeRequestsAccessLevel(value: string);
    resetMergeRequestsAccessLevel(): void;
    get mergeRequestsAccessLevelInput(): string | undefined;
    private _mergeRequestsEnabled?;
    get mergeRequestsEnabled(): boolean | cdktf.IResolvable;
    set mergeRequestsEnabled(value: boolean | cdktf.IResolvable);
    resetMergeRequestsEnabled(): void;
    get mergeRequestsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _mergeRequestsTemplate?;
    get mergeRequestsTemplate(): string;
    set mergeRequestsTemplate(value: string);
    resetMergeRequestsTemplate(): void;
    get mergeRequestsTemplateInput(): string | undefined;
    private _mergeTrainsEnabled?;
    get mergeTrainsEnabled(): boolean | cdktf.IResolvable;
    set mergeTrainsEnabled(value: boolean | cdktf.IResolvable);
    resetMergeTrainsEnabled(): void;
    get mergeTrainsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _mirror?;
    get mirror(): boolean | cdktf.IResolvable;
    set mirror(value: boolean | cdktf.IResolvable);
    resetMirror(): void;
    get mirrorInput(): boolean | cdktf.IResolvable | undefined;
    private _mirrorOverwritesDivergedBranches?;
    get mirrorOverwritesDivergedBranches(): boolean | cdktf.IResolvable;
    set mirrorOverwritesDivergedBranches(value: boolean | cdktf.IResolvable);
    resetMirrorOverwritesDivergedBranches(): void;
    get mirrorOverwritesDivergedBranchesInput(): boolean | cdktf.IResolvable | undefined;
    private _mirrorTriggerBuilds?;
    get mirrorTriggerBuilds(): boolean | cdktf.IResolvable;
    set mirrorTriggerBuilds(value: boolean | cdktf.IResolvable);
    resetMirrorTriggerBuilds(): void;
    get mirrorTriggerBuildsInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespaceId?;
    get namespaceId(): number;
    set namespaceId(value: number);
    resetNamespaceId(): void;
    get namespaceIdInput(): number | undefined;
    private _onlyAllowMergeIfAllDiscussionsAreResolved?;
    get onlyAllowMergeIfAllDiscussionsAreResolved(): boolean | cdktf.IResolvable;
    set onlyAllowMergeIfAllDiscussionsAreResolved(value: boolean | cdktf.IResolvable);
    resetOnlyAllowMergeIfAllDiscussionsAreResolved(): void;
    get onlyAllowMergeIfAllDiscussionsAreResolvedInput(): boolean | cdktf.IResolvable | undefined;
    private _onlyAllowMergeIfPipelineSucceeds?;
    get onlyAllowMergeIfPipelineSucceeds(): boolean | cdktf.IResolvable;
    set onlyAllowMergeIfPipelineSucceeds(value: boolean | cdktf.IResolvable);
    resetOnlyAllowMergeIfPipelineSucceeds(): void;
    get onlyAllowMergeIfPipelineSucceedsInput(): boolean | cdktf.IResolvable | undefined;
    private _onlyMirrorProtectedBranches?;
    get onlyMirrorProtectedBranches(): boolean | cdktf.IResolvable;
    set onlyMirrorProtectedBranches(value: boolean | cdktf.IResolvable);
    resetOnlyMirrorProtectedBranches(): void;
    get onlyMirrorProtectedBranchesInput(): boolean | cdktf.IResolvable | undefined;
    private _operationsAccessLevel?;
    get operationsAccessLevel(): string;
    set operationsAccessLevel(value: string);
    resetOperationsAccessLevel(): void;
    get operationsAccessLevelInput(): string | undefined;
    private _packagesEnabled?;
    get packagesEnabled(): boolean | cdktf.IResolvable;
    set packagesEnabled(value: boolean | cdktf.IResolvable);
    resetPackagesEnabled(): void;
    get packagesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _pagesAccessLevel?;
    get pagesAccessLevel(): string;
    set pagesAccessLevel(value: string);
    resetPagesAccessLevel(): void;
    get pagesAccessLevelInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    get pathWithNamespace(): string;
    private _pipelinesEnabled?;
    get pipelinesEnabled(): boolean | cdktf.IResolvable;
    set pipelinesEnabled(value: boolean | cdktf.IResolvable);
    resetPipelinesEnabled(): void;
    get pipelinesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _printingMergeRequestLinkEnabled?;
    get printingMergeRequestLinkEnabled(): boolean | cdktf.IResolvable;
    set printingMergeRequestLinkEnabled(value: boolean | cdktf.IResolvable);
    resetPrintingMergeRequestLinkEnabled(): void;
    get printingMergeRequestLinkEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _publicBuilds?;
    get publicBuilds(): boolean | cdktf.IResolvable;
    set publicBuilds(value: boolean | cdktf.IResolvable);
    resetPublicBuilds(): void;
    get publicBuildsInput(): boolean | cdktf.IResolvable | undefined;
    private _removeSourceBranchAfterMerge?;
    get removeSourceBranchAfterMerge(): boolean | cdktf.IResolvable;
    set removeSourceBranchAfterMerge(value: boolean | cdktf.IResolvable);
    resetRemoveSourceBranchAfterMerge(): void;
    get removeSourceBranchAfterMergeInput(): boolean | cdktf.IResolvable | undefined;
    private _repositoryAccessLevel?;
    get repositoryAccessLevel(): string;
    set repositoryAccessLevel(value: string);
    resetRepositoryAccessLevel(): void;
    get repositoryAccessLevelInput(): string | undefined;
    private _repositoryStorage?;
    get repositoryStorage(): string;
    set repositoryStorage(value: string);
    resetRepositoryStorage(): void;
    get repositoryStorageInput(): string | undefined;
    private _requestAccessEnabled?;
    get requestAccessEnabled(): boolean | cdktf.IResolvable;
    set requestAccessEnabled(value: boolean | cdktf.IResolvable);
    resetRequestAccessEnabled(): void;
    get requestAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _requirementsAccessLevel?;
    get requirementsAccessLevel(): string;
    set requirementsAccessLevel(value: string);
    resetRequirementsAccessLevel(): void;
    get requirementsAccessLevelInput(): string | undefined;
    private _resolveOutdatedDiffDiscussions?;
    get resolveOutdatedDiffDiscussions(): boolean | cdktf.IResolvable;
    set resolveOutdatedDiffDiscussions(value: boolean | cdktf.IResolvable);
    resetResolveOutdatedDiffDiscussions(): void;
    get resolveOutdatedDiffDiscussionsInput(): boolean | cdktf.IResolvable | undefined;
    get runnersToken(): string;
    private _securityAndComplianceAccessLevel?;
    get securityAndComplianceAccessLevel(): string;
    set securityAndComplianceAccessLevel(value: string);
    resetSecurityAndComplianceAccessLevel(): void;
    get securityAndComplianceAccessLevelInput(): string | undefined;
    private _sharedRunnersEnabled?;
    get sharedRunnersEnabled(): boolean | cdktf.IResolvable;
    set sharedRunnersEnabled(value: boolean | cdktf.IResolvable);
    resetSharedRunnersEnabled(): void;
    get sharedRunnersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _skipWaitForDefaultBranchProtection?;
    get skipWaitForDefaultBranchProtection(): boolean | cdktf.IResolvable;
    set skipWaitForDefaultBranchProtection(value: boolean | cdktf.IResolvable);
    resetSkipWaitForDefaultBranchProtection(): void;
    get skipWaitForDefaultBranchProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _snippetsAccessLevel?;
    get snippetsAccessLevel(): string;
    set snippetsAccessLevel(value: string);
    resetSnippetsAccessLevel(): void;
    get snippetsAccessLevelInput(): string | undefined;
    private _snippetsEnabled?;
    get snippetsEnabled(): boolean | cdktf.IResolvable;
    set snippetsEnabled(value: boolean | cdktf.IResolvable);
    resetSnippetsEnabled(): void;
    get snippetsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _squashCommitTemplate?;
    get squashCommitTemplate(): string;
    set squashCommitTemplate(value: string);
    resetSquashCommitTemplate(): void;
    get squashCommitTemplateInput(): string | undefined;
    private _squashOption?;
    get squashOption(): string;
    set squashOption(value: string);
    resetSquashOption(): void;
    get squashOptionInput(): string | undefined;
    get sshUrlToRepo(): string;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _templateName?;
    get templateName(): string;
    set templateName(value: string);
    resetTemplateName(): void;
    get templateNameInput(): string | undefined;
    private _templateProjectId?;
    get templateProjectId(): number;
    set templateProjectId(value: number);
    resetTemplateProjectId(): void;
    get templateProjectIdInput(): number | undefined;
    private _topics?;
    get topics(): string[];
    set topics(value: string[]);
    resetTopics(): void;
    get topicsInput(): string[] | undefined;
    private _useCustomTemplate?;
    get useCustomTemplate(): boolean | cdktf.IResolvable;
    set useCustomTemplate(value: boolean | cdktf.IResolvable);
    resetUseCustomTemplate(): void;
    get useCustomTemplateInput(): boolean | cdktf.IResolvable | undefined;
    private _visibilityLevel?;
    get visibilityLevel(): string;
    set visibilityLevel(value: string);
    resetVisibilityLevel(): void;
    get visibilityLevelInput(): string | undefined;
    get webUrl(): string;
    private _wikiAccessLevel?;
    get wikiAccessLevel(): string;
    set wikiAccessLevel(value: string);
    resetWikiAccessLevel(): void;
    get wikiAccessLevelInput(): string | undefined;
    private _wikiEnabled?;
    get wikiEnabled(): boolean | cdktf.IResolvable;
    set wikiEnabled(value: boolean | cdktf.IResolvable);
    resetWikiEnabled(): void;
    get wikiEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _containerExpirationPolicy;
    get containerExpirationPolicy(): ProjectContainerExpirationPolicyOutputReference;
    putContainerExpirationPolicy(value: ProjectContainerExpirationPolicy): void;
    resetContainerExpirationPolicy(): void;
    get containerExpirationPolicyInput(): ProjectContainerExpirationPolicy | undefined;
    private _pushRules;
    get pushRules(): ProjectPushRulesOutputReference;
    putPushRules(value: ProjectPushRules): void;
    resetPushRules(): void;
    get pushRulesInput(): ProjectPushRules | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
