"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnAction = exports.PropsUtil = exports.DeploymentPlan = exports.AttiniDeploymentPlanStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
const constructs_1 = require("constructs");
class AttiniDeploymentPlanStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.addTransform('AttiniDeploymentPlan');
        this.addTransform('AWS::Serverless-2016-10-31');
    }
}
exports.AttiniDeploymentPlanStack = AttiniDeploymentPlanStack;
_a = JSII_RTTI_SYMBOL_1;
AttiniDeploymentPlanStack[_a] = { fqn: "@attini/cdk.AttiniDeploymentPlanStack", version: "1.0.1" };
class DeploymentPlan extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        new aws_cdk_lib_1.CfnResource(this, id, {
            type: 'Attini::Deploy::DeploymentPlan',
            properties: {
                DeploymentPlan: new aws_stepfunctions_1.StateGraph(props.definition.startState, 'not important').toGraphJson(),
            },
        });
    }
}
exports.DeploymentPlan = DeploymentPlan;
_b = JSII_RTTI_SYMBOL_1;
DeploymentPlan[_b] = { fqn: "@attini/cdk.DeploymentPlan", version: "1.0.1" };
class PropsUtil {
    static fixCase(props) {
        let copy = {};
        Object.entries(props).forEach(([key, value]) => {
            copy[key.charAt(0).toUpperCase() + key.slice(1)] = value;
        });
        return copy;
    }
}
exports.PropsUtil = PropsUtil;
_c = JSII_RTTI_SYMBOL_1;
PropsUtil[_c] = { fqn: "@attini/cdk.PropsUtil", version: "1.0.1" };
var CfnAction;
(function (CfnAction) {
    CfnAction[CfnAction["DEPLOY"] = 0] = "DEPLOY";
    CfnAction[CfnAction["DELETE"] = 1] = "DELETE";
})(CfnAction = exports.CfnAction || (exports.CfnAction = {}));
__exportStar(require("./attini-state"), exports);
__exportStar(require("./attini-merge"), exports);
__exportStar(require("./attini-runner-job"), exports);
__exportStar(require("./attini-cfn"), exports);
__exportStar(require("./attini-manual-approval"), exports);
__exportStar(require("./attini-import"), exports);
__exportStar(require("./attini-lambda-invoke"), exports);
__exportStar(require("./attini-sam"), exports);
__exportStar(require("./attini-task"), exports);
__exportStar(require("./attini-runner"), exports);
__exportStar(require("./attini-cdk"), exports);
//# sourceMappingURL=data:application/json;base64,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