"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttiniCdk = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
const attini_task_1 = require("./attini-task");
const index_1 = require("./index");
/**
 * The AttiniCdk step allows you to deploy CDK projects as part of your deployment plan.
 */
class AttiniCdk extends attini_task_1.AttiniTask {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.type = 'AttiniCdk';
        this.props = props;
    }
    renderProps() {
        let { buildCommands: _, ...copy } = this.props;
        if (this.props.stackConfiguration) {
            copy.stackConfiguration = this.props.stackConfiguration?.map(value => index_1.PropsUtil.fixCase(value));
        }
        if (this.props.buildCommands) {
            copy.build = this.props.buildCommands;
        }
        return { Properties: aws_stepfunctions_1.FieldUtils.renderObject(index_1.PropsUtil.fixCase(copy)) };
    }
}
exports.AttiniCdk = AttiniCdk;
_a = JSII_RTTI_SYMBOL_1;
AttiniCdk[_a] = { fqn: "@attini/cdk.AttiniCdk", version: "1.0.1" };
//# sourceMappingURL=data:application/json;base64,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