# pied-piper-sdwan-sdk
The vManage API exposes the functionality of operations maintaining devices and the overlay network

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.0.0
- Package version: 1.0.47
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/oshafran/pied-piper-openapi-client-python.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/oshafran/pied-piper-openapi-client-python.git`)

Then import the package:
```python
import openapi_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import openapi_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import openapi_client
from pprint import pprint
from openapi_client.api import administration_audit_log_api
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)



# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = administration_audit_log_api.AdministrationAuditLogApi(api_client)
    query = "query_example" # str | Query filter (optional)
    page = 1 # int | page number (optional)
    page_size = 1 # int | page size (optional)
    sort_by = "sortBy_example" # str | sort by (optional)
    sort_order = "sortOrder_example" # str | sort order (optional)

    try:
        api_response = api_instance.generate_audit_log(query=query, page=page, page_size=page_size, sort_by=sort_by, sort_order=sort_order)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling AdministrationAuditLogApi->generate_audit_log: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://1.1.1.1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdministrationAuditLogApi* | [**generate_audit_log**](docs/AdministrationAuditLogApi.md#generate_audit_log) | **GET** /auditlog/severity | 
*AdministrationAuditLogApi* | [**get_audit_severity_custom_histogram**](docs/AdministrationAuditLogApi.md#get_audit_severity_custom_histogram) | **GET** /auditlog/severity/summary | 
*AdministrationAuditLogApi* | [**get_count**](docs/AdministrationAuditLogApi.md#get_count) | **GET** /auditlog/doccount | 
*AdministrationAuditLogApi* | [**get_count_post**](docs/AdministrationAuditLogApi.md#get_count_post) | **POST** /auditlog/doccount | 
*AdministrationAuditLogApi* | [**get_post_property_aggregation_data**](docs/AdministrationAuditLogApi.md#get_post_property_aggregation_data) | **POST** /auditlog/aggregation | 
*AdministrationAuditLogApi* | [**get_post_stat_bulk_raw_property_data**](docs/AdministrationAuditLogApi.md#get_post_stat_bulk_raw_property_data) | **POST** /auditlog/page | 
*AdministrationAuditLogApi* | [**get_property_aggregation_data**](docs/AdministrationAuditLogApi.md#get_property_aggregation_data) | **GET** /auditlog/aggregation | 
*AdministrationAuditLogApi* | [**get_raw_property_data**](docs/AdministrationAuditLogApi.md#get_raw_property_data) | **POST** /auditlog | 
*AdministrationAuditLogApi* | [**get_stat_bulk_raw_property_data**](docs/AdministrationAuditLogApi.md#get_stat_bulk_raw_property_data) | **GET** /auditlog/page | 
*AdministrationAuditLogApi* | [**get_stat_data_fields**](docs/AdministrationAuditLogApi.md#get_stat_data_fields) | **GET** /auditlog/fields | 
*AdministrationAuditLogApi* | [**get_stat_data_raw_audit_log_data**](docs/AdministrationAuditLogApi.md#get_stat_data_raw_audit_log_data) | **GET** /auditlog | 
*AdministrationAuditLogApi* | [**get_stat_query_fields**](docs/AdministrationAuditLogApi.md#get_stat_query_fields) | **GET** /auditlog/query/fields | 
*AdministrationUserAndGroupApi* | [**create_colo_group**](docs/AdministrationUserAndGroupApi.md#create_colo_group) | **POST** /admin/cologroup | 
*AdministrationUserAndGroupApi* | [**create_group_grid_columns**](docs/AdministrationUserAndGroupApi.md#create_group_grid_columns) | **GET** /admin/usergroup/definition | 
*AdministrationUserAndGroupApi* | [**create_user**](docs/AdministrationUserAndGroupApi.md#create_user) | **POST** /admin/user | 
*AdministrationUserAndGroupApi* | [**create_user_group**](docs/AdministrationUserAndGroupApi.md#create_user_group) | **POST** /admin/usergroup | 
*AdministrationUserAndGroupApi* | [**create_vpn_group**](docs/AdministrationUserAndGroupApi.md#create_vpn_group) | **POST** /admin/vpngroup | 
*AdministrationUserAndGroupApi* | [**delete_colo_group**](docs/AdministrationUserAndGroupApi.md#delete_colo_group) | **DELETE** /admin/cologroup/{id} | 
*AdministrationUserAndGroupApi* | [**delete_user**](docs/AdministrationUserAndGroupApi.md#delete_user) | **DELETE** /admin/user/{userName} | 
*AdministrationUserAndGroupApi* | [**delete_user_group**](docs/AdministrationUserAndGroupApi.md#delete_user_group) | **DELETE** /admin/usergroup/{userGroupId} | 
*AdministrationUserAndGroupApi* | [**delete_vpn_group**](docs/AdministrationUserAndGroupApi.md#delete_vpn_group) | **DELETE** /admin/vpngroup/{id} | 
*AdministrationUserAndGroupApi* | [**edit_colo_group**](docs/AdministrationUserAndGroupApi.md#edit_colo_group) | **PUT** /admin/cologroup/{id} | 
*AdministrationUserAndGroupApi* | [**edit_vpn_group**](docs/AdministrationUserAndGroupApi.md#edit_vpn_group) | **PUT** /admin/vpngroup/{id} | 
*AdministrationUserAndGroupApi* | [**find_user_auth_type**](docs/AdministrationUserAndGroupApi.md#find_user_auth_type) | **GET** /admin/user/userAuthType | 
*AdministrationUserAndGroupApi* | [**find_user_groups**](docs/AdministrationUserAndGroupApi.md#find_user_groups) | **GET** /admin/usergroup | 
*AdministrationUserAndGroupApi* | [**find_user_groups_as_key_value**](docs/AdministrationUserAndGroupApi.md#find_user_groups_as_key_value) | **GET** /admin/usergroup/keyvalue | 
*AdministrationUserAndGroupApi* | [**find_user_role**](docs/AdministrationUserAndGroupApi.md#find_user_role) | **GET** /admin/user/role | 
*AdministrationUserAndGroupApi* | [**find_users**](docs/AdministrationUserAndGroupApi.md#find_users) | **GET** /admin/user | 
*AdministrationUserAndGroupApi* | [**get_active_sessions**](docs/AdministrationUserAndGroupApi.md#get_active_sessions) | **GET** /admin/user/activeSessions | 
*AdministrationUserAndGroupApi* | [**get_colo_groups**](docs/AdministrationUserAndGroupApi.md#get_colo_groups) | **GET** /admin/cologroup | 
*AdministrationUserAndGroupApi* | [**get_vpn_groups**](docs/AdministrationUserAndGroupApi.md#get_vpn_groups) | **GET** /admin/vpngroup | 
*AdministrationUserAndGroupApi* | [**remove_sessions**](docs/AdministrationUserAndGroupApi.md#remove_sessions) | **DELETE** /admin/user/removeSessions | 
*AdministrationUserAndGroupApi* | [**reset_user**](docs/AdministrationUserAndGroupApi.md#reset_user) | **POST** /admin/user/reset | 
*AdministrationUserAndGroupApi* | [**resource_group**](docs/AdministrationUserAndGroupApi.md#resource_group) | **GET** /admin/resourcegroup | 
*AdministrationUserAndGroupApi* | [**resource_group1**](docs/AdministrationUserAndGroupApi.md#resource_group1) | **POST** /admin/resourcegroup/switch | 
*AdministrationUserAndGroupApi* | [**resource_group2**](docs/AdministrationUserAndGroupApi.md#resource_group2) | **PUT** /admin/resourcegroup/{groupId} | 
*AdministrationUserAndGroupApi* | [**resource_group3**](docs/AdministrationUserAndGroupApi.md#resource_group3) | **DELETE** /admin/resourcegroup/{groupId} | 
*AdministrationUserAndGroupApi* | [**resource_group4**](docs/AdministrationUserAndGroupApi.md#resource_group4) | **POST** /admin/resourcegroup | 
*AdministrationUserAndGroupApi* | [**resource_group_name**](docs/AdministrationUserAndGroupApi.md#resource_group_name) | **GET** /admin/user/resourceGroupName | 
*AdministrationUserAndGroupApi* | [**update_admin_password**](docs/AdministrationUserAndGroupApi.md#update_admin_password) | **POST** /admin/user/admin/password | 
*AdministrationUserAndGroupApi* | [**update_password**](docs/AdministrationUserAndGroupApi.md#update_password) | **PUT** /admin/user/password/{userName} | 
*AdministrationUserAndGroupApi* | [**update_profile_locale**](docs/AdministrationUserAndGroupApi.md#update_profile_locale) | **PUT** /admin/user/profile/locale | 
*AdministrationUserAndGroupApi* | [**update_profile_password**](docs/AdministrationUserAndGroupApi.md#update_profile_password) | **PUT** /admin/user/profile/password | 
*AdministrationUserAndGroupApi* | [**update_user**](docs/AdministrationUserAndGroupApi.md#update_user) | **PUT** /admin/user/{userName} | 
*AdministrationUserAndGroupApi* | [**update_user_group**](docs/AdministrationUserAndGroupApi.md#update_user_group) | **PUT** /admin/usergroup/{userGroupId} | 
*AdministrationUserAndGroupApi* | [**validate_password**](docs/AdministrationUserAndGroupApi.md#validate_password) | **POST** /admin/user/password/validate | 
*CertificateManagementDeviceApi* | [**decommission_enterprise_csr_for_vedge**](docs/CertificateManagementDeviceApi.md#decommission_enterprise_csr_for_vedge) | **POST** /certificate/revoke/enterprise/certificate | 
*CertificateManagementDeviceApi* | [**delete_configuration**](docs/CertificateManagementDeviceApi.md#delete_configuration) | **DELETE** /certificate/{uuid} | 
*CertificateManagementDeviceApi* | [**force_sync_root_cert**](docs/CertificateManagementDeviceApi.md#force_sync_root_cert) | **POST** /certificate/forcesync/rootCert | 
*CertificateManagementDeviceApi* | [**generate_csr**](docs/CertificateManagementDeviceApi.md#generate_csr) | **POST** /certificate/generate/csr | 
*CertificateManagementDeviceApi* | [**generate_edge_device_csr**](docs/CertificateManagementDeviceApi.md#generate_edge_device_csr) | **POST** /certificate/generate/wanedge/csr | 
*CertificateManagementDeviceApi* | [**generate_enterprise_csr**](docs/CertificateManagementDeviceApi.md#generate_enterprise_csr) | **POST** /certificate/generate/enterprise/csr/vedge | 
*CertificateManagementDeviceApi* | [**get_cert_details**](docs/CertificateManagementDeviceApi.md#get_cert_details) | **POST** /certificate/certdetails | 
*CertificateManagementDeviceApi* | [**get_certificate_data**](docs/CertificateManagementDeviceApi.md#get_certificate_data) | **GET** /certificate/record | 
*CertificateManagementDeviceApi* | [**get_certificate_detail**](docs/CertificateManagementDeviceApi.md#get_certificate_detail) | **GET** /certificate/stats/detail | 
*CertificateManagementDeviceApi* | [**get_certificate_stats**](docs/CertificateManagementDeviceApi.md#get_certificate_stats) | **GET** /certificate/stats/summary | 
*CertificateManagementDeviceApi* | [**get_csr_view_right_menus**](docs/CertificateManagementDeviceApi.md#get_csr_view_right_menus) | **GET** /certificate/csr/details | 
*CertificateManagementDeviceApi* | [**get_device_view_right_menus**](docs/CertificateManagementDeviceApi.md#get_device_view_right_menus) | **GET** /certificate/device/details | 
*CertificateManagementDeviceApi* | [**get_devices_list**](docs/CertificateManagementDeviceApi.md#get_devices_list) | **GET** /certificate/device/list | 
*CertificateManagementDeviceApi* | [**get_installed_cert**](docs/CertificateManagementDeviceApi.md#get_installed_cert) | **GET** /certificate/vedge | 
*CertificateManagementDeviceApi* | [**get_list_status**](docs/CertificateManagementDeviceApi.md#get_list_status) | **GET** /certificate/list/status | 
*CertificateManagementDeviceApi* | [**get_root_cert_chains**](docs/CertificateManagementDeviceApi.md#get_root_cert_chains) | **GET** /certificate/rootcertchains | 
*CertificateManagementDeviceApi* | [**get_root_certificate**](docs/CertificateManagementDeviceApi.md#get_root_certificate) | **GET** /certificate/rootcertificate | 
*CertificateManagementDeviceApi* | [**get_view**](docs/CertificateManagementDeviceApi.md#get_view) | **GET** /certificate/view | 
*CertificateManagementDeviceApi* | [**getc_edge_list**](docs/CertificateManagementDeviceApi.md#getc_edge_list) | **GET** /certificate/tokengeneratedlist | 
*CertificateManagementDeviceApi* | [**getv_edge_csr**](docs/CertificateManagementDeviceApi.md#getv_edge_csr) | **GET** /certificate/vedge/csr | 
*CertificateManagementDeviceApi* | [**getv_edge_list**](docs/CertificateManagementDeviceApi.md#getv_edge_list) | **GET** /certificate/vedge/list | 
*CertificateManagementDeviceApi* | [**getv_smart_list**](docs/CertificateManagementDeviceApi.md#getv_smart_list) | **GET** /certificate/vsmart/list | 
*CertificateManagementDeviceApi* | [**install_certificate**](docs/CertificateManagementDeviceApi.md#install_certificate) | **POST** /certificate/install/signedCert | 
*CertificateManagementDeviceApi* | [**reset_rsa**](docs/CertificateManagementDeviceApi.md#reset_rsa) | **POST** /certificate/reset/rsa | 
*CertificateManagementDeviceApi* | [**save_root_cert_chain**](docs/CertificateManagementDeviceApi.md#save_root_cert_chain) | **PUT** /certificate/rootcertchains | 
*CertificateManagementDeviceApi* | [**save_v_edge_list**](docs/CertificateManagementDeviceApi.md#save_v_edge_list) | **POST** /certificate/save/vedge/list | 
*CertificateManagementDeviceApi* | [**setv_edge_list**](docs/CertificateManagementDeviceApi.md#setv_edge_list) | **POST** /certificate/vedge/list | 
*CertificateManagementDeviceApi* | [**setv_smart_list**](docs/CertificateManagementDeviceApi.md#setv_smart_list) | **POST** /certificate/vsmart/list | 
*CertificateManagementDeviceApi* | [**setv_smart_list1**](docs/CertificateManagementDeviceApi.md#setv_smart_list1) | **GET** /certificate/mthub/list | 
*CertificateManagementDeviceApi* | [**syncv_bond**](docs/CertificateManagementDeviceApi.md#syncv_bond) | **GET** /certificate/syncvbond | 
*CertificateManagementDeviceApi* | [**update_jks**](docs/CertificateManagementDeviceApi.md#update_jks) | **PUT** /certificate/jks | 
*CertificateManagementVManageApi* | [**dump_certificate**](docs/CertificateManagementVManageApi.md#dump_certificate) | **GET** /setting/configuration/webserver/certificate/certificate | 
*CertificateManagementVManageApi* | [**get_certificate**](docs/CertificateManagementVManageApi.md#get_certificate) | **GET** /setting/configuration/webserver/certificate/getcertificate | 
*CertificateManagementVManageApi* | [**get_csr**](docs/CertificateManagementVManageApi.md#get_csr) | **POST** /setting/configuration/webserver/certificate | 
*CertificateManagementVManageApi* | [**import_certificate**](docs/CertificateManagementVManageApi.md#import_certificate) | **PUT** /setting/configuration/webserver/certificate | 
*CertificateManagementVManageApi* | [**rollback**](docs/CertificateManagementVManageApi.md#rollback) | **GET** /setting/configuration/webserver/certificate/rollback | 
*CertificateManagementVManageApi* | [**show_info**](docs/CertificateManagementVManageApi.md#show_info) | **GET** /setting/configuration/webserver/certificate | 
*ClusterManagementApi* | [**add_or_update_user_credentials**](docs/ClusterManagementApi.md#add_or_update_user_credentials) | **POST** /clusterManagement/userCreds | 
*ClusterManagementApi* | [**add_vmanage**](docs/ClusterManagementApi.md#add_vmanage) | **POST** /clusterManagement/setup | 
*ClusterManagementApi* | [**check_if_cluster_locked**](docs/ClusterManagementApi.md#check_if_cluster_locked) | **GET** /clusterManagement/clusterLocked | 
*ClusterManagementApi* | [**configure_vmanage**](docs/ClusterManagementApi.md#configure_vmanage) | **POST** /clusterManagement/configure | 
*ClusterManagementApi* | [**edit_vmanage**](docs/ClusterManagementApi.md#edit_vmanage) | **PUT** /clusterManagement/setup | 
*ClusterManagementApi* | [**get_cluster_workflow_version**](docs/ClusterManagementApi.md#get_cluster_workflow_version) | **GET** /clusterManagement/clusterworkflow/version | 
*ClusterManagementApi* | [**get_configured_ip_list**](docs/ClusterManagementApi.md#get_configured_ip_list) | **GET** /clusterManagement/iplist/{vmanageID} | 
*ClusterManagementApi* | [**get_connected_devices**](docs/ClusterManagementApi.md#get_connected_devices) | **GET** /clusterManagement/connectedDevices/{vmanageIP} | 
*ClusterManagementApi* | [**get_connected_devices_per_tenant**](docs/ClusterManagementApi.md#get_connected_devices_per_tenant) | **GET** /clusterManagement/{tenantId}/connectedDevices/{vmanageIP} | 
*ClusterManagementApi* | [**get_tenancy_mode**](docs/ClusterManagementApi.md#get_tenancy_mode) | **GET** /clusterManagement/tenancy/mode | 
*ClusterManagementApi* | [**get_tenants_list**](docs/ClusterManagementApi.md#get_tenants_list) | **GET** /clusterManagement/tenantList | 
*ClusterManagementApi* | [**get_v_manage_details**](docs/ClusterManagementApi.md#get_v_manage_details) | **GET** /clusterManagement/vManage/details/{vmanageIP} | 
*ClusterManagementApi* | [**health_details**](docs/ClusterManagementApi.md#health_details) | **GET** /clusterManagement/health/details | 
*ClusterManagementApi* | [**health_status_info**](docs/ClusterManagementApi.md#health_status_info) | **GET** /clusterManagement/health/status | 
*ClusterManagementApi* | [**health_summary**](docs/ClusterManagementApi.md#health_summary) | **GET** /clusterManagement/health/summary | 
*ClusterManagementApi* | [**is_cluster_ready**](docs/ClusterManagementApi.md#is_cluster_ready) | **GET** /clusterManagement/isready | 
*ClusterManagementApi* | [**list_vmanages**](docs/ClusterManagementApi.md#list_vmanages) | **GET** /clusterManagement/list | 
*ClusterManagementApi* | [**node_properties**](docs/ClusterManagementApi.md#node_properties) | **GET** /clusterManagement/nodeProperties | 
*ClusterManagementApi* | [**perform_replication_and_rebalance_of_kafka_partitions**](docs/ClusterManagementApi.md#perform_replication_and_rebalance_of_kafka_partitions) | **PUT** /clusterManagement/replicateAndRebalance | 
*ClusterManagementApi* | [**remove_vmanage**](docs/ClusterManagementApi.md#remove_vmanage) | **POST** /clusterManagement/remove | 
*ClusterManagementApi* | [**set_tenancy_mode**](docs/ClusterManagementApi.md#set_tenancy_mode) | **POST** /clusterManagement/tenancy/mode | 
*ColocationClusterApi* | [**acitvate_cloud_dock_cluster**](docs/ColocationClusterApi.md#acitvate_cloud_dock_cluster) | **POST** /colocation/cluster/activate | 
*ColocationClusterApi* | [**cloud_dock_cluster_preview**](docs/ColocationClusterApi.md#cloud_dock_cluster_preview) | **GET** /colocation/cluster/config | 
*ColocationClusterApi* | [**create_cloud_dock_cluster**](docs/ColocationClusterApi.md#create_cloud_dock_cluster) | **POST** /colocation/cluster | 
*ColocationClusterApi* | [**de_acitvate_cloud_dock_cluster**](docs/ColocationClusterApi.md#de_acitvate_cloud_dock_cluster) | **POST** /colocation/cluster/deactivate | 
*ColocationClusterApi* | [**delete_cloud_dock_cluster_by_name**](docs/ColocationClusterApi.md#delete_cloud_dock_cluster_by_name) | **DELETE** /colocation/cluster/{clustername} | 
*ColocationClusterApi* | [**dummyccm**](docs/ColocationClusterApi.md#dummyccm) | **GET** /colocation/cluster/activateClusterDummy | 
*ColocationClusterApi* | [**dummycsp_state**](docs/ColocationClusterApi.md#dummycsp_state) | **GET** /colocation/cluster/activateClusterDummyState | 
*ColocationClusterApi* | [**get_cloud_dock_cluster_detail**](docs/ColocationClusterApi.md#get_cloud_dock_cluster_detail) | **GET** /colocation/cluster | 
*ColocationClusterApi* | [**get_cloud_dock_cluster_detail_by_id**](docs/ColocationClusterApi.md#get_cloud_dock_cluster_detail_by_id) | **GET** /colocation/cluster/id | 
*ColocationClusterApi* | [**rma_cloud_dock_csp**](docs/ColocationClusterApi.md#rma_cloud_dock_csp) | **POST** /colocation/cluster/rma | 
*ColocationClusterApi* | [**update_cloud_dock_cluster**](docs/ColocationClusterApi.md#update_cloud_dock_cluster) | **PUT** /colocation/cluster | 
*ColocationClusterApi* | [**update_csp_to_cluster**](docs/ColocationClusterApi.md#update_csp_to_cluster) | **PUT** /colocation/cluster/attached/csp | 
*ColocationServiceChainApi* | [**attach_service_chain**](docs/ColocationServiceChainApi.md#attach_service_chain) | **POST** /colocation/servicechain/attach | 
*ColocationServiceChainApi* | [**attach_service_chain1**](docs/ColocationServiceChainApi.md#attach_service_chain1) | **POST** /colocation/servicechain/autoattach | 
*ColocationServiceChainApi* | [**cancel_button**](docs/ColocationServiceChainApi.md#cancel_button) | **POST** /colocation/servicechain/cancel | 
*ColocationServiceChainApi* | [**detach_service_chain**](docs/ColocationServiceChainApi.md#detach_service_chain) | **PUT** /colocation/servicechain/detach | 
*ColocationServiceChainApi* | [**get_edge_devices**](docs/ColocationServiceChainApi.md#get_edge_devices) | **GET** /colocation/servicechain/edge/devices | 
*ColocationServiceChainApi* | [**getpnf_devices**](docs/ColocationServiceChainApi.md#getpnf_devices) | **GET** /colocation/servicechain/edge/pnfdevices | 
*ColocationServiceGroupApi* | [**create_service_group_cluster**](docs/ColocationServiceGroupApi.md#create_service_group_cluster) | **POST** /colocation/servicegroup | 
*ColocationServiceGroupApi* | [**delete_service_group_cluster**](docs/ColocationServiceGroupApi.md#delete_service_group_cluster) | **DELETE** /colocation/servicegroup/{name} | 
*ColocationServiceGroupApi* | [**get_available_chains**](docs/ColocationServiceGroupApi.md#get_available_chains) | **GET** /colocation/servicegroup/servicechains | 
*ColocationServiceGroupApi* | [**get_default_chain**](docs/ColocationServiceGroupApi.md#get_default_chain) | **GET** /colocation/servicegroup/servicechain/default | 
*ColocationServiceGroupApi* | [**get_service_chain**](docs/ColocationServiceGroupApi.md#get_service_chain) | **GET** /colocation/servicegroup | 
*ColocationServiceGroupApi* | [**get_service_group_in_cluster**](docs/ColocationServiceGroupApi.md#get_service_group_in_cluster) | **GET** /colocation/servicegroup/attached | 
*ColocationServiceGroupApi* | [**update_service_group_cluster**](docs/ColocationServiceGroupApi.md#update_service_group_cluster) | **PUT** /colocation/servicegroup | 
*ConfigurationAdvancedInspectionProfileDefinitionApi* | [**create_policy_definition10**](docs/ConfigurationAdvancedInspectionProfileDefinitionApi.md#create_policy_definition10) | **POST** /template/policy/definition/advancedinspectionprofile | 
*ConfigurationAdvancedInspectionProfileDefinitionApi* | [**delete_policy_definition10**](docs/ConfigurationAdvancedInspectionProfileDefinitionApi.md#delete_policy_definition10) | **DELETE** /template/policy/definition/advancedinspectionprofile/{id} | 
*ConfigurationAdvancedInspectionProfileDefinitionApi* | [**edit_multiple_policy_definition10**](docs/ConfigurationAdvancedInspectionProfileDefinitionApi.md#edit_multiple_policy_definition10) | **PUT** /template/policy/definition/advancedinspectionprofile/multiple/{id} | 
*ConfigurationAdvancedInspectionProfileDefinitionApi* | [**edit_policy_definition10**](docs/ConfigurationAdvancedInspectionProfileDefinitionApi.md#edit_policy_definition10) | **PUT** /template/policy/definition/advancedinspectionprofile/{id} | 
*ConfigurationAdvancedInspectionProfileDefinitionApi* | [**get_definitions10**](docs/ConfigurationAdvancedInspectionProfileDefinitionApi.md#get_definitions10) | **GET** /template/policy/definition/advancedinspectionprofile | 
*ConfigurationAdvancedInspectionProfileDefinitionApi* | [**get_policy_definition10**](docs/ConfigurationAdvancedInspectionProfileDefinitionApi.md#get_policy_definition10) | **GET** /template/policy/definition/advancedinspectionprofile/{id} | 
*ConfigurationAdvancedInspectionProfileDefinitionApi* | [**preview_policy_definition10**](docs/ConfigurationAdvancedInspectionProfileDefinitionApi.md#preview_policy_definition10) | **POST** /template/policy/definition/advancedinspectionprofile/preview | 
*ConfigurationAdvancedInspectionProfileDefinitionApi* | [**preview_policy_definition_by_id10**](docs/ConfigurationAdvancedInspectionProfileDefinitionApi.md#preview_policy_definition_by_id10) | **GET** /template/policy/definition/advancedinspectionprofile/preview/{id} | 
*ConfigurationAdvancedInspectionProfileDefinitionApi* | [**save_policy_definition_in_bulk10**](docs/ConfigurationAdvancedInspectionProfileDefinitionApi.md#save_policy_definition_in_bulk10) | **PUT** /template/policy/definition/advancedinspectionprofile/bulk | 
*ConfigurationAzureConnectApi* | [**authenticate_azure_connect_cred_and_add**](docs/ConfigurationAzureConnectApi.md#authenticate_azure_connect_cred_and_add) | **POST** /template/cortex/cloud/authenticate | 
*ConfigurationAzureConnectApi* | [**delete_wan_resource_groups**](docs/ConfigurationAzureConnectApi.md#delete_wan_resource_groups) | **DELETE** /template/cortex/wanrg | 
*ConfigurationAzureConnectApi* | [**edit_wan_resource_groups**](docs/ConfigurationAzureConnectApi.md#edit_wan_resource_groups) | **PUT** /template/cortex/wanrg | 
*ConfigurationAzureConnectApi* | [**get_cortex_status**](docs/ConfigurationAzureConnectApi.md#get_cortex_status) | **GET** /template/cortex | 
*ConfigurationAzureConnectApi* | [**get_mapped_wan_resource_groups**](docs/ConfigurationAzureConnectApi.md#get_mapped_wan_resource_groups) | **GET** /template/cortex/map | 
*ConfigurationAzureConnectApi* | [**get_wan_resource_groups**](docs/ConfigurationAzureConnectApi.md#get_wan_resource_groups) | **GET** /template/cortex/wanrg | 
*ConfigurationAzureConnectApi* | [**save_wan_resource_groups**](docs/ConfigurationAzureConnectApi.md#save_wan_resource_groups) | **POST** /template/cortex/wanrg | 
*ConfigurationAzureConnectApi* | [**sync_wan_resource_groups**](docs/ConfigurationAzureConnectApi.md#sync_wan_resource_groups) | **POST** /template/cortex/sync | 
*ConfigurationCircuitsApi* | [**create_circuit**](docs/ConfigurationCircuitsApi.md#create_circuit) | **POST** /networkdesign/circuit | 
*ConfigurationCircuitsApi* | [**delete_circuit**](docs/ConfigurationCircuitsApi.md#delete_circuit) | **DELETE** /networkdesign/circuit/{id} | 
*ConfigurationCircuitsApi* | [**edit_circuit**](docs/ConfigurationCircuitsApi.md#edit_circuit) | **PUT** /networkdesign/circuit/{id} | 
*ConfigurationCircuitsApi* | [**get_circuits**](docs/ConfigurationCircuitsApi.md#get_circuits) | **GET** /networkdesign/circuit | 
*ConfigurationCloudExpressApi* | [**add_apps**](docs/ConfigurationCloudExpressApi.md#add_apps) | **POST** /template/cloudx/manage/apps | 
*ConfigurationCloudExpressApi* | [**add_cloudx_interfaces**](docs/ConfigurationCloudExpressApi.md#add_cloudx_interfaces) | **POST** /template/cloudx/interfaces | 
*ConfigurationCloudExpressApi* | [**add_cloudx_type**](docs/ConfigurationCloudExpressApi.md#add_cloudx_type) | **POST** /template/cloudx/addcloudx/{type} | 
*ConfigurationCloudExpressApi* | [**delete_webex_prefix_lists**](docs/ConfigurationCloudExpressApi.md#delete_webex_prefix_lists) | **DELETE** /cloudservices/app/webex | 
*ConfigurationCloudExpressApi* | [**edit_apps**](docs/ConfigurationCloudExpressApi.md#edit_apps) | **PUT** /template/cloudx/manage/apps | 
*ConfigurationCloudExpressApi* | [**enable_webex**](docs/ConfigurationCloudExpressApi.md#enable_webex) | **POST** /cloudservices/app/webex | 
*ConfigurationCloudExpressApi* | [**enable_webex1**](docs/ConfigurationCloudExpressApi.md#enable_webex1) | **PUT** /cloudservices/app/webex | 
*ConfigurationCloudExpressApi* | [**get_apps**](docs/ConfigurationCloudExpressApi.md#get_apps) | **GET** /template/cloudx/manage/apps | 
*ConfigurationCloudExpressApi* | [**get_attached_client_list**](docs/ConfigurationCloudExpressApi.md#get_attached_client_list) | **GET** /template/cloudx/attachedclient | 
*ConfigurationCloudExpressApi* | [**get_attached_dia_list**](docs/ConfigurationCloudExpressApi.md#get_attached_dia_list) | **GET** /template/cloudx/attacheddia | 
*ConfigurationCloudExpressApi* | [**get_attached_gateway_list**](docs/ConfigurationCloudExpressApi.md#get_attached_gateway_list) | **GET** /template/cloudx/attachedgateway | 
*ConfigurationCloudExpressApi* | [**get_cloud_x_available_apps**](docs/ConfigurationCloudExpressApi.md#get_cloud_x_available_apps) | **GET** /template/cloudx/availableapps | 
*ConfigurationCloudExpressApi* | [**get_cloud_x_status**](docs/ConfigurationCloudExpressApi.md#get_cloud_x_status) | **GET** /template/cloudx | 
*ConfigurationCloudExpressApi* | [**get_dia_list**](docs/ConfigurationCloudExpressApi.md#get_dia_list) | **GET** /template/cloudx/dialist | 
*ConfigurationCloudExpressApi* | [**get_gateway_list**](docs/ConfigurationCloudExpressApi.md#get_gateway_list) | **GET** /template/cloudx/gatewaylist | 
*ConfigurationCloudExpressApi* | [**get_site_list**](docs/ConfigurationCloudExpressApi.md#get_site_list) | **GET** /template/cloudx/clientlist | 
*ConfigurationCloudExpressApi* | [**site_per_app**](docs/ConfigurationCloudExpressApi.md#site_per_app) | **GET** /template/cloudx/status | 
*ConfigurationCloudOnRampApi* | [**acquire_resource_pool**](docs/ConfigurationCloudOnRampApi.md#acquire_resource_pool) | **POST** /template/cor/acquireResourcePool | 
*ConfigurationCloudOnRampApi* | [**add_device_pair**](docs/ConfigurationCloudOnRampApi.md#add_device_pair) | **POST** /template/cor/devicepair | 
*ConfigurationCloudOnRampApi* | [**add_transit_vpc**](docs/ConfigurationCloudOnRampApi.md#add_transit_vpc) | **POST** /template/cor/transitvpc | 
*ConfigurationCloudOnRampApi* | [**authenticate_cloud_on_ramp_cred_and_add**](docs/ConfigurationCloudOnRampApi.md#authenticate_cloud_on_ramp_cred_and_add) | **POST** /template/cor/cloud/authenticate | 
*ConfigurationCloudOnRampApi* | [**authenticate_cred_and_update**](docs/ConfigurationCloudOnRampApi.md#authenticate_cred_and_update) | **PUT** /template/cor/cloud/authenticate | 
*ConfigurationCloudOnRampApi* | [**create_and_map**](docs/ConfigurationCloudOnRampApi.md#create_and_map) | **POST** /template/cor | 
*ConfigurationCloudOnRampApi* | [**create_resource_pool**](docs/ConfigurationCloudOnRampApi.md#create_resource_pool) | **POST** /template/cor/createResourcePool | 
*ConfigurationCloudOnRampApi* | [**get_ami_list**](docs/ConfigurationCloudOnRampApi.md#get_ami_list) | **GET** /template/cor/ami | 
*ConfigurationCloudOnRampApi* | [**get_cloud_accounts**](docs/ConfigurationCloudOnRampApi.md#get_cloud_accounts) | **GET** /template/cor/cloud/account | 
*ConfigurationCloudOnRampApi* | [**get_cloud_host_vpc_account_details**](docs/ConfigurationCloudOnRampApi.md#get_cloud_host_vpc_account_details) | **GET** /template/cor/cloud/host/accountdetails | 
*ConfigurationCloudOnRampApi* | [**get_cloud_host_vpcs**](docs/ConfigurationCloudOnRampApi.md#get_cloud_host_vpcs) | **GET** /template/cor/hostvpc | 
*ConfigurationCloudOnRampApi* | [**get_cloud_list**](docs/ConfigurationCloudOnRampApi.md#get_cloud_list) | **GET** /template/cor/cloud | 
*ConfigurationCloudOnRampApi* | [**get_cloud_mapped_host_accounts**](docs/ConfigurationCloudOnRampApi.md#get_cloud_mapped_host_accounts) | **GET** /template/cor/cloud/mappedhostaccounts | 
*ConfigurationCloudOnRampApi* | [**get_cloud_on_ramp_devices**](docs/ConfigurationCloudOnRampApi.md#get_cloud_on_ramp_devices) | **GET** /template/cor/device | 
*ConfigurationCloudOnRampApi* | [**get_cor_status**](docs/ConfigurationCloudOnRampApi.md#get_cor_status) | **GET** /template/cor | 
*ConfigurationCloudOnRampApi* | [**get_external_id**](docs/ConfigurationCloudOnRampApi.md#get_external_id) | **GET** /template/cor/externalId | 
*ConfigurationCloudOnRampApi* | [**get_host_vpcs**](docs/ConfigurationCloudOnRampApi.md#get_host_vpcs) | **GET** /template/cor/devicepair/hostvpc | 
*ConfigurationCloudOnRampApi* | [**get_mapped_vpcs**](docs/ConfigurationCloudOnRampApi.md#get_mapped_vpcs) | **GET** /template/cor/map | 
*ConfigurationCloudOnRampApi* | [**get_pem_key_list**](docs/ConfigurationCloudOnRampApi.md#get_pem_key_list) | **GET** /template/cor/pem | 
*ConfigurationCloudOnRampApi* | [**get_tenant_and_host_vpc_list**](docs/ConfigurationCloudOnRampApi.md#get_tenant_and_host_vpc_list) | **GET** /template/cor/hostvpclist | 
*ConfigurationCloudOnRampApi* | [**get_transit_device_pair_and_host_list**](docs/ConfigurationCloudOnRampApi.md#get_transit_device_pair_and_host_list) | **GET** /template/cor/getTransitDevicePairAndHostList | 
*ConfigurationCloudOnRampApi* | [**get_transit_vpc_supported_size**](docs/ConfigurationCloudOnRampApi.md#get_transit_vpc_supported_size) | **GET** /template/cor/transitvpc/size | 
*ConfigurationCloudOnRampApi* | [**get_transit_vpc_vpn_list**](docs/ConfigurationCloudOnRampApi.md#get_transit_vpc_vpn_list) | **GET** /template/cor/getTransitVpnList | 
*ConfigurationCloudOnRampApi* | [**get_transit_vpcs**](docs/ConfigurationCloudOnRampApi.md#get_transit_vpcs) | **GET** /template/cor/transitvpc | 
*ConfigurationCloudOnRampApi* | [**map_vpcs**](docs/ConfigurationCloudOnRampApi.md#map_vpcs) | **POST** /template/cor/map | 
*ConfigurationCloudOnRampApi* | [**raise_alarm_for_account**](docs/ConfigurationCloudOnRampApi.md#raise_alarm_for_account) | **POST** /template/cor/account/alarm | 
*ConfigurationCloudOnRampApi* | [**remove_device_id**](docs/ConfigurationCloudOnRampApi.md#remove_device_id) | **DELETE** /template/cor/deleteDevicepair | 
*ConfigurationCloudOnRampApi* | [**remove_transit_vpc**](docs/ConfigurationCloudOnRampApi.md#remove_transit_vpc) | **DELETE** /template/cor/accountid/{accountid} | 
*ConfigurationCloudOnRampApi* | [**scale_down**](docs/ConfigurationCloudOnRampApi.md#scale_down) | **POST** /template/cor/scale/down | 
*ConfigurationCloudOnRampApi* | [**scale_up**](docs/ConfigurationCloudOnRampApi.md#scale_up) | **POST** /template/cor/scale/up | 
*ConfigurationCloudOnRampApi* | [**unmap_vpcs**](docs/ConfigurationCloudOnRampApi.md#unmap_vpcs) | **DELETE** /template/cor/map | 
*ConfigurationCloudOnRampApi* | [**update_host_vpc_reachability**](docs/ConfigurationCloudOnRampApi.md#update_host_vpc_reachability) | **PUT** /template/cor/hostvpclist | 
*ConfigurationCloudOnRampApi* | [**update_transit_vpc**](docs/ConfigurationCloudOnRampApi.md#update_transit_vpc) | **PUT** /template/cor/transitvpc | 
*ConfigurationCloudOnRampApi* | [**update_transit_vpc_autoscale_properties**](docs/ConfigurationCloudOnRampApi.md#update_transit_vpc_autoscale_properties) | **PUT** /template/cor/transitvpc/autoscale-properties | 
*ConfigurationCloudOnRampApi* | [**updatestatus**](docs/ConfigurationCloudOnRampApi.md#updatestatus) | **POST** /template/cor/status | 
*ConfigurationConfigurationGroupApi* | [**create_config_group**](docs/ConfigurationConfigurationGroupApi.md#create_config_group) | **POST** /v1/config-group | 
*ConfigurationConfigurationGroupApi* | [**create_config_group_association**](docs/ConfigurationConfigurationGroupApi.md#create_config_group_association) | **POST** /v1/config-group/{configGroupId}/device/associate | 
*ConfigurationConfigurationGroupApi* | [**create_config_group_device_variables**](docs/ConfigurationConfigurationGroupApi.md#create_config_group_device_variables) | **PUT** /v1/config-group/{configGroupId}/device/variables | 
*ConfigurationConfigurationGroupApi* | [**create_config_group_device_variables1**](docs/ConfigurationConfigurationGroupApi.md#create_config_group_device_variables1) | **GET** /v1/config-group/{configGroupId}/device/variables/schema | 
*ConfigurationConfigurationGroupApi* | [**delete_config_group**](docs/ConfigurationConfigurationGroupApi.md#delete_config_group) | **DELETE** /v1/config-group/{configGroupId} | 
*ConfigurationConfigurationGroupApi* | [**delete_config_group_association**](docs/ConfigurationConfigurationGroupApi.md#delete_config_group_association) | **DELETE** /v1/config-group/{configGroupId}/device/associate | 
*ConfigurationConfigurationGroupApi* | [**deploy_config_group**](docs/ConfigurationConfigurationGroupApi.md#deploy_config_group) | **POST** /v1/config-group/{configGroupId}/device/deploy | 
*ConfigurationConfigurationGroupApi* | [**edit_config_group**](docs/ConfigurationConfigurationGroupApi.md#edit_config_group) | **PUT** /v1/config-group/{configGroupId} | 
*ConfigurationConfigurationGroupApi* | [**get_cedge_config_group_schema_by_schema_type**](docs/ConfigurationConfigurationGroupApi.md#get_cedge_config_group_schema_by_schema_type) | **GET** /v1/config-group/schema/sdwan | 
*ConfigurationConfigurationGroupApi* | [**get_config_group**](docs/ConfigurationConfigurationGroupApi.md#get_config_group) | **GET** /v1/config-group/{configGroupId} | 
*ConfigurationConfigurationGroupApi* | [**get_config_group_association**](docs/ConfigurationConfigurationGroupApi.md#get_config_group_association) | **GET** /v1/config-group/{configGroupId}/device/associate | 
*ConfigurationConfigurationGroupApi* | [**get_config_group_by_solution**](docs/ConfigurationConfigurationGroupApi.md#get_config_group_by_solution) | **GET** /v1/config-group | 
*ConfigurationConfigurationGroupApi* | [**get_config_group_device_configuration_preview**](docs/ConfigurationConfigurationGroupApi.md#get_config_group_device_configuration_preview) | **POST** /v1/config-group/{configGroupId}/device/{deviceId}/preview | 
*ConfigurationConfigurationGroupApi* | [**get_config_group_device_variables**](docs/ConfigurationConfigurationGroupApi.md#get_config_group_device_variables) | **GET** /v1/config-group/{configGroupId}/device/variables | 
*ConfigurationConfigurationGroupApi* | [**update_config_group_association**](docs/ConfigurationConfigurationGroupApi.md#update_config_group_association) | **PUT** /v1/config-group/{configGroupId}/device/associate | 
*ConfigurationDashboardStatusApi* | [**cancel_pending_tasks**](docs/ConfigurationDashboardStatusApi.md#cancel_pending_tasks) | **POST** /device/action/status/cancel/{processId} | 
*ConfigurationDashboardStatusApi* | [**clean_status**](docs/ConfigurationDashboardStatusApi.md#clean_status) | **GET** /device/action/status/clean | 
*ConfigurationDashboardStatusApi* | [**delete_status**](docs/ConfigurationDashboardStatusApi.md#delete_status) | **DELETE** /device/action/status/clear | 
*ConfigurationDashboardStatusApi* | [**find_running_tasks**](docs/ConfigurationDashboardStatusApi.md#find_running_tasks) | **GET** /device/action/status/tasks | 
*ConfigurationDashboardStatusApi* | [**find_status**](docs/ConfigurationDashboardStatusApi.md#find_status) | **GET** /device/action/status/{actionName} | 
*ConfigurationDashboardStatusApi* | [**get_active_task_count**](docs/ConfigurationDashboardStatusApi.md#get_active_task_count) | **GET** /device/action/status/tasks/activeCount | 
*ConfigurationDashboardStatusApi* | [**get_clean_status**](docs/ConfigurationDashboardStatusApi.md#get_clean_status) | **GET** /device/action/status/tasks/clean | 
*ConfigurationDeviceActionsApi* | [**create_filter_vpn_list**](docs/ConfigurationDeviceActionsApi.md#create_filter_vpn_list) | **GET** /device/action/filter/vpn | 
*ConfigurationDeviceActionsApi* | [**create_unique_vpn_list**](docs/ConfigurationDeviceActionsApi.md#create_unique_vpn_list) | **POST** /device/action/uniquevpnlist | 
*ConfigurationDeviceActionsApi* | [**create_vpn_list**](docs/ConfigurationDeviceActionsApi.md#create_vpn_list) | **GET** /device/action/vpn | 
*ConfigurationDeviceActionsApi* | [**generate_change_partition_info**](docs/ConfigurationDeviceActionsApi.md#generate_change_partition_info) | **GET** /device/action/changepartition | 
*ConfigurationDeviceActionsApi* | [**generate_deactivate_info**](docs/ConfigurationDeviceActionsApi.md#generate_deactivate_info) | **GET** /device/action/deactivate | 
*ConfigurationDeviceActionsApi* | [**generate_device_action_list**](docs/ConfigurationDeviceActionsApi.md#generate_device_action_list) | **GET** /device/action/list | 
*ConfigurationDeviceActionsApi* | [**generate_device_list**](docs/ConfigurationDeviceActionsApi.md#generate_device_list) | **GET** /device/action/install/devices/{deviceType} | 
*ConfigurationDeviceActionsApi* | [**generate_install_info**](docs/ConfigurationDeviceActionsApi.md#generate_install_info) | **GET** /device/action/install | 
*ConfigurationDeviceActionsApi* | [**generate_reboot_device_list**](docs/ConfigurationDeviceActionsApi.md#generate_reboot_device_list) | **GET** /device/action/reboot/devices/{deviceType} | 
*ConfigurationDeviceActionsApi* | [**generate_reboot_info**](docs/ConfigurationDeviceActionsApi.md#generate_reboot_info) | **GET** /device/action/reboot | 
*ConfigurationDeviceActionsApi* | [**generate_rediscover_info**](docs/ConfigurationDeviceActionsApi.md#generate_rediscover_info) | **GET** /device/action/rediscover | 
*ConfigurationDeviceActionsApi* | [**generate_remove_partition_info**](docs/ConfigurationDeviceActionsApi.md#generate_remove_partition_info) | **GET** /device/action/removepartition | 
*ConfigurationDeviceActionsApi* | [**generate_security_devices_list**](docs/ConfigurationDeviceActionsApi.md#generate_security_devices_list) | **GET** /device/action/security/devices/{policyType} | 
*ConfigurationDeviceActionsApi* | [**get_ztp_upgrade_config**](docs/ConfigurationDeviceActionsApi.md#get_ztp_upgrade_config) | **GET** /device/action/ztp/upgrade | 
*ConfigurationDeviceActionsApi* | [**get_ztp_upgrade_config_setting**](docs/ConfigurationDeviceActionsApi.md#get_ztp_upgrade_config_setting) | **GET** /device/action/ztp/upgrade/setting | 
*ConfigurationDeviceActionsApi* | [**initiate_image_download**](docs/ConfigurationDeviceActionsApi.md#initiate_image_download) | **POST** /device/action/image-download | 
*ConfigurationDeviceActionsApi* | [**process_amp_api_re_key**](docs/ConfigurationDeviceActionsApi.md#process_amp_api_re_key) | **POST** /device/action/security/amp/rekey | 
*ConfigurationDeviceActionsApi* | [**process_change_partition**](docs/ConfigurationDeviceActionsApi.md#process_change_partition) | **POST** /device/action/changepartition | 
*ConfigurationDeviceActionsApi* | [**process_deactivate_smu**](docs/ConfigurationDeviceActionsApi.md#process_deactivate_smu) | **POST** /device/action/deactivate | 
*ConfigurationDeviceActionsApi* | [**process_default_partition**](docs/ConfigurationDeviceActionsApi.md#process_default_partition) | **POST** /device/action/defaultpartition | 
*ConfigurationDeviceActionsApi* | [**process_delete_amp_api_key**](docs/ConfigurationDeviceActionsApi.md#process_delete_amp_api_key) | **DELETE** /device/action/security/amp/apikey/{uuid} | 
*ConfigurationDeviceActionsApi* | [**process_install**](docs/ConfigurationDeviceActionsApi.md#process_install) | **POST** /device/action/install | 
*ConfigurationDeviceActionsApi* | [**process_lxc_activate**](docs/ConfigurationDeviceActionsApi.md#process_lxc_activate) | **POST** /device/action/lxcactivate | 
*ConfigurationDeviceActionsApi* | [**process_lxc_delete**](docs/ConfigurationDeviceActionsApi.md#process_lxc_delete) | **POST** /device/action/lxcdelete | 
*ConfigurationDeviceActionsApi* | [**process_lxc_install**](docs/ConfigurationDeviceActionsApi.md#process_lxc_install) | **POST** /device/action/lxcinstall | 
*ConfigurationDeviceActionsApi* | [**process_lxc_reload**](docs/ConfigurationDeviceActionsApi.md#process_lxc_reload) | **POST** /device/action/lxcreload | 
*ConfigurationDeviceActionsApi* | [**process_lxc_reset**](docs/ConfigurationDeviceActionsApi.md#process_lxc_reset) | **POST** /device/action/lxcreset | 
*ConfigurationDeviceActionsApi* | [**process_lxc_upgrade**](docs/ConfigurationDeviceActionsApi.md#process_lxc_upgrade) | **POST** /device/action/lxcupgrade | 
*ConfigurationDeviceActionsApi* | [**process_reboot**](docs/ConfigurationDeviceActionsApi.md#process_reboot) | **POST** /device/action/reboot | 
*ConfigurationDeviceActionsApi* | [**process_remove_partition**](docs/ConfigurationDeviceActionsApi.md#process_remove_partition) | **POST** /device/action/removepartition | 
*ConfigurationDeviceActionsApi* | [**process_remove_software_image**](docs/ConfigurationDeviceActionsApi.md#process_remove_software_image) | **POST** /device/action/image-remove | 
*ConfigurationDeviceActionsApi* | [**process_vnf_install**](docs/ConfigurationDeviceActionsApi.md#process_vnf_install) | **POST** /device/action/vnfinstall | 
*ConfigurationDeviceActionsApi* | [**process_ztp_upgrade_config**](docs/ConfigurationDeviceActionsApi.md#process_ztp_upgrade_config) | **POST** /device/action/ztp/upgrade | 
*ConfigurationDeviceActionsApi* | [**process_ztp_upgrade_config_setting**](docs/ConfigurationDeviceActionsApi.md#process_ztp_upgrade_config_setting) | **POST** /device/action/ztp/upgrade/setting | 
*ConfigurationDeviceActionsApi* | [**re_discover_all_device**](docs/ConfigurationDeviceActionsApi.md#re_discover_all_device) | **POST** /device/action/rediscoverall | 
*ConfigurationDeviceActionsApi* | [**re_discover_devices**](docs/ConfigurationDeviceActionsApi.md#re_discover_devices) | **POST** /device/action/rediscover | 
*ConfigurationDeviceActionsApi* | [**test_api_key**](docs/ConfigurationDeviceActionsApi.md#test_api_key) | **GET** /device/action/security/apikey/{uuid} | 
*ConfigurationDeviceActionsApi* | [**test_iox_config**](docs/ConfigurationDeviceActionsApi.md#test_iox_config) | **GET** /device/action/test/ioxconfig/{deviceIP} | 
*ConfigurationDeviceActionsApi* | [**trigger_pending_tasks_monitoring**](docs/ConfigurationDeviceActionsApi.md#trigger_pending_tasks_monitoring) | **GET** /device/action/startmonitor | 
*ConfigurationDeviceConfigHistoryApi* | [**get_aggregation_data_by_query20**](docs/ConfigurationDeviceConfigHistoryApi.md#get_aggregation_data_by_query20) | **GET** /device/history/aggregation | 
*ConfigurationDeviceConfigHistoryApi* | [**get_config_diff**](docs/ConfigurationDeviceConfigHistoryApi.md#get_config_diff) | **GET** /device/history/config/diff/list | 
*ConfigurationDeviceConfigHistoryApi* | [**get_count22**](docs/ConfigurationDeviceConfigHistoryApi.md#get_count22) | **GET** /device/history/doccount | 
*ConfigurationDeviceConfigHistoryApi* | [**get_count_post22**](docs/ConfigurationDeviceConfigHistoryApi.md#get_count_post22) | **POST** /device/history/doccount | 
*ConfigurationDeviceConfigHistoryApi* | [**get_device_config**](docs/ConfigurationDeviceConfigHistoryApi.md#get_device_config) | **GET** /device/history/config/{config_id} | 
*ConfigurationDeviceConfigHistoryApi* | [**get_last_thousand_config_list**](docs/ConfigurationDeviceConfigHistoryApi.md#get_last_thousand_config_list) | **GET** /device/history/config | 
*ConfigurationDeviceConfigHistoryApi* | [**get_post_aggregation_app_data_by_query19**](docs/ConfigurationDeviceConfigHistoryApi.md#get_post_aggregation_app_data_by_query19) | **POST** /device/history/app-agg/aggregation | 
*ConfigurationDeviceConfigHistoryApi* | [**get_post_aggregation_data_by_query19**](docs/ConfigurationDeviceConfigHistoryApi.md#get_post_aggregation_data_by_query19) | **POST** /device/history/aggregation | 
*ConfigurationDeviceConfigHistoryApi* | [**get_post_stat_bulk_raw_data20**](docs/ConfigurationDeviceConfigHistoryApi.md#get_post_stat_bulk_raw_data20) | **POST** /device/history/page | 
*ConfigurationDeviceConfigHistoryApi* | [**get_stat_bulk_raw_data20**](docs/ConfigurationDeviceConfigHistoryApi.md#get_stat_bulk_raw_data20) | **GET** /device/history/page | 
*ConfigurationDeviceConfigHistoryApi* | [**get_stat_data_fields22**](docs/ConfigurationDeviceConfigHistoryApi.md#get_stat_data_fields22) | **GET** /device/history/fields | 
*ConfigurationDeviceConfigHistoryApi* | [**get_stat_data_raw_data19**](docs/ConfigurationDeviceConfigHistoryApi.md#get_stat_data_raw_data19) | **GET** /device/history | 
*ConfigurationDeviceConfigHistoryApi* | [**get_stat_data_raw_data_as_csv20**](docs/ConfigurationDeviceConfigHistoryApi.md#get_stat_data_raw_data_as_csv20) | **GET** /device/history/csv | 
*ConfigurationDeviceConfigHistoryApi* | [**get_stat_query_fields22**](docs/ConfigurationDeviceConfigHistoryApi.md#get_stat_query_fields22) | **GET** /device/history/query/fields | 
*ConfigurationDeviceConfigHistoryApi* | [**get_stats_raw_data20**](docs/ConfigurationDeviceConfigHistoryApi.md#get_stats_raw_data20) | **POST** /device/history | 
*ConfigurationDeviceFirmwareUpdateApi* | [**activate_firmware_image**](docs/ConfigurationDeviceFirmwareUpdateApi.md#activate_firmware_image) | **POST** /device/action/firmware/activate | 
*ConfigurationDeviceFirmwareUpdateApi* | [**delete_firmware_image**](docs/ConfigurationDeviceFirmwareUpdateApi.md#delete_firmware_image) | **DELETE** /device/action/firmware/{versionId} | 
*ConfigurationDeviceFirmwareUpdateApi* | [**get_devices_fw_upgrade**](docs/ConfigurationDeviceFirmwareUpdateApi.md#get_devices_fw_upgrade) | **GET** /device/action/firmware/devices | 
*ConfigurationDeviceFirmwareUpdateApi* | [**get_firmware_image_details**](docs/ConfigurationDeviceFirmwareUpdateApi.md#get_firmware_image_details) | **GET** /device/action/firmware/{versionId} | 
*ConfigurationDeviceFirmwareUpdateApi* | [**get_firmware_images**](docs/ConfigurationDeviceFirmwareUpdateApi.md#get_firmware_images) | **GET** /device/action/firmware | 
*ConfigurationDeviceFirmwareUpdateApi* | [**install_firmware_image**](docs/ConfigurationDeviceFirmwareUpdateApi.md#install_firmware_image) | **POST** /device/action/firmware/install | 
*ConfigurationDeviceFirmwareUpdateApi* | [**process_firmware_image**](docs/ConfigurationDeviceFirmwareUpdateApi.md#process_firmware_image) | **POST** /device/action/firmware | 
*ConfigurationDeviceFirmwareUpdateApi* | [**remove_firmware_image**](docs/ConfigurationDeviceFirmwareUpdateApi.md#remove_firmware_image) | **POST** /device/action/firmware/remove | 
*ConfigurationDeviceInventoryApi* | [**check_self_signed_cert**](docs/ConfigurationDeviceInventoryApi.md#check_self_signed_cert) | **GET** /system/device/selfsignedcert/iscreated | 
*ConfigurationDeviceInventoryApi* | [**claim_devices**](docs/ConfigurationDeviceInventoryApi.md#claim_devices) | **POST** /system/device/claimDevices | 
*ConfigurationDeviceInventoryApi* | [**create_device**](docs/ConfigurationDeviceInventoryApi.md#create_device) | **POST** /system/device | 
*ConfigurationDeviceInventoryApi* | [**decommission_vedge_cloud**](docs/ConfigurationDeviceInventoryApi.md#decommission_vedge_cloud) | **PUT** /system/device/decommission/{uuid} | 
*ConfigurationDeviceInventoryApi* | [**delete_device**](docs/ConfigurationDeviceInventoryApi.md#delete_device) | **DELETE** /system/device/{uuid} | 
*ConfigurationDeviceInventoryApi* | [**devices_without_subject_sudi**](docs/ConfigurationDeviceInventoryApi.md#devices_without_subject_sudi) | **GET** /system/device/devicesWithoutSubjectSudi | 
*ConfigurationDeviceInventoryApi* | [**edit_device**](docs/ConfigurationDeviceInventoryApi.md#edit_device) | **PUT** /system/device/{uuid} | 
*ConfigurationDeviceInventoryApi* | [**form_post**](docs/ConfigurationDeviceInventoryApi.md#form_post) | **POST** /system/device/fileupload | 
*ConfigurationDeviceInventoryApi* | [**generate_bootstrap_config_for_vedge**](docs/ConfigurationDeviceInventoryApi.md#generate_bootstrap_config_for_vedge) | **GET** /system/device/bootstrap/device/{uuid} | 
*ConfigurationDeviceInventoryApi* | [**generate_bootstrap_config_for_vedges**](docs/ConfigurationDeviceInventoryApi.md#generate_bootstrap_config_for_vedges) | **POST** /system/device/bootstrap/devices | 
*ConfigurationDeviceInventoryApi* | [**generate_generic_bootstrap_config_for_vedges**](docs/ConfigurationDeviceInventoryApi.md#generate_generic_bootstrap_config_for_vedges) | **GET** /system/device/bootstrap/generic/devices | 
*ConfigurationDeviceInventoryApi* | [**get_all_unclaimed_devices**](docs/ConfigurationDeviceInventoryApi.md#get_all_unclaimed_devices) | **GET** /system/device/unclaimedDevices | 
*ConfigurationDeviceInventoryApi* | [**get_bootstrap_config_zip**](docs/ConfigurationDeviceInventoryApi.md#get_bootstrap_config_zip) | **GET** /system/device/bootstrap/download/{id} | 
*ConfigurationDeviceInventoryApi* | [**get_cloud_dock_data_based_on_device_type**](docs/ConfigurationDeviceInventoryApi.md#get_cloud_dock_data_based_on_device_type) | **GET** /system/device/type/{deviceCategory} | 
*ConfigurationDeviceInventoryApi* | [**get_cloud_dock_default_config_based_on_device_type**](docs/ConfigurationDeviceInventoryApi.md#get_cloud_dock_default_config_based_on_device_type) | **GET** /system/device/type/{deviceCategory}/defaultConfig | 
*ConfigurationDeviceInventoryApi* | [**get_controller_v_edge_sync_status**](docs/ConfigurationDeviceInventoryApi.md#get_controller_v_edge_sync_status) | **GET** /system/device/controllers/vedge/status | 
*ConfigurationDeviceInventoryApi* | [**get_devices_details**](docs/ConfigurationDeviceInventoryApi.md#get_devices_details) | **GET** /system/device/{deviceCategory} | 
*ConfigurationDeviceInventoryApi* | [**get_management_system_ip_info**](docs/ConfigurationDeviceInventoryApi.md#get_management_system_ip_info) | **GET** /system/device/management/systemip | 
*ConfigurationDeviceInventoryApi* | [**get_rma_candidates**](docs/ConfigurationDeviceInventoryApi.md#get_rma_candidates) | **GET** /system/device/rma/candidates/{deviceType} | 
*ConfigurationDeviceInventoryApi* | [**get_root_cert_status_all**](docs/ConfigurationDeviceInventoryApi.md#get_root_cert_status_all) | **GET** /system/device/rootcertchain/status | 
*ConfigurationDeviceInventoryApi* | [**get_tenant_management_system_ips**](docs/ConfigurationDeviceInventoryApi.md#get_tenant_management_system_ips) | **GET** /system/device/tenant/management/systemip | 
*ConfigurationDeviceInventoryApi* | [**invalidate_vmanage_root_ca**](docs/ConfigurationDeviceInventoryApi.md#invalidate_vmanage_root_ca) | **DELETE** /system/device/vmanagerootca/{uuid} | 
*ConfigurationDeviceInventoryApi* | [**migrate_device**](docs/ConfigurationDeviceInventoryApi.md#migrate_device) | **PUT** /system/device/migrateDevice/{uuid} | 
*ConfigurationDeviceInventoryApi* | [**reset_vedge_cloud**](docs/ConfigurationDeviceInventoryApi.md#reset_vedge_cloud) | **PUT** /system/device/reset/{uuid} | 
*ConfigurationDeviceInventoryApi* | [**set_life_cycle**](docs/ConfigurationDeviceInventoryApi.md#set_life_cycle) | **POST** /system/device/lifecycle/management/{uuid} | 
*ConfigurationDeviceInventoryApi* | [**sync_devices**](docs/ConfigurationDeviceInventoryApi.md#sync_devices) | **POST** /system/device/smartaccount/sync | 
*ConfigurationDeviceInventoryApi* | [**sync_root_cert_chain**](docs/ConfigurationDeviceInventoryApi.md#sync_root_cert_chain) | **GET** /system/device/sync/rootcertchain | 
*ConfigurationDeviceInventoryApi* | [**update_device_subject_sudi**](docs/ConfigurationDeviceInventoryApi.md#update_device_subject_sudi) | **PUT** /system/device/updateDeviceSubjectSUDI/{uuid} | 
*ConfigurationDeviceInventoryApi* | [**validate_user**](docs/ConfigurationDeviceInventoryApi.md#validate_user) | **POST** /system/device/smartaccount/authenticate | 
*ConfigurationDeviceInventoryApi* | [**validate_user1**](docs/ConfigurationDeviceInventoryApi.md#validate_user1) | **POST** /system/device/generate-payg | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**add_wan_edge**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#add_wan_edge) | **POST** /sslproxy/certificate/wanedge/{deviceId} | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**generate_ssl_proxy_csr**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#generate_ssl_proxy_csr) | **POST** /sslproxy/generate/csr/sslproxy | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**generate_ssl_proxy_csr_0**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#generate_ssl_proxy_csr_0) | **POST** /sslproxy/generate/vmanage/csr | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**get_all_device_certificates**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#get_all_device_certificates) | **POST** /sslproxy/devicecertificates | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**get_all_device_csr**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#get_all_device_csr) | **POST** /sslproxy/devicecsr | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**get_certificate_state**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#get_certificate_state) | **GET** /sslproxy/settings/certificate | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**get_enterprise_certificate**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#get_enterprise_certificate) | **GET** /sslproxy/settings/enterprise/certificate | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**get_proxy_cert_of_edge**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#get_proxy_cert_of_edge) | **GET** /sslproxy/certificate | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**get_self_signed_cert**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#get_self_signed_cert) | **GET** /certificate/vmanage/selfsignedcert | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**get_ssl_proxy_csr**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#get_ssl_proxy_csr) | **GET** /sslproxy/csr | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**get_ssl_proxy_list**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#get_ssl_proxy_list) | **GET** /sslproxy/list | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**get_v_manage_enterprise_root_certificate**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#get_v_manage_enterprise_root_certificate) | **GET** /sslproxy/settings/enterprise/rootca | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**getv_manage_certificate**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#getv_manage_certificate) | **GET** /sslproxy/settings/vmanage/certificate | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**getv_manage_csr**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#getv_manage_csr) | **GET** /sslproxy/settings/vmanage/csr | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**getv_manage_root_ca**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#getv_manage_root_ca) | **GET** /sslproxy/settings/vmanage/rootca | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**renew_certificate**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#renew_certificate) | **POST** /sslproxy/renew | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**revoke_certificate**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#revoke_certificate) | **POST** /sslproxy/revoke | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**revoke_renew_certificate**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#revoke_renew_certificate) | **POST** /sslproxy/revokerenew | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**set_enterprise_cert**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#set_enterprise_cert) | **POST** /sslproxy/settings/enterprise/certificate | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**set_enterprise_root_ca_cert**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#set_enterprise_root_ca_cert) | **POST** /sslproxy/settings/enterprise/rootca | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**setv_manage_root_ca**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#setv_manage_root_ca) | **POST** /sslproxy/settings/vmanage/rootca | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**setv_manageintermediate_cert**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#setv_manageintermediate_cert) | **POST** /sslproxy/settings/vmanage/certificate | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**update_certificate**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#update_certificate) | **PUT** /sslproxy/certificate | 
*ConfigurationDeviceSSLProxyCertificateManagementApi* | [**upload_certificiates**](docs/ConfigurationDeviceSSLProxyCertificateManagementApi.md#upload_certificiates) | **POST** /sslproxy/certificates | 
*ConfigurationDeviceSoftwarePackageApi* | [**create_vnf_package**](docs/ConfigurationDeviceSoftwarePackageApi.md#create_vnf_package) | **POST** /device/action/software/package/custom/vnfPackage | 
*ConfigurationDeviceSoftwarePackageApi* | [**edit_config_file**](docs/ConfigurationDeviceSoftwarePackageApi.md#edit_config_file) | **PUT** /device/action/software/package/custom/file/{uuid} | 
*ConfigurationDeviceSoftwarePackageApi* | [**get_file_contents**](docs/ConfigurationDeviceSoftwarePackageApi.md#get_file_contents) | **GET** /device/action/software/package/custom/file/{uuid} | 
*ConfigurationDeviceSoftwarePackageApi* | [**upload_image_file**](docs/ConfigurationDeviceSoftwarePackageApi.md#upload_image_file) | **POST** /device/action/software/package/custom/uploads/{type} | 
*ConfigurationDeviceSoftwareUpdateApi* | [**download_package_file**](docs/ConfigurationDeviceSoftwareUpdateApi.md#download_package_file) | **GET** /device/action/software/package/{fileName} | 
*ConfigurationDeviceSoftwareUpdateApi* | [**edit_image_metadata**](docs/ConfigurationDeviceSoftwareUpdateApi.md#edit_image_metadata) | **PUT** /device/action/software/package/{versionId}/metadata | 
*ConfigurationDeviceSoftwareUpdateApi* | [**get_image_metadata**](docs/ConfigurationDeviceSoftwareUpdateApi.md#get_image_metadata) | **GET** /device/action/software/package/{versionId}/metadata | 
*ConfigurationDeviceSoftwareUpdateApi* | [**get_upload_images_count**](docs/ConfigurationDeviceSoftwareUpdateApi.md#get_upload_images_count) | **GET** /device/action/software/package/imageCount | 
*ConfigurationDeviceSoftwareUpdateApi* | [**install_pkg**](docs/ConfigurationDeviceSoftwareUpdateApi.md#install_pkg) | **POST** /device/action/software/package | 
*ConfigurationDeviceSoftwareUpdateApi* | [**process_software_image**](docs/ConfigurationDeviceSoftwareUpdateApi.md#process_software_image) | **POST** /device/action/software/package/{imageType} | 
*ConfigurationDeviceTemplateApi* | [**attach_device_template**](docs/ConfigurationDeviceTemplateApi.md#attach_device_template) | **POST** /template/device/config/attachment | 
*ConfigurationDeviceTemplateApi* | [**check_vbond**](docs/ConfigurationDeviceTemplateApi.md#check_vbond) | **GET** /template/device/config/vbond | 
*ConfigurationDeviceTemplateApi* | [**create_device_input**](docs/ConfigurationDeviceTemplateApi.md#create_device_input) | **POST** /template/device/config/input | 
*ConfigurationDeviceTemplateApi* | [**create_input_without_device**](docs/ConfigurationDeviceTemplateApi.md#create_input_without_device) | **POST** /template/device/config/exportcsv | 
*ConfigurationDeviceTemplateApi* | [**detach_device_template**](docs/ConfigurationDeviceTemplateApi.md#detach_device_template) | **POST** /template/device/config/detach | 
*ConfigurationDeviceTemplateApi* | [**detach_sites**](docs/ConfigurationDeviceTemplateApi.md#detach_sites) | **POST** /template/device/config/detachcloudx | 
*ConfigurationDeviceTemplateApi* | [**edit_cloudx_config**](docs/ConfigurationDeviceTemplateApi.md#edit_cloudx_config) | **PUT** /template/device/config/attachcloudx | 
*ConfigurationDeviceTemplateApi* | [**get_attached_config_to_device**](docs/ConfigurationDeviceTemplateApi.md#get_attached_config_to_device) | **GET** /template/device/config/attachedconfig | 
*ConfigurationDeviceTemplateApi* | [**get_attached_device_list**](docs/ConfigurationDeviceTemplateApi.md#get_attached_device_list) | **GET** /template/device/config/attached/{masterTemplateId} | 
*ConfigurationDeviceTemplateApi* | [**get_device_configuration_preview**](docs/ConfigurationDeviceTemplateApi.md#get_device_configuration_preview) | **POST** /template/device/config/config | 
*ConfigurationDeviceTemplateApi* | [**get_device_list_by_master_template_id**](docs/ConfigurationDeviceTemplateApi.md#get_device_list_by_master_template_id) | **GET** /template/device/config/available/{masterTemplateId} | 
*ConfigurationDeviceTemplateApi* | [**get_devices_with_duplicate_ip**](docs/ConfigurationDeviceTemplateApi.md#get_devices_with_duplicate_ip) | **POST** /template/device/config/duplicateip | 
*ConfigurationDeviceTemplateApi* | [**get_quick_connect_variables**](docs/ConfigurationDeviceTemplateApi.md#get_quick_connect_variables) | **POST** /template/device/config/quickconnectvariable | 
*ConfigurationDeviceTemplateApi* | [**process_input_comma_sep_file**](docs/ConfigurationDeviceTemplateApi.md#process_input_comma_sep_file) | **POST** /template/device/config/process/input/file | 
*ConfigurationDeviceTemplateApi* | [**push_cli_template**](docs/ConfigurationDeviceTemplateApi.md#push_cli_template) | **POST** /template/device/config/attachcli | 
*ConfigurationDeviceTemplateApi* | [**push_cloudx_config**](docs/ConfigurationDeviceTemplateApi.md#push_cloudx_config) | **POST** /template/device/config/attachcloudx | 
*ConfigurationDeviceTemplateApi* | [**push_master_template**](docs/ConfigurationDeviceTemplateApi.md#push_master_template) | **POST** /template/device/config/attachfeature | 
*ConfigurationDeviceTemplateApi* | [**push_master_template1**](docs/ConfigurationDeviceTemplateApi.md#push_master_template1) | **POST** /template/device/config/attachBootStrap | 
*ConfigurationDeviceTemplateApi* | [**validate_template**](docs/ConfigurationDeviceTemplateApi.md#validate_template) | **POST** /template/device/config/verify | 
*ConfigurationDisasterRecoveryApi* | [**activate**](docs/ConfigurationDisasterRecoveryApi.md#activate) | **POST** /disasterrecovery/activate | 
*ConfigurationDisasterRecoveryApi* | [**delete**](docs/ConfigurationDisasterRecoveryApi.md#delete) | **POST** /disasterrecovery/deregister | 
*ConfigurationDisasterRecoveryApi* | [**delete_dc**](docs/ConfigurationDisasterRecoveryApi.md#delete_dc) | **POST** /disasterrecovery/deleteRemoteDataCenter | 
*ConfigurationDisasterRecoveryApi* | [**delete_local_dc**](docs/ConfigurationDisasterRecoveryApi.md#delete_local_dc) | **POST** /disasterrecovery/deleteLocalDataCenter | 
*ConfigurationDisasterRecoveryApi* | [**disaster_recovery_pause_replication**](docs/ConfigurationDisasterRecoveryApi.md#disaster_recovery_pause_replication) | **POST** /disasterrecovery/pausereplication | 
*ConfigurationDisasterRecoveryApi* | [**disaster_recovery_replication_request**](docs/ConfigurationDisasterRecoveryApi.md#disaster_recovery_replication_request) | **POST** /disasterrecovery/requestimport | 
*ConfigurationDisasterRecoveryApi* | [**disaster_recovery_un_pause_replication**](docs/ConfigurationDisasterRecoveryApi.md#disaster_recovery_un_pause_replication) | **POST** /disasterrecovery/unpausereplication | 
*ConfigurationDisasterRecoveryApi* | [**download**](docs/ConfigurationDisasterRecoveryApi.md#download) | **GET** /disasterrecovery/download/backup/{token}/db_bkp.tar.gz | 
*ConfigurationDisasterRecoveryApi* | [**download_replication_data**](docs/ConfigurationDisasterRecoveryApi.md#download_replication_data) | **GET** /disasterrecovery/download/{token}/{fileName} | 
*ConfigurationDisasterRecoveryApi* | [**get**](docs/ConfigurationDisasterRecoveryApi.md#get) | **GET** /disasterrecovery/usernames | 
*ConfigurationDisasterRecoveryApi* | [**get_cluster_info**](docs/ConfigurationDisasterRecoveryApi.md#get_cluster_info) | **GET** /disasterrecovery/clusterInfo | 
*ConfigurationDisasterRecoveryApi* | [**get_config_db_restore_status**](docs/ConfigurationDisasterRecoveryApi.md#get_config_db_restore_status) | **GET** /disasterrecovery/dbrestorestatus | 
*ConfigurationDisasterRecoveryApi* | [**get_details**](docs/ConfigurationDisasterRecoveryApi.md#get_details) | **GET** /disasterrecovery/details | 
*ConfigurationDisasterRecoveryApi* | [**get_disaster_recovery_local_replication_schedule**](docs/ConfigurationDisasterRecoveryApi.md#get_disaster_recovery_local_replication_schedule) | **GET** /disasterrecovery/schedule | 
*ConfigurationDisasterRecoveryApi* | [**get_disaster_recovery_status**](docs/ConfigurationDisasterRecoveryApi.md#get_disaster_recovery_status) | **GET** /disasterrecovery/drstatus | 
*ConfigurationDisasterRecoveryApi* | [**get_history**](docs/ConfigurationDisasterRecoveryApi.md#get_history) | **GET** /disasterrecovery/history | 
*ConfigurationDisasterRecoveryApi* | [**get_local_data_center_state**](docs/ConfigurationDisasterRecoveryApi.md#get_local_data_center_state) | **GET** /disasterrecovery/localdc | 
*ConfigurationDisasterRecoveryApi* | [**get_local_history**](docs/ConfigurationDisasterRecoveryApi.md#get_local_history) | **GET** /disasterrecovery/localLatestHistory | 
*ConfigurationDisasterRecoveryApi* | [**get_reachability_info**](docs/ConfigurationDisasterRecoveryApi.md#get_reachability_info) | **POST** /disasterrecovery/validateNodes | 
*ConfigurationDisasterRecoveryApi* | [**get_remote_data_center_state**](docs/ConfigurationDisasterRecoveryApi.md#get_remote_data_center_state) | **GET** /disasterrecovery/remotedc | 
*ConfigurationDisasterRecoveryApi* | [**get_remote_data_center_version**](docs/ConfigurationDisasterRecoveryApi.md#get_remote_data_center_version) | **GET** /disasterrecovery/remotedc/swversion | 
*ConfigurationDisasterRecoveryApi* | [**get_remote_dc_members_state**](docs/ConfigurationDisasterRecoveryApi.md#get_remote_dc_members_state) | **GET** /disasterrecovery/remoteDcState | 
*ConfigurationDisasterRecoveryApi* | [**getdr_status**](docs/ConfigurationDisasterRecoveryApi.md#getdr_status) | **GET** /disasterrecovery/status | 
*ConfigurationDisasterRecoveryApi* | [**pause_dr**](docs/ConfigurationDisasterRecoveryApi.md#pause_dr) | **POST** /disasterrecovery/pause | 
*ConfigurationDisasterRecoveryApi* | [**pause_local_arbitrator**](docs/ConfigurationDisasterRecoveryApi.md#pause_local_arbitrator) | **POST** /disasterrecovery/pauseLocalArbitrator | 
*ConfigurationDisasterRecoveryApi* | [**pause_local_dc_for_dr**](docs/ConfigurationDisasterRecoveryApi.md#pause_local_dc_for_dr) | **POST** /disasterrecovery/pauseLocalDC | 
*ConfigurationDisasterRecoveryApi* | [**pause_local_dc_replication**](docs/ConfigurationDisasterRecoveryApi.md#pause_local_dc_replication) | **POST** /disasterrecovery/pauseLocalReplication | 
*ConfigurationDisasterRecoveryApi* | [**register**](docs/ConfigurationDisasterRecoveryApi.md#register) | **POST** /disasterrecovery/register | 
*ConfigurationDisasterRecoveryApi* | [**restart_data_center**](docs/ConfigurationDisasterRecoveryApi.md#restart_data_center) | **POST** /disasterrecovery/restartDataCenter | 
*ConfigurationDisasterRecoveryApi* | [**restore_config_db**](docs/ConfigurationDisasterRecoveryApi.md#restore_config_db) | **POST** /disasterrecovery/dbrestore | 
*ConfigurationDisasterRecoveryApi* | [**unpause_dr**](docs/ConfigurationDisasterRecoveryApi.md#unpause_dr) | **POST** /disasterrecovery/unpause | 
*ConfigurationDisasterRecoveryApi* | [**unpause_local_arbitrator**](docs/ConfigurationDisasterRecoveryApi.md#unpause_local_arbitrator) | **POST** /disasterrecovery/unpauseLocalArbitrator | 
*ConfigurationDisasterRecoveryApi* | [**unpause_local_dc_for_dr**](docs/ConfigurationDisasterRecoveryApi.md#unpause_local_dc_for_dr) | **POST** /disasterrecovery/unpauseLocalDC | 
*ConfigurationDisasterRecoveryApi* | [**unpause_local_dc_replication**](docs/ConfigurationDisasterRecoveryApi.md#unpause_local_dc_replication) | **POST** /disasterrecovery/unpauseLocalReplication | 
*ConfigurationDisasterRecoveryApi* | [**update**](docs/ConfigurationDisasterRecoveryApi.md#update) | **POST** /disasterrecovery/password | 
*ConfigurationDisasterRecoveryApi* | [**update1**](docs/ConfigurationDisasterRecoveryApi.md#update1) | **PUT** /disasterrecovery/register | 
*ConfigurationDisasterRecoveryApi* | [**update_disaster_recovery_state**](docs/ConfigurationDisasterRecoveryApi.md#update_disaster_recovery_state) | **POST** /disasterrecovery/remotePassword | 
*ConfigurationDisasterRecoveryApi* | [**update_disaster_recovery_state1**](docs/ConfigurationDisasterRecoveryApi.md#update_disaster_recovery_state1) | **POST** /disasterrecovery/remotedc | 
*ConfigurationDisasterRecoveryApi* | [**update_dr_state**](docs/ConfigurationDisasterRecoveryApi.md#update_dr_state) | **POST** /disasterrecovery/updateDRConfigOnArbitrator | 
*ConfigurationDisasterRecoveryApi* | [**update_replication**](docs/ConfigurationDisasterRecoveryApi.md#update_replication) | **POST** /disasterrecovery/updateReplication | 
*ConfigurationFQDNListBuilderApi* | [**create_policy_list16**](docs/ConfigurationFQDNListBuilderApi.md#create_policy_list16) | **POST** /template/policy/list/fqdn | 
*ConfigurationFQDNListBuilderApi* | [**delete_policy_list16**](docs/ConfigurationFQDNListBuilderApi.md#delete_policy_list16) | **DELETE** /template/policy/list/fqdn/{id} | 
*ConfigurationFQDNListBuilderApi* | [**delete_policy_lists_with_info_tag16**](docs/ConfigurationFQDNListBuilderApi.md#delete_policy_lists_with_info_tag16) | **DELETE** /template/policy/list/fqdn | 
*ConfigurationFQDNListBuilderApi* | [**edit_policy_list16**](docs/ConfigurationFQDNListBuilderApi.md#edit_policy_list16) | **PUT** /template/policy/list/fqdn/{id} | 
*ConfigurationFQDNListBuilderApi* | [**get_lists_by_id16**](docs/ConfigurationFQDNListBuilderApi.md#get_lists_by_id16) | **GET** /template/policy/list/fqdn/{id} | 
*ConfigurationFQDNListBuilderApi* | [**get_policy_lists14**](docs/ConfigurationFQDNListBuilderApi.md#get_policy_lists14) | **GET** /template/policy/list/fqdn | 
*ConfigurationFQDNListBuilderApi* | [**get_policy_lists_with_info_tag16**](docs/ConfigurationFQDNListBuilderApi.md#get_policy_lists_with_info_tag16) | **GET** /template/policy/list/fqdn/filtered | 
*ConfigurationFQDNListBuilderApi* | [**preview_policy_list16**](docs/ConfigurationFQDNListBuilderApi.md#preview_policy_list16) | **POST** /template/policy/list/fqdn/preview | 
*ConfigurationFQDNListBuilderApi* | [**preview_policy_list_by_id16**](docs/ConfigurationFQDNListBuilderApi.md#preview_policy_list_by_id16) | **GET** /template/policy/list/fqdn/preview/{id} | 
*ConfigurationFeatureCertificateApi* | [**gen_device_csr**](docs/ConfigurationFeatureCertificateApi.md#gen_device_csr) | **PUT** /featurecertificate/devicecsr | 
*ConfigurationFeatureCertificateApi* | [**get_device_certificate**](docs/ConfigurationFeatureCertificateApi.md#get_device_certificate) | **GET** /featurecertificate/certificate | 
*ConfigurationFeatureCertificateApi* | [**get_device_csr**](docs/ConfigurationFeatureCertificateApi.md#get_device_csr) | **GET** /featurecertificate/devicecsr | 
*ConfigurationFeatureCertificateApi* | [**get_feature_ca_state**](docs/ConfigurationFeatureCertificateApi.md#get_feature_ca_state) | **GET** /featurecertificate/syslogconfig | 
*ConfigurationFeatureCertificateApi* | [**install_feature_certificate**](docs/ConfigurationFeatureCertificateApi.md#install_feature_certificate) | **PUT** /featurecertificate/certificate | 
*ConfigurationFeatureCertificateApi* | [**revoke_feature_certificate**](docs/ConfigurationFeatureCertificateApi.md#revoke_feature_certificate) | **PUT** /featurecertificate/revoke | 
*ConfigurationFeatureProfileMobilityApi* | [**create_basic_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#create_basic_profile_parcel_for_mobility) | **POST** /v1/feature-profile/mobility/global/{profileId}/basic | 
*ConfigurationFeatureProfileMobilityApi* | [**create_cellular_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#create_cellular_profile_parcel_for_mobility) | **POST** /v1/feature-profile/mobility/global/{profileId}/cellular | 
*ConfigurationFeatureProfileMobilityApi* | [**create_ethernet_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#create_ethernet_profile_parcel_for_mobility) | **POST** /v1/feature-profile/mobility/global/{profileId}/ethernet | 
*ConfigurationFeatureProfileMobilityApi* | [**create_mobility_config_profile_parcel_for_cli**](docs/ConfigurationFeatureProfileMobilityApi.md#create_mobility_config_profile_parcel_for_cli) | **POST** /v1/feature-profile/mobility/cli/{cliId}/config | 
*ConfigurationFeatureProfileMobilityApi* | [**create_network_protocol_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#create_network_protocol_profile_parcel_for_mobility) | **POST** /v1/feature-profile/mobility/global/{profileId}/networkProtocol | 
*ConfigurationFeatureProfileMobilityApi* | [**create_security_policy_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#create_security_policy_profile_parcel_for_mobility) | **POST** /v1/feature-profile/mobility/global/{profileId}/securityPolicy | 
*ConfigurationFeatureProfileMobilityApi* | [**create_vpn_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#create_vpn_profile_parcel_for_mobility) | **POST** /v1/feature-profile/mobility/global/{profileId}/vpn | 
*ConfigurationFeatureProfileMobilityApi* | [**create_wifi_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#create_wifi_profile_parcel_for_mobility) | **POST** /v1/feature-profile/mobility/global/{profileId}/wifi | 
*ConfigurationFeatureProfileMobilityApi* | [**delete_a_cellular_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#delete_a_cellular_profile_parcel_for_mobility) | **DELETE** /v1/feature-profile/mobility/global/{profileId}/cellular/{cellularId} | 
*ConfigurationFeatureProfileMobilityApi* | [**delete_a_vpn_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#delete_a_vpn_profile_parcel_for_mobility) | **DELETE** /v1/feature-profile/mobility/global/{profileId}/vpn/{vpnId} | 
*ConfigurationFeatureProfileMobilityApi* | [**delete_basic_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#delete_basic_profile_parcel_for_mobility) | **DELETE** /v1/feature-profile/mobility/global/{profileId}/basic/{parcelId} | 
*ConfigurationFeatureProfileMobilityApi* | [**delete_ethernet_profile_parcel_for_system**](docs/ConfigurationFeatureProfileMobilityApi.md#delete_ethernet_profile_parcel_for_system) | **DELETE** /v1/feature-profile/mobility/global/{profileId}/ethernet/{ethernetId} | 
*ConfigurationFeatureProfileMobilityApi* | [**delete_mobility_config_profile_parcel_for_cli**](docs/ConfigurationFeatureProfileMobilityApi.md#delete_mobility_config_profile_parcel_for_cli) | **DELETE** /v1/feature-profile/mobility/cli/{cliId}/config/{configId} | 
*ConfigurationFeatureProfileMobilityApi* | [**delete_network_protocol_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#delete_network_protocol_profile_parcel_for_mobility) | **DELETE** /v1/feature-profile/mobility/global/{profileId}/networkProtocol/{networkProtocolId} | 
*ConfigurationFeatureProfileMobilityApi* | [**delete_security_policy_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#delete_security_policy_profile_parcel_for_mobility) | **DELETE** /v1/feature-profile/mobility/global/{profileId}/securityPolicy/{securityPolicyId} | 
*ConfigurationFeatureProfileMobilityApi* | [**delete_wifi_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#delete_wifi_profile_parcel_for_mobility) | **DELETE** /v1/feature-profile/mobility/global/{profileId}/wifi/{wifiId} | 
*ConfigurationFeatureProfileMobilityApi* | [**edit_basic_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#edit_basic_profile_parcel_for_mobility) | **PUT** /v1/feature-profile/mobility/global/{profileId}/basic/{parcelId} | 
*ConfigurationFeatureProfileMobilityApi* | [**edit_cellular_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#edit_cellular_profile_parcel_for_mobility) | **PUT** /v1/feature-profile/mobility/global/{profileId}/cellular/{cellularId} | 
*ConfigurationFeatureProfileMobilityApi* | [**edit_ethernet_profile_parcel_for_system**](docs/ConfigurationFeatureProfileMobilityApi.md#edit_ethernet_profile_parcel_for_system) | **PUT** /v1/feature-profile/mobility/global/{profileId}/ethernet/{ethernetId} | 
*ConfigurationFeatureProfileMobilityApi* | [**edit_mobility_config_profile_parcel_for_cli**](docs/ConfigurationFeatureProfileMobilityApi.md#edit_mobility_config_profile_parcel_for_cli) | **PUT** /v1/feature-profile/mobility/cli/{cliId}/config/{configId} | 
*ConfigurationFeatureProfileMobilityApi* | [**edit_network_protocol_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#edit_network_protocol_profile_parcel_for_mobility) | **PUT** /v1/feature-profile/mobility/global/{profileId}/networkProtocol/{networkProtocolId} | 
*ConfigurationFeatureProfileMobilityApi* | [**edit_security_policy_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#edit_security_policy_profile_parcel_for_mobility) | **PUT** /v1/feature-profile/mobility/global/{profileId}/securityPolicy/{securityPolicyId} | 
*ConfigurationFeatureProfileMobilityApi* | [**edit_vpn_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#edit_vpn_profile_parcel_for_mobility) | **PUT** /v1/feature-profile/mobility/global/{profileId}/vpn/{vpnId} | 
*ConfigurationFeatureProfileMobilityApi* | [**edit_wifi_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#edit_wifi_profile_parcel_for_mobility) | **PUT** /v1/feature-profile/mobility/global/{profileId}/wifi/{wifiId} | 
*ConfigurationFeatureProfileMobilityApi* | [**get_basic_profile_parcel_by_parcel_id_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#get_basic_profile_parcel_by_parcel_id_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/basic/{parcelId} | 
*ConfigurationFeatureProfileMobilityApi* | [**get_basic_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#get_basic_profile_parcel_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/basic | 
*ConfigurationFeatureProfileMobilityApi* | [**get_cellular_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#get_cellular_profile_parcel_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/cellular/{cellularId} | 
*ConfigurationFeatureProfileMobilityApi* | [**get_cellular_profile_parcel_list_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#get_cellular_profile_parcel_list_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/cellular | 
*ConfigurationFeatureProfileMobilityApi* | [**get_ethernet_profile_parcel**](docs/ConfigurationFeatureProfileMobilityApi.md#get_ethernet_profile_parcel) | **GET** /v1/feature-profile/mobility/global/{profileId}/ethernet/{ethernetId} | 
*ConfigurationFeatureProfileMobilityApi* | [**get_ethernet_profile_parcels**](docs/ConfigurationFeatureProfileMobilityApi.md#get_ethernet_profile_parcels) | **GET** /v1/feature-profile/mobility/global/{profileId}/ethernet | 
*ConfigurationFeatureProfileMobilityApi* | [**get_mobility_config_profile_parcel_by_parcel_id_for_cli**](docs/ConfigurationFeatureProfileMobilityApi.md#get_mobility_config_profile_parcel_by_parcel_id_for_cli) | **GET** /v1/feature-profile/mobility/cli/{cliId}/config/{configId} | 
*ConfigurationFeatureProfileMobilityApi* | [**get_mobility_config_profile_parcel_for_cli**](docs/ConfigurationFeatureProfileMobilityApi.md#get_mobility_config_profile_parcel_for_cli) | **GET** /v1/feature-profile/mobility/cli/{cliId}/config | 
*ConfigurationFeatureProfileMobilityApi* | [**get_mobility_feature_profile_by_global_id**](docs/ConfigurationFeatureProfileMobilityApi.md#get_mobility_feature_profile_by_global_id) | **GET** /v1/feature-profile/mobility/global/{profileId} | 
*ConfigurationFeatureProfileMobilityApi* | [**get_mobility_global_basic_parcel_schema_by_schema_type**](docs/ConfigurationFeatureProfileMobilityApi.md#get_mobility_global_basic_parcel_schema_by_schema_type) | **GET** /v1/feature-profile/mobility/global/basic/schema | 
*ConfigurationFeatureProfileMobilityApi* | [**get_network_protocol_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#get_network_protocol_profile_parcel_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/networkProtocol/{networkProtocolId} | 
*ConfigurationFeatureProfileMobilityApi* | [**get_network_protocol_profile_parcel_list_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#get_network_protocol_profile_parcel_list_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/networkProtocol | 
*ConfigurationFeatureProfileMobilityApi* | [**get_security_policy_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#get_security_policy_profile_parcel_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/securityPolicy/{securityPolicyId} | 
*ConfigurationFeatureProfileMobilityApi* | [**get_security_policy_profile_parcel_list_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#get_security_policy_profile_parcel_list_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/securityPolicy | 
*ConfigurationFeatureProfileMobilityApi* | [**get_vpn_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#get_vpn_profile_parcel_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/vpn/{vpnId} | 
*ConfigurationFeatureProfileMobilityApi* | [**get_vpn_profile_parcel_list_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#get_vpn_profile_parcel_list_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/vpn | 
*ConfigurationFeatureProfileMobilityApi* | [**get_wifi_profile_parcel_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#get_wifi_profile_parcel_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/wifi/{wifiId} | 
*ConfigurationFeatureProfileMobilityApi* | [**get_wifi_profile_parcel_list_for_mobility**](docs/ConfigurationFeatureProfileMobilityApi.md#get_wifi_profile_parcel_list_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/wifi | 
*ConfigurationFeatureProfileSDWANApi* | [**create_aaa_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#create_aaa_profile_parcel_for_system) | **POST** /v1/feature-profile/sdwan/system/{systemId}/aaa | 
*ConfigurationFeatureProfileSDWANApi* | [**create_banner_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#create_banner_profile_parcel_for_system) | **POST** /v1/feature-profile/sdwan/system/{systemId}/banner | 
*ConfigurationFeatureProfileSDWANApi* | [**create_basic_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#create_basic_profile_parcel_for_system) | **POST** /v1/feature-profile/sdwan/system/{systemId}/basic | 
*ConfigurationFeatureProfileSDWANApi* | [**create_bfd_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#create_bfd_profile_parcel_for_system) | **POST** /v1/feature-profile/sdwan/system/{systemId}/bfd | 
*ConfigurationFeatureProfileSDWANApi* | [**create_cellular_controller_and_cellular_profile_parcel_association_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#create_cellular_controller_and_cellular_profile_parcel_association_for_transport) | **POST** /v1/feature-profile/sdwan/transport/{transportId}/cellular-controller/{cellularControllerId}/cellular-profile | 
*ConfigurationFeatureProfileSDWANApi* | [**create_cellular_controller_profile_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#create_cellular_controller_profile_parcel_for_transport) | **POST** /v1/feature-profile/sdwan/transport/{transportId}/cellular-controller | 
*ConfigurationFeatureProfileSDWANApi* | [**create_cellular_profile_profile_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#create_cellular_profile_profile_parcel_for_transport) | **POST** /v1/feature-profile/sdwan/transport/{transportId}/cellular-profile | 
*ConfigurationFeatureProfileSDWANApi* | [**create_global_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#create_global_profile_parcel_for_system) | **POST** /v1/feature-profile/sdwan/system/{systemId}/global | 
*ConfigurationFeatureProfileSDWANApi* | [**create_lan_vpn_and_routing_bgp_parcel_association_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#create_lan_vpn_and_routing_bgp_parcel_association_for_service) | **POST** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/routing/bgp | 
*ConfigurationFeatureProfileSDWANApi* | [**create_lan_vpn_and_routing_ospf_parcel_association_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#create_lan_vpn_and_routing_ospf_parcel_association_for_service) | **POST** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/routing/ospf | 
*ConfigurationFeatureProfileSDWANApi* | [**create_lan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#create_lan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport) | **POST** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnParcelId}/interface/ethernet/{ethernetId}/tracker | 
*ConfigurationFeatureProfileSDWANApi* | [**create_lan_vpn_interface_ethernet_parcel_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#create_lan_vpn_interface_ethernet_parcel_for_service) | **POST** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/interface/ethernet | 
*ConfigurationFeatureProfileSDWANApi* | [**create_lan_vpn_profile_parcel_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#create_lan_vpn_profile_parcel_for_service) | **POST** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn | 
*ConfigurationFeatureProfileSDWANApi* | [**create_logging_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#create_logging_profile_parcel_for_system) | **POST** /v1/feature-profile/sdwan/system/{systemId}/logging | 
*ConfigurationFeatureProfileSDWANApi* | [**create_management_vpn_interface_ethernet_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#create_management_vpn_interface_ethernet_parcel_for_transport) | **POST** /v1/feature-profile/sdwan/transport/{transportId}/management/vpn/{vpnId}/interface/ethernet | 
*ConfigurationFeatureProfileSDWANApi* | [**create_management_vpn_profile_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#create_management_vpn_profile_parcel_for_transport) | **POST** /v1/feature-profile/sdwan/transport/{transportId}/management/vpn | 
*ConfigurationFeatureProfileSDWANApi* | [**create_ntp_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#create_ntp_profile_parcel_for_system) | **POST** /v1/feature-profile/sdwan/system/{systemId}/ntp | 
*ConfigurationFeatureProfileSDWANApi* | [**create_omp_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#create_omp_profile_parcel_for_system) | **POST** /v1/feature-profile/sdwan/system/{systemId}/omp | 
*ConfigurationFeatureProfileSDWANApi* | [**create_routing_bgp_profile_parcel_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#create_routing_bgp_profile_parcel_for_service) | **POST** /v1/feature-profile/sdwan/service/{serviceId}/routing/bgp | 
*ConfigurationFeatureProfileSDWANApi* | [**create_routing_ospf_profile_parcel_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#create_routing_ospf_profile_parcel_for_service) | **POST** /v1/feature-profile/sdwan/service/{serviceId}/routing/ospf | 
*ConfigurationFeatureProfileSDWANApi* | [**create_sdwan_config_profile_parcel_for_cli**](docs/ConfigurationFeatureProfileSDWANApi.md#create_sdwan_config_profile_parcel_for_cli) | **POST** /v1/feature-profile/sdwan/cli/{cliId}/config | 
*ConfigurationFeatureProfileSDWANApi* | [**create_sdwan_feature_profile**](docs/ConfigurationFeatureProfileSDWANApi.md#create_sdwan_feature_profile) | **POST** /v1/feature-profile/sdwan/cli | 
*ConfigurationFeatureProfileSDWANApi* | [**create_sdwan_service_feature_profile**](docs/ConfigurationFeatureProfileSDWANApi.md#create_sdwan_service_feature_profile) | **POST** /v1/feature-profile/sdwan/service | 
*ConfigurationFeatureProfileSDWANApi* | [**create_sdwan_system_feature_profile**](docs/ConfigurationFeatureProfileSDWANApi.md#create_sdwan_system_feature_profile) | **POST** /v1/feature-profile/sdwan/system | 
*ConfigurationFeatureProfileSDWANApi* | [**create_sdwan_transport_feature_profile**](docs/ConfigurationFeatureProfileSDWANApi.md#create_sdwan_transport_feature_profile) | **POST** /v1/feature-profile/sdwan/transport | 
*ConfigurationFeatureProfileSDWANApi* | [**create_tracker_profile_parcel_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#create_tracker_profile_parcel_for_service) | **POST** /v1/feature-profile/sdwan/service/{serviceId}/tracker | 
*ConfigurationFeatureProfileSDWANApi* | [**create_tracker_profile_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#create_tracker_profile_parcel_for_transport) | **POST** /v1/feature-profile/sdwan/transport/{transportId}/tracker | 
*ConfigurationFeatureProfileSDWANApi* | [**create_wan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#create_wan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport) | **POST** /v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnParcelId}/interface/ethernet/{ethernetId}/tracker | 
*ConfigurationFeatureProfileSDWANApi* | [**create_wan_vpn_interface_ethernet_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#create_wan_vpn_interface_ethernet_parcel_for_transport) | **POST** /v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId}/interface/ethernet | 
*ConfigurationFeatureProfileSDWANApi* | [**create_wan_vpn_profile_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#create_wan_vpn_profile_parcel_for_transport) | **POST** /v1/feature-profile/sdwan/transport/{transportId}/wan/vpn | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_aaa_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_aaa_profile_parcel_for_system) | **DELETE** /v1/feature-profile/sdwan/system/{systemId}/aaa/{aaaId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_banner_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_banner_profile_parcel_for_system) | **DELETE** /v1/feature-profile/sdwan/system/{systemId}/banner/{bannerId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_basic_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_basic_profile_parcel_for_system) | **DELETE** /v1/feature-profile/sdwan/system/{systemId}/basic/{basicId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_bfd_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_bfd_profile_parcel_for_system) | **DELETE** /v1/feature-profile/sdwan/system/{systemId}/bfd/{bfdId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_cellular_controller_and_cellular_profile_association_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_cellular_controller_and_cellular_profile_association_for_transport) | **DELETE** /v1/feature-profile/sdwan/transport/{transportId}/cellular-controller/{cellularControllerId}/cellular-profile/{cellularProfileId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_cellular_controller_profile_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_cellular_controller_profile_parcel_for_transport) | **DELETE** /v1/feature-profile/sdwan/transport/{transportId}/cellular-controller/{cellularControllerId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_cellular_profile_profile_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_cellular_profile_profile_parcel_for_transport) | **DELETE** /v1/feature-profile/sdwan/transport/{transportId}/cellular-profile/{cellularProfileId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_config_profile_parcel_for_cli**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_config_profile_parcel_for_cli) | **DELETE** /v1/feature-profile/sdwan/cli/{cliId}/config/{configId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_global_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_global_profile_parcel_for_system) | **DELETE** /v1/feature-profile/sdwan/system/{systemId}/global/{globalId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_lan_vpn_and_routing_bgp_association_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_lan_vpn_and_routing_bgp_association_for_service) | **DELETE** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/routing/bgp/{bgpId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_lan_vpn_and_routing_ospf_association_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_lan_vpn_and_routing_ospf_association_for_service) | **DELETE** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/routing/ospf/{ospfId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_lan_vpn_interface_ethernet_and_tracker_association_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_lan_vpn_interface_ethernet_and_tracker_association_for_transport) | **DELETE** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/interface/ethernet/{ethernetId}/tracker/{trackerId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_lan_vpn_interface_ethernet_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_lan_vpn_interface_ethernet_for_service) | **DELETE** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/interface/ethernet/{ethernetId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_lan_vpn_profile_parcel_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_lan_vpn_profile_parcel_for_service) | **DELETE** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_logging_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_logging_profile_parcel_for_system) | **DELETE** /v1/feature-profile/sdwan/system/{systemId}/logging/{loggingId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_management_vpn_interface_ethernet_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_management_vpn_interface_ethernet_for_transport) | **DELETE** /v1/feature-profile/sdwan/transport/{transportId}/management/vpn/{vpnId}/interface/ethernet/{ethernetId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_management_vpn_profile_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_management_vpn_profile_parcel_for_transport) | **DELETE** /v1/feature-profile/sdwan/transport/{transportId}/management/vpn/{vpnId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_ntp_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_ntp_profile_parcel_for_system) | **DELETE** /v1/feature-profile/sdwan/system/{systemId}/ntp/{ntpId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_omp_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_omp_profile_parcel_for_system) | **DELETE** /v1/feature-profile/sdwan/system/{systemId}/omp/{ompId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_routing_bgp_profile_parcel_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_routing_bgp_profile_parcel_for_service) | **DELETE** /v1/feature-profile/sdwan/service/{serviceId}/routing/bgp/{bgpId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_routing_ospf_profile_parcel_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_routing_ospf_profile_parcel_for_service) | **DELETE** /v1/feature-profile/sdwan/service/{serviceId}/routing/ospf/{ospfId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_sdwan_feature_profile_for_cli**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_sdwan_feature_profile_for_cli) | **DELETE** /v1/feature-profile/sdwan/cli/{cliId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_sdwan_service_feature_profile**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_sdwan_service_feature_profile) | **DELETE** /v1/feature-profile/sdwan/service/{serviceId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_sdwan_system_feature_profile**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_sdwan_system_feature_profile) | **DELETE** /v1/feature-profile/sdwan/system/{systemId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_sdwan_transport_feature_profile**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_sdwan_transport_feature_profile) | **DELETE** /v1/feature-profile/sdwan/transport/{transportId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_tracker_profile_parcel_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_tracker_profile_parcel_for_service) | **DELETE** /v1/feature-profile/sdwan/service/{serviceId}/tracker/{trackerId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_tracker_profile_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_tracker_profile_parcel_for_transport) | **DELETE** /v1/feature-profile/sdwan/transport/{transportId}/tracker/{trackerId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_wan_vpn_interface_ethernet_and_tracker_association_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_wan_vpn_interface_ethernet_and_tracker_association_for_transport) | **DELETE** /v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId}/interface/ethernet/{ethernetId}/tracker/{trackerId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_wan_vpn_interface_ethernet_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_wan_vpn_interface_ethernet_for_transport) | **DELETE** /v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId}/interface/ethernet/{ethernetId} | 
*ConfigurationFeatureProfileSDWANApi* | [**delete_wan_vpn_profile_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#delete_wan_vpn_profile_parcel_for_transport) | **DELETE** /v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_aaa_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_aaa_profile_parcel_for_system) | **PUT** /v1/feature-profile/sdwan/system/{systemId}/aaa/{aaaId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_banner_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_banner_profile_parcel_for_system) | **PUT** /v1/feature-profile/sdwan/system/{systemId}/banner/{bannerId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_basic_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_basic_profile_parcel_for_system) | **PUT** /v1/feature-profile/sdwan/system/{systemId}/basic/{basicId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_bfd_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_bfd_profile_parcel_for_system) | **PUT** /v1/feature-profile/sdwan/system/{systemId}/bfd/{bfdId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_cellular_controller_and_cellular_profile_parcel_association_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_cellular_controller_and_cellular_profile_parcel_association_for_transport) | **PUT** /v1/feature-profile/sdwan/transport/{transportId}/cellular-controller/{cellularControllerId}/cellular-profile/{cellularProfileId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_cellular_controller_profile_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_cellular_controller_profile_parcel_for_transport) | **PUT** /v1/feature-profile/sdwan/transport/{transportId}/cellular-controller/{cellularControllerId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_cellular_profile_profile_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_cellular_profile_profile_parcel_for_transport) | **PUT** /v1/feature-profile/sdwan/transport/{transportId}/cellular-profile/{cellularProfileId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_config_profile_parcel_for_cli**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_config_profile_parcel_for_cli) | **PUT** /v1/feature-profile/sdwan/cli/{cliId}/config/{configId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_global_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_global_profile_parcel_for_system) | **PUT** /v1/feature-profile/sdwan/system/{systemId}/global/{globalId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_lan_vpn_and_routing_bgp_parcel_association_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_lan_vpn_and_routing_bgp_parcel_association_for_service) | **PUT** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/routing/bgp/{bgpId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_lan_vpn_and_routing_ospf_parcel_association_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_lan_vpn_and_routing_ospf_parcel_association_for_service) | **PUT** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/routing/ospf/{ospfId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_lan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_lan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport) | **PUT** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/interface/ethernet/{ethernetId}/tracker/{trackerId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_lan_vpn_interface_ethernet_parcel_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_lan_vpn_interface_ethernet_parcel_for_service) | **PUT** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/interface/ethernet/{ethernetId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_lan_vpn_profile_parcel_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_lan_vpn_profile_parcel_for_service) | **PUT** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_logging_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_logging_profile_parcel_for_system) | **PUT** /v1/feature-profile/sdwan/system/{systemId}/logging/{loggingId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_management_vpn_interface_ethernet_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_management_vpn_interface_ethernet_parcel_for_transport) | **PUT** /v1/feature-profile/sdwan/transport/{transportId}/management/vpn/{vpnId}/interface/ethernet/{ethernetId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_management_vpn_profile_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_management_vpn_profile_parcel_for_transport) | **PUT** /v1/feature-profile/sdwan/transport/{transportId}/management/vpn/{vpnId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_ntp_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_ntp_profile_parcel_for_system) | **PUT** /v1/feature-profile/sdwan/system/{systemId}/ntp/{ntpId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_omp_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_omp_profile_parcel_for_system) | **PUT** /v1/feature-profile/sdwan/system/{systemId}/omp/{ompId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_routing_bgp_profile_parcel_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_routing_bgp_profile_parcel_for_service) | **PUT** /v1/feature-profile/sdwan/service/{serviceId}/routing/bgp/{bgpId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_routing_ospf_profile_parcel_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_routing_ospf_profile_parcel_for_service) | **PUT** /v1/feature-profile/sdwan/service/{serviceId}/routing/ospf/{ospfId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_sdwan_feature_profile**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_sdwan_feature_profile) | **PUT** /v1/feature-profile/sdwan/cli/{cliId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_sdwan_service_feature_profile**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_sdwan_service_feature_profile) | **PUT** /v1/feature-profile/sdwan/service/{serviceId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_sdwan_system_feature_profile**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_sdwan_system_feature_profile) | **PUT** /v1/feature-profile/sdwan/system/{systemId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_sdwan_transport_feature_profile**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_sdwan_transport_feature_profile) | **PUT** /v1/feature-profile/sdwan/transport/{transportId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_tracker_profile_parcel_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_tracker_profile_parcel_for_service) | **PUT** /v1/feature-profile/sdwan/service/{serviceId}/tracker/{trackerId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_tracker_profile_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_tracker_profile_parcel_for_transport) | **PUT** /v1/feature-profile/sdwan/transport/{transportId}/tracker/{trackerId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_wan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_wan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport) | **PUT** /v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId}/interface/ethernet/{ethernetId}/tracker/{trackerId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_wan_vpn_interface_ethernet_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_wan_vpn_interface_ethernet_parcel_for_transport) | **PUT** /v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId}/interface/ethernet/{ethernetId} | 
*ConfigurationFeatureProfileSDWANApi* | [**edit_wan_vpn_profile_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#edit_wan_vpn_profile_parcel_for_transport) | **PUT** /v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_aaa_profile_parcel_by_parcel_id_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#get_aaa_profile_parcel_by_parcel_id_for_system) | **GET** /v1/feature-profile/sdwan/system/{systemId}/aaa/{aaaId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_aaa_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#get_aaa_profile_parcel_for_system) | **GET** /v1/feature-profile/sdwan/system/{systemId}/aaa | 
*ConfigurationFeatureProfileSDWANApi* | [**get_banner_profile_parcel_by_parcel_id_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#get_banner_profile_parcel_by_parcel_id_for_system) | **GET** /v1/feature-profile/sdwan/system/{systemId}/banner/{bannerId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_banner_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#get_banner_profile_parcel_for_system) | **GET** /v1/feature-profile/sdwan/system/{systemId}/banner | 
*ConfigurationFeatureProfileSDWANApi* | [**get_basic_profile_parcel_by_parcel_id_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#get_basic_profile_parcel_by_parcel_id_for_system) | **GET** /v1/feature-profile/sdwan/system/{systemId}/basic/{basicId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_basic_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#get_basic_profile_parcel_for_system) | **GET** /v1/feature-profile/sdwan/system/{systemId}/basic | 
*ConfigurationFeatureProfileSDWANApi* | [**get_bfd_profile_parcel_by_parcel_id_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#get_bfd_profile_parcel_by_parcel_id_for_system) | **GET** /v1/feature-profile/sdwan/system/{systemId}/bfd/{bfdId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_bfd_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#get_bfd_profile_parcel_for_system) | **GET** /v1/feature-profile/sdwan/system/{systemId}/bfd | 
*ConfigurationFeatureProfileSDWANApi* | [**get_cedge_system_global_parcel_schema_by_schema_type**](docs/ConfigurationFeatureProfileSDWANApi.md#get_cedge_system_global_parcel_schema_by_schema_type) | **GET** /v1/feature-profile/sdwan/system/global/schema | 
*ConfigurationFeatureProfileSDWANApi* | [**get_cellular_controller_associated_cellular_profile_parcel_by_parcel_id_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#get_cellular_controller_associated_cellular_profile_parcel_by_parcel_id_for_transport) | **GET** /v1/feature-profile/sdwan/transport/{transportId}/cellular-controller/{cellularControllerId}/cellular-profile/{cellularProfileId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_cellular_controller_associated_cellular_profile_parcels_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#get_cellular_controller_associated_cellular_profile_parcels_for_transport) | **GET** /v1/feature-profile/sdwan/transport/{transportId}/cellular-controller/{cellularControllerId}/cellular-profile | 
*ConfigurationFeatureProfileSDWANApi* | [**get_cellular_controller_profile_parcel_by_parcel_id_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#get_cellular_controller_profile_parcel_by_parcel_id_for_transport) | **GET** /v1/feature-profile/sdwan/transport/{transportId}/cellular-controller/{cellularControllerId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_cellular_controller_profile_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#get_cellular_controller_profile_parcel_for_transport) | **GET** /v1/feature-profile/sdwan/transport/{transportId}/cellular-controller | 
*ConfigurationFeatureProfileSDWANApi* | [**get_cellular_profile_profile_parcel_by_parcel_id_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#get_cellular_profile_profile_parcel_by_parcel_id_for_transport) | **GET** /v1/feature-profile/sdwan/transport/{transportId}/cellular-profile/{cellularProfileId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_cellular_profile_profile_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#get_cellular_profile_profile_parcel_for_transport) | **GET** /v1/feature-profile/sdwan/transport/{transportId}/cellular-profile | 
*ConfigurationFeatureProfileSDWANApi* | [**get_config_profile_parcel_by_parcel_id_for_cli**](docs/ConfigurationFeatureProfileSDWANApi.md#get_config_profile_parcel_by_parcel_id_for_cli) | **GET** /v1/feature-profile/sdwan/cli/{cliId}/config/{configId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_config_profile_parcel_for_cli**](docs/ConfigurationFeatureProfileSDWANApi.md#get_config_profile_parcel_for_cli) | **GET** /v1/feature-profile/sdwan/cli/{cliId}/config | 
*ConfigurationFeatureProfileSDWANApi* | [**get_global_profile_parcel_by_parcel_id_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#get_global_profile_parcel_by_parcel_id_for_system) | **GET** /v1/feature-profile/sdwan/system/{systemId}/global/{globalId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_global_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#get_global_profile_parcel_for_system) | **GET** /v1/feature-profile/sdwan/system/{systemId}/global | 
*ConfigurationFeatureProfileSDWANApi* | [**get_interface_ethernet_parcels_for_service_lan_vpn**](docs/ConfigurationFeatureProfileSDWANApi.md#get_interface_ethernet_parcels_for_service_lan_vpn) | **GET** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/interface/ethernet | 
*ConfigurationFeatureProfileSDWANApi* | [**get_interface_ethernet_parcels_for_transport_management_vpn**](docs/ConfigurationFeatureProfileSDWANApi.md#get_interface_ethernet_parcels_for_transport_management_vpn) | **GET** /v1/feature-profile/sdwan/transport/{transportId}/management/vpn/{vpnId}/interface/ethernet | 
*ConfigurationFeatureProfileSDWANApi* | [**get_interface_ethernet_parcels_for_transport_wan_vpn**](docs/ConfigurationFeatureProfileSDWANApi.md#get_interface_ethernet_parcels_for_transport_wan_vpn) | **GET** /v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId}/interface/ethernet | 
*ConfigurationFeatureProfileSDWANApi* | [**get_lan_vpn_associated_routing_bgp_parcel_by_parcel_id_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#get_lan_vpn_associated_routing_bgp_parcel_by_parcel_id_for_service) | **GET** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/routing/bgp/{bgpId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_lan_vpn_associated_routing_bgp_parcels_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#get_lan_vpn_associated_routing_bgp_parcels_for_service) | **GET** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/routing/bgp | 
*ConfigurationFeatureProfileSDWANApi* | [**get_lan_vpn_associated_routing_ospf_parcel_by_parcel_id_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#get_lan_vpn_associated_routing_ospf_parcel_by_parcel_id_for_service) | **GET** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/routing/ospf/{ospfId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_lan_vpn_associated_routing_ospf_parcels_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#get_lan_vpn_associated_routing_ospf_parcels_for_service) | **GET** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/routing/ospf | 
*ConfigurationFeatureProfileSDWANApi* | [**get_lan_vpn_interface_ethernet_associated_tracker_parcel_by_parcel_id_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#get_lan_vpn_interface_ethernet_associated_tracker_parcel_by_parcel_id_for_transport) | **GET** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/interface/ethernet/{ethernetId}/tracker/{trackerId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_lan_vpn_interface_ethernet_associated_tracker_parcels_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#get_lan_vpn_interface_ethernet_associated_tracker_parcels_for_transport) | **GET** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/interface/ethernet/{ethernetId}/tracker | 
*ConfigurationFeatureProfileSDWANApi* | [**get_lan_vpn_interface_ethernet_parcel_by_parcel_id_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#get_lan_vpn_interface_ethernet_parcel_by_parcel_id_for_service) | **GET** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/interface/ethernet/{ethernetId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_lan_vpn_profile_parcel_by_parcel_id_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#get_lan_vpn_profile_parcel_by_parcel_id_for_service) | **GET** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_lan_vpn_profile_parcel_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#get_lan_vpn_profile_parcel_for_service) | **GET** /v1/feature-profile/sdwan/service/{serviceId}/lan/vpn | 
*ConfigurationFeatureProfileSDWANApi* | [**get_logging_profile_parcel_by_parcel_id_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#get_logging_profile_parcel_by_parcel_id_for_system) | **GET** /v1/feature-profile/sdwan/system/{systemId}/logging/{loggingId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_logging_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#get_logging_profile_parcel_for_system) | **GET** /v1/feature-profile/sdwan/system/{systemId}/logging | 
*ConfigurationFeatureProfileSDWANApi* | [**get_management_vpn_interface_ethernet_parcel_by_parcel_id_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#get_management_vpn_interface_ethernet_parcel_by_parcel_id_for_transport) | **GET** /v1/feature-profile/sdwan/transport/{transportId}/management/vpn/{vpnId}/interface/ethernet/{ethernetId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_management_vpn_profile_parcel_by_parcel_id_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#get_management_vpn_profile_parcel_by_parcel_id_for_transport) | **GET** /v1/feature-profile/sdwan/transport/{transportId}/management/vpn/{vpnId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_management_vpn_profile_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#get_management_vpn_profile_parcel_for_transport) | **GET** /v1/feature-profile/sdwan/transport/{transportId}/management/vpn | 
*ConfigurationFeatureProfileSDWANApi* | [**get_ntp_profile_parcel_by_parcel_id_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#get_ntp_profile_parcel_by_parcel_id_for_system) | **GET** /v1/feature-profile/sdwan/system/{systemId}/ntp/{ntpId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_ntp_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#get_ntp_profile_parcel_for_system) | **GET** /v1/feature-profile/sdwan/system/{systemId}/ntp | 
*ConfigurationFeatureProfileSDWANApi* | [**get_omp_profile_parcel_by_parcel_id_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#get_omp_profile_parcel_by_parcel_id_for_system) | **GET** /v1/feature-profile/sdwan/system/{systemId}/omp/{ompId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_omp_profile_parcel_for_system**](docs/ConfigurationFeatureProfileSDWANApi.md#get_omp_profile_parcel_for_system) | **GET** /v1/feature-profile/sdwan/system/{systemId}/omp | 
*ConfigurationFeatureProfileSDWANApi* | [**get_routing_bgp_profile_parcel_by_parcel_id_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#get_routing_bgp_profile_parcel_by_parcel_id_for_service) | **GET** /v1/feature-profile/sdwan/service/{serviceId}/routing/bgp/{bgpId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_routing_bgp_profile_parcel_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#get_routing_bgp_profile_parcel_for_service) | **GET** /v1/feature-profile/sdwan/service/{serviceId}/routing/bgp | 
*ConfigurationFeatureProfileSDWANApi* | [**get_routing_ospf_profile_parcel_by_parcel_id_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#get_routing_ospf_profile_parcel_by_parcel_id_for_service) | **GET** /v1/feature-profile/sdwan/service/{serviceId}/routing/ospf/{ospfId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_routing_ospf_profile_parcel_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#get_routing_ospf_profile_parcel_for_service) | **GET** /v1/feature-profile/sdwan/service/{serviceId}/routing/ospf | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_feature_profile_by_profile_id**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_feature_profile_by_profile_id) | **GET** /v1/feature-profile/sdwan/cli/{cliId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_feature_profile_by_sdwan_family**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_feature_profile_by_sdwan_family) | **GET** /v1/feature-profile/sdwan | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_feature_profiles_by_family_and_type**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_feature_profiles_by_family_and_type) | **GET** /v1/feature-profile/sdwan/cli | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_service_feature_profile_by_profile_id**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_service_feature_profile_by_profile_id) | **GET** /v1/feature-profile/sdwan/service/{serviceId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_service_feature_profiles**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_service_feature_profiles) | **GET** /v1/feature-profile/sdwan/service | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_service_lan_vpn_interface_ethernet_parcel_schema_by_schema**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_service_lan_vpn_interface_ethernet_parcel_schema_by_schema) | **GET** /v1/feature-profile/sdwan/service/lan/vpn/interface/ethernet/schema | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_service_lan_vpn_parcel_schema_by_schema_type**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_service_lan_vpn_parcel_schema_by_schema_type) | **GET** /v1/feature-profile/sdwan/service/lan/vpn/schema | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_service_routing_bgp_parcel_schema_by_schema_type**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_service_routing_bgp_parcel_schema_by_schema_type) | **GET** /v1/feature-profile/sdwan/service/routing/bgp/schema | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_service_routing_ospf_parcel_schema_by_schema_type**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_service_routing_ospf_parcel_schema_by_schema_type) | **GET** /v1/feature-profile/sdwan/service/routing/ospf/schema | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_service_tracker_parcel_schema_by_schema_type**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_service_tracker_parcel_schema_by_schema_type) | **GET** /v1/feature-profile/sdwan/service/tracker/schema | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_system_aaa_parcel_schema_by_schema_type**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_system_aaa_parcel_schema_by_schema_type) | **GET** /v1/feature-profile/sdwan/system/aaa/schema | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_system_banner_parcel_schema_by_schema_type**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_system_banner_parcel_schema_by_schema_type) | **GET** /v1/feature-profile/sdwan/system/banner/schema | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_system_basic_parcel_schema_by_schema_type**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_system_basic_parcel_schema_by_schema_type) | **GET** /v1/feature-profile/sdwan/system/basic/schema | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_system_bfd_parcel_schema_by_schema_type**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_system_bfd_parcel_schema_by_schema_type) | **GET** /v1/feature-profile/sdwan/system/bfd/schema | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_system_feature_profile_by_profile_id**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_system_feature_profile_by_profile_id) | **GET** /v1/feature-profile/sdwan/system/{systemId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_system_feature_profiles**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_system_feature_profiles) | **GET** /v1/feature-profile/sdwan/system | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_system_logging_parcel_schema_by_schema_type**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_system_logging_parcel_schema_by_schema_type) | **GET** /v1/feature-profile/sdwan/system/logging/schema | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_system_ntp_parcel_schema_by_schema_type**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_system_ntp_parcel_schema_by_schema_type) | **GET** /v1/feature-profile/sdwan/system/ntp/schema | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_system_omp_parcel_schema_by_schema_type**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_system_omp_parcel_schema_by_schema_type) | **GET** /v1/feature-profile/sdwan/system/omp/schema | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_transport_cellular_controller_parcel_schema_by_schema_type**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_transport_cellular_controller_parcel_schema_by_schema_type) | **GET** /v1/feature-profile/sdwan/transport/cellular-controller/schema | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_transport_cellular_profile_parcel_schema_by_schema_type**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_transport_cellular_profile_parcel_schema_by_schema_type) | **GET** /v1/feature-profile/sdwan/transport/cellular-profile/schema | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_transport_feature_profile_by_profile_id**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_transport_feature_profile_by_profile_id) | **GET** /v1/feature-profile/sdwan/transport/{transportId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_transport_feature_profiles**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_transport_feature_profiles) | **GET** /v1/feature-profile/sdwan/transport | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_transport_management_vpn_interface_ethernet_parcel_schema_by_schema**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_transport_management_vpn_interface_ethernet_parcel_schema_by_schema) | **GET** /v1/feature-profile/sdwan/transport/management/vpn/interface/ethernet/schema | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_transport_management_vpn_parcel_schema_by_schema_type**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_transport_management_vpn_parcel_schema_by_schema_type) | **GET** /v1/feature-profile/sdwan/transport/management/vpn/schema | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_transport_tracker_parcel_schema_by_schema_type**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_transport_tracker_parcel_schema_by_schema_type) | **GET** /v1/feature-profile/sdwan/transport/tracker/schema | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_transport_wan_vpn_interface_ethernet_parcel_schema_by_schema**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_transport_wan_vpn_interface_ethernet_parcel_schema_by_schema) | **GET** /v1/feature-profile/sdwan/transport/wan/vpn/interface/ethernet/schema | 
*ConfigurationFeatureProfileSDWANApi* | [**get_sdwan_transport_wan_vpn_parcel_schema_by_schema_type**](docs/ConfigurationFeatureProfileSDWANApi.md#get_sdwan_transport_wan_vpn_parcel_schema_by_schema_type) | **GET** /v1/feature-profile/sdwan/transport/wan/vpn/schema | 
*ConfigurationFeatureProfileSDWANApi* | [**get_tracker_profile_parcel_by_parcel_id_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#get_tracker_profile_parcel_by_parcel_id_for_service) | **GET** /v1/feature-profile/sdwan/service/{serviceId}/tracker/{trackerId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_tracker_profile_parcel_by_parcel_id_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#get_tracker_profile_parcel_by_parcel_id_for_transport) | **GET** /v1/feature-profile/sdwan/transport/{transportId}/tracker/{trackerId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_tracker_profile_parcel_for_service**](docs/ConfigurationFeatureProfileSDWANApi.md#get_tracker_profile_parcel_for_service) | **GET** /v1/feature-profile/sdwan/service/{serviceId}/tracker | 
*ConfigurationFeatureProfileSDWANApi* | [**get_tracker_profile_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#get_tracker_profile_parcel_for_transport) | **GET** /v1/feature-profile/sdwan/transport/{transportId}/tracker | 
*ConfigurationFeatureProfileSDWANApi* | [**get_wan_vpn_interface_ethernet_associated_tracker_parcel_by_parcel_id_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#get_wan_vpn_interface_ethernet_associated_tracker_parcel_by_parcel_id_for_transport) | **GET** /v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId}/interface/ethernet/{ethernetId}/tracker/{trackerId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_wan_vpn_interface_ethernet_associated_tracker_parcels_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#get_wan_vpn_interface_ethernet_associated_tracker_parcels_for_transport) | **GET** /v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId}/interface/ethernet/{ethernetId}/tracker | 
*ConfigurationFeatureProfileSDWANApi* | [**get_wan_vpn_interface_ethernet_parcel_by_parcel_id_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#get_wan_vpn_interface_ethernet_parcel_by_parcel_id_for_transport) | **GET** /v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId}/interface/ethernet/{ethernetId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_wan_vpn_profile_parcel_by_parcel_id_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#get_wan_vpn_profile_parcel_by_parcel_id_for_transport) | **GET** /v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId} | 
*ConfigurationFeatureProfileSDWANApi* | [**get_wan_vpn_profile_parcel_for_transport**](docs/ConfigurationFeatureProfileSDWANApi.md#get_wan_vpn_profile_parcel_for_transport) | **GET** /v1/feature-profile/sdwan/transport/{transportId}/wan/vpn | 
*ConfigurationGeneralTemplateApi* | [**change_template_resource_group**](docs/ConfigurationGeneralTemplateApi.md#change_template_resource_group) | **POST** /template/feature/resource-group/{resourceGroupName}/{templateId} | 
*ConfigurationGeneralTemplateApi* | [**clone_template**](docs/ConfigurationGeneralTemplateApi.md#clone_template) | **POST** /template/feature/clone | 
*ConfigurationGeneralTemplateApi* | [**create_feature_template**](docs/ConfigurationGeneralTemplateApi.md#create_feature_template) | **POST** /template/feature | 
*ConfigurationGeneralTemplateApi* | [**create_li_template**](docs/ConfigurationGeneralTemplateApi.md#create_li_template) | **POST** /template/feature/li | 
*ConfigurationGeneralTemplateApi* | [**delete_general_template**](docs/ConfigurationGeneralTemplateApi.md#delete_general_template) | **DELETE** /template/feature/{templateId} | 
*ConfigurationGeneralTemplateApi* | [**edit_feature_template**](docs/ConfigurationGeneralTemplateApi.md#edit_feature_template) | **PUT** /template/feature/{templateId} | 
*ConfigurationGeneralTemplateApi* | [**edit_li_template**](docs/ConfigurationGeneralTemplateApi.md#edit_li_template) | **PUT** /template/feature/li/{templateId} | 
*ConfigurationGeneralTemplateApi* | [**generate_feature_template_list**](docs/ConfigurationGeneralTemplateApi.md#generate_feature_template_list) | **GET** /template/feature | 
*ConfigurationGeneralTemplateApi* | [**generate_master_template_definition**](docs/ConfigurationGeneralTemplateApi.md#generate_master_template_definition) | **GET** /template/feature/master/{type_name} | 
*ConfigurationGeneralTemplateApi* | [**generate_template_by_device_type**](docs/ConfigurationGeneralTemplateApi.md#generate_template_by_device_type) | **GET** /template/feature/{deviceType} | 
*ConfigurationGeneralTemplateApi* | [**generate_template_type_definition**](docs/ConfigurationGeneralTemplateApi.md#generate_template_type_definition) | **GET** /template/feature/types/definition/{type_name}/{version} | 
*ConfigurationGeneralTemplateApi* | [**generate_template_types**](docs/ConfigurationGeneralTemplateApi.md#generate_template_types) | **GET** /template/feature/types | 
*ConfigurationGeneralTemplateApi* | [**get_default_networks**](docs/ConfigurationGeneralTemplateApi.md#get_default_networks) | **GET** /template/feature/default/networks | 
*ConfigurationGeneralTemplateApi* | [**get_device_templates_attached_to_feature**](docs/ConfigurationGeneralTemplateApi.md#get_device_templates_attached_to_feature) | **GET** /template/feature/devicetemplates/{templateId} | 
*ConfigurationGeneralTemplateApi* | [**get_encrypted_string**](docs/ConfigurationGeneralTemplateApi.md#get_encrypted_string) | **POST** /template/security/encryptText/encrypt | 
*ConfigurationGeneralTemplateApi* | [**get_general_template**](docs/ConfigurationGeneralTemplateApi.md#get_general_template) | **GET** /template/feature/object/{templateId} | 
*ConfigurationGeneralTemplateApi* | [**get_network_interface**](docs/ConfigurationGeneralTemplateApi.md#get_network_interface) | **GET** /template/feature/default/networkinterface | 
*ConfigurationGeneralTemplateApi* | [**get_template_definition**](docs/ConfigurationGeneralTemplateApi.md#get_template_definition) | **GET** /template/feature/definition/{templateId} | 
*ConfigurationGeneralTemplateApi* | [**get_template_for_migration**](docs/ConfigurationGeneralTemplateApi.md#get_template_for_migration) | **GET** /template/feature/migration | 
*ConfigurationGeneralTemplateApi* | [**list_li_template**](docs/ConfigurationGeneralTemplateApi.md#list_li_template) | **GET** /template/feature/li | 
*ConfigurationMultiCloudApi* | [**add_edge_global_settings**](docs/ConfigurationMultiCloudApi.md#add_edge_global_settings) | **POST** /multicloud/settings/edge/global | 
*ConfigurationMultiCloudApi* | [**add_global_settings**](docs/ConfigurationMultiCloudApi.md#add_global_settings) | **POST** /multicloud/settings/global | 
*ConfigurationMultiCloudApi* | [**attach_sites**](docs/ConfigurationMultiCloudApi.md#attach_sites) | **POST** /multicloud/cloudgateway/{cloudGatewayName}/site | 
*ConfigurationMultiCloudApi* | [**audit**](docs/ConfigurationMultiCloudApi.md#audit) | **POST** /multicloud/audit | 
*ConfigurationMultiCloudApi* | [**audit_dry_run**](docs/ConfigurationMultiCloudApi.md#audit_dry_run) | **GET** /multicloud/audit | 
*ConfigurationMultiCloudApi* | [**clean_up_all_connectivity_gateways_in_local_db**](docs/ConfigurationMultiCloudApi.md#clean_up_all_connectivity_gateways_in_local_db) | **DELETE** /multicloud/connectivitygateway | 
*ConfigurationMultiCloudApi* | [**create_cgw**](docs/ConfigurationMultiCloudApi.md#create_cgw) | **POST** /multicloud/cloudgateway | 
*ConfigurationMultiCloudApi* | [**create_connectivity_gateway**](docs/ConfigurationMultiCloudApi.md#create_connectivity_gateway) | **POST** /multicloud/connectivitygateway | 
*ConfigurationMultiCloudApi* | [**create_device_link**](docs/ConfigurationMultiCloudApi.md#create_device_link) | **POST** /multicloud/devicelink/edge | 
*ConfigurationMultiCloudApi* | [**create_edge_connectivity**](docs/ConfigurationMultiCloudApi.md#create_edge_connectivity) | **POST** /multicloud/connectivity/edge | 
*ConfigurationMultiCloudApi* | [**create_icgw**](docs/ConfigurationMultiCloudApi.md#create_icgw) | **POST** /multicloud/gateway/edge | 
*ConfigurationMultiCloudApi* | [**create_virtual_wan**](docs/ConfigurationMultiCloudApi.md#create_virtual_wan) | **POST** /multicloud/vwan | 
*ConfigurationMultiCloudApi* | [**delete_account**](docs/ConfigurationMultiCloudApi.md#delete_account) | **DELETE** /multicloud/accounts/{accountId} | 
*ConfigurationMultiCloudApi* | [**delete_cgw**](docs/ConfigurationMultiCloudApi.md#delete_cgw) | **DELETE** /multicloud/cloudgateway/{cloudGatewayName} | 
*ConfigurationMultiCloudApi* | [**delete_connectivity_gateway**](docs/ConfigurationMultiCloudApi.md#delete_connectivity_gateway) | **DELETE** /multicloud/connectivitygateway/{cloudProvider}/{connectivityGatewayName} | 
*ConfigurationMultiCloudApi* | [**delete_device_link**](docs/ConfigurationMultiCloudApi.md#delete_device_link) | **DELETE** /multicloud/devicelink/edge/{deviceLinkName} | 
*ConfigurationMultiCloudApi* | [**delete_edge_account**](docs/ConfigurationMultiCloudApi.md#delete_edge_account) | **DELETE** /multicloud/accounts/edge/{accountId} | 
*ConfigurationMultiCloudApi* | [**delete_edge_account1**](docs/ConfigurationMultiCloudApi.md#delete_edge_account1) | **DELETE** /multicloud/locations/edge/{edgeType} | 
*ConfigurationMultiCloudApi* | [**delete_edge_connectivity**](docs/ConfigurationMultiCloudApi.md#delete_edge_connectivity) | **DELETE** /multicloud/connectivity/edge/{connectionName} | 
*ConfigurationMultiCloudApi* | [**delete_icgw**](docs/ConfigurationMultiCloudApi.md#delete_icgw) | **DELETE** /multicloud/gateway/edge/{edgeGatewayName} | 
*ConfigurationMultiCloudApi* | [**delete_virtual_wan**](docs/ConfigurationMultiCloudApi.md#delete_virtual_wan) | **DELETE** /multicloud/vwan/{cloudProvider}/{vWanName} | 
*ConfigurationMultiCloudApi* | [**detach_sites1**](docs/ConfigurationMultiCloudApi.md#detach_sites1) | **DELETE** /multicloud/cloudgateway/{cloudGatewayName}/site | 
*ConfigurationMultiCloudApi* | [**edge_audit**](docs/ConfigurationMultiCloudApi.md#edge_audit) | **POST** /multicloud/audit/edge | 
*ConfigurationMultiCloudApi* | [**edge_audit_dry_run**](docs/ConfigurationMultiCloudApi.md#edge_audit_dry_run) | **GET** /multicloud/audit/edge | 
*ConfigurationMultiCloudApi* | [**edit_tag**](docs/ConfigurationMultiCloudApi.md#edit_tag) | **PUT** /multicloud/hostvpc/tags | 
*ConfigurationMultiCloudApi* | [**get_all_cloud_accounts**](docs/ConfigurationMultiCloudApi.md#get_all_cloud_accounts) | **GET** /multicloud/accounts | 
*ConfigurationMultiCloudApi* | [**get_azure_network_virtual_appliances**](docs/ConfigurationMultiCloudApi.md#get_azure_network_virtual_appliances) | **GET** /multicloud/cloudgateway/nvas | 
*ConfigurationMultiCloudApi* | [**get_azure_nva_sku_list**](docs/ConfigurationMultiCloudApi.md#get_azure_nva_sku_list) | **GET** /multicloud/cloudgateway/nvasku | 
*ConfigurationMultiCloudApi* | [**get_azure_resource_groups**](docs/ConfigurationMultiCloudApi.md#get_azure_resource_groups) | **GET** /multicloud/cloudgateway/resourceGroups | 
*ConfigurationMultiCloudApi* | [**get_azure_virtual_hubs**](docs/ConfigurationMultiCloudApi.md#get_azure_virtual_hubs) | **GET** /multicloud/cloudgateway/vhubs | 
*ConfigurationMultiCloudApi* | [**get_azure_virtual_wans**](docs/ConfigurationMultiCloudApi.md#get_azure_virtual_wans) | **GET** /multicloud/cloudgateway/vwans | 
*ConfigurationMultiCloudApi* | [**get_cgw_associated_mappings**](docs/ConfigurationMultiCloudApi.md#get_cgw_associated_mappings) | **GET** /multicloud/mapping/{cloudType} | 
*ConfigurationMultiCloudApi* | [**get_cgw_custom_setting_details**](docs/ConfigurationMultiCloudApi.md#get_cgw_custom_setting_details) | **GET** /multicloud/cloudgatewaysetting/{cloudGatewayName} | 
*ConfigurationMultiCloudApi* | [**get_cgw_details**](docs/ConfigurationMultiCloudApi.md#get_cgw_details) | **GET** /multicloud/cloudgateway/{cloudGatewayName} | 
*ConfigurationMultiCloudApi* | [**get_cgw_org_resources**](docs/ConfigurationMultiCloudApi.md#get_cgw_org_resources) | **GET** /multicloud/cloudgateway/resource | 
*ConfigurationMultiCloudApi* | [**get_cgw_types**](docs/ConfigurationMultiCloudApi.md#get_cgw_types) | **GET** /multicloud/cloudgatewaytype | 
*ConfigurationMultiCloudApi* | [**get_cgws**](docs/ConfigurationMultiCloudApi.md#get_cgws) | **GET** /multicloud/cloudgateway | 
*ConfigurationMultiCloudApi* | [**get_cloud_account_details**](docs/ConfigurationMultiCloudApi.md#get_cloud_account_details) | **GET** /multicloud/accounts/{accountId} | 
*ConfigurationMultiCloudApi* | [**get_cloud_connected_sites**](docs/ConfigurationMultiCloudApi.md#get_cloud_connected_sites) | **GET** /multicloud/connected-sites/{cloudType} | 
*ConfigurationMultiCloudApi* | [**get_cloud_connected_sites1**](docs/ConfigurationMultiCloudApi.md#get_cloud_connected_sites1) | **GET** /multicloud/connected-sites/edge/{edgeType} | 
*ConfigurationMultiCloudApi* | [**get_cloud_devices**](docs/ConfigurationMultiCloudApi.md#get_cloud_devices) | **GET** /multicloud/devices/{cloudType} | 
*ConfigurationMultiCloudApi* | [**get_cloud_devices1**](docs/ConfigurationMultiCloudApi.md#get_cloud_devices1) | **GET** /multicloud/devices/edge/{edgeType} | 
*ConfigurationMultiCloudApi* | [**get_cloud_gateways**](docs/ConfigurationMultiCloudApi.md#get_cloud_gateways) | **GET** /multicloud/cloudgateways/{cloudType} | 
*ConfigurationMultiCloudApi* | [**get_cloud_regions**](docs/ConfigurationMultiCloudApi.md#get_cloud_regions) | **GET** /multicloud/regions | 
*ConfigurationMultiCloudApi* | [**get_cloud_types**](docs/ConfigurationMultiCloudApi.md#get_cloud_types) | **GET** /multicloud/types | 
*ConfigurationMultiCloudApi* | [**get_cloud_widget**](docs/ConfigurationMultiCloudApi.md#get_cloud_widget) | **GET** /multicloud/widget/{cloudType} | 
*ConfigurationMultiCloudApi* | [**get_connectivity_gateway_creation_options**](docs/ConfigurationMultiCloudApi.md#get_connectivity_gateway_creation_options) | **GET** /multicloud/connectivitygatewaycreationoptions | 
*ConfigurationMultiCloudApi* | [**get_connectivity_gateways**](docs/ConfigurationMultiCloudApi.md#get_connectivity_gateways) | **GET** /multicloud/connectivitygateway | 
*ConfigurationMultiCloudApi* | [**get_dashboard_edge_info**](docs/ConfigurationMultiCloudApi.md#get_dashboard_edge_info) | **GET** /multicloud/dashboard/edge | 
*ConfigurationMultiCloudApi* | [**get_default_mapping_values**](docs/ConfigurationMultiCloudApi.md#get_default_mapping_values) | **GET** /multicloud/map/defaults | 
*ConfigurationMultiCloudApi* | [**get_device_links**](docs/ConfigurationMultiCloudApi.md#get_device_links) | **GET** /multicloud/devicelink/edge | 
*ConfigurationMultiCloudApi* | [**get_dl_port_speed**](docs/ConfigurationMultiCloudApi.md#get_dl_port_speed) | **GET** /multicloud/devicelink/edge/portspeed/{edgeType} | 
*ConfigurationMultiCloudApi* | [**get_edge_account_details**](docs/ConfigurationMultiCloudApi.md#get_edge_account_details) | **GET** /multicloud/accounts/edge/{accountId} | 
*ConfigurationMultiCloudApi* | [**get_edge_accounts**](docs/ConfigurationMultiCloudApi.md#get_edge_accounts) | **GET** /multicloud/accounts/edge | 
*ConfigurationMultiCloudApi* | [**get_edge_billing_accounts**](docs/ConfigurationMultiCloudApi.md#get_edge_billing_accounts) | **GET** /multicloud/billingaccounts/edge/{edgeType}/{edgeAccountId} | 
*ConfigurationMultiCloudApi* | [**get_edge_connectivity_detail_by_name**](docs/ConfigurationMultiCloudApi.md#get_edge_connectivity_detail_by_name) | **GET** /multicloud/connectivity/edge/{connectivityName} | 
*ConfigurationMultiCloudApi* | [**get_edge_connectivity_details**](docs/ConfigurationMultiCloudApi.md#get_edge_connectivity_details) | **GET** /multicloud/connectivity/edge | 
*ConfigurationMultiCloudApi* | [**get_edge_gateways**](docs/ConfigurationMultiCloudApi.md#get_edge_gateways) | **GET** /multicloud/gateways/edge/{edgeType} | 
*ConfigurationMultiCloudApi* | [**get_edge_global_settings**](docs/ConfigurationMultiCloudApi.md#get_edge_global_settings) | **GET** /multicloud/settings/edge/global | 
*ConfigurationMultiCloudApi* | [**get_edge_locations_info**](docs/ConfigurationMultiCloudApi.md#get_edge_locations_info) | **GET** /multicloud/locations/edge/{edgeType} | 
*ConfigurationMultiCloudApi* | [**get_edge_mapping_tags**](docs/ConfigurationMultiCloudApi.md#get_edge_mapping_tags) | **GET** /multicloud/map/tags/edge | 
*ConfigurationMultiCloudApi* | [**get_edge_types**](docs/ConfigurationMultiCloudApi.md#get_edge_types) | **GET** /multicloud/types/edge | 
*ConfigurationMultiCloudApi* | [**get_edge_wan_devices**](docs/ConfigurationMultiCloudApi.md#get_edge_wan_devices) | **GET** /multicloud/edge/{edgeType}/device | 
*ConfigurationMultiCloudApi* | [**get_edge_widget**](docs/ConfigurationMultiCloudApi.md#get_edge_widget) | **GET** /multicloud/widget/edge/{edgeType} | 
*ConfigurationMultiCloudApi* | [**get_global_settings**](docs/ConfigurationMultiCloudApi.md#get_global_settings) | **GET** /multicloud/settings/global | 
*ConfigurationMultiCloudApi* | [**get_host_vpcs**](docs/ConfigurationMultiCloudApi.md#get_host_vpcs) | **GET** /multicloud/hostvpc | 
*ConfigurationMultiCloudApi* | [**get_icgw_custom_setting_details**](docs/ConfigurationMultiCloudApi.md#get_icgw_custom_setting_details) | **GET** /multicloud/gateway/edge/setting/{edgeGatewayName} | 
*ConfigurationMultiCloudApi* | [**get_icgw_details**](docs/ConfigurationMultiCloudApi.md#get_icgw_details) | **GET** /multicloud/gateway/edge/{edgeGatewayName} | 
*ConfigurationMultiCloudApi* | [**get_icgw_types**](docs/ConfigurationMultiCloudApi.md#get_icgw_types) | **GET** /multicloud/gateway/edge/types | 
*ConfigurationMultiCloudApi* | [**get_icgws**](docs/ConfigurationMultiCloudApi.md#get_icgws) | **GET** /multicloud/gateway/edge | 
*ConfigurationMultiCloudApi* | [**get_mapping_matrix**](docs/ConfigurationMultiCloudApi.md#get_mapping_matrix) | **GET** /multicloud/map | 
*ConfigurationMultiCloudApi* | [**get_mapping_status**](docs/ConfigurationMultiCloudApi.md#get_mapping_status) | **GET** /multicloud/map/status | 
*ConfigurationMultiCloudApi* | [**get_mapping_summary**](docs/ConfigurationMultiCloudApi.md#get_mapping_summary) | **GET** /multicloud/map/summary | 
*ConfigurationMultiCloudApi* | [**get_mapping_tags**](docs/ConfigurationMultiCloudApi.md#get_mapping_tags) | **GET** /multicloud/map/tags | 
*ConfigurationMultiCloudApi* | [**get_mapping_vpns**](docs/ConfigurationMultiCloudApi.md#get_mapping_vpns) | **GET** /multicloud/map/vpns | 
*ConfigurationMultiCloudApi* | [**get_nva_security_rules**](docs/ConfigurationMultiCloudApi.md#get_nva_security_rules) | **GET** /multicloud/cloudgateway/nvaSecurityRules/{cloudGatewayName} | 
*ConfigurationMultiCloudApi* | [**get_partner_ports**](docs/ConfigurationMultiCloudApi.md#get_partner_ports) | **GET** /multicloud/partnerports/edge | 
*ConfigurationMultiCloudApi* | [**get_port_speed**](docs/ConfigurationMultiCloudApi.md#get_port_speed) | **GET** /multicloud/portSpeed/edge/{edgeType}/{edgeAccountId}/{connectivityType} | 
*ConfigurationMultiCloudApi* | [**get_post_aggregation_data_by_query25**](docs/ConfigurationMultiCloudApi.md#get_post_aggregation_data_by_query25) | **POST** /multicloud/statistics/interface/aggregation | 
*ConfigurationMultiCloudApi* | [**get_sites**](docs/ConfigurationMultiCloudApi.md#get_sites) | **GET** /multicloud/site | 
*ConfigurationMultiCloudApi* | [**get_sites1**](docs/ConfigurationMultiCloudApi.md#get_sites1) | **GET** /multicloud/cloudgateway/{cloudGatewayName}/site | 
*ConfigurationMultiCloudApi* | [**get_ssh_key_list**](docs/ConfigurationMultiCloudApi.md#get_ssh_key_list) | **GET** /multicloud/sshkeys | 
*ConfigurationMultiCloudApi* | [**get_supported_edge_image_names**](docs/ConfigurationMultiCloudApi.md#get_supported_edge_image_names) | **GET** /multicloud/imagename/edge | 
*ConfigurationMultiCloudApi* | [**get_supported_edge_instance_size**](docs/ConfigurationMultiCloudApi.md#get_supported_edge_instance_size) | **GET** /multicloud/instancesize/edge | 
*ConfigurationMultiCloudApi* | [**get_supported_instance_size**](docs/ConfigurationMultiCloudApi.md#get_supported_instance_size) | **GET** /multicloud/instancesize | 
*ConfigurationMultiCloudApi* | [**get_supported_loopback_cgw_colors**](docs/ConfigurationMultiCloudApi.md#get_supported_loopback_cgw_colors) | **GET** /multicloud/loopbackCGWColor/edge | 
*ConfigurationMultiCloudApi* | [**get_supported_software_image_list**](docs/ConfigurationMultiCloudApi.md#get_supported_software_image_list) | **GET** /multicloud/swimages | 
*ConfigurationMultiCloudApi* | [**get_tunnel_names**](docs/ConfigurationMultiCloudApi.md#get_tunnel_names) | **GET** /multicloud/tunnels/{cloudType} | 
*ConfigurationMultiCloudApi* | [**get_v_hubs**](docs/ConfigurationMultiCloudApi.md#get_v_hubs) | **GET** /multicloud/vhubs | 
*ConfigurationMultiCloudApi* | [**get_v_wans**](docs/ConfigurationMultiCloudApi.md#get_v_wans) | **GET** /multicloud/vwans | 
*ConfigurationMultiCloudApi* | [**get_vpc_tags**](docs/ConfigurationMultiCloudApi.md#get_vpc_tags) | **GET** /multicloud/hostvpc/tags | 
*ConfigurationMultiCloudApi* | [**get_wan_devices**](docs/ConfigurationMultiCloudApi.md#get_wan_devices) | **GET** /multicloud/device | 
*ConfigurationMultiCloudApi* | [**get_wan_interface_colors**](docs/ConfigurationMultiCloudApi.md#get_wan_interface_colors) | **GET** /multicloud/interfacecolor | 
*ConfigurationMultiCloudApi* | [**hostvpc_tagging**](docs/ConfigurationMultiCloudApi.md#hostvpc_tagging) | **POST** /multicloud/hostvpc/tags | 
*ConfigurationMultiCloudApi* | [**process_mapping**](docs/ConfigurationMultiCloudApi.md#process_mapping) | **POST** /multicloud/map | 
*ConfigurationMultiCloudApi* | [**telemetry**](docs/ConfigurationMultiCloudApi.md#telemetry) | **POST** /multicloud/telemetry | 
*ConfigurationMultiCloudApi* | [**tunnel_scaling**](docs/ConfigurationMultiCloudApi.md#tunnel_scaling) | **PUT** /multicloud/cloudgateway/{cloudGatewayName}/site | 
*ConfigurationMultiCloudApi* | [**un_tag**](docs/ConfigurationMultiCloudApi.md#un_tag) | **DELETE** /multicloud/hostvpc/tags/{tagName} | 
*ConfigurationMultiCloudApi* | [**update_account**](docs/ConfigurationMultiCloudApi.md#update_account) | **PUT** /multicloud/accounts/{accountId} | 
*ConfigurationMultiCloudApi* | [**update_cgw**](docs/ConfigurationMultiCloudApi.md#update_cgw) | **PUT** /multicloud/cloudgateway/{cloudGatewayName} | 
*ConfigurationMultiCloudApi* | [**update_device_link**](docs/ConfigurationMultiCloudApi.md#update_device_link) | **PUT** /multicloud/devicelink/edge | 
*ConfigurationMultiCloudApi* | [**update_edge_account**](docs/ConfigurationMultiCloudApi.md#update_edge_account) | **PUT** /multicloud/accounts/edge/{accountId} | 
*ConfigurationMultiCloudApi* | [**update_edge_connectivity**](docs/ConfigurationMultiCloudApi.md#update_edge_connectivity) | **PUT** /multicloud/connectivity/edge | 
*ConfigurationMultiCloudApi* | [**update_edge_global_settings**](docs/ConfigurationMultiCloudApi.md#update_edge_global_settings) | **PUT** /multicloud/settings/edge/global | 
*ConfigurationMultiCloudApi* | [**update_edge_locations_info**](docs/ConfigurationMultiCloudApi.md#update_edge_locations_info) | **PUT** /multicloud/locations/edge/{edgeType}/accountId/{accountId} | 
*ConfigurationMultiCloudApi* | [**update_global_settings**](docs/ConfigurationMultiCloudApi.md#update_global_settings) | **PUT** /multicloud/settings/global | 
*ConfigurationMultiCloudApi* | [**update_icgw**](docs/ConfigurationMultiCloudApi.md#update_icgw) | **PUT** /multicloud/gateway/edge/{edgeGatewayName} | 
*ConfigurationMultiCloudApi* | [**update_nva_security_rules**](docs/ConfigurationMultiCloudApi.md#update_nva_security_rules) | **PUT** /multicloud/cloudgateway/nvaSecurityRules/{cloudGatewayName} | 
*ConfigurationMultiCloudApi* | [**validate_account_add**](docs/ConfigurationMultiCloudApi.md#validate_account_add) | **POST** /multicloud/accounts | 
*ConfigurationMultiCloudApi* | [**validate_account_update_credentials**](docs/ConfigurationMultiCloudApi.md#validate_account_update_credentials) | **PUT** /multicloud/accounts/{accountId}/credentials | 
*ConfigurationMultiCloudApi* | [**validate_edge_account_add**](docs/ConfigurationMultiCloudApi.md#validate_edge_account_add) | **POST** /multicloud/accounts/edge | 
*ConfigurationMultiCloudApi* | [**validate_edge_account_update_credentials**](docs/ConfigurationMultiCloudApi.md#validate_edge_account_update_credentials) | **PUT** /multicloud/accounts/edge/{accountId}/credentials | 
*ConfigurationMultidomainPolicyApi* | [**add_internal_policy**](docs/ConfigurationMultidomainPolicyApi.md#add_internal_policy) | **PUT** /mdp/policies/mdpconfig | 
*ConfigurationMultidomainPolicyApi* | [**attach_devices**](docs/ConfigurationMultidomainPolicyApi.md#attach_devices) | **POST** /mdp/attachDevices/{nmsId} | 
*ConfigurationMultidomainPolicyApi* | [**detach_devices**](docs/ConfigurationMultidomainPolicyApi.md#detach_devices) | **POST** /mdp/detachDevices/{nmsId} | 
*ConfigurationMultidomainPolicyApi* | [**disconnect_from_mdp**](docs/ConfigurationMultidomainPolicyApi.md#disconnect_from_mdp) | **GET** /mdp/disconnect/{nmsId} | 
*ConfigurationMultidomainPolicyApi* | [**edit_attached_devices**](docs/ConfigurationMultidomainPolicyApi.md#edit_attached_devices) | **PUT** /mdp/attachDevices/{nmsId} | 
*ConfigurationMultidomainPolicyApi* | [**get_mdp_onboarding_status**](docs/ConfigurationMultidomainPolicyApi.md#get_mdp_onboarding_status) | **GET** /mdp/onboard/status | 
*ConfigurationMultidomainPolicyApi* | [**offboard**](docs/ConfigurationMultidomainPolicyApi.md#offboard) | **DELETE** /mdp/onboard/{nmsId} | 
*ConfigurationMultidomainPolicyApi* | [**onboard_mdp**](docs/ConfigurationMultidomainPolicyApi.md#onboard_mdp) | **POST** /mdp/onboard | 
*ConfigurationMultidomainPolicyApi* | [**retrieve_mdp_attached_devices**](docs/ConfigurationMultidomainPolicyApi.md#retrieve_mdp_attached_devices) | **GET** /mdp/attachDevices/{nmsId} | 
*ConfigurationMultidomainPolicyApi* | [**retrieve_mdp_config_object**](docs/ConfigurationMultidomainPolicyApi.md#retrieve_mdp_config_object) | **GET** /mdp/policies/mdpconfig/{deviceId} | 
*ConfigurationMultidomainPolicyApi* | [**retrieve_mdp_policies**](docs/ConfigurationMultidomainPolicyApi.md#retrieve_mdp_policies) | **GET** /mdp/policies/{nmsId} | 
*ConfigurationMultidomainPolicyApi* | [**retrieve_mdp_supported_devices_**](docs/ConfigurationMultidomainPolicyApi.md#retrieve_mdp_supported_devices_) | **GET** /mdp/devices/{nmsId} | 
*ConfigurationMultidomainPolicyApi* | [**update_onboarding_payload**](docs/ConfigurationMultidomainPolicyApi.md#update_onboarding_payload) | **PUT** /mdp/onboard/{nmsId} | 
*ConfigurationMultidomainPolicyApi* | [**update_policy_status**](docs/ConfigurationMultidomainPolicyApi.md#update_policy_status) | **PUT** /mdp/policies/{nmsId} | 
*ConfigurationNetworkDesignApi* | [**acquire_attach_lock**](docs/ConfigurationNetworkDesignApi.md#acquire_attach_lock) | **POST** /networkdesign/profile/lock/{profileId} | 
*ConfigurationNetworkDesignApi* | [**acquire_edit_lock**](docs/ConfigurationNetworkDesignApi.md#acquire_edit_lock) | **POST** /networkdesign/lock/edit | 
*ConfigurationNetworkDesignApi* | [**create_network_design**](docs/ConfigurationNetworkDesignApi.md#create_network_design) | **POST** /networkdesign | 
*ConfigurationNetworkDesignApi* | [**edit_network_design**](docs/ConfigurationNetworkDesignApi.md#edit_network_design) | **PUT** /networkdesign | 
*ConfigurationNetworkDesignApi* | [**get_device_profile_config_status**](docs/ConfigurationNetworkDesignApi.md#get_device_profile_config_status) | **GET** /networkdesign/profile/status | 
*ConfigurationNetworkDesignApi* | [**get_device_profile_config_status_by_profile_id**](docs/ConfigurationNetworkDesignApi.md#get_device_profile_config_status_by_profile_id) | **GET** /networkdesign/profile/status/{profileId} | 
*ConfigurationNetworkDesignApi* | [**get_device_profile_task_count**](docs/ConfigurationNetworkDesignApi.md#get_device_profile_task_count) | **GET** /networkdesign/profile/task/count | 
*ConfigurationNetworkDesignApi* | [**get_device_profile_task_status**](docs/ConfigurationNetworkDesignApi.md#get_device_profile_task_status) | **GET** /networkdesign/profile/task/status | 
*ConfigurationNetworkDesignApi* | [**get_device_profile_task_status_by_profile_id**](docs/ConfigurationNetworkDesignApi.md#get_device_profile_task_status_by_profile_id) | **GET** /networkdesign/profile/task/status/{profileId} | 
*ConfigurationNetworkDesignApi* | [**get_global_parameters**](docs/ConfigurationNetworkDesignApi.md#get_global_parameters) | **GET** /networkdesign/global/parameters | 
*ConfigurationNetworkDesignApi* | [**get_network_design**](docs/ConfigurationNetworkDesignApi.md#get_network_design) | **GET** /networkdesign | 
*ConfigurationNetworkDesignApi* | [**get_service_profile_config**](docs/ConfigurationNetworkDesignApi.md#get_service_profile_config) | **GET** /networkdesign/serviceProfileConfig/{profileId} | 
*ConfigurationNetworkDesignApi* | [**push_device_profile_template**](docs/ConfigurationNetworkDesignApi.md#push_device_profile_template) | **POST** /networkdesign/profile/attachment/{profileId} | 
*ConfigurationNetworkDesignApi* | [**push_network_design**](docs/ConfigurationNetworkDesignApi.md#push_network_design) | **POST** /networkdesign/attachment | 
*ConfigurationNetworkDesignApi* | [**run_my_test**](docs/ConfigurationNetworkDesignApi.md#run_my_test) | **GET** /networkdesign/mytest/{name} | 
*ConfigurationNetworkDesignTemplatesApi* | [**edit_device_profile_template**](docs/ConfigurationNetworkDesignTemplatesApi.md#edit_device_profile_template) | **PUT** /networkdesign/profile/template/{templateId} | 
*ConfigurationNetworkDesignTemplatesApi* | [**edit_global_template**](docs/ConfigurationNetworkDesignTemplatesApi.md#edit_global_template) | **PUT** /networkdesign/global/template/{templateId} | 
*ConfigurationNetworkDesignTemplatesApi* | [**generate_profile_template_list**](docs/ConfigurationNetworkDesignTemplatesApi.md#generate_profile_template_list) | **GET** /networkdesign/profile/template | 
*ConfigurationNetworkDesignTemplatesApi* | [**get_device_profile_feature_template_list**](docs/ConfigurationNetworkDesignTemplatesApi.md#get_device_profile_feature_template_list) | **GET** /networkdesign/profile/feature | 
*ConfigurationNetworkDesignTemplatesApi* | [**get_device_profile_template**](docs/ConfigurationNetworkDesignTemplatesApi.md#get_device_profile_template) | **GET** /networkdesign/profile/template/{templateId} | 
*ConfigurationNetworkDesignTemplatesApi* | [**get_global_template**](docs/ConfigurationNetworkDesignTemplatesApi.md#get_global_template) | **GET** /networkdesign/global/template/{templateId} | 
*ConfigurationPolicyAMPDefinitionBuilderApi* | [**create_policy_definition11**](docs/ConfigurationPolicyAMPDefinitionBuilderApi.md#create_policy_definition11) | **POST** /template/policy/definition/advancedMalwareProtection | 
*ConfigurationPolicyAMPDefinitionBuilderApi* | [**delete_policy_definition11**](docs/ConfigurationPolicyAMPDefinitionBuilderApi.md#delete_policy_definition11) | **DELETE** /template/policy/definition/advancedMalwareProtection/{id} | 
*ConfigurationPolicyAMPDefinitionBuilderApi* | [**edit_multiple_policy_definition11**](docs/ConfigurationPolicyAMPDefinitionBuilderApi.md#edit_multiple_policy_definition11) | **PUT** /template/policy/definition/advancedMalwareProtection/multiple/{id} | 
*ConfigurationPolicyAMPDefinitionBuilderApi* | [**edit_policy_definition11**](docs/ConfigurationPolicyAMPDefinitionBuilderApi.md#edit_policy_definition11) | **PUT** /template/policy/definition/advancedMalwareProtection/{id} | 
*ConfigurationPolicyAMPDefinitionBuilderApi* | [**get_definitions11**](docs/ConfigurationPolicyAMPDefinitionBuilderApi.md#get_definitions11) | **GET** /template/policy/definition/advancedMalwareProtection | 
*ConfigurationPolicyAMPDefinitionBuilderApi* | [**get_policy_definition11**](docs/ConfigurationPolicyAMPDefinitionBuilderApi.md#get_policy_definition11) | **GET** /template/policy/definition/advancedMalwareProtection/{id} | 
*ConfigurationPolicyAMPDefinitionBuilderApi* | [**preview_policy_definition11**](docs/ConfigurationPolicyAMPDefinitionBuilderApi.md#preview_policy_definition11) | **POST** /template/policy/definition/advancedMalwareProtection/preview | 
*ConfigurationPolicyAMPDefinitionBuilderApi* | [**preview_policy_definition_by_id11**](docs/ConfigurationPolicyAMPDefinitionBuilderApi.md#preview_policy_definition_by_id11) | **GET** /template/policy/definition/advancedMalwareProtection/preview/{id} | 
*ConfigurationPolicyAMPDefinitionBuilderApi* | [**save_policy_definition_in_bulk11**](docs/ConfigurationPolicyAMPDefinitionBuilderApi.md#save_policy_definition_in_bulk11) | **PUT** /template/policy/definition/advancedMalwareProtection/bulk | 
*ConfigurationPolicyASPathListBuilderApi* | [**create_policy_list5**](docs/ConfigurationPolicyASPathListBuilderApi.md#create_policy_list5) | **POST** /template/policy/list/aspath | 
*ConfigurationPolicyASPathListBuilderApi* | [**delete_policy_list5**](docs/ConfigurationPolicyASPathListBuilderApi.md#delete_policy_list5) | **DELETE** /template/policy/list/aspath/{id} | 
*ConfigurationPolicyASPathListBuilderApi* | [**delete_policy_lists_with_info_tag5**](docs/ConfigurationPolicyASPathListBuilderApi.md#delete_policy_lists_with_info_tag5) | **DELETE** /template/policy/list/aspath | 
*ConfigurationPolicyASPathListBuilderApi* | [**edit_policy_list5**](docs/ConfigurationPolicyASPathListBuilderApi.md#edit_policy_list5) | **PUT** /template/policy/list/aspath/{id} | 
*ConfigurationPolicyASPathListBuilderApi* | [**get_lists_by_id5**](docs/ConfigurationPolicyASPathListBuilderApi.md#get_lists_by_id5) | **GET** /template/policy/list/aspath/{id} | 
*ConfigurationPolicyASPathListBuilderApi* | [**get_policy_lists5**](docs/ConfigurationPolicyASPathListBuilderApi.md#get_policy_lists5) | **GET** /template/policy/list/aspath | 
*ConfigurationPolicyASPathListBuilderApi* | [**get_policy_lists_with_info_tag5**](docs/ConfigurationPolicyASPathListBuilderApi.md#get_policy_lists_with_info_tag5) | **GET** /template/policy/list/aspath/filtered | 
*ConfigurationPolicyASPathListBuilderApi* | [**preview_policy_list5**](docs/ConfigurationPolicyASPathListBuilderApi.md#preview_policy_list5) | **POST** /template/policy/list/aspath/preview | 
*ConfigurationPolicyASPathListBuilderApi* | [**preview_policy_list_by_id5**](docs/ConfigurationPolicyASPathListBuilderApi.md#preview_policy_list_by_id5) | **GET** /template/policy/list/aspath/preview/{id} | 
*ConfigurationPolicyAccessListDefinitionBuilderApi* | [**create_policy_definition8**](docs/ConfigurationPolicyAccessListDefinitionBuilderApi.md#create_policy_definition8) | **POST** /template/policy/definition/acl | 
*ConfigurationPolicyAccessListDefinitionBuilderApi* | [**delete_policy_definition8**](docs/ConfigurationPolicyAccessListDefinitionBuilderApi.md#delete_policy_definition8) | **DELETE** /template/policy/definition/acl/{id} | 
*ConfigurationPolicyAccessListDefinitionBuilderApi* | [**edit_multiple_policy_definition8**](docs/ConfigurationPolicyAccessListDefinitionBuilderApi.md#edit_multiple_policy_definition8) | **PUT** /template/policy/definition/acl/multiple/{id} | 
*ConfigurationPolicyAccessListDefinitionBuilderApi* | [**edit_policy_definition8**](docs/ConfigurationPolicyAccessListDefinitionBuilderApi.md#edit_policy_definition8) | **PUT** /template/policy/definition/acl/{id} | 
*ConfigurationPolicyAccessListDefinitionBuilderApi* | [**get_definitions8**](docs/ConfigurationPolicyAccessListDefinitionBuilderApi.md#get_definitions8) | **GET** /template/policy/definition/acl | 
*ConfigurationPolicyAccessListDefinitionBuilderApi* | [**get_policy_definition8**](docs/ConfigurationPolicyAccessListDefinitionBuilderApi.md#get_policy_definition8) | **GET** /template/policy/definition/acl/{id} | 
*ConfigurationPolicyAccessListDefinitionBuilderApi* | [**preview_policy_definition8**](docs/ConfigurationPolicyAccessListDefinitionBuilderApi.md#preview_policy_definition8) | **POST** /template/policy/definition/acl/preview | 
*ConfigurationPolicyAccessListDefinitionBuilderApi* | [**preview_policy_definition_by_id8**](docs/ConfigurationPolicyAccessListDefinitionBuilderApi.md#preview_policy_definition_by_id8) | **GET** /template/policy/definition/acl/preview/{id} | 
*ConfigurationPolicyAccessListDefinitionBuilderApi* | [**save_policy_definition_in_bulk8**](docs/ConfigurationPolicyAccessListDefinitionBuilderApi.md#save_policy_definition_in_bulk8) | **PUT** /template/policy/definition/acl/bulk | 
*ConfigurationPolicyAppRouteDefinitionBuilderApi* | [**create_policy_definition12**](docs/ConfigurationPolicyAppRouteDefinitionBuilderApi.md#create_policy_definition12) | **POST** /template/policy/definition/approute | 
*ConfigurationPolicyAppRouteDefinitionBuilderApi* | [**delete_policy_definition12**](docs/ConfigurationPolicyAppRouteDefinitionBuilderApi.md#delete_policy_definition12) | **DELETE** /template/policy/definition/approute/{id} | 
*ConfigurationPolicyAppRouteDefinitionBuilderApi* | [**edit_multiple_policy_definition12**](docs/ConfigurationPolicyAppRouteDefinitionBuilderApi.md#edit_multiple_policy_definition12) | **PUT** /template/policy/definition/approute/multiple/{id} | 
*ConfigurationPolicyAppRouteDefinitionBuilderApi* | [**edit_policy_definition12**](docs/ConfigurationPolicyAppRouteDefinitionBuilderApi.md#edit_policy_definition12) | **PUT** /template/policy/definition/approute/{id} | 
*ConfigurationPolicyAppRouteDefinitionBuilderApi* | [**get_definitions12**](docs/ConfigurationPolicyAppRouteDefinitionBuilderApi.md#get_definitions12) | **GET** /template/policy/definition/approute | 
*ConfigurationPolicyAppRouteDefinitionBuilderApi* | [**get_policy_definition12**](docs/ConfigurationPolicyAppRouteDefinitionBuilderApi.md#get_policy_definition12) | **GET** /template/policy/definition/approute/{id} | 
*ConfigurationPolicyAppRouteDefinitionBuilderApi* | [**preview_policy_definition12**](docs/ConfigurationPolicyAppRouteDefinitionBuilderApi.md#preview_policy_definition12) | **POST** /template/policy/definition/approute/preview | 
*ConfigurationPolicyAppRouteDefinitionBuilderApi* | [**preview_policy_definition_by_id12**](docs/ConfigurationPolicyAppRouteDefinitionBuilderApi.md#preview_policy_definition_by_id12) | **GET** /template/policy/definition/approute/preview/{id} | 
*ConfigurationPolicyAppRouteDefinitionBuilderApi* | [**save_policy_definition_in_bulk12**](docs/ConfigurationPolicyAppRouteDefinitionBuilderApi.md#save_policy_definition_in_bulk12) | **PUT** /template/policy/definition/approute/bulk | 
*ConfigurationPolicyAppProbeClassBuilderApi* | [**create_policy_list4**](docs/ConfigurationPolicyAppProbeClassBuilderApi.md#create_policy_list4) | **POST** /template/policy/list/appprobe | 
*ConfigurationPolicyAppProbeClassBuilderApi* | [**delete_policy_list4**](docs/ConfigurationPolicyAppProbeClassBuilderApi.md#delete_policy_list4) | **DELETE** /template/policy/list/appprobe/{id} | 
*ConfigurationPolicyAppProbeClassBuilderApi* | [**delete_policy_lists_with_info_tag4**](docs/ConfigurationPolicyAppProbeClassBuilderApi.md#delete_policy_lists_with_info_tag4) | **DELETE** /template/policy/list/appprobe | 
*ConfigurationPolicyAppProbeClassBuilderApi* | [**edit_policy_list4**](docs/ConfigurationPolicyAppProbeClassBuilderApi.md#edit_policy_list4) | **PUT** /template/policy/list/appprobe/{id} | 
*ConfigurationPolicyAppProbeClassBuilderApi* | [**get_lists_by_id4**](docs/ConfigurationPolicyAppProbeClassBuilderApi.md#get_lists_by_id4) | **GET** /template/policy/list/appprobe/{id} | 
*ConfigurationPolicyAppProbeClassBuilderApi* | [**get_policy_lists4**](docs/ConfigurationPolicyAppProbeClassBuilderApi.md#get_policy_lists4) | **GET** /template/policy/list/appprobe | 
*ConfigurationPolicyAppProbeClassBuilderApi* | [**get_policy_lists_with_info_tag4**](docs/ConfigurationPolicyAppProbeClassBuilderApi.md#get_policy_lists_with_info_tag4) | **GET** /template/policy/list/appprobe/filtered | 
*ConfigurationPolicyAppProbeClassBuilderApi* | [**preview_policy_list4**](docs/ConfigurationPolicyAppProbeClassBuilderApi.md#preview_policy_list4) | **POST** /template/policy/list/appprobe/preview | 
*ConfigurationPolicyAppProbeClassBuilderApi* | [**preview_policy_list_by_id4**](docs/ConfigurationPolicyAppProbeClassBuilderApi.md#preview_policy_list_by_id4) | **GET** /template/policy/list/appprobe/preview/{id} | 
*ConfigurationPolicyApplicationListBuilderApi* | [**create_policy_list21**](docs/ConfigurationPolicyApplicationListBuilderApi.md#create_policy_list21) | **POST** /template/policy/list/localapp | 
*ConfigurationPolicyApplicationListBuilderApi* | [**create_policy_list3**](docs/ConfigurationPolicyApplicationListBuilderApi.md#create_policy_list3) | **POST** /template/policy/list/app | 
*ConfigurationPolicyApplicationListBuilderApi* | [**delete_policy_list21**](docs/ConfigurationPolicyApplicationListBuilderApi.md#delete_policy_list21) | **DELETE** /template/policy/list/localapp/{id} | 
*ConfigurationPolicyApplicationListBuilderApi* | [**delete_policy_list3**](docs/ConfigurationPolicyApplicationListBuilderApi.md#delete_policy_list3) | **DELETE** /template/policy/list/app/{id} | 
*ConfigurationPolicyApplicationListBuilderApi* | [**delete_policy_lists_with_info_tag21**](docs/ConfigurationPolicyApplicationListBuilderApi.md#delete_policy_lists_with_info_tag21) | **DELETE** /template/policy/list/localapp | 
*ConfigurationPolicyApplicationListBuilderApi* | [**delete_policy_lists_with_info_tag3**](docs/ConfigurationPolicyApplicationListBuilderApi.md#delete_policy_lists_with_info_tag3) | **DELETE** /template/policy/list/app | 
*ConfigurationPolicyApplicationListBuilderApi* | [**edit_policy_list21**](docs/ConfigurationPolicyApplicationListBuilderApi.md#edit_policy_list21) | **PUT** /template/policy/list/localapp/{id} | 
*ConfigurationPolicyApplicationListBuilderApi* | [**edit_policy_list3**](docs/ConfigurationPolicyApplicationListBuilderApi.md#edit_policy_list3) | **PUT** /template/policy/list/app/{id} | 
*ConfigurationPolicyApplicationListBuilderApi* | [**get_lists_by_id21**](docs/ConfigurationPolicyApplicationListBuilderApi.md#get_lists_by_id21) | **GET** /template/policy/list/localapp/{id} | 
*ConfigurationPolicyApplicationListBuilderApi* | [**get_lists_by_id3**](docs/ConfigurationPolicyApplicationListBuilderApi.md#get_lists_by_id3) | **GET** /template/policy/list/app/{id} | 
*ConfigurationPolicyApplicationListBuilderApi* | [**get_policy_lists18**](docs/ConfigurationPolicyApplicationListBuilderApi.md#get_policy_lists18) | **GET** /template/policy/list/localapp | 
*ConfigurationPolicyApplicationListBuilderApi* | [**get_policy_lists3**](docs/ConfigurationPolicyApplicationListBuilderApi.md#get_policy_lists3) | **GET** /template/policy/list/app | 
*ConfigurationPolicyApplicationListBuilderApi* | [**get_policy_lists_with_info_tag21**](docs/ConfigurationPolicyApplicationListBuilderApi.md#get_policy_lists_with_info_tag21) | **GET** /template/policy/list/localapp/filtered | 
*ConfigurationPolicyApplicationListBuilderApi* | [**get_policy_lists_with_info_tag3**](docs/ConfigurationPolicyApplicationListBuilderApi.md#get_policy_lists_with_info_tag3) | **GET** /template/policy/list/app/filtered | 
*ConfigurationPolicyApplicationListBuilderApi* | [**preview_policy_list21**](docs/ConfigurationPolicyApplicationListBuilderApi.md#preview_policy_list21) | **POST** /template/policy/list/localapp/preview | 
*ConfigurationPolicyApplicationListBuilderApi* | [**preview_policy_list3**](docs/ConfigurationPolicyApplicationListBuilderApi.md#preview_policy_list3) | **POST** /template/policy/list/app/preview | 
*ConfigurationPolicyApplicationListBuilderApi* | [**preview_policy_list_by_id21**](docs/ConfigurationPolicyApplicationListBuilderApi.md#preview_policy_list_by_id21) | **GET** /template/policy/list/localapp/preview/{id} | 
*ConfigurationPolicyApplicationListBuilderApi* | [**preview_policy_list_by_id3**](docs/ConfigurationPolicyApplicationListBuilderApi.md#preview_policy_list_by_id3) | **GET** /template/policy/list/app/preview/{id} | 
*ConfigurationPolicyCflowdDefinitionBuilderApi* | [**create_policy_definition13**](docs/ConfigurationPolicyCflowdDefinitionBuilderApi.md#create_policy_definition13) | **POST** /template/policy/definition/cflowd | 
*ConfigurationPolicyCflowdDefinitionBuilderApi* | [**delete_policy_definition13**](docs/ConfigurationPolicyCflowdDefinitionBuilderApi.md#delete_policy_definition13) | **DELETE** /template/policy/definition/cflowd/{id} | 
*ConfigurationPolicyCflowdDefinitionBuilderApi* | [**edit_multiple_policy_definition13**](docs/ConfigurationPolicyCflowdDefinitionBuilderApi.md#edit_multiple_policy_definition13) | **PUT** /template/policy/definition/cflowd/multiple/{id} | 
*ConfigurationPolicyCflowdDefinitionBuilderApi* | [**edit_policy_definition13**](docs/ConfigurationPolicyCflowdDefinitionBuilderApi.md#edit_policy_definition13) | **PUT** /template/policy/definition/cflowd/{id} | 
*ConfigurationPolicyCflowdDefinitionBuilderApi* | [**get_definitions13**](docs/ConfigurationPolicyCflowdDefinitionBuilderApi.md#get_definitions13) | **GET** /template/policy/definition/cflowd | 
*ConfigurationPolicyCflowdDefinitionBuilderApi* | [**get_policy_definition13**](docs/ConfigurationPolicyCflowdDefinitionBuilderApi.md#get_policy_definition13) | **GET** /template/policy/definition/cflowd/{id} | 
*ConfigurationPolicyCflowdDefinitionBuilderApi* | [**preview_policy_definition13**](docs/ConfigurationPolicyCflowdDefinitionBuilderApi.md#preview_policy_definition13) | **POST** /template/policy/definition/cflowd/preview | 
*ConfigurationPolicyCflowdDefinitionBuilderApi* | [**preview_policy_definition_by_id13**](docs/ConfigurationPolicyCflowdDefinitionBuilderApi.md#preview_policy_definition_by_id13) | **GET** /template/policy/definition/cflowd/preview/{id} | 
*ConfigurationPolicyCflowdDefinitionBuilderApi* | [**save_policy_definition_in_bulk13**](docs/ConfigurationPolicyCflowdDefinitionBuilderApi.md#save_policy_definition_in_bulk13) | **PUT** /template/policy/definition/cflowd/bulk | 
*ConfigurationPolicyCloudApplicationBuilderApi* | [**get_cloud_discovered_apps**](docs/ConfigurationPolicyCloudApplicationBuilderApi.md#get_cloud_discovered_apps) | **GET** /template/policy/clouddiscoveredapp | 
*ConfigurationPolicyColorListBuilderApi* | [**create_policy_list6**](docs/ConfigurationPolicyColorListBuilderApi.md#create_policy_list6) | **POST** /template/policy/list/color | 
*ConfigurationPolicyColorListBuilderApi* | [**delete_policy_list6**](docs/ConfigurationPolicyColorListBuilderApi.md#delete_policy_list6) | **DELETE** /template/policy/list/color/{id} | 
*ConfigurationPolicyColorListBuilderApi* | [**delete_policy_lists_with_info_tag6**](docs/ConfigurationPolicyColorListBuilderApi.md#delete_policy_lists_with_info_tag6) | **DELETE** /template/policy/list/color | 
*ConfigurationPolicyColorListBuilderApi* | [**edit_policy_list6**](docs/ConfigurationPolicyColorListBuilderApi.md#edit_policy_list6) | **PUT** /template/policy/list/color/{id} | 
*ConfigurationPolicyColorListBuilderApi* | [**get_lists_by_id6**](docs/ConfigurationPolicyColorListBuilderApi.md#get_lists_by_id6) | **GET** /template/policy/list/color/{id} | 
*ConfigurationPolicyColorListBuilderApi* | [**get_policy_lists6**](docs/ConfigurationPolicyColorListBuilderApi.md#get_policy_lists6) | **GET** /template/policy/list/color | 
*ConfigurationPolicyColorListBuilderApi* | [**get_policy_lists_with_info_tag6**](docs/ConfigurationPolicyColorListBuilderApi.md#get_policy_lists_with_info_tag6) | **GET** /template/policy/list/color/filtered | 
*ConfigurationPolicyColorListBuilderApi* | [**preview_policy_list6**](docs/ConfigurationPolicyColorListBuilderApi.md#preview_policy_list6) | **POST** /template/policy/list/color/preview | 
*ConfigurationPolicyColorListBuilderApi* | [**preview_policy_list_by_id6**](docs/ConfigurationPolicyColorListBuilderApi.md#preview_policy_list_by_id6) | **GET** /template/policy/list/color/preview/{id} | 
*ConfigurationPolicyCommunityListBuilderApi* | [**create_policy_list7**](docs/ConfigurationPolicyCommunityListBuilderApi.md#create_policy_list7) | **POST** /template/policy/list/community | 
*ConfigurationPolicyCommunityListBuilderApi* | [**delete_policy_list7**](docs/ConfigurationPolicyCommunityListBuilderApi.md#delete_policy_list7) | **DELETE** /template/policy/list/community/{id} | 
*ConfigurationPolicyCommunityListBuilderApi* | [**delete_policy_lists_with_info_tag7**](docs/ConfigurationPolicyCommunityListBuilderApi.md#delete_policy_lists_with_info_tag7) | **DELETE** /template/policy/list/community | 
*ConfigurationPolicyCommunityListBuilderApi* | [**edit_policy_list7**](docs/ConfigurationPolicyCommunityListBuilderApi.md#edit_policy_list7) | **PUT** /template/policy/list/community/{id} | 
*ConfigurationPolicyCommunityListBuilderApi* | [**get_lists_by_id7**](docs/ConfigurationPolicyCommunityListBuilderApi.md#get_lists_by_id7) | **GET** /template/policy/list/community/{id} | 
*ConfigurationPolicyCommunityListBuilderApi* | [**get_policy_lists7**](docs/ConfigurationPolicyCommunityListBuilderApi.md#get_policy_lists7) | **GET** /template/policy/list/community | 
*ConfigurationPolicyCommunityListBuilderApi* | [**get_policy_lists_with_info_tag7**](docs/ConfigurationPolicyCommunityListBuilderApi.md#get_policy_lists_with_info_tag7) | **GET** /template/policy/list/community/filtered | 
*ConfigurationPolicyCommunityListBuilderApi* | [**preview_policy_list7**](docs/ConfigurationPolicyCommunityListBuilderApi.md#preview_policy_list7) | **POST** /template/policy/list/community/preview | 
*ConfigurationPolicyCommunityListBuilderApi* | [**preview_policy_list_by_id7**](docs/ConfigurationPolicyCommunityListBuilderApi.md#preview_policy_list_by_id7) | **GET** /template/policy/list/community/preview/{id} | 
*ConfigurationPolicyControlDefinitionBuilderApi* | [**create_policy_definition14**](docs/ConfigurationPolicyControlDefinitionBuilderApi.md#create_policy_definition14) | **POST** /template/policy/definition/control | 
*ConfigurationPolicyControlDefinitionBuilderApi* | [**delete_policy_definition14**](docs/ConfigurationPolicyControlDefinitionBuilderApi.md#delete_policy_definition14) | **DELETE** /template/policy/definition/control/{id} | 
*ConfigurationPolicyControlDefinitionBuilderApi* | [**edit_multiple_policy_definition14**](docs/ConfigurationPolicyControlDefinitionBuilderApi.md#edit_multiple_policy_definition14) | **PUT** /template/policy/definition/control/multiple/{id} | 
*ConfigurationPolicyControlDefinitionBuilderApi* | [**edit_policy_definition14**](docs/ConfigurationPolicyControlDefinitionBuilderApi.md#edit_policy_definition14) | **PUT** /template/policy/definition/control/{id} | 
*ConfigurationPolicyControlDefinitionBuilderApi* | [**get_definitions14**](docs/ConfigurationPolicyControlDefinitionBuilderApi.md#get_definitions14) | **GET** /template/policy/definition/control | 
*ConfigurationPolicyControlDefinitionBuilderApi* | [**get_policy_definition14**](docs/ConfigurationPolicyControlDefinitionBuilderApi.md#get_policy_definition14) | **GET** /template/policy/definition/control/{id} | 
*ConfigurationPolicyControlDefinitionBuilderApi* | [**preview_policy_definition14**](docs/ConfigurationPolicyControlDefinitionBuilderApi.md#preview_policy_definition14) | **POST** /template/policy/definition/control/preview | 
*ConfigurationPolicyControlDefinitionBuilderApi* | [**preview_policy_definition_by_id14**](docs/ConfigurationPolicyControlDefinitionBuilderApi.md#preview_policy_definition_by_id14) | **GET** /template/policy/definition/control/preview/{id} | 
*ConfigurationPolicyControlDefinitionBuilderApi* | [**save_policy_definition_in_bulk14**](docs/ConfigurationPolicyControlDefinitionBuilderApi.md#save_policy_definition_in_bulk14) | **PUT** /template/policy/definition/control/bulk | 
*ConfigurationPolicyCustomApplicationBuilderApi* | [**create_custom_app**](docs/ConfigurationPolicyCustomApplicationBuilderApi.md#create_custom_app) | **POST** /template/policy/customapp | 
*ConfigurationPolicyCustomApplicationBuilderApi* | [**delete_custom_app**](docs/ConfigurationPolicyCustomApplicationBuilderApi.md#delete_custom_app) | **DELETE** /template/policy/customapp/{id} | 
*ConfigurationPolicyCustomApplicationBuilderApi* | [**edit_custom_app**](docs/ConfigurationPolicyCustomApplicationBuilderApi.md#edit_custom_app) | **PUT** /template/policy/customapp/{id} | 
*ConfigurationPolicyCustomApplicationBuilderApi* | [**get_custom_app_by_id**](docs/ConfigurationPolicyCustomApplicationBuilderApi.md#get_custom_app_by_id) | **GET** /template/policy/customapp/{id} | 
*ConfigurationPolicyCustomApplicationBuilderApi* | [**get_custom_apps**](docs/ConfigurationPolicyCustomApplicationBuilderApi.md#get_custom_apps) | **GET** /template/policy/customapp | 
*ConfigurationPolicyCustomApplicationBuilderApi* | [**map_traffic_profiles**](docs/ConfigurationPolicyCustomApplicationBuilderApi.md#map_traffic_profiles) | **POST** /template/policy/clouddiscoveredapp | 
*ConfigurationPolicyDataDefinitionBuilderApi* | [**create_policy_definition15**](docs/ConfigurationPolicyDataDefinitionBuilderApi.md#create_policy_definition15) | **POST** /template/policy/definition/data | 
*ConfigurationPolicyDataDefinitionBuilderApi* | [**delete_policy_definition15**](docs/ConfigurationPolicyDataDefinitionBuilderApi.md#delete_policy_definition15) | **DELETE** /template/policy/definition/data/{id} | 
*ConfigurationPolicyDataDefinitionBuilderApi* | [**edit_multiple_policy_definition15**](docs/ConfigurationPolicyDataDefinitionBuilderApi.md#edit_multiple_policy_definition15) | **PUT** /template/policy/definition/data/multiple/{id} | 
*ConfigurationPolicyDataDefinitionBuilderApi* | [**edit_policy_definition15**](docs/ConfigurationPolicyDataDefinitionBuilderApi.md#edit_policy_definition15) | **PUT** /template/policy/definition/data/{id} | 
*ConfigurationPolicyDataDefinitionBuilderApi* | [**get_definitions15**](docs/ConfigurationPolicyDataDefinitionBuilderApi.md#get_definitions15) | **GET** /template/policy/definition/data | 
*ConfigurationPolicyDataDefinitionBuilderApi* | [**get_policy_definition15**](docs/ConfigurationPolicyDataDefinitionBuilderApi.md#get_policy_definition15) | **GET** /template/policy/definition/data/{id} | 
*ConfigurationPolicyDataDefinitionBuilderApi* | [**preview_policy_definition15**](docs/ConfigurationPolicyDataDefinitionBuilderApi.md#preview_policy_definition15) | **POST** /template/policy/definition/data/preview | 
*ConfigurationPolicyDataDefinitionBuilderApi* | [**preview_policy_definition_by_id15**](docs/ConfigurationPolicyDataDefinitionBuilderApi.md#preview_policy_definition_by_id15) | **GET** /template/policy/definition/data/preview/{id} | 
*ConfigurationPolicyDataDefinitionBuilderApi* | [**save_policy_definition_in_bulk15**](docs/ConfigurationPolicyDataDefinitionBuilderApi.md#save_policy_definition_in_bulk15) | **PUT** /template/policy/definition/data/bulk | 
*ConfigurationPolicyDataIPV6PrefixListBuilderApi* | [**create_policy_list8**](docs/ConfigurationPolicyDataIPV6PrefixListBuilderApi.md#create_policy_list8) | **POST** /template/policy/list/dataipv6prefix | 
*ConfigurationPolicyDataIPV6PrefixListBuilderApi* | [**delete_policy_list8**](docs/ConfigurationPolicyDataIPV6PrefixListBuilderApi.md#delete_policy_list8) | **DELETE** /template/policy/list/dataipv6prefix/{id} | 
*ConfigurationPolicyDataIPV6PrefixListBuilderApi* | [**delete_policy_lists_with_info_tag8**](docs/ConfigurationPolicyDataIPV6PrefixListBuilderApi.md#delete_policy_lists_with_info_tag8) | **DELETE** /template/policy/list/dataipv6prefix | 
*ConfigurationPolicyDataIPV6PrefixListBuilderApi* | [**edit_policy_list8**](docs/ConfigurationPolicyDataIPV6PrefixListBuilderApi.md#edit_policy_list8) | **PUT** /template/policy/list/dataipv6prefix/{id} | 
*ConfigurationPolicyDataIPV6PrefixListBuilderApi* | [**get_lists_by_id8**](docs/ConfigurationPolicyDataIPV6PrefixListBuilderApi.md#get_lists_by_id8) | **GET** /template/policy/list/dataipv6prefix/{id} | 
*ConfigurationPolicyDataIPV6PrefixListBuilderApi* | [**get_policy_lists8**](docs/ConfigurationPolicyDataIPV6PrefixListBuilderApi.md#get_policy_lists8) | **GET** /template/policy/list/dataipv6prefix | 
*ConfigurationPolicyDataIPV6PrefixListBuilderApi* | [**get_policy_lists_with_info_tag8**](docs/ConfigurationPolicyDataIPV6PrefixListBuilderApi.md#get_policy_lists_with_info_tag8) | **GET** /template/policy/list/dataipv6prefix/filtered | 
*ConfigurationPolicyDataIPV6PrefixListBuilderApi* | [**preview_policy_list8**](docs/ConfigurationPolicyDataIPV6PrefixListBuilderApi.md#preview_policy_list8) | **POST** /template/policy/list/dataipv6prefix/preview | 
*ConfigurationPolicyDataIPV6PrefixListBuilderApi* | [**preview_policy_list_by_id8**](docs/ConfigurationPolicyDataIPV6PrefixListBuilderApi.md#preview_policy_list_by_id8) | **GET** /template/policy/list/dataipv6prefix/preview/{id} | 
*ConfigurationPolicyDataPrefixAllTypesOfListsBuilderApi* | [**create_policy_list9**](docs/ConfigurationPolicyDataPrefixAllTypesOfListsBuilderApi.md#create_policy_list9) | **POST** /template/policy/list/dataprefixall | 
*ConfigurationPolicyDataPrefixAllTypesOfListsBuilderApi* | [**delete_policy_list9**](docs/ConfigurationPolicyDataPrefixAllTypesOfListsBuilderApi.md#delete_policy_list9) | **DELETE** /template/policy/list/dataprefixall/{id} | 
*ConfigurationPolicyDataPrefixAllTypesOfListsBuilderApi* | [**delete_policy_lists_with_info_tag9**](docs/ConfigurationPolicyDataPrefixAllTypesOfListsBuilderApi.md#delete_policy_lists_with_info_tag9) | **DELETE** /template/policy/list/dataprefixall | 
*ConfigurationPolicyDataPrefixAllTypesOfListsBuilderApi* | [**edit_policy_list9**](docs/ConfigurationPolicyDataPrefixAllTypesOfListsBuilderApi.md#edit_policy_list9) | **PUT** /template/policy/list/dataprefixall/{id} | 
*ConfigurationPolicyDataPrefixAllTypesOfListsBuilderApi* | [**get_lists_by_id9**](docs/ConfigurationPolicyDataPrefixAllTypesOfListsBuilderApi.md#get_lists_by_id9) | **GET** /template/policy/list/dataprefixall/{id} | 
*ConfigurationPolicyDataPrefixAllTypesOfListsBuilderApi* | [**get_lists_for_all_data_prefixes**](docs/ConfigurationPolicyDataPrefixAllTypesOfListsBuilderApi.md#get_lists_for_all_data_prefixes) | **GET** /template/policy/list/dataprefixall | 
*ConfigurationPolicyDataPrefixAllTypesOfListsBuilderApi* | [**get_policy_lists_with_info_tag9**](docs/ConfigurationPolicyDataPrefixAllTypesOfListsBuilderApi.md#get_policy_lists_with_info_tag9) | **GET** /template/policy/list/dataprefixall/filtered | 
*ConfigurationPolicyDataPrefixAllTypesOfListsBuilderApi* | [**preview_policy_list9**](docs/ConfigurationPolicyDataPrefixAllTypesOfListsBuilderApi.md#preview_policy_list9) | **POST** /template/policy/list/dataprefixall/preview | 
*ConfigurationPolicyDataPrefixAllTypesOfListsBuilderApi* | [**preview_policy_list_by_id9**](docs/ConfigurationPolicyDataPrefixAllTypesOfListsBuilderApi.md#preview_policy_list_by_id9) | **GET** /template/policy/list/dataprefixall/preview/{id} | 
*ConfigurationPolicyDataPrefixListBuilderApi* | [**create_policy_list10**](docs/ConfigurationPolicyDataPrefixListBuilderApi.md#create_policy_list10) | **POST** /template/policy/list/dataprefix | 
*ConfigurationPolicyDataPrefixListBuilderApi* | [**delete_policy_list10**](docs/ConfigurationPolicyDataPrefixListBuilderApi.md#delete_policy_list10) | **DELETE** /template/policy/list/dataprefix/{id} | 
*ConfigurationPolicyDataPrefixListBuilderApi* | [**delete_policy_lists_with_info_tag10**](docs/ConfigurationPolicyDataPrefixListBuilderApi.md#delete_policy_lists_with_info_tag10) | **DELETE** /template/policy/list/dataprefix | 
*ConfigurationPolicyDataPrefixListBuilderApi* | [**edit_policy_list10**](docs/ConfigurationPolicyDataPrefixListBuilderApi.md#edit_policy_list10) | **PUT** /template/policy/list/dataprefix/{id} | 
*ConfigurationPolicyDataPrefixListBuilderApi* | [**get_lists_by_id10**](docs/ConfigurationPolicyDataPrefixListBuilderApi.md#get_lists_by_id10) | **GET** /template/policy/list/dataprefix/{id} | 
*ConfigurationPolicyDataPrefixListBuilderApi* | [**get_policy_lists9**](docs/ConfigurationPolicyDataPrefixListBuilderApi.md#get_policy_lists9) | **GET** /template/policy/list/dataprefix | 
*ConfigurationPolicyDataPrefixListBuilderApi* | [**get_policy_lists_with_info_tag10**](docs/ConfigurationPolicyDataPrefixListBuilderApi.md#get_policy_lists_with_info_tag10) | **GET** /template/policy/list/dataprefix/filtered | 
*ConfigurationPolicyDataPrefixListBuilderApi* | [**preview_policy_list10**](docs/ConfigurationPolicyDataPrefixListBuilderApi.md#preview_policy_list10) | **POST** /template/policy/list/dataprefix/preview | 
*ConfigurationPolicyDataPrefixListBuilderApi* | [**preview_policy_list_by_id10**](docs/ConfigurationPolicyDataPrefixListBuilderApi.md#preview_policy_list_by_id10) | **GET** /template/policy/list/dataprefix/preview/{id} | 
*ConfigurationPolicyDataPrefixAndFQDNAllTypesOfListsBuilderApi* | [**create_policy_list15**](docs/ConfigurationPolicyDataPrefixAndFQDNAllTypesOfListsBuilderApi.md#create_policy_list15) | **POST** /template/policy/list/dataprefixfqdn | 
*ConfigurationPolicyDataPrefixAndFQDNAllTypesOfListsBuilderApi* | [**delete_policy_list15**](docs/ConfigurationPolicyDataPrefixAndFQDNAllTypesOfListsBuilderApi.md#delete_policy_list15) | **DELETE** /template/policy/list/dataprefixfqdn/{id} | 
*ConfigurationPolicyDataPrefixAndFQDNAllTypesOfListsBuilderApi* | [**delete_policy_lists_with_info_tag15**](docs/ConfigurationPolicyDataPrefixAndFQDNAllTypesOfListsBuilderApi.md#delete_policy_lists_with_info_tag15) | **DELETE** /template/policy/list/dataprefixfqdn | 
*ConfigurationPolicyDataPrefixAndFQDNAllTypesOfListsBuilderApi* | [**edit_policy_list15**](docs/ConfigurationPolicyDataPrefixAndFQDNAllTypesOfListsBuilderApi.md#edit_policy_list15) | **PUT** /template/policy/list/dataprefixfqdn/{id} | 
*ConfigurationPolicyDataPrefixAndFQDNAllTypesOfListsBuilderApi* | [**get_all_data_prefix_and_fqdn_lists**](docs/ConfigurationPolicyDataPrefixAndFQDNAllTypesOfListsBuilderApi.md#get_all_data_prefix_and_fqdn_lists) | **GET** /template/policy/list/dataprefixfqdn | 
*ConfigurationPolicyDataPrefixAndFQDNAllTypesOfListsBuilderApi* | [**get_lists_by_id15**](docs/ConfigurationPolicyDataPrefixAndFQDNAllTypesOfListsBuilderApi.md#get_lists_by_id15) | **GET** /template/policy/list/dataprefixfqdn/{id} | 
*ConfigurationPolicyDataPrefixAndFQDNAllTypesOfListsBuilderApi* | [**get_policy_lists_with_info_tag15**](docs/ConfigurationPolicyDataPrefixAndFQDNAllTypesOfListsBuilderApi.md#get_policy_lists_with_info_tag15) | **GET** /template/policy/list/dataprefixfqdn/filtered | 
*ConfigurationPolicyDataPrefixAndFQDNAllTypesOfListsBuilderApi* | [**preview_policy_list15**](docs/ConfigurationPolicyDataPrefixAndFQDNAllTypesOfListsBuilderApi.md#preview_policy_list15) | **POST** /template/policy/list/dataprefixfqdn/preview | 
*ConfigurationPolicyDataPrefixAndFQDNAllTypesOfListsBuilderApi* | [**preview_policy_list_by_id15**](docs/ConfigurationPolicyDataPrefixAndFQDNAllTypesOfListsBuilderApi.md#preview_policy_list_by_id15) | **GET** /template/policy/list/dataprefixfqdn/preview/{id} | 
*ConfigurationPolicyDeviceAccessListDefinitionBuilderApi* | [**create_policy_definition16**](docs/ConfigurationPolicyDeviceAccessListDefinitionBuilderApi.md#create_policy_definition16) | **POST** /template/policy/definition/deviceaccesspolicy | 
*ConfigurationPolicyDeviceAccessListDefinitionBuilderApi* | [**delete_policy_definition16**](docs/ConfigurationPolicyDeviceAccessListDefinitionBuilderApi.md#delete_policy_definition16) | **DELETE** /template/policy/definition/deviceaccesspolicy/{id} | 
*ConfigurationPolicyDeviceAccessListDefinitionBuilderApi* | [**edit_multiple_policy_definition16**](docs/ConfigurationPolicyDeviceAccessListDefinitionBuilderApi.md#edit_multiple_policy_definition16) | **PUT** /template/policy/definition/deviceaccesspolicy/multiple/{id} | 
*ConfigurationPolicyDeviceAccessListDefinitionBuilderApi* | [**edit_policy_definition16**](docs/ConfigurationPolicyDeviceAccessListDefinitionBuilderApi.md#edit_policy_definition16) | **PUT** /template/policy/definition/deviceaccesspolicy/{id} | 
*ConfigurationPolicyDeviceAccessListDefinitionBuilderApi* | [**get_definitions16**](docs/ConfigurationPolicyDeviceAccessListDefinitionBuilderApi.md#get_definitions16) | **GET** /template/policy/definition/deviceaccesspolicy | 
*ConfigurationPolicyDeviceAccessListDefinitionBuilderApi* | [**get_policy_definition16**](docs/ConfigurationPolicyDeviceAccessListDefinitionBuilderApi.md#get_policy_definition16) | **GET** /template/policy/definition/deviceaccesspolicy/{id} | 
*ConfigurationPolicyDeviceAccessListDefinitionBuilderApi* | [**preview_policy_definition16**](docs/ConfigurationPolicyDeviceAccessListDefinitionBuilderApi.md#preview_policy_definition16) | **POST** /template/policy/definition/deviceaccesspolicy/preview | 
*ConfigurationPolicyDeviceAccessListDefinitionBuilderApi* | [**preview_policy_definition_by_id16**](docs/ConfigurationPolicyDeviceAccessListDefinitionBuilderApi.md#preview_policy_definition_by_id16) | **GET** /template/policy/definition/deviceaccesspolicy/preview/{id} | 
*ConfigurationPolicyDeviceAccessListDefinitionBuilderApi* | [**save_policy_definition_in_bulk16**](docs/ConfigurationPolicyDeviceAccessListDefinitionBuilderApi.md#save_policy_definition_in_bulk16) | **PUT** /template/policy/definition/deviceaccesspolicy/bulk | 
*ConfigurationPolicyDialPeerDefinitionBuilderApi* | [**create_policy_definition25**](docs/ConfigurationPolicyDialPeerDefinitionBuilderApi.md#create_policy_definition25) | **POST** /template/policy/definition/dialpeer | 
*ConfigurationPolicyDialPeerDefinitionBuilderApi* | [**create_policy_definition30**](docs/ConfigurationPolicyDialPeerDefinitionBuilderApi.md#create_policy_definition30) | **POST** /template/policy/definition/srstphoneprofile | 
*ConfigurationPolicyDialPeerDefinitionBuilderApi* | [**delete_policy_definition25**](docs/ConfigurationPolicyDialPeerDefinitionBuilderApi.md#delete_policy_definition25) | **DELETE** /template/policy/definition/dialpeer/{id} | 
*ConfigurationPolicyDialPeerDefinitionBuilderApi* | [**delete_policy_definition30**](docs/ConfigurationPolicyDialPeerDefinitionBuilderApi.md#delete_policy_definition30) | **DELETE** /template/policy/definition/srstphoneprofile/{id} | 
*ConfigurationPolicyDialPeerDefinitionBuilderApi* | [**edit_multiple_policy_definition25**](docs/ConfigurationPolicyDialPeerDefinitionBuilderApi.md#edit_multiple_policy_definition25) | **PUT** /template/policy/definition/dialpeer/multiple/{id} | 
*ConfigurationPolicyDialPeerDefinitionBuilderApi* | [**edit_multiple_policy_definition30**](docs/ConfigurationPolicyDialPeerDefinitionBuilderApi.md#edit_multiple_policy_definition30) | **PUT** /template/policy/definition/srstphoneprofile/multiple/{id} | 
*ConfigurationPolicyDialPeerDefinitionBuilderApi* | [**edit_policy_definition25**](docs/ConfigurationPolicyDialPeerDefinitionBuilderApi.md#edit_policy_definition25) | **PUT** /template/policy/definition/dialpeer/{id} | 
*ConfigurationPolicyDialPeerDefinitionBuilderApi* | [**edit_policy_definition30**](docs/ConfigurationPolicyDialPeerDefinitionBuilderApi.md#edit_policy_definition30) | **PUT** /template/policy/definition/srstphoneprofile/{id} | 
*ConfigurationPolicyDialPeerDefinitionBuilderApi* | [**get_definitions25**](docs/ConfigurationPolicyDialPeerDefinitionBuilderApi.md#get_definitions25) | **GET** /template/policy/definition/dialpeer | 
*ConfigurationPolicyDialPeerDefinitionBuilderApi* | [**get_definitions30**](docs/ConfigurationPolicyDialPeerDefinitionBuilderApi.md#get_definitions30) | **GET** /template/policy/definition/srstphoneprofile | 
*ConfigurationPolicyDialPeerDefinitionBuilderApi* | [**get_policy_definition25**](docs/ConfigurationPolicyDialPeerDefinitionBuilderApi.md#get_policy_definition25) | **GET** /template/policy/definition/dialpeer/{id} | 
*ConfigurationPolicyDialPeerDefinitionBuilderApi* | [**get_policy_definition30**](docs/ConfigurationPolicyDialPeerDefinitionBuilderApi.md#get_policy_definition30) | **GET** /template/policy/definition/srstphoneprofile/{id} | 
*ConfigurationPolicyDialPeerDefinitionBuilderApi* | [**preview_policy_definition25**](docs/ConfigurationPolicyDialPeerDefinitionBuilderApi.md#preview_policy_definition25) | **POST** /template/policy/definition/dialpeer/preview | 
*ConfigurationPolicyDialPeerDefinitionBuilderApi* | [**preview_policy_definition30**](docs/ConfigurationPolicyDialPeerDefinitionBuilderApi.md#preview_policy_definition30) | **POST** /template/policy/definition/srstphoneprofile/preview | 
*ConfigurationPolicyDialPeerDefinitionBuilderApi* | [**preview_policy_definition_by_id25**](docs/ConfigurationPolicyDialPeerDefinitionBuilderApi.md#preview_policy_definition_by_id25) | **GET** /template/policy/definition/dialpeer/preview/{id} | 
*ConfigurationPolicyDialPeerDefinitionBuilderApi* | [**preview_policy_definition_by_id30**](docs/ConfigurationPolicyDialPeerDefinitionBuilderApi.md#preview_policy_definition_by_id30) | **GET** /template/policy/definition/srstphoneprofile/preview/{id} | 
*ConfigurationPolicyDialPeerDefinitionBuilderApi* | [**save_policy_definition_in_bulk25**](docs/ConfigurationPolicyDialPeerDefinitionBuilderApi.md#save_policy_definition_in_bulk25) | **PUT** /template/policy/definition/dialpeer/bulk | 
*ConfigurationPolicyDialPeerDefinitionBuilderApi* | [**save_policy_definition_in_bulk30**](docs/ConfigurationPolicyDialPeerDefinitionBuilderApi.md#save_policy_definition_in_bulk30) | **PUT** /template/policy/definition/srstphoneprofile/bulk | 
*ConfigurationPolicyExpandedCommunityListBuilderApi* | [**create_policy_list11**](docs/ConfigurationPolicyExpandedCommunityListBuilderApi.md#create_policy_list11) | **POST** /template/policy/list/expandedcommunity | 
*ConfigurationPolicyExpandedCommunityListBuilderApi* | [**delete_policy_list11**](docs/ConfigurationPolicyExpandedCommunityListBuilderApi.md#delete_policy_list11) | **DELETE** /template/policy/list/expandedcommunity/{id} | 
*ConfigurationPolicyExpandedCommunityListBuilderApi* | [**delete_policy_lists_with_info_tag11**](docs/ConfigurationPolicyExpandedCommunityListBuilderApi.md#delete_policy_lists_with_info_tag11) | **DELETE** /template/policy/list/expandedcommunity | 
*ConfigurationPolicyExpandedCommunityListBuilderApi* | [**edit_policy_list11**](docs/ConfigurationPolicyExpandedCommunityListBuilderApi.md#edit_policy_list11) | **PUT** /template/policy/list/expandedcommunity/{id} | 
*ConfigurationPolicyExpandedCommunityListBuilderApi* | [**get_lists_by_id11**](docs/ConfigurationPolicyExpandedCommunityListBuilderApi.md#get_lists_by_id11) | **GET** /template/policy/list/expandedcommunity/{id} | 
*ConfigurationPolicyExpandedCommunityListBuilderApi* | [**get_policy_lists10**](docs/ConfigurationPolicyExpandedCommunityListBuilderApi.md#get_policy_lists10) | **GET** /template/policy/list/expandedcommunity | 
*ConfigurationPolicyExpandedCommunityListBuilderApi* | [**get_policy_lists_with_info_tag11**](docs/ConfigurationPolicyExpandedCommunityListBuilderApi.md#get_policy_lists_with_info_tag11) | **GET** /template/policy/list/expandedcommunity/filtered | 
*ConfigurationPolicyExpandedCommunityListBuilderApi* | [**preview_policy_list11**](docs/ConfigurationPolicyExpandedCommunityListBuilderApi.md#preview_policy_list11) | **POST** /template/policy/list/expandedcommunity/preview | 
*ConfigurationPolicyExpandedCommunityListBuilderApi* | [**preview_policy_list_by_id11**](docs/ConfigurationPolicyExpandedCommunityListBuilderApi.md#preview_policy_list_by_id11) | **GET** /template/policy/list/expandedcommunity/preview/{id} | 
*ConfigurationPolicyExtendedCommunityListBuilderApi* | [**create_policy_list12**](docs/ConfigurationPolicyExtendedCommunityListBuilderApi.md#create_policy_list12) | **POST** /template/policy/list/extcommunity | 
*ConfigurationPolicyExtendedCommunityListBuilderApi* | [**delete_policy_list12**](docs/ConfigurationPolicyExtendedCommunityListBuilderApi.md#delete_policy_list12) | **DELETE** /template/policy/list/extcommunity/{id} | 
*ConfigurationPolicyExtendedCommunityListBuilderApi* | [**delete_policy_lists_with_info_tag12**](docs/ConfigurationPolicyExtendedCommunityListBuilderApi.md#delete_policy_lists_with_info_tag12) | **DELETE** /template/policy/list/extcommunity | 
*ConfigurationPolicyExtendedCommunityListBuilderApi* | [**edit_policy_list12**](docs/ConfigurationPolicyExtendedCommunityListBuilderApi.md#edit_policy_list12) | **PUT** /template/policy/list/extcommunity/{id} | 
*ConfigurationPolicyExtendedCommunityListBuilderApi* | [**get_lists_by_id12**](docs/ConfigurationPolicyExtendedCommunityListBuilderApi.md#get_lists_by_id12) | **GET** /template/policy/list/extcommunity/{id} | 
*ConfigurationPolicyExtendedCommunityListBuilderApi* | [**get_policy_lists11**](docs/ConfigurationPolicyExtendedCommunityListBuilderApi.md#get_policy_lists11) | **GET** /template/policy/list/extcommunity | 
*ConfigurationPolicyExtendedCommunityListBuilderApi* | [**get_policy_lists_with_info_tag12**](docs/ConfigurationPolicyExtendedCommunityListBuilderApi.md#get_policy_lists_with_info_tag12) | **GET** /template/policy/list/extcommunity/filtered | 
*ConfigurationPolicyExtendedCommunityListBuilderApi* | [**preview_policy_list12**](docs/ConfigurationPolicyExtendedCommunityListBuilderApi.md#preview_policy_list12) | **POST** /template/policy/list/extcommunity/preview | 
*ConfigurationPolicyExtendedCommunityListBuilderApi* | [**preview_policy_list_by_id12**](docs/ConfigurationPolicyExtendedCommunityListBuilderApi.md#preview_policy_list_by_id12) | **GET** /template/policy/list/extcommunity/preview/{id} | 
*ConfigurationPolicyFXOPortDefinitionBuilderApi* | [**create_policy_definition26**](docs/ConfigurationPolicyFXOPortDefinitionBuilderApi.md#create_policy_definition26) | **POST** /template/policy/definition/fxoport | 
*ConfigurationPolicyFXOPortDefinitionBuilderApi* | [**delete_policy_definition26**](docs/ConfigurationPolicyFXOPortDefinitionBuilderApi.md#delete_policy_definition26) | **DELETE** /template/policy/definition/fxoport/{id} | 
*ConfigurationPolicyFXOPortDefinitionBuilderApi* | [**edit_multiple_policy_definition26**](docs/ConfigurationPolicyFXOPortDefinitionBuilderApi.md#edit_multiple_policy_definition26) | **PUT** /template/policy/definition/fxoport/multiple/{id} | 
*ConfigurationPolicyFXOPortDefinitionBuilderApi* | [**edit_policy_definition26**](docs/ConfigurationPolicyFXOPortDefinitionBuilderApi.md#edit_policy_definition26) | **PUT** /template/policy/definition/fxoport/{id} | 
*ConfigurationPolicyFXOPortDefinitionBuilderApi* | [**get_definitions26**](docs/ConfigurationPolicyFXOPortDefinitionBuilderApi.md#get_definitions26) | **GET** /template/policy/definition/fxoport | 
*ConfigurationPolicyFXOPortDefinitionBuilderApi* | [**get_policy_definition26**](docs/ConfigurationPolicyFXOPortDefinitionBuilderApi.md#get_policy_definition26) | **GET** /template/policy/definition/fxoport/{id} | 
*ConfigurationPolicyFXOPortDefinitionBuilderApi* | [**preview_policy_definition26**](docs/ConfigurationPolicyFXOPortDefinitionBuilderApi.md#preview_policy_definition26) | **POST** /template/policy/definition/fxoport/preview | 
*ConfigurationPolicyFXOPortDefinitionBuilderApi* | [**preview_policy_definition_by_id26**](docs/ConfigurationPolicyFXOPortDefinitionBuilderApi.md#preview_policy_definition_by_id26) | **GET** /template/policy/definition/fxoport/preview/{id} | 
*ConfigurationPolicyFXOPortDefinitionBuilderApi* | [**save_policy_definition_in_bulk26**](docs/ConfigurationPolicyFXOPortDefinitionBuilderApi.md#save_policy_definition_in_bulk26) | **PUT** /template/policy/definition/fxoport/bulk | 
*ConfigurationPolicyFXSDIDPortDefinitionBuilderApi* | [**create_policy_definition28**](docs/ConfigurationPolicyFXSDIDPortDefinitionBuilderApi.md#create_policy_definition28) | **POST** /template/policy/definition/fxsdidport | 
*ConfigurationPolicyFXSDIDPortDefinitionBuilderApi* | [**delete_policy_definition28**](docs/ConfigurationPolicyFXSDIDPortDefinitionBuilderApi.md#delete_policy_definition28) | **DELETE** /template/policy/definition/fxsdidport/{id} | 
*ConfigurationPolicyFXSDIDPortDefinitionBuilderApi* | [**edit_multiple_policy_definition28**](docs/ConfigurationPolicyFXSDIDPortDefinitionBuilderApi.md#edit_multiple_policy_definition28) | **PUT** /template/policy/definition/fxsdidport/multiple/{id} | 
*ConfigurationPolicyFXSDIDPortDefinitionBuilderApi* | [**edit_policy_definition28**](docs/ConfigurationPolicyFXSDIDPortDefinitionBuilderApi.md#edit_policy_definition28) | **PUT** /template/policy/definition/fxsdidport/{id} | 
*ConfigurationPolicyFXSDIDPortDefinitionBuilderApi* | [**get_definitions28**](docs/ConfigurationPolicyFXSDIDPortDefinitionBuilderApi.md#get_definitions28) | **GET** /template/policy/definition/fxsdidport | 
*ConfigurationPolicyFXSDIDPortDefinitionBuilderApi* | [**get_policy_definition28**](docs/ConfigurationPolicyFXSDIDPortDefinitionBuilderApi.md#get_policy_definition28) | **GET** /template/policy/definition/fxsdidport/{id} | 
*ConfigurationPolicyFXSDIDPortDefinitionBuilderApi* | [**preview_policy_definition28**](docs/ConfigurationPolicyFXSDIDPortDefinitionBuilderApi.md#preview_policy_definition28) | **POST** /template/policy/definition/fxsdidport/preview | 
*ConfigurationPolicyFXSDIDPortDefinitionBuilderApi* | [**preview_policy_definition_by_id28**](docs/ConfigurationPolicyFXSDIDPortDefinitionBuilderApi.md#preview_policy_definition_by_id28) | **GET** /template/policy/definition/fxsdidport/preview/{id} | 
*ConfigurationPolicyFXSDIDPortDefinitionBuilderApi* | [**save_policy_definition_in_bulk28**](docs/ConfigurationPolicyFXSDIDPortDefinitionBuilderApi.md#save_policy_definition_in_bulk28) | **PUT** /template/policy/definition/fxsdidport/bulk | 
*ConfigurationPolicyFXSPortDefinitionBuilderApi* | [**create_policy_definition27**](docs/ConfigurationPolicyFXSPortDefinitionBuilderApi.md#create_policy_definition27) | **POST** /template/policy/definition/fxsport | 
*ConfigurationPolicyFXSPortDefinitionBuilderApi* | [**delete_policy_definition27**](docs/ConfigurationPolicyFXSPortDefinitionBuilderApi.md#delete_policy_definition27) | **DELETE** /template/policy/definition/fxsport/{id} | 
*ConfigurationPolicyFXSPortDefinitionBuilderApi* | [**edit_multiple_policy_definition27**](docs/ConfigurationPolicyFXSPortDefinitionBuilderApi.md#edit_multiple_policy_definition27) | **PUT** /template/policy/definition/fxsport/multiple/{id} | 
*ConfigurationPolicyFXSPortDefinitionBuilderApi* | [**edit_policy_definition27**](docs/ConfigurationPolicyFXSPortDefinitionBuilderApi.md#edit_policy_definition27) | **PUT** /template/policy/definition/fxsport/{id} | 
*ConfigurationPolicyFXSPortDefinitionBuilderApi* | [**get_definitions27**](docs/ConfigurationPolicyFXSPortDefinitionBuilderApi.md#get_definitions27) | **GET** /template/policy/definition/fxsport | 
*ConfigurationPolicyFXSPortDefinitionBuilderApi* | [**get_policy_definition27**](docs/ConfigurationPolicyFXSPortDefinitionBuilderApi.md#get_policy_definition27) | **GET** /template/policy/definition/fxsport/{id} | 
*ConfigurationPolicyFXSPortDefinitionBuilderApi* | [**preview_policy_definition27**](docs/ConfigurationPolicyFXSPortDefinitionBuilderApi.md#preview_policy_definition27) | **POST** /template/policy/definition/fxsport/preview | 
*ConfigurationPolicyFXSPortDefinitionBuilderApi* | [**preview_policy_definition_by_id27**](docs/ConfigurationPolicyFXSPortDefinitionBuilderApi.md#preview_policy_definition_by_id27) | **GET** /template/policy/definition/fxsport/preview/{id} | 
*ConfigurationPolicyFXSPortDefinitionBuilderApi* | [**save_policy_definition_in_bulk27**](docs/ConfigurationPolicyFXSPortDefinitionBuilderApi.md#save_policy_definition_in_bulk27) | **PUT** /template/policy/definition/fxsport/bulk | 
*ConfigurationPolicyFaxProtocolListBuilderApi* | [**create_policy_list13**](docs/ConfigurationPolicyFaxProtocolListBuilderApi.md#create_policy_list13) | **POST** /template/policy/list/faxprotocol | 
*ConfigurationPolicyFaxProtocolListBuilderApi* | [**delete_policy_list13**](docs/ConfigurationPolicyFaxProtocolListBuilderApi.md#delete_policy_list13) | **DELETE** /template/policy/list/faxprotocol/{id} | 
*ConfigurationPolicyFaxProtocolListBuilderApi* | [**delete_policy_lists_with_info_tag13**](docs/ConfigurationPolicyFaxProtocolListBuilderApi.md#delete_policy_lists_with_info_tag13) | **DELETE** /template/policy/list/faxprotocol | 
*ConfigurationPolicyFaxProtocolListBuilderApi* | [**edit_policy_list13**](docs/ConfigurationPolicyFaxProtocolListBuilderApi.md#edit_policy_list13) | **PUT** /template/policy/list/faxprotocol/{id} | 
*ConfigurationPolicyFaxProtocolListBuilderApi* | [**get_lists_by_id13**](docs/ConfigurationPolicyFaxProtocolListBuilderApi.md#get_lists_by_id13) | **GET** /template/policy/list/faxprotocol/{id} | 
*ConfigurationPolicyFaxProtocolListBuilderApi* | [**get_policy_lists12**](docs/ConfigurationPolicyFaxProtocolListBuilderApi.md#get_policy_lists12) | **GET** /template/policy/list/faxprotocol | 
*ConfigurationPolicyFaxProtocolListBuilderApi* | [**get_policy_lists_with_info_tag13**](docs/ConfigurationPolicyFaxProtocolListBuilderApi.md#get_policy_lists_with_info_tag13) | **GET** /template/policy/list/faxprotocol/filtered | 
*ConfigurationPolicyFaxProtocolListBuilderApi* | [**preview_policy_list13**](docs/ConfigurationPolicyFaxProtocolListBuilderApi.md#preview_policy_list13) | **POST** /template/policy/list/faxprotocol/preview | 
*ConfigurationPolicyFaxProtocolListBuilderApi* | [**preview_policy_list_by_id13**](docs/ConfigurationPolicyFaxProtocolListBuilderApi.md#preview_policy_list_by_id13) | **GET** /template/policy/list/faxprotocol/preview/{id} | 
*ConfigurationPolicyForwardingClassListBuilderApi* | [**create_policy_list14**](docs/ConfigurationPolicyForwardingClassListBuilderApi.md#create_policy_list14) | **POST** /template/policy/list/class | 
*ConfigurationPolicyForwardingClassListBuilderApi* | [**delete_policy_list14**](docs/ConfigurationPolicyForwardingClassListBuilderApi.md#delete_policy_list14) | **DELETE** /template/policy/list/class/{id} | 
*ConfigurationPolicyForwardingClassListBuilderApi* | [**delete_policy_lists_with_info_tag14**](docs/ConfigurationPolicyForwardingClassListBuilderApi.md#delete_policy_lists_with_info_tag14) | **DELETE** /template/policy/list/class | 
*ConfigurationPolicyForwardingClassListBuilderApi* | [**edit_policy_list14**](docs/ConfigurationPolicyForwardingClassListBuilderApi.md#edit_policy_list14) | **PUT** /template/policy/list/class/{id} | 
*ConfigurationPolicyForwardingClassListBuilderApi* | [**get_lists_by_id14**](docs/ConfigurationPolicyForwardingClassListBuilderApi.md#get_lists_by_id14) | **GET** /template/policy/list/class/{id} | 
*ConfigurationPolicyForwardingClassListBuilderApi* | [**get_policy_lists13**](docs/ConfigurationPolicyForwardingClassListBuilderApi.md#get_policy_lists13) | **GET** /template/policy/list/class | 
*ConfigurationPolicyForwardingClassListBuilderApi* | [**get_policy_lists_with_info_tag14**](docs/ConfigurationPolicyForwardingClassListBuilderApi.md#get_policy_lists_with_info_tag14) | **GET** /template/policy/list/class/filtered | 
*ConfigurationPolicyForwardingClassListBuilderApi* | [**preview_policy_list14**](docs/ConfigurationPolicyForwardingClassListBuilderApi.md#preview_policy_list14) | **POST** /template/policy/list/class/preview | 
*ConfigurationPolicyForwardingClassListBuilderApi* | [**preview_policy_list_by_id14**](docs/ConfigurationPolicyForwardingClassListBuilderApi.md#preview_policy_list_by_id14) | **GET** /template/policy/list/class/preview/{id} | 
*ConfigurationPolicyGeoLocationBuilderApi* | [**create_policy_list17**](docs/ConfigurationPolicyGeoLocationBuilderApi.md#create_policy_list17) | **POST** /template/policy/list/geolocation | 
*ConfigurationPolicyGeoLocationBuilderApi* | [**delete_policy_list17**](docs/ConfigurationPolicyGeoLocationBuilderApi.md#delete_policy_list17) | **DELETE** /template/policy/list/geolocation/{id} | 
*ConfigurationPolicyGeoLocationBuilderApi* | [**delete_policy_lists_with_info_tag17**](docs/ConfigurationPolicyGeoLocationBuilderApi.md#delete_policy_lists_with_info_tag17) | **DELETE** /template/policy/list/geolocation | 
*ConfigurationPolicyGeoLocationBuilderApi* | [**edit_policy_list17**](docs/ConfigurationPolicyGeoLocationBuilderApi.md#edit_policy_list17) | **PUT** /template/policy/list/geolocation/{id} | 
*ConfigurationPolicyGeoLocationBuilderApi* | [**get_geo_location_lists**](docs/ConfigurationPolicyGeoLocationBuilderApi.md#get_geo_location_lists) | **GET** /template/policy/list/geolocation/entries | 
*ConfigurationPolicyGeoLocationBuilderApi* | [**get_lists_by_id17**](docs/ConfigurationPolicyGeoLocationBuilderApi.md#get_lists_by_id17) | **GET** /template/policy/list/geolocation/{id} | 
*ConfigurationPolicyGeoLocationBuilderApi* | [**get_policy_lists15**](docs/ConfigurationPolicyGeoLocationBuilderApi.md#get_policy_lists15) | **GET** /template/policy/list/geolocation | 
*ConfigurationPolicyGeoLocationBuilderApi* | [**get_policy_lists_with_info_tag17**](docs/ConfigurationPolicyGeoLocationBuilderApi.md#get_policy_lists_with_info_tag17) | **GET** /template/policy/list/geolocation/filtered | 
*ConfigurationPolicyGeoLocationBuilderApi* | [**preview_policy_list17**](docs/ConfigurationPolicyGeoLocationBuilderApi.md#preview_policy_list17) | **POST** /template/policy/list/geolocation/preview | 
*ConfigurationPolicyGeoLocationBuilderApi* | [**preview_policy_list_by_id17**](docs/ConfigurationPolicyGeoLocationBuilderApi.md#preview_policy_list_by_id17) | **GET** /template/policy/list/geolocation/preview/{id} | 
*ConfigurationPolicyHubAndSpokeDefinitionBuilderApi* | [**create_policy_definition4**](docs/ConfigurationPolicyHubAndSpokeDefinitionBuilderApi.md#create_policy_definition4) | **POST** /template/policy/definition/hubandspoke | 
*ConfigurationPolicyHubAndSpokeDefinitionBuilderApi* | [**delete_policy_definition4**](docs/ConfigurationPolicyHubAndSpokeDefinitionBuilderApi.md#delete_policy_definition4) | **DELETE** /template/policy/definition/hubandspoke/{id} | 
*ConfigurationPolicyHubAndSpokeDefinitionBuilderApi* | [**edit_multiple_policy_definition4**](docs/ConfigurationPolicyHubAndSpokeDefinitionBuilderApi.md#edit_multiple_policy_definition4) | **PUT** /template/policy/definition/hubandspoke/multiple/{id} | 
*ConfigurationPolicyHubAndSpokeDefinitionBuilderApi* | [**edit_policy_definition4**](docs/ConfigurationPolicyHubAndSpokeDefinitionBuilderApi.md#edit_policy_definition4) | **PUT** /template/policy/definition/hubandspoke/{id} | 
*ConfigurationPolicyHubAndSpokeDefinitionBuilderApi* | [**get_definitions4**](docs/ConfigurationPolicyHubAndSpokeDefinitionBuilderApi.md#get_definitions4) | **GET** /template/policy/definition/hubandspoke | 
*ConfigurationPolicyHubAndSpokeDefinitionBuilderApi* | [**get_policy_definition4**](docs/ConfigurationPolicyHubAndSpokeDefinitionBuilderApi.md#get_policy_definition4) | **GET** /template/policy/definition/hubandspoke/{id} | 
*ConfigurationPolicyHubAndSpokeDefinitionBuilderApi* | [**preview_policy_definition4**](docs/ConfigurationPolicyHubAndSpokeDefinitionBuilderApi.md#preview_policy_definition4) | **POST** /template/policy/definition/hubandspoke/preview | 
*ConfigurationPolicyHubAndSpokeDefinitionBuilderApi* | [**preview_policy_definition_by_id4**](docs/ConfigurationPolicyHubAndSpokeDefinitionBuilderApi.md#preview_policy_definition_by_id4) | **GET** /template/policy/definition/hubandspoke/preview/{id} | 
*ConfigurationPolicyHubAndSpokeDefinitionBuilderApi* | [**save_policy_definition_in_bulk4**](docs/ConfigurationPolicyHubAndSpokeDefinitionBuilderApi.md#save_policy_definition_in_bulk4) | **PUT** /template/policy/definition/hubandspoke/bulk | 
*ConfigurationPolicyIPSSignatureListBuilderApi* | [**create_policy_list18**](docs/ConfigurationPolicyIPSSignatureListBuilderApi.md#create_policy_list18) | **POST** /template/policy/list/ipssignature | 
*ConfigurationPolicyIPSSignatureListBuilderApi* | [**delete_policy_list18**](docs/ConfigurationPolicyIPSSignatureListBuilderApi.md#delete_policy_list18) | **DELETE** /template/policy/list/ipssignature/{id} | 
*ConfigurationPolicyIPSSignatureListBuilderApi* | [**delete_policy_lists_with_info_tag18**](docs/ConfigurationPolicyIPSSignatureListBuilderApi.md#delete_policy_lists_with_info_tag18) | **DELETE** /template/policy/list/ipssignature | 
*ConfigurationPolicyIPSSignatureListBuilderApi* | [**edit_policy_list18**](docs/ConfigurationPolicyIPSSignatureListBuilderApi.md#edit_policy_list18) | **PUT** /template/policy/list/ipssignature/{id} | 
*ConfigurationPolicyIPSSignatureListBuilderApi* | [**get_lists_by_id18**](docs/ConfigurationPolicyIPSSignatureListBuilderApi.md#get_lists_by_id18) | **GET** /template/policy/list/ipssignature/{id} | 
*ConfigurationPolicyIPSSignatureListBuilderApi* | [**get_policy_lists16**](docs/ConfigurationPolicyIPSSignatureListBuilderApi.md#get_policy_lists16) | **GET** /template/policy/list/ipssignature | 
*ConfigurationPolicyIPSSignatureListBuilderApi* | [**get_policy_lists_with_info_tag18**](docs/ConfigurationPolicyIPSSignatureListBuilderApi.md#get_policy_lists_with_info_tag18) | **GET** /template/policy/list/ipssignature/filtered | 
*ConfigurationPolicyIPSSignatureListBuilderApi* | [**preview_policy_list18**](docs/ConfigurationPolicyIPSSignatureListBuilderApi.md#preview_policy_list18) | **POST** /template/policy/list/ipssignature/preview | 
*ConfigurationPolicyIPSSignatureListBuilderApi* | [**preview_policy_list_by_id18**](docs/ConfigurationPolicyIPSSignatureListBuilderApi.md#preview_policy_list_by_id18) | **GET** /template/policy/list/ipssignature/preview/{id} | 
*ConfigurationPolicyIPv6AccessListDefinitionBuilderApi* | [**create_policy_definition9**](docs/ConfigurationPolicyIPv6AccessListDefinitionBuilderApi.md#create_policy_definition9) | **POST** /template/policy/definition/aclv6 | 
*ConfigurationPolicyIPv6AccessListDefinitionBuilderApi* | [**delete_policy_definition9**](docs/ConfigurationPolicyIPv6AccessListDefinitionBuilderApi.md#delete_policy_definition9) | **DELETE** /template/policy/definition/aclv6/{id} | 
*ConfigurationPolicyIPv6AccessListDefinitionBuilderApi* | [**edit_multiple_policy_definition9**](docs/ConfigurationPolicyIPv6AccessListDefinitionBuilderApi.md#edit_multiple_policy_definition9) | **PUT** /template/policy/definition/aclv6/multiple/{id} | 
*ConfigurationPolicyIPv6AccessListDefinitionBuilderApi* | [**edit_policy_definition9**](docs/ConfigurationPolicyIPv6AccessListDefinitionBuilderApi.md#edit_policy_definition9) | **PUT** /template/policy/definition/aclv6/{id} | 
*ConfigurationPolicyIPv6AccessListDefinitionBuilderApi* | [**get_definitions9**](docs/ConfigurationPolicyIPv6AccessListDefinitionBuilderApi.md#get_definitions9) | **GET** /template/policy/definition/aclv6 | 
*ConfigurationPolicyIPv6AccessListDefinitionBuilderApi* | [**get_policy_definition9**](docs/ConfigurationPolicyIPv6AccessListDefinitionBuilderApi.md#get_policy_definition9) | **GET** /template/policy/definition/aclv6/{id} | 
*ConfigurationPolicyIPv6AccessListDefinitionBuilderApi* | [**preview_policy_definition9**](docs/ConfigurationPolicyIPv6AccessListDefinitionBuilderApi.md#preview_policy_definition9) | **POST** /template/policy/definition/aclv6/preview | 
*ConfigurationPolicyIPv6AccessListDefinitionBuilderApi* | [**preview_policy_definition_by_id9**](docs/ConfigurationPolicyIPv6AccessListDefinitionBuilderApi.md#preview_policy_definition_by_id9) | **GET** /template/policy/definition/aclv6/preview/{id} | 
*ConfigurationPolicyIPv6AccessListDefinitionBuilderApi* | [**save_policy_definition_in_bulk9**](docs/ConfigurationPolicyIPv6AccessListDefinitionBuilderApi.md#save_policy_definition_in_bulk9) | **PUT** /template/policy/definition/aclv6/bulk | 
*ConfigurationPolicyIPv6DeviceAccessListDefinitionBuilderApi* | [**create_policy_definition17**](docs/ConfigurationPolicyIPv6DeviceAccessListDefinitionBuilderApi.md#create_policy_definition17) | **POST** /template/policy/definition/deviceaccesspolicyv6 | 
*ConfigurationPolicyIPv6DeviceAccessListDefinitionBuilderApi* | [**delete_policy_definition17**](docs/ConfigurationPolicyIPv6DeviceAccessListDefinitionBuilderApi.md#delete_policy_definition17) | **DELETE** /template/policy/definition/deviceaccesspolicyv6/{id} | 
*ConfigurationPolicyIPv6DeviceAccessListDefinitionBuilderApi* | [**edit_multiple_policy_definition17**](docs/ConfigurationPolicyIPv6DeviceAccessListDefinitionBuilderApi.md#edit_multiple_policy_definition17) | **PUT** /template/policy/definition/deviceaccesspolicyv6/multiple/{id} | 
*ConfigurationPolicyIPv6DeviceAccessListDefinitionBuilderApi* | [**edit_policy_definition17**](docs/ConfigurationPolicyIPv6DeviceAccessListDefinitionBuilderApi.md#edit_policy_definition17) | **PUT** /template/policy/definition/deviceaccesspolicyv6/{id} | 
*ConfigurationPolicyIPv6DeviceAccessListDefinitionBuilderApi* | [**get_definitions17**](docs/ConfigurationPolicyIPv6DeviceAccessListDefinitionBuilderApi.md#get_definitions17) | **GET** /template/policy/definition/deviceaccesspolicyv6 | 
*ConfigurationPolicyIPv6DeviceAccessListDefinitionBuilderApi* | [**get_policy_definition17**](docs/ConfigurationPolicyIPv6DeviceAccessListDefinitionBuilderApi.md#get_policy_definition17) | **GET** /template/policy/definition/deviceaccesspolicyv6/{id} | 
*ConfigurationPolicyIPv6DeviceAccessListDefinitionBuilderApi* | [**preview_policy_definition17**](docs/ConfigurationPolicyIPv6DeviceAccessListDefinitionBuilderApi.md#preview_policy_definition17) | **POST** /template/policy/definition/deviceaccesspolicyv6/preview | 
*ConfigurationPolicyIPv6DeviceAccessListDefinitionBuilderApi* | [**preview_policy_definition_by_id17**](docs/ConfigurationPolicyIPv6DeviceAccessListDefinitionBuilderApi.md#preview_policy_definition_by_id17) | **GET** /template/policy/definition/deviceaccesspolicyv6/preview/{id} | 
*ConfigurationPolicyIPv6DeviceAccessListDefinitionBuilderApi* | [**save_policy_definition_in_bulk17**](docs/ConfigurationPolicyIPv6DeviceAccessListDefinitionBuilderApi.md#save_policy_definition_in_bulk17) | **PUT** /template/policy/definition/deviceaccesspolicyv6/bulk | 
*ConfigurationPolicyIPv6PrefixListBuilderApi* | [**create_policy_list19**](docs/ConfigurationPolicyIPv6PrefixListBuilderApi.md#create_policy_list19) | **POST** /template/policy/list/ipv6prefix | 
*ConfigurationPolicyIPv6PrefixListBuilderApi* | [**delete_policy_list19**](docs/ConfigurationPolicyIPv6PrefixListBuilderApi.md#delete_policy_list19) | **DELETE** /template/policy/list/ipv6prefix/{id} | 
*ConfigurationPolicyIPv6PrefixListBuilderApi* | [**delete_policy_lists_with_info_tag19**](docs/ConfigurationPolicyIPv6PrefixListBuilderApi.md#delete_policy_lists_with_info_tag19) | **DELETE** /template/policy/list/ipv6prefix | 
*ConfigurationPolicyIPv6PrefixListBuilderApi* | [**edit_policy_list19**](docs/ConfigurationPolicyIPv6PrefixListBuilderApi.md#edit_policy_list19) | **PUT** /template/policy/list/ipv6prefix/{id} | 
*ConfigurationPolicyIPv6PrefixListBuilderApi* | [**get_lists_by_id19**](docs/ConfigurationPolicyIPv6PrefixListBuilderApi.md#get_lists_by_id19) | **GET** /template/policy/list/ipv6prefix/{id} | 
*ConfigurationPolicyIPv6PrefixListBuilderApi* | [**get_policy_lists17**](docs/ConfigurationPolicyIPv6PrefixListBuilderApi.md#get_policy_lists17) | **GET** /template/policy/list/ipv6prefix | 
*ConfigurationPolicyIPv6PrefixListBuilderApi* | [**get_policy_lists_with_info_tag19**](docs/ConfigurationPolicyIPv6PrefixListBuilderApi.md#get_policy_lists_with_info_tag19) | **GET** /template/policy/list/ipv6prefix/filtered | 
*ConfigurationPolicyIPv6PrefixListBuilderApi* | [**preview_policy_list19**](docs/ConfigurationPolicyIPv6PrefixListBuilderApi.md#preview_policy_list19) | **POST** /template/policy/list/ipv6prefix/preview | 
*ConfigurationPolicyIPv6PrefixListBuilderApi* | [**preview_policy_list_by_id19**](docs/ConfigurationPolicyIPv6PrefixListBuilderApi.md#preview_policy_list_by_id19) | **GET** /template/policy/list/ipv6prefix/preview/{id} | 
*ConfigurationPolicyIntrusionPreventionDefinitionBuilderApi* | [**create_policy_definition18**](docs/ConfigurationPolicyIntrusionPreventionDefinitionBuilderApi.md#create_policy_definition18) | **POST** /template/policy/definition/intrusionprevention | 
*ConfigurationPolicyIntrusionPreventionDefinitionBuilderApi* | [**delete_policy_definition18**](docs/ConfigurationPolicyIntrusionPreventionDefinitionBuilderApi.md#delete_policy_definition18) | **DELETE** /template/policy/definition/intrusionprevention/{id} | 
*ConfigurationPolicyIntrusionPreventionDefinitionBuilderApi* | [**edit_multiple_policy_definition18**](docs/ConfigurationPolicyIntrusionPreventionDefinitionBuilderApi.md#edit_multiple_policy_definition18) | **PUT** /template/policy/definition/intrusionprevention/multiple/{id} | 
*ConfigurationPolicyIntrusionPreventionDefinitionBuilderApi* | [**edit_policy_definition18**](docs/ConfigurationPolicyIntrusionPreventionDefinitionBuilderApi.md#edit_policy_definition18) | **PUT** /template/policy/definition/intrusionprevention/{id} | 
*ConfigurationPolicyIntrusionPreventionDefinitionBuilderApi* | [**get_definitions18**](docs/ConfigurationPolicyIntrusionPreventionDefinitionBuilderApi.md#get_definitions18) | **GET** /template/policy/definition/intrusionprevention | 
*ConfigurationPolicyIntrusionPreventionDefinitionBuilderApi* | [**get_policy_definition18**](docs/ConfigurationPolicyIntrusionPreventionDefinitionBuilderApi.md#get_policy_definition18) | **GET** /template/policy/definition/intrusionprevention/{id} | 
*ConfigurationPolicyIntrusionPreventionDefinitionBuilderApi* | [**preview_policy_definition18**](docs/ConfigurationPolicyIntrusionPreventionDefinitionBuilderApi.md#preview_policy_definition18) | **POST** /template/policy/definition/intrusionprevention/preview | 
*ConfigurationPolicyIntrusionPreventionDefinitionBuilderApi* | [**preview_policy_definition_by_id18**](docs/ConfigurationPolicyIntrusionPreventionDefinitionBuilderApi.md#preview_policy_definition_by_id18) | **GET** /template/policy/definition/intrusionprevention/preview/{id} | 
*ConfigurationPolicyIntrusionPreventionDefinitionBuilderApi* | [**save_policy_definition_in_bulk18**](docs/ConfigurationPolicyIntrusionPreventionDefinitionBuilderApi.md#save_policy_definition_in_bulk18) | **PUT** /template/policy/definition/intrusionprevention/bulk | 
*ConfigurationPolicyListBuilderApi* | [**create_webex_prefix_lists**](docs/ConfigurationPolicyListBuilderApi.md#create_webex_prefix_lists) | **POST** /template/policy/list/webex | 
*ConfigurationPolicyListBuilderApi* | [**create_webex_prefix_lists1**](docs/ConfigurationPolicyListBuilderApi.md#create_webex_prefix_lists1) | **POST** /template/policy/list/webex/update | 
*ConfigurationPolicyListBuilderApi* | [**get_all_policy_lists**](docs/ConfigurationPolicyListBuilderApi.md#get_all_policy_lists) | **GET** /template/policy/list | 
*ConfigurationPolicyLocalDomainDefinitionBuilderApi* | [**create_policy_definition**](docs/ConfigurationPolicyLocalDomainDefinitionBuilderApi.md#create_policy_definition) | **POST** /template/policy/definition/dnssecurity | 
*ConfigurationPolicyLocalDomainDefinitionBuilderApi* | [**delete_policy_definition**](docs/ConfigurationPolicyLocalDomainDefinitionBuilderApi.md#delete_policy_definition) | **DELETE** /template/policy/definition/dnssecurity/{id} | 
*ConfigurationPolicyLocalDomainDefinitionBuilderApi* | [**edit_multiple_policy_definition**](docs/ConfigurationPolicyLocalDomainDefinitionBuilderApi.md#edit_multiple_policy_definition) | **PUT** /template/policy/definition/dnssecurity/multiple/{id} | 
*ConfigurationPolicyLocalDomainDefinitionBuilderApi* | [**edit_policy_definition**](docs/ConfigurationPolicyLocalDomainDefinitionBuilderApi.md#edit_policy_definition) | **PUT** /template/policy/definition/dnssecurity/{id} | 
*ConfigurationPolicyLocalDomainDefinitionBuilderApi* | [**get_definitions**](docs/ConfigurationPolicyLocalDomainDefinitionBuilderApi.md#get_definitions) | **GET** /template/policy/definition/dnssecurity | 
*ConfigurationPolicyLocalDomainDefinitionBuilderApi* | [**get_policy_definition**](docs/ConfigurationPolicyLocalDomainDefinitionBuilderApi.md#get_policy_definition) | **GET** /template/policy/definition/dnssecurity/{id} | 
*ConfigurationPolicyLocalDomainDefinitionBuilderApi* | [**preview_policy_definition**](docs/ConfigurationPolicyLocalDomainDefinitionBuilderApi.md#preview_policy_definition) | **POST** /template/policy/definition/dnssecurity/preview | 
*ConfigurationPolicyLocalDomainDefinitionBuilderApi* | [**preview_policy_definition_by_id**](docs/ConfigurationPolicyLocalDomainDefinitionBuilderApi.md#preview_policy_definition_by_id) | **GET** /template/policy/definition/dnssecurity/preview/{id} | 
*ConfigurationPolicyLocalDomainDefinitionBuilderApi* | [**save_policy_definition_in_bulk**](docs/ConfigurationPolicyLocalDomainDefinitionBuilderApi.md#save_policy_definition_in_bulk) | **PUT** /template/policy/definition/dnssecurity/bulk | 
*ConfigurationPolicyLocalDomainNameListBuilderApi* | [**create_policy_list22**](docs/ConfigurationPolicyLocalDomainNameListBuilderApi.md#create_policy_list22) | **POST** /template/policy/list/localdomain | 
*ConfigurationPolicyLocalDomainNameListBuilderApi* | [**delete_policy_list22**](docs/ConfigurationPolicyLocalDomainNameListBuilderApi.md#delete_policy_list22) | **DELETE** /template/policy/list/localdomain/{id} | 
*ConfigurationPolicyLocalDomainNameListBuilderApi* | [**delete_policy_lists_with_info_tag22**](docs/ConfigurationPolicyLocalDomainNameListBuilderApi.md#delete_policy_lists_with_info_tag22) | **DELETE** /template/policy/list/localdomain | 
*ConfigurationPolicyLocalDomainNameListBuilderApi* | [**edit_policy_list22**](docs/ConfigurationPolicyLocalDomainNameListBuilderApi.md#edit_policy_list22) | **PUT** /template/policy/list/localdomain/{id} | 
*ConfigurationPolicyLocalDomainNameListBuilderApi* | [**get_lists_by_id22**](docs/ConfigurationPolicyLocalDomainNameListBuilderApi.md#get_lists_by_id22) | **GET** /template/policy/list/localdomain/{id} | 
*ConfigurationPolicyLocalDomainNameListBuilderApi* | [**get_policy_lists19**](docs/ConfigurationPolicyLocalDomainNameListBuilderApi.md#get_policy_lists19) | **GET** /template/policy/list/localdomain | 
*ConfigurationPolicyLocalDomainNameListBuilderApi* | [**get_policy_lists_with_info_tag22**](docs/ConfigurationPolicyLocalDomainNameListBuilderApi.md#get_policy_lists_with_info_tag22) | **GET** /template/policy/list/localdomain/filtered | 
*ConfigurationPolicyLocalDomainNameListBuilderApi* | [**preview_policy_list22**](docs/ConfigurationPolicyLocalDomainNameListBuilderApi.md#preview_policy_list22) | **POST** /template/policy/list/localdomain/preview | 
*ConfigurationPolicyLocalDomainNameListBuilderApi* | [**preview_policy_list_by_id22**](docs/ConfigurationPolicyLocalDomainNameListBuilderApi.md#preview_policy_list_by_id22) | **GET** /template/policy/list/localdomain/preview/{id} | 
*ConfigurationPolicyMediaProfileListBuilderApi* | [**create_policy_list**](docs/ConfigurationPolicyMediaProfileListBuilderApi.md#create_policy_list) | **POST** /template/policy/list/mediaprofile | 
*ConfigurationPolicyMediaProfileListBuilderApi* | [**delete_policy_list**](docs/ConfigurationPolicyMediaProfileListBuilderApi.md#delete_policy_list) | **DELETE** /template/policy/list/mediaprofile/{id} | 
*ConfigurationPolicyMediaProfileListBuilderApi* | [**delete_policy_lists_with_info_tag**](docs/ConfigurationPolicyMediaProfileListBuilderApi.md#delete_policy_lists_with_info_tag) | **DELETE** /template/policy/list/mediaprofile | 
*ConfigurationPolicyMediaProfileListBuilderApi* | [**edit_policy_list**](docs/ConfigurationPolicyMediaProfileListBuilderApi.md#edit_policy_list) | **PUT** /template/policy/list/mediaprofile/{id} | 
*ConfigurationPolicyMediaProfileListBuilderApi* | [**get_lists_by_id**](docs/ConfigurationPolicyMediaProfileListBuilderApi.md#get_lists_by_id) | **GET** /template/policy/list/mediaprofile/{id} | 
*ConfigurationPolicyMediaProfileListBuilderApi* | [**get_policy_lists**](docs/ConfigurationPolicyMediaProfileListBuilderApi.md#get_policy_lists) | **GET** /template/policy/list/mediaprofile | 
*ConfigurationPolicyMediaProfileListBuilderApi* | [**get_policy_lists_with_info_tag**](docs/ConfigurationPolicyMediaProfileListBuilderApi.md#get_policy_lists_with_info_tag) | **GET** /template/policy/list/mediaprofile/filtered | 
*ConfigurationPolicyMediaProfileListBuilderApi* | [**preview_policy_list**](docs/ConfigurationPolicyMediaProfileListBuilderApi.md#preview_policy_list) | **POST** /template/policy/list/mediaprofile/preview | 
*ConfigurationPolicyMediaProfileListBuilderApi* | [**preview_policy_list_by_id**](docs/ConfigurationPolicyMediaProfileListBuilderApi.md#preview_policy_list_by_id) | **GET** /template/policy/list/mediaprofile/preview/{id} | 
*ConfigurationPolicyMeshDefinitionBuilderApi* | [**create_policy_definition5**](docs/ConfigurationPolicyMeshDefinitionBuilderApi.md#create_policy_definition5) | **POST** /template/policy/definition/mesh | 
*ConfigurationPolicyMeshDefinitionBuilderApi* | [**delete_policy_definition5**](docs/ConfigurationPolicyMeshDefinitionBuilderApi.md#delete_policy_definition5) | **DELETE** /template/policy/definition/mesh/{id} | 
*ConfigurationPolicyMeshDefinitionBuilderApi* | [**edit_multiple_policy_definition5**](docs/ConfigurationPolicyMeshDefinitionBuilderApi.md#edit_multiple_policy_definition5) | **PUT** /template/policy/definition/mesh/multiple/{id} | 
*ConfigurationPolicyMeshDefinitionBuilderApi* | [**edit_policy_definition5**](docs/ConfigurationPolicyMeshDefinitionBuilderApi.md#edit_policy_definition5) | **PUT** /template/policy/definition/mesh/{id} | 
*ConfigurationPolicyMeshDefinitionBuilderApi* | [**get_definitions5**](docs/ConfigurationPolicyMeshDefinitionBuilderApi.md#get_definitions5) | **GET** /template/policy/definition/mesh | 
*ConfigurationPolicyMeshDefinitionBuilderApi* | [**get_policy_definition5**](docs/ConfigurationPolicyMeshDefinitionBuilderApi.md#get_policy_definition5) | **GET** /template/policy/definition/mesh/{id} | 
*ConfigurationPolicyMeshDefinitionBuilderApi* | [**preview_policy_definition5**](docs/ConfigurationPolicyMeshDefinitionBuilderApi.md#preview_policy_definition5) | **POST** /template/policy/definition/mesh/preview | 
*ConfigurationPolicyMeshDefinitionBuilderApi* | [**preview_policy_definition_by_id5**](docs/ConfigurationPolicyMeshDefinitionBuilderApi.md#preview_policy_definition_by_id5) | **GET** /template/policy/definition/mesh/preview/{id} | 
*ConfigurationPolicyMeshDefinitionBuilderApi* | [**save_policy_definition_in_bulk5**](docs/ConfigurationPolicyMeshDefinitionBuilderApi.md#save_policy_definition_in_bulk5) | **PUT** /template/policy/definition/mesh/bulk | 
*ConfigurationPolicyMirrorBuilderApi* | [**create_policy_list23**](docs/ConfigurationPolicyMirrorBuilderApi.md#create_policy_list23) | **POST** /template/policy/list/mirror | 
*ConfigurationPolicyMirrorBuilderApi* | [**delete_policy_list23**](docs/ConfigurationPolicyMirrorBuilderApi.md#delete_policy_list23) | **DELETE** /template/policy/list/mirror/{id} | 
*ConfigurationPolicyMirrorBuilderApi* | [**delete_policy_lists_with_info_tag23**](docs/ConfigurationPolicyMirrorBuilderApi.md#delete_policy_lists_with_info_tag23) | **DELETE** /template/policy/list/mirror | 
*ConfigurationPolicyMirrorBuilderApi* | [**edit_policy_list23**](docs/ConfigurationPolicyMirrorBuilderApi.md#edit_policy_list23) | **PUT** /template/policy/list/mirror/{id} | 
*ConfigurationPolicyMirrorBuilderApi* | [**get_lists_by_id23**](docs/ConfigurationPolicyMirrorBuilderApi.md#get_lists_by_id23) | **GET** /template/policy/list/mirror/{id} | 
*ConfigurationPolicyMirrorBuilderApi* | [**get_policy_lists20**](docs/ConfigurationPolicyMirrorBuilderApi.md#get_policy_lists20) | **GET** /template/policy/list/mirror | 
*ConfigurationPolicyMirrorBuilderApi* | [**get_policy_lists_with_info_tag23**](docs/ConfigurationPolicyMirrorBuilderApi.md#get_policy_lists_with_info_tag23) | **GET** /template/policy/list/mirror/filtered | 
*ConfigurationPolicyMirrorBuilderApi* | [**preview_policy_list23**](docs/ConfigurationPolicyMirrorBuilderApi.md#preview_policy_list23) | **POST** /template/policy/list/mirror/preview | 
*ConfigurationPolicyMirrorBuilderApi* | [**preview_policy_list_by_id23**](docs/ConfigurationPolicyMirrorBuilderApi.md#preview_policy_list_by_id23) | **GET** /template/policy/list/mirror/preview/{id} | 
*ConfigurationPolicyModemPassthroughListBuilderApi* | [**create_policy_list24**](docs/ConfigurationPolicyModemPassthroughListBuilderApi.md#create_policy_list24) | **POST** /template/policy/list/modempassthrough | 
*ConfigurationPolicyModemPassthroughListBuilderApi* | [**delete_policy_list24**](docs/ConfigurationPolicyModemPassthroughListBuilderApi.md#delete_policy_list24) | **DELETE** /template/policy/list/modempassthrough/{id} | 
*ConfigurationPolicyModemPassthroughListBuilderApi* | [**delete_policy_lists_with_info_tag24**](docs/ConfigurationPolicyModemPassthroughListBuilderApi.md#delete_policy_lists_with_info_tag24) | **DELETE** /template/policy/list/modempassthrough | 
*ConfigurationPolicyModemPassthroughListBuilderApi* | [**edit_policy_list24**](docs/ConfigurationPolicyModemPassthroughListBuilderApi.md#edit_policy_list24) | **PUT** /template/policy/list/modempassthrough/{id} | 
*ConfigurationPolicyModemPassthroughListBuilderApi* | [**get_lists_by_id24**](docs/ConfigurationPolicyModemPassthroughListBuilderApi.md#get_lists_by_id24) | **GET** /template/policy/list/modempassthrough/{id} | 
*ConfigurationPolicyModemPassthroughListBuilderApi* | [**get_policy_lists21**](docs/ConfigurationPolicyModemPassthroughListBuilderApi.md#get_policy_lists21) | **GET** /template/policy/list/modempassthrough | 
*ConfigurationPolicyModemPassthroughListBuilderApi* | [**get_policy_lists_with_info_tag24**](docs/ConfigurationPolicyModemPassthroughListBuilderApi.md#get_policy_lists_with_info_tag24) | **GET** /template/policy/list/modempassthrough/filtered | 
*ConfigurationPolicyModemPassthroughListBuilderApi* | [**preview_policy_list24**](docs/ConfigurationPolicyModemPassthroughListBuilderApi.md#preview_policy_list24) | **POST** /template/policy/list/modempassthrough/preview | 
*ConfigurationPolicyModemPassthroughListBuilderApi* | [**preview_policy_list_by_id24**](docs/ConfigurationPolicyModemPassthroughListBuilderApi.md#preview_policy_list_by_id24) | **GET** /template/policy/list/modempassthrough/preview/{id} | 
*ConfigurationPolicyPRIISDNPortDefinitionBuilderApi* | [**create_policy_definition29**](docs/ConfigurationPolicyPRIISDNPortDefinitionBuilderApi.md#create_policy_definition29) | **POST** /template/policy/definition/priisdnport | 
*ConfigurationPolicyPRIISDNPortDefinitionBuilderApi* | [**delete_policy_definition29**](docs/ConfigurationPolicyPRIISDNPortDefinitionBuilderApi.md#delete_policy_definition29) | **DELETE** /template/policy/definition/priisdnport/{id} | 
*ConfigurationPolicyPRIISDNPortDefinitionBuilderApi* | [**edit_multiple_policy_definition29**](docs/ConfigurationPolicyPRIISDNPortDefinitionBuilderApi.md#edit_multiple_policy_definition29) | **PUT** /template/policy/definition/priisdnport/multiple/{id} | 
*ConfigurationPolicyPRIISDNPortDefinitionBuilderApi* | [**edit_policy_definition29**](docs/ConfigurationPolicyPRIISDNPortDefinitionBuilderApi.md#edit_policy_definition29) | **PUT** /template/policy/definition/priisdnport/{id} | 
*ConfigurationPolicyPRIISDNPortDefinitionBuilderApi* | [**get_definitions29**](docs/ConfigurationPolicyPRIISDNPortDefinitionBuilderApi.md#get_definitions29) | **GET** /template/policy/definition/priisdnport | 
*ConfigurationPolicyPRIISDNPortDefinitionBuilderApi* | [**get_policy_definition29**](docs/ConfigurationPolicyPRIISDNPortDefinitionBuilderApi.md#get_policy_definition29) | **GET** /template/policy/definition/priisdnport/{id} | 
*ConfigurationPolicyPRIISDNPortDefinitionBuilderApi* | [**preview_policy_definition29**](docs/ConfigurationPolicyPRIISDNPortDefinitionBuilderApi.md#preview_policy_definition29) | **POST** /template/policy/definition/priisdnport/preview | 
*ConfigurationPolicyPRIISDNPortDefinitionBuilderApi* | [**preview_policy_definition_by_id29**](docs/ConfigurationPolicyPRIISDNPortDefinitionBuilderApi.md#preview_policy_definition_by_id29) | **GET** /template/policy/definition/priisdnport/preview/{id} | 
*ConfigurationPolicyPRIISDNPortDefinitionBuilderApi* | [**save_policy_definition_in_bulk29**](docs/ConfigurationPolicyPRIISDNPortDefinitionBuilderApi.md#save_policy_definition_in_bulk29) | **PUT** /template/policy/definition/priisdnport/bulk | 
*ConfigurationPolicyPolicerClassBuilderApi* | [**create_policy_list25**](docs/ConfigurationPolicyPolicerClassBuilderApi.md#create_policy_list25) | **POST** /template/policy/list/policer | 
*ConfigurationPolicyPolicerClassBuilderApi* | [**delete_policy_list25**](docs/ConfigurationPolicyPolicerClassBuilderApi.md#delete_policy_list25) | **DELETE** /template/policy/list/policer/{id} | 
*ConfigurationPolicyPolicerClassBuilderApi* | [**delete_policy_lists_with_info_tag25**](docs/ConfigurationPolicyPolicerClassBuilderApi.md#delete_policy_lists_with_info_tag25) | **DELETE** /template/policy/list/policer | 
*ConfigurationPolicyPolicerClassBuilderApi* | [**edit_policy_list25**](docs/ConfigurationPolicyPolicerClassBuilderApi.md#edit_policy_list25) | **PUT** /template/policy/list/policer/{id} | 
*ConfigurationPolicyPolicerClassBuilderApi* | [**get_lists_by_id25**](docs/ConfigurationPolicyPolicerClassBuilderApi.md#get_lists_by_id25) | **GET** /template/policy/list/policer/{id} | 
*ConfigurationPolicyPolicerClassBuilderApi* | [**get_policy_lists22**](docs/ConfigurationPolicyPolicerClassBuilderApi.md#get_policy_lists22) | **GET** /template/policy/list/policer | 
*ConfigurationPolicyPolicerClassBuilderApi* | [**get_policy_lists_with_info_tag25**](docs/ConfigurationPolicyPolicerClassBuilderApi.md#get_policy_lists_with_info_tag25) | **GET** /template/policy/list/policer/filtered | 
*ConfigurationPolicyPolicerClassBuilderApi* | [**preview_policy_list25**](docs/ConfigurationPolicyPolicerClassBuilderApi.md#preview_policy_list25) | **POST** /template/policy/list/policer/preview | 
*ConfigurationPolicyPolicerClassBuilderApi* | [**preview_policy_list_by_id25**](docs/ConfigurationPolicyPolicerClassBuilderApi.md#preview_policy_list_by_id25) | **GET** /template/policy/list/policer/preview/{id} | 
*ConfigurationPolicyPortListBuilderApi* | [**create_policy_list26**](docs/ConfigurationPolicyPortListBuilderApi.md#create_policy_list26) | **POST** /template/policy/list/port | 
*ConfigurationPolicyPortListBuilderApi* | [**delete_policy_list26**](docs/ConfigurationPolicyPortListBuilderApi.md#delete_policy_list26) | **DELETE** /template/policy/list/port/{id} | 
*ConfigurationPolicyPortListBuilderApi* | [**delete_policy_lists_with_info_tag26**](docs/ConfigurationPolicyPortListBuilderApi.md#delete_policy_lists_with_info_tag26) | **DELETE** /template/policy/list/port | 
*ConfigurationPolicyPortListBuilderApi* | [**edit_policy_list26**](docs/ConfigurationPolicyPortListBuilderApi.md#edit_policy_list26) | **PUT** /template/policy/list/port/{id} | 
*ConfigurationPolicyPortListBuilderApi* | [**get_lists_by_id26**](docs/ConfigurationPolicyPortListBuilderApi.md#get_lists_by_id26) | **GET** /template/policy/list/port/{id} | 
*ConfigurationPolicyPortListBuilderApi* | [**get_policy_lists23**](docs/ConfigurationPolicyPortListBuilderApi.md#get_policy_lists23) | **GET** /template/policy/list/port | 
*ConfigurationPolicyPortListBuilderApi* | [**get_policy_lists_with_info_tag26**](docs/ConfigurationPolicyPortListBuilderApi.md#get_policy_lists_with_info_tag26) | **GET** /template/policy/list/port/filtered | 
*ConfigurationPolicyPortListBuilderApi* | [**preview_policy_list26**](docs/ConfigurationPolicyPortListBuilderApi.md#preview_policy_list26) | **POST** /template/policy/list/port/preview | 
*ConfigurationPolicyPortListBuilderApi* | [**preview_policy_list_by_id26**](docs/ConfigurationPolicyPortListBuilderApi.md#preview_policy_list_by_id26) | **GET** /template/policy/list/port/preview/{id} | 
*ConfigurationPolicyPrefixListBuilderApi* | [**create_policy_list27**](docs/ConfigurationPolicyPrefixListBuilderApi.md#create_policy_list27) | **POST** /template/policy/list/prefix | 
*ConfigurationPolicyPrefixListBuilderApi* | [**delete_policy_list27**](docs/ConfigurationPolicyPrefixListBuilderApi.md#delete_policy_list27) | **DELETE** /template/policy/list/prefix/{id} | 
*ConfigurationPolicyPrefixListBuilderApi* | [**delete_policy_lists_with_info_tag27**](docs/ConfigurationPolicyPrefixListBuilderApi.md#delete_policy_lists_with_info_tag27) | **DELETE** /template/policy/list/prefix | 
*ConfigurationPolicyPrefixListBuilderApi* | [**edit_policy_list27**](docs/ConfigurationPolicyPrefixListBuilderApi.md#edit_policy_list27) | **PUT** /template/policy/list/prefix/{id} | 
*ConfigurationPolicyPrefixListBuilderApi* | [**get_lists_by_id27**](docs/ConfigurationPolicyPrefixListBuilderApi.md#get_lists_by_id27) | **GET** /template/policy/list/prefix/{id} | 
*ConfigurationPolicyPrefixListBuilderApi* | [**get_policy_lists24**](docs/ConfigurationPolicyPrefixListBuilderApi.md#get_policy_lists24) | **GET** /template/policy/list/prefix | 
*ConfigurationPolicyPrefixListBuilderApi* | [**get_policy_lists_with_info_tag27**](docs/ConfigurationPolicyPrefixListBuilderApi.md#get_policy_lists_with_info_tag27) | **GET** /template/policy/list/prefix/filtered | 
*ConfigurationPolicyPrefixListBuilderApi* | [**preview_policy_list27**](docs/ConfigurationPolicyPrefixListBuilderApi.md#preview_policy_list27) | **POST** /template/policy/list/prefix/preview | 
*ConfigurationPolicyPrefixListBuilderApi* | [**preview_policy_list_by_id27**](docs/ConfigurationPolicyPrefixListBuilderApi.md#preview_policy_list_by_id27) | **GET** /template/policy/list/prefix/preview/{id} | 
*ConfigurationPolicyPrefixForAllTypesOfListsBuilderApi* | [**create_policy_list20**](docs/ConfigurationPolicyPrefixForAllTypesOfListsBuilderApi.md#create_policy_list20) | **POST** /template/policy/list/ipprefixall | 
*ConfigurationPolicyPrefixForAllTypesOfListsBuilderApi* | [**delete_policy_list20**](docs/ConfigurationPolicyPrefixForAllTypesOfListsBuilderApi.md#delete_policy_list20) | **DELETE** /template/policy/list/ipprefixall/{id} | 
*ConfigurationPolicyPrefixForAllTypesOfListsBuilderApi* | [**delete_policy_lists_with_info_tag20**](docs/ConfigurationPolicyPrefixForAllTypesOfListsBuilderApi.md#delete_policy_lists_with_info_tag20) | **DELETE** /template/policy/list/ipprefixall | 
*ConfigurationPolicyPrefixForAllTypesOfListsBuilderApi* | [**edit_policy_list20**](docs/ConfigurationPolicyPrefixForAllTypesOfListsBuilderApi.md#edit_policy_list20) | **PUT** /template/policy/list/ipprefixall/{id} | 
*ConfigurationPolicyPrefixForAllTypesOfListsBuilderApi* | [**get_lists_by_id20**](docs/ConfigurationPolicyPrefixForAllTypesOfListsBuilderApi.md#get_lists_by_id20) | **GET** /template/policy/list/ipprefixall/{id} | 
*ConfigurationPolicyPrefixForAllTypesOfListsBuilderApi* | [**get_lists_for_all_prefixes**](docs/ConfigurationPolicyPrefixForAllTypesOfListsBuilderApi.md#get_lists_for_all_prefixes) | **GET** /template/policy/list/ipprefixall | 
*ConfigurationPolicyPrefixForAllTypesOfListsBuilderApi* | [**get_policy_lists_with_info_tag20**](docs/ConfigurationPolicyPrefixForAllTypesOfListsBuilderApi.md#get_policy_lists_with_info_tag20) | **GET** /template/policy/list/ipprefixall/filtered | 
*ConfigurationPolicyPrefixForAllTypesOfListsBuilderApi* | [**preview_policy_list20**](docs/ConfigurationPolicyPrefixForAllTypesOfListsBuilderApi.md#preview_policy_list20) | **POST** /template/policy/list/ipprefixall/preview | 
*ConfigurationPolicyPrefixForAllTypesOfListsBuilderApi* | [**preview_policy_list_by_id20**](docs/ConfigurationPolicyPrefixForAllTypesOfListsBuilderApi.md#preview_policy_list_by_id20) | **GET** /template/policy/list/ipprefixall/preview/{id} | 
*ConfigurationPolicyProtocolNameListBuilderApi* | [**create_policy_list28**](docs/ConfigurationPolicyProtocolNameListBuilderApi.md#create_policy_list28) | **POST** /template/policy/list/protocolname | 
*ConfigurationPolicyProtocolNameListBuilderApi* | [**delete_policy_list28**](docs/ConfigurationPolicyProtocolNameListBuilderApi.md#delete_policy_list28) | **DELETE** /template/policy/list/protocolname/{id} | 
*ConfigurationPolicyProtocolNameListBuilderApi* | [**delete_policy_lists_with_info_tag28**](docs/ConfigurationPolicyProtocolNameListBuilderApi.md#delete_policy_lists_with_info_tag28) | **DELETE** /template/policy/list/protocolname | 
*ConfigurationPolicyProtocolNameListBuilderApi* | [**edit_policy_list28**](docs/ConfigurationPolicyProtocolNameListBuilderApi.md#edit_policy_list28) | **PUT** /template/policy/list/protocolname/{id} | 
*ConfigurationPolicyProtocolNameListBuilderApi* | [**get_lists_by_id28**](docs/ConfigurationPolicyProtocolNameListBuilderApi.md#get_lists_by_id28) | **GET** /template/policy/list/protocolname/{id} | 
*ConfigurationPolicyProtocolNameListBuilderApi* | [**get_policy_lists25**](docs/ConfigurationPolicyProtocolNameListBuilderApi.md#get_policy_lists25) | **GET** /template/policy/list/protocolname | 
*ConfigurationPolicyProtocolNameListBuilderApi* | [**get_policy_lists_with_info_tag28**](docs/ConfigurationPolicyProtocolNameListBuilderApi.md#get_policy_lists_with_info_tag28) | **GET** /template/policy/list/protocolname/filtered | 
*ConfigurationPolicyProtocolNameListBuilderApi* | [**preview_policy_list28**](docs/ConfigurationPolicyProtocolNameListBuilderApi.md#preview_policy_list28) | **POST** /template/policy/list/protocolname/preview | 
*ConfigurationPolicyProtocolNameListBuilderApi* | [**preview_policy_list_by_id28**](docs/ConfigurationPolicyProtocolNameListBuilderApi.md#preview_policy_list_by_id28) | **GET** /template/policy/list/protocolname/preview/{id} | 
*ConfigurationPolicyQosMapDefinitionBuilderApi* | [**create_policy_definition1**](docs/ConfigurationPolicyQosMapDefinitionBuilderApi.md#create_policy_definition1) | **POST** /template/policy/definition/qosmap | 
*ConfigurationPolicyQosMapDefinitionBuilderApi* | [**delete_policy_definition1**](docs/ConfigurationPolicyQosMapDefinitionBuilderApi.md#delete_policy_definition1) | **DELETE** /template/policy/definition/qosmap/{id} | 
*ConfigurationPolicyQosMapDefinitionBuilderApi* | [**edit_multiple_policy_definition1**](docs/ConfigurationPolicyQosMapDefinitionBuilderApi.md#edit_multiple_policy_definition1) | **PUT** /template/policy/definition/qosmap/multiple/{id} | 
*ConfigurationPolicyQosMapDefinitionBuilderApi* | [**edit_policy_definition1**](docs/ConfigurationPolicyQosMapDefinitionBuilderApi.md#edit_policy_definition1) | **PUT** /template/policy/definition/qosmap/{id} | 
*ConfigurationPolicyQosMapDefinitionBuilderApi* | [**get_definitions1**](docs/ConfigurationPolicyQosMapDefinitionBuilderApi.md#get_definitions1) | **GET** /template/policy/definition/qosmap | 
*ConfigurationPolicyQosMapDefinitionBuilderApi* | [**get_policy_definition1**](docs/ConfigurationPolicyQosMapDefinitionBuilderApi.md#get_policy_definition1) | **GET** /template/policy/definition/qosmap/{id} | 
*ConfigurationPolicyQosMapDefinitionBuilderApi* | [**preview_policy_definition1**](docs/ConfigurationPolicyQosMapDefinitionBuilderApi.md#preview_policy_definition1) | **POST** /template/policy/definition/qosmap/preview | 
*ConfigurationPolicyQosMapDefinitionBuilderApi* | [**preview_policy_definition_by_id1**](docs/ConfigurationPolicyQosMapDefinitionBuilderApi.md#preview_policy_definition_by_id1) | **GET** /template/policy/definition/qosmap/preview/{id} | 
*ConfigurationPolicyQosMapDefinitionBuilderApi* | [**save_policy_definition_in_bulk1**](docs/ConfigurationPolicyQosMapDefinitionBuilderApi.md#save_policy_definition_in_bulk1) | **PUT** /template/policy/definition/qosmap/bulk | 
*ConfigurationPolicyRegionListBuilderApi* | [**create_policy_list29**](docs/ConfigurationPolicyRegionListBuilderApi.md#create_policy_list29) | **POST** /template/policy/list/region | 
*ConfigurationPolicyRegionListBuilderApi* | [**delete_policy_list29**](docs/ConfigurationPolicyRegionListBuilderApi.md#delete_policy_list29) | **DELETE** /template/policy/list/region/{id} | 
*ConfigurationPolicyRegionListBuilderApi* | [**delete_policy_lists_with_info_tag29**](docs/ConfigurationPolicyRegionListBuilderApi.md#delete_policy_lists_with_info_tag29) | **DELETE** /template/policy/list/region | 
*ConfigurationPolicyRegionListBuilderApi* | [**edit_policy_list29**](docs/ConfigurationPolicyRegionListBuilderApi.md#edit_policy_list29) | **PUT** /template/policy/list/region/{id} | 
*ConfigurationPolicyRegionListBuilderApi* | [**get_lists_by_id29**](docs/ConfigurationPolicyRegionListBuilderApi.md#get_lists_by_id29) | **GET** /template/policy/list/region/{id} | 
*ConfigurationPolicyRegionListBuilderApi* | [**get_policy_lists26**](docs/ConfigurationPolicyRegionListBuilderApi.md#get_policy_lists26) | **GET** /template/policy/list/region | 
*ConfigurationPolicyRegionListBuilderApi* | [**get_policy_lists_with_info_tag29**](docs/ConfigurationPolicyRegionListBuilderApi.md#get_policy_lists_with_info_tag29) | **GET** /template/policy/list/region/filtered | 
*ConfigurationPolicyRegionListBuilderApi* | [**preview_policy_list29**](docs/ConfigurationPolicyRegionListBuilderApi.md#preview_policy_list29) | **POST** /template/policy/list/region/preview | 
*ConfigurationPolicyRegionListBuilderApi* | [**preview_policy_list_by_id29**](docs/ConfigurationPolicyRegionListBuilderApi.md#preview_policy_list_by_id29) | **GET** /template/policy/list/region/preview/{id} | 
*ConfigurationPolicyRewriteRuleDefinitionBuilderApi* | [**create_policy_definition19**](docs/ConfigurationPolicyRewriteRuleDefinitionBuilderApi.md#create_policy_definition19) | **POST** /template/policy/definition/rewriterule | 
*ConfigurationPolicyRewriteRuleDefinitionBuilderApi* | [**delete_policy_definition19**](docs/ConfigurationPolicyRewriteRuleDefinitionBuilderApi.md#delete_policy_definition19) | **DELETE** /template/policy/definition/rewriterule/{id} | 
*ConfigurationPolicyRewriteRuleDefinitionBuilderApi* | [**edit_multiple_policy_definition19**](docs/ConfigurationPolicyRewriteRuleDefinitionBuilderApi.md#edit_multiple_policy_definition19) | **PUT** /template/policy/definition/rewriterule/multiple/{id} | 
*ConfigurationPolicyRewriteRuleDefinitionBuilderApi* | [**edit_policy_definition19**](docs/ConfigurationPolicyRewriteRuleDefinitionBuilderApi.md#edit_policy_definition19) | **PUT** /template/policy/definition/rewriterule/{id} | 
*ConfigurationPolicyRewriteRuleDefinitionBuilderApi* | [**get_definitions19**](docs/ConfigurationPolicyRewriteRuleDefinitionBuilderApi.md#get_definitions19) | **GET** /template/policy/definition/rewriterule | 
*ConfigurationPolicyRewriteRuleDefinitionBuilderApi* | [**get_policy_definition19**](docs/ConfigurationPolicyRewriteRuleDefinitionBuilderApi.md#get_policy_definition19) | **GET** /template/policy/definition/rewriterule/{id} | 
*ConfigurationPolicyRewriteRuleDefinitionBuilderApi* | [**preview_policy_definition19**](docs/ConfigurationPolicyRewriteRuleDefinitionBuilderApi.md#preview_policy_definition19) | **POST** /template/policy/definition/rewriterule/preview | 
*ConfigurationPolicyRewriteRuleDefinitionBuilderApi* | [**preview_policy_definition_by_id19**](docs/ConfigurationPolicyRewriteRuleDefinitionBuilderApi.md#preview_policy_definition_by_id19) | **GET** /template/policy/definition/rewriterule/preview/{id} | 
*ConfigurationPolicyRewriteRuleDefinitionBuilderApi* | [**save_policy_definition_in_bulk19**](docs/ConfigurationPolicyRewriteRuleDefinitionBuilderApi.md#save_policy_definition_in_bulk19) | **PUT** /template/policy/definition/rewriterule/bulk | 
*ConfigurationPolicySLAClassBuilderApi* | [**create_policy_list31**](docs/ConfigurationPolicySLAClassBuilderApi.md#create_policy_list31) | **POST** /template/policy/list/sla | 
*ConfigurationPolicySLAClassBuilderApi* | [**delete_policy_list31**](docs/ConfigurationPolicySLAClassBuilderApi.md#delete_policy_list31) | **DELETE** /template/policy/list/sla/{id} | 
*ConfigurationPolicySLAClassBuilderApi* | [**delete_policy_lists_with_info_tag31**](docs/ConfigurationPolicySLAClassBuilderApi.md#delete_policy_lists_with_info_tag31) | **DELETE** /template/policy/list/sla | 
*ConfigurationPolicySLAClassBuilderApi* | [**edit_policy_list31**](docs/ConfigurationPolicySLAClassBuilderApi.md#edit_policy_list31) | **PUT** /template/policy/list/sla/{id} | 
*ConfigurationPolicySLAClassBuilderApi* | [**get_lists_by_id31**](docs/ConfigurationPolicySLAClassBuilderApi.md#get_lists_by_id31) | **GET** /template/policy/list/sla/{id} | 
*ConfigurationPolicySLAClassBuilderApi* | [**get_policy_lists28**](docs/ConfigurationPolicySLAClassBuilderApi.md#get_policy_lists28) | **GET** /template/policy/list/sla | 
*ConfigurationPolicySLAClassBuilderApi* | [**get_policy_lists_with_info_tag31**](docs/ConfigurationPolicySLAClassBuilderApi.md#get_policy_lists_with_info_tag31) | **GET** /template/policy/list/sla/filtered | 
*ConfigurationPolicySLAClassBuilderApi* | [**preview_policy_list31**](docs/ConfigurationPolicySLAClassBuilderApi.md#preview_policy_list31) | **POST** /template/policy/list/sla/preview | 
*ConfigurationPolicySLAClassBuilderApi* | [**preview_policy_list_by_id31**](docs/ConfigurationPolicySLAClassBuilderApi.md#preview_policy_list_by_id31) | **GET** /template/policy/list/sla/preview/{id} | 
*ConfigurationPolicySecureInternetGatewayDataCentersBuilderApi* | [**get_sig_data_center_list**](docs/ConfigurationPolicySecureInternetGatewayDataCentersBuilderApi.md#get_sig_data_center_list) | **GET** /sig/datacenters/{type} | 
*ConfigurationPolicySecurityAssemblerApi* | [**preview**](docs/ConfigurationPolicySecurityAssemblerApi.md#preview) | **POST** /template/policy/assembly/security | 
*ConfigurationPolicySecurityAssemblerApi* | [**preview_by_id**](docs/ConfigurationPolicySecurityAssemblerApi.md#preview_by_id) | **GET** /template/policy/assembly/security/{id} | 
*ConfigurationPolicySiteListBuilderApi* | [**create_default_site_list**](docs/ConfigurationPolicySiteListBuilderApi.md#create_default_site_list) | **POST** /template/policy/list/site/defaultsite | 
*ConfigurationPolicySiteListBuilderApi* | [**create_policy_list30**](docs/ConfigurationPolicySiteListBuilderApi.md#create_policy_list30) | **POST** /template/policy/list/site | 
*ConfigurationPolicySiteListBuilderApi* | [**delete_policy_list30**](docs/ConfigurationPolicySiteListBuilderApi.md#delete_policy_list30) | **DELETE** /template/policy/list/site/{id} | 
*ConfigurationPolicySiteListBuilderApi* | [**delete_policy_lists_with_info_tag30**](docs/ConfigurationPolicySiteListBuilderApi.md#delete_policy_lists_with_info_tag30) | **DELETE** /template/policy/list/site | 
*ConfigurationPolicySiteListBuilderApi* | [**edit_policy_list30**](docs/ConfigurationPolicySiteListBuilderApi.md#edit_policy_list30) | **PUT** /template/policy/list/site/{id} | 
*ConfigurationPolicySiteListBuilderApi* | [**get_lists_by_id30**](docs/ConfigurationPolicySiteListBuilderApi.md#get_lists_by_id30) | **GET** /template/policy/list/site/{id} | 
*ConfigurationPolicySiteListBuilderApi* | [**get_policy_lists27**](docs/ConfigurationPolicySiteListBuilderApi.md#get_policy_lists27) | **GET** /template/policy/list/site | 
*ConfigurationPolicySiteListBuilderApi* | [**get_policy_lists_with_info_tag30**](docs/ConfigurationPolicySiteListBuilderApi.md#get_policy_lists_with_info_tag30) | **GET** /template/policy/list/site/filtered | 
*ConfigurationPolicySiteListBuilderApi* | [**preview_policy_list30**](docs/ConfigurationPolicySiteListBuilderApi.md#preview_policy_list30) | **POST** /template/policy/list/site/preview | 
*ConfigurationPolicySiteListBuilderApi* | [**preview_policy_list_by_id30**](docs/ConfigurationPolicySiteListBuilderApi.md#preview_policy_list_by_id30) | **GET** /template/policy/list/site/preview/{id} | 
*ConfigurationPolicySupervisoryDiscListBuilderApi* | [**create_policy_list32**](docs/ConfigurationPolicySupervisoryDiscListBuilderApi.md#create_policy_list32) | **POST** /template/policy/list/supervisorydisc | 
*ConfigurationPolicySupervisoryDiscListBuilderApi* | [**delete_policy_list32**](docs/ConfigurationPolicySupervisoryDiscListBuilderApi.md#delete_policy_list32) | **DELETE** /template/policy/list/supervisorydisc/{id} | 
*ConfigurationPolicySupervisoryDiscListBuilderApi* | [**delete_policy_lists_with_info_tag32**](docs/ConfigurationPolicySupervisoryDiscListBuilderApi.md#delete_policy_lists_with_info_tag32) | **DELETE** /template/policy/list/supervisorydisc | 
*ConfigurationPolicySupervisoryDiscListBuilderApi* | [**edit_policy_list32**](docs/ConfigurationPolicySupervisoryDiscListBuilderApi.md#edit_policy_list32) | **PUT** /template/policy/list/supervisorydisc/{id} | 
*ConfigurationPolicySupervisoryDiscListBuilderApi* | [**get_lists_by_id32**](docs/ConfigurationPolicySupervisoryDiscListBuilderApi.md#get_lists_by_id32) | **GET** /template/policy/list/supervisorydisc/{id} | 
*ConfigurationPolicySupervisoryDiscListBuilderApi* | [**get_policy_lists29**](docs/ConfigurationPolicySupervisoryDiscListBuilderApi.md#get_policy_lists29) | **GET** /template/policy/list/supervisorydisc | 
*ConfigurationPolicySupervisoryDiscListBuilderApi* | [**get_policy_lists_with_info_tag32**](docs/ConfigurationPolicySupervisoryDiscListBuilderApi.md#get_policy_lists_with_info_tag32) | **GET** /template/policy/list/supervisorydisc/filtered | 
*ConfigurationPolicySupervisoryDiscListBuilderApi* | [**preview_policy_list32**](docs/ConfigurationPolicySupervisoryDiscListBuilderApi.md#preview_policy_list32) | **POST** /template/policy/list/supervisorydisc/preview | 
*ConfigurationPolicySupervisoryDiscListBuilderApi* | [**preview_policy_list_by_id32**](docs/ConfigurationPolicySupervisoryDiscListBuilderApi.md#preview_policy_list_by_id32) | **GET** /template/policy/list/supervisorydisc/preview/{id} | 
*ConfigurationPolicyTLOCListBuilderApi* | [**create_policy_list34**](docs/ConfigurationPolicyTLOCListBuilderApi.md#create_policy_list34) | **POST** /template/policy/list/tloc | 
*ConfigurationPolicyTLOCListBuilderApi* | [**delete_policy_list34**](docs/ConfigurationPolicyTLOCListBuilderApi.md#delete_policy_list34) | **DELETE** /template/policy/list/tloc/{id} | 
*ConfigurationPolicyTLOCListBuilderApi* | [**delete_policy_lists_with_info_tag34**](docs/ConfigurationPolicyTLOCListBuilderApi.md#delete_policy_lists_with_info_tag34) | **DELETE** /template/policy/list/tloc | 
*ConfigurationPolicyTLOCListBuilderApi* | [**edit_policy_list34**](docs/ConfigurationPolicyTLOCListBuilderApi.md#edit_policy_list34) | **PUT** /template/policy/list/tloc/{id} | 
*ConfigurationPolicyTLOCListBuilderApi* | [**get_lists_by_id34**](docs/ConfigurationPolicyTLOCListBuilderApi.md#get_lists_by_id34) | **GET** /template/policy/list/tloc/{id} | 
*ConfigurationPolicyTLOCListBuilderApi* | [**get_policy_lists31**](docs/ConfigurationPolicyTLOCListBuilderApi.md#get_policy_lists31) | **GET** /template/policy/list/tloc | 
*ConfigurationPolicyTLOCListBuilderApi* | [**get_policy_lists_with_info_tag34**](docs/ConfigurationPolicyTLOCListBuilderApi.md#get_policy_lists_with_info_tag34) | **GET** /template/policy/list/tloc/filtered | 
*ConfigurationPolicyTLOCListBuilderApi* | [**preview_policy_list34**](docs/ConfigurationPolicyTLOCListBuilderApi.md#preview_policy_list34) | **POST** /template/policy/list/tloc/preview | 
*ConfigurationPolicyTLOCListBuilderApi* | [**preview_policy_list_by_id34**](docs/ConfigurationPolicyTLOCListBuilderApi.md#preview_policy_list_by_id34) | **GET** /template/policy/list/tloc/preview/{id} | 
*ConfigurationPolicyThreatGridApiKeyApi* | [**create_policy_list33**](docs/ConfigurationPolicyThreatGridApiKeyApi.md#create_policy_list33) | **POST** /template/policy/list/tgapikey | 
*ConfigurationPolicyThreatGridApiKeyApi* | [**delete_policy_list33**](docs/ConfigurationPolicyThreatGridApiKeyApi.md#delete_policy_list33) | **DELETE** /template/policy/list/tgapikey/{id} | 
*ConfigurationPolicyThreatGridApiKeyApi* | [**delete_policy_lists_with_info_tag33**](docs/ConfigurationPolicyThreatGridApiKeyApi.md#delete_policy_lists_with_info_tag33) | **DELETE** /template/policy/list/tgapikey | 
*ConfigurationPolicyThreatGridApiKeyApi* | [**edit_policy_list33**](docs/ConfigurationPolicyThreatGridApiKeyApi.md#edit_policy_list33) | **PUT** /template/policy/list/tgapikey/{id} | 
*ConfigurationPolicyThreatGridApiKeyApi* | [**get_lists_by_id33**](docs/ConfigurationPolicyThreatGridApiKeyApi.md#get_lists_by_id33) | **GET** /template/policy/list/tgapikey/{id} | 
*ConfigurationPolicyThreatGridApiKeyApi* | [**get_policy_lists30**](docs/ConfigurationPolicyThreatGridApiKeyApi.md#get_policy_lists30) | **GET** /template/policy/list/tgapikey | 
*ConfigurationPolicyThreatGridApiKeyApi* | [**get_policy_lists_with_info_tag33**](docs/ConfigurationPolicyThreatGridApiKeyApi.md#get_policy_lists_with_info_tag33) | **GET** /template/policy/list/tgapikey/filtered | 
*ConfigurationPolicyThreatGridApiKeyApi* | [**preview_policy_list33**](docs/ConfigurationPolicyThreatGridApiKeyApi.md#preview_policy_list33) | **POST** /template/policy/list/tgapikey/preview | 
*ConfigurationPolicyThreatGridApiKeyApi* | [**preview_policy_list_by_id33**](docs/ConfigurationPolicyThreatGridApiKeyApi.md#preview_policy_list_by_id33) | **GET** /template/policy/list/tgapikey/preview/{id} | 
*ConfigurationPolicyTranslationProfileListBuilderApi* | [**create_policy_list1**](docs/ConfigurationPolicyTranslationProfileListBuilderApi.md#create_policy_list1) | **POST** /template/policy/list/translationprofile | 
*ConfigurationPolicyTranslationProfileListBuilderApi* | [**delete_policy_list1**](docs/ConfigurationPolicyTranslationProfileListBuilderApi.md#delete_policy_list1) | **DELETE** /template/policy/list/translationprofile/{id} | 
*ConfigurationPolicyTranslationProfileListBuilderApi* | [**delete_policy_lists_with_info_tag1**](docs/ConfigurationPolicyTranslationProfileListBuilderApi.md#delete_policy_lists_with_info_tag1) | **DELETE** /template/policy/list/translationprofile | 
*ConfigurationPolicyTranslationProfileListBuilderApi* | [**edit_policy_list1**](docs/ConfigurationPolicyTranslationProfileListBuilderApi.md#edit_policy_list1) | **PUT** /template/policy/list/translationprofile/{id} | 
*ConfigurationPolicyTranslationProfileListBuilderApi* | [**get_lists_by_id1**](docs/ConfigurationPolicyTranslationProfileListBuilderApi.md#get_lists_by_id1) | **GET** /template/policy/list/translationprofile/{id} | 
*ConfigurationPolicyTranslationProfileListBuilderApi* | [**get_policy_lists1**](docs/ConfigurationPolicyTranslationProfileListBuilderApi.md#get_policy_lists1) | **GET** /template/policy/list/translationprofile | 
*ConfigurationPolicyTranslationProfileListBuilderApi* | [**get_policy_lists_with_info_tag1**](docs/ConfigurationPolicyTranslationProfileListBuilderApi.md#get_policy_lists_with_info_tag1) | **GET** /template/policy/list/translationprofile/filtered | 
*ConfigurationPolicyTranslationProfileListBuilderApi* | [**preview_policy_list1**](docs/ConfigurationPolicyTranslationProfileListBuilderApi.md#preview_policy_list1) | **POST** /template/policy/list/translationprofile/preview | 
*ConfigurationPolicyTranslationProfileListBuilderApi* | [**preview_policy_list_by_id1**](docs/ConfigurationPolicyTranslationProfileListBuilderApi.md#preview_policy_list_by_id1) | **GET** /template/policy/list/translationprofile/preview/{id} | 
*ConfigurationPolicyTranslationRulesListBuilderApi* | [**create_policy_list2**](docs/ConfigurationPolicyTranslationRulesListBuilderApi.md#create_policy_list2) | **POST** /template/policy/list/translationrules | 
*ConfigurationPolicyTranslationRulesListBuilderApi* | [**delete_policy_list2**](docs/ConfigurationPolicyTranslationRulesListBuilderApi.md#delete_policy_list2) | **DELETE** /template/policy/list/translationrules/{id} | 
*ConfigurationPolicyTranslationRulesListBuilderApi* | [**delete_policy_lists_with_info_tag2**](docs/ConfigurationPolicyTranslationRulesListBuilderApi.md#delete_policy_lists_with_info_tag2) | **DELETE** /template/policy/list/translationrules | 
*ConfigurationPolicyTranslationRulesListBuilderApi* | [**edit_policy_list2**](docs/ConfigurationPolicyTranslationRulesListBuilderApi.md#edit_policy_list2) | **PUT** /template/policy/list/translationrules/{id} | 
*ConfigurationPolicyTranslationRulesListBuilderApi* | [**get_lists_by_id2**](docs/ConfigurationPolicyTranslationRulesListBuilderApi.md#get_lists_by_id2) | **GET** /template/policy/list/translationrules/{id} | 
*ConfigurationPolicyTranslationRulesListBuilderApi* | [**get_policy_lists2**](docs/ConfigurationPolicyTranslationRulesListBuilderApi.md#get_policy_lists2) | **GET** /template/policy/list/translationrules | 
*ConfigurationPolicyTranslationRulesListBuilderApi* | [**get_policy_lists_with_info_tag2**](docs/ConfigurationPolicyTranslationRulesListBuilderApi.md#get_policy_lists_with_info_tag2) | **GET** /template/policy/list/translationrules/filtered | 
*ConfigurationPolicyTranslationRulesListBuilderApi* | [**preview_policy_list2**](docs/ConfigurationPolicyTranslationRulesListBuilderApi.md#preview_policy_list2) | **POST** /template/policy/list/translationrules/preview | 
*ConfigurationPolicyTranslationRulesListBuilderApi* | [**preview_policy_list_by_id2**](docs/ConfigurationPolicyTranslationRulesListBuilderApi.md#preview_policy_list_by_id2) | **GET** /template/policy/list/translationrules/preview/{id} | 
*ConfigurationPolicyTrunkGroupListBuilderApi* | [**create_policy_list35**](docs/ConfigurationPolicyTrunkGroupListBuilderApi.md#create_policy_list35) | **POST** /template/policy/list/trunkgroup | 
*ConfigurationPolicyTrunkGroupListBuilderApi* | [**delete_policy_list35**](docs/ConfigurationPolicyTrunkGroupListBuilderApi.md#delete_policy_list35) | **DELETE** /template/policy/list/trunkgroup/{id} | 
*ConfigurationPolicyTrunkGroupListBuilderApi* | [**delete_policy_lists_with_info_tag35**](docs/ConfigurationPolicyTrunkGroupListBuilderApi.md#delete_policy_lists_with_info_tag35) | **DELETE** /template/policy/list/trunkgroup | 
*ConfigurationPolicyTrunkGroupListBuilderApi* | [**edit_policy_list35**](docs/ConfigurationPolicyTrunkGroupListBuilderApi.md#edit_policy_list35) | **PUT** /template/policy/list/trunkgroup/{id} | 
*ConfigurationPolicyTrunkGroupListBuilderApi* | [**get_lists_by_id35**](docs/ConfigurationPolicyTrunkGroupListBuilderApi.md#get_lists_by_id35) | **GET** /template/policy/list/trunkgroup/{id} | 
*ConfigurationPolicyTrunkGroupListBuilderApi* | [**get_policy_lists32**](docs/ConfigurationPolicyTrunkGroupListBuilderApi.md#get_policy_lists32) | **GET** /template/policy/list/trunkgroup | 
*ConfigurationPolicyTrunkGroupListBuilderApi* | [**get_policy_lists_with_info_tag35**](docs/ConfigurationPolicyTrunkGroupListBuilderApi.md#get_policy_lists_with_info_tag35) | **GET** /template/policy/list/trunkgroup/filtered | 
*ConfigurationPolicyTrunkGroupListBuilderApi* | [**preview_policy_list35**](docs/ConfigurationPolicyTrunkGroupListBuilderApi.md#preview_policy_list35) | **POST** /template/policy/list/trunkgroup/preview | 
*ConfigurationPolicyTrunkGroupListBuilderApi* | [**preview_policy_list_by_id35**](docs/ConfigurationPolicyTrunkGroupListBuilderApi.md#preview_policy_list_by_id35) | **GET** /template/policy/list/trunkgroup/preview/{id} | 
*ConfigurationPolicyURLBlackListBuilderApi* | [**create_policy_list37**](docs/ConfigurationPolicyURLBlackListBuilderApi.md#create_policy_list37) | **POST** /template/policy/list/urlblacklist | 
*ConfigurationPolicyURLBlackListBuilderApi* | [**delete_policy_list37**](docs/ConfigurationPolicyURLBlackListBuilderApi.md#delete_policy_list37) | **DELETE** /template/policy/list/urlblacklist/{id} | 
*ConfigurationPolicyURLBlackListBuilderApi* | [**delete_policy_lists_with_info_tag37**](docs/ConfigurationPolicyURLBlackListBuilderApi.md#delete_policy_lists_with_info_tag37) | **DELETE** /template/policy/list/urlblacklist | 
*ConfigurationPolicyURLBlackListBuilderApi* | [**edit_policy_list37**](docs/ConfigurationPolicyURLBlackListBuilderApi.md#edit_policy_list37) | **PUT** /template/policy/list/urlblacklist/{id} | 
*ConfigurationPolicyURLBlackListBuilderApi* | [**get_lists_by_id37**](docs/ConfigurationPolicyURLBlackListBuilderApi.md#get_lists_by_id37) | **GET** /template/policy/list/urlblacklist/{id} | 
*ConfigurationPolicyURLBlackListBuilderApi* | [**get_policy_lists34**](docs/ConfigurationPolicyURLBlackListBuilderApi.md#get_policy_lists34) | **GET** /template/policy/list/urlblacklist | 
*ConfigurationPolicyURLBlackListBuilderApi* | [**get_policy_lists_with_info_tag37**](docs/ConfigurationPolicyURLBlackListBuilderApi.md#get_policy_lists_with_info_tag37) | **GET** /template/policy/list/urlblacklist/filtered | 
*ConfigurationPolicyURLBlackListBuilderApi* | [**preview_policy_list37**](docs/ConfigurationPolicyURLBlackListBuilderApi.md#preview_policy_list37) | **POST** /template/policy/list/urlblacklist/preview | 
*ConfigurationPolicyURLBlackListBuilderApi* | [**preview_policy_list_by_id37**](docs/ConfigurationPolicyURLBlackListBuilderApi.md#preview_policy_list_by_id37) | **GET** /template/policy/list/urlblacklist/preview/{id} | 
*ConfigurationPolicyURLFilteringDefinitionBuilderApi* | [**create_policy_definition23**](docs/ConfigurationPolicyURLFilteringDefinitionBuilderApi.md#create_policy_definition23) | **POST** /template/policy/definition/urlfiltering | 
*ConfigurationPolicyURLFilteringDefinitionBuilderApi* | [**delete_policy_definition23**](docs/ConfigurationPolicyURLFilteringDefinitionBuilderApi.md#delete_policy_definition23) | **DELETE** /template/policy/definition/urlfiltering/{id} | 
*ConfigurationPolicyURLFilteringDefinitionBuilderApi* | [**edit_multiple_policy_definition23**](docs/ConfigurationPolicyURLFilteringDefinitionBuilderApi.md#edit_multiple_policy_definition23) | **PUT** /template/policy/definition/urlfiltering/multiple/{id} | 
*ConfigurationPolicyURLFilteringDefinitionBuilderApi* | [**edit_policy_definition23**](docs/ConfigurationPolicyURLFilteringDefinitionBuilderApi.md#edit_policy_definition23) | **PUT** /template/policy/definition/urlfiltering/{id} | 
*ConfigurationPolicyURLFilteringDefinitionBuilderApi* | [**get_definitions23**](docs/ConfigurationPolicyURLFilteringDefinitionBuilderApi.md#get_definitions23) | **GET** /template/policy/definition/urlfiltering | 
*ConfigurationPolicyURLFilteringDefinitionBuilderApi* | [**get_policy_definition23**](docs/ConfigurationPolicyURLFilteringDefinitionBuilderApi.md#get_policy_definition23) | **GET** /template/policy/definition/urlfiltering/{id} | 
*ConfigurationPolicyURLFilteringDefinitionBuilderApi* | [**preview_policy_definition23**](docs/ConfigurationPolicyURLFilteringDefinitionBuilderApi.md#preview_policy_definition23) | **POST** /template/policy/definition/urlfiltering/preview | 
*ConfigurationPolicyURLFilteringDefinitionBuilderApi* | [**preview_policy_definition_by_id23**](docs/ConfigurationPolicyURLFilteringDefinitionBuilderApi.md#preview_policy_definition_by_id23) | **GET** /template/policy/definition/urlfiltering/preview/{id} | 
*ConfigurationPolicyURLFilteringDefinitionBuilderApi* | [**save_policy_definition_in_bulk23**](docs/ConfigurationPolicyURLFilteringDefinitionBuilderApi.md#save_policy_definition_in_bulk23) | **PUT** /template/policy/definition/urlfiltering/bulk | 
*ConfigurationPolicyURLWhiteListBuilderApi* | [**create_policy_list38**](docs/ConfigurationPolicyURLWhiteListBuilderApi.md#create_policy_list38) | **POST** /template/policy/list/urlwhitelist | 
*ConfigurationPolicyURLWhiteListBuilderApi* | [**delete_policy_list38**](docs/ConfigurationPolicyURLWhiteListBuilderApi.md#delete_policy_list38) | **DELETE** /template/policy/list/urlwhitelist/{id} | 
*ConfigurationPolicyURLWhiteListBuilderApi* | [**delete_policy_lists_with_info_tag38**](docs/ConfigurationPolicyURLWhiteListBuilderApi.md#delete_policy_lists_with_info_tag38) | **DELETE** /template/policy/list/urlwhitelist | 
*ConfigurationPolicyURLWhiteListBuilderApi* | [**edit_policy_list38**](docs/ConfigurationPolicyURLWhiteListBuilderApi.md#edit_policy_list38) | **PUT** /template/policy/list/urlwhitelist/{id} | 
*ConfigurationPolicyURLWhiteListBuilderApi* | [**get_lists_by_id38**](docs/ConfigurationPolicyURLWhiteListBuilderApi.md#get_lists_by_id38) | **GET** /template/policy/list/urlwhitelist/{id} | 
*ConfigurationPolicyURLWhiteListBuilderApi* | [**get_policy_lists35**](docs/ConfigurationPolicyURLWhiteListBuilderApi.md#get_policy_lists35) | **GET** /template/policy/list/urlwhitelist | 
*ConfigurationPolicyURLWhiteListBuilderApi* | [**get_policy_lists_with_info_tag38**](docs/ConfigurationPolicyURLWhiteListBuilderApi.md#get_policy_lists_with_info_tag38) | **GET** /template/policy/list/urlwhitelist/filtered | 
*ConfigurationPolicyURLWhiteListBuilderApi* | [**preview_policy_list38**](docs/ConfigurationPolicyURLWhiteListBuilderApi.md#preview_policy_list38) | **POST** /template/policy/list/urlwhitelist/preview | 
*ConfigurationPolicyURLWhiteListBuilderApi* | [**preview_policy_list_by_id38**](docs/ConfigurationPolicyURLWhiteListBuilderApi.md#preview_policy_list_by_id38) | **GET** /template/policy/list/urlwhitelist/preview/{id} | 
*ConfigurationPolicyUmbrellaDataBuilderApi* | [**create_policy_list36**](docs/ConfigurationPolicyUmbrellaDataBuilderApi.md#create_policy_list36) | **POST** /template/policy/list/umbrelladata | 
*ConfigurationPolicyUmbrellaDataBuilderApi* | [**delete_policy_list36**](docs/ConfigurationPolicyUmbrellaDataBuilderApi.md#delete_policy_list36) | **DELETE** /template/policy/list/umbrelladata/{id} | 
*ConfigurationPolicyUmbrellaDataBuilderApi* | [**delete_policy_lists_with_info_tag36**](docs/ConfigurationPolicyUmbrellaDataBuilderApi.md#delete_policy_lists_with_info_tag36) | **DELETE** /template/policy/list/umbrelladata | 
*ConfigurationPolicyUmbrellaDataBuilderApi* | [**edit_policy_list36**](docs/ConfigurationPolicyUmbrellaDataBuilderApi.md#edit_policy_list36) | **PUT** /template/policy/list/umbrelladata/{id} | 
*ConfigurationPolicyUmbrellaDataBuilderApi* | [**get_lists_by_id36**](docs/ConfigurationPolicyUmbrellaDataBuilderApi.md#get_lists_by_id36) | **GET** /template/policy/list/umbrelladata/{id} | 
*ConfigurationPolicyUmbrellaDataBuilderApi* | [**get_policy_lists33**](docs/ConfigurationPolicyUmbrellaDataBuilderApi.md#get_policy_lists33) | **GET** /template/policy/list/umbrelladata | 
*ConfigurationPolicyUmbrellaDataBuilderApi* | [**get_policy_lists_with_info_tag36**](docs/ConfigurationPolicyUmbrellaDataBuilderApi.md#get_policy_lists_with_info_tag36) | **GET** /template/policy/list/umbrelladata/filtered | 
*ConfigurationPolicyUmbrellaDataBuilderApi* | [**preview_policy_list36**](docs/ConfigurationPolicyUmbrellaDataBuilderApi.md#preview_policy_list36) | **POST** /template/policy/list/umbrelladata/preview | 
*ConfigurationPolicyUmbrellaDataBuilderApi* | [**preview_policy_list_by_id36**](docs/ConfigurationPolicyUmbrellaDataBuilderApi.md#preview_policy_list_by_id36) | **GET** /template/policy/list/umbrelladata/preview/{id} | 
*ConfigurationPolicyVPNListBuilderApi* | [**create_policy_list39**](docs/ConfigurationPolicyVPNListBuilderApi.md#create_policy_list39) | **POST** /template/policy/list/vpn | 
*ConfigurationPolicyVPNListBuilderApi* | [**delete_policy_list39**](docs/ConfigurationPolicyVPNListBuilderApi.md#delete_policy_list39) | **DELETE** /template/policy/list/vpn/{id} | 
*ConfigurationPolicyVPNListBuilderApi* | [**delete_policy_lists_with_info_tag39**](docs/ConfigurationPolicyVPNListBuilderApi.md#delete_policy_lists_with_info_tag39) | **DELETE** /template/policy/list/vpn | 
*ConfigurationPolicyVPNListBuilderApi* | [**edit_policy_list39**](docs/ConfigurationPolicyVPNListBuilderApi.md#edit_policy_list39) | **PUT** /template/policy/list/vpn/{id} | 
*ConfigurationPolicyVPNListBuilderApi* | [**get_lists_by_id39**](docs/ConfigurationPolicyVPNListBuilderApi.md#get_lists_by_id39) | **GET** /template/policy/list/vpn/{id} | 
*ConfigurationPolicyVPNListBuilderApi* | [**get_policy_lists36**](docs/ConfigurationPolicyVPNListBuilderApi.md#get_policy_lists36) | **GET** /template/policy/list/vpn | 
*ConfigurationPolicyVPNListBuilderApi* | [**get_policy_lists_with_info_tag39**](docs/ConfigurationPolicyVPNListBuilderApi.md#get_policy_lists_with_info_tag39) | **GET** /template/policy/list/vpn/filtered | 
*ConfigurationPolicyVPNListBuilderApi* | [**preview_policy_list39**](docs/ConfigurationPolicyVPNListBuilderApi.md#preview_policy_list39) | **POST** /template/policy/list/vpn/preview | 
*ConfigurationPolicyVPNListBuilderApi* | [**preview_policy_list_by_id39**](docs/ConfigurationPolicyVPNListBuilderApi.md#preview_policy_list_by_id39) | **GET** /template/policy/list/vpn/preview/{id} | 
*ConfigurationPolicyVPNMembershipGroupDefinitionBuilderApi* | [**create_policy_definition6**](docs/ConfigurationPolicyVPNMembershipGroupDefinitionBuilderApi.md#create_policy_definition6) | **POST** /template/policy/definition/vpnmembershipgroup | 
*ConfigurationPolicyVPNMembershipGroupDefinitionBuilderApi* | [**delete_policy_definition6**](docs/ConfigurationPolicyVPNMembershipGroupDefinitionBuilderApi.md#delete_policy_definition6) | **DELETE** /template/policy/definition/vpnmembershipgroup/{id} | 
*ConfigurationPolicyVPNMembershipGroupDefinitionBuilderApi* | [**edit_multiple_policy_definition6**](docs/ConfigurationPolicyVPNMembershipGroupDefinitionBuilderApi.md#edit_multiple_policy_definition6) | **PUT** /template/policy/definition/vpnmembershipgroup/multiple/{id} | 
*ConfigurationPolicyVPNMembershipGroupDefinitionBuilderApi* | [**edit_policy_definition6**](docs/ConfigurationPolicyVPNMembershipGroupDefinitionBuilderApi.md#edit_policy_definition6) | **PUT** /template/policy/definition/vpnmembershipgroup/{id} | 
*ConfigurationPolicyVPNMembershipGroupDefinitionBuilderApi* | [**get_definitions6**](docs/ConfigurationPolicyVPNMembershipGroupDefinitionBuilderApi.md#get_definitions6) | **GET** /template/policy/definition/vpnmembershipgroup | 
*ConfigurationPolicyVPNMembershipGroupDefinitionBuilderApi* | [**get_policy_definition6**](docs/ConfigurationPolicyVPNMembershipGroupDefinitionBuilderApi.md#get_policy_definition6) | **GET** /template/policy/definition/vpnmembershipgroup/{id} | 
*ConfigurationPolicyVPNMembershipGroupDefinitionBuilderApi* | [**preview_policy_definition6**](docs/ConfigurationPolicyVPNMembershipGroupDefinitionBuilderApi.md#preview_policy_definition6) | **POST** /template/policy/definition/vpnmembershipgroup/preview | 
*ConfigurationPolicyVPNMembershipGroupDefinitionBuilderApi* | [**preview_policy_definition_by_id6**](docs/ConfigurationPolicyVPNMembershipGroupDefinitionBuilderApi.md#preview_policy_definition_by_id6) | **GET** /template/policy/definition/vpnmembershipgroup/preview/{id} | 
*ConfigurationPolicyVPNMembershipGroupDefinitionBuilderApi* | [**save_policy_definition_in_bulk6**](docs/ConfigurationPolicyVPNMembershipGroupDefinitionBuilderApi.md#save_policy_definition_in_bulk6) | **PUT** /template/policy/definition/vpnmembershipgroup/bulk | 
*ConfigurationPolicyVPNQosMapDefinitionBuilderApi* | [**create_policy_definition2**](docs/ConfigurationPolicyVPNQosMapDefinitionBuilderApi.md#create_policy_definition2) | **POST** /template/policy/definition/vpnqosmap | 
*ConfigurationPolicyVPNQosMapDefinitionBuilderApi* | [**delete_policy_definition2**](docs/ConfigurationPolicyVPNQosMapDefinitionBuilderApi.md#delete_policy_definition2) | **DELETE** /template/policy/definition/vpnqosmap/{id} | 
*ConfigurationPolicyVPNQosMapDefinitionBuilderApi* | [**edit_multiple_policy_definition2**](docs/ConfigurationPolicyVPNQosMapDefinitionBuilderApi.md#edit_multiple_policy_definition2) | **PUT** /template/policy/definition/vpnqosmap/multiple/{id} | 
*ConfigurationPolicyVPNQosMapDefinitionBuilderApi* | [**edit_policy_definition2**](docs/ConfigurationPolicyVPNQosMapDefinitionBuilderApi.md#edit_policy_definition2) | **PUT** /template/policy/definition/vpnqosmap/{id} | 
*ConfigurationPolicyVPNQosMapDefinitionBuilderApi* | [**get_definitions2**](docs/ConfigurationPolicyVPNQosMapDefinitionBuilderApi.md#get_definitions2) | **GET** /template/policy/definition/vpnqosmap | 
*ConfigurationPolicyVPNQosMapDefinitionBuilderApi* | [**get_policy_definition2**](docs/ConfigurationPolicyVPNQosMapDefinitionBuilderApi.md#get_policy_definition2) | **GET** /template/policy/definition/vpnqosmap/{id} | 
*ConfigurationPolicyVPNQosMapDefinitionBuilderApi* | [**preview_policy_definition2**](docs/ConfigurationPolicyVPNQosMapDefinitionBuilderApi.md#preview_policy_definition2) | **POST** /template/policy/definition/vpnqosmap/preview | 
*ConfigurationPolicyVPNQosMapDefinitionBuilderApi* | [**preview_policy_definition_by_id2**](docs/ConfigurationPolicyVPNQosMapDefinitionBuilderApi.md#preview_policy_definition_by_id2) | **GET** /template/policy/definition/vpnqosmap/preview/{id} | 
*ConfigurationPolicyVPNQosMapDefinitionBuilderApi* | [**save_policy_definition_in_bulk2**](docs/ConfigurationPolicyVPNQosMapDefinitionBuilderApi.md#save_policy_definition_in_bulk2) | **PUT** /template/policy/definition/vpnqosmap/bulk | 
*ConfigurationPolicyVoiceAssemblerApi* | [**preview2**](docs/ConfigurationPolicyVoiceAssemblerApi.md#preview2) | **POST** /template/policy/assembly/voice | 
*ConfigurationPolicyVoiceAssemblerApi* | [**preview_by_id2**](docs/ConfigurationPolicyVoiceAssemblerApi.md#preview_by_id2) | **GET** /template/policy/assembly/voice/{id} | 
*ConfigurationPolicyZoneBasedFirewallDefinitionBuilderApi* | [**create_policy_definition7**](docs/ConfigurationPolicyZoneBasedFirewallDefinitionBuilderApi.md#create_policy_definition7) | **POST** /template/policy/definition/zonebasedfw | 
*ConfigurationPolicyZoneBasedFirewallDefinitionBuilderApi* | [**delete_policy_definition7**](docs/ConfigurationPolicyZoneBasedFirewallDefinitionBuilderApi.md#delete_policy_definition7) | **DELETE** /template/policy/definition/zonebasedfw/{id} | 
*ConfigurationPolicyZoneBasedFirewallDefinitionBuilderApi* | [**edit_multiple_policy_definition7**](docs/ConfigurationPolicyZoneBasedFirewallDefinitionBuilderApi.md#edit_multiple_policy_definition7) | **PUT** /template/policy/definition/zonebasedfw/multiple/{id} | 
*ConfigurationPolicyZoneBasedFirewallDefinitionBuilderApi* | [**edit_policy_definition7**](docs/ConfigurationPolicyZoneBasedFirewallDefinitionBuilderApi.md#edit_policy_definition7) | **PUT** /template/policy/definition/zonebasedfw/{id} | 
*ConfigurationPolicyZoneBasedFirewallDefinitionBuilderApi* | [**get_definitions7**](docs/ConfigurationPolicyZoneBasedFirewallDefinitionBuilderApi.md#get_definitions7) | **GET** /template/policy/definition/zonebasedfw | 
*ConfigurationPolicyZoneBasedFirewallDefinitionBuilderApi* | [**get_policy_definition7**](docs/ConfigurationPolicyZoneBasedFirewallDefinitionBuilderApi.md#get_policy_definition7) | **GET** /template/policy/definition/zonebasedfw/{id} | 
*ConfigurationPolicyZoneBasedFirewallDefinitionBuilderApi* | [**preview_policy_definition7**](docs/ConfigurationPolicyZoneBasedFirewallDefinitionBuilderApi.md#preview_policy_definition7) | **POST** /template/policy/definition/zonebasedfw/preview | 
*ConfigurationPolicyZoneBasedFirewallDefinitionBuilderApi* | [**preview_policy_definition_by_id7**](docs/ConfigurationPolicyZoneBasedFirewallDefinitionBuilderApi.md#preview_policy_definition_by_id7) | **GET** /template/policy/definition/zonebasedfw/preview/{id} | 
*ConfigurationPolicyZoneBasedFirewallDefinitionBuilderApi* | [**save_policy_definition_in_bulk7**](docs/ConfigurationPolicyZoneBasedFirewallDefinitionBuilderApi.md#save_policy_definition_in_bulk7) | **PUT** /template/policy/definition/zonebasedfw/bulk | 
*ConfigurationPolicyZoneListBuilderApi* | [**create_policy_list40**](docs/ConfigurationPolicyZoneListBuilderApi.md#create_policy_list40) | **POST** /template/policy/list/zone | 
*ConfigurationPolicyZoneListBuilderApi* | [**delete_policy_list40**](docs/ConfigurationPolicyZoneListBuilderApi.md#delete_policy_list40) | **DELETE** /template/policy/list/zone/{id} | 
*ConfigurationPolicyZoneListBuilderApi* | [**delete_policy_lists_with_info_tag40**](docs/ConfigurationPolicyZoneListBuilderApi.md#delete_policy_lists_with_info_tag40) | **DELETE** /template/policy/list/zone | 
*ConfigurationPolicyZoneListBuilderApi* | [**edit_policy_list40**](docs/ConfigurationPolicyZoneListBuilderApi.md#edit_policy_list40) | **PUT** /template/policy/list/zone/{id} | 
*ConfigurationPolicyZoneListBuilderApi* | [**get_lists_by_id40**](docs/ConfigurationPolicyZoneListBuilderApi.md#get_lists_by_id40) | **GET** /template/policy/list/zone/{id} | 
*ConfigurationPolicyZoneListBuilderApi* | [**get_policy_lists37**](docs/ConfigurationPolicyZoneListBuilderApi.md#get_policy_lists37) | **GET** /template/policy/list/zone | 
*ConfigurationPolicyZoneListBuilderApi* | [**get_policy_lists_with_info_tag40**](docs/ConfigurationPolicyZoneListBuilderApi.md#get_policy_lists_with_info_tag40) | **GET** /template/policy/list/zone/filtered | 
*ConfigurationPolicyZoneListBuilderApi* | [**preview_policy_list40**](docs/ConfigurationPolicyZoneListBuilderApi.md#preview_policy_list40) | **POST** /template/policy/list/zone/preview | 
*ConfigurationPolicyZoneListBuilderApi* | [**preview_policy_list_by_id40**](docs/ConfigurationPolicyZoneListBuilderApi.md#preview_policy_list_by_id40) | **GET** /template/policy/list/zone/preview/{id} | 
*ConfigurationPolicyVEdgeAssemblerApi* | [**preview1**](docs/ConfigurationPolicyVEdgeAssemblerApi.md#preview1) | **POST** /template/policy/assembly/vedge | 
*ConfigurationPolicyVEdgeAssemblerApi* | [**preview_by_id1**](docs/ConfigurationPolicyVEdgeAssemblerApi.md#preview_by_id1) | **GET** /template/policy/assembly/vedge/{id} | 
*ConfigurationPolicyVEdgeRouteDefinitionBuilderApi* | [**create_policy_definition24**](docs/ConfigurationPolicyVEdgeRouteDefinitionBuilderApi.md#create_policy_definition24) | **POST** /template/policy/definition/vedgeroute | 
*ConfigurationPolicyVEdgeRouteDefinitionBuilderApi* | [**delete_policy_definition24**](docs/ConfigurationPolicyVEdgeRouteDefinitionBuilderApi.md#delete_policy_definition24) | **DELETE** /template/policy/definition/vedgeroute/{id} | 
*ConfigurationPolicyVEdgeRouteDefinitionBuilderApi* | [**edit_multiple_policy_definition24**](docs/ConfigurationPolicyVEdgeRouteDefinitionBuilderApi.md#edit_multiple_policy_definition24) | **PUT** /template/policy/definition/vedgeroute/multiple/{id} | 
*ConfigurationPolicyVEdgeRouteDefinitionBuilderApi* | [**edit_policy_definition24**](docs/ConfigurationPolicyVEdgeRouteDefinitionBuilderApi.md#edit_policy_definition24) | **PUT** /template/policy/definition/vedgeroute/{id} | 
*ConfigurationPolicyVEdgeRouteDefinitionBuilderApi* | [**get_definitions24**](docs/ConfigurationPolicyVEdgeRouteDefinitionBuilderApi.md#get_definitions24) | **GET** /template/policy/definition/vedgeroute | 
*ConfigurationPolicyVEdgeRouteDefinitionBuilderApi* | [**get_policy_definition24**](docs/ConfigurationPolicyVEdgeRouteDefinitionBuilderApi.md#get_policy_definition24) | **GET** /template/policy/definition/vedgeroute/{id} | 
*ConfigurationPolicyVEdgeRouteDefinitionBuilderApi* | [**preview_policy_definition24**](docs/ConfigurationPolicyVEdgeRouteDefinitionBuilderApi.md#preview_policy_definition24) | **POST** /template/policy/definition/vedgeroute/preview | 
*ConfigurationPolicyVEdgeRouteDefinitionBuilderApi* | [**preview_policy_definition_by_id24**](docs/ConfigurationPolicyVEdgeRouteDefinitionBuilderApi.md#preview_policy_definition_by_id24) | **GET** /template/policy/definition/vedgeroute/preview/{id} | 
*ConfigurationPolicyVEdgeRouteDefinitionBuilderApi* | [**save_policy_definition_in_bulk24**](docs/ConfigurationPolicyVEdgeRouteDefinitionBuilderApi.md#save_policy_definition_in_bulk24) | **PUT** /template/policy/definition/vedgeroute/bulk | 
*ConfigurationPolicyVSmartAssemblerApi* | [**preview3**](docs/ConfigurationPolicyVSmartAssemblerApi.md#preview3) | **POST** /template/policy/assembly/vsmart | 
*ConfigurationPolicyVSmartAssemblerApi* | [**preview_by_id3**](docs/ConfigurationPolicyVSmartAssemblerApi.md#preview_by_id3) | **GET** /template/policy/assembly/vsmart/{id} | 
*ConfigurationPreUpgradeCheckStatusApi* | [**update_pre_upgrade_check_status**](docs/ConfigurationPreUpgradeCheckStatusApi.md#update_pre_upgrade_check_status) | **PUT** /device/action/status/preupgrade/check | 
*ConfigurationQuickConnectApi* | [**submit_day0_config**](docs/ConfigurationQuickConnectApi.md#submit_day0_config) | **POST** /template/config/quickConnect/submitDevices | 
*ConfigurationRuleSetDefinitionApi* | [**create_policy_definition20**](docs/ConfigurationRuleSetDefinitionApi.md#create_policy_definition20) | **POST** /template/policy/definition/ruleset | 
*ConfigurationRuleSetDefinitionApi* | [**delete_policy_definition20**](docs/ConfigurationRuleSetDefinitionApi.md#delete_policy_definition20) | **DELETE** /template/policy/definition/ruleset/{id} | 
*ConfigurationRuleSetDefinitionApi* | [**edit_multiple_policy_definition20**](docs/ConfigurationRuleSetDefinitionApi.md#edit_multiple_policy_definition20) | **PUT** /template/policy/definition/ruleset/multiple/{id} | 
*ConfigurationRuleSetDefinitionApi* | [**edit_policy_definition20**](docs/ConfigurationRuleSetDefinitionApi.md#edit_policy_definition20) | **PUT** /template/policy/definition/ruleset/{id} | 
*ConfigurationRuleSetDefinitionApi* | [**get_definitions20**](docs/ConfigurationRuleSetDefinitionApi.md#get_definitions20) | **GET** /template/policy/definition/ruleset | 
*ConfigurationRuleSetDefinitionApi* | [**get_policy_definition20**](docs/ConfigurationRuleSetDefinitionApi.md#get_policy_definition20) | **GET** /template/policy/definition/ruleset/{id} | 
*ConfigurationRuleSetDefinitionApi* | [**preview_policy_definition20**](docs/ConfigurationRuleSetDefinitionApi.md#preview_policy_definition20) | **POST** /template/policy/definition/ruleset/preview | 
*ConfigurationRuleSetDefinitionApi* | [**preview_policy_definition_by_id20**](docs/ConfigurationRuleSetDefinitionApi.md#preview_policy_definition_by_id20) | **GET** /template/policy/definition/ruleset/preview/{id} | 
*ConfigurationRuleSetDefinitionApi* | [**save_policy_definition_in_bulk20**](docs/ConfigurationRuleSetDefinitionApi.md#save_policy_definition_in_bulk20) | **PUT** /template/policy/definition/ruleset/bulk | 
*ConfigurationSSLDecryptionPolicyDefinitionBuilderApi* | [**create_policy_definition3**](docs/ConfigurationSSLDecryptionPolicyDefinitionBuilderApi.md#create_policy_definition3) | **POST** /template/policy/definition/ssldecryption | 
*ConfigurationSSLDecryptionPolicyDefinitionBuilderApi* | [**delete_policy_definition3**](docs/ConfigurationSSLDecryptionPolicyDefinitionBuilderApi.md#delete_policy_definition3) | **DELETE** /template/policy/definition/ssldecryption/{id} | 
*ConfigurationSSLDecryptionPolicyDefinitionBuilderApi* | [**edit_multiple_policy_definition3**](docs/ConfigurationSSLDecryptionPolicyDefinitionBuilderApi.md#edit_multiple_policy_definition3) | **PUT** /template/policy/definition/ssldecryption/multiple/{id} | 
*ConfigurationSSLDecryptionPolicyDefinitionBuilderApi* | [**edit_policy_definition3**](docs/ConfigurationSSLDecryptionPolicyDefinitionBuilderApi.md#edit_policy_definition3) | **PUT** /template/policy/definition/ssldecryption/{id} | 
*ConfigurationSSLDecryptionPolicyDefinitionBuilderApi* | [**get_definitions3**](docs/ConfigurationSSLDecryptionPolicyDefinitionBuilderApi.md#get_definitions3) | **GET** /template/policy/definition/ssldecryption | 
*ConfigurationSSLDecryptionPolicyDefinitionBuilderApi* | [**get_policy_definition3**](docs/ConfigurationSSLDecryptionPolicyDefinitionBuilderApi.md#get_policy_definition3) | **GET** /template/policy/definition/ssldecryption/{id} | 
*ConfigurationSSLDecryptionPolicyDefinitionBuilderApi* | [**preview_policy_definition3**](docs/ConfigurationSSLDecryptionPolicyDefinitionBuilderApi.md#preview_policy_definition3) | **POST** /template/policy/definition/ssldecryption/preview | 
*ConfigurationSSLDecryptionPolicyDefinitionBuilderApi* | [**preview_policy_definition_by_id3**](docs/ConfigurationSSLDecryptionPolicyDefinitionBuilderApi.md#preview_policy_definition_by_id3) | **GET** /template/policy/definition/ssldecryption/preview/{id} | 
*ConfigurationSSLDecryptionPolicyDefinitionBuilderApi* | [**save_policy_definition_in_bulk3**](docs/ConfigurationSSLDecryptionPolicyDefinitionBuilderApi.md#save_policy_definition_in_bulk3) | **PUT** /template/policy/definition/ssldecryption/bulk | 
*ConfigurationSSLDecryptionUTDProfileDefinitionApi* | [**create_policy_definition22**](docs/ConfigurationSSLDecryptionUTDProfileDefinitionApi.md#create_policy_definition22) | **POST** /template/policy/definition/sslutdprofile | 
*ConfigurationSSLDecryptionUTDProfileDefinitionApi* | [**delete_policy_definition22**](docs/ConfigurationSSLDecryptionUTDProfileDefinitionApi.md#delete_policy_definition22) | **DELETE** /template/policy/definition/sslutdprofile/{id} | 
*ConfigurationSSLDecryptionUTDProfileDefinitionApi* | [**edit_multiple_policy_definition22**](docs/ConfigurationSSLDecryptionUTDProfileDefinitionApi.md#edit_multiple_policy_definition22) | **PUT** /template/policy/definition/sslutdprofile/multiple/{id} | 
*ConfigurationSSLDecryptionUTDProfileDefinitionApi* | [**edit_policy_definition22**](docs/ConfigurationSSLDecryptionUTDProfileDefinitionApi.md#edit_policy_definition22) | **PUT** /template/policy/definition/sslutdprofile/{id} | 
*ConfigurationSSLDecryptionUTDProfileDefinitionApi* | [**get_definitions22**](docs/ConfigurationSSLDecryptionUTDProfileDefinitionApi.md#get_definitions22) | **GET** /template/policy/definition/sslutdprofile | 
*ConfigurationSSLDecryptionUTDProfileDefinitionApi* | [**get_policy_definition22**](docs/ConfigurationSSLDecryptionUTDProfileDefinitionApi.md#get_policy_definition22) | **GET** /template/policy/definition/sslutdprofile/{id} | 
*ConfigurationSSLDecryptionUTDProfileDefinitionApi* | [**preview_policy_definition22**](docs/ConfigurationSSLDecryptionUTDProfileDefinitionApi.md#preview_policy_definition22) | **POST** /template/policy/definition/sslutdprofile/preview | 
*ConfigurationSSLDecryptionUTDProfileDefinitionApi* | [**preview_policy_definition_by_id22**](docs/ConfigurationSSLDecryptionUTDProfileDefinitionApi.md#preview_policy_definition_by_id22) | **GET** /template/policy/definition/sslutdprofile/preview/{id} | 
*ConfigurationSSLDecryptionUTDProfileDefinitionApi* | [**save_policy_definition_in_bulk22**](docs/ConfigurationSSLDecryptionUTDProfileDefinitionApi.md#save_policy_definition_in_bulk22) | **PUT** /template/policy/definition/sslutdprofile/bulk | 
*ConfigurationSecureInternetGatewayTunnelsApi* | [**get_sig_tunnel_list**](docs/ConfigurationSecureInternetGatewayTunnelsApi.md#get_sig_tunnel_list) | **GET** /template/cloudx/sig_tunnels | 
*ConfigurationSecurityGroupDefinitionApi* | [**create_policy_definition21**](docs/ConfigurationSecurityGroupDefinitionApi.md#create_policy_definition21) | **POST** /template/policy/definition/securitygroup | 
*ConfigurationSecurityGroupDefinitionApi* | [**delete_policy_definition21**](docs/ConfigurationSecurityGroupDefinitionApi.md#delete_policy_definition21) | **DELETE** /template/policy/definition/securitygroup/{id} | 
*ConfigurationSecurityGroupDefinitionApi* | [**edit_multiple_policy_definition21**](docs/ConfigurationSecurityGroupDefinitionApi.md#edit_multiple_policy_definition21) | **PUT** /template/policy/definition/securitygroup/multiple/{id} | 
*ConfigurationSecurityGroupDefinitionApi* | [**edit_policy_definition21**](docs/ConfigurationSecurityGroupDefinitionApi.md#edit_policy_definition21) | **PUT** /template/policy/definition/securitygroup/{id} | 
*ConfigurationSecurityGroupDefinitionApi* | [**get_definitions21**](docs/ConfigurationSecurityGroupDefinitionApi.md#get_definitions21) | **GET** /template/policy/definition/securitygroup | 
*ConfigurationSecurityGroupDefinitionApi* | [**get_policy_definition21**](docs/ConfigurationSecurityGroupDefinitionApi.md#get_policy_definition21) | **GET** /template/policy/definition/securitygroup/{id} | 
*ConfigurationSecurityGroupDefinitionApi* | [**preview_policy_definition21**](docs/ConfigurationSecurityGroupDefinitionApi.md#preview_policy_definition21) | **POST** /template/policy/definition/securitygroup/preview | 
*ConfigurationSecurityGroupDefinitionApi* | [**preview_policy_definition_by_id21**](docs/ConfigurationSecurityGroupDefinitionApi.md#preview_policy_definition_by_id21) | **GET** /template/policy/definition/securitygroup/preview/{id} | 
*ConfigurationSecurityGroupDefinitionApi* | [**save_policy_definition_in_bulk21**](docs/ConfigurationSecurityGroupDefinitionApi.md#save_policy_definition_in_bulk21) | **PUT** /template/policy/definition/securitygroup/bulk | 
*ConfigurationSecurityTemplatePolicyApi* | [**create_security_template**](docs/ConfigurationSecurityTemplatePolicyApi.md#create_security_template) | **POST** /template/policy/security | 
*ConfigurationSecurityTemplatePolicyApi* | [**delete_security_template**](docs/ConfigurationSecurityTemplatePolicyApi.md#delete_security_template) | **DELETE** /template/policy/security/{policyId} | 
*ConfigurationSecurityTemplatePolicyApi* | [**edit_security_template**](docs/ConfigurationSecurityTemplatePolicyApi.md#edit_security_template) | **PUT** /template/policy/security/{policyId} | 
*ConfigurationSecurityTemplatePolicyApi* | [**edit_template_with_lenient_lock**](docs/ConfigurationSecurityTemplatePolicyApi.md#edit_template_with_lenient_lock) | **PUT** /template/policy/security/staging/{policyId} | 
*ConfigurationSecurityTemplatePolicyApi* | [**generate_security_policy_summary**](docs/ConfigurationSecurityTemplatePolicyApi.md#generate_security_policy_summary) | **GET** /template/policy/security/summary | 
*ConfigurationSecurityTemplatePolicyApi* | [**generate_security_template_list**](docs/ConfigurationSecurityTemplatePolicyApi.md#generate_security_template_list) | **GET** /template/policy/security | 
*ConfigurationSecurityTemplatePolicyApi* | [**get_device_list_by_id**](docs/ConfigurationSecurityTemplatePolicyApi.md#get_device_list_by_id) | **GET** /template/policy/security/devices/{policyId} | 
*ConfigurationSecurityTemplatePolicyApi* | [**get_security_policy_device_list**](docs/ConfigurationSecurityTemplatePolicyApi.md#get_security_policy_device_list) | **GET** /template/policy/security/devices | 
*ConfigurationSecurityTemplatePolicyApi* | [**get_security_template**](docs/ConfigurationSecurityTemplatePolicyApi.md#get_security_template) | **GET** /template/policy/security/definition/{policyId} | 
*ConfigurationSecurityTemplatePolicyApi* | [**get_security_templates_for_device**](docs/ConfigurationSecurityTemplatePolicyApi.md#get_security_templates_for_device) | **GET** /template/policy/security/{deviceModel} | 
*ConfigurationSegmentsApi* | [**create_segment**](docs/ConfigurationSegmentsApi.md#create_segment) | **POST** /segment | 
*ConfigurationSegmentsApi* | [**delete_segment**](docs/ConfigurationSegmentsApi.md#delete_segment) | **DELETE** /segment/{id} | 
*ConfigurationSegmentsApi* | [**edit_segment**](docs/ConfigurationSegmentsApi.md#edit_segment) | **PUT** /segment/{id} | 
*ConfigurationSegmentsApi* | [**get_segment**](docs/ConfigurationSegmentsApi.md#get_segment) | **GET** /segment/{id} | 
*ConfigurationSegmentsApi* | [**get_segments**](docs/ConfigurationSegmentsApi.md#get_segments) | **GET** /segment | 
*ConfigurationSettingsApi* | [**create_analytics_data_file**](docs/ConfigurationSettingsApi.md#create_analytics_data_file) | **POST** /settings/configuration/analytics/dca | 
*ConfigurationSettingsApi* | [**edit_cert_configuration**](docs/ConfigurationSettingsApi.md#edit_cert_configuration) | **PUT** /settings/configuration/certificate/{settingType} | 
*ConfigurationSettingsApi* | [**edit_configuration**](docs/ConfigurationSettingsApi.md#edit_configuration) | **PUT** /settings/configuration/{settingType} | 
*ConfigurationSettingsApi* | [**get_banner**](docs/ConfigurationSettingsApi.md#get_banner) | **GET** /settings/banner | 
*ConfigurationSettingsApi* | [**get_cert_configuration**](docs/ConfigurationSettingsApi.md#get_cert_configuration) | **GET** /settings/configuration/certificate/{settingType} | 
*ConfigurationSettingsApi* | [**get_configuration_by_setting_type**](docs/ConfigurationSettingsApi.md#get_configuration_by_setting_type) | **GET** /settings/configuration/{settingType} | 
*ConfigurationSettingsApi* | [**get_google_map_key**](docs/ConfigurationSettingsApi.md#get_google_map_key) | **GET** /settings/configuration/googleMapKey | 
*ConfigurationSettingsApi* | [**get_maintenance_window**](docs/ConfigurationSettingsApi.md#get_maintenance_window) | **GET** /settings/configuration/maintenanceWindow | 
*ConfigurationSettingsApi* | [**get_session_timout**](docs/ConfigurationSettingsApi.md#get_session_timout) | **GET** /settings/clientSessionTimeout | 
*ConfigurationSettingsApi* | [**new_cert_configuration**](docs/ConfigurationSettingsApi.md#new_cert_configuration) | **POST** /settings/configuration/certificate/{settingType} | 
*ConfigurationSettingsApi* | [**new_configuration**](docs/ConfigurationSettingsApi.md#new_configuration) | **POST** /settings/configuration/{settingType} | 
*ConfigurationSoftwareActionsApi* | [**add_remote_server**](docs/ConfigurationSoftwareActionsApi.md#add_remote_server) | **POST** /device/action/remote-server | 
*ConfigurationSoftwareActionsApi* | [**create_image_url**](docs/ConfigurationSoftwareActionsApi.md#create_image_url) | **POST** /device/action/software | 
*ConfigurationSoftwareActionsApi* | [**delete_image_url**](docs/ConfigurationSoftwareActionsApi.md#delete_image_url) | **DELETE** /device/action/software/{versionId} | 
*ConfigurationSoftwareActionsApi* | [**delete_remote_server**](docs/ConfigurationSoftwareActionsApi.md#delete_remote_server) | **DELETE** /device/action/remote-server/{id} | 
*ConfigurationSoftwareActionsApi* | [**find_software_images**](docs/ConfigurationSoftwareActionsApi.md#find_software_images) | **GET** /device/action/software | 
*ConfigurationSoftwareActionsApi* | [**find_software_images_with_filters**](docs/ConfigurationSoftwareActionsApi.md#find_software_images_with_filters) | **GET** /device/action/software/images | 
*ConfigurationSoftwareActionsApi* | [**find_software_version**](docs/ConfigurationSoftwareActionsApi.md#find_software_version) | **GET** /device/action/software/version | 
*ConfigurationSoftwareActionsApi* | [**find_v_edge_software_version**](docs/ConfigurationSoftwareActionsApi.md#find_v_edge_software_version) | **GET** /device/action/software/vedge/version | 
*ConfigurationSoftwareActionsApi* | [**find_ztp_software_version**](docs/ConfigurationSoftwareActionsApi.md#find_ztp_software_version) | **GET** /device/action/software/ztp/version | 
*ConfigurationSoftwareActionsApi* | [**get_image_properties**](docs/ConfigurationSoftwareActionsApi.md#get_image_properties) | **GET** /device/action/software/imageProperties/{versionId} | 
*ConfigurationSoftwareActionsApi* | [**get_pnf_properties**](docs/ConfigurationSoftwareActionsApi.md#get_pnf_properties) | **GET** /device/action/software/pnfproperties/{pnfType} | 
*ConfigurationSoftwareActionsApi* | [**get_remote_server_by_id**](docs/ConfigurationSoftwareActionsApi.md#get_remote_server_by_id) | **GET** /device/action/remote-server/{id} | 
*ConfigurationSoftwareActionsApi* | [**get_remote_server_list**](docs/ConfigurationSoftwareActionsApi.md#get_remote_server_list) | **GET** /device/action/remote-server | 
*ConfigurationSoftwareActionsApi* | [**get_vnf_properties**](docs/ConfigurationSoftwareActionsApi.md#get_vnf_properties) | **GET** /device/action/software/vnfproperties/{versionId} | 
*ConfigurationSoftwareActionsApi* | [**update_image_url**](docs/ConfigurationSoftwareActionsApi.md#update_image_url) | **PUT** /device/action/software/{versionId} | 
*ConfigurationSoftwareActionsApi* | [**update_remote_server**](docs/ConfigurationSoftwareActionsApi.md#update_remote_server) | **PUT** /device/action/remote-server/{id} | 
*ConfigurationTemplateConfigurationApi* | [**generate_cli_mode_devices**](docs/ConfigurationTemplateConfigurationApi.md#generate_cli_mode_devices) | **GET** /template/config/device/mode/cli | 
*ConfigurationTemplateConfigurationApi* | [**generatev_manage_mode_devices**](docs/ConfigurationTemplateConfigurationApi.md#generatev_manage_mode_devices) | **GET** /template/config/device/mode/vmanage | 
*ConfigurationTemplateConfigurationApi* | [**get_attached_config**](docs/ConfigurationTemplateConfigurationApi.md#get_attached_config) | **GET** /template/config/attached/{deviceId} | 
*ConfigurationTemplateConfigurationApi* | [**get_compatible_devices**](docs/ConfigurationTemplateConfigurationApi.md#get_compatible_devices) | **GET** /template/config/rmalist/{oldDeviceId} | 
*ConfigurationTemplateConfigurationApi* | [**get_device_diff**](docs/ConfigurationTemplateConfigurationApi.md#get_device_diff) | **GET** /template/config/diff/{deviceId} | 
*ConfigurationTemplateConfigurationApi* | [**get_running_config**](docs/ConfigurationTemplateConfigurationApi.md#get_running_config) | **GET** /template/config/running/{deviceId} | 
*ConfigurationTemplateConfigurationApi* | [**get_vpn_for_device**](docs/ConfigurationTemplateConfigurationApi.md#get_vpn_for_device) | **GET** /template/config/vpn/{deviceId} | 
*ConfigurationTemplateConfigurationApi* | [**rma_update**](docs/ConfigurationTemplateConfigurationApi.md#rma_update) | **PUT** /template/config/rmaupdate | 
*ConfigurationTemplateConfigurationApi* | [**update_device_to_cli_mode**](docs/ConfigurationTemplateConfigurationApi.md#update_device_to_cli_mode) | **POST** /template/config/device/mode/cli | 
*ConfigurationTemplateConfigurationApi* | [**upload_config**](docs/ConfigurationTemplateConfigurationApi.md#upload_config) | **PUT** /template/config/attach/{deviceId} | 
*ConfigurationTemplateLockApi* | [**remove_lock**](docs/ConfigurationTemplateLockApi.md#remove_lock) | **DELETE** /template/lock/{processId} | 
*ConfigurationTemplateLockApi* | [**update_lease_time**](docs/ConfigurationTemplateLockApi.md#update_lease_time) | **PUT** /template/lock/{processId} | 
*ConfigurationTemplateMasterApi* | [**change_template_resource_group1**](docs/ConfigurationTemplateMasterApi.md#change_template_resource_group1) | **POST** /template/device/resource-group/{resourceGroupName}/{templateId} | 
*ConfigurationTemplateMasterApi* | [**create_cli_template**](docs/ConfigurationTemplateMasterApi.md#create_cli_template) | **POST** /template/device/cli | 
*ConfigurationTemplateMasterApi* | [**create_master_template**](docs/ConfigurationTemplateMasterApi.md#create_master_template) | **POST** /template/device/feature | 
*ConfigurationTemplateMasterApi* | [**delete_master_template**](docs/ConfigurationTemplateMasterApi.md#delete_master_template) | **DELETE** /template/device/{templateId} | 
*ConfigurationTemplateMasterApi* | [**edit_master_template**](docs/ConfigurationTemplateMasterApi.md#edit_master_template) | **PUT** /template/device/{templateId} | 
*ConfigurationTemplateMasterApi* | [**generate_master_template_list**](docs/ConfigurationTemplateMasterApi.md#generate_master_template_list) | **GET** /template/device | 
*ConfigurationTemplateMasterApi* | [**generate_template_for_migration**](docs/ConfigurationTemplateMasterApi.md#generate_template_for_migration) | **GET** /template/device/migration | 
*ConfigurationTemplateMasterApi* | [**get_master_template_definition**](docs/ConfigurationTemplateMasterApi.md#get_master_template_definition) | **GET** /template/device/object/{templateId} | 
*ConfigurationTemplateMasterApi* | [**get_out_of_sync_devices**](docs/ConfigurationTemplateMasterApi.md#get_out_of_sync_devices) | **GET** /template/device/syncstatus/{templateId} | 
*ConfigurationTemplateMasterApi* | [**get_out_of_sync_templates**](docs/ConfigurationTemplateMasterApi.md#get_out_of_sync_templates) | **GET** /template/device/syncstatus | 
*ConfigurationTemplateMasterApi* | [**is_migration_required**](docs/ConfigurationTemplateMasterApi.md#is_migration_required) | **GET** /template/device/is_migration_required | 
*ConfigurationTemplateMasterApi* | [**migrate_templates**](docs/ConfigurationTemplateMasterApi.md#migrate_templates) | **POST** /template/device/migration | 
*ConfigurationTemplateMasterApi* | [**migration_info**](docs/ConfigurationTemplateMasterApi.md#migration_info) | **GET** /template/device/migration_info | 
*ConfigurationTopologyApi* | [**create_device_topology**](docs/ConfigurationTopologyApi.md#create_device_topology) | **GET** /topology/device | 
*ConfigurationTopologyApi* | [**create_full_topology**](docs/ConfigurationTopologyApi.md#create_full_topology) | **GET** /topology | 
*ConfigurationTopologyApi* | [**create_physical_topology**](docs/ConfigurationTopologyApi.md#create_physical_topology) | **GET** /topology/physical | 
*ConfigurationTopologyApi* | [**get_site_topology**](docs/ConfigurationTopologyApi.md#get_site_topology) | **GET** /topology/device/site/{siteId} | 
*ConfigurationVoiceTemplatePolicyApi* | [**create_voice_template**](docs/ConfigurationVoiceTemplatePolicyApi.md#create_voice_template) | **POST** /template/policy/voice | 
*ConfigurationVoiceTemplatePolicyApi* | [**delete_voice_template**](docs/ConfigurationVoiceTemplatePolicyApi.md#delete_voice_template) | **DELETE** /template/policy/voice/{policyId} | 
*ConfigurationVoiceTemplatePolicyApi* | [**edit_voice_template**](docs/ConfigurationVoiceTemplatePolicyApi.md#edit_voice_template) | **PUT** /template/policy/voice/{policyId} | 
*ConfigurationVoiceTemplatePolicyApi* | [**generate_voice_policy_summary**](docs/ConfigurationVoiceTemplatePolicyApi.md#generate_voice_policy_summary) | **GET** /template/policy/voice/summary | 
*ConfigurationVoiceTemplatePolicyApi* | [**generate_voice_template_list**](docs/ConfigurationVoiceTemplatePolicyApi.md#generate_voice_template_list) | **GET** /template/policy/voice | 
*ConfigurationVoiceTemplatePolicyApi* | [**get_device_list_by_policy_id**](docs/ConfigurationVoiceTemplatePolicyApi.md#get_device_list_by_policy_id) | **GET** /template/policy/voice/devices/{policyId} | 
*ConfigurationVoiceTemplatePolicyApi* | [**get_template_by_id**](docs/ConfigurationVoiceTemplatePolicyApi.md#get_template_by_id) | **GET** /template/policy/voice/definition/{policyId} | 
*ConfigurationVoiceTemplatePolicyApi* | [**get_voice_policy_device_list**](docs/ConfigurationVoiceTemplatePolicyApi.md#get_voice_policy_device_list) | **GET** /template/policy/voice/devices | 
*ConfigurationVoiceTemplatePolicyApi* | [**get_voice_templates_for_device**](docs/ConfigurationVoiceTemplatePolicyApi.md#get_voice_templates_for_device) | **GET** /template/policy/voice/{deviceModel} | 
*ConfigurationVEdgeTemplatePolicyApi* | [**change_policy_resource_group**](docs/ConfigurationVEdgeTemplatePolicyApi.md#change_policy_resource_group) | **POST** /template/policy/vedge/{resourceGroupName}/{policyId} | 
*ConfigurationVEdgeTemplatePolicyApi* | [**create_v_edge_template**](docs/ConfigurationVEdgeTemplatePolicyApi.md#create_v_edge_template) | **POST** /template/policy/vedge | 
*ConfigurationVEdgeTemplatePolicyApi* | [**delete_v_edge_template**](docs/ConfigurationVEdgeTemplatePolicyApi.md#delete_v_edge_template) | **DELETE** /template/policy/vedge/{policyId} | 
*ConfigurationVEdgeTemplatePolicyApi* | [**edit_v_edge_template**](docs/ConfigurationVEdgeTemplatePolicyApi.md#edit_v_edge_template) | **PUT** /template/policy/vedge/{policyId} | 
*ConfigurationVEdgeTemplatePolicyApi* | [**generate_policy_template_list**](docs/ConfigurationVEdgeTemplatePolicyApi.md#generate_policy_template_list) | **GET** /template/policy/vedge | 
*ConfigurationVEdgeTemplatePolicyApi* | [**get_device_list_by_policy**](docs/ConfigurationVEdgeTemplatePolicyApi.md#get_device_list_by_policy) | **GET** /template/policy/vedge/devices/{policyId} | 
*ConfigurationVEdgeTemplatePolicyApi* | [**get_v_edge_policy_device_list**](docs/ConfigurationVEdgeTemplatePolicyApi.md#get_v_edge_policy_device_list) | **GET** /template/policy/vedge/devices | 
*ConfigurationVEdgeTemplatePolicyApi* | [**get_v_edge_template**](docs/ConfigurationVEdgeTemplatePolicyApi.md#get_v_edge_template) | **GET** /template/policy/vedge/definition/{policyId} | 
*ConfigurationVSmartTemplatePolicyApi* | [**activate_policy**](docs/ConfigurationVSmartTemplatePolicyApi.md#activate_policy) | **POST** /template/policy/vsmart/activate/{policyId} | 
*ConfigurationVSmartTemplatePolicyApi* | [**activate_policy_for_cloud_services**](docs/ConfigurationVSmartTemplatePolicyApi.md#activate_policy_for_cloud_services) | **POST** /template/policy/vsmart/activate/central/{policyId} | 
*ConfigurationVSmartTemplatePolicyApi* | [**check_v_smart_connectivity_status**](docs/ConfigurationVSmartTemplatePolicyApi.md#check_v_smart_connectivity_status) | **GET** /template/policy/vsmart/connectivity/status | 
*ConfigurationVSmartTemplatePolicyApi* | [**create_v_smart_template**](docs/ConfigurationVSmartTemplatePolicyApi.md#create_v_smart_template) | **POST** /template/policy/vsmart | 
*ConfigurationVSmartTemplatePolicyApi* | [**de_activate_policy**](docs/ConfigurationVSmartTemplatePolicyApi.md#de_activate_policy) | **POST** /template/policy/vsmart/deactivate/{policyId} | 
*ConfigurationVSmartTemplatePolicyApi* | [**delete_v_smart_template**](docs/ConfigurationVSmartTemplatePolicyApi.md#delete_v_smart_template) | **DELETE** /template/policy/vsmart/{policyId} | 
*ConfigurationVSmartTemplatePolicyApi* | [**edit_template_without_lock_checks**](docs/ConfigurationVSmartTemplatePolicyApi.md#edit_template_without_lock_checks) | **PUT** /template/policy/vsmart/central/{policyId} | 
*ConfigurationVSmartTemplatePolicyApi* | [**edit_v_smart_template**](docs/ConfigurationVSmartTemplatePolicyApi.md#edit_v_smart_template) | **PUT** /template/policy/vsmart/{policyId} | 
*ConfigurationVSmartTemplatePolicyApi* | [**generate_v_smart_policy_template_list**](docs/ConfigurationVSmartTemplatePolicyApi.md#generate_v_smart_policy_template_list) | **GET** /template/policy/vsmart | 
*ConfigurationVSmartTemplatePolicyApi* | [**get_template_by_policy_id**](docs/ConfigurationVSmartTemplatePolicyApi.md#get_template_by_policy_id) | **GET** /template/policy/vsmart/definition/{policyId} | 
*ConfigurationVSmartTemplatePolicyApi* | [**qosmos_nbar_migration_warning**](docs/ConfigurationVSmartTemplatePolicyApi.md#qosmos_nbar_migration_warning) | **GET** /template/policy/vsmart/qosmos_nbar_migration_warning | 
*DataCollectionAgentApi* | [**create_dca_analytics_data_file**](docs/DataCollectionAgentApi.md#create_dca_analytics_data_file) | **POST** /dca/settings/configuration/{type}/dca | 
*DataCollectionAgentApi* | [**create_stats**](docs/DataCollectionAgentApi.md#create_stats) | **PUT** /dca/analytics | 
*DataCollectionAgentApi* | [**generate_alarm**](docs/DataCollectionAgentApi.md#generate_alarm) | **POST** /dca/cloudservices/alarm | 
*DataCollectionAgentApi* | [**generate_dca_device_state_data**](docs/DataCollectionAgentApi.md#generate_dca_device_state_data) | **POST** /dca/data/device/state/{state_data_type} | 
*DataCollectionAgentApi* | [**generate_dca_device_statistics_data**](docs/DataCollectionAgentApi.md#generate_dca_device_statistics_data) | **POST** /dca/data/device/statistics/{stats_data_type} | 
*DataCollectionAgentApi* | [**get_access_token**](docs/DataCollectionAgentApi.md#get_access_token) | **GET** /dca/cloudservices/accesstoken | 
*DataCollectionAgentApi* | [**get_all_stats_data_dca**](docs/DataCollectionAgentApi.md#get_all_stats_data_dca) | **POST** /dca/analytics/all | 
*DataCollectionAgentApi* | [**get_cloud_services_configuration_dca**](docs/DataCollectionAgentApi.md#get_cloud_services_configuration_dca) | **GET** /dca/settings/configuration/cloudservices/dca | 
*DataCollectionAgentApi* | [**get_crash_logs**](docs/DataCollectionAgentApi.md#get_crash_logs) | **POST** /dca/device/crashlog/details | 
*DataCollectionAgentApi* | [**get_crash_logs_synced**](docs/DataCollectionAgentApi.md#get_crash_logs_synced) | **GET** /dca/device/crashlog/synced | 
*DataCollectionAgentApi* | [**get_dca_attached_config_to_device**](docs/DataCollectionAgentApi.md#get_dca_attached_config_to_device) | **POST** /dca/template/device/config/attachedconfig | 
*DataCollectionAgentApi* | [**get_dca_tenant_owners**](docs/DataCollectionAgentApi.md#get_dca_tenant_owners) | **GET** /dca/dcatenantowners | 
*DataCollectionAgentApi* | [**get_devices_details_dca**](docs/DataCollectionAgentApi.md#get_devices_details_dca) | **POST** /dca/system/device | 
*DataCollectionAgentApi* | [**get_id_token**](docs/DataCollectionAgentApi.md#get_id_token) | **GET** /dca/cloudservices/idtoken | 
*DataCollectionAgentApi* | [**get_stats_db_index_status**](docs/DataCollectionAgentApi.md#get_stats_db_index_status) | **POST** /dca/statistics/settings/status | 
*DataCollectionAgentApi* | [**get_telemetry_settings**](docs/DataCollectionAgentApi.md#get_telemetry_settings) | **GET** /dca/cloudservices/telemetry | 
*DataCollectionAgentApi* | [**get_template_policy_definitions_dca**](docs/DataCollectionAgentApi.md#get_template_policy_definitions_dca) | **POST** /dca/template/policy/definition/approute | 
*DataCollectionAgentApi* | [**get_vedge_template_list_dca**](docs/DataCollectionAgentApi.md#get_vedge_template_list_dca) | **POST** /dca/template/policy/vedge | 
*DataCollectionAgentApi* | [**get_vpn_lists_dca**](docs/DataCollectionAgentApi.md#get_vpn_lists_dca) | **POST** /dca/template/policy/list/vpn | 
*DataCollectionAgentApi* | [**get_vsmart_template_list_dca**](docs/DataCollectionAgentApi.md#get_vsmart_template_list_dca) | **POST** /dca/template/policy/vsmart | 
*DataCollectionAgentApi* | [**list_all_devices_dca**](docs/DataCollectionAgentApi.md#list_all_devices_dca) | **POST** /dca/device | 
*DataCollectionAgentApi* | [**store_access_token**](docs/DataCollectionAgentApi.md#store_access_token) | **POST** /dca/cloudservices/accesstoken | 
*DataCollectionAgentApi* | [**store_id_token**](docs/DataCollectionAgentApi.md#store_id_token) | **POST** /dca/cloudservices/idtoken | 
*DeploymentModeApi* | [**config_fedramp_mode**](docs/DeploymentModeApi.md#config_fedramp_mode) | **POST** /fedramp/status | 
*DeploymentModeApi* | [**configure_dns_sec**](docs/DeploymentModeApi.md#configure_dns_sec) | **POST** /fedramp/dnssec/config | 
*DeploymentModeApi* | [**configure_wazuh_client**](docs/DeploymentModeApi.md#configure_wazuh_client) | **POST** /fedramp/wazuh/config | 
*DeploymentModeApi* | [**get_dns_sec_status**](docs/DeploymentModeApi.md#get_dns_sec_status) | **GET** /fedramp/dnssec/status | 
*DeploymentModeApi* | [**get_wazuh_agent_status**](docs/DeploymentModeApi.md#get_wazuh_agent_status) | **GET** /fedramp/wazuh/status | 
*DeploymentModeApi* | [**reques_dns_sec_actions**](docs/DeploymentModeApi.md#reques_dns_sec_actions) | **GET** /fedramp/dnssec/actions | 
*DeploymentModeApi* | [**request_wazuh_actions**](docs/DeploymentModeApi.md#request_wazuh_actions) | **GET** /fedramp/wazuh/actions | 
*DeviceMessagingApi* | [**create_device_vmanage_connection_list**](docs/DeviceMessagingApi.md#create_device_vmanage_connection_list) | **GET** /messaging/device/vmanage | 
*DeviceNetworkApi* | [**get_network_issues_summary**](docs/DeviceNetworkApi.md#get_network_issues_summary) | **GET** /network/issues/summary | 
*DeviceNetworkApi* | [**get_network_status_summary**](docs/DeviceNetworkApi.md#get_network_status_summary) | **GET** /network/status | 
*DeviceNetworkApi* | [**get_reboot_count**](docs/DeviceNetworkApi.md#get_reboot_count) | **GET** /network/issues/rebootcount | 
*DeviceNetworkApi* | [**get_vmanage_control_status**](docs/DeviceNetworkApi.md#get_vmanage_control_status) | **GET** /network/connectionssummary | 
*LocaleApi* | [**get_supported_locales**](docs/LocaleApi.md#get_supported_locales) | **GET** /localization/supportedLocales | 
*MDPConfigObjectApi* | [**retrieve_mdp_config_object**](docs/MDPConfigObjectApi.md#retrieve_mdp_config_object) | **GET** /mdp/policies/mdpconfig/{deviceId} | 
*MDPDeviceSharingApi* | [**attach_devices**](docs/MDPDeviceSharingApi.md#attach_devices) | **POST** /mdp/attachDevices/{nmsId} | 
*MDPDeviceSharingApi* | [**detach_devices**](docs/MDPDeviceSharingApi.md#detach_devices) | **POST** /mdp/detachDevices/{nmsId} | 
*MDPDeviceSharingApi* | [**edit_attached_devices**](docs/MDPDeviceSharingApi.md#edit_attached_devices) | **PUT** /mdp/attachDevices/{nmsId} | 
*MDPDeviceSharingApi* | [**retrieve_mdp_attached_devices**](docs/MDPDeviceSharingApi.md#retrieve_mdp_attached_devices) | **GET** /mdp/attachDevices/{nmsId} | 
*MDPDeviceSharingApi* | [**retrieve_mdp_supported_devices_**](docs/MDPDeviceSharingApi.md#retrieve_mdp_supported_devices_) | **GET** /mdp/devices/{nmsId} | 
*MDPInternalPolicyManagementApi* | [**add_internal_policy**](docs/MDPInternalPolicyManagementApi.md#add_internal_policy) | **PUT** /mdp/policies/mdpconfig | 
*MDPOffboardingApi* | [**disconnect_from_mdp**](docs/MDPOffboardingApi.md#disconnect_from_mdp) | **GET** /mdp/disconnect/{nmsId} | 
*MDPOffboardingApi* | [**offboard**](docs/MDPOffboardingApi.md#offboard) | **DELETE** /mdp/onboard/{nmsId} | 
*MDPOnboardingApi* | [**get_mdp_onboarding_status**](docs/MDPOnboardingApi.md#get_mdp_onboarding_status) | **GET** /mdp/onboard/status | 
*MDPOnboardingApi* | [**onboard_mdp**](docs/MDPOnboardingApi.md#onboard_mdp) | **POST** /mdp/onboard | 
*MDPOnboardingApi* | [**update_onboarding_payload**](docs/MDPOnboardingApi.md#update_onboarding_payload) | **PUT** /mdp/onboard/{nmsId} | 
*MDPPolicyManagementApi* | [**retrieve_mdp_policies**](docs/MDPPolicyManagementApi.md#retrieve_mdp_policies) | **GET** /mdp/policies/{nmsId} | 
*MDPPolicyManagementApi* | [**update_policy_status**](docs/MDPPolicyManagementApi.md#update_policy_status) | **PUT** /mdp/policies/{nmsId} | 
*MSLAApi* | [**get_all_template**](docs/MSLAApi.md#get_all_template) | **GET** /msla/template | 
*MSLAApi* | [**get_license_and_device_count**](docs/MSLAApi.md#get_license_and_device_count) | **GET** /msla/monitoring/licensedDeviceCount | 
*MSLAApi* | [**get_license_and_device_count1**](docs/MSLAApi.md#get_license_and_device_count1) | **GET** /msla/monitoring/licensedDistributionDetails | 
*MSLAApi* | [**get_msla_devices**](docs/MSLAApi.md#get_msla_devices) | **GET** /msla/devices | 
*MSLAApi* | [**get_packaging_distribution_details**](docs/MSLAApi.md#get_packaging_distribution_details) | **GET** /msla/monitoring/packagingDistributionDetails | 
*MSLAApi* | [**get_subscriptions**](docs/MSLAApi.md#get_subscriptions) | **GET** /msla/va/License | 
*MSLAApi* | [**get_subscriptions1**](docs/MSLAApi.md#get_subscriptions1) | **POST** /msla/template/licenses | 
*MSLAApi* | [**sync_licenses2**](docs/MSLAApi.md#sync_licenses2) | **POST** /msla/licenses/sync | 
*MonitoringARTApi* | [**get_aggregation_data_by_query3**](docs/MonitoringARTApi.md#get_aggregation_data_by_query3) | **GET** /statistics/art/aggregation | 
*MonitoringARTApi* | [**get_count5**](docs/MonitoringARTApi.md#get_count5) | **GET** /statistics/art/doccount | 
*MonitoringARTApi* | [**get_count_post5**](docs/MonitoringARTApi.md#get_count_post5) | **POST** /statistics/art/doccount | 
*MonitoringARTApi* | [**get_post_aggregation_app_data_by_query3**](docs/MonitoringARTApi.md#get_post_aggregation_app_data_by_query3) | **POST** /statistics/art/app-agg/aggregation | 
*MonitoringARTApi* | [**get_post_aggregation_data_by_query3**](docs/MonitoringARTApi.md#get_post_aggregation_data_by_query3) | **POST** /statistics/art/aggregation | 
*MonitoringARTApi* | [**get_post_stat_bulk_raw_data3**](docs/MonitoringARTApi.md#get_post_stat_bulk_raw_data3) | **POST** /statistics/art/page | 
*MonitoringARTApi* | [**get_stat_bulk_raw_data3**](docs/MonitoringARTApi.md#get_stat_bulk_raw_data3) | **GET** /statistics/art/page | 
*MonitoringARTApi* | [**get_stat_data_fields5**](docs/MonitoringARTApi.md#get_stat_data_fields5) | **GET** /statistics/art/fields | 
*MonitoringARTApi* | [**get_stat_data_raw_data3**](docs/MonitoringARTApi.md#get_stat_data_raw_data3) | **GET** /statistics/art | 
*MonitoringARTApi* | [**get_stat_data_raw_data_as_csv3**](docs/MonitoringARTApi.md#get_stat_data_raw_data_as_csv3) | **GET** /statistics/art/csv | 
*MonitoringARTApi* | [**get_stat_query_fields5**](docs/MonitoringARTApi.md#get_stat_query_fields5) | **GET** /statistics/art/query/fields | 
*MonitoringARTApi* | [**get_stats_raw_data3**](docs/MonitoringARTApi.md#get_stats_raw_data3) | **POST** /statistics/art | 
*MonitoringAlarmsDetailsApi* | [**clear_stale_alarm**](docs/MonitoringAlarmsDetailsApi.md#clear_stale_alarm) | **POST** /alarms/clear | 
*MonitoringAlarmsDetailsApi* | [**correl_anti_entropy**](docs/MonitoringAlarmsDetailsApi.md#correl_anti_entropy) | **GET** /alarms/reset | 
*MonitoringAlarmsDetailsApi* | [**create_alarm_query_config**](docs/MonitoringAlarmsDetailsApi.md#create_alarm_query_config) | **GET** /alarms/query/input | 
*MonitoringAlarmsDetailsApi* | [**create_notification_rule**](docs/MonitoringAlarmsDetailsApi.md#create_notification_rule) | **POST** /notifications/rule | 
*MonitoringAlarmsDetailsApi* | [**delete_notification_rule**](docs/MonitoringAlarmsDetailsApi.md#delete_notification_rule) | **DELETE** /notifications/rules | 
*MonitoringAlarmsDetailsApi* | [**disable_enable_alarm**](docs/MonitoringAlarmsDetailsApi.md#disable_enable_alarm) | **POST** /alarms/disabled | 
*MonitoringAlarmsDetailsApi* | [**dump_correlation_engine_data**](docs/MonitoringAlarmsDetailsApi.md#dump_correlation_engine_data) | **POST** /alarms/dump | 
*MonitoringAlarmsDetailsApi* | [**enable_disable_link_state_alarm**](docs/MonitoringAlarmsDetailsApi.md#enable_disable_link_state_alarm) | **POST** /alarms/link-state-alarm | 
*MonitoringAlarmsDetailsApi* | [**get_alarm_aggregation_data**](docs/MonitoringAlarmsDetailsApi.md#get_alarm_aggregation_data) | **GET** /alarms/aggregation | 
*MonitoringAlarmsDetailsApi* | [**get_alarm_details**](docs/MonitoringAlarmsDetailsApi.md#get_alarm_details) | **GET** /alarms/uuid/{alarm_uuid} | 
*MonitoringAlarmsDetailsApi* | [**get_alarm_severity_custom_histogram**](docs/MonitoringAlarmsDetailsApi.md#get_alarm_severity_custom_histogram) | **GET** /alarms/severity/summary | 
*MonitoringAlarmsDetailsApi* | [**get_alarm_severity_mappings**](docs/MonitoringAlarmsDetailsApi.md#get_alarm_severity_mappings) | **GET** /alarms/severitymappings | 
*MonitoringAlarmsDetailsApi* | [**get_alarm_types_as_key_value**](docs/MonitoringAlarmsDetailsApi.md#get_alarm_types_as_key_value) | **GET** /alarms/rulenamedisplay/keyvalue | 
*MonitoringAlarmsDetailsApi* | [**get_alarms**](docs/MonitoringAlarmsDetailsApi.md#get_alarms) | **GET** /alarms | 
*MonitoringAlarmsDetailsApi* | [**get_alarms_by_severity**](docs/MonitoringAlarmsDetailsApi.md#get_alarms_by_severity) | **GET** /alarms/severity | 
*MonitoringAlarmsDetailsApi* | [**get_count1**](docs/MonitoringAlarmsDetailsApi.md#get_count1) | **GET** /alarms/doccount | 
*MonitoringAlarmsDetailsApi* | [**get_count_post1**](docs/MonitoringAlarmsDetailsApi.md#get_count_post1) | **POST** /alarms/doccount | 
*MonitoringAlarmsDetailsApi* | [**get_device_topic**](docs/MonitoringAlarmsDetailsApi.md#get_device_topic) | **GET** /alarms/topic | 
*MonitoringAlarmsDetailsApi* | [**get_link_state_alarm_config**](docs/MonitoringAlarmsDetailsApi.md#get_link_state_alarm_config) | **GET** /alarms/link-state-alarm | 
*MonitoringAlarmsDetailsApi* | [**get_master_manager_state**](docs/MonitoringAlarmsDetailsApi.md#get_master_manager_state) | **GET** /alarms/master | 
*MonitoringAlarmsDetailsApi* | [**get_non_viewed_active_alarms_count**](docs/MonitoringAlarmsDetailsApi.md#get_non_viewed_active_alarms_count) | **GET** /alarms/count | 
*MonitoringAlarmsDetailsApi* | [**get_non_viewed_alarms**](docs/MonitoringAlarmsDetailsApi.md#get_non_viewed_alarms) | **GET** /alarms/notviewed | 
*MonitoringAlarmsDetailsApi* | [**get_notification_rule**](docs/MonitoringAlarmsDetailsApi.md#get_notification_rule) | **GET** /notifications/rules | 
*MonitoringAlarmsDetailsApi* | [**get_post_alarm_aggregation_data**](docs/MonitoringAlarmsDetailsApi.md#get_post_alarm_aggregation_data) | **POST** /alarms/aggregation | 
*MonitoringAlarmsDetailsApi* | [**get_post_stat_bulk_alarm_raw_data**](docs/MonitoringAlarmsDetailsApi.md#get_post_stat_bulk_alarm_raw_data) | **POST** /alarms/page | 
*MonitoringAlarmsDetailsApi* | [**get_raw_alarm_data**](docs/MonitoringAlarmsDetailsApi.md#get_raw_alarm_data) | **POST** /alarms | 
*MonitoringAlarmsDetailsApi* | [**get_stat_bulk_alarm_raw_data**](docs/MonitoringAlarmsDetailsApi.md#get_stat_bulk_alarm_raw_data) | **GET** /alarms/page | 
*MonitoringAlarmsDetailsApi* | [**get_stat_data_fields1**](docs/MonitoringAlarmsDetailsApi.md#get_stat_data_fields1) | **GET** /alarms/fields | 
*MonitoringAlarmsDetailsApi* | [**get_stat_query_fields1**](docs/MonitoringAlarmsDetailsApi.md#get_stat_query_fields1) | **GET** /alarms/query/fields | 
*MonitoringAlarmsDetailsApi* | [**get_stats**](docs/MonitoringAlarmsDetailsApi.md#get_stats) | **GET** /alarms/stats | 
*MonitoringAlarmsDetailsApi* | [**list_disabled_alarm**](docs/MonitoringAlarmsDetailsApi.md#list_disabled_alarm) | **GET** /alarms/disabled | 
*MonitoringAlarmsDetailsApi* | [**mark_alarms_as_viewed**](docs/MonitoringAlarmsDetailsApi.md#mark_alarms_as_viewed) | **POST** /alarms/markviewed | 
*MonitoringAlarmsDetailsApi* | [**mark_all_alarms_as_viewed**](docs/MonitoringAlarmsDetailsApi.md#mark_all_alarms_as_viewed) | **POST** /alarms/markallasviewed | 
*MonitoringAlarmsDetailsApi* | [**restart_correlation_engine**](docs/MonitoringAlarmsDetailsApi.md#restart_correlation_engine) | **GET** /alarms/restart | 
*MonitoringAlarmsDetailsApi* | [**set_periodic_purge_timer**](docs/MonitoringAlarmsDetailsApi.md#set_periodic_purge_timer) | **GET** /alarms/purgefrequency | 
*MonitoringAlarmsDetailsApi* | [**start_tracking**](docs/MonitoringAlarmsDetailsApi.md#start_tracking) | **POST** /alarms/starttracking/{testName} | 
*MonitoringAlarmsDetailsApi* | [**stop_tracking**](docs/MonitoringAlarmsDetailsApi.md#stop_tracking) | **POST** /alarms/stoptracking/{testName} | 
*MonitoringAlarmsDetailsApi* | [**update_notification_rule**](docs/MonitoringAlarmsDetailsApi.md#update_notification_rule) | **PUT** /notifications/rule | 
*MonitoringAppHostingApi* | [**get_aggregation_data_by_query1**](docs/MonitoringAppHostingApi.md#get_aggregation_data_by_query1) | **GET** /statistics/apphosting/aggregation | 
*MonitoringAppHostingApi* | [**get_count3**](docs/MonitoringAppHostingApi.md#get_count3) | **GET** /statistics/apphosting/doccount | 
*MonitoringAppHostingApi* | [**get_count_post3**](docs/MonitoringAppHostingApi.md#get_count_post3) | **POST** /statistics/apphosting/doccount | 
*MonitoringAppHostingApi* | [**get_post_aggregation_app_data_by_query1**](docs/MonitoringAppHostingApi.md#get_post_aggregation_app_data_by_query1) | **POST** /statistics/apphosting/app-agg/aggregation | 
*MonitoringAppHostingApi* | [**get_post_aggregation_data_by_query1**](docs/MonitoringAppHostingApi.md#get_post_aggregation_data_by_query1) | **POST** /statistics/apphosting/aggregation | 
*MonitoringAppHostingApi* | [**get_post_stat_bulk_raw_data1**](docs/MonitoringAppHostingApi.md#get_post_stat_bulk_raw_data1) | **POST** /statistics/apphosting/page | 
*MonitoringAppHostingApi* | [**get_stat_bulk_raw_data1**](docs/MonitoringAppHostingApi.md#get_stat_bulk_raw_data1) | **GET** /statistics/apphosting/page | 
*MonitoringAppHostingApi* | [**get_stat_data_fields3**](docs/MonitoringAppHostingApi.md#get_stat_data_fields3) | **GET** /statistics/apphosting/fields | 
*MonitoringAppHostingApi* | [**get_stat_data_raw_data1**](docs/MonitoringAppHostingApi.md#get_stat_data_raw_data1) | **GET** /statistics/apphosting | 
*MonitoringAppHostingApi* | [**get_stat_data_raw_data_as_csv1**](docs/MonitoringAppHostingApi.md#get_stat_data_raw_data_as_csv1) | **GET** /statistics/apphosting/csv | 
*MonitoringAppHostingApi* | [**get_stat_query_fields3**](docs/MonitoringAppHostingApi.md#get_stat_query_fields3) | **GET** /statistics/apphosting/query/fields | 
*MonitoringAppHostingApi* | [**get_stats_raw_data1**](docs/MonitoringAppHostingApi.md#get_stats_raw_data1) | **POST** /statistics/apphosting | 
*MonitoringAppHostingInterfaceApi* | [**get_aggregation_data_by_query**](docs/MonitoringAppHostingInterfaceApi.md#get_aggregation_data_by_query) | **GET** /statistics/apphostinginterface/aggregation | 
*MonitoringAppHostingInterfaceApi* | [**get_count2**](docs/MonitoringAppHostingInterfaceApi.md#get_count2) | **GET** /statistics/apphostinginterface/doccount | 
*MonitoringAppHostingInterfaceApi* | [**get_count_post2**](docs/MonitoringAppHostingInterfaceApi.md#get_count_post2) | **POST** /statistics/apphostinginterface/doccount | 
*MonitoringAppHostingInterfaceApi* | [**get_post_aggregation_app_data_by_query**](docs/MonitoringAppHostingInterfaceApi.md#get_post_aggregation_app_data_by_query) | **POST** /statistics/apphostinginterface/app-agg/aggregation | 
*MonitoringAppHostingInterfaceApi* | [**get_post_aggregation_data_by_query**](docs/MonitoringAppHostingInterfaceApi.md#get_post_aggregation_data_by_query) | **POST** /statistics/apphostinginterface/aggregation | 
*MonitoringAppHostingInterfaceApi* | [**get_post_stat_bulk_raw_data**](docs/MonitoringAppHostingInterfaceApi.md#get_post_stat_bulk_raw_data) | **POST** /statistics/apphostinginterface/page | 
*MonitoringAppHostingInterfaceApi* | [**get_stat_bulk_raw_data**](docs/MonitoringAppHostingInterfaceApi.md#get_stat_bulk_raw_data) | **GET** /statistics/apphostinginterface/page | 
*MonitoringAppHostingInterfaceApi* | [**get_stat_data_fields2**](docs/MonitoringAppHostingInterfaceApi.md#get_stat_data_fields2) | **GET** /statistics/apphostinginterface/fields | 
*MonitoringAppHostingInterfaceApi* | [**get_stat_data_raw_data**](docs/MonitoringAppHostingInterfaceApi.md#get_stat_data_raw_data) | **GET** /statistics/apphostinginterface | 
*MonitoringAppHostingInterfaceApi* | [**get_stat_data_raw_data_as_csv**](docs/MonitoringAppHostingInterfaceApi.md#get_stat_data_raw_data_as_csv) | **GET** /statistics/apphostinginterface/csv | 
*MonitoringAppHostingInterfaceApi* | [**get_stat_query_fields2**](docs/MonitoringAppHostingInterfaceApi.md#get_stat_query_fields2) | **GET** /statistics/apphostinginterface/query/fields | 
*MonitoringAppHostingInterfaceApi* | [**get_stats_raw_data**](docs/MonitoringAppHostingInterfaceApi.md#get_stats_raw_data) | **POST** /statistics/apphostinginterface | 
*MonitoringApplicationAwareRoutingApi* | [**get_aggregation_data_app_route**](docs/MonitoringApplicationAwareRoutingApi.md#get_aggregation_data_app_route) | **POST** /statistics/approute/fec/aggregation | 
*MonitoringApplicationAwareRoutingApi* | [**get_aggregation_data_by_query2**](docs/MonitoringApplicationAwareRoutingApi.md#get_aggregation_data_by_query2) | **GET** /statistics/approute/aggregation | 
*MonitoringApplicationAwareRoutingApi* | [**get_approute_grid_stat**](docs/MonitoringApplicationAwareRoutingApi.md#get_approute_grid_stat) | **GET** /statistics/approute/device/tunnel/summary | 
*MonitoringApplicationAwareRoutingApi* | [**get_count4**](docs/MonitoringApplicationAwareRoutingApi.md#get_count4) | **GET** /statistics/approute/doccount | 
*MonitoringApplicationAwareRoutingApi* | [**get_count_post4**](docs/MonitoringApplicationAwareRoutingApi.md#get_count_post4) | **POST** /statistics/approute/doccount | 
*MonitoringApplicationAwareRoutingApi* | [**get_post_aggregation_app_data_by_query2**](docs/MonitoringApplicationAwareRoutingApi.md#get_post_aggregation_app_data_by_query2) | **POST** /statistics/approute/app-agg/aggregation | 
*MonitoringApplicationAwareRoutingApi* | [**get_post_aggregation_data_by_query2**](docs/MonitoringApplicationAwareRoutingApi.md#get_post_aggregation_data_by_query2) | **POST** /statistics/approute/aggregation | 
*MonitoringApplicationAwareRoutingApi* | [**get_post_stat_bulk_raw_data2**](docs/MonitoringApplicationAwareRoutingApi.md#get_post_stat_bulk_raw_data2) | **POST** /statistics/approute/page | 
*MonitoringApplicationAwareRoutingApi* | [**get_stat_bulk_raw_data2**](docs/MonitoringApplicationAwareRoutingApi.md#get_stat_bulk_raw_data2) | **GET** /statistics/approute/page | 
*MonitoringApplicationAwareRoutingApi* | [**get_stat_data_fields4**](docs/MonitoringApplicationAwareRoutingApi.md#get_stat_data_fields4) | **GET** /statistics/approute/fields | 
*MonitoringApplicationAwareRoutingApi* | [**get_stat_data_raw_data2**](docs/MonitoringApplicationAwareRoutingApi.md#get_stat_data_raw_data2) | **GET** /statistics/approute | 
*MonitoringApplicationAwareRoutingApi* | [**get_stat_data_raw_data_as_csv2**](docs/MonitoringApplicationAwareRoutingApi.md#get_stat_data_raw_data_as_csv2) | **GET** /statistics/approute/csv | 
*MonitoringApplicationAwareRoutingApi* | [**get_stat_query_fields4**](docs/MonitoringApplicationAwareRoutingApi.md#get_stat_query_fields4) | **GET** /statistics/approute/query/fields | 
*MonitoringApplicationAwareRoutingApi* | [**get_stats_raw_data2**](docs/MonitoringApplicationAwareRoutingApi.md#get_stats_raw_data2) | **POST** /statistics/approute | 
*MonitoringApplicationAwareRoutingApi* | [**get_transport_health**](docs/MonitoringApplicationAwareRoutingApi.md#get_transport_health) | **GET** /statistics/approute/transport/{type} | 
*MonitoringApplicationAwareRoutingApi* | [**get_transport_health_summary**](docs/MonitoringApplicationAwareRoutingApi.md#get_transport_health_summary) | **GET** /statistics/approute/transport/summary/{type} | 
*MonitoringApplicationAwareRoutingApi* | [**get_tunnel**](docs/MonitoringApplicationAwareRoutingApi.md#get_tunnel) | **GET** /statistics/approute/device/tunnels | 
*MonitoringApplicationAwareRoutingApi* | [**get_tunnel_chart**](docs/MonitoringApplicationAwareRoutingApi.md#get_tunnel_chart) | **GET** /statistics/approute/tunnel/{type}/summary | 
*MonitoringApplicationAwareRoutingApi* | [**get_tunnels**](docs/MonitoringApplicationAwareRoutingApi.md#get_tunnels) | **GET** /statistics/approute/tunnels/{type} | 
*MonitoringApplicationAwareRoutingApi* | [**get_tunnels_health**](docs/MonitoringApplicationAwareRoutingApi.md#get_tunnels_health) | **GET** /statistics/approute/tunnels/health/{type} | 
*MonitoringApplicationAwareRoutingApi* | [**get_tunnels_summary**](docs/MonitoringApplicationAwareRoutingApi.md#get_tunnels_summary) | **GET** /statistics/approute/tunnels/summary/{type} | 
*MonitoringApplicationAwareRoutingStatisticsApi* | [**get_transport_health**](docs/MonitoringApplicationAwareRoutingStatisticsApi.md#get_transport_health) | **GET** /statistics/approute/transport/{type} | 
*MonitoringApplicationAwareRoutingStatisticsApi* | [**get_transport_health_summary**](docs/MonitoringApplicationAwareRoutingStatisticsApi.md#get_transport_health_summary) | **GET** /statistics/approute/transport/summary/{type} | 
*MonitoringBFDApi* | [**get_aggregation_data_by_query4**](docs/MonitoringBFDApi.md#get_aggregation_data_by_query4) | **GET** /statistics/bfd/aggregation | 
*MonitoringBFDApi* | [**get_count6**](docs/MonitoringBFDApi.md#get_count6) | **GET** /statistics/bfd/doccount | 
*MonitoringBFDApi* | [**get_count_post6**](docs/MonitoringBFDApi.md#get_count_post6) | **POST** /statistics/bfd/doccount | 
*MonitoringBFDApi* | [**get_post_aggregation_app_data_by_query4**](docs/MonitoringBFDApi.md#get_post_aggregation_app_data_by_query4) | **POST** /statistics/bfd/app-agg/aggregation | 
*MonitoringBFDApi* | [**get_post_aggregation_data_by_query4**](docs/MonitoringBFDApi.md#get_post_aggregation_data_by_query4) | **POST** /statistics/bfd/aggregation | 
*MonitoringBFDApi* | [**get_post_stat_bulk_raw_data4**](docs/MonitoringBFDApi.md#get_post_stat_bulk_raw_data4) | **POST** /statistics/bfd/page | 
*MonitoringBFDApi* | [**get_stat_bulk_raw_data4**](docs/MonitoringBFDApi.md#get_stat_bulk_raw_data4) | **GET** /statistics/bfd/page | 
*MonitoringBFDApi* | [**get_stat_data_fields6**](docs/MonitoringBFDApi.md#get_stat_data_fields6) | **GET** /statistics/bfd/fields | 
*MonitoringBFDApi* | [**get_stat_data_raw_data4**](docs/MonitoringBFDApi.md#get_stat_data_raw_data4) | **GET** /statistics/bfd | 
*MonitoringBFDApi* | [**get_stat_data_raw_data_as_csv4**](docs/MonitoringBFDApi.md#get_stat_data_raw_data_as_csv4) | **GET** /statistics/bfd/csv | 
*MonitoringBFDApi* | [**get_stat_query_fields6**](docs/MonitoringBFDApi.md#get_stat_query_fields6) | **GET** /statistics/bfd/query/fields | 
*MonitoringBFDApi* | [**get_stats_raw_data4**](docs/MonitoringBFDApi.md#get_stats_raw_data4) | **POST** /statistics/bfd | 
*MonitoringBridgeInterfaceApi* | [**get_aggregation_data_by_query5**](docs/MonitoringBridgeInterfaceApi.md#get_aggregation_data_by_query5) | **GET** /statistics/bridgeinterface/aggregation | 
*MonitoringBridgeInterfaceApi* | [**get_count7**](docs/MonitoringBridgeInterfaceApi.md#get_count7) | **GET** /statistics/bridgeinterface/doccount | 
*MonitoringBridgeInterfaceApi* | [**get_count_post7**](docs/MonitoringBridgeInterfaceApi.md#get_count_post7) | **POST** /statistics/bridgeinterface/doccount | 
*MonitoringBridgeInterfaceApi* | [**get_post_aggregation_app_data_by_query5**](docs/MonitoringBridgeInterfaceApi.md#get_post_aggregation_app_data_by_query5) | **POST** /statistics/bridgeinterface/app-agg/aggregation | 
*MonitoringBridgeInterfaceApi* | [**get_post_aggregation_data_by_query5**](docs/MonitoringBridgeInterfaceApi.md#get_post_aggregation_data_by_query5) | **POST** /statistics/bridgeinterface/aggregation | 
*MonitoringBridgeInterfaceApi* | [**get_post_stat_bulk_raw_data5**](docs/MonitoringBridgeInterfaceApi.md#get_post_stat_bulk_raw_data5) | **POST** /statistics/bridgeinterface/page | 
*MonitoringBridgeInterfaceApi* | [**get_stat_bulk_raw_data5**](docs/MonitoringBridgeInterfaceApi.md#get_stat_bulk_raw_data5) | **GET** /statistics/bridgeinterface/page | 
*MonitoringBridgeInterfaceApi* | [**get_stat_data_fields7**](docs/MonitoringBridgeInterfaceApi.md#get_stat_data_fields7) | **GET** /statistics/bridgeinterface/fields | 
*MonitoringBridgeInterfaceApi* | [**get_stat_data_raw_data5**](docs/MonitoringBridgeInterfaceApi.md#get_stat_data_raw_data5) | **GET** /statistics/bridgeinterface | 
*MonitoringBridgeInterfaceApi* | [**get_stat_data_raw_data_as_csv5**](docs/MonitoringBridgeInterfaceApi.md#get_stat_data_raw_data_as_csv5) | **GET** /statistics/bridgeinterface/csv | 
*MonitoringBridgeInterfaceApi* | [**get_stat_query_fields7**](docs/MonitoringBridgeInterfaceApi.md#get_stat_query_fields7) | **GET** /statistics/bridgeinterface/query/fields | 
*MonitoringBridgeInterfaceApi* | [**get_stats_raw_data5**](docs/MonitoringBridgeInterfaceApi.md#get_stats_raw_data5) | **POST** /statistics/bridgeinterface | 
*MonitoringBridgeMacApi* | [**get_aggregation_data_by_query6**](docs/MonitoringBridgeMacApi.md#get_aggregation_data_by_query6) | **GET** /statistics/bridgemac/aggregation | 
*MonitoringBridgeMacApi* | [**get_count8**](docs/MonitoringBridgeMacApi.md#get_count8) | **GET** /statistics/bridgemac/doccount | 
*MonitoringBridgeMacApi* | [**get_count_post8**](docs/MonitoringBridgeMacApi.md#get_count_post8) | **POST** /statistics/bridgemac/doccount | 
*MonitoringBridgeMacApi* | [**get_post_aggregation_app_data_by_query6**](docs/MonitoringBridgeMacApi.md#get_post_aggregation_app_data_by_query6) | **POST** /statistics/bridgemac/app-agg/aggregation | 
*MonitoringBridgeMacApi* | [**get_post_aggregation_data_by_query6**](docs/MonitoringBridgeMacApi.md#get_post_aggregation_data_by_query6) | **POST** /statistics/bridgemac/aggregation | 
*MonitoringBridgeMacApi* | [**get_post_stat_bulk_raw_data6**](docs/MonitoringBridgeMacApi.md#get_post_stat_bulk_raw_data6) | **POST** /statistics/bridgemac/page | 
*MonitoringBridgeMacApi* | [**get_stat_bulk_raw_data6**](docs/MonitoringBridgeMacApi.md#get_stat_bulk_raw_data6) | **GET** /statistics/bridgemac/page | 
*MonitoringBridgeMacApi* | [**get_stat_data_fields8**](docs/MonitoringBridgeMacApi.md#get_stat_data_fields8) | **GET** /statistics/bridgemac/fields | 
*MonitoringBridgeMacApi* | [**get_stat_data_raw_data6**](docs/MonitoringBridgeMacApi.md#get_stat_data_raw_data6) | **GET** /statistics/bridgemac | 
*MonitoringBridgeMacApi* | [**get_stat_data_raw_data_as_csv6**](docs/MonitoringBridgeMacApi.md#get_stat_data_raw_data_as_csv6) | **GET** /statistics/bridgemac/csv | 
*MonitoringBridgeMacApi* | [**get_stat_query_fields8**](docs/MonitoringBridgeMacApi.md#get_stat_query_fields8) | **GET** /statistics/bridgemac/query/fields | 
*MonitoringBridgeMacApi* | [**get_stats_raw_data6**](docs/MonitoringBridgeMacApi.md#get_stats_raw_data6) | **POST** /statistics/bridgemac | 
*MonitoringCellularEIOLTEApi* | [**get_aggregation_data_by_query7**](docs/MonitoringCellularEIOLTEApi.md#get_aggregation_data_by_query7) | **GET** /statistics/eiolte/aggregation | 
*MonitoringCellularEIOLTEApi* | [**get_count9**](docs/MonitoringCellularEIOLTEApi.md#get_count9) | **GET** /statistics/eiolte/doccount | 
*MonitoringCellularEIOLTEApi* | [**get_count_post9**](docs/MonitoringCellularEIOLTEApi.md#get_count_post9) | **POST** /statistics/eiolte/doccount | 
*MonitoringCellularEIOLTEApi* | [**get_post_aggregation_app_data_by_query7**](docs/MonitoringCellularEIOLTEApi.md#get_post_aggregation_app_data_by_query7) | **POST** /statistics/eiolte/app-agg/aggregation | 
*MonitoringCellularEIOLTEApi* | [**get_post_aggregation_data_by_query7**](docs/MonitoringCellularEIOLTEApi.md#get_post_aggregation_data_by_query7) | **POST** /statistics/eiolte/aggregation | 
*MonitoringCellularEIOLTEApi* | [**get_post_stat_bulk_raw_data7**](docs/MonitoringCellularEIOLTEApi.md#get_post_stat_bulk_raw_data7) | **POST** /statistics/eiolte/page | 
*MonitoringCellularEIOLTEApi* | [**get_stat_bulk_raw_data7**](docs/MonitoringCellularEIOLTEApi.md#get_stat_bulk_raw_data7) | **GET** /statistics/eiolte/page | 
*MonitoringCellularEIOLTEApi* | [**get_stat_data_fields9**](docs/MonitoringCellularEIOLTEApi.md#get_stat_data_fields9) | **GET** /statistics/eiolte/fields | 
*MonitoringCellularEIOLTEApi* | [**get_stat_data_raw_data7**](docs/MonitoringCellularEIOLTEApi.md#get_stat_data_raw_data7) | **GET** /statistics/eiolte | 
*MonitoringCellularEIOLTEApi* | [**get_stat_data_raw_data_as_csv7**](docs/MonitoringCellularEIOLTEApi.md#get_stat_data_raw_data_as_csv7) | **GET** /statistics/eiolte/csv | 
*MonitoringCellularEIOLTEApi* | [**get_stat_query_fields9**](docs/MonitoringCellularEIOLTEApi.md#get_stat_query_fields9) | **GET** /statistics/eiolte/query/fields | 
*MonitoringCellularEIOLTEApi* | [**get_stats_raw_data7**](docs/MonitoringCellularEIOLTEApi.md#get_stats_raw_data7) | **POST** /statistics/eiolte | 
*MonitoringCflowdApi* | [**create_flow_device_data**](docs/MonitoringCflowdApi.md#create_flow_device_data) | **GET** /statistics/cflowd/device/applications | 
*MonitoringCflowdApi* | [**create_flows_grid**](docs/MonitoringCflowdApi.md#create_flows_grid) | **GET** /statistics/cflowd/applications | 
*MonitoringCflowdApi* | [**create_flowssummary**](docs/MonitoringCflowdApi.md#create_flowssummary) | **GET** /statistics/cflowd/applications/summary | 
*MonitoringCflowdApi* | [**get_aggregation_data_by_query8**](docs/MonitoringCflowdApi.md#get_aggregation_data_by_query8) | **GET** /statistics/cflowd/aggregation | 
*MonitoringCflowdApi* | [**get_count10**](docs/MonitoringCflowdApi.md#get_count10) | **GET** /statistics/cflowd/doccount | 
*MonitoringCflowdApi* | [**get_count_post10**](docs/MonitoringCflowdApi.md#get_count_post10) | **POST** /statistics/cflowd/doccount | 
*MonitoringCflowdApi* | [**get_post_aggregation_app_data_by_query8**](docs/MonitoringCflowdApi.md#get_post_aggregation_app_data_by_query8) | **POST** /statistics/cflowd/app-agg/aggregation | 
*MonitoringCflowdApi* | [**get_post_aggregation_data_by_query8**](docs/MonitoringCflowdApi.md#get_post_aggregation_data_by_query8) | **POST** /statistics/cflowd/aggregation | 
*MonitoringCflowdApi* | [**get_post_stat_bulk_raw_data8**](docs/MonitoringCflowdApi.md#get_post_stat_bulk_raw_data8) | **POST** /statistics/cflowd/page | 
*MonitoringCflowdApi* | [**get_stat_bulk_raw_data8**](docs/MonitoringCflowdApi.md#get_stat_bulk_raw_data8) | **GET** /statistics/cflowd/page | 
*MonitoringCflowdApi* | [**get_stat_data_fields10**](docs/MonitoringCflowdApi.md#get_stat_data_fields10) | **GET** /statistics/cflowd/fields | 
*MonitoringCflowdApi* | [**get_stat_data_raw_data8**](docs/MonitoringCflowdApi.md#get_stat_data_raw_data8) | **GET** /statistics/cflowd | 
*MonitoringCflowdApi* | [**get_stat_data_raw_data_as_csv8**](docs/MonitoringCflowdApi.md#get_stat_data_raw_data_as_csv8) | **GET** /statistics/cflowd/csv | 
*MonitoringCflowdApi* | [**get_stat_query_fields10**](docs/MonitoringCflowdApi.md#get_stat_query_fields10) | **GET** /statistics/cflowd/query/fields | 
*MonitoringCflowdApi* | [**get_stats_raw_data8**](docs/MonitoringCflowdApi.md#get_stats_raw_data8) | **POST** /statistics/cflowd | 
*MonitoringCflowdFlowsApi* | [**create_cflow_collector_list**](docs/MonitoringCflowdFlowsApi.md#create_cflow_collector_list) | **GET** /device/cflowd/flows | 
*MonitoringCflowdFlowsApi* | [**create_cflowd_collector_list**](docs/MonitoringCflowdFlowsApi.md#create_cflowd_collector_list) | **GET** /device/cflowd/collector | 
*MonitoringCflowdFlowsApi* | [**create_cflowd_flows_count_list**](docs/MonitoringCflowdFlowsApi.md#create_cflowd_flows_count_list) | **GET** /device/cflowd/flows-count | 
*MonitoringCflowdFlowsApi* | [**create_cflowd_statistics**](docs/MonitoringCflowdFlowsApi.md#create_cflowd_statistics) | **GET** /device/cflowd/statistics | 
*MonitoringCflowdFlowsApi* | [**create_cflowd_template**](docs/MonitoringCflowdFlowsApi.md#create_cflowd_template) | **GET** /device/cflowd/template | 
*MonitoringCflowdFlowsApi* | [**get_cflowd_dpi_device_field_json**](docs/MonitoringCflowdFlowsApi.md#get_cflowd_dpi_device_field_json) | **GET** /device/cflowd/application/fields | 
*MonitoringCflowdFlowsApi* | [**get_cflowd_dpi_field_json**](docs/MonitoringCflowdFlowsApi.md#get_cflowd_dpi_field_json) | **GET** /device/cflowd/device/fields | 
*MonitoringCflowdFlowsApi* | [**get_fn_f_cache_stats**](docs/MonitoringCflowdFlowsApi.md#get_fn_f_cache_stats) | **GET** /device/cflowd/fnf/cache-stats | 
*MonitoringCflowdFlowsApi* | [**get_fn_f_export_client_stats**](docs/MonitoringCflowdFlowsApi.md#get_fn_f_export_client_stats) | **GET** /device/cflowd/fnf/export-client-stats | 
*MonitoringCflowdFlowsApi* | [**get_fn_f_export_stats**](docs/MonitoringCflowdFlowsApi.md#get_fn_f_export_stats) | **GET** /device/cflowd/fnf/export-stats | 
*MonitoringCflowdFlowsApi* | [**get_fn_f_monitor_stats**](docs/MonitoringCflowdFlowsApi.md#get_fn_f_monitor_stats) | **GET** /device/cflowd/fnf/monitor-stats | 
*MonitoringCflowdFlowsApi* | [**get_fnf**](docs/MonitoringCflowdFlowsApi.md#get_fnf) | **GET** /device/cflowd/fnf/flow-monitor | 
*MonitoringCloudExpressApi* | [**get_aggregation_data_by_query9**](docs/MonitoringCloudExpressApi.md#get_aggregation_data_by_query9) | **GET** /statistics/cloudx/aggregation | 
*MonitoringCloudExpressApi* | [**get_count11**](docs/MonitoringCloudExpressApi.md#get_count11) | **GET** /statistics/cloudx/doccount | 
*MonitoringCloudExpressApi* | [**get_count_post11**](docs/MonitoringCloudExpressApi.md#get_count_post11) | **POST** /statistics/cloudx/doccount | 
*MonitoringCloudExpressApi* | [**get_post_aggregation_app_data_by_query9**](docs/MonitoringCloudExpressApi.md#get_post_aggregation_app_data_by_query9) | **POST** /statistics/cloudx/app-agg/aggregation | 
*MonitoringCloudExpressApi* | [**get_post_aggregation_data_by_query9**](docs/MonitoringCloudExpressApi.md#get_post_aggregation_data_by_query9) | **POST** /statistics/cloudx/aggregation | 
*MonitoringCloudExpressApi* | [**get_post_stat_bulk_raw_data9**](docs/MonitoringCloudExpressApi.md#get_post_stat_bulk_raw_data9) | **POST** /statistics/cloudx/page | 
*MonitoringCloudExpressApi* | [**get_stat_bulk_raw_data9**](docs/MonitoringCloudExpressApi.md#get_stat_bulk_raw_data9) | **GET** /statistics/cloudx/page | 
*MonitoringCloudExpressApi* | [**get_stat_data_fields11**](docs/MonitoringCloudExpressApi.md#get_stat_data_fields11) | **GET** /statistics/cloudx/fields | 
*MonitoringCloudExpressApi* | [**get_stat_data_raw_data9**](docs/MonitoringCloudExpressApi.md#get_stat_data_raw_data9) | **GET** /statistics/cloudx | 
*MonitoringCloudExpressApi* | [**get_stat_data_raw_data_as_csv9**](docs/MonitoringCloudExpressApi.md#get_stat_data_raw_data_as_csv9) | **GET** /statistics/cloudx/csv | 
*MonitoringCloudExpressApi* | [**get_stat_query_fields11**](docs/MonitoringCloudExpressApi.md#get_stat_query_fields11) | **GET** /statistics/cloudx/query/fields | 
*MonitoringCloudExpressApi* | [**get_stats_raw_data9**](docs/MonitoringCloudExpressApi.md#get_stats_raw_data9) | **POST** /statistics/cloudx | 
*MonitoringColocationClusterApi* | [**get_cluster_config_by_cluster_id**](docs/MonitoringColocationClusterApi.md#get_cluster_config_by_cluster_id) | **GET** /colocation/monitor/cluster/config | 
*MonitoringColocationClusterApi* | [**get_cluster_details_by_cluster_id**](docs/MonitoringColocationClusterApi.md#get_cluster_details_by_cluster_id) | **GET** /colocation/monitor/cluster | 
*MonitoringColocationClusterApi* | [**get_cluster_port_mapping_by_cluster_id**](docs/MonitoringColocationClusterApi.md#get_cluster_port_mapping_by_cluster_id) | **GET** /colocation/monitor/cluster/portView | 
*MonitoringColocationClusterApi* | [**get_device_detail_by_device_id**](docs/MonitoringColocationClusterApi.md#get_device_detail_by_device_id) | **GET** /colocation/monitor/device | 
*MonitoringColocationClusterApi* | [**get_pnf_config**](docs/MonitoringColocationClusterApi.md#get_pnf_config) | **GET** /colocation/monitor/pnf/configuration | 
*MonitoringColocationClusterApi* | [**get_service_chain_details**](docs/MonitoringColocationClusterApi.md#get_service_chain_details) | **GET** /colocation/monitor/servicechain | 
*MonitoringColocationClusterApi* | [**get_service_group_by_cluster_id**](docs/MonitoringColocationClusterApi.md#get_service_group_by_cluster_id) | **GET** /colocation/monitor/servicegroup | 
*MonitoringColocationClusterApi* | [**get_system_status_by_device_id**](docs/MonitoringColocationClusterApi.md#get_system_status_by_device_id) | **GET** /colocation/monitor/device/system | 
*MonitoringColocationClusterApi* | [**get_vnf_alarm_count**](docs/MonitoringColocationClusterApi.md#get_vnf_alarm_count) | **GET** /colocation/monitor/vnf/alarms/count | 
*MonitoringColocationClusterApi* | [**get_vnf_events_count_detail**](docs/MonitoringColocationClusterApi.md#get_vnf_events_count_detail) | **GET** /colocation/monitor/vnf/alarms | 
*MonitoringColocationClusterApi* | [**get_vnf_events_detail**](docs/MonitoringColocationClusterApi.md#get_vnf_events_detail) | **GET** /colocation/monitor/vnf/events | 
*MonitoringColocationClusterApi* | [**get_vnf_interface_detail**](docs/MonitoringColocationClusterApi.md#get_vnf_interface_detail) | **GET** /colocation/monitor/vnf/interface | 
*MonitoringColocationClusterApi* | [**getpnf_details**](docs/MonitoringColocationClusterApi.md#getpnf_details) | **GET** /colocation/monitor/pnf | 
*MonitoringColocationClusterApi* | [**getvnf_by_device_id**](docs/MonitoringColocationClusterApi.md#getvnf_by_device_id) | **GET** /colocation/monitor/device/vnf | 
*MonitoringColocationClusterApi* | [**getvnf_details**](docs/MonitoringColocationClusterApi.md#getvnf_details) | **GET** /colocation/monitor/vnf | 
*MonitoringColocationClusterApi* | [**list_network_function_map**](docs/MonitoringColocationClusterApi.md#list_network_function_map) | **GET** /colocation/monitor/networkfunction/listmap | 
*MonitoringColocationClusterApi* | [**vnf_actions**](docs/MonitoringColocationClusterApi.md#vnf_actions) | **POST** /colocation/monitor/vnf/action | 
*MonitoringDPIApi* | [**create_dpi_device_and_app_details**](docs/MonitoringDPIApi.md#create_dpi_device_and_app_details) | **GET** /statistics/dpi/device/details/applications | 
*MonitoringDPIApi* | [**create_dpi_device_grid_data**](docs/MonitoringDPIApi.md#create_dpi_device_grid_data) | **GET** /statistics/dpi/device/applications | 
*MonitoringDPIApi* | [**create_dpi_flows_grid_list_query**](docs/MonitoringDPIApi.md#create_dpi_flows_grid_list_query) | **GET** /statistics/dpi/applications | 
*MonitoringDPIApi* | [**create_dpi_summary**](docs/MonitoringDPIApi.md#create_dpi_summary) | **GET** /statistics/dpi/applications/summary | 
*MonitoringDPIApi* | [**get_aggregation_data_by_query12**](docs/MonitoringDPIApi.md#get_aggregation_data_by_query12) | **GET** /statistics/dpi/aggregation | 
*MonitoringDPIApi* | [**get_aggregation_data_dpi**](docs/MonitoringDPIApi.md#get_aggregation_data_dpi) | **POST** /statistics/dpi/recovery/aggregation | 
*MonitoringDPIApi* | [**get_aggregation_data_for_packet_dup**](docs/MonitoringDPIApi.md#get_aggregation_data_for_packet_dup) | **POST** /statistics/dpi/pktdup/aggregation | 
*MonitoringDPIApi* | [**get_count14**](docs/MonitoringDPIApi.md#get_count14) | **GET** /statistics/dpi/doccount | 
*MonitoringDPIApi* | [**get_count_post14**](docs/MonitoringDPIApi.md#get_count_post14) | **POST** /statistics/dpi/doccount | 
*MonitoringDPIApi* | [**get_post_aggregation_app_data**](docs/MonitoringDPIApi.md#get_post_aggregation_app_data) | **POST** /statistics/dpi/agg-app/aggregation | 
*MonitoringDPIApi* | [**get_post_aggregation_data**](docs/MonitoringDPIApi.md#get_post_aggregation_data) | **POST** /statistics/dpi/aggregation | 
*MonitoringDPIApi* | [**get_post_stat_bulk_raw_data12**](docs/MonitoringDPIApi.md#get_post_stat_bulk_raw_data12) | **POST** /statistics/dpi/page | 
*MonitoringDPIApi* | [**get_stat_bulk_raw_data12**](docs/MonitoringDPIApi.md#get_stat_bulk_raw_data12) | **GET** /statistics/dpi/page | 
*MonitoringDPIApi* | [**get_stat_data_fields14**](docs/MonitoringDPIApi.md#get_stat_data_fields14) | **GET** /statistics/dpi/fields | 
*MonitoringDPIApi* | [**get_stat_data_raw_data12**](docs/MonitoringDPIApi.md#get_stat_data_raw_data12) | **GET** /statistics/dpi | 
*MonitoringDPIApi* | [**get_stat_data_raw_data_as_csv12**](docs/MonitoringDPIApi.md#get_stat_data_raw_data_as_csv12) | **GET** /statistics/dpi/csv | 
*MonitoringDPIApi* | [**get_stat_query_fields14**](docs/MonitoringDPIApi.md#get_stat_query_fields14) | **GET** /statistics/dpi/query/fields | 
*MonitoringDPIApi* | [**get_stats_raw_data12**](docs/MonitoringDPIApi.md#get_stats_raw_data12) | **POST** /statistics/dpi | 
*MonitoringDPIApi* | [**get_unique_flow_count**](docs/MonitoringDPIApi.md#get_unique_flow_count) | **GET** /statistics/dpi/device/application/flowcount | 
*MonitoringDPIOnDemandTroubleshootingApi* | [**create_queue_entry**](docs/MonitoringDPIOnDemandTroubleshootingApi.md#create_queue_entry) | **POST** /statistics/on-demand/queue | 
*MonitoringDPIOnDemandTroubleshootingApi* | [**delete_queue_entry**](docs/MonitoringDPIOnDemandTroubleshootingApi.md#delete_queue_entry) | **DELETE** /statistics/on-demand/queue/{entryId} | 
*MonitoringDPIOnDemandTroubleshootingApi* | [**get_queue_entries**](docs/MonitoringDPIOnDemandTroubleshootingApi.md#get_queue_entries) | **GET** /statistics/on-demand/queue | 
*MonitoringDPIOnDemandTroubleshootingApi* | [**get_queue_properties**](docs/MonitoringDPIOnDemandTroubleshootingApi.md#get_queue_properties) | **GET** /statistics/on-demand/queue/properties | 
*MonitoringDPIOnDemandTroubleshootingApi* | [**update_queue_entry**](docs/MonitoringDPIOnDemandTroubleshootingApi.md#update_queue_entry) | **PUT** /statistics/on-demand/queue/{entryId} | 
*MonitoringDeviceDetailsApi* | [**enable_sdavcon_device**](docs/MonitoringDeviceDetailsApi.md#enable_sdavcon_device) | **POST** /device/enableSDAVC/{deviceIP}/{enable} | 
*MonitoringDeviceDetailsApi* | [**generate_device_state_data**](docs/MonitoringDeviceDetailsApi.md#generate_device_state_data) | **GET** /data/device/state/{state_data_type} | 
*MonitoringDeviceDetailsApi* | [**generate_device_state_data_fields**](docs/MonitoringDeviceDetailsApi.md#generate_device_state_data_fields) | **GET** /data/device/state/{state_data_type}/fields | 
*MonitoringDeviceDetailsApi* | [**generate_device_state_data_with_query_string**](docs/MonitoringDeviceDetailsApi.md#generate_device_state_data_with_query_string) | **GET** /data/device/state/{state_data_type}/query | 
*MonitoringDeviceDetailsApi* | [**get_all_device_status**](docs/MonitoringDeviceDetailsApi.md#get_all_device_status) | **GET** /device/status | 
*MonitoringDeviceDetailsApi* | [**get_device_counters**](docs/MonitoringDeviceDetailsApi.md#get_device_counters) | **GET** /device/counters | 
*MonitoringDeviceDetailsApi* | [**get_device_list_as_key_value**](docs/MonitoringDeviceDetailsApi.md#get_device_list_as_key_value) | **GET** /device/keyvalue | 
*MonitoringDeviceDetailsApi* | [**get_device_models**](docs/MonitoringDeviceDetailsApi.md#get_device_models) | **GET** /device/models/{uuid} | 
*MonitoringDeviceDetailsApi* | [**get_device_only_status**](docs/MonitoringDeviceDetailsApi.md#get_device_only_status) | **GET** /device/devicestatus | 
*MonitoringDeviceDetailsApi* | [**get_device_running_config**](docs/MonitoringDeviceDetailsApi.md#get_device_running_config) | **GET** /device/config | 
*MonitoringDeviceDetailsApi* | [**get_device_running_config_html**](docs/MonitoringDeviceDetailsApi.md#get_device_running_config_html) | **GET** /device/config/html | 
*MonitoringDeviceDetailsApi* | [**get_device_tloc_status**](docs/MonitoringDeviceDetailsApi.md#get_device_tloc_status) | **GET** /device/tloc | 
*MonitoringDeviceDetailsApi* | [**get_device_tloc_util**](docs/MonitoringDeviceDetailsApi.md#get_device_tloc_util) | **GET** /device/tlocutil | 
*MonitoringDeviceDetailsApi* | [**get_device_tloc_util_details**](docs/MonitoringDeviceDetailsApi.md#get_device_tloc_util_details) | **GET** /device/tlocutil/detail | 
*MonitoringDeviceDetailsApi* | [**get_hardware_health_details**](docs/MonitoringDeviceDetailsApi.md#get_hardware_health_details) | **GET** /device/hardwarehealth/detail | 
*MonitoringDeviceDetailsApi* | [**get_hardware_health_summary**](docs/MonitoringDeviceDetailsApi.md#get_hardware_health_summary) | **GET** /device/hardwarehealth/summary | 
*MonitoringDeviceDetailsApi* | [**get_stats_queues**](docs/MonitoringDeviceDetailsApi.md#get_stats_queues) | **GET** /device/stats | 
*MonitoringDeviceDetailsApi* | [**get_sync_queues**](docs/MonitoringDeviceDetailsApi.md#get_sync_queues) | **GET** /device/queues | 
*MonitoringDeviceDetailsApi* | [**get_unconfigured**](docs/MonitoringDeviceDetailsApi.md#get_unconfigured) | **GET** /device/unconfigured | 
*MonitoringDeviceDetailsApi* | [**get_v_manage_system_ip**](docs/MonitoringDeviceDetailsApi.md#get_v_manage_system_ip) | **GET** /device/vmanage | 
*MonitoringDeviceDetailsApi* | [**get_vedge_inventory**](docs/MonitoringDeviceDetailsApi.md#get_vedge_inventory) | **GET** /device/vedgeinventory/detail | 
*MonitoringDeviceDetailsApi* | [**get_vedge_inventory_summary**](docs/MonitoringDeviceDetailsApi.md#get_vedge_inventory_summary) | **GET** /device/vedgeinventory/summary | 
*MonitoringDeviceDetailsApi* | [**list_all_device_models**](docs/MonitoringDeviceDetailsApi.md#list_all_device_models) | **GET** /device/models | 
*MonitoringDeviceDetailsApi* | [**list_all_devices**](docs/MonitoringDeviceDetailsApi.md#list_all_devices) | **GET** /device | 
*MonitoringDeviceDetailsApi* | [**list_all_monitor_details_devices**](docs/MonitoringDeviceDetailsApi.md#list_all_monitor_details_devices) | **GET** /device/monitor | 
*MonitoringDeviceDetailsApi* | [**list_currently_syncing_devices**](docs/MonitoringDeviceDetailsApi.md#list_currently_syncing_devices) | **GET** /device/sync_status | 
*MonitoringDeviceDetailsApi* | [**list_reachable_devices**](docs/MonitoringDeviceDetailsApi.md#list_reachable_devices) | **GET** /device/reachable | 
*MonitoringDeviceDetailsApi* | [**list_unreachable_devices**](docs/MonitoringDeviceDetailsApi.md#list_unreachable_devices) | **GET** /device/unreachable | 
*MonitoringDeviceDetailsApi* | [**remove_unreachable_device**](docs/MonitoringDeviceDetailsApi.md#remove_unreachable_device) | **DELETE** /device/unreachable/{deviceIP} | 
*MonitoringDeviceDetailsApi* | [**set_block_sync**](docs/MonitoringDeviceDetailsApi.md#set_block_sync) | **POST** /device/blockSync | 
*MonitoringDeviceDetailsApi* | [**sync_all_devices_mem_db**](docs/MonitoringDeviceDetailsApi.md#sync_all_devices_mem_db) | **POST** /device/syncall/memorydb | 
*MonitoringDeviceStatisticsApi* | [**get_aggregation_data_by_query15**](docs/MonitoringDeviceStatisticsApi.md#get_aggregation_data_by_query15) | **GET** /statistics/device/aggregation | 
*MonitoringDeviceStatisticsApi* | [**get_count17**](docs/MonitoringDeviceStatisticsApi.md#get_count17) | **GET** /statistics/device/doccount | 
*MonitoringDeviceStatisticsApi* | [**get_count_post17**](docs/MonitoringDeviceStatisticsApi.md#get_count_post17) | **POST** /statistics/device/doccount | 
*MonitoringDeviceStatisticsApi* | [**get_post_aggregation_app_data_by_query14**](docs/MonitoringDeviceStatisticsApi.md#get_post_aggregation_app_data_by_query14) | **POST** /statistics/device/app-agg/aggregation | 
*MonitoringDeviceStatisticsApi* | [**get_post_aggregation_data_by_query14**](docs/MonitoringDeviceStatisticsApi.md#get_post_aggregation_data_by_query14) | **POST** /statistics/device/aggregation | 
*MonitoringDeviceStatisticsApi* | [**get_post_stat_bulk_raw_data15**](docs/MonitoringDeviceStatisticsApi.md#get_post_stat_bulk_raw_data15) | **POST** /statistics/device/page | 
*MonitoringDeviceStatisticsApi* | [**get_stat_bulk_raw_data15**](docs/MonitoringDeviceStatisticsApi.md#get_stat_bulk_raw_data15) | **GET** /statistics/device/page | 
*MonitoringDeviceStatisticsApi* | [**get_stat_data_fields17**](docs/MonitoringDeviceStatisticsApi.md#get_stat_data_fields17) | **GET** /statistics/device/fields | 
*MonitoringDeviceStatisticsApi* | [**get_stat_data_raw_data14**](docs/MonitoringDeviceStatisticsApi.md#get_stat_data_raw_data14) | **GET** /statistics/device | 
*MonitoringDeviceStatisticsApi* | [**get_stat_data_raw_data_as_csv15**](docs/MonitoringDeviceStatisticsApi.md#get_stat_data_raw_data_as_csv15) | **GET** /statistics/device/csv | 
*MonitoringDeviceStatisticsApi* | [**get_stat_query_fields17**](docs/MonitoringDeviceStatisticsApi.md#get_stat_query_fields17) | **GET** /statistics/device/query/fields | 
*MonitoringDeviceStatisticsApi* | [**get_stats_raw_data15**](docs/MonitoringDeviceStatisticsApi.md#get_stats_raw_data15) | **POST** /statistics/device | 
*MonitoringDeviceStatisticsDetailsApi* | [**generate_device_statistics_data**](docs/MonitoringDeviceStatisticsDetailsApi.md#generate_device_statistics_data) | **GET** /data/device/statistics/{state_data_type} | 
*MonitoringDeviceStatisticsDetailsApi* | [**get_active_alarms**](docs/MonitoringDeviceStatisticsDetailsApi.md#get_active_alarms) | **GET** /data/device/statistics/alarm/active | 
*MonitoringDeviceStatisticsDetailsApi* | [**get_count_with_state_data_type**](docs/MonitoringDeviceStatisticsDetailsApi.md#get_count_with_state_data_type) | **GET** /data/device/statistics/{state_data_type}/doccount | 
*MonitoringDeviceStatisticsDetailsApi* | [**get_stat_data_fields_by_state_data_type**](docs/MonitoringDeviceStatisticsDetailsApi.md#get_stat_data_fields_by_state_data_type) | **GET** /data/device/statistics/{state_data_type}/fields | 
*MonitoringDeviceStatisticsDetailsApi* | [**get_statistics_type**](docs/MonitoringDeviceStatisticsDetailsApi.md#get_statistics_type) | **GET** /data/device/statistics | 
*MonitoringEndpointTrackerStatusApi* | [**get_aggregation_data_by_query18**](docs/MonitoringEndpointTrackerStatusApi.md#get_aggregation_data_by_query18) | **GET** /statistics/endpointTracker/aggregation | 
*MonitoringEndpointTrackerStatusApi* | [**get_count20**](docs/MonitoringEndpointTrackerStatusApi.md#get_count20) | **GET** /statistics/endpointTracker/doccount | 
*MonitoringEndpointTrackerStatusApi* | [**get_count_post20**](docs/MonitoringEndpointTrackerStatusApi.md#get_count_post20) | **POST** /statistics/endpointTracker/doccount | 
*MonitoringEndpointTrackerStatusApi* | [**get_post_aggregation_app_data_by_query17**](docs/MonitoringEndpointTrackerStatusApi.md#get_post_aggregation_app_data_by_query17) | **POST** /statistics/endpointTracker/app-agg/aggregation | 
*MonitoringEndpointTrackerStatusApi* | [**get_post_aggregation_data_by_query17**](docs/MonitoringEndpointTrackerStatusApi.md#get_post_aggregation_data_by_query17) | **POST** /statistics/endpointTracker/aggregation | 
*MonitoringEndpointTrackerStatusApi* | [**get_post_stat_bulk_raw_data18**](docs/MonitoringEndpointTrackerStatusApi.md#get_post_stat_bulk_raw_data18) | **POST** /statistics/endpointTracker/page | 
*MonitoringEndpointTrackerStatusApi* | [**get_stat_bulk_raw_data18**](docs/MonitoringEndpointTrackerStatusApi.md#get_stat_bulk_raw_data18) | **GET** /statistics/endpointTracker/page | 
*MonitoringEndpointTrackerStatusApi* | [**get_stat_data_fields20**](docs/MonitoringEndpointTrackerStatusApi.md#get_stat_data_fields20) | **GET** /statistics/endpointTracker/fields | 
*MonitoringEndpointTrackerStatusApi* | [**get_stat_data_raw_data17**](docs/MonitoringEndpointTrackerStatusApi.md#get_stat_data_raw_data17) | **GET** /statistics/endpointTracker | 
*MonitoringEndpointTrackerStatusApi* | [**get_stat_data_raw_data_as_csv18**](docs/MonitoringEndpointTrackerStatusApi.md#get_stat_data_raw_data_as_csv18) | **GET** /statistics/endpointTracker/csv | 
*MonitoringEndpointTrackerStatusApi* | [**get_stat_query_fields20**](docs/MonitoringEndpointTrackerStatusApi.md#get_stat_query_fields20) | **GET** /statistics/endpointTracker/query/fields | 
*MonitoringEndpointTrackerStatusApi* | [**get_stats_raw_data18**](docs/MonitoringEndpointTrackerStatusApi.md#get_stats_raw_data18) | **POST** /statistics/endpointTracker | 
*MonitoringEventsApi* | [**create_events_query_config**](docs/MonitoringEventsApi.md#create_events_query_config) | **GET** /event/query/input | 
*MonitoringEventsApi* | [**enable_events_from_file**](docs/MonitoringEventsApi.md#enable_events_from_file) | **GET** /event/enable/fileprocess | 
*MonitoringEventsApi* | [**find_events**](docs/MonitoringEventsApi.md#find_events) | **GET** /event/severity | 
*MonitoringEventsApi* | [**get_aggregation_data_by_query25**](docs/MonitoringEventsApi.md#get_aggregation_data_by_query25) | **GET** /event/aggregation | 
*MonitoringEventsApi* | [**get_components_as_key_value**](docs/MonitoringEventsApi.md#get_components_as_key_value) | **GET** /event/component/keyvalue | 
*MonitoringEventsApi* | [**get_count27**](docs/MonitoringEventsApi.md#get_count27) | **GET** /event/doccount | 
*MonitoringEventsApi* | [**get_count_post27**](docs/MonitoringEventsApi.md#get_count_post27) | **POST** /event/doccount | 
*MonitoringEventsApi* | [**get_event_types_as_key_value**](docs/MonitoringEventsApi.md#get_event_types_as_key_value) | **GET** /event/types/keyvalue | 
*MonitoringEventsApi* | [**get_listeners_info**](docs/MonitoringEventsApi.md#get_listeners_info) | **GET** /event/listeners | 
*MonitoringEventsApi* | [**get_post_aggregation_app_data_by_query24**](docs/MonitoringEventsApi.md#get_post_aggregation_app_data_by_query24) | **POST** /event/app-agg/aggregation | 
*MonitoringEventsApi* | [**get_post_aggregation_data_by_query24**](docs/MonitoringEventsApi.md#get_post_aggregation_data_by_query24) | **POST** /event/aggregation | 
*MonitoringEventsApi* | [**get_post_stat_bulk_raw_data25**](docs/MonitoringEventsApi.md#get_post_stat_bulk_raw_data25) | **POST** /event/page | 
*MonitoringEventsApi* | [**get_severity_histogram**](docs/MonitoringEventsApi.md#get_severity_histogram) | **GET** /event/severity/summary | 
*MonitoringEventsApi* | [**get_stat_bulk_raw_data25**](docs/MonitoringEventsApi.md#get_stat_bulk_raw_data25) | **GET** /event/page | 
*MonitoringEventsApi* | [**get_stat_data_fields27**](docs/MonitoringEventsApi.md#get_stat_data_fields27) | **GET** /event/fields | 
*MonitoringEventsApi* | [**get_stat_data_raw_data24**](docs/MonitoringEventsApi.md#get_stat_data_raw_data24) | **GET** /event | 
*MonitoringEventsApi* | [**get_stat_data_raw_data_as_csv25**](docs/MonitoringEventsApi.md#get_stat_data_raw_data_as_csv25) | **GET** /event/csv | 
*MonitoringEventsApi* | [**get_stat_query_fields27**](docs/MonitoringEventsApi.md#get_stat_query_fields27) | **GET** /event/query/fields | 
*MonitoringEventsApi* | [**get_stats_raw_data25**](docs/MonitoringEventsApi.md#get_stats_raw_data25) | **POST** /event | 
*MonitoringFlowlogApi* | [**get_aggregation_data_by_query26**](docs/MonitoringFlowlogApi.md#get_aggregation_data_by_query26) | **GET** /statistics/flowlog/aggregation | 
*MonitoringFlowlogApi* | [**get_count28**](docs/MonitoringFlowlogApi.md#get_count28) | **GET** /statistics/flowlog/doccount | 
*MonitoringFlowlogApi* | [**get_count_post28**](docs/MonitoringFlowlogApi.md#get_count_post28) | **POST** /statistics/flowlog/doccount | 
*MonitoringFlowlogApi* | [**get_post_aggregation_app_data_by_query25**](docs/MonitoringFlowlogApi.md#get_post_aggregation_app_data_by_query25) | **POST** /statistics/flowlog/app-agg/aggregation | 
*MonitoringFlowlogApi* | [**get_post_aggregation_data_by_query26**](docs/MonitoringFlowlogApi.md#get_post_aggregation_data_by_query26) | **POST** /statistics/flowlog/aggregation | 
*MonitoringFlowlogApi* | [**get_post_stat_bulk_raw_data26**](docs/MonitoringFlowlogApi.md#get_post_stat_bulk_raw_data26) | **POST** /statistics/flowlog/page | 
*MonitoringFlowlogApi* | [**get_stat_bulk_raw_data26**](docs/MonitoringFlowlogApi.md#get_stat_bulk_raw_data26) | **GET** /statistics/flowlog/page | 
*MonitoringFlowlogApi* | [**get_stat_data_fields28**](docs/MonitoringFlowlogApi.md#get_stat_data_fields28) | **GET** /statistics/flowlog/fields | 
*MonitoringFlowlogApi* | [**get_stat_data_raw_data25**](docs/MonitoringFlowlogApi.md#get_stat_data_raw_data25) | **GET** /statistics/flowlog | 
*MonitoringFlowlogApi* | [**get_stat_data_raw_data_as_csv26**](docs/MonitoringFlowlogApi.md#get_stat_data_raw_data_as_csv26) | **GET** /statistics/flowlog/csv | 
*MonitoringFlowlogApi* | [**get_stat_query_fields28**](docs/MonitoringFlowlogApi.md#get_stat_query_fields28) | **GET** /statistics/flowlog/query/fields | 
*MonitoringFlowlogApi* | [**get_stats_raw_data26**](docs/MonitoringFlowlogApi.md#get_stats_raw_data26) | **POST** /statistics/flowlog | 
*MonitoringHealthApi* | [**get_devices_health**](docs/MonitoringHealthApi.md#get_devices_health) | **GET** /health/devices | 
*MonitoringHealthApi* | [**get_devices_health_overview**](docs/MonitoringHealthApi.md#get_devices_health_overview) | **GET** /health/devices/overview | 
*MonitoringHealthDevicesApi* | [**get_devices_health**](docs/MonitoringHealthDevicesApi.md#get_devices_health) | **GET** /health/devices | 
*MonitoringHealthDevicesApi* | [**get_devices_health_overview**](docs/MonitoringHealthDevicesApi.md#get_devices_health_overview) | **GET** /health/devices/overview | 
*MonitoringIPsAlertApi* | [**get_aggregation_data_by_query21**](docs/MonitoringIPsAlertApi.md#get_aggregation_data_by_query21) | **GET** /statistics/ipsalert/aggregation | 
*MonitoringIPsAlertApi* | [**get_count23**](docs/MonitoringIPsAlertApi.md#get_count23) | **GET** /statistics/ipsalert/doccount | 
*MonitoringIPsAlertApi* | [**get_count_post23**](docs/MonitoringIPsAlertApi.md#get_count_post23) | **POST** /statistics/ipsalert/doccount | 
*MonitoringIPsAlertApi* | [**get_post_aggregation_app_data_by_query20**](docs/MonitoringIPsAlertApi.md#get_post_aggregation_app_data_by_query20) | **POST** /statistics/ipsalert/app-agg/aggregation | 
*MonitoringIPsAlertApi* | [**get_post_aggregation_data_by_query20**](docs/MonitoringIPsAlertApi.md#get_post_aggregation_data_by_query20) | **POST** /statistics/ipsalert/aggregation | 
*MonitoringIPsAlertApi* | [**get_post_stat_bulk_raw_data21**](docs/MonitoringIPsAlertApi.md#get_post_stat_bulk_raw_data21) | **POST** /statistics/ipsalert/page | 
*MonitoringIPsAlertApi* | [**get_stat_bulk_raw_data21**](docs/MonitoringIPsAlertApi.md#get_stat_bulk_raw_data21) | **GET** /statistics/ipsalert/page | 
*MonitoringIPsAlertApi* | [**get_stat_data_fields23**](docs/MonitoringIPsAlertApi.md#get_stat_data_fields23) | **GET** /statistics/ipsalert/fields | 
*MonitoringIPsAlertApi* | [**get_stat_data_raw_data20**](docs/MonitoringIPsAlertApi.md#get_stat_data_raw_data20) | **GET** /statistics/ipsalert | 
*MonitoringIPsAlertApi* | [**get_stat_data_raw_data_as_csv21**](docs/MonitoringIPsAlertApi.md#get_stat_data_raw_data_as_csv21) | **GET** /statistics/ipsalert/csv | 
*MonitoringIPsAlertApi* | [**get_stat_query_fields23**](docs/MonitoringIPsAlertApi.md#get_stat_query_fields23) | **GET** /statistics/ipsalert/query/fields | 
*MonitoringIPsAlertApi* | [**get_stats_raw_data21**](docs/MonitoringIPsAlertApi.md#get_stats_raw_data21) | **POST** /statistics/ipsalert | 
*MonitoringInterfaceStatisticsApi* | [**get_aggregation_data_by_query10**](docs/MonitoringInterfaceStatisticsApi.md#get_aggregation_data_by_query10) | **GET** /statistics/interface/aggregation | 
*MonitoringInterfaceStatisticsApi* | [**get_bandwidth_distribution**](docs/MonitoringInterfaceStatisticsApi.md#get_bandwidth_distribution) | **GET** /statistics/interface/ccapacity/distribution | 
*MonitoringInterfaceStatisticsApi* | [**get_count12**](docs/MonitoringInterfaceStatisticsApi.md#get_count12) | **GET** /statistics/interface/doccount | 
*MonitoringInterfaceStatisticsApi* | [**get_count_post12**](docs/MonitoringInterfaceStatisticsApi.md#get_count_post12) | **POST** /statistics/interface/doccount | 
*MonitoringInterfaceStatisticsApi* | [**get_post_aggregation_app_data_by_query10**](docs/MonitoringInterfaceStatisticsApi.md#get_post_aggregation_app_data_by_query10) | **POST** /statistics/interface/app-agg/aggregation | 
*MonitoringInterfaceStatisticsApi* | [**get_post_aggregation_data_by_query10**](docs/MonitoringInterfaceStatisticsApi.md#get_post_aggregation_data_by_query10) | **POST** /statistics/interface/aggregation | 
*MonitoringInterfaceStatisticsApi* | [**get_post_stat_bulk_raw_data10**](docs/MonitoringInterfaceStatisticsApi.md#get_post_stat_bulk_raw_data10) | **POST** /statistics/interface/page | 
*MonitoringInterfaceStatisticsApi* | [**get_stat_bulk_raw_data10**](docs/MonitoringInterfaceStatisticsApi.md#get_stat_bulk_raw_data10) | **GET** /statistics/interface/page | 
*MonitoringInterfaceStatisticsApi* | [**get_stat_data_fields12**](docs/MonitoringInterfaceStatisticsApi.md#get_stat_data_fields12) | **GET** /statistics/interface/fields | 
*MonitoringInterfaceStatisticsApi* | [**get_stat_data_raw_data10**](docs/MonitoringInterfaceStatisticsApi.md#get_stat_data_raw_data10) | **GET** /statistics/interface | 
*MonitoringInterfaceStatisticsApi* | [**get_stat_data_raw_data_as_csv10**](docs/MonitoringInterfaceStatisticsApi.md#get_stat_data_raw_data_as_csv10) | **GET** /statistics/interface/csv | 
*MonitoringInterfaceStatisticsApi* | [**get_stat_query_fields12**](docs/MonitoringInterfaceStatisticsApi.md#get_stat_query_fields12) | **GET** /statistics/interface/query/fields | 
*MonitoringInterfaceStatisticsApi* | [**get_statistics_per_interface**](docs/MonitoringInterfaceStatisticsApi.md#get_statistics_per_interface) | **GET** /statistics/interface/type | 
*MonitoringInterfaceStatisticsApi* | [**get_stats_raw_data10**](docs/MonitoringInterfaceStatisticsApi.md#get_stats_raw_data10) | **POST** /statistics/interface | 
*MonitoringQoSApi* | [**get_aggregation_data_by_query13**](docs/MonitoringQoSApi.md#get_aggregation_data_by_query13) | **GET** /statistics/qos/aggregation | 
*MonitoringQoSApi* | [**get_count15**](docs/MonitoringQoSApi.md#get_count15) | **GET** /statistics/qos/doccount | 
*MonitoringQoSApi* | [**get_count_post15**](docs/MonitoringQoSApi.md#get_count_post15) | **POST** /statistics/qos/doccount | 
*MonitoringQoSApi* | [**get_post_aggregation_app_data_by_query12**](docs/MonitoringQoSApi.md#get_post_aggregation_app_data_by_query12) | **POST** /statistics/qos/app-agg/aggregation | 
*MonitoringQoSApi* | [**get_post_aggregation_data_by_query12**](docs/MonitoringQoSApi.md#get_post_aggregation_data_by_query12) | **POST** /statistics/qos/aggregation | 
*MonitoringQoSApi* | [**get_post_stat_bulk_raw_data13**](docs/MonitoringQoSApi.md#get_post_stat_bulk_raw_data13) | **POST** /statistics/qos/page | 
*MonitoringQoSApi* | [**get_stat_bulk_raw_data13**](docs/MonitoringQoSApi.md#get_stat_bulk_raw_data13) | **GET** /statistics/qos/page | 
*MonitoringQoSApi* | [**get_stat_data_fields15**](docs/MonitoringQoSApi.md#get_stat_data_fields15) | **GET** /statistics/qos/fields | 
*MonitoringQoSApi* | [**get_stat_data_raw_data13**](docs/MonitoringQoSApi.md#get_stat_data_raw_data13) | **GET** /statistics/qos | 
*MonitoringQoSApi* | [**get_stat_data_raw_data_as_csv13**](docs/MonitoringQoSApi.md#get_stat_data_raw_data_as_csv13) | **GET** /statistics/qos/csv | 
*MonitoringQoSApi* | [**get_stat_query_fields15**](docs/MonitoringQoSApi.md#get_stat_query_fields15) | **GET** /statistics/qos/query/fields | 
*MonitoringQoSApi* | [**get_stats_raw_data13**](docs/MonitoringQoSApi.md#get_stats_raw_data13) | **POST** /statistics/qos | 
*MonitoringSecurityUnifiedLoggingConnectionEventsApi* | [**get_aggregation_data_by_query14**](docs/MonitoringSecurityUnifiedLoggingConnectionEventsApi.md#get_aggregation_data_by_query14) | **GET** /statistics/sul/connections/aggregation | 
*MonitoringSecurityUnifiedLoggingConnectionEventsApi* | [**get_count16**](docs/MonitoringSecurityUnifiedLoggingConnectionEventsApi.md#get_count16) | **GET** /statistics/sul/connections/doccount | 
*MonitoringSecurityUnifiedLoggingConnectionEventsApi* | [**get_count_post16**](docs/MonitoringSecurityUnifiedLoggingConnectionEventsApi.md#get_count_post16) | **POST** /statistics/sul/connections/doccount | 
*MonitoringSecurityUnifiedLoggingConnectionEventsApi* | [**get_filter_policy_name_list**](docs/MonitoringSecurityUnifiedLoggingConnectionEventsApi.md#get_filter_policy_name_list) | **GET** /statistics/sul/connections/filter/policy_name/{policyType} | 
*MonitoringSecurityUnifiedLoggingConnectionEventsApi* | [**get_post_aggregation_app_data_by_query13**](docs/MonitoringSecurityUnifiedLoggingConnectionEventsApi.md#get_post_aggregation_app_data_by_query13) | **POST** /statistics/sul/connections/app-agg/aggregation | 
*MonitoringSecurityUnifiedLoggingConnectionEventsApi* | [**get_post_aggregation_data_by_query13**](docs/MonitoringSecurityUnifiedLoggingConnectionEventsApi.md#get_post_aggregation_data_by_query13) | **POST** /statistics/sul/connections/aggregation | 
*MonitoringSecurityUnifiedLoggingConnectionEventsApi* | [**get_post_stat_bulk_raw_data14**](docs/MonitoringSecurityUnifiedLoggingConnectionEventsApi.md#get_post_stat_bulk_raw_data14) | **POST** /statistics/sul/connections/page | 
*MonitoringSecurityUnifiedLoggingConnectionEventsApi* | [**get_stat_bulk_raw_data14**](docs/MonitoringSecurityUnifiedLoggingConnectionEventsApi.md#get_stat_bulk_raw_data14) | **GET** /statistics/sul/connections/page | 
*MonitoringSecurityUnifiedLoggingConnectionEventsApi* | [**get_stat_data_fields16**](docs/MonitoringSecurityUnifiedLoggingConnectionEventsApi.md#get_stat_data_fields16) | **GET** /statistics/sul/connections/fields | 
*MonitoringSecurityUnifiedLoggingConnectionEventsApi* | [**get_stat_data_raw_data_as_csv14**](docs/MonitoringSecurityUnifiedLoggingConnectionEventsApi.md#get_stat_data_raw_data_as_csv14) | **GET** /statistics/sul/connections/csv | 
*MonitoringSecurityUnifiedLoggingConnectionEventsApi* | [**get_stat_query_fields16**](docs/MonitoringSecurityUnifiedLoggingConnectionEventsApi.md#get_stat_query_fields16) | **GET** /statistics/sul/connections/query/fields | 
*MonitoringSecurityUnifiedLoggingConnectionEventsApi* | [**get_stats_raw_data14**](docs/MonitoringSecurityUnifiedLoggingConnectionEventsApi.md#get_stats_raw_data14) | **POST** /statistics/sul/connections | 
*MonitoringSecurityUnifiedLoggingConnectionEventsApi* | [**get_sul_stat_data_raw_data**](docs/MonitoringSecurityUnifiedLoggingConnectionEventsApi.md#get_sul_stat_data_raw_data) | **GET** /statistics/sul/connections | 
*MonitoringServerInfoApi* | [**create_server_info**](docs/MonitoringServerInfoApi.md#create_server_info) | **GET** /server/info | 
*MonitoringServiceChainStatisticsApi* | [**get_aggregation_data_by_query11**](docs/MonitoringServiceChainStatisticsApi.md#get_aggregation_data_by_query11) | **GET** /statistics/vnfstatistics/aggregation | 
*MonitoringServiceChainStatisticsApi* | [**get_count13**](docs/MonitoringServiceChainStatisticsApi.md#get_count13) | **GET** /statistics/vnfstatistics/doccount | 
*MonitoringServiceChainStatisticsApi* | [**get_count_post13**](docs/MonitoringServiceChainStatisticsApi.md#get_count_post13) | **POST** /statistics/vnfstatistics/doccount | 
*MonitoringServiceChainStatisticsApi* | [**get_post_aggregation_app_data_by_query11**](docs/MonitoringServiceChainStatisticsApi.md#get_post_aggregation_app_data_by_query11) | **POST** /statistics/vnfstatistics/app-agg/aggregation | 
*MonitoringServiceChainStatisticsApi* | [**get_post_aggregation_data_by_query11**](docs/MonitoringServiceChainStatisticsApi.md#get_post_aggregation_data_by_query11) | **POST** /statistics/vnfstatistics/aggregation | 
*MonitoringServiceChainStatisticsApi* | [**get_post_stat_bulk_raw_data11**](docs/MonitoringServiceChainStatisticsApi.md#get_post_stat_bulk_raw_data11) | **POST** /statistics/vnfstatistics/page | 
*MonitoringServiceChainStatisticsApi* | [**get_stat_bulk_raw_data11**](docs/MonitoringServiceChainStatisticsApi.md#get_stat_bulk_raw_data11) | **GET** /statistics/vnfstatistics/page | 
*MonitoringServiceChainStatisticsApi* | [**get_stat_data_fields13**](docs/MonitoringServiceChainStatisticsApi.md#get_stat_data_fields13) | **GET** /statistics/vnfstatistics/fields | 
*MonitoringServiceChainStatisticsApi* | [**get_stat_data_raw_data11**](docs/MonitoringServiceChainStatisticsApi.md#get_stat_data_raw_data11) | **GET** /statistics/vnfstatistics | 
*MonitoringServiceChainStatisticsApi* | [**get_stat_data_raw_data_as_csv11**](docs/MonitoringServiceChainStatisticsApi.md#get_stat_data_raw_data_as_csv11) | **GET** /statistics/vnfstatistics/csv | 
*MonitoringServiceChainStatisticsApi* | [**get_stat_query_fields13**](docs/MonitoringServiceChainStatisticsApi.md#get_stat_query_fields13) | **GET** /statistics/vnfstatistics/query/fields | 
*MonitoringServiceChainStatisticsApi* | [**get_stats_raw_data11**](docs/MonitoringServiceChainStatisticsApi.md#get_stats_raw_data11) | **POST** /statistics/vnfstatistics | 
*MonitoringStatsDownloadApi* | [**download1**](docs/MonitoringStatsDownloadApi.md#download1) | **GET** /statistics/download/{processType}/file/{fileType}/{queue}/{deviceIp}/{token}/{fileName} | 
*MonitoringStatsDownloadApi* | [**download_list**](docs/MonitoringStatsDownloadApi.md#download_list) | **POST** /statistics/download/{processType}/filelist | 
*MonitoringStatsDownloadApi* | [**fetch_list**](docs/MonitoringStatsDownloadApi.md#fetch_list) | **GET** /statistics/download/{processType}/fetchvManageList | 
*MonitoringStatsProcessingApi* | [**enable_statistics_demo_mode**](docs/MonitoringStatsProcessingApi.md#enable_statistics_demo_mode) | **GET** /statistics/demomode | 
*MonitoringStatsProcessingApi* | [**generate_stats_collect_thread_report**](docs/MonitoringStatsProcessingApi.md#generate_stats_collect_thread_report) | **GET** /statistics/collect/thread/status | 
*MonitoringStatsProcessingApi* | [**generate_stats_process_report**](docs/MonitoringStatsProcessingApi.md#generate_stats_process_report) | **GET** /statistics/process/status | 
*MonitoringStatsProcessingApi* | [**generate_stats_process_thread_report**](docs/MonitoringStatsProcessingApi.md#generate_stats_process_thread_report) | **GET** /statistics/process/thread/status | 
*MonitoringStatsProcessingApi* | [**get_statistic_type**](docs/MonitoringStatsProcessingApi.md#get_statistic_type) | **GET** /statistics | 
*MonitoringStatsProcessingApi* | [**get_statistics_processing_counters**](docs/MonitoringStatsProcessingApi.md#get_statistics_processing_counters) | **GET** /statistics/process/counters | 
*MonitoringStatsProcessingApi* | [**process_statistics_data**](docs/MonitoringStatsProcessingApi.md#process_statistics_data) | **GET** /statistics/process | 
*MonitoringStatsProcessingApi* | [**reset_stats_collection**](docs/MonitoringStatsProcessingApi.md#reset_stats_collection) | **GET** /statistics/collection/reset/{processQueue} | 
*MonitoringStatsProcessingApi* | [**start_stats_collection**](docs/MonitoringStatsProcessingApi.md#start_stats_collection) | **GET** /statistics/collect | 
*MonitoringStatusApi* | [**get_disabled_device_list**](docs/MonitoringStatusApi.md#get_disabled_device_list) | **GET** /statistics/settings/disable/devicelist/{indexName} | 
*MonitoringStatusApi* | [**get_enabled_index_for_device**](docs/MonitoringStatusApi.md#get_enabled_index_for_device) | **GET** /statistics/settings/status/device | 
*MonitoringStatusApi* | [**get_statistics_settings**](docs/MonitoringStatusApi.md#get_statistics_settings) | **GET** /statistics/settings/status | 
*MonitoringStatusApi* | [**update_statistics_device_list**](docs/MonitoringStatusApi.md#update_statistics_device_list) | **PUT** /statistics/settings/disable/devicelist/{indexName} | 
*MonitoringStatusApi* | [**update_statistics_settings**](docs/MonitoringStatusApi.md#update_statistics_settings) | **PUT** /statistics/settings/status | 
*MonitoringSystemStatusStatsApi* | [**get_aggregation_data_by_query17**](docs/MonitoringSystemStatusStatsApi.md#get_aggregation_data_by_query17) | **GET** /statistics/system/stats/aggregation | 
*MonitoringSystemStatusStatsApi* | [**get_count19**](docs/MonitoringSystemStatusStatsApi.md#get_count19) | **GET** /statistics/system/stats/doccount | 
*MonitoringSystemStatusStatsApi* | [**get_count_post19**](docs/MonitoringSystemStatusStatsApi.md#get_count_post19) | **POST** /statistics/system/stats/doccount | 
*MonitoringSystemStatusStatsApi* | [**get_post_aggregation_app_data_by_query16**](docs/MonitoringSystemStatusStatsApi.md#get_post_aggregation_app_data_by_query16) | **POST** /statistics/system/stats/app-agg/aggregation | 
*MonitoringSystemStatusStatsApi* | [**get_post_aggregation_data_by_query16**](docs/MonitoringSystemStatusStatsApi.md#get_post_aggregation_data_by_query16) | **POST** /statistics/system/stats/aggregation | 
*MonitoringSystemStatusStatsApi* | [**get_post_stat_bulk_raw_data17**](docs/MonitoringSystemStatusStatsApi.md#get_post_stat_bulk_raw_data17) | **POST** /statistics/system/stats/page | 
*MonitoringSystemStatusStatsApi* | [**get_stat_bulk_raw_data17**](docs/MonitoringSystemStatusStatsApi.md#get_stat_bulk_raw_data17) | **GET** /statistics/system/stats/page | 
*MonitoringSystemStatusStatsApi* | [**get_stat_data_fields19**](docs/MonitoringSystemStatusStatsApi.md#get_stat_data_fields19) | **GET** /statistics/system/stats/fields | 
*MonitoringSystemStatusStatsApi* | [**get_stat_data_raw_data16**](docs/MonitoringSystemStatusStatsApi.md#get_stat_data_raw_data16) | **GET** /statistics/system/stats | 
*MonitoringSystemStatusStatsApi* | [**get_stat_data_raw_data_as_csv17**](docs/MonitoringSystemStatusStatsApi.md#get_stat_data_raw_data_as_csv17) | **GET** /statistics/system/stats/csv | 
*MonitoringSystemStatusStatsApi* | [**get_stat_query_fields19**](docs/MonitoringSystemStatusStatsApi.md#get_stat_query_fields19) | **GET** /statistics/system/stats/query/fields | 
*MonitoringSystemStatusStatsApi* | [**get_stats_raw_data17**](docs/MonitoringSystemStatusStatsApi.md#get_stats_raw_data17) | **POST** /statistics/system/stats | 
*MonitoringURLFilteringApi* | [**get_aggregation_data_by_query22**](docs/MonitoringURLFilteringApi.md#get_aggregation_data_by_query22) | **GET** /statistics/urlf/aggregation | 
*MonitoringURLFilteringApi* | [**get_count24**](docs/MonitoringURLFilteringApi.md#get_count24) | **GET** /statistics/urlf/doccount | 
*MonitoringURLFilteringApi* | [**get_count_post24**](docs/MonitoringURLFilteringApi.md#get_count_post24) | **POST** /statistics/urlf/doccount | 
*MonitoringURLFilteringApi* | [**get_post_aggregation_app_data_by_query21**](docs/MonitoringURLFilteringApi.md#get_post_aggregation_app_data_by_query21) | **POST** /statistics/urlf/app-agg/aggregation | 
*MonitoringURLFilteringApi* | [**get_post_aggregation_data_by_query21**](docs/MonitoringURLFilteringApi.md#get_post_aggregation_data_by_query21) | **POST** /statistics/urlf/aggregation | 
*MonitoringURLFilteringApi* | [**get_post_stat_bulk_raw_data22**](docs/MonitoringURLFilteringApi.md#get_post_stat_bulk_raw_data22) | **POST** /statistics/urlf/page | 
*MonitoringURLFilteringApi* | [**get_stat_bulk_raw_data22**](docs/MonitoringURLFilteringApi.md#get_stat_bulk_raw_data22) | **GET** /statistics/urlf/page | 
*MonitoringURLFilteringApi* | [**get_stat_data_fields24**](docs/MonitoringURLFilteringApi.md#get_stat_data_fields24) | **GET** /statistics/urlf/fields | 
*MonitoringURLFilteringApi* | [**get_stat_data_raw_data21**](docs/MonitoringURLFilteringApi.md#get_stat_data_raw_data21) | **GET** /statistics/urlf | 
*MonitoringURLFilteringApi* | [**get_stat_data_raw_data_as_csv22**](docs/MonitoringURLFilteringApi.md#get_stat_data_raw_data_as_csv22) | **GET** /statistics/urlf/csv | 
*MonitoringURLFilteringApi* | [**get_stat_query_fields24**](docs/MonitoringURLFilteringApi.md#get_stat_query_fields24) | **GET** /statistics/urlf/query/fields | 
*MonitoringURLFilteringApi* | [**get_stats_raw_data22**](docs/MonitoringURLFilteringApi.md#get_stats_raw_data22) | **POST** /statistics/urlf | 
*MonitoringUmbrellaApi* | [**get_aggregation_data_by_query24**](docs/MonitoringUmbrellaApi.md#get_aggregation_data_by_query24) | **GET** /statistics/umbrella/aggregation | 
*MonitoringUmbrellaApi* | [**get_count26**](docs/MonitoringUmbrellaApi.md#get_count26) | **GET** /statistics/umbrella/doccount | 
*MonitoringUmbrellaApi* | [**get_count_post26**](docs/MonitoringUmbrellaApi.md#get_count_post26) | **POST** /statistics/umbrella/doccount | 
*MonitoringUmbrellaApi* | [**get_post_aggregation_app_data_by_query23**](docs/MonitoringUmbrellaApi.md#get_post_aggregation_app_data_by_query23) | **POST** /statistics/umbrella/app-agg/aggregation | 
*MonitoringUmbrellaApi* | [**get_post_aggregation_data_by_query23**](docs/MonitoringUmbrellaApi.md#get_post_aggregation_data_by_query23) | **POST** /statistics/umbrella/aggregation | 
*MonitoringUmbrellaApi* | [**get_post_stat_bulk_raw_data24**](docs/MonitoringUmbrellaApi.md#get_post_stat_bulk_raw_data24) | **POST** /statistics/umbrella/page | 
*MonitoringUmbrellaApi* | [**get_stat_bulk_raw_data24**](docs/MonitoringUmbrellaApi.md#get_stat_bulk_raw_data24) | **GET** /statistics/umbrella/page | 
*MonitoringUmbrellaApi* | [**get_stat_data_fields26**](docs/MonitoringUmbrellaApi.md#get_stat_data_fields26) | **GET** /statistics/umbrella/fields | 
*MonitoringUmbrellaApi* | [**get_stat_data_raw_data23**](docs/MonitoringUmbrellaApi.md#get_stat_data_raw_data23) | **GET** /statistics/umbrella | 
*MonitoringUmbrellaApi* | [**get_stat_data_raw_data_as_csv24**](docs/MonitoringUmbrellaApi.md#get_stat_data_raw_data_as_csv24) | **GET** /statistics/umbrella/csv | 
*MonitoringUmbrellaApi* | [**get_stat_query_fields26**](docs/MonitoringUmbrellaApi.md#get_stat_query_fields26) | **GET** /statistics/umbrella/query/fields | 
*MonitoringUmbrellaApi* | [**get_stats_raw_data24**](docs/MonitoringUmbrellaApi.md#get_stats_raw_data24) | **POST** /statistics/umbrella | 
*MonitoringUmbrellaPatternsApi* | [**get_aggregation_data_by_query23**](docs/MonitoringUmbrellaPatternsApi.md#get_aggregation_data_by_query23) | **GET** /statistics/fwall/aggregation | 
*MonitoringUmbrellaPatternsApi* | [**get_count25**](docs/MonitoringUmbrellaPatternsApi.md#get_count25) | **GET** /statistics/fwall/doccount | 
*MonitoringUmbrellaPatternsApi* | [**get_count_post25**](docs/MonitoringUmbrellaPatternsApi.md#get_count_post25) | **POST** /statistics/fwall/doccount | 
*MonitoringUmbrellaPatternsApi* | [**get_post_aggregation_app_data_by_query22**](docs/MonitoringUmbrellaPatternsApi.md#get_post_aggregation_app_data_by_query22) | **POST** /statistics/fwall/app-agg/aggregation | 
*MonitoringUmbrellaPatternsApi* | [**get_post_aggregation_data_by_query22**](docs/MonitoringUmbrellaPatternsApi.md#get_post_aggregation_data_by_query22) | **POST** /statistics/fwall/aggregation | 
*MonitoringUmbrellaPatternsApi* | [**get_post_stat_bulk_raw_data23**](docs/MonitoringUmbrellaPatternsApi.md#get_post_stat_bulk_raw_data23) | **POST** /statistics/fwall/page | 
*MonitoringUmbrellaPatternsApi* | [**get_stat_bulk_raw_data23**](docs/MonitoringUmbrellaPatternsApi.md#get_stat_bulk_raw_data23) | **GET** /statistics/fwall/page | 
*MonitoringUmbrellaPatternsApi* | [**get_stat_data_fields25**](docs/MonitoringUmbrellaPatternsApi.md#get_stat_data_fields25) | **GET** /statistics/fwall/fields | 
*MonitoringUmbrellaPatternsApi* | [**get_stat_data_raw_data22**](docs/MonitoringUmbrellaPatternsApi.md#get_stat_data_raw_data22) | **GET** /statistics/fwall | 
*MonitoringUmbrellaPatternsApi* | [**get_stat_data_raw_data_as_csv23**](docs/MonitoringUmbrellaPatternsApi.md#get_stat_data_raw_data_as_csv23) | **GET** /statistics/fwall/csv | 
*MonitoringUmbrellaPatternsApi* | [**get_stat_query_fields25**](docs/MonitoringUmbrellaPatternsApi.md#get_stat_query_fields25) | **GET** /statistics/fwall/query/fields | 
*MonitoringUmbrellaPatternsApi* | [**get_stats_raw_data23**](docs/MonitoringUmbrellaPatternsApi.md#get_stats_raw_data23) | **POST** /statistics/fwall | 
*MonitoringWlanClientInfoApi* | [**get_aggregation_data_by_query19**](docs/MonitoringWlanClientInfoApi.md#get_aggregation_data_by_query19) | **GET** /statistics/wlanclientinfo/aggregation | 
*MonitoringWlanClientInfoApi* | [**get_count21**](docs/MonitoringWlanClientInfoApi.md#get_count21) | **GET** /statistics/wlanclientinfo/doccount | 
*MonitoringWlanClientInfoApi* | [**get_count_post21**](docs/MonitoringWlanClientInfoApi.md#get_count_post21) | **POST** /statistics/wlanclientinfo/doccount | 
*MonitoringWlanClientInfoApi* | [**get_post_aggregation_app_data_by_query18**](docs/MonitoringWlanClientInfoApi.md#get_post_aggregation_app_data_by_query18) | **POST** /statistics/wlanclientinfo/app-agg/aggregation | 
*MonitoringWlanClientInfoApi* | [**get_post_aggregation_data_by_query18**](docs/MonitoringWlanClientInfoApi.md#get_post_aggregation_data_by_query18) | **POST** /statistics/wlanclientinfo/aggregation | 
*MonitoringWlanClientInfoApi* | [**get_post_stat_bulk_raw_data19**](docs/MonitoringWlanClientInfoApi.md#get_post_stat_bulk_raw_data19) | **POST** /statistics/wlanclientinfo/page | 
*MonitoringWlanClientInfoApi* | [**get_stat_bulk_raw_data19**](docs/MonitoringWlanClientInfoApi.md#get_stat_bulk_raw_data19) | **GET** /statistics/wlanclientinfo/page | 
*MonitoringWlanClientInfoApi* | [**get_stat_data_fields21**](docs/MonitoringWlanClientInfoApi.md#get_stat_data_fields21) | **GET** /statistics/wlanclientinfo/fields | 
*MonitoringWlanClientInfoApi* | [**get_stat_data_raw_data18**](docs/MonitoringWlanClientInfoApi.md#get_stat_data_raw_data18) | **GET** /statistics/wlanclientinfo | 
*MonitoringWlanClientInfoApi* | [**get_stat_data_raw_data_as_csv19**](docs/MonitoringWlanClientInfoApi.md#get_stat_data_raw_data_as_csv19) | **GET** /statistics/wlanclientinfo/csv | 
*MonitoringWlanClientInfoApi* | [**get_stat_query_fields21**](docs/MonitoringWlanClientInfoApi.md#get_stat_query_fields21) | **GET** /statistics/wlanclientinfo/query/fields | 
*MonitoringWlanClientInfoApi* | [**get_stats_raw_data19**](docs/MonitoringWlanClientInfoApi.md#get_stats_raw_data19) | **POST** /statistics/wlanclientinfo | 
*MultitenantAPIsProviderApi* | [**create_tenant**](docs/MultitenantAPIsProviderApi.md#create_tenant) | **POST** /tenant | 
*MultitenantAPIsProviderApi* | [**create_tenant_async**](docs/MultitenantAPIsProviderApi.md#create_tenant_async) | **POST** /tenant/async | 
*MultitenantAPIsProviderApi* | [**create_tenant_async_bulk**](docs/MultitenantAPIsProviderApi.md#create_tenant_async_bulk) | **POST** /tenant/bulk/async | 
*MultitenantAPIsProviderApi* | [**delete_tenant**](docs/MultitenantAPIsProviderApi.md#delete_tenant) | **POST** /tenant/{tenantId}/delete | 
*MultitenantAPIsProviderApi* | [**delete_tenant_async_bulk**](docs/MultitenantAPIsProviderApi.md#delete_tenant_async_bulk) | **DELETE** /tenant/bulk/async | 
*MultitenantAPIsProviderApi* | [**delete_tenant_backup**](docs/MultitenantAPIsProviderApi.md#delete_tenant_backup) | **DELETE** /tenantbackup/delete | 
*MultitenantAPIsProviderApi* | [**download_existing_backup_file**](docs/MultitenantAPIsProviderApi.md#download_existing_backup_file) | **GET** /tenantbackup/download/{path} | 
*MultitenantAPIsProviderApi* | [**export_tenant_backup**](docs/MultitenantAPIsProviderApi.md#export_tenant_backup) | **GET** /tenantbackup/export | 
*MultitenantAPIsProviderApi* | [**force_status_collection**](docs/MultitenantAPIsProviderApi.md#force_status_collection) | **POST** /tenantstatus/force | 
*MultitenantAPIsProviderApi* | [**get_all_tenant_statuses**](docs/MultitenantAPIsProviderApi.md#get_all_tenant_statuses) | **GET** /tenantstatus | 
*MultitenantAPIsProviderApi* | [**get_all_tenants**](docs/MultitenantAPIsProviderApi.md#get_all_tenants) | **GET** /tenant | 
*MultitenantAPIsProviderApi* | [**get_tenant**](docs/MultitenantAPIsProviderApi.md#get_tenant) | **GET** /tenant/{tenantId} | 
*MultitenantAPIsProviderApi* | [**get_tenant_hosting_capacity_onv_smarts**](docs/MultitenantAPIsProviderApi.md#get_tenant_hosting_capacity_onv_smarts) | **GET** /tenant/vsmart/capacity | 
*MultitenantAPIsProviderApi* | [**get_tenantv_smart_mapping**](docs/MultitenantAPIsProviderApi.md#get_tenantv_smart_mapping) | **GET** /tenant/vsmart | 
*MultitenantAPIsProviderApi* | [**import_tenant_backup**](docs/MultitenantAPIsProviderApi.md#import_tenant_backup) | **POST** /tenantbackup/import | 
*MultitenantAPIsProviderApi* | [**list_tenant_backup**](docs/MultitenantAPIsProviderApi.md#list_tenant_backup) | **GET** /tenantbackup/list | 
*MultitenantAPIsProviderApi* | [**switch_tenant**](docs/MultitenantAPIsProviderApi.md#switch_tenant) | **POST** /tenant/{tenantId}/switch | 
*MultitenantAPIsProviderApi* | [**tenantv_smart_mt_migrate**](docs/MultitenantAPIsProviderApi.md#tenantv_smart_mt_migrate) | **POST** /tenant/vsmart-mt/migrate | 
*MultitenantAPIsProviderApi* | [**update_tenant**](docs/MultitenantAPIsProviderApi.md#update_tenant) | **PUT** /tenant/{tenantId} | 
*MultitenantAPIsProviderApi* | [**v_session_id**](docs/MultitenantAPIsProviderApi.md#v_session_id) | **POST** /tenant/{tenantId}/vsessionid | 
*PartnerACIPolicyBuilderApi* | [**create_dscp_mappings**](docs/PartnerACIPolicyBuilderApi.md#create_dscp_mappings) | **POST** /partner/aci/policy/dscpmapping/{partnerId} | 
*PartnerACIPolicyBuilderApi* | [**delete_dscp_mappings**](docs/PartnerACIPolicyBuilderApi.md#delete_dscp_mappings) | **DELETE** /partner/aci/policy/dscpmapping/{partnerId} | 
*PartnerACIPolicyBuilderApi* | [**get_aci_definitions**](docs/PartnerACIPolicyBuilderApi.md#get_aci_definitions) | **GET** /partner/aci/policy | 
*PartnerACIPolicyBuilderApi* | [**get_data_prefix_mappings**](docs/PartnerACIPolicyBuilderApi.md#get_data_prefix_mappings) | **GET** /partner/aci/policy/prefixmapping/{partnerId} | 
*PartnerACIPolicyBuilderApi* | [**get_data_prefix_sequences**](docs/PartnerACIPolicyBuilderApi.md#get_data_prefix_sequences) | **GET** /partner/aci/policy/sequences | 
*PartnerACIPolicyBuilderApi* | [**get_dscp_mappings**](docs/PartnerACIPolicyBuilderApi.md#get_dscp_mappings) | **GET** /partner/aci/policy/dscpmapping/{partnerId} | 
*PartnerACIPolicyBuilderApi* | [**get_events**](docs/PartnerACIPolicyBuilderApi.md#get_events) | **GET** /partner/aci/policy/events/{partnerId} | 
*PartnerACIPolicyBuilderApi* | [**set_data_prefix_mappings**](docs/PartnerACIPolicyBuilderApi.md#set_data_prefix_mappings) | **POST** /partner/aci/policy/prefixmapping/{partnerId} | 
*PartnerDNACSDAAPIApi* | [**create_sda_config**](docs/PartnerDNACSDAAPIApi.md#create_sda_config) | **POST** /partner/dnac/sda/config/{partnerId} | 
*PartnerDNACSDAAPIApi* | [**create_sda_config_from_netconf**](docs/PartnerDNACSDAAPIApi.md#create_sda_config_from_netconf) | **POST** /partner/dnac/sda/netconfconfig/{partnerId} | 
*PartnerDNACSDAAPIApi* | [**get_device_details**](docs/PartnerDNACSDAAPIApi.md#get_device_details) | **GET** /partner/dnac/sda/device/{partnerId}/{uuid} | 
*PartnerDNACSDAAPIApi* | [**get_overlay_vpn_list**](docs/PartnerDNACSDAAPIApi.md#get_overlay_vpn_list) | **GET** /partner/dnac/sda/vpn | 
*PartnerDNACSDAAPIApi* | [**get_sda_enabled_devices**](docs/PartnerDNACSDAAPIApi.md#get_sda_enabled_devices) | **GET** /partner/dnac/sda/device/{partnerId} | 
*PartnerDNACSDAAPIApi* | [**get_sites_for_partner**](docs/PartnerDNACSDAAPIApi.md#get_sites_for_partner) | **GET** /partner/dnac/sda/site/{partnerId} | 
*PartnerRegistrationApi* | [**delete_device_mapping**](docs/PartnerRegistrationApi.md#delete_device_mapping) | **POST** /partner/{partnerType}/unmap/{nmsId} | 
*PartnerRegistrationApi* | [**delete_partner**](docs/PartnerRegistrationApi.md#delete_partner) | **DELETE** /partner/{partnerType}/{nmsId} | 
*PartnerRegistrationApi* | [**get_data_change_info**](docs/PartnerRegistrationApi.md#get_data_change_info) | **GET** /serverlongpoll/event/poll/{partnerId} | 
*PartnerRegistrationApi* | [**get_partner**](docs/PartnerRegistrationApi.md#get_partner) | **GET** /partner/{partnerType}/{nmsId} | 
*PartnerRegistrationApi* | [**get_partner_devices**](docs/PartnerRegistrationApi.md#get_partner_devices) | **GET** /partner/{partnerType}/map/{nmsId} | 
*PartnerRegistrationApi* | [**get_partners**](docs/PartnerRegistrationApi.md#get_partners) | **GET** /partner | 
*PartnerRegistrationApi* | [**get_partners_by_partner_type**](docs/PartnerRegistrationApi.md#get_partners_by_partner_type) | **GET** /partner/{partnerType} | 
*PartnerRegistrationApi* | [**get_vpn_list**](docs/PartnerRegistrationApi.md#get_vpn_list) | **GET** /partner/vpn | 
*PartnerRegistrationApi* | [**map_devices**](docs/PartnerRegistrationApi.md#map_devices) | **POST** /partner/{partnerType}/map/{nmsId} | 
*PartnerRegistrationApi* | [**register_partner**](docs/PartnerRegistrationApi.md#register_partner) | **POST** /partner/{partnerType} | 
*PartnerRegistrationApi* | [**unmap_devices**](docs/PartnerRegistrationApi.md#unmap_devices) | **DELETE** /partner/{partnerType}/map/{nmsId} | 
*PartnerRegistrationApi* | [**update_partner**](docs/PartnerRegistrationApi.md#update_partner) | **PUT** /partner/{partnerType}/{nmsId} | 
*PartnerWCMConfigsApi* | [**push_netconf_configs**](docs/PartnerWCMConfigsApi.md#push_netconf_configs) | **POST** /partner/wcm/netconf/{nmsId} | 
*RealTimeMonitoringAAAApi* | [**get_aa_aservers**](docs/RealTimeMonitoringAAAApi.md#get_aa_aservers) | **GET** /device/aaa/servers | 
*RealTimeMonitoringAAAApi* | [**get_aaa_users**](docs/RealTimeMonitoringAAAApi.md#get_aaa_users) | **GET** /device/aaa/users | 
*RealTimeMonitoringAAAApi* | [**get_acl_match_counter_users**](docs/RealTimeMonitoringAAAApi.md#get_acl_match_counter_users) | **GET** /device/acl/matchcounter | 
*RealTimeMonitoringAAAApi* | [**get_all_device_users**](docs/RealTimeMonitoringAAAApi.md#get_all_device_users) | **GET** /device/users/list | 
*RealTimeMonitoringAAAApi* | [**get_logging_from_device**](docs/RealTimeMonitoringAAAApi.md#get_logging_from_device) | **GET** /device/logging | 
*RealTimeMonitoringAAAApi* | [**get_unclaimed_vedges**](docs/RealTimeMonitoringAAAApi.md#get_unclaimed_vedges) | **GET** /device/unclaimed/vedges | 
*RealTimeMonitoringAAAApi* | [**get_users_from_device**](docs/RealTimeMonitoringAAAApi.md#get_users_from_device) | **GET** /device/users | 
*RealTimeMonitoringARPApi* | [**get_arp_interface**](docs/RealTimeMonitoringARPApi.md#get_arp_interface) | **GET** /device/arp | 
*RealTimeMonitoringAppHostingApi* | [**get_app_hosting_attached_devices**](docs/RealTimeMonitoringAppHostingApi.md#get_app_hosting_attached_devices) | **GET** /device/app-hosting/attached-devices | 
*RealTimeMonitoringAppHostingApi* | [**get_app_hosting_details**](docs/RealTimeMonitoringAppHostingApi.md#get_app_hosting_details) | **GET** /device/app-hosting/details | 
*RealTimeMonitoringAppHostingApi* | [**get_app_hosting_guest_routes**](docs/RealTimeMonitoringAppHostingApi.md#get_app_hosting_guest_routes) | **GET** /device/app-hosting/guest-routes | 
*RealTimeMonitoringAppHostingApi* | [**get_app_hosting_network_devices**](docs/RealTimeMonitoringAppHostingApi.md#get_app_hosting_network_devices) | **GET** /device/app-hosting/network-interfaces | 
*RealTimeMonitoringAppHostingApi* | [**get_app_hosting_network_utils**](docs/RealTimeMonitoringAppHostingApi.md#get_app_hosting_network_utils) | **GET** /device/app-hosting/network-utilization | 
*RealTimeMonitoringAppHostingApi* | [**get_app_hosting_processes**](docs/RealTimeMonitoringAppHostingApi.md#get_app_hosting_processes) | **GET** /device/app-hosting/processes | 
*RealTimeMonitoringAppHostingApi* | [**get_app_hosting_storage_utils**](docs/RealTimeMonitoringAppHostingApi.md#get_app_hosting_storage_utils) | **GET** /device/app-hosting/storage-utilization | 
*RealTimeMonitoringAppHostingApi* | [**get_app_hosting_utilization**](docs/RealTimeMonitoringAppHostingApi.md#get_app_hosting_utilization) | **GET** /device/app-hosting/utilization | 
*RealTimeMonitoringAppLogsApi* | [**get_app_log_flow_count**](docs/RealTimeMonitoringAppLogsApi.md#get_app_log_flow_count) | **GET** /device/app/log/flow-count | 
*RealTimeMonitoringAppLogsApi* | [**get_app_log_flows**](docs/RealTimeMonitoringAppLogsApi.md#get_app_log_flows) | **GET** /device/app/log/flows | 
*RealTimeMonitoringApplicationAwareRouteApi* | [**create_app_route_sla_class_list**](docs/RealTimeMonitoringApplicationAwareRouteApi.md#create_app_route_sla_class_list) | **GET** /device/app-route/sla-class | 
*RealTimeMonitoringApplicationAwareRouteApi* | [**create_app_route_statistics_list**](docs/RealTimeMonitoringApplicationAwareRouteApi.md#create_app_route_statistics_list) | **GET** /device/app-route/statistics | 
*RealTimeMonitoringAppqoeApi* | [**get_appqoe_cluster_summary**](docs/RealTimeMonitoringAppqoeApi.md#get_appqoe_cluster_summary) | **GET** /device/appqoe/cluster-summary | 
*RealTimeMonitoringAppqoeApi* | [**get_appqoe_error_recent**](docs/RealTimeMonitoringAppqoeApi.md#get_appqoe_error_recent) | **GET** /device/appqoe/error-recent | 
*RealTimeMonitoringAppqoeApi* | [**get_appqoe_flow_closed_error**](docs/RealTimeMonitoringAppqoeApi.md#get_appqoe_flow_closed_error) | **GET** /device/appqoe/flow-closed-error | 
*RealTimeMonitoringAppqoeApi* | [**get_appqoe_hput_stats**](docs/RealTimeMonitoringAppqoeApi.md#get_appqoe_hput_stats) | **GET** /device/appqoe/appqoe-hput-stats | 
*RealTimeMonitoringAppqoeApi* | [**get_appqoe_nat_stats**](docs/RealTimeMonitoringAppqoeApi.md#get_appqoe_nat_stats) | **GET** /device/appqoe/appqoe-nat-stats | 
*RealTimeMonitoringAppqoeApi* | [**get_appqoe_rm_resources**](docs/RealTimeMonitoringAppqoeApi.md#get_appqoe_rm_resources) | **GET** /device/appqoe/appqoe-rm-resource | 
*RealTimeMonitoringAppqoeApi* | [**get_appqoe_rm_stats**](docs/RealTimeMonitoringAppqoeApi.md#get_appqoe_rm_stats) | **GET** /device/appqoe/appqoe-rm-stats | 
*RealTimeMonitoringAppqoeApi* | [**get_appqoe_service_controllers**](docs/RealTimeMonitoringAppqoeApi.md#get_appqoe_service_controllers) | **GET** /device/appqoe/service-controllers | 
*RealTimeMonitoringAppqoeApi* | [**get_appqoe_services_status**](docs/RealTimeMonitoringAppqoeApi.md#get_appqoe_services_status) | **GET** /device/appqoe/appqoe-services-status | 
*RealTimeMonitoringAppqoeApi* | [**get_appqoe_sppi_pipe_stats**](docs/RealTimeMonitoringAppqoeApi.md#get_appqoe_sppi_pipe_stats) | **GET** /device/appqoe/appqoe-sppi-pipe-resource | 
*RealTimeMonitoringAppqoeApi* | [**get_appqoe_sppi_queue_stats**](docs/RealTimeMonitoringAppqoeApi.md#get_appqoe_sppi_queue_stats) | **GET** /device/appqoe/appqoe-sppi-queue-resource | 
*RealTimeMonitoringAppqoeApi* | [**get_appqoe_status**](docs/RealTimeMonitoringAppqoeApi.md#get_appqoe_status) | **GET** /device/appqoe/status | 
*RealTimeMonitoringBFDApi* | [**create_bfd_history_list**](docs/RealTimeMonitoringBFDApi.md#create_bfd_history_list) | **GET** /device/bfd/history | 
*RealTimeMonitoringBFDApi* | [**create_bfd_link_list**](docs/RealTimeMonitoringBFDApi.md#create_bfd_link_list) | **GET** /device/bfd/links | 
*RealTimeMonitoringBFDApi* | [**create_bfd_sessions**](docs/RealTimeMonitoringBFDApi.md#create_bfd_sessions) | **GET** /device/bfd/sessions | 
*RealTimeMonitoringBFDApi* | [**create_bfd_summary**](docs/RealTimeMonitoringBFDApi.md#create_bfd_summary) | **GET** /device/bfd/summary | 
*RealTimeMonitoringBFDApi* | [**create_synced_bfd_session**](docs/RealTimeMonitoringBFDApi.md#create_synced_bfd_session) | **GET** /device/bfd/synced/sessions | 
*RealTimeMonitoringBFDApi* | [**create_tloc_summary**](docs/RealTimeMonitoringBFDApi.md#create_tloc_summary) | **GET** /device/bfd/tloc | 
*RealTimeMonitoringBFDApi* | [**get_bfd_site_state_detail**](docs/RealTimeMonitoringBFDApi.md#get_bfd_site_state_detail) | **GET** /device/bfd/sites/detail | 
*RealTimeMonitoringBFDApi* | [**get_bfd_sites_summary**](docs/RealTimeMonitoringBFDApi.md#get_bfd_sites_summary) | **GET** /device/bfd/sites/summary | 
*RealTimeMonitoringBFDApi* | [**get_device_bfd_state_summary**](docs/RealTimeMonitoringBFDApi.md#get_device_bfd_state_summary) | **GET** /device/bfd/state/device | 
*RealTimeMonitoringBFDApi* | [**get_device_bfd_state_summary_tloc**](docs/RealTimeMonitoringBFDApi.md#get_device_bfd_state_summary_tloc) | **GET** /device/bfd/state/device/tloc | 
*RealTimeMonitoringBFDApi* | [**get_device_bfd_status**](docs/RealTimeMonitoringBFDApi.md#get_device_bfd_status) | **GET** /device/bfd/status | 
*RealTimeMonitoringBFDApi* | [**get_device_bfd_status_summary**](docs/RealTimeMonitoringBFDApi.md#get_device_bfd_status_summary) | **GET** /device/bfd/summary/device | 
*RealTimeMonitoringBGPApi* | [**create_bgp_neighbors_list**](docs/RealTimeMonitoringBGPApi.md#create_bgp_neighbors_list) | **GET** /device/bgp/neighbors | 
*RealTimeMonitoringBGPApi* | [**create_bgp_routes_list**](docs/RealTimeMonitoringBGPApi.md#create_bgp_routes_list) | **GET** /device/bgp/routes | 
*RealTimeMonitoringBGPApi* | [**create_bgp_summary**](docs/RealTimeMonitoringBGPApi.md#create_bgp_summary) | **GET** /device/bgp/summary | 
*RealTimeMonitoringBridgeApi* | [**get_bridge_interface_list**](docs/RealTimeMonitoringBridgeApi.md#get_bridge_interface_list) | **GET** /device/bridge/interface | 
*RealTimeMonitoringBridgeApi* | [**get_bridge_interface_mac**](docs/RealTimeMonitoringBridgeApi.md#get_bridge_interface_mac) | **GET** /device/bridge/mac | 
*RealTimeMonitoringBridgeApi* | [**get_bridge_interface_table**](docs/RealTimeMonitoringBridgeApi.md#get_bridge_interface_table) | **GET** /device/bridge/table | 
*RealTimeMonitoringCFMApi* | [**get_mp_database**](docs/RealTimeMonitoringCFMApi.md#get_mp_database) | **GET** /device/cfm/mp/database | 
*RealTimeMonitoringCFMApi* | [**get_mp_local_mep**](docs/RealTimeMonitoringCFMApi.md#get_mp_local_mep) | **GET** /device/cfm/mp/local/mep | 
*RealTimeMonitoringCFMApi* | [**get_mp_local_mip**](docs/RealTimeMonitoringCFMApi.md#get_mp_local_mip) | **GET** /device/cfm/mp/local/mip | 
*RealTimeMonitoringCFMApi* | [**get_mp_remote_mep**](docs/RealTimeMonitoringCFMApi.md#get_mp_remote_mep) | **GET** /device/cfm/mp/remotemep | 
*RealTimeMonitoringCellularApi* | [**create_cellular_connection_list**](docs/RealTimeMonitoringCellularApi.md#create_cellular_connection_list) | **GET** /device/cellular/connection | 
*RealTimeMonitoringCellularApi* | [**create_hardware_list**](docs/RealTimeMonitoringCellularApi.md#create_hardware_list) | **GET** /device/cellular/hardware | 
*RealTimeMonitoringCellularApi* | [**create_modem_list**](docs/RealTimeMonitoringCellularApi.md#create_modem_list) | **GET** /device/cellular/modem | 
*RealTimeMonitoringCellularApi* | [**create_network_list**](docs/RealTimeMonitoringCellularApi.md#create_network_list) | **GET** /device/cellular/network | 
*RealTimeMonitoringCellularApi* | [**create_profile_list**](docs/RealTimeMonitoringCellularApi.md#create_profile_list) | **GET** /device/cellular/profiles | 
*RealTimeMonitoringCellularApi* | [**create_radio_list**](docs/RealTimeMonitoringCellularApi.md#create_radio_list) | **GET** /device/cellular/radio | 
*RealTimeMonitoringCellularApi* | [**create_sessions_list**](docs/RealTimeMonitoringCellularApi.md#create_sessions_list) | **GET** /device/cellular/sessions | 
*RealTimeMonitoringCellularApi* | [**get_cellular_status_list**](docs/RealTimeMonitoringCellularApi.md#get_cellular_status_list) | **GET** /device/cellular/status | 
*RealTimeMonitoringCellularAONIpsecInterfaceApi* | [**get_aon_ipsec_interface_counters_info**](docs/RealTimeMonitoringCellularAONIpsecInterfaceApi.md#get_aon_ipsec_interface_counters_info) | **GET** /device/cellularEiolte/ipsec/interface/counters | 
*RealTimeMonitoringCellularAONIpsecInterfaceApi* | [**get_aon_ipsec_interface_sessionnfo**](docs/RealTimeMonitoringCellularAONIpsecInterfaceApi.md#get_aon_ipsec_interface_sessionnfo) | **GET** /device/cellularEiolte/ipsec/interface/session | 
*RealTimeMonitoringCellularEIOLTEConnectionServiceApi* | [**get_eiolte_connection_info**](docs/RealTimeMonitoringCellularEIOLTEConnectionServiceApi.md#get_eiolte_connection_info) | **GET** /device/cellularEiolte/connections | 
*RealTimeMonitoringCellularEIOLTEConnectionServiceApi* | [**get_eiolte_radio_info**](docs/RealTimeMonitoringCellularEIOLTEConnectionServiceApi.md#get_eiolte_radio_info) | **GET** /device/cellularEiolte/radio | 
*RealTimeMonitoringCellularEIOLTEHardwareServiceApi* | [**get_eiolte_hardware_info**](docs/RealTimeMonitoringCellularEIOLTEHardwareServiceApi.md#get_eiolte_hardware_info) | **GET** /device/cellularEiolte/hardware | 
*RealTimeMonitoringCellularEIOLTENetworkServiceApi* | [**get_eiolte_network_info**](docs/RealTimeMonitoringCellularEIOLTENetworkServiceApi.md#get_eiolte_network_info) | **GET** /device/cellularEiolte/network | 
*RealTimeMonitoringCellularEIOLTESimServiceApi* | [**get_eiolte_sim_info**](docs/RealTimeMonitoringCellularEIOLTESimServiceApi.md#get_eiolte_sim_info) | **GET** /device/cellularEiolte/sim | 
*RealTimeMonitoringCloudExpressApi* | [**create_applications_detail_list**](docs/RealTimeMonitoringCloudExpressApi.md#create_applications_detail_list) | **GET** /device/cloudx/application/detail | 
*RealTimeMonitoringCloudExpressApi* | [**create_applications_list**](docs/RealTimeMonitoringCloudExpressApi.md#create_applications_list) | **GET** /device/cloudx/applications | 
*RealTimeMonitoringCloudExpressApi* | [**create_gateway_exits_list**](docs/RealTimeMonitoringCloudExpressApi.md#create_gateway_exits_list) | **GET** /device/cloudx/gatewayexits | 
*RealTimeMonitoringCloudExpressApi* | [**create_lb_applications_list**](docs/RealTimeMonitoringCloudExpressApi.md#create_lb_applications_list) | **GET** /device/cloudx/loadbalance | 
*RealTimeMonitoringCloudExpressApi* | [**create_local_exits_list**](docs/RealTimeMonitoringCloudExpressApi.md#create_local_exits_list) | **GET** /device/cloudx/localexits | 
*RealTimeMonitoringContainerLifecycleApi* | [**create_device_containers_info**](docs/RealTimeMonitoringContainerLifecycleApi.md#create_device_containers_info) | **GET** /device/csp/containers/container | 
*RealTimeMonitoringCrashLogApi* | [**get_all_device_crash_logs**](docs/RealTimeMonitoringCrashLogApi.md#get_all_device_crash_logs) | **GET** /device/crashlog/details | 
*RealTimeMonitoringCrashLogApi* | [**get_device_crash_information**](docs/RealTimeMonitoringCrashLogApi.md#get_device_crash_information) | **GET** /device/crashlog/log | 
*RealTimeMonitoringCrashLogApi* | [**get_device_crash_logs**](docs/RealTimeMonitoringCrashLogApi.md#get_device_crash_logs) | **GET** /device/crashlog | 
*RealTimeMonitoringCrashLogApi* | [**get_device_crash_logs_synced**](docs/RealTimeMonitoringCrashLogApi.md#get_device_crash_logs_synced) | **GET** /device/crashlog/synced | 
*RealTimeMonitoringDHCPApi* | [**get_dhcp_client**](docs/RealTimeMonitoringDHCPApi.md#get_dhcp_client) | **GET** /device/dhcp/client | 
*RealTimeMonitoringDHCPApi* | [**get_dhcp_interface**](docs/RealTimeMonitoringDHCPApi.md#get_dhcp_interface) | **GET** /device/dhcp/interface | 
*RealTimeMonitoringDHCPApi* | [**get_dhcp_server**](docs/RealTimeMonitoringDHCPApi.md#get_dhcp_server) | **GET** /device/dhcp/server | 
*RealTimeMonitoringDHCPApi* | [**get_dhcpv6_interface**](docs/RealTimeMonitoringDHCPApi.md#get_dhcpv6_interface) | **GET** /device/dhcpv6/interface | 
*RealTimeMonitoringDOT1xApi* | [**get_dot1x_radius**](docs/RealTimeMonitoringDOT1xApi.md#get_dot1x_radius) | **GET** /device/dot1x/radius | 
*RealTimeMonitoringDOT1xApi* | [**get_wlandot1x_clients**](docs/RealTimeMonitoringDOT1xApi.md#get_wlandot1x_clients) | **GET** /device/dot1x/clients | 
*RealTimeMonitoringDOT1xApi* | [**get_wlandot1x_interfaces**](docs/RealTimeMonitoringDOT1xApi.md#get_wlandot1x_interfaces) | **GET** /device/dot1x/interfaces | 
*RealTimeMonitoringDPIApi* | [**create_dpi_collector_list**](docs/RealTimeMonitoringDPIApi.md#create_dpi_collector_list) | **GET** /device/dpi/applications | 
*RealTimeMonitoringDPIApi* | [**create_dpi_flows_list**](docs/RealTimeMonitoringDPIApi.md#create_dpi_flows_list) | **GET** /device/dpi/flows | 
*RealTimeMonitoringDPIApi* | [**create_dpi_statistics**](docs/RealTimeMonitoringDPIApi.md#create_dpi_statistics) | **GET** /device/dpi/supported-applications | 
*RealTimeMonitoringDPIApi* | [**create_dpi_summary_real_time**](docs/RealTimeMonitoringDPIApi.md#create_dpi_summary_real_time) | **GET** /device/dpi/summary | 
*RealTimeMonitoringDPIApi* | [**get_common_application_list**](docs/RealTimeMonitoringDPIApi.md#get_common_application_list) | **GET** /device/dpi/common/applications | 
*RealTimeMonitoringDPIApi* | [**get_dpi_device_details_field_json**](docs/RealTimeMonitoringDPIApi.md#get_dpi_device_details_field_json) | **GET** /device/dpi/devicedetails/fields | 
*RealTimeMonitoringDPIApi* | [**get_dpi_device_field_json**](docs/RealTimeMonitoringDPIApi.md#get_dpi_device_field_json) | **GET** /device/dpi/application/fields | 
*RealTimeMonitoringDPIApi* | [**get_dpi_field_json**](docs/RealTimeMonitoringDPIApi.md#get_dpi_field_json) | **GET** /device/dpi/device/fields | 
*RealTimeMonitoringDPIApi* | [**get_qosmos_application_list**](docs/RealTimeMonitoringDPIApi.md#get_qosmos_application_list) | **GET** /device/dpi/qosmos/applications | 
*RealTimeMonitoringDREApi* | [**get_dre_auto_bypass_stats**](docs/RealTimeMonitoringDREApi.md#get_dre_auto_bypass_stats) | **GET** /device/dre/auto-bypass-stats | 
*RealTimeMonitoringDREApi* | [**get_dre_peer_stats**](docs/RealTimeMonitoringDREApi.md#get_dre_peer_stats) | **GET** /device/dre/peer-stats | 
*RealTimeMonitoringDREApi* | [**get_dre_stats**](docs/RealTimeMonitoringDREApi.md#get_dre_stats) | **GET** /device/dre/dre-stats | 
*RealTimeMonitoringDREApi* | [**get_dre_status**](docs/RealTimeMonitoringDREApi.md#get_dre_status) | **GET** /device/dre/dre-status | 
*RealTimeMonitoringDeviceApi* | [**get_ipv6_data**](docs/RealTimeMonitoringDeviceApi.md#get_ipv6_data) | **GET** /device/ipv6/nd6 | 
*RealTimeMonitoringDeviceControlApi* | [**create_connection_history_list_real_time**](docs/RealTimeMonitoringDeviceControlApi.md#create_connection_history_list_real_time) | **GET** /device/control/connectionshistory | 
*RealTimeMonitoringDeviceControlApi* | [**create_connections_summary**](docs/RealTimeMonitoringDeviceControlApi.md#create_connections_summary) | **GET** /device/control/summary | 
*RealTimeMonitoringDeviceControlApi* | [**create_link_list**](docs/RealTimeMonitoringDeviceControlApi.md#create_link_list) | **GET** /device/control/links | 
*RealTimeMonitoringDeviceControlApi* | [**create_local_properties_list_list_real_t_ime**](docs/RealTimeMonitoringDeviceControlApi.md#create_local_properties_list_list_real_t_ime) | **GET** /device/control/localproperties | 
*RealTimeMonitoringDeviceControlApi* | [**create_local_properties_synced_list**](docs/RealTimeMonitoringDeviceControlApi.md#create_local_properties_synced_list) | **GET** /device/control/synced/localproperties | 
*RealTimeMonitoringDeviceControlApi* | [**create_real_time_connection_list**](docs/RealTimeMonitoringDeviceControlApi.md#create_real_time_connection_list) | **GET** /device/control/connections | 
*RealTimeMonitoringDeviceControlApi* | [**create_synced_connection_list**](docs/RealTimeMonitoringDeviceControlApi.md#create_synced_connection_list) | **GET** /device/control/synced/connections | 
*RealTimeMonitoringDeviceControlApi* | [**create_valid_devices_list_real_time**](docs/RealTimeMonitoringDeviceControlApi.md#create_valid_devices_list_real_time) | **GET** /device/control/validdevices | 
*RealTimeMonitoringDeviceControlApi* | [**create_valid_v_smarts_list_real_time**](docs/RealTimeMonitoringDeviceControlApi.md#create_valid_v_smarts_list_real_time) | **GET** /device/control/validvsmarts | 
*RealTimeMonitoringDeviceControlApi* | [**create_wan_interface_list_list**](docs/RealTimeMonitoringDeviceControlApi.md#create_wan_interface_list_list) | **GET** /device/control/waninterface | 
*RealTimeMonitoringDeviceControlApi* | [**create_wan_interface_synced_list**](docs/RealTimeMonitoringDeviceControlApi.md#create_wan_interface_synced_list) | **GET** /device/control/synced/waninterface | 
*RealTimeMonitoringDeviceControlApi* | [**get_affinity_config**](docs/RealTimeMonitoringDeviceControlApi.md#get_affinity_config) | **GET** /device/control/affinity/config | 
*RealTimeMonitoringDeviceControlApi* | [**get_affinity_status**](docs/RealTimeMonitoringDeviceControlApi.md#get_affinity_status) | **GET** /device/control/affinity/status | 
*RealTimeMonitoringDeviceControlApi* | [**get_connection_statistics**](docs/RealTimeMonitoringDeviceControlApi.md#get_connection_statistics) | **GET** /device/control/statistics | 
*RealTimeMonitoringDeviceControlApi* | [**get_device_control_status_summary**](docs/RealTimeMonitoringDeviceControlApi.md#get_device_control_status_summary) | **GET** /device/control/summary/device | 
*RealTimeMonitoringDeviceControlApi* | [**get_local_device_status**](docs/RealTimeMonitoringDeviceControlApi.md#get_local_device_status) | **GET** /device/control/status | 
*RealTimeMonitoringDeviceControlApi* | [**get_port_hop_color**](docs/RealTimeMonitoringDeviceControlApi.md#get_port_hop_color) | **GET** /device/control/waninterface/color | 
*RealTimeMonitoringDeviceControlApi* | [**get_total_count_for_device_states**](docs/RealTimeMonitoringDeviceControlApi.md#get_total_count_for_device_states) | **GET** /device/control/count | 
*RealTimeMonitoringDeviceControlApi* | [**get_valid_v_manage_id_real_time**](docs/RealTimeMonitoringDeviceControlApi.md#get_valid_v_manage_id_real_time) | **GET** /device/control/validvmanageid | 
*RealTimeMonitoringDeviceControlApi* | [**network_summary**](docs/RealTimeMonitoringDeviceControlApi.md#network_summary) | **GET** /device/control/networksummary | 
*RealTimeMonitoringDeviceFeatureListApi* | [**get_feature_list**](docs/RealTimeMonitoringDeviceFeatureListApi.md#get_feature_list) | **GET** /device/featurelist | 
*RealTimeMonitoringDeviceFeatureListApi* | [**get_synced_feature_list**](docs/RealTimeMonitoringDeviceFeatureListApi.md#get_synced_feature_list) | **GET** /device/featurelist/synced | 
*RealTimeMonitoringDeviceSystemStatsApi* | [**create_device_system_cpu_stat**](docs/RealTimeMonitoringDeviceSystemStatsApi.md#create_device_system_cpu_stat) | **GET** /statistics/system/cpu | 
*RealTimeMonitoringDeviceSystemStatsApi* | [**create_device_system_memory_stat**](docs/RealTimeMonitoringDeviceSystemStatsApi.md#create_device_system_memory_stat) | **GET** /statistics/system/memory | 
*RealTimeMonitoringDeviceSystemStatsApi* | [**get_aggregation_data_by_query16**](docs/RealTimeMonitoringDeviceSystemStatsApi.md#get_aggregation_data_by_query16) | **GET** /statistics/system/aggregation | 
*RealTimeMonitoringDeviceSystemStatsApi* | [**get_count18**](docs/RealTimeMonitoringDeviceSystemStatsApi.md#get_count18) | **GET** /statistics/system/doccount | 
*RealTimeMonitoringDeviceSystemStatsApi* | [**get_count_post18**](docs/RealTimeMonitoringDeviceSystemStatsApi.md#get_count_post18) | **POST** /statistics/system/doccount | 
*RealTimeMonitoringDeviceSystemStatsApi* | [**get_post_aggregation_app_data_by_query15**](docs/RealTimeMonitoringDeviceSystemStatsApi.md#get_post_aggregation_app_data_by_query15) | **POST** /statistics/system/app-agg/aggregation | 
*RealTimeMonitoringDeviceSystemStatsApi* | [**get_post_aggregation_data_by_query15**](docs/RealTimeMonitoringDeviceSystemStatsApi.md#get_post_aggregation_data_by_query15) | **POST** /statistics/system/aggregation | 
*RealTimeMonitoringDeviceSystemStatsApi* | [**get_post_stat_bulk_raw_data16**](docs/RealTimeMonitoringDeviceSystemStatsApi.md#get_post_stat_bulk_raw_data16) | **POST** /statistics/system/page | 
*RealTimeMonitoringDeviceSystemStatsApi* | [**get_stat_bulk_raw_data16**](docs/RealTimeMonitoringDeviceSystemStatsApi.md#get_stat_bulk_raw_data16) | **GET** /statistics/system/page | 
*RealTimeMonitoringDeviceSystemStatsApi* | [**get_stat_data_fields18**](docs/RealTimeMonitoringDeviceSystemStatsApi.md#get_stat_data_fields18) | **GET** /statistics/system/fields | 
*RealTimeMonitoringDeviceSystemStatsApi* | [**get_stat_data_raw_data15**](docs/RealTimeMonitoringDeviceSystemStatsApi.md#get_stat_data_raw_data15) | **GET** /statistics/system | 
*RealTimeMonitoringDeviceSystemStatsApi* | [**get_stat_data_raw_data_as_csv16**](docs/RealTimeMonitoringDeviceSystemStatsApi.md#get_stat_data_raw_data_as_csv16) | **GET** /statistics/system/csv | 
*RealTimeMonitoringDeviceSystemStatsApi* | [**get_stat_query_fields18**](docs/RealTimeMonitoringDeviceSystemStatsApi.md#get_stat_query_fields18) | **GET** /statistics/system/query/fields | 
*RealTimeMonitoringDeviceSystemStatsApi* | [**get_stats_raw_data16**](docs/RealTimeMonitoringDeviceSystemStatsApi.md#get_stats_raw_data16) | **POST** /statistics/system | 
*RealTimeMonitoringDownloadedImagesApi* | [**create_software_list**](docs/RealTimeMonitoringDownloadedImagesApi.md#create_software_list) | **GET** /device/downloadedImages | 
*RealTimeMonitoringDualStaticRouteTrackerServiceApi* | [**get_dual_static_route_tracker_info**](docs/RealTimeMonitoringDualStaticRouteTrackerServiceApi.md#get_dual_static_route_tracker_info) | **GET** /device/dualStaticRouteTracker | 
*RealTimeMonitoringEIGRPApi* | [**create_eigrp_interface**](docs/RealTimeMonitoringEIGRPApi.md#create_eigrp_interface) | **GET** /device/eigrp/interface | 
*RealTimeMonitoringEIGRPApi* | [**create_eigrp_route**](docs/RealTimeMonitoringEIGRPApi.md#create_eigrp_route) | **GET** /device/eigrp/route | 
*RealTimeMonitoringEIGRPApi* | [**create_eigrp_topology**](docs/RealTimeMonitoringEIGRPApi.md#create_eigrp_topology) | **GET** /device/eigrp/topology | 
*RealTimeMonitoringEndpointTrackerGroupServiceApi* | [**get_endpoint_tracker_group_info**](docs/RealTimeMonitoringEndpointTrackerGroupServiceApi.md#get_endpoint_tracker_group_info) | **GET** /device/endpointTrackerGroup | 
*RealTimeMonitoringEndpointTrackerServiceApi* | [**get_endpoint_tracker_info**](docs/RealTimeMonitoringEndpointTrackerServiceApi.md#get_endpoint_tracker_info) | **GET** /device/endpointTracker | 
*RealTimeMonitoringGeoFencingApi* | [**get_geofence_status**](docs/RealTimeMonitoringGeoFencingApi.md#get_geofence_status) | **GET** /device/geofence/status | 
*RealTimeMonitoringHardwareApi* | [**create_alarm_list**](docs/RealTimeMonitoringHardwareApi.md#create_alarm_list) | **GET** /device/hardware/alarms | 
*RealTimeMonitoringHardwareApi* | [**create_environment_list**](docs/RealTimeMonitoringHardwareApi.md#create_environment_list) | **GET** /device/hardware/environment | 
*RealTimeMonitoringHardwareApi* | [**create_error_alarm_list**](docs/RealTimeMonitoringHardwareApi.md#create_error_alarm_list) | **GET** /device/hardware/errors | 
*RealTimeMonitoringHardwareApi* | [**create_inventory_list**](docs/RealTimeMonitoringHardwareApi.md#create_inventory_list) | **GET** /device/hardware/inventory | 
*RealTimeMonitoringHardwareApi* | [**create_status_summary**](docs/RealTimeMonitoringHardwareApi.md#create_status_summary) | **GET** /device/hardware/status/summary | 
*RealTimeMonitoringHardwareApi* | [**create_synced_alarm_list**](docs/RealTimeMonitoringHardwareApi.md#create_synced_alarm_list) | **GET** /device/hardware/synced/alarms | 
*RealTimeMonitoringHardwareApi* | [**create_synced_environment_list**](docs/RealTimeMonitoringHardwareApi.md#create_synced_environment_list) | **GET** /device/hardware/synced/environment | 
*RealTimeMonitoringHardwareApi* | [**create_synced_inventory_list**](docs/RealTimeMonitoringHardwareApi.md#create_synced_inventory_list) | **GET** /device/hardware/synced/inventory | 
*RealTimeMonitoringHardwareApi* | [**create_system_list**](docs/RealTimeMonitoringHardwareApi.md#create_system_list) | **GET** /device/hardware/system | 
*RealTimeMonitoringHardwareApi* | [**create_temp_threshold_list**](docs/RealTimeMonitoringHardwareApi.md#create_temp_threshold_list) | **GET** /device/hardware/threshold | 
*RealTimeMonitoringIGMPApi* | [**create_igmp_groups_list**](docs/RealTimeMonitoringIGMPApi.md#create_igmp_groups_list) | **GET** /device/igmp/groups | 
*RealTimeMonitoringIGMPApi* | [**create_igmp_interface_list**](docs/RealTimeMonitoringIGMPApi.md#create_igmp_interface_list) | **GET** /device/igmp/interface | 
*RealTimeMonitoringIGMPApi* | [**create_igmp_statistics_list**](docs/RealTimeMonitoringIGMPApi.md#create_igmp_statistics_list) | **GET** /device/igmp/statistics | 
*RealTimeMonitoringIGMPApi* | [**create_igmp_summary**](docs/RealTimeMonitoringIGMPApi.md#create_igmp_summary) | **GET** /device/igmp/summary | 
*RealTimeMonitoringIPApi* | [**create_fib_list**](docs/RealTimeMonitoringIPApi.md#create_fib_list) | **GET** /device/ip/fib | 
*RealTimeMonitoringIPApi* | [**create_ietf_routing_list**](docs/RealTimeMonitoringIPApi.md#create_ietf_routing_list) | **GET** /device/ip/ipRoutes | 
*RealTimeMonitoringIPApi* | [**create_ip_mfib_oil_list**](docs/RealTimeMonitoringIPApi.md#create_ip_mfib_oil_list) | **GET** /device/ip/mfiboil | 
*RealTimeMonitoringIPApi* | [**create_ip_mfib_stats_list**](docs/RealTimeMonitoringIPApi.md#create_ip_mfib_stats_list) | **GET** /device/ip/mfibstats | 
*RealTimeMonitoringIPApi* | [**create_ip_mfib_summary_list**](docs/RealTimeMonitoringIPApi.md#create_ip_mfib_summary_list) | **GET** /device/ip/mfibsummary | 
*RealTimeMonitoringIPApi* | [**create_nat64_translation_list**](docs/RealTimeMonitoringIPApi.md#create_nat64_translation_list) | **GET** /device/ip/nat64/translation | 
*RealTimeMonitoringIPApi* | [**create_nat_filter_list**](docs/RealTimeMonitoringIPApi.md#create_nat_filter_list) | **GET** /device/ip/nat/filter | 
*RealTimeMonitoringIPApi* | [**create_nat_interface_list**](docs/RealTimeMonitoringIPApi.md#create_nat_interface_list) | **GET** /device/ip/nat/interface | 
*RealTimeMonitoringIPApi* | [**create_nat_interface_statistics_list**](docs/RealTimeMonitoringIPApi.md#create_nat_interface_statistics_list) | **GET** /device/ip/nat/interfacestatistics | 
*RealTimeMonitoringIPApi* | [**create_nat_translation_list**](docs/RealTimeMonitoringIPApi.md#create_nat_translation_list) | **GET** /device/ip/nat/translation | 
*RealTimeMonitoringIPApi* | [**create_route_table_list**](docs/RealTimeMonitoringIPApi.md#create_route_table_list) | **GET** /device/ip/routetable | 
*RealTimeMonitoringIPsecApi* | [**create_crypto_ipsec_identity**](docs/RealTimeMonitoringIPsecApi.md#create_crypto_ipsec_identity) | **GET** /device/ipsec/identity | 
*RealTimeMonitoringIPsecApi* | [**create_cryptov1_local_sa_list**](docs/RealTimeMonitoringIPsecApi.md#create_cryptov1_local_sa_list) | **GET** /device/ipsec/ikev1 | 
*RealTimeMonitoringIPsecApi* | [**create_cryptov2_local_sa_list**](docs/RealTimeMonitoringIPsecApi.md#create_cryptov2_local_sa_list) | **GET** /device/ipsec/ikev2 | 
*RealTimeMonitoringIPsecApi* | [**create_i_psec_pwk_inbound_connections**](docs/RealTimeMonitoringIPsecApi.md#create_i_psec_pwk_inbound_connections) | **GET** /device/ipsec/pwk/inbound | 
*RealTimeMonitoringIPsecApi* | [**create_i_psec_pwk_local_sa**](docs/RealTimeMonitoringIPsecApi.md#create_i_psec_pwk_local_sa) | **GET** /device/ipsec/pwk/localsa | 
*RealTimeMonitoringIPsecApi* | [**create_i_psec_pwk_outbound_connections**](docs/RealTimeMonitoringIPsecApi.md#create_i_psec_pwk_outbound_connections) | **GET** /device/ipsec/pwk/outbound | 
*RealTimeMonitoringIPsecApi* | [**create_ike_inbound_list**](docs/RealTimeMonitoringIPsecApi.md#create_ike_inbound_list) | **GET** /device/ipsec/ike/inbound | 
*RealTimeMonitoringIPsecApi* | [**create_ike_outbound_list**](docs/RealTimeMonitoringIPsecApi.md#create_ike_outbound_list) | **GET** /device/ipsec/ike/outbound | 
*RealTimeMonitoringIPsecApi* | [**create_ike_sessions**](docs/RealTimeMonitoringIPsecApi.md#create_ike_sessions) | **GET** /device/ipsec/ike/sessions | 
*RealTimeMonitoringIPsecApi* | [**create_in_bound_list**](docs/RealTimeMonitoringIPsecApi.md#create_in_bound_list) | **GET** /device/ipsec/inbound | 
*RealTimeMonitoringIPsecApi* | [**create_local_sa_list**](docs/RealTimeMonitoringIPsecApi.md#create_local_sa_list) | **GET** /device/ipsec/localsa | 
*RealTimeMonitoringIPsecApi* | [**create_out_bound_list**](docs/RealTimeMonitoringIPsecApi.md#create_out_bound_list) | **GET** /device/ipsec/outbound | 
*RealTimeMonitoringIPv4FIBApi* | [**create_ipv4_fib_list**](docs/RealTimeMonitoringIPv4FIBApi.md#create_ipv4_fib_list) | **GET** /device/ip/v4fib | 
*RealTimeMonitoringIPv6FIBApi* | [**create_ipv6_fib_list**](docs/RealTimeMonitoringIPv6FIBApi.md#create_ipv6_fib_list) | **GET** /device/ip/v6fib | 
*RealTimeMonitoringIPv6NeighboursApi* | [**get_ipv6_interface**](docs/RealTimeMonitoringIPv6NeighboursApi.md#get_ipv6_interface) | **GET** /device/ndv6 | 
*RealTimeMonitoringInterfaceApi* | [**generate_device_interface_vpn**](docs/RealTimeMonitoringInterfaceApi.md#generate_device_interface_vpn) | **GET** /device/interface/vpn | 
*RealTimeMonitoringInterfaceApi* | [**get_device_interface**](docs/RealTimeMonitoringInterfaceApi.md#get_device_interface) | **GET** /device/interface | 
*RealTimeMonitoringInterfaceApi* | [**get_device_interface_arp_stats**](docs/RealTimeMonitoringInterfaceApi.md#get_device_interface_arp_stats) | **GET** /device/interface/arp_stats | 
*RealTimeMonitoringInterfaceApi* | [**get_device_interface_error_stats**](docs/RealTimeMonitoringInterfaceApi.md#get_device_interface_error_stats) | **GET** /device/interface/error_stats | 
*RealTimeMonitoringInterfaceApi* | [**get_device_interface_ipv6_stats**](docs/RealTimeMonitoringInterfaceApi.md#get_device_interface_ipv6_stats) | **GET** /device/interface/ipv6Stats | 
*RealTimeMonitoringInterfaceApi* | [**get_device_interface_pkt_sizes**](docs/RealTimeMonitoringInterfaceApi.md#get_device_interface_pkt_sizes) | **GET** /device/interface/pkt_size | 
*RealTimeMonitoringInterfaceApi* | [**get_device_interface_port_stats**](docs/RealTimeMonitoringInterfaceApi.md#get_device_interface_port_stats) | **GET** /device/interface/port_stats | 
*RealTimeMonitoringInterfaceApi* | [**get_device_interface_qos_stats**](docs/RealTimeMonitoringInterfaceApi.md#get_device_interface_qos_stats) | **GET** /device/interface/qosStats | 
*RealTimeMonitoringInterfaceApi* | [**get_device_interface_queue_stats**](docs/RealTimeMonitoringInterfaceApi.md#get_device_interface_queue_stats) | **GET** /device/interface/queue_stats | 
*RealTimeMonitoringInterfaceApi* | [**get_device_interface_stats**](docs/RealTimeMonitoringInterfaceApi.md#get_device_interface_stats) | **GET** /device/interface/stats | 
*RealTimeMonitoringInterfaceApi* | [**get_device_serial_interface**](docs/RealTimeMonitoringInterfaceApi.md#get_device_serial_interface) | **GET** /device/interface/serial | 
*RealTimeMonitoringInterfaceApi* | [**get_synced_device_interface**](docs/RealTimeMonitoringInterfaceApi.md#get_synced_device_interface) | **GET** /device/interface/synced | 
*RealTimeMonitoringInterfaceApi* | [**trustsec**](docs/RealTimeMonitoringInterfaceApi.md#trustsec) | **GET** /device/interface/trustsec | 
*RealTimeMonitoringLicenseInfoApi* | [**get_license_eval_info**](docs/RealTimeMonitoringLicenseInfoApi.md#get_license_eval_info) | **GET** /device/license/evaluation | 
*RealTimeMonitoringLicenseInfoApi* | [**get_license_pak_info**](docs/RealTimeMonitoringLicenseInfoApi.md#get_license_pak_info) | **GET** /device/license/pak | 
*RealTimeMonitoringLicenseInfoApi* | [**get_license_privacy_info**](docs/RealTimeMonitoringLicenseInfoApi.md#get_license_privacy_info) | **GET** /device/license/privacy | 
*RealTimeMonitoringLicenseInfoApi* | [**get_license_reg_info**](docs/RealTimeMonitoringLicenseInfoApi.md#get_license_reg_info) | **GET** /device/license/registration | 
*RealTimeMonitoringLicenseInfoApi* | [**get_license_udi_info**](docs/RealTimeMonitoringLicenseInfoApi.md#get_license_udi_info) | **GET** /device/license/udi | 
*RealTimeMonitoringLicenseInfoApi* | [**get_license_usage_info**](docs/RealTimeMonitoringLicenseInfoApi.md#get_license_usage_info) | **GET** /device/license/usage | 
*RealTimeMonitoringMulticastApi* | [**create_pim_tunnel_list**](docs/RealTimeMonitoringMulticastApi.md#create_pim_tunnel_list) | **GET** /device/multicast/tunnel | 
*RealTimeMonitoringMulticastApi* | [**create_replicator_list**](docs/RealTimeMonitoringMulticastApi.md#create_replicator_list) | **GET** /device/multicast/replicator | 
*RealTimeMonitoringMulticastApi* | [**create_rpf_list**](docs/RealTimeMonitoringMulticastApi.md#create_rpf_list) | **GET** /device/multicast/rpf | 
*RealTimeMonitoringMulticastApi* | [**create_topology_list**](docs/RealTimeMonitoringMulticastApi.md#create_topology_list) | **GET** /device/multicast/topology | 
*RealTimeMonitoringNMSApi* | [**get_running**](docs/RealTimeMonitoringNMSApi.md#get_running) | **GET** /device/nms/running | 
*RealTimeMonitoringNTPApi* | [**create_associations_list**](docs/RealTimeMonitoringNTPApi.md#create_associations_list) | **GET** /device/ntp/associations | 
*RealTimeMonitoringNTPApi* | [**create_ntp_status_list**](docs/RealTimeMonitoringNTPApi.md#create_ntp_status_list) | **GET** /device/ntp/status | 
*RealTimeMonitoringNTPApi* | [**create_peer_list**](docs/RealTimeMonitoringNTPApi.md#create_peer_list) | **GET** /device/ntp/peer | 
*RealTimeMonitoringNTPApi* | [**create_te_list**](docs/RealTimeMonitoringNTPApi.md#create_te_list) | **GET** /device/virtualApplication/te | 
*RealTimeMonitoringNTPApi* | [**create_utd_list**](docs/RealTimeMonitoringNTPApi.md#create_utd_list) | **GET** /device/virtualApplication/utd | 
*RealTimeMonitoringNTPApi* | [**create_waas_list**](docs/RealTimeMonitoringNTPApi.md#create_waas_list) | **GET** /device/virtualApplication/waas | 
*RealTimeMonitoringNetworkHubResourcesApi* | [**get_allocation_info**](docs/RealTimeMonitoringNetworkHubResourcesApi.md#get_allocation_info) | **GET** /device/csp/resources/cpu-info/allocation | 
*RealTimeMonitoringNetworkHubResourcesApi* | [**get_cpu_info**](docs/RealTimeMonitoringNetworkHubResourcesApi.md#get_cpu_info) | **GET** /device/csp/resources/cpu-info/cpus | 
*RealTimeMonitoringNetworkHubResourcesApi* | [**get_vnf_info**](docs/RealTimeMonitoringNetworkHubResourcesApi.md#get_vnf_info) | **GET** /device/csp/resources/cpu-info/vnfs | 
*RealTimeMonitoringOMPApi* | [**create_advertised_routes_list**](docs/RealTimeMonitoringOMPApi.md#create_advertised_routes_list) | **GET** /device/omp/routes/advertised | 
*RealTimeMonitoringOMPApi* | [**create_advertised_routes_list_ipv6**](docs/RealTimeMonitoringOMPApi.md#create_advertised_routes_list_ipv6) | **GET** /device/omp/routes/advertised/ompIpv6 | 
*RealTimeMonitoringOMPApi* | [**create_advertised_tlocs_list**](docs/RealTimeMonitoringOMPApi.md#create_advertised_tlocs_list) | **GET** /device/omp/tlocs/advertised | 
*RealTimeMonitoringOMPApi* | [**create_omp_cloud_x_recv**](docs/RealTimeMonitoringOMPApi.md#create_omp_cloud_x_recv) | **GET** /device/omp/cloudx | 
*RealTimeMonitoringOMPApi* | [**create_omp_link_list**](docs/RealTimeMonitoringOMPApi.md#create_omp_link_list) | **GET** /device/omp/links | 
*RealTimeMonitoringOMPApi* | [**create_omp_mcast_auto_discover_advt**](docs/RealTimeMonitoringOMPApi.md#create_omp_mcast_auto_discover_advt) | **GET** /device/omp/mcastautodiscoveradvt | 
*RealTimeMonitoringOMPApi* | [**create_omp_mcast_auto_discover_recv**](docs/RealTimeMonitoringOMPApi.md#create_omp_mcast_auto_discover_recv) | **GET** /device/omp/mcastautodiscoverrecv | 
*RealTimeMonitoringOMPApi* | [**create_omp_mcast_routes_advt**](docs/RealTimeMonitoringOMPApi.md#create_omp_mcast_routes_advt) | **GET** /device/omp/mcastroutesadvt | 
*RealTimeMonitoringOMPApi* | [**create_omp_mcast_routes_recv**](docs/RealTimeMonitoringOMPApi.md#create_omp_mcast_routes_recv) | **GET** /device/omp/mcastroutesrecv | 
*RealTimeMonitoringOMPApi* | [**create_omp_services**](docs/RealTimeMonitoringOMPApi.md#create_omp_services) | **GET** /device/omp/services | 
*RealTimeMonitoringOMPApi* | [**create_omp_session_list**](docs/RealTimeMonitoringOMPApi.md#create_omp_session_list) | **GET** /device/omp/peers | 
*RealTimeMonitoringOMPApi* | [**create_omp_summary**](docs/RealTimeMonitoringOMPApi.md#create_omp_summary) | **GET** /device/omp/summary | 
*RealTimeMonitoringOMPApi* | [**create_received_routes_list**](docs/RealTimeMonitoringOMPApi.md#create_received_routes_list) | **GET** /device/omp/routes/received | 
*RealTimeMonitoringOMPApi* | [**create_received_routes_list_ipv6**](docs/RealTimeMonitoringOMPApi.md#create_received_routes_list_ipv6) | **GET** /device/omp/routes/received/ompIpv6 | 
*RealTimeMonitoringOMPApi* | [**create_received_tlocs_list**](docs/RealTimeMonitoringOMPApi.md#create_received_tlocs_list) | **GET** /device/omp/tlocs/received | 
*RealTimeMonitoringOMPApi* | [**create_synced_omp_session_list**](docs/RealTimeMonitoringOMPApi.md#create_synced_omp_session_list) | **GET** /device/omp/synced/peers | 
*RealTimeMonitoringOMPApi* | [**get_device_omp_status**](docs/RealTimeMonitoringOMPApi.md#get_device_omp_status) | **GET** /device/omp/status | 
*RealTimeMonitoringOSPFApi* | [**create_ospf_database_external**](docs/RealTimeMonitoringOSPFApi.md#create_ospf_database_external) | **GET** /device/ospf/databaseexternal | 
*RealTimeMonitoringOSPFApi* | [**create_ospf_database_list**](docs/RealTimeMonitoringOSPFApi.md#create_ospf_database_list) | **GET** /device/ospf/database | 
*RealTimeMonitoringOSPFApi* | [**create_ospf_database_summary_list**](docs/RealTimeMonitoringOSPFApi.md#create_ospf_database_summary_list) | **GET** /device/ospf/databasesummary | 
*RealTimeMonitoringOSPFApi* | [**create_ospf_interface**](docs/RealTimeMonitoringOSPFApi.md#create_ospf_interface) | **GET** /device/ospf/interface | 
*RealTimeMonitoringOSPFApi* | [**create_ospf_neighbors**](docs/RealTimeMonitoringOSPFApi.md#create_ospf_neighbors) | **GET** /device/ospf/neighbor | 
*RealTimeMonitoringOSPFApi* | [**create_ospf_process**](docs/RealTimeMonitoringOSPFApi.md#create_ospf_process) | **GET** /device/ospf/process | 
*RealTimeMonitoringOSPFApi* | [**create_ospf_routes_list**](docs/RealTimeMonitoringOSPFApi.md#create_ospf_routes_list) | **GET** /device/ospf/routes | 
*RealTimeMonitoringOSPFApi* | [**create_ospfv3_interface**](docs/RealTimeMonitoringOSPFApi.md#create_ospfv3_interface) | **GET** /device/ospf/v3interface | 
*RealTimeMonitoringOSPFApi* | [**create_ospfv3_neighbors**](docs/RealTimeMonitoringOSPFApi.md#create_ospfv3_neighbors) | **GET** /device/ospf/v3neighbor | 
*RealTimeMonitoringOrchestratorApi* | [**create_connection_history_list**](docs/RealTimeMonitoringOrchestratorApi.md#create_connection_history_list) | **GET** /device/orchestrator/connectionshistory | 
*RealTimeMonitoringOrchestratorApi* | [**create_connection_list_from_device**](docs/RealTimeMonitoringOrchestratorApi.md#create_connection_list_from_device) | **GET** /device/orchestrator/connections | 
*RealTimeMonitoringOrchestratorApi* | [**create_connection_summary**](docs/RealTimeMonitoringOrchestratorApi.md#create_connection_summary) | **GET** /device/orchestrator/summary | 
*RealTimeMonitoringOrchestratorApi* | [**create_local_properties_list_list**](docs/RealTimeMonitoringOrchestratorApi.md#create_local_properties_list_list) | **GET** /device/orchestrator/localproperties | 
*RealTimeMonitoringOrchestratorApi* | [**create_reverse_proxy_mapping_list**](docs/RealTimeMonitoringOrchestratorApi.md#create_reverse_proxy_mapping_list) | **GET** /device/orchestrator/proxymapping | 
*RealTimeMonitoringOrchestratorApi* | [**create_valid_devices_list**](docs/RealTimeMonitoringOrchestratorApi.md#create_valid_devices_list) | **GET** /device/orchestrator/validvedges | 
*RealTimeMonitoringOrchestratorApi* | [**create_valid_v_smarts_list**](docs/RealTimeMonitoringOrchestratorApi.md#create_valid_v_smarts_list) | **GET** /device/orchestrator/validvsmarts | 
*RealTimeMonitoringOrchestratorApi* | [**get_statistics**](docs/RealTimeMonitoringOrchestratorApi.md#get_statistics) | **GET** /device/orchestrator/statistics | 
*RealTimeMonitoringOrchestratorApi* | [**get_valid_v_manage_id**](docs/RealTimeMonitoringOrchestratorApi.md#get_valid_v_manage_id) | **GET** /device/orchestrator/validvmanageid | 
*RealTimeMonitoringPIMApi* | [**create_pim_interface_list**](docs/RealTimeMonitoringPIMApi.md#create_pim_interface_list) | **GET** /device/pim/interface | 
*RealTimeMonitoringPIMApi* | [**create_pim_neighbor_list**](docs/RealTimeMonitoringPIMApi.md#create_pim_neighbor_list) | **GET** /device/pim/neighbor | 
*RealTimeMonitoringPIMApi* | [**create_pim_statistics_list**](docs/RealTimeMonitoringPIMApi.md#create_pim_statistics_list) | **GET** /device/pim/statistics | 
*RealTimeMonitoringPIMApi* | [**create_pimrp_mapping_list**](docs/RealTimeMonitoringPIMApi.md#create_pimrp_mapping_list) | **GET** /device/pim/rp-mapping | 
*RealTimeMonitoringPIMApi* | [**create_ppp_interface_list**](docs/RealTimeMonitoringPIMApi.md#create_ppp_interface_list) | **GET** /device/ppp/interface | 
*RealTimeMonitoringPPPoEApi* | [**create_pppo_e_interface_list**](docs/RealTimeMonitoringPPPoEApi.md#create_pppo_e_interface_list) | **GET** /device/pppoe/session | 
*RealTimeMonitoringPPPoEApi* | [**create_pppo_e_neighbor_list**](docs/RealTimeMonitoringPPPoEApi.md#create_pppo_e_neighbor_list) | **GET** /device/pppoe/statistic | 
*RealTimeMonitoringPolicerApi* | [**get_policed_interface**](docs/RealTimeMonitoringPolicerApi.md#get_policed_interface) | **GET** /device/policer | 
*RealTimeMonitoringPolicyApi* | [**create_polic_data_policy_filter**](docs/RealTimeMonitoringPolicyApi.md#create_polic_data_policy_filter) | **GET** /device/policy/datapolicyfilter | 
*RealTimeMonitoringPolicyApi* | [**create_polic_qos_map_info**](docs/RealTimeMonitoringPolicyApi.md#create_polic_qos_map_info) | **GET** /device/policy/qosmapinfo | 
*RealTimeMonitoringPolicyApi* | [**create_polic_qos_scheduler_info**](docs/RealTimeMonitoringPolicyApi.md#create_polic_qos_scheduler_info) | **GET** /device/policy/qosschedulerinfo | 
*RealTimeMonitoringPolicyApi* | [**create_policy_access_list_associations**](docs/RealTimeMonitoringPolicyApi.md#create_policy_access_list_associations) | **GET** /device/policy/accesslistassociations | 
*RealTimeMonitoringPolicyApi* | [**create_policy_access_list_associations_ipv6**](docs/RealTimeMonitoringPolicyApi.md#create_policy_access_list_associations_ipv6) | **GET** /device/policy/ipv6/accesslistassociations | 
*RealTimeMonitoringPolicyApi* | [**create_policy_access_list_counters**](docs/RealTimeMonitoringPolicyApi.md#create_policy_access_list_counters) | **GET** /device/policy/accesslistcounters | 
*RealTimeMonitoringPolicyApi* | [**create_policy_access_list_counters_ipv6**](docs/RealTimeMonitoringPolicyApi.md#create_policy_access_list_counters_ipv6) | **GET** /device/policy/ipv6/accesslistcounters | 
*RealTimeMonitoringPolicyApi* | [**create_policy_access_list_names**](docs/RealTimeMonitoringPolicyApi.md#create_policy_access_list_names) | **GET** /device/policy/accesslistnames | 
*RealTimeMonitoringPolicyApi* | [**create_policy_access_list_names_ipv6**](docs/RealTimeMonitoringPolicyApi.md#create_policy_access_list_names_ipv6) | **GET** /device/policy/ipv6/accesslistnames | 
*RealTimeMonitoringPolicyApi* | [**create_policy_access_list_policers**](docs/RealTimeMonitoringPolicyApi.md#create_policy_access_list_policers) | **GET** /device/policy/accesslistpolicers | 
*RealTimeMonitoringPolicyApi* | [**create_policy_access_list_policers_ipv6**](docs/RealTimeMonitoringPolicyApi.md#create_policy_access_list_policers_ipv6) | **GET** /device/policy/ipv6/accesslistpolicers | 
*RealTimeMonitoringPolicyApi* | [**create_policy_app_route_policy_filter**](docs/RealTimeMonitoringPolicyApi.md#create_policy_app_route_policy_filter) | **GET** /device/policy/approutepolicyfilter | 
*RealTimeMonitoringPolicyApi* | [**create_policy_filter_memory_usage**](docs/RealTimeMonitoringPolicyApi.md#create_policy_filter_memory_usage) | **GET** /device/policy/filtermemoryusage | 
*RealTimeMonitoringPolicyApi* | [**create_policy_rewrite_associations_info**](docs/RealTimeMonitoringPolicyApi.md#create_policy_rewrite_associations_info) | **GET** /device/policy/rewriteassociations | 
*RealTimeMonitoringPolicyApi* | [**get_zbfw_statistics**](docs/RealTimeMonitoringPolicyApi.md#get_zbfw_statistics) | **GET** /device/policy/zbfwstatistics | 
*RealTimeMonitoringPolicyApi* | [**get_zone_drop_statistics**](docs/RealTimeMonitoringPolicyApi.md#get_zone_drop_statistics) | **GET** /device/policy/zbfwdropstatistics | 
*RealTimeMonitoringPolicyApi* | [**get_zone_pair_sessions**](docs/RealTimeMonitoringPolicyApi.md#get_zone_pair_sessions) | **GET** /device/policy/zonepairsessions | 
*RealTimeMonitoringPolicyApi* | [**get_zone_pairs**](docs/RealTimeMonitoringPolicyApi.md#get_zone_pairs) | **GET** /device/policy/zonepairstatistics | 
*RealTimeMonitoringPolicyApi* | [**get_zone_policy_filters**](docs/RealTimeMonitoringPolicyApi.md#get_zone_policy_filters) | **GET** /device/policy/zonepolicyfilter | 
*RealTimeMonitoringPolicyApi* | [**show_sdwan_policy_from_vsmart**](docs/RealTimeMonitoringPolicyApi.md#show_sdwan_policy_from_vsmart) | **GET** /device/policy/vsmart | 
*RealTimeMonitoringRBACApi* | [**get_pnic_stats**](docs/RealTimeMonitoringRBACApi.md#get_pnic_stats) | **GET** /device/csp/pnic | 
*RealTimeMonitoringRBACApi* | [**get_pnic_stats_from_device**](docs/RealTimeMonitoringRBACApi.md#get_pnic_stats_from_device) | **GET** /device/csp/pnic/synced | 
*RealTimeMonitoringRBACApi* | [**get_rbac_interface**](docs/RealTimeMonitoringRBACApi.md#get_rbac_interface) | **GET** /device/csp/rbac | 
*RealTimeMonitoringRebootHistoryApi* | [**create_reboot_history_list**](docs/RealTimeMonitoringRebootHistoryApi.md#create_reboot_history_list) | **GET** /device/reboothistory | 
*RealTimeMonitoringRebootHistoryApi* | [**create_synced_reboot_history_list**](docs/RealTimeMonitoringRebootHistoryApi.md#create_synced_reboot_history_list) | **GET** /device/reboothistory/synced | 
*RealTimeMonitoringRebootHistoryApi* | [**get_reboot_history_details**](docs/RealTimeMonitoringRebootHistoryApi.md#get_reboot_history_details) | **GET** /device/reboothistory/details | 
*RealTimeMonitoringSDWANStatisticsApi* | [**get_sd_wan_global_drop_statistics**](docs/RealTimeMonitoringSDWANStatisticsApi.md#get_sd_wan_global_drop_statistics) | **GET** /device/sdwan-global-drop-statistics | 
*RealTimeMonitoringSDWANStatisticsApi* | [**get_sd_wan_stats**](docs/RealTimeMonitoringSDWANStatisticsApi.md#get_sd_wan_stats) | **GET** /device/sdwan-stats | 
*RealTimeMonitoringSFPApi* | [**get_detail**](docs/RealTimeMonitoringSFPApi.md#get_detail) | **GET** /device/sfp/detail | 
*RealTimeMonitoringSFPApi* | [**get_diagnostic**](docs/RealTimeMonitoringSFPApi.md#get_diagnostic) | **GET** /device/sfp/diagnostic | 
*RealTimeMonitoringSFPApi* | [**get_diagnostic_measurement_alarm**](docs/RealTimeMonitoringSFPApi.md#get_diagnostic_measurement_alarm) | **GET** /device/sfp/diagnosticMeasurementAlarm | 
*RealTimeMonitoringSFPApi* | [**get_diagnostic_measurement_value**](docs/RealTimeMonitoringSFPApi.md#get_diagnostic_measurement_value) | **GET** /device/sfp/diagnosticMeasurementValue | 
*RealTimeMonitoringSIGApi* | [**get_sig_umbrella_tunnels**](docs/RealTimeMonitoringSIGApi.md#get_sig_umbrella_tunnels) | **GET** /device/sig/umbrella/tunnels | 
*RealTimeMonitoringSIGApi* | [**get_sig_zscaler_tunnels**](docs/RealTimeMonitoringSIGApi.md#get_sig_zscaler_tunnels) | **GET** /device/sig/zscaler/tunnels | 
*RealTimeMonitoringSecurityApi* | [**create_session_list**](docs/RealTimeMonitoringSecurityApi.md#create_session_list) | **GET** /device/security/information | 
*RealTimeMonitoringShowOnDemandLocalApi* | [**get_on_demand_local**](docs/RealTimeMonitoringShowOnDemandLocalApi.md#get_on_demand_local) | **GET** /device/ondemand/local | 
*RealTimeMonitoringShowOnDemandRemoteApi* | [**get_on_demand_remote**](docs/RealTimeMonitoringShowOnDemandRemoteApi.md#get_on_demand_remote) | **GET** /device/ondemand/remote | 
*RealTimeMonitoringSoftwareApi* | [**create_smu_list**](docs/RealTimeMonitoringSoftwareApi.md#create_smu_list) | **GET** /device/smu | 
*RealTimeMonitoringSoftwareApi* | [**create_synced_smu_list**](docs/RealTimeMonitoringSoftwareApi.md#create_synced_smu_list) | **GET** /device/smu/synced | 
*RealTimeMonitoringSoftwareApi* | [**create_synced_software_list**](docs/RealTimeMonitoringSoftwareApi.md#create_synced_software_list) | **GET** /device/software/synced | 
*RealTimeMonitoringSoftwareApi* | [**get_aaa_ucreate_software_listsers**](docs/RealTimeMonitoringSoftwareApi.md#get_aaa_ucreate_software_listsers) | **GET** /device/software | 
*RealTimeMonitoringSslproxyApi* | [**get_ssl_proxy_statistics**](docs/RealTimeMonitoringSslproxyApi.md#get_ssl_proxy_statistics) | **GET** /device/sslproxy/statistics | 
*RealTimeMonitoringSslproxyApi* | [**get_ssl_proxy_status**](docs/RealTimeMonitoringSslproxyApi.md#get_ssl_proxy_status) | **GET** /device/sslproxy/status | 
*RealTimeMonitoringStaticRouteTrackerServiceApi* | [**get_static_route_tracker_info**](docs/RealTimeMonitoringStaticRouteTrackerServiceApi.md#get_static_route_tracker_info) | **GET** /device/staticRouteTracker | 
*RealTimeMonitoringSystemApi* | [**create_device_info_list**](docs/RealTimeMonitoringSystemApi.md#create_device_info_list) | **GET** /device/system/info | 
*RealTimeMonitoringSystemApi* | [**create_device_system_process_list**](docs/RealTimeMonitoringSystemApi.md#create_device_system_process_list) | **GET** /device/csp/system/processlist | 
*RealTimeMonitoringSystemApi* | [**create_device_system_setting**](docs/RealTimeMonitoringSystemApi.md#create_device_system_setting) | **GET** /device/csp/system/settings | 
*RealTimeMonitoringSystemApi* | [**create_device_system_setting_native_info**](docs/RealTimeMonitoringSystemApi.md#create_device_system_setting_native_info) | **GET** /device/csp/system/native | 
*RealTimeMonitoringSystemApi* | [**create_device_system_stats_list**](docs/RealTimeMonitoringSystemApi.md#create_device_system_stats_list) | **GET** /device/system/statistics | 
*RealTimeMonitoringSystemApi* | [**create_device_system_status**](docs/RealTimeMonitoringSystemApi.md#create_device_system_status) | **GET** /device/csp/system/status | 
*RealTimeMonitoringSystemApi* | [**create_device_system_status_list**](docs/RealTimeMonitoringSystemApi.md#create_device_system_status_list) | **GET** /device/system/status | 
*RealTimeMonitoringSystemApi* | [**create_synced_device_system_status_list**](docs/RealTimeMonitoringSystemApi.md#create_synced_device_system_status_list) | **GET** /device/system/synced/status | 
*RealTimeMonitoringTCPOptimizationApi* | [**get_active_tcp_flows**](docs/RealTimeMonitoringTCPOptimizationApi.md#get_active_tcp_flows) | **GET** /device/tcpopt/activeflows | 
*RealTimeMonitoringTCPOptimizationApi* | [**get_expired_tcp_flows**](docs/RealTimeMonitoringTCPOptimizationApi.md#get_expired_tcp_flows) | **GET** /device/tcpopt/expiredflows | 
*RealTimeMonitoringTCPOptimizationApi* | [**get_tcp_summary**](docs/RealTimeMonitoringTCPOptimizationApi.md#get_tcp_summary) | **GET** /device/tcpopt/summary | 
*RealTimeMonitoringTcpproxyApi* | [**get_tcp_proxy_statistics**](docs/RealTimeMonitoringTcpproxyApi.md#get_tcp_proxy_statistics) | **GET** /device/tcpproxy/statistics | 
*RealTimeMonitoringTcpproxyApi* | [**get_tcp_proxy_status**](docs/RealTimeMonitoringTcpproxyApi.md#get_tcp_proxy_status) | **GET** /device/tcpproxy/status | 
*RealTimeMonitoringTransportApi* | [**create_transport_connection_list**](docs/RealTimeMonitoringTransportApi.md#create_transport_connection_list) | **GET** /device/transport/connection | 
*RealTimeMonitoringTrustsecApi* | [**get_cts_pac**](docs/RealTimeMonitoringTrustsecApi.md#get_cts_pac) | **GET** /device/ctsPac | 
*RealTimeMonitoringTrustsecApi* | [**get_environment_data**](docs/RealTimeMonitoringTrustsecApi.md#get_environment_data) | **GET** /device/environmentData | 
*RealTimeMonitoringTrustsecApi* | [**get_radius_server**](docs/RealTimeMonitoringTrustsecApi.md#get_radius_server) | **GET** /device/environmentData/radiusServer | 
*RealTimeMonitoringTrustsecApi* | [**get_role_based_counters**](docs/RealTimeMonitoringTrustsecApi.md#get_role_based_counters) | **GET** /device/roleBasedCounters | 
*RealTimeMonitoringTrustsecApi* | [**get_role_based_ipv6_counters**](docs/RealTimeMonitoringTrustsecApi.md#get_role_based_ipv6_counters) | **GET** /device/roleBasedIpv6Counters | 
*RealTimeMonitoringTrustsecApi* | [**get_role_based_ipv6_permissions**](docs/RealTimeMonitoringTrustsecApi.md#get_role_based_ipv6_permissions) | **GET** /device/roleBasedIpv6Permissions | 
*RealTimeMonitoringTrustsecApi* | [**get_role_based_permissions**](docs/RealTimeMonitoringTrustsecApi.md#get_role_based_permissions) | **GET** /device/roleBasedPermissions | 
*RealTimeMonitoringTrustsecApi* | [**get_role_based_sgt_map**](docs/RealTimeMonitoringTrustsecApi.md#get_role_based_sgt_map) | **GET** /device/roleBasedSgtMap | 
*RealTimeMonitoringTrustsecApi* | [**get_sxp_connections**](docs/RealTimeMonitoringTrustsecApi.md#get_sxp_connections) | **GET** /device/sxpConnections | 
*RealTimeMonitoringTunnelApi* | [**create_bfd_statistics_list**](docs/RealTimeMonitoringTunnelApi.md#create_bfd_statistics_list) | **GET** /device/tunnel/bfd_statistics | 
*RealTimeMonitoringTunnelApi* | [**create_fec_statistics**](docs/RealTimeMonitoringTunnelApi.md#create_fec_statistics) | **GET** /device/tunnel/fec_statistics | 
*RealTimeMonitoringTunnelApi* | [**create_gre_keepalives_list**](docs/RealTimeMonitoringTunnelApi.md#create_gre_keepalives_list) | **GET** /device/tunnel/gre-keepalives | 
*RealTimeMonitoringTunnelApi* | [**create_ipsec_statistics_list**](docs/RealTimeMonitoringTunnelApi.md#create_ipsec_statistics_list) | **GET** /device/tunnel/ipsec_statistics | 
*RealTimeMonitoringTunnelApi* | [**create_packet_duplicate_statistics**](docs/RealTimeMonitoringTunnelApi.md#create_packet_duplicate_statistics) | **GET** /device/tunnel/packet-duplicate | 
*RealTimeMonitoringTunnelApi* | [**create_statistics_list**](docs/RealTimeMonitoringTunnelApi.md#create_statistics_list) | **GET** /device/tunnel/statistics | 
*RealTimeMonitoringUTDApi* | [**get_signature_version_info**](docs/RealTimeMonitoringUTDApi.md#get_signature_version_info) | **GET** /device/utd/signature/version/details | 
*RealTimeMonitoringUTDApi* | [**get_utd_dataplane_config**](docs/RealTimeMonitoringUTDApi.md#get_utd_dataplane_config) | **GET** /device/utd/dataplane-config | 
*RealTimeMonitoringUTDApi* | [**get_utd_dataplane_global**](docs/RealTimeMonitoringUTDApi.md#get_utd_dataplane_global) | **GET** /device/utd/dataplane-global | 
*RealTimeMonitoringUTDApi* | [**get_utd_dataplane_stats**](docs/RealTimeMonitoringUTDApi.md#get_utd_dataplane_stats) | **GET** /device/utd/dataplane-stats | 
*RealTimeMonitoringUTDApi* | [**get_utd_dataplane_stats_summary**](docs/RealTimeMonitoringUTDApi.md#get_utd_dataplane_stats_summary) | **GET** /device/utd/dataplane-stats-summary | 
*RealTimeMonitoringUTDApi* | [**get_utd_engine_instance_status**](docs/RealTimeMonitoringUTDApi.md#get_utd_engine_instance_status) | **GET** /device/utd/engine-instance-status | 
*RealTimeMonitoringUTDApi* | [**get_utd_engine_status**](docs/RealTimeMonitoringUTDApi.md#get_utd_engine_status) | **GET** /device/utd/engine-status | 
*RealTimeMonitoringUTDApi* | [**get_utd_file_analysis_status**](docs/RealTimeMonitoringUTDApi.md#get_utd_file_analysis_status) | **GET** /device/utd/file-analysis-status | 
*RealTimeMonitoringUTDApi* | [**get_utd_file_reputation_status**](docs/RealTimeMonitoringUTDApi.md#get_utd_file_reputation_status) | **GET** /device/utd/file-reputation-status | 
*RealTimeMonitoringUTDApi* | [**get_utd_ips_update_status**](docs/RealTimeMonitoringUTDApi.md#get_utd_ips_update_status) | **GET** /device/utd/ips-update-status | 
*RealTimeMonitoringUTDApi* | [**get_utd_urlf_connection_status**](docs/RealTimeMonitoringUTDApi.md#get_utd_urlf_connection_status) | **GET** /device/utd/urlf-con-status | 
*RealTimeMonitoringUTDApi* | [**get_utd_urlf_update_status**](docs/RealTimeMonitoringUTDApi.md#get_utd_urlf_update_status) | **GET** /device/utd/urlf-update-status | 
*RealTimeMonitoringUTDApi* | [**get_utd_version_status**](docs/RealTimeMonitoringUTDApi.md#get_utd_version_status) | **GET** /device/utd/version-status | 
*RealTimeMonitoringUcseApi* | [**create_ucse_stats**](docs/RealTimeMonitoringUcseApi.md#create_ucse_stats) | **GET** /device/ucse/stats | 
*RealTimeMonitoringUmbrellaApi* | [**get_umbrella_config**](docs/RealTimeMonitoringUmbrellaApi.md#get_umbrella_config) | **GET** /device/umbrella/umbrella-config | 
*RealTimeMonitoringUmbrellaApi* | [**get_umbrella_dev_reg**](docs/RealTimeMonitoringUmbrellaApi.md#get_umbrella_dev_reg) | **GET** /device/umbrella/device-registration | 
*RealTimeMonitoringUmbrellaApi* | [**get_umbrella_dns_crypt**](docs/RealTimeMonitoringUmbrellaApi.md#get_umbrella_dns_crypt) | **GET** /device/umbrella/dnscrypt | 
*RealTimeMonitoringUmbrellaApi* | [**get_umbrella_dp_stats**](docs/RealTimeMonitoringUmbrellaApi.md#get_umbrella_dp_stats) | **GET** /device/umbrella/dp-stats | 
*RealTimeMonitoringUmbrellaApi* | [**get_umbrella_overview**](docs/RealTimeMonitoringUmbrellaApi.md#get_umbrella_overview) | **GET** /device/umbrella/overview | 
*RealTimeMonitoringVDSLServiceApi* | [**get_co_line_specific_stats**](docs/RealTimeMonitoringVDSLServiceApi.md#get_co_line_specific_stats) | **GET** /device/vdslService/coLineSpecificStats | 
*RealTimeMonitoringVDSLServiceApi* | [**get_co_stats**](docs/RealTimeMonitoringVDSLServiceApi.md#get_co_stats) | **GET** /device/vdslService/coStats | 
*RealTimeMonitoringVDSLServiceApi* | [**get_cpe_line_specific_stats**](docs/RealTimeMonitoringVDSLServiceApi.md#get_cpe_line_specific_stats) | **GET** /device/vdslService/cpeLineSpecificStats | 
*RealTimeMonitoringVDSLServiceApi* | [**get_cpe_stats**](docs/RealTimeMonitoringVDSLServiceApi.md#get_cpe_stats) | **GET** /device/vdslService/cpeStats | 
*RealTimeMonitoringVDSLServiceApi* | [**get_line_bonding_stats**](docs/RealTimeMonitoringVDSLServiceApi.md#get_line_bonding_stats) | **GET** /device/vdslService/lineBondingStats | 
*RealTimeMonitoringVDSLServiceApi* | [**get_line_specific_stats**](docs/RealTimeMonitoringVDSLServiceApi.md#get_line_specific_stats) | **GET** /device/vdslService/lineSpecificStats | 
*RealTimeMonitoringVDSLServiceApi* | [**get_vdsl_info**](docs/RealTimeMonitoringVDSLServiceApi.md#get_vdsl_info) | **GET** /device/vdslService/vdslInfo | 
*RealTimeMonitoringVMApi* | [**get_cloud_dock_vm_lifecycle_nics**](docs/RealTimeMonitoringVMApi.md#get_cloud_dock_vm_lifecycle_nics) | **GET** /device/vm/notifications | 
*RealTimeMonitoringVMApi* | [**get_vbranch_vm_lifecycle**](docs/RealTimeMonitoringVMApi.md#get_vbranch_vm_lifecycle) | **GET** /device/vm/oper/state | 
*RealTimeMonitoringVMApi* | [**get_vbranch_vm_lifecycle_nics**](docs/RealTimeMonitoringVMApi.md#get_vbranch_vm_lifecycle_nics) | **GET** /device/vm/nics | 
*RealTimeMonitoringVMApi* | [**get_vm_life_cycle_state**](docs/RealTimeMonitoringVMApi.md#get_vm_life_cycle_state) | **GET** /device/vm/state | 
*RealTimeMonitoringVPNApi* | [**get_vpn_instances**](docs/RealTimeMonitoringVPNApi.md#get_vpn_instances) | **GET** /device/vpn | 
*RealTimeMonitoringVRRPApi* | [**get_vrrp_interface**](docs/RealTimeMonitoringVRRPApi.md#get_vrrp_interface) | **GET** /device/vrrp | 
*RealTimeMonitoringVoiceApi* | [**get_controller_t1e1_info_current15_min_stats**](docs/RealTimeMonitoringVoiceApi.md#get_controller_t1e1_info_current15_min_stats) | **GET** /device/voicet1e1controllerinfo/current15minstats | 
*RealTimeMonitoringVoiceApi* | [**get_controller_t1e1_info_total_stats**](docs/RealTimeMonitoringVoiceApi.md#get_controller_t1e1_info_total_stats) | **GET** /device/voicet1e1controllerinfo/totalstats | 
*RealTimeMonitoringVoiceApi* | [**get_dsp_active**](docs/RealTimeMonitoringVoiceApi.md#get_dsp_active) | **GET** /device/voice/dspActive | 
*RealTimeMonitoringVoiceApi* | [**get_dsp_farm_profiles**](docs/RealTimeMonitoringVoiceApi.md#get_dsp_farm_profiles) | **GET** /device/voice/profiles | 
*RealTimeMonitoringVoiceApi* | [**get_phone_info**](docs/RealTimeMonitoringVoiceApi.md#get_phone_info) | **GET** /device/voice/phoneInfo | 
*RealTimeMonitoringVoiceApi* | [**get_sccp_ccm_groups**](docs/RealTimeMonitoringVoiceApi.md#get_sccp_ccm_groups) | **GET** /device/voice/sccpCcmGroups | 
*RealTimeMonitoringVoiceApi* | [**get_sccp_connections**](docs/RealTimeMonitoringVoiceApi.md#get_sccp_connections) | **GET** /device/voice/sccpConnections | 
*RealTimeMonitoringVoiceApi* | [**get_t1e1_isdn_status**](docs/RealTimeMonitoringVoiceApi.md#get_t1e1_isdn_status) | **GET** /device/voiceisdninfo/isdnstatus | 
*RealTimeMonitoringVoiceApi* | [**get_voice_calls**](docs/RealTimeMonitoringVoiceApi.md#get_voice_calls) | **GET** /device/voice/voiceCalls | 
*RealTimeMonitoringVoiceApi* | [**get_voip_calls**](docs/RealTimeMonitoringVoiceApi.md#get_voip_calls) | **GET** /device/voice/voipCalls | 
*RealTimeMonitoringWLANApi* | [**get_wlan_clients**](docs/RealTimeMonitoringWLANApi.md#get_wlan_clients) | **GET** /device/wlan/clients | 
*RealTimeMonitoringWLANApi* | [**get_wlan_interfaces**](docs/RealTimeMonitoringWLANApi.md#get_wlan_interfaces) | **GET** /device/wlan/interfaces | 
*RealTimeMonitoringWLANApi* | [**get_wlan_radios**](docs/RealTimeMonitoringWLANApi.md#get_wlan_radios) | **GET** /device/wlan/radios | 
*RealTimeMonitoringWLANApi* | [**get_wlan_radius**](docs/RealTimeMonitoringWLANApi.md#get_wlan_radius) | **GET** /device/wlan/radius | 
*RealTimeMonitoringWirelessApi* | [**get_wireless_clients**](docs/RealTimeMonitoringWirelessApi.md#get_wireless_clients) | **GET** /device/wireless/client | 
*RealTimeMonitoringWirelessApi* | [**get_wireless_radios**](docs/RealTimeMonitoringWirelessApi.md#get_wireless_radios) | **GET** /device/wireless/radio | 
*RealTimeMonitoringWirelessApi* | [**get_wireless_ssid**](docs/RealTimeMonitoringWirelessApi.md#get_wireless_ssid) | **GET** /device/wireless/ssid | 
*ResourcePoolApi* | [**create_resources**](docs/ResourcePoolApi.md#create_resources) | **PUT** /resourcepool/resource/vpn | 
*ResourcePoolApi* | [**delete_resources**](docs/ResourcePoolApi.md#delete_resources) | **DELETE** /resourcepool/resource/vpn | 
*ResourcePoolApi* | [**get_resources**](docs/ResourcePoolApi.md#get_resources) | **GET** /resourcepool/resource/vpn | 
*SDAVCCloudConnectorApi* | [**disable_cloud_connector**](docs/SDAVCCloudConnectorApi.md#disable_cloud_connector) | **PUT** /sdavc/cloudconnector | 
*SDAVCCloudConnectorApi* | [**enable_cloud_connector**](docs/SDAVCCloudConnectorApi.md#enable_cloud_connector) | **POST** /sdavc/cloudconnector | 
*SDAVCCloudConnectorApi* | [**get_cloud_connector**](docs/SDAVCCloudConnectorApi.md#get_cloud_connector) | **GET** /sdavc/cloudconnector | 
*SDAVCCloudConnectorApi* | [**get_cloud_connector_status**](docs/SDAVCCloudConnectorApi.md#get_cloud_connector_status) | **GET** /sdavc/cloudconnector/status | 
*SDAVCDomainBasedAppRulesApi* | [**get_cloud_connector_domain_app_rules**](docs/SDAVCDomainBasedAppRulesApi.md#get_cloud_connector_domain_app_rules) | **GET** /monitor/sdavccloudconnector/domain | 
*SDAVCIPAddressBasedAppRulesApi* | [**get_cloud_connector_ip_address_app_rules**](docs/SDAVCIPAddressBasedAppRulesApi.md#get_cloud_connector_ip_address_app_rules) | **GET** /monitor/sdavccloudconnector/ipaddress | 
*ScheduledBackupRestoreApi* | [**delete_schduled_backup**](docs/ScheduledBackupRestoreApi.md#delete_schduled_backup) | **DELETE** /backup/backupinfo | 
*ScheduledBackupRestoreApi* | [**delete_schedule**](docs/ScheduledBackupRestoreApi.md#delete_schedule) | **DELETE** /schedule/{schedulerId} | 
*ScheduledBackupRestoreApi* | [**download_backup_file**](docs/ScheduledBackupRestoreApi.md#download_backup_file) | **GET** /backup/download/{path} | 
*ScheduledBackupRestoreApi* | [**export_backup**](docs/ScheduledBackupRestoreApi.md#export_backup) | **POST** /backup/export | 
*ScheduledBackupRestoreApi* | [**get_local_backup_info**](docs/ScheduledBackupRestoreApi.md#get_local_backup_info) | **GET** /backup/backupinfo/{localBackupInfoId} | 
*ScheduledBackupRestoreApi* | [**get_schedule_record_for_backup**](docs/ScheduledBackupRestoreApi.md#get_schedule_record_for_backup) | **GET** /schedule/{schedulerId} | 
*ScheduledBackupRestoreApi* | [**import_scheduled_backup**](docs/ScheduledBackupRestoreApi.md#import_scheduled_backup) | **POST** /restore/import | 
*ScheduledBackupRestoreApi* | [**list_backup**](docs/ScheduledBackupRestoreApi.md#list_backup) | **GET** /backup/list | 
*ScheduledBackupRestoreApi* | [**list_schedules**](docs/ScheduledBackupRestoreApi.md#list_schedules) | **GET** /schedule/list | 
*ScheduledBackupRestoreApi* | [**remote_import_backup**](docs/ScheduledBackupRestoreApi.md#remote_import_backup) | **POST** /restore/remoteimport | 
*ScheduledBackupRestoreApi* | [**schedule_backup**](docs/ScheduledBackupRestoreApi.md#schedule_backup) | **POST** /schedule/create | 
*SmartLicenseApi* | [**fetch_accounts**](docs/SmartLicenseApi.md#fetch_accounts) | **GET** /smartLicensing/fetchAccounts | 
*SmartLicenseApi* | [**fetch_reports**](docs/SmartLicenseApi.md#fetch_reports) | **GET** /smartLicensing/fetchReportsForSa | 
*SmartLicenseApi* | [**fetch_reports1**](docs/SmartLicenseApi.md#fetch_reports1) | **GET** /smartLicensing/fetchAllSa | 
*SmartLicenseApi* | [**get_settings**](docs/SmartLicenseApi.md#get_settings) | **GET** /smartLicensing/getUserSettings | 
*SmartLicenseApi* | [**sleauthenticate**](docs/SmartLicenseApi.md#sleauthenticate) | **POST** /smartLicensing/authenticate | 
*SmartLicenseApi* | [**sync_licenses**](docs/SmartLicenseApi.md#sync_licenses) | **POST** /smartLicensing/syncLicenses | 
*SmartLicenseApi* | [**sync_licenses1**](docs/SmartLicenseApi.md#sync_licenses1) | **POST** /smartLicensing/removeSaVaSelection | 
*SmartLicenseApi* | [**upload_ack**](docs/SmartLicenseApi.md#upload_ack) | **POST** /smartLicensing/uploadAck | 
*SystemCloudServiceApi* | [**add_cloud_credentials**](docs/SystemCloudServiceApi.md#add_cloud_credentials) | **POST** /cloudservices/credentials | 
*SystemCloudServiceApi* | [**connect**](docs/SystemCloudServiceApi.md#connect) | **GET** /cloudservices/connect | 
*SystemCloudServiceApi* | [**entity_ownership_info**](docs/SystemCloudServiceApi.md#entity_ownership_info) | **GET** /entityownership/tree | 
*SystemCloudServiceApi* | [**get_access_tokenfor_device**](docs/SystemCloudServiceApi.md#get_access_tokenfor_device) | **GET** /cloudservices/accesstoken | 
*SystemCloudServiceApi* | [**get_azure_token**](docs/SystemCloudServiceApi.md#get_azure_token) | **POST** /cloudservices/authtoken | 
*SystemCloudServiceApi* | [**get_cloud_credentials**](docs/SystemCloudServiceApi.md#get_cloud_credentials) | **GET** /cloudservices/credentials | 
*SystemCloudServiceApi* | [**get_cloud_settings**](docs/SystemCloudServiceApi.md#get_cloud_settings) | **GET** /dca/cloudservices | 
*SystemCloudServiceApi* | [**get_device_code**](docs/SystemCloudServiceApi.md#get_device_code) | **POST** /cloudservices/devicecode | 
*SystemCloudServiceApi* | [**get_otp**](docs/SystemCloudServiceApi.md#get_otp) | **GET** /dca/cloudservices/otp | 
*SystemCloudServiceApi* | [**get_telemetry_state**](docs/SystemCloudServiceApi.md#get_telemetry_state) | **GET** /cloudservices/telemetry | 
*SystemCloudServiceApi* | [**is_staging**](docs/SystemCloudServiceApi.md#is_staging) | **GET** /cloudservices/staging | 
*SystemCloudServiceApi* | [**list_entity_ownership_info**](docs/SystemCloudServiceApi.md#list_entity_ownership_info) | **GET** /entityownership/list | 
*SystemCloudServiceApi* | [**opt_in**](docs/SystemCloudServiceApi.md#opt_in) | **PUT** /cloudservices/telemetry/optin | 
*SystemCloudServiceApi* | [**opt_out**](docs/SystemCloudServiceApi.md#opt_out) | **DELETE** /cloudservices/telemetry/optout | 
*SystemCloudServiceApi* | [**updatet_otp**](docs/SystemCloudServiceApi.md#updatet_otp) | **PUT** /dca/cloudservices/otp | 
*SystemCloudServiceWebexApi* | [**delete_webex_data_centers**](docs/SystemCloudServiceWebexApi.md#delete_webex_data_centers) | **DELETE** /webex/datacenter | 
*SystemCloudServiceWebexApi* | [**get_webex_data_centers**](docs/SystemCloudServiceWebexApi.md#get_webex_data_centers) | **POST** /webex/datacenter | 
*SystemCloudServiceWebexApi* | [**get_webex_data_centers_sync_status**](docs/SystemCloudServiceWebexApi.md#get_webex_data_centers_sync_status) | **GET** /webex/datacenter/syncstatus | 
*SystemCloudServiceWebexApi* | [**set_webex_data_centers_sync_status**](docs/SystemCloudServiceWebexApi.md#set_webex_data_centers_sync_status) | **PUT** /webex/datacenter/syncstatus | 
*SystemCloudServiceWebexApi* | [**update_webex_data_centers**](docs/SystemCloudServiceWebexApi.md#update_webex_data_centers) | **POST** /webex/datacenter/sync | 
*SystemContainerApi* | [**activate_container**](docs/SystemContainerApi.md#activate_container) | **POST** /sdavc/task/{taskId} | 
*SystemContainerApi* | [**activate_container_on_remote_host**](docs/SystemContainerApi.md#activate_container_on_remote_host) | **POST** /container-manager/activate/{containerName} | 
*SystemContainerApi* | [**de_activate_container**](docs/SystemContainerApi.md#de_activate_container) | **POST** /container-manager/deactivate/{containerName} | 
*SystemContainerApi* | [**does_valid_image_exist**](docs/SystemContainerApi.md#does_valid_image_exist) | **GET** /container-manager/doesValidImageExist/{containerName} | 
*SystemContainerApi* | [**get_container_inspect_data**](docs/SystemContainerApi.md#get_container_inspect_data) | **GET** /container-manager/inspect/{containerName} | 
*SystemContainerApi* | [**get_container_settings**](docs/SystemContainerApi.md#get_container_settings) | **GET** /container-manager/settings/{containerName} | 
*SystemContainerApi* | [**get_custom_app**](docs/SystemContainerApi.md#get_custom_app) | **GET** /sdavc/customapps | 
*SystemContainerApi* | [**test_load_balancer**](docs/SystemContainerApi.md#test_load_balancer) | **POST** /sdavc/test | 
*SystemReverseProxyApi* | [**create_reverse_proxy_mappings**](docs/SystemReverseProxyApi.md#create_reverse_proxy_mappings) | **POST** /system/reverseproxy/{uuid} | 
*SystemReverseProxyApi* | [**get_reverse_proxy_mappings**](docs/SystemReverseProxyApi.md#get_reverse_proxy_mappings) | **GET** /system/reverseproxy/{uuid} | 
*TagApi* | [**check_for_conflicts_when_tagging**](docs/TagApi.md#check_for_conflicts_when_tagging) | **POST** /tag/conflictCheck | 
*TagApi* | [**check_rules**](docs/TagApi.md#check_rules) | **POST** /tag/checkRules | 
*TagApi* | [**create_tag**](docs/TagApi.md#create_tag) | **POST** /tag | 
*TagApi* | [**create_tag_rule**](docs/TagApi.md#create_tag_rule) | **POST** /tag/tagRules | 
*TagApi* | [**delete_tag**](docs/TagApi.md#delete_tag) | **POST** /tag/remove | 
*TagApi* | [**delete_tag_rule**](docs/TagApi.md#delete_tag_rule) | **DELETE** /tag/tagRules/{tagRuleId} | 
*TagApi* | [**edit_tag_rule**](docs/TagApi.md#edit_tag_rule) | **PUT** /tag/tagRules | 
*TagApi* | [**get_tag**](docs/TagApi.md#get_tag) | **GET** /tag | 
*TagApi* | [**get_tag_rules**](docs/TagApi.md#get_tag_rules) | **GET** /tag/tagRules/{configGroupId} | 
*TagApi* | [**reindex_tag**](docs/TagApi.md#reindex_tag) | **GET** /tag/reindex | 
*TenantBackupRestoreApi* | [**delete_tenant_backup**](docs/TenantBackupRestoreApi.md#delete_tenant_backup) | **DELETE** /tenantbackup/delete | 
*TenantBackupRestoreApi* | [**download_existing_backup_file**](docs/TenantBackupRestoreApi.md#download_existing_backup_file) | **GET** /tenantbackup/download/{path} | 
*TenantBackupRestoreApi* | [**export_tenant_backup**](docs/TenantBackupRestoreApi.md#export_tenant_backup) | **GET** /tenantbackup/export | 
*TenantBackupRestoreApi* | [**import_tenant_backup**](docs/TenantBackupRestoreApi.md#import_tenant_backup) | **POST** /tenantbackup/import | 
*TenantBackupRestoreApi* | [**list_tenant_backup**](docs/TenantBackupRestoreApi.md#list_tenant_backup) | **GET** /tenantbackup/list | 
*TenantManagementApi* | [**create_tenant**](docs/TenantManagementApi.md#create_tenant) | **POST** /tenant | 
*TenantManagementApi* | [**create_tenant_async**](docs/TenantManagementApi.md#create_tenant_async) | **POST** /tenant/async | 
*TenantManagementApi* | [**create_tenant_async_bulk**](docs/TenantManagementApi.md#create_tenant_async_bulk) | **POST** /tenant/bulk/async | 
*TenantManagementApi* | [**delete_tenant**](docs/TenantManagementApi.md#delete_tenant) | **POST** /tenant/{tenantId}/delete | 
*TenantManagementApi* | [**delete_tenant_async_bulk**](docs/TenantManagementApi.md#delete_tenant_async_bulk) | **DELETE** /tenant/bulk/async | 
*TenantManagementApi* | [**force_status_collection**](docs/TenantManagementApi.md#force_status_collection) | **POST** /tenantstatus/force | 
*TenantManagementApi* | [**get_all_tenant_statuses**](docs/TenantManagementApi.md#get_all_tenant_statuses) | **GET** /tenantstatus | 
*TenantManagementApi* | [**get_all_tenants**](docs/TenantManagementApi.md#get_all_tenants) | **GET** /tenant | 
*TenantManagementApi* | [**get_tenant**](docs/TenantManagementApi.md#get_tenant) | **GET** /tenant/{tenantId} | 
*TenantManagementApi* | [**get_tenant_hosting_capacity_onv_smarts**](docs/TenantManagementApi.md#get_tenant_hosting_capacity_onv_smarts) | **GET** /tenant/vsmart/capacity | 
*TenantManagementApi* | [**get_tenantv_smart_mapping**](docs/TenantManagementApi.md#get_tenantv_smart_mapping) | **GET** /tenant/vsmart | 
*TenantManagementApi* | [**switch_tenant**](docs/TenantManagementApi.md#switch_tenant) | **POST** /tenant/{tenantId}/switch | 
*TenantManagementApi* | [**tenantv_smart_mt_migrate**](docs/TenantManagementApi.md#tenantv_smart_mt_migrate) | **POST** /tenant/vsmart-mt/migrate | 
*TenantManagementApi* | [**update_tenant**](docs/TenantManagementApi.md#update_tenant) | **PUT** /tenant/{tenantId} | 
*TenantManagementApi* | [**v_session_id**](docs/TenantManagementApi.md#v_session_id) | **POST** /tenant/{tenantId}/vsessionid | 
*TenantMigrationApi* | [**download_tenant_data**](docs/TenantMigrationApi.md#download_tenant_data) | **GET** /tenantmigration/download/{path} | 
*TenantMigrationApi* | [**export_tenant_data**](docs/TenantMigrationApi.md#export_tenant_data) | **POST** /tenantmigration/export | 
*TenantMigrationApi* | [**get_migration_token**](docs/TenantMigrationApi.md#get_migration_token) | **GET** /tenantmigration/migrationToken | 
*TenantMigrationApi* | [**import_tenant_data**](docs/TenantMigrationApi.md#import_tenant_data) | **POST** /tenantmigration/import | 
*TenantMigrationApi* | [**migrate_network**](docs/TenantMigrationApi.md#migrate_network) | **POST** /tenantmigration/networkMigration | 
*TenantMigrationApi* | [**re_trigger_network_migration**](docs/TenantMigrationApi.md#re_trigger_network_migration) | **GET** /tenantmigration/networkMigration | 
*TroubleshootingToolsDeviceConnectivityApi* | [**copy_admin_tech_on_device**](docs/TroubleshootingToolsDeviceConnectivityApi.md#copy_admin_tech_on_device) | **POST** /device/tools/admintech/copy | 
*TroubleshootingToolsDeviceConnectivityApi* | [**create_admin_tech**](docs/TroubleshootingToolsDeviceConnectivityApi.md#create_admin_tech) | **POST** /device/tools/admintech | 
*TroubleshootingToolsDeviceConnectivityApi* | [**delete_admin_tech_file**](docs/TroubleshootingToolsDeviceConnectivityApi.md#delete_admin_tech_file) | **DELETE** /device/tools/admintech/{requestID} | 
*TroubleshootingToolsDeviceConnectivityApi* | [**delete_admin_tech_on_device**](docs/TroubleshootingToolsDeviceConnectivityApi.md#delete_admin_tech_on_device) | **DELETE** /device/tools/admintech/delete | 
*TroubleshootingToolsDeviceConnectivityApi* | [**download_admin_tech_file**](docs/TroubleshootingToolsDeviceConnectivityApi.md#download_admin_tech_file) | **GET** /device/tools/admintech/download/{filename} | 
*TroubleshootingToolsDeviceConnectivityApi* | [**factory_reset**](docs/TroubleshootingToolsDeviceConnectivityApi.md#factory_reset) | **POST** /device/tools/factoryreset | 
*TroubleshootingToolsDeviceConnectivityApi* | [**get_control_connections**](docs/TroubleshootingToolsDeviceConnectivityApi.md#get_control_connections) | **GET** /troubleshooting/control/{uuid} | 
*TroubleshootingToolsDeviceConnectivityApi* | [**get_device_configuration**](docs/TroubleshootingToolsDeviceConnectivityApi.md#get_device_configuration) | **GET** /troubleshooting/devicebringup | 
*TroubleshootingToolsDeviceConnectivityApi* | [**get_in_progress_count**](docs/TroubleshootingToolsDeviceConnectivityApi.md#get_in_progress_count) | **GET** /device/tools/admintechs/inprogress | 
*TroubleshootingToolsDeviceConnectivityApi* | [**invalidate_device**](docs/TroubleshootingToolsDeviceConnectivityApi.md#invalidate_device) | **POST** /certificate/device/invalidate | 
*TroubleshootingToolsDeviceConnectivityApi* | [**list_admin_techs**](docs/TroubleshootingToolsDeviceConnectivityApi.md#list_admin_techs) | **GET** /device/tools/admintechs | 
*TroubleshootingToolsDeviceConnectivityApi* | [**list_admin_techs_on_device**](docs/TroubleshootingToolsDeviceConnectivityApi.md#list_admin_techs_on_device) | **POST** /device/tools/admintechlist | 
*TroubleshootingToolsDeviceConnectivityApi* | [**nping_device**](docs/TroubleshootingToolsDeviceConnectivityApi.md#nping_device) | **POST** /device/tools/nping/{deviceIP} | 
*TroubleshootingToolsDeviceConnectivityApi* | [**ping_device**](docs/TroubleshootingToolsDeviceConnectivityApi.md#ping_device) | **POST** /device/tools/ping/{deviceIP} | 
*TroubleshootingToolsDeviceConnectivityApi* | [**process_interface_reset**](docs/TroubleshootingToolsDeviceConnectivityApi.md#process_interface_reset) | **POST** /device/tools/reset/interface/{deviceIP} | 
*TroubleshootingToolsDeviceConnectivityApi* | [**process_port_hop_color**](docs/TroubleshootingToolsDeviceConnectivityApi.md#process_port_hop_color) | **POST** /device/tools/porthopcolor/{deviceIP} | 
*TroubleshootingToolsDeviceConnectivityApi* | [**process_reset_user**](docs/TroubleshootingToolsDeviceConnectivityApi.md#process_reset_user) | **POST** /device/tools/resetuser/{deviceIP} | 
*TroubleshootingToolsDeviceConnectivityApi* | [**service_path**](docs/TroubleshootingToolsDeviceConnectivityApi.md#service_path) | **POST** /device/tools/servicepath/{deviceIP} | 
*TroubleshootingToolsDeviceConnectivityApi* | [**stage_device**](docs/TroubleshootingToolsDeviceConnectivityApi.md#stage_device) | **POST** /certificate/device/stage | 
*TroubleshootingToolsDeviceConnectivityApi* | [**traceroute_device**](docs/TroubleshootingToolsDeviceConnectivityApi.md#traceroute_device) | **POST** /device/tools/traceroute/{deviceIP} | 
*TroubleshootingToolsDeviceConnectivityApi* | [**tunnel_path**](docs/TroubleshootingToolsDeviceConnectivityApi.md#tunnel_path) | **POST** /device/tools/tunnelpath/{deviceIP} | 
*TroubleshootingToolsDeviceConnectivityApi* | [**upload_admin_tech**](docs/TroubleshootingToolsDeviceConnectivityApi.md#upload_admin_tech) | **POST** /device/tools/admintechs/upload | 
*TroubleshootingToolsDeviceGroupApi* | [**list_device_group_list**](docs/TroubleshootingToolsDeviceGroupApi.md#list_device_group_list) | **GET** /group | 
*TroubleshootingToolsDeviceGroupApi* | [**list_device_groups**](docs/TroubleshootingToolsDeviceGroupApi.md#list_device_groups) | **GET** /group/device | 
*TroubleshootingToolsDeviceGroupApi* | [**list_group_devices**](docs/TroubleshootingToolsDeviceGroupApi.md#list_group_devices) | **GET** /group/devices | 
*TroubleshootingToolsDeviceGroupApi* | [**list_group_devices_for_map**](docs/TroubleshootingToolsDeviceGroupApi.md#list_group_devices_for_map) | **GET** /group/map/devices | 
*TroubleshootingToolsDeviceGroupApi* | [**list_group_links_for_map**](docs/TroubleshootingToolsDeviceGroupApi.md#list_group_links_for_map) | **GET** /group/map/devices/links | 
*TroubleshootingToolsDiagnosticsApi* | [**clear_session**](docs/TroubleshootingToolsDiagnosticsApi.md#clear_session) | **GET** /stream/device/log/sessions/clear/{sessionId} | 
*TroubleshootingToolsDiagnosticsApi* | [**disable_device_log**](docs/TroubleshootingToolsDiagnosticsApi.md#disable_device_log) | **GET** /stream/device/log/disable/{sessionId} | 
*TroubleshootingToolsDiagnosticsApi* | [**disable_packet_capture_session**](docs/TroubleshootingToolsDiagnosticsApi.md#disable_packet_capture_session) | **GET** /stream/device/capture/disable/{sessionId} | 
*TroubleshootingToolsDiagnosticsApi* | [**disable_speed_test_session**](docs/TroubleshootingToolsDiagnosticsApi.md#disable_speed_test_session) | **GET** /stream/device/speed/disable/{sessionId} | 
*TroubleshootingToolsDiagnosticsApi* | [**download_debug_log**](docs/TroubleshootingToolsDiagnosticsApi.md#download_debug_log) | **GET** /stream/device/log/download/{sessionId} | 
*TroubleshootingToolsDiagnosticsApi* | [**download_file**](docs/TroubleshootingToolsDiagnosticsApi.md#download_file) | **GET** /stream/device/capture/download/{sessionId} | 
*TroubleshootingToolsDiagnosticsApi* | [**force_stop_pcap_session**](docs/TroubleshootingToolsDiagnosticsApi.md#force_stop_pcap_session) | **GET** /stream/device/capture/forcedisbale/{sessionId} | 
*TroubleshootingToolsDiagnosticsApi* | [**form_post_packet_capture**](docs/TroubleshootingToolsDiagnosticsApi.md#form_post_packet_capture) | **POST** /stream/device/capture/{deviceUUID}/{sessionId} | 
*TroubleshootingToolsDiagnosticsApi* | [**get_aggregation_data_by_query27**](docs/TroubleshootingToolsDiagnosticsApi.md#get_aggregation_data_by_query27) | **GET** /stream/device/nwpi/aggregation | 
*TroubleshootingToolsDiagnosticsApi* | [**get_aggregation_data_by_query28**](docs/TroubleshootingToolsDiagnosticsApi.md#get_aggregation_data_by_query28) | **GET** /statistics/speedtest/aggregation | 
*TroubleshootingToolsDiagnosticsApi* | [**get_concurrent_data**](docs/TroubleshootingToolsDiagnosticsApi.md#get_concurrent_data) | **GET** /stream/device/nwpi/concurrentData | 
*TroubleshootingToolsDiagnosticsApi* | [**get_concurrent_domain_data**](docs/TroubleshootingToolsDiagnosticsApi.md#get_concurrent_domain_data) | **GET** /stream/device/nwpi/concurrentDomainData | 
*TroubleshootingToolsDiagnosticsApi* | [**get_count29**](docs/TroubleshootingToolsDiagnosticsApi.md#get_count29) | **GET** /stream/device/nwpi/doccount | 
*TroubleshootingToolsDiagnosticsApi* | [**get_count30**](docs/TroubleshootingToolsDiagnosticsApi.md#get_count30) | **GET** /statistics/speedtest/doccount | 
*TroubleshootingToolsDiagnosticsApi* | [**get_count_post29**](docs/TroubleshootingToolsDiagnosticsApi.md#get_count_post29) | **POST** /stream/device/nwpi/doccount | 
*TroubleshootingToolsDiagnosticsApi* | [**get_count_post30**](docs/TroubleshootingToolsDiagnosticsApi.md#get_count_post30) | **POST** /statistics/speedtest/doccount | 
*TroubleshootingToolsDiagnosticsApi* | [**get_db_schema**](docs/TroubleshootingToolsDiagnosticsApi.md#get_db_schema) | **GET** /diagnostics/dbschema | 
*TroubleshootingToolsDiagnosticsApi* | [**get_device_log**](docs/TroubleshootingToolsDiagnosticsApi.md#get_device_log) | **GET** /stream/device/log/{sessionId} | 
*TroubleshootingToolsDiagnosticsApi* | [**get_domain_metric**](docs/TroubleshootingToolsDiagnosticsApi.md#get_domain_metric) | **GET** /stream/device/nwpi/domainMetric | 
*TroubleshootingToolsDiagnosticsApi* | [**get_file_download_status**](docs/TroubleshootingToolsDiagnosticsApi.md#get_file_download_status) | **GET** /stream/device/capture/status/{sessionId} | 
*TroubleshootingToolsDiagnosticsApi* | [**get_finalized_data**](docs/TroubleshootingToolsDiagnosticsApi.md#get_finalized_data) | **GET** /stream/device/nwpi/finalizedData | 
*TroubleshootingToolsDiagnosticsApi* | [**get_finalized_domain_data**](docs/TroubleshootingToolsDiagnosticsApi.md#get_finalized_domain_data) | **GET** /stream/device/nwpi/finalizedDomainData | 
*TroubleshootingToolsDiagnosticsApi* | [**get_flow_detail**](docs/TroubleshootingToolsDiagnosticsApi.md#get_flow_detail) | **GET** /stream/device/nwpi/flowDetail | 
*TroubleshootingToolsDiagnosticsApi* | [**get_flow_metric**](docs/TroubleshootingToolsDiagnosticsApi.md#get_flow_metric) | **GET** /stream/device/nwpi/flowMetric | 
*TroubleshootingToolsDiagnosticsApi* | [**get_interface_bandwidth**](docs/TroubleshootingToolsDiagnosticsApi.md#get_interface_bandwidth) | **GET** /stream/device/speed/interface/bandwidth | 
*TroubleshootingToolsDiagnosticsApi* | [**get_log_type**](docs/TroubleshootingToolsDiagnosticsApi.md#get_log_type) | **GET** /stream/device/log/type | 
*TroubleshootingToolsDiagnosticsApi* | [**get_monitor_state**](docs/TroubleshootingToolsDiagnosticsApi.md#get_monitor_state) | **GET** /stream/device/nwpi/getMonitorState | 
*TroubleshootingToolsDiagnosticsApi* | [**get_nwpi_dscp**](docs/TroubleshootingToolsDiagnosticsApi.md#get_nwpi_dscp) | **GET** /stream/device/nwpi/nwpiDSCP | 
*TroubleshootingToolsDiagnosticsApi* | [**get_nwpi_nbar_app_group**](docs/TroubleshootingToolsDiagnosticsApi.md#get_nwpi_nbar_app_group) | **GET** /stream/device/nwpi/nwpiNbarAppGroup | 
*TroubleshootingToolsDiagnosticsApi* | [**get_nwpi_protocol**](docs/TroubleshootingToolsDiagnosticsApi.md#get_nwpi_protocol) | **GET** /stream/device/nwpi/nwpiProtocol | 
*TroubleshootingToolsDiagnosticsApi* | [**get_packet_features**](docs/TroubleshootingToolsDiagnosticsApi.md#get_packet_features) | **GET** /stream/device/nwpi/packetFeatures | 
*TroubleshootingToolsDiagnosticsApi* | [**get_post_aggregation_app_data_by_query26**](docs/TroubleshootingToolsDiagnosticsApi.md#get_post_aggregation_app_data_by_query26) | **POST** /stream/device/nwpi/app-agg/aggregation | 
*TroubleshootingToolsDiagnosticsApi* | [**get_post_aggregation_app_data_by_query27**](docs/TroubleshootingToolsDiagnosticsApi.md#get_post_aggregation_app_data_by_query27) | **POST** /statistics/speedtest/app-agg/aggregation | 
*TroubleshootingToolsDiagnosticsApi* | [**get_post_aggregation_data_by_query27**](docs/TroubleshootingToolsDiagnosticsApi.md#get_post_aggregation_data_by_query27) | **POST** /stream/device/nwpi/aggregation | 
*TroubleshootingToolsDiagnosticsApi* | [**get_post_aggregation_data_by_query28**](docs/TroubleshootingToolsDiagnosticsApi.md#get_post_aggregation_data_by_query28) | **POST** /statistics/speedtest/aggregation | 
*TroubleshootingToolsDiagnosticsApi* | [**get_post_stat_bulk_raw_data27**](docs/TroubleshootingToolsDiagnosticsApi.md#get_post_stat_bulk_raw_data27) | **POST** /stream/device/nwpi/page | 
*TroubleshootingToolsDiagnosticsApi* | [**get_post_stat_bulk_raw_data28**](docs/TroubleshootingToolsDiagnosticsApi.md#get_post_stat_bulk_raw_data28) | **POST** /statistics/speedtest/page | 
*TroubleshootingToolsDiagnosticsApi* | [**get_session**](docs/TroubleshootingToolsDiagnosticsApi.md#get_session) | **POST** /stream/device/speed | 
*TroubleshootingToolsDiagnosticsApi* | [**get_session_info_capture**](docs/TroubleshootingToolsDiagnosticsApi.md#get_session_info_capture) | **POST** /stream/device/capture | 
*TroubleshootingToolsDiagnosticsApi* | [**get_session_info_log**](docs/TroubleshootingToolsDiagnosticsApi.md#get_session_info_log) | **POST** /stream/device/log | 
*TroubleshootingToolsDiagnosticsApi* | [**get_sessions**](docs/TroubleshootingToolsDiagnosticsApi.md#get_sessions) | **GET** /stream/device/log/sessions | 
*TroubleshootingToolsDiagnosticsApi* | [**get_speed_test**](docs/TroubleshootingToolsDiagnosticsApi.md#get_speed_test) | **GET** /stream/device/speed/{sessionId} | 
*TroubleshootingToolsDiagnosticsApi* | [**get_speed_test_status**](docs/TroubleshootingToolsDiagnosticsApi.md#get_speed_test_status) | **GET** /stream/device/speed/status/{sessionId} | 
*TroubleshootingToolsDiagnosticsApi* | [**get_stat_bulk_raw_data27**](docs/TroubleshootingToolsDiagnosticsApi.md#get_stat_bulk_raw_data27) | **GET** /stream/device/nwpi/page | 
*TroubleshootingToolsDiagnosticsApi* | [**get_stat_bulk_raw_data28**](docs/TroubleshootingToolsDiagnosticsApi.md#get_stat_bulk_raw_data28) | **GET** /statistics/speedtest/page | 
*TroubleshootingToolsDiagnosticsApi* | [**get_stat_data_fields29**](docs/TroubleshootingToolsDiagnosticsApi.md#get_stat_data_fields29) | **GET** /stream/device/nwpi/fields | 
*TroubleshootingToolsDiagnosticsApi* | [**get_stat_data_fields30**](docs/TroubleshootingToolsDiagnosticsApi.md#get_stat_data_fields30) | **GET** /statistics/speedtest/fields | 
*TroubleshootingToolsDiagnosticsApi* | [**get_stat_data_raw_data26**](docs/TroubleshootingToolsDiagnosticsApi.md#get_stat_data_raw_data26) | **GET** /stream/device/nwpi | 
*TroubleshootingToolsDiagnosticsApi* | [**get_stat_data_raw_data27**](docs/TroubleshootingToolsDiagnosticsApi.md#get_stat_data_raw_data27) | **GET** /statistics/speedtest | 
*TroubleshootingToolsDiagnosticsApi* | [**get_stat_data_raw_data_as_csv27**](docs/TroubleshootingToolsDiagnosticsApi.md#get_stat_data_raw_data_as_csv27) | **GET** /stream/device/nwpi/csv | 
*TroubleshootingToolsDiagnosticsApi* | [**get_stat_data_raw_data_as_csv28**](docs/TroubleshootingToolsDiagnosticsApi.md#get_stat_data_raw_data_as_csv28) | **GET** /statistics/speedtest/csv | 
*TroubleshootingToolsDiagnosticsApi* | [**get_stat_query_fields29**](docs/TroubleshootingToolsDiagnosticsApi.md#get_stat_query_fields29) | **GET** /stream/device/nwpi/query/fields | 
*TroubleshootingToolsDiagnosticsApi* | [**get_stat_query_fields30**](docs/TroubleshootingToolsDiagnosticsApi.md#get_stat_query_fields30) | **GET** /statistics/speedtest/query/fields | 
*TroubleshootingToolsDiagnosticsApi* | [**get_stats_raw_data27**](docs/TroubleshootingToolsDiagnosticsApi.md#get_stats_raw_data27) | **POST** /stream/device/nwpi | 
*TroubleshootingToolsDiagnosticsApi* | [**get_stats_raw_data28**](docs/TroubleshootingToolsDiagnosticsApi.md#get_stats_raw_data28) | **POST** /statistics/speedtest | 
*TroubleshootingToolsDiagnosticsApi* | [**get_thread_pools**](docs/TroubleshootingToolsDiagnosticsApi.md#get_thread_pools) | **GET** /diagnostics/threadpools | 
*TroubleshootingToolsDiagnosticsApi* | [**get_trace_flow**](docs/TroubleshootingToolsDiagnosticsApi.md#get_trace_flow) | **GET** /stream/device/nwpi/traceFlow | 
*TroubleshootingToolsDiagnosticsApi* | [**get_trace_history**](docs/TroubleshootingToolsDiagnosticsApi.md#get_trace_history) | **GET** /stream/device/nwpi/traceHistory | 
*TroubleshootingToolsDiagnosticsApi* | [**get_vnic_info_by_vnf_id**](docs/TroubleshootingToolsDiagnosticsApi.md#get_vnic_info_by_vnf_id) | **GET** /stream/device/capture/vnicsInfo/{vnfId} | 
*TroubleshootingToolsDiagnosticsApi* | [**monitor_start**](docs/TroubleshootingToolsDiagnosticsApi.md#monitor_start) | **POST** /stream/device/nwpi/monitor/start | 
*TroubleshootingToolsDiagnosticsApi* | [**monitor_stop**](docs/TroubleshootingToolsDiagnosticsApi.md#monitor_stop) | **POST** /stream/device/nwpi/monitor/stop | 
*TroubleshootingToolsDiagnosticsApi* | [**process_device_status**](docs/TroubleshootingToolsDiagnosticsApi.md#process_device_status) | **POST** /stream/device/status/{deviceUUID} | 
*TroubleshootingToolsDiagnosticsApi* | [**renew_session_info**](docs/TroubleshootingToolsDiagnosticsApi.md#renew_session_info) | **GET** /stream/device/log/renew/{sessionId} | 
*TroubleshootingToolsDiagnosticsApi* | [**save_speed_test_results**](docs/TroubleshootingToolsDiagnosticsApi.md#save_speed_test_results) | **POST** /stream/device/speed/{deviceUUID}/{sessionId} | 
*TroubleshootingToolsDiagnosticsApi* | [**search_device_log**](docs/TroubleshootingToolsDiagnosticsApi.md#search_device_log) | **POST** /stream/device/log/search/{sessionId} | 
*TroubleshootingToolsDiagnosticsApi* | [**start_pcap_session**](docs/TroubleshootingToolsDiagnosticsApi.md#start_pcap_session) | **GET** /stream/device/capture/start/{sessionId} | 
*TroubleshootingToolsDiagnosticsApi* | [**start_speed_test**](docs/TroubleshootingToolsDiagnosticsApi.md#start_speed_test) | **GET** /stream/device/speed/start/{sessionId} | 
*TroubleshootingToolsDiagnosticsApi* | [**stop_pcap_session**](docs/TroubleshootingToolsDiagnosticsApi.md#stop_pcap_session) | **GET** /stream/device/capture/stop/{sessionId} | 
*TroubleshootingToolsDiagnosticsApi* | [**stop_speed_test**](docs/TroubleshootingToolsDiagnosticsApi.md#stop_speed_test) | **GET** /stream/device/speed/stop/{sessionId} | 
*TroubleshootingToolsDiagnosticsApi* | [**stream_log**](docs/TroubleshootingToolsDiagnosticsApi.md#stream_log) | **POST** /stream/device/log/{logType}/{deviceUUID}/{sessionId} | 
*TroubleshootingToolsDiagnosticsApi* | [**trace_delete**](docs/TroubleshootingToolsDiagnosticsApi.md#trace_delete) | **DELETE** /stream/device/nwpi/trace/delete | 
*TroubleshootingToolsDiagnosticsApi* | [**trace_fin_flow_with_query**](docs/TroubleshootingToolsDiagnosticsApi.md#trace_fin_flow_with_query) | **GET** /stream/device/nwpi/traceFinFlowWithQuery | 
*TroubleshootingToolsDiagnosticsApi* | [**trace_start**](docs/TroubleshootingToolsDiagnosticsApi.md#trace_start) | **POST** /stream/device/nwpi/trace/start | 
*TroubleshootingToolsDiagnosticsApi* | [**trace_stop**](docs/TroubleshootingToolsDiagnosticsApi.md#trace_stop) | **POST** /stream/device/nwpi/trace/stop/{traceId} | 
*UmbrellaApi* | [**get_all_keys_from_umbrella**](docs/UmbrellaApi.md#get_all_keys_from_umbrella) | **GET** /umbrella/getkeys | 
*UmbrellaApi* | [**get_management_keys_from_umbrella**](docs/UmbrellaApi.md#get_management_keys_from_umbrella) | **GET** /umbrella/getkeys/management | 
*UmbrellaApi* | [**get_network_keys_from_umbrella**](docs/UmbrellaApi.md#get_network_keys_from_umbrella) | **GET** /umbrella/getkeys/networkdevices | 
*UmbrellaApi* | [**get_reporting_keys_from_umbrella**](docs/UmbrellaApi.md#get_reporting_keys_from_umbrella) | **GET** /umbrella/getkeys/reporting | 
*UtilityConfigurationDBApi* | [**get_db_size_on_file**](docs/UtilityConfigurationDBApi.md#get_db_size_on_file) | **GET** /util/configdb/size | 
*UtilityLoggingApi* | [**debug_log**](docs/UtilityLoggingApi.md#debug_log) | **POST** /util/logging/debuglog | 
*UtilityLoggingApi* | [**list_log_file_details**](docs/UtilityLoggingApi.md#list_log_file_details) | **GET** /util/logfile/appserver | 
*UtilityLoggingApi* | [**list_loggers**](docs/UtilityLoggingApi.md#list_loggers) | **GET** /util/logging/loggers | 
*UtilityLoggingApi* | [**list_v_manage_server_log_last_n_lines**](docs/UtilityLoggingApi.md#list_v_manage_server_log_last_n_lines) | **GET** /util/logfile/appserver/lastnlines | 
*UtilityLoggingApi* | [**set_log_level**](docs/UtilityLoggingApi.md#set_log_level) | **POST** /util/logging/level | 
*UtilitySecurityApi* | [**check_given_ip_list**](docs/UtilitySecurityApi.md#check_given_ip_list) | **POST** /software/compliance/ip/origin/check | 
*WorkflowManagementApi* | [**create_workflow**](docs/WorkflowManagementApi.md#create_workflow) | **POST** /workflow | 
*WorkflowManagementApi* | [**delete_workflow**](docs/WorkflowManagementApi.md#delete_workflow) | **DELETE** /workflow | 
*WorkflowManagementApi* | [**get_workflows**](docs/WorkflowManagementApi.md#get_workflows) | **GET** /workflow | 
*WorkflowManagementApi* | [**save_workflow**](docs/WorkflowManagementApi.md#save_workflow) | **PUT** /workflow | 
*DefaultApi* | [**add_tier**](docs/DefaultApi.md#add_tier) | **POST** /device/tier | 
*DefaultApi* | [**delete_tier**](docs/DefaultApi.md#delete_tier) | **DELETE** /device/tier/{tierName} | 
*DefaultApi* | [**get_o365_preferred_path_from_v_analytics**](docs/DefaultApi.md#get_o365_preferred_path_from_v_analytics) | **POST** /cloudservices/m365/preferredpath | 
*DefaultApi* | [**get_tiers**](docs/DefaultApi.md#get_tiers) | **GET** /device/tier | 
*DefaultApi* | [**update_device_action_status**](docs/DefaultApi.md#update_device_action_status) | **PUT** /device/action/status | 


## Documentation For Models

 - [AdvancedRadioSetting](docs/AdvancedRadioSetting.md)
 - [ApiReKeyDevice](docs/ApiReKeyDevice.md)
 - [ApiReKeyDeviceList](docs/ApiReKeyDeviceList.md)
 - [AwsIamCredentials](docs/AwsIamCredentials.md)
 - [AwsKeyCredentials](docs/AwsKeyCredentials.md)
 - [AzureCredentials](docs/AzureCredentials.md)
 - [Banner](docs/Banner.md)
 - [Bfd](docs/Bfd.md)
 - [BfdTimerOnTransportTunnels](docs/BfdTimerOnTransportTunnels.md)
 - [BizInternetTimer](docs/BizInternetTimer.md)
 - [Cellular](docs/Cellular.md)
 - [CellularAllOf](docs/CellularAllOf.md)
 - [CellularProfile](docs/CellularProfile.md)
 - [CertificateStates](docs/CertificateStates.md)
 - [CertificateValidity](docs/CertificateValidity.md)
 - [ChannelPowerSettings](docs/ChannelPowerSettings.md)
 - [ConfigGroup](docs/ConfigGroup.md)
 - [ConnectToNtpServer](docs/ConnectToNtpServer.md)
 - [ControlStatus](docs/ControlStatus.md)
 - [CorporateWifi](docs/CorporateWifi.md)
 - [CountryRegionSettings](docs/CountryRegionSettings.md)
 - [CreateDeviceParams](docs/CreateDeviceParams.md)
 - [CreateTenantModel](docs/CreateTenantModel.md)
 - [DHCPPool](docs/DHCPPool.md)
 - [DataCenter](docs/DataCenter.md)
 - [DataCenterRegistration](docs/DataCenterRegistration.md)
 - [DeleteTenantBulkModel](docs/DeleteTenantBulkModel.md)
 - [DeleteTenantModel](docs/DeleteTenantModel.md)
 - [Device](docs/Device.md)
 - [DeviceHealthDetails](docs/DeviceHealthDetails.md)
 - [DeviceIP](docs/DeviceIP.md)
 - [DeviceModel](docs/DeviceModel.md)
 - [DeviceType](docs/DeviceType.md)
 - [DeviceUuid](docs/DeviceUuid.md)
 - [DevicesHealth](docs/DevicesHealth.md)
 - [DevicesHealthOverview](docs/DevicesHealthOverview.md)
 - [DisasterRecoverySettings](docs/DisasterRecoverySettings.md)
 - [DomainDetail](docs/DomainDetail.md)
 - [EntityOwnershipInfo](docs/EntityOwnershipInfo.md)
 - [EquinixCredentials](docs/EquinixCredentials.md)
 - [EquinixLocationInfo](docs/EquinixLocationInfo.md)
 - [EquinixNEInfo](docs/EquinixNEInfo.md)
 - [EquinixPartnerPort](docs/EquinixPartnerPort.md)
 - [Ethernet](docs/Ethernet.md)
 - [EthernetAllOf](docs/EthernetAllOf.md)
 - [EthernetInterface](docs/EthernetInterface.md)
 - [EventName](docs/EventName.md)
 - [FeatureProfile](docs/FeatureProfile.md)
 - [GcpCredentials](docs/GcpCredentials.md)
 - [GetO365PreferredPathFromVAnalyticsRequest](docs/GetO365PreferredPathFromVAnalyticsRequest.md)
 - [GetO365PreferredPathFromVAnalyticsRequestValue](docs/GetO365PreferredPathFromVAnalyticsRequestValue.md)
 - [GlobalSettings](docs/GlobalSettings.md)
 - [GlobalSettingsAllOf](docs/GlobalSettingsAllOf.md)
 - [GroupId](docs/GroupId.md)
 - [GuestWifi](docs/GuestWifi.md)
 - [Header](docs/Header.md)
 - [HeaderElement](docs/HeaderElement.md)
 - [Host](docs/Host.md)
 - [IkePhase](docs/IkePhase.md)
 - [IpSecPolicy](docs/IpSecPolicy.md)
 - [IpSecSecurity](docs/IpSecSecurity.md)
 - [LoggingSystemMessages](docs/LoggingSystemMessages.md)
 - [LoginAccessToRouter](docs/LoginAccessToRouter.md)
 - [LteTimer](docs/LteTimer.md)
 - [MegaportCredentials](docs/MegaportCredentials.md)
 - [MegaportLocationInfo](docs/MegaportLocationInfo.md)
 - [MegaportMVEInfo](docs/MegaportMVEInfo.md)
 - [MegaportPartnerPort](docs/MegaportPartnerPort.md)
 - [MplsTimer](docs/MplsTimer.md)
 - [MultiCloudAccountInfo](docs/MultiCloudAccountInfo.md)
 - [MultiCloudEdgeAccountInfo](docs/MultiCloudEdgeAccountInfo.md)
 - [MultiCloudEdgeBillingAccountInfo](docs/MultiCloudEdgeBillingAccountInfo.md)
 - [MultiCloudEdgeLocationInfo](docs/MultiCloudEdgeLocationInfo.md)
 - [MultiCloudEdgePartnerPort](docs/MultiCloudEdgePartnerPort.md)
 - [NATRule](docs/NATRule.md)
 - [NameValuePair](docs/NameValuePair.md)
 - [NetworkProtocol](docs/NetworkProtocol.md)
 - [NetworkProtocolAllOf](docs/NetworkProtocolAllOf.md)
 - [Node](docs/Node.md)
 - [NwpiDomainMonitor](docs/NwpiDomainMonitor.md)
 - [OMP](docs/OMP.md)
 - [OnDemandQueueEntry](docs/OnDemandQueueEntry.md)
 - [PartnerType](docs/PartnerType.md)
 - [PolicyRule](docs/PolicyRule.md)
 - [ProfileParcel](docs/ProfileParcel.md)
 - [PropertyDefinition](docs/PropertyDefinition.md)
 - [PublicInternetTimer](docs/PublicInternetTimer.md)
 - [QueueEntries](docs/QueueEntries.md)
 - [QueueProperties](docs/QueueProperties.md)
 - [RadioBandSetting24G](docs/RadioBandSetting24G.md)
 - [RadioBandSetting5G](docs/RadioBandSetting5G.md)
 - [RadiusServer](docs/RadiusServer.md)
 - [ResourceGroup](docs/ResourceGroup.md)
 - [SSIDConfig](docs/SSIDConfig.md)
 - [SchemaDefinition](docs/SchemaDefinition.md)
 - [SecurityPolicy](docs/SecurityPolicy.md)
 - [SecurityPolicyAllOf](docs/SecurityPolicyAllOf.md)
 - [SimSlotConfig](docs/SimSlotConfig.md)
 - [SiteHealth](docs/SiteHealth.md)
 - [SiteToSiteVpn](docs/SiteToSiteVpn.md)
 - [SmartAccountModel](docs/SmartAccountModel.md)
 - [StatisticsProcessingCounters](docs/StatisticsProcessingCounters.md)
 - [StatsTypeProcessingCounters](docs/StatsTypeProcessingCounters.md)
 - [Systems](docs/Systems.md)
 - [TagRestfulResource](docs/TagRestfulResource.md)
 - [TagRestfulResourceAllGroups](docs/TagRestfulResourceAllGroups.md)
 - [TenantStatus](docs/TenantStatus.md)
 - [TenantStatusListModel](docs/TenantStatusListModel.md)
 - [ThreadPoolDefinition](docs/ThreadPoolDefinition.md)
 - [ThreadPoolsDefinition](docs/ThreadPoolsDefinition.md)
 - [UpdateTenantModel](docs/UpdateTenantModel.md)
 - [Uuid](docs/Uuid.md)
 - [UuidToDomainId](docs/UuidToDomainId.md)
 - [UuidToDomainIdMapping](docs/UuidToDomainIdMapping.md)
 - [VEdgeBootstrapConfig](docs/VEdgeBootstrapConfig.md)
 - [VEdgeHealth](docs/VEdgeHealth.md)
 - [VPNID](docs/VPNID.md)
 - [VResourceGroupNameModel](docs/VResourceGroupNameModel.md)
 - [VSmartStatus](docs/VSmartStatus.md)
 - [Variable](docs/Variable.md)
 - [VertexDefinition](docs/VertexDefinition.md)
 - [Vpn](docs/Vpn.md)
 - [VpnAllOf](docs/VpnAllOf.md)
 - [WanSpec](docs/WanSpec.md)
 - [Wifi](docs/Wifi.md)
 - [WifiAllOf](docs/WifiAllOf.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author

vmanage@cisco.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in openapi_client.apis and openapi_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from openapi_client.api.default_api import DefaultApi`
- `from openapi_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import openapi_client
from openapi_client.apis import *
from openapi_client.models import *
```

