"""
The tool to check the availability or syntax of domain, IP or URL.

::


    ██████╗ ██╗   ██╗███████╗██╗   ██╗███╗   ██╗ ██████╗███████╗██████╗ ██╗     ███████╗
    ██╔══██╗╚██╗ ██╔╝██╔════╝██║   ██║████╗  ██║██╔════╝██╔════╝██╔══██╗██║     ██╔════╝
    ██████╔╝ ╚████╔╝ █████╗  ██║   ██║██╔██╗ ██║██║     █████╗  ██████╔╝██║     █████╗
    ██╔═══╝   ╚██╔╝  ██╔══╝  ██║   ██║██║╚██╗██║██║     ██╔══╝  ██╔══██╗██║     ██╔══╝
    ██║        ██║   ██║     ╚██████╔╝██║ ╚████║╚██████╗███████╗██████╔╝███████╗███████╗
    ╚═╝        ╚═╝   ╚═╝      ╚═════╝ ╚═╝  ╚═══╝ ╚═════╝╚══════╝╚═════╝ ╚══════╝╚══════╝

Provides the IPv4 reputation lookup interface.

Author:
    Nissar Chababy, @funilrys, contactTATAfunilrysTODTODcom

Special thanks:
    https://pyfunceble.github.io/special-thanks.html

Contributors:
    https://pyfunceble.github.io/contributors.html

Project link:
    https://github.com/funilrys/PyFunceble

Project documentation:
    https://pyfunceble.readthedocs.io/en/master/

Project homepage:
    https://pyfunceble.github.io/

License:
::


    Copyright 2017, 2018, 2019, 2020 Nissar Chababy

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

import PyFunceble


class IPv4Reputation:
    """
    Let us checks a given IPv4 against the IPv4 reputation file.
    """

    def __init__(self):
        self.input_file = (
            PyFunceble.CONFIG_DIRECTORY
            + PyFunceble.abstracts.Infrastructure.IPV4_REPUTATION_FILENAME
        )

        if not PyFunceble.helpers.File(self.input_file).exists():
            PyFunceble.downloader.IPv4Reputation()

    def __is_present(self, subject):
        """
        Checks the given subject against the input file.
        """

        if PyFunceble.Check(subject).is_ipv4():
            with open(self.input_file, "r", encoding="utf-8") as file_stream:
                for line in file_stream:
                    if not line.startswith(subject):
                        continue

                    return True
        else:
            subjects = PyFunceble.DNSLOOKUP.a_record(subject)

            return any([self.__is_present(x) for x in subjects])

        return False

    def __contains__(self, subject):
        return self.__is_present(subject)
