# coding :utf-8
#
# The MIT License (MIT)
#
# Copyright (c) 2016-2019 XuHaiJiang/QFF
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
为实现get_index_stocks函数查询指数的成分股票代码，构建index_stock数据表，
目前仅支持['000016','000852','000905','000906','000300','000010','000688']等指数
1、在聚宽平台运行_get_index_stocks函数生成ind_stocks.csv,将csv文件保存至数据库
2、每日从中证指数官网下载每个指数样本列表文件，更新数据库数据
"""
import pandas as pd
import pymongo
from qff.tools.config import DATABASE
from qff.tools.date import get_pre_trade_day
from qff.tools.utils import util_to_json_from_pandas


def save_csv_to_db():
    df = pd.read_csv('ind_stocks.csv', index_col=0)
    df['code'] = df['code'].apply(lambda x: x[:6])
    df['index'] = df['index'].apply(lambda x: x[:6])
    coll = DATABASE.index_stock
    coll.create_index(
        [("index",
          pymongo.ASCENDING),
         ("code",
          pymongo.ASCENDING)]
    )
    DATABASE.index_stock.insert_many(util_to_json_from_pandas(df))


index_url = "https://csi-web-dev.oss-cn-shanghai-finance-1-pub.aliyuncs.com/static/html/csindex/public/uploads/file/autofile/cons/{}cons.xls"


def save_index_stock():
    indexs = ['000016', '000852', '000905', '000906', '000300', '000010', '000688']
    for index in indexs:
        try:
            url = index_url.format(index)
            data0 = pd.read_excel(url)
            # 从中证指数官网读取指数成分股票代码
            s1 = [str(x).zfill(6) for x in data0.iloc[:, 4].tolist()]
            # 读取当前日期
            date = str(data0.iloc[0, 0])
            date = date[:4]+'-'+date[4:6]+'-'+date[6:]

            # 从数据库中读取指数对应的成分股票
            coll = DATABASE.index_stock
            cursor = coll.find(
                {"index": index, "end": "2200-01-01"},
                {"_id": 0},
            )
            data = pd.DataFrame([item for item in cursor])
            s2 = data['code'].tolist()

            a = [x for x in s1 if x not in s2]  # 新增加的股票代码
            if len(a) > 0:
                new = pd.DataFrame({
                    'code': a,
                    'start': date,
                    'end': '2200-01-01',
                    'index': index
                })
                coll.insert_many(util_to_json_from_pandas(new))

            b = [x for x in s2 if x not in s1]  # 取消掉的股票代码
            if len(b) > 0:
                ind = data[data['code'].isin(b)].index
                df = data.loc[ind].copy()
                df['end'] = get_pre_trade_day(date)
                for d in util_to_json_from_pandas(df):
                    coll.update_one({
                        'code': d['code'],
                        'index': index,
                        'end': '2200-01-01'
                    }, {'$set': d}, upsert=True)
        except Exception as e:
            print('{}指数更新出错:{}'.format(index, e))

