/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.AlterDatabaseFinalStep;
import org.jooq.AlterDatabaseStep;
import org.jooq.Catalog;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractRowCountQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class AlterDatabaseImpl
extends AbstractRowCountQuery
implements AlterDatabaseStep,
AlterDatabaseFinalStep {
    private static final long serialVersionUID = 1L;
    private final Catalog database;
    private final boolean alterDatabaseIfExists;
    private Catalog renameTo;
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.POSTGRES);

    AlterDatabaseImpl(Configuration configuration, Catalog database, boolean alterDatabaseIfExists) {
        this(configuration, database, alterDatabaseIfExists, null);
    }

    AlterDatabaseImpl(Configuration configuration, Catalog database, boolean alterDatabaseIfExists, Catalog renameTo) {
        super(configuration);
        this.database = database;
        this.alterDatabaseIfExists = alterDatabaseIfExists;
        this.renameTo = renameTo;
    }

    final Catalog $database() {
        return this.database;
    }

    final boolean $alterDatabaseIfExists() {
        return this.alterDatabaseIfExists;
    }

    final Catalog $renameTo() {
        return this.renameTo;
    }

    @Override
    public final AlterDatabaseImpl renameTo(String renameTo) {
        return this.renameTo(DSL.catalog(DSL.name(renameTo)));
    }

    @Override
    public final AlterDatabaseImpl renameTo(Name renameTo) {
        return this.renameTo(DSL.catalog(renameTo));
    }

    @Override
    public final AlterDatabaseImpl renameTo(Catalog renameTo) {
        this.renameTo = renameTo;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.alterDatabaseIfExists && !this.supportsIfExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.ALTER_DATABASE);
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.ALTER_DATABASE);
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        boolean supportRename = false;
        if (supportRename) {
            ctx.visit(Keywords.K_RENAME);
        } else {
            ctx.visit(Keywords.K_ALTER);
        }
        ctx.sql(' ').visit(Keywords.K_DATABASE);
        if (this.alterDatabaseIfExists && this.supportsIfExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
        }
        ctx.sql(' ').visit(this.database);
        if (this.renameTo != null) {
            boolean qualify = ctx.qualify();
            ctx.sql(' ').qualify(false).visit(supportRename ? Keywords.K_TO : Keywords.K_RENAME_TO).sql(' ').visit(this.renameTo).qualify(qualify);
        }
    }
}

