/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner.impl;

import java.util.Optional;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiomShortCut;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class SatisfiabilityReducer
implements OWLAxiomVisitorEx<Optional<OWLClassExpression>> {
    private final OWLDataFactory df;

    public SatisfiabilityReducer(OWLDataFactory dataFactory) {
        this.df = OWLAPIPreconditions.checkNotNull(dataFactory, "dataFactory cannot be null");
    }

    @Override
    public Optional<OWLClassExpression> doDefault(Object o) {
        if (o instanceof OWLSubClassOfAxiomShortCut) {
            return ((OWLSubClassOfAxiomShortCut)o).asOWLSubClassOfAxiom().accept(this);
        }
        return OWLAPIPreconditions.emptyOptional();
    }

    @Override
    public Optional<OWLClassExpression> visit(OWLSubClassOfAxiom axiom) {
        return Optional.of(this.df.getOWLObjectIntersectionOf(axiom.getSubClass(), this.df.getOWLObjectComplementOf(axiom.getSuperClass())));
    }
}

