/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import javax.annotation.Nullable;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.ImportsStructureEntitySorter;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class ShortForm2AnnotationGenerator
extends AbstractCompositeOntologyChange {
    public ShortForm2AnnotationGenerator(OWLDataFactory df, OWLOntologyManager ontologyManager, OWLOntology ontology, ShortFormProvider shortFormProvider, IRI annotationIRI, @Nullable String languageTag) {
        super(df);
        ShortForm2AnnotationGenerator.generateChanges(OWLAPIPreconditions.checkNotNull(ontologyManager, "ontologyManager cannot be null"), OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null"), OWLAPIPreconditions.checkNotNull(shortFormProvider, "shortFormProvider cannot be null"), OWLAPIPreconditions.checkNotNull(annotationIRI, "annotationIRI cannot be null"), languageTag);
    }

    public ShortForm2AnnotationGenerator(OWLDataFactory df, OWLOntologyManager ontologyManager, OWLOntology ontology, ShortFormProvider shortFormProvider, IRI annotationIRI) {
        this(df, ontologyManager, ontology, shortFormProvider, annotationIRI, null);
    }

    private static void generateChanges(OWLOntologyManager ontologyManager, OWLOntology o, ShortFormProvider provider, IRI annotationIRI, @Nullable String lang) {
        OWLDataFactory df = ontologyManager.getOWLDataFactory();
        OWLAnnotationProperty ap = df.getOWLAnnotationProperty(annotationIRI);
        new ImportsStructureEntitySorter(o).getObjects().forEach((ont, ent) -> ent.forEach(e -> {
            if (o.containsEntityInSignature((OWLEntity)e)) {
                ont.add(df.getOWLAnnotationAssertionAxiom(ap, e.getIRI(), ShortForm2AnnotationGenerator.action(e, lang, provider, df)));
            }
        }));
    }

    private static OWLLiteral action(OWLEntity e, @Nullable String lang, ShortFormProvider provider, OWLDataFactory df) {
        if (lang != null) {
            return df.getOWLLiteral(provider.getShortForm(e), lang);
        }
        return df.getOWLLiteral(provider.getShortForm(e));
    }
}

