/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo12.parser;

import java.util.HashMap;
import java.util.Map;
import org.coode.owlapi.obo12.parser.OBOPrefix;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

class IDSpaceManager {
    private final Map<String, String> idPrefix2IRIPrefixMap = new HashMap<String, String>();

    public IDSpaceManager() {
    }

    public IDSpaceManager(IDSpaceManager idSpaceManager) {
        OWLAPIPreconditions.checkNotNull(idSpaceManager, "idSpaceManager must not be null");
        this.idPrefix2IRIPrefixMap.putAll(idSpaceManager.idPrefix2IRIPrefixMap);
    }

    public String getDefaultIRIPrefix() {
        return OBOPrefix.OBO.getPrefix();
    }

    public String getIRIPrefix(String idPrefix) {
        String iriPrefix = this.idPrefix2IRIPrefixMap.get(idPrefix);
        if (iriPrefix != null) {
            return iriPrefix;
        }
        return this.getDefaultIRIPrefix();
    }

    public void setIRIPrefix(String idPrefix, String iriPrefix) {
        OWLAPIPreconditions.checkNotNull(idPrefix, "idPrefix must not be null");
        OWLAPIPreconditions.checkNotNull(iriPrefix, "iriPrefix must not be null");
        this.idPrefix2IRIPrefixMap.put(idPrefix, iriPrefix);
    }
}

