/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.httpd;

import com.bigdata.util.CaseInsensitiveStringComparator;
import com.bigdata.util.httpd.HTTPHeaderUtility;
import com.bigdata.util.httpd.NVPair;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;

public class MIMEType {
    protected static final Logger log = Logger.getLogger(MIMEType.class);
    String m_type;
    String m_subtype;
    NVPair[] m_params = EMPTY;
    static final NVPair[] EMPTY = new NVPair[0];
    protected static Pattern m_p1 = null;
    protected static Pattern m_p2 = null;

    protected static void init() {
        try {
            String tok = "[^\\p{Cntrl}\\(\\)<>@,;:\\\\\\\"/\\[\\]\\?=\\{\\}\\s\\x09]+";
            String qs = "\\\"(?:\\\\\"|[^\\p{Cntrl}\\\"])*\\\"";
            if (m_p1 != null && m_p2 != null) {
                return;
            }
            m_p1 = Pattern.compile("^(" + tok + ")/(" + tok + ")(.*)$");
            m_p2 = Pattern.compile("\\s*;\\s*(" + tok + ")=(" + tok + "|" + qs + ")\\s*");
        }
        catch (PatternSyntaxException ex) {
            AssertionError err = new AssertionError((Object)"Could not compile regex patterns.");
            ((Throwable)((Object)err)).initCause(ex);
            throw err;
        }
    }

    public String[] getDefaultParamNames() {
        return new String[0];
    }

    public boolean isIgnoredParam(String name) {
        return false;
    }

    public MIMEType(MIMEType mt) {
        this(mt.toString());
    }

    public MIMEType(String type, String subtype) {
        this(type, subtype, EMPTY);
    }

    public MIMEType(String type, String subtype, NVPair[] params) throws IllegalArgumentException {
        MIMEType.init();
        this.m_type = type;
        this.m_subtype = subtype;
        this.m_params = params;
        if (!HTTPHeaderUtility.isHttpToken(type)) {
            throw new IllegalArgumentException("MIME type is not an HTTP token : '" + type + "'");
        }
        if (!HTTPHeaderUtility.isHttpToken(subtype)) {
            throw new IllegalArgumentException("MIME subtype is not an HTTP token : '" + subtype + "'");
        }
        if (params == null) {
            throw new IllegalArgumentException("params may not be null.");
        }
        for (int i = 0; i < params.length; ++i) {
            String attribute = params[i].getName();
            String value = params[i].getValue();
            if (HTTPHeaderUtility.isHttpToken(attribute)) continue;
            throw new IllegalArgumentException("MIME attribute is not an HTTP token : '" + attribute + "'");
        }
    }

    public MIMEType(String s) throws IllegalArgumentException {
        MIMEType.init();
        log.debug((Object)("Parsing: '" + s + "'"));
        Matcher m1 = m_p1.matcher(s);
        if (!m1.matches()) {
            throw new IllegalArgumentException("Can not parse '" + s + "' as a MIME string.");
        }
        this.m_type = m1.group(1);
        log.debug((Object)("type = '" + this.m_type + "'"));
        this.m_subtype = m1.group(2);
        log.debug((Object)("subtype = '" + this.m_subtype + "'"));
        if (this.m_type.equals("*") && !this.m_subtype.equals("*")) {
            throw new IllegalArgumentException("The mime type wildcard is '*/*', not " + this.m_type + "/" + this.m_subtype);
        }
        String parameters = m1.group(3);
        log.debug((Object)("parameters = '" + parameters + "'"));
        if (parameters.length() == 0) {
            this.m_params = EMPTY;
            return;
        }
        Vector<NVPair> v = new Vector<NVPair>();
        Matcher m2 = m_p2.matcher(parameters);
        int nextStart = 0;
        log.debug((Object)("input length = " + parameters.length()));
        while (m2.find()) {
            log.debug((Object)("nextStart = " + nextStart + "\n" + "    start = " + m2.start() + "\n" + "      end = " + m2.end() + "\n" + "    match = '" + m2.group(0) + "'\n" + "attribute = '" + m2.group(1) + "'\n" + "    value = '" + m2.group(2) + "'\n"));
            if (m2.start() != nextStart) {
                throw new AssertionError((Object)("Pattern matches are not contiguous, data='" + s + "'" + ", position=" + nextStart));
            }
            nextStart = m2.end();
            String attribute = m2.group(1);
            String value = m2.group(2);
            value = HTTPHeaderUtility.unquoteString(value);
            log.debug((Object)("parameter : " + attribute + "=" + value));
            v.add(new NVPair(attribute, value));
        }
        if (nextStart != parameters.length()) {
            throw new IllegalArgumentException("Pattern did not completely absorb input, data='" + s + "'" + ", nextStart=" + nextStart + ", inputLength=" + parameters.length());
        }
        this.m_params = v.toArray(EMPTY);
    }

    public String getType() {
        return this.m_type;
    }

    public String getSubtype() {
        return this.m_subtype;
    }

    public boolean isTypeWildcard() {
        return this.getType().equals("*");
    }

    public boolean isWildcard() {
        return this.isSubtypeWildcard();
    }

    public boolean isSubtypeWildcard() {
        return this.getSubtype().equals("*");
    }

    public String getMimeType() {
        return this.getType() + "/" + this.getSubtype();
    }

    public boolean matches(String mimeType) throws IllegalArgumentException {
        return this.matches(new MIMEType(mimeType), false);
    }

    public boolean matches(MIMEType otherMimeType) throws IllegalArgumentException {
        return this.matches(otherMimeType, false);
    }

    public boolean isExactMatch(MIMEType otherType) {
        return this.isExactMatch(otherType, true);
    }

    public boolean isExactMatch(String otherType) throws IllegalArgumentException {
        return this.isExactMatch(new MIMEType(otherType), true);
    }

    public boolean isExactMatch(MIMEType t, boolean compareParams) {
        if (!this.getType().equalsIgnoreCase(t.getType())) {
            return false;
        }
        if (!this.getSubtype().equalsIgnoreCase(t.getSubtype())) {
            return false;
        }
        if (compareParams) {
            return this.spans(t, true) && t.spans(this, true);
        }
        return true;
    }

    public boolean sameParamValue(String name, String realValue, String otherValue) throws IllegalArgumentException {
        if (realValue == null && otherValue != null) {
            return false;
        }
        return realValue.equals(otherValue);
    }

    public String toString(String name, String value) {
        return value;
    }

    public MIMEType getIntersection(MIMEType other, String[] dropParams) {
        boolean dropThisParam;
        String name;
        String subtype;
        String type;
        if (other == null) {
            throw new IllegalArgumentException("The 'other' parameter may not be null.");
        }
        if (dropParams == null) {
            throw new IllegalArgumentException("The 'dropParams' parameter may not be null.");
        }
        if (this.getType().equalsIgnoreCase(other.getType())) {
            type = this.getType();
        } else if (this.isTypeWildcard()) {
            type = other.getType();
        } else if (other.isTypeWildcard()) {
            type = this.getType();
        } else {
            return null;
        }
        if (this.getSubtype().equalsIgnoreCase(other.getSubtype())) {
            subtype = this.getSubtype();
        } else if (this.isSubtypeWildcard()) {
            subtype = other.getSubtype();
        } else if (other.isSubtypeWildcard()) {
            subtype = this.getSubtype();
        } else {
            return null;
        }
        TreeMap<String, NVPair> params = new TreeMap<String, NVPair>((Comparator<String>)new CaseInsensitiveStringComparator());
        for (NVPair param : Arrays.asList(this.getParams())) {
            name = param.getName();
            dropThisParam = false;
            for (int i = 0; i < dropParams.length; ++i) {
                if (!name.equalsIgnoreCase(dropParams[i])) continue;
                dropThisParam = true;
                break;
            }
            if (dropThisParam) continue;
            params.put(name, param);
        }
        for (NVPair param : Arrays.asList(other.getParams())) {
            name = param.getName();
            dropThisParam = false;
            for (int i = 0; i < dropParams.length; ++i) {
                if (!name.equalsIgnoreCase(dropParams[i])) continue;
                dropThisParam = true;
                break;
            }
            if (dropThisParam) continue;
            NVPair existingParam = (NVPair)((Object)params.get(name));
            if (existingParam != null && !this.sameParamValue(name, existingParam.getValue(), param.getValue())) {
                return null;
            }
            params.put(name, param);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(type + "/" + subtype);
        for (Map.Entry entry : params.entrySet()) {
            String name2 = (String)entry.getKey();
            NVPair param = (NVPair)((Object)entry.getValue());
            sb.append(";" + param.getName() + "=" + param.getValue());
        }
        return new MIMEType(sb.toString());
    }

    public boolean spans(String other) {
        return this.spans(other, true);
    }

    public boolean spans(MIMEType other) {
        return this.spans(other, true);
    }

    public boolean spans(String other, boolean compareParams) {
        return this.spans(new MIMEType(other), compareParams);
    }

    public boolean spans(MIMEType other, boolean compareParams) {
        if (this.isTypeWildcard()) {
            return true;
        }
        if (this.getType().equalsIgnoreCase(other.getType()) && (this.getSubtype().equalsIgnoreCase(other.getSubtype()) || this.isSubtypeWildcard())) {
            if (compareParams) {
                NVPair[] params = this.getParams();
                for (int i = 0; i < params.length; ++i) {
                    String otherValue;
                    String value;
                    String name = params[i].getName();
                    if (this.isIgnoredParam(name) || this.sameParamValue(name, value = params[i].getValue(), otherValue = other.getParamValue(name))) continue;
                    return false;
                }
                String[] defaultNames = this.getDefaultParamNames();
                for (int i = 0; i < defaultNames.length; ++i) {
                    String otherValue;
                    String value;
                    String name = defaultNames[i];
                    if (this.isIgnoredParam(name) || this.sameParamValue(name, value = this.getParamValue(name), otherValue = other.getParamValue(name))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean isSpannedBy(String other) {
        return new MIMEType(other).spans(this, true);
    }

    public boolean isSpannedBy(MIMEType other) {
        return other.spans(this, true);
    }

    public boolean isSpannedBy(MIMEType other, boolean compareParams) {
        return other.spans(this, compareParams);
    }

    public boolean matches(MIMEType other, boolean compareParams) {
        return this.spans(other, false);
    }

    public boolean equals(Object o) {
        MIMEType t = null;
        if (o instanceof String) {
            t = new MIMEType((String)o);
        } else if (o instanceof MIMEType) {
            t = (MIMEType)o;
        } else {
            throw new IllegalArgumentException("Can't compare " + o.getClass());
        }
        return this.isExactMatch(t, true);
    }

    public NVPair[] getParams() {
        return this.m_params;
    }

    public NVPair getParam(int i) {
        return this.m_params[i];
    }

    public int getParamCount() {
        return this.m_params.length;
    }

    public String getParamValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name may not be null.");
        }
        NVPair[] params = this.getParams();
        for (int i = 0; i < params.length; ++i) {
            String attribute = params[i].getName();
            if (!name.equalsIgnoreCase(attribute)) continue;
            return params[i].getValue();
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getMimeType());
        NVPair[] params = this.getParams();
        for (int i = 0; i < params.length; ++i) {
            String attribute = params[i].getName();
            String value = HTTPHeaderUtility.quoteString(params[i].getValue(), false);
            sb.append("; " + attribute + "=" + value);
        }
        return sb.toString();
    }
}

