/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.striterator;

import com.bigdata.striterator.Appender;
import com.bigdata.striterator.Filter;
import com.bigdata.striterator.IFilter;
import com.bigdata.striterator.IStriterator;
import cutthecrap.utils.striterators.ICloseable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;

public class Striterator<I extends Iterator<E>, E>
implements IStriterator<I, E> {
    protected final I realSource;
    protected I src;

    public Striterator(I src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.src = src;
        this.realSource = this.src;
    }

    public Striterator(final Enumeration<E> srcEnum) {
        this(new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return srcEnum.hasMoreElements();
            }

            @Override
            public E next() {
                return srcEnum.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }

    @Override
    public IStriterator<I, E> addFilter(IFilter<I, ?, E> filter) {
        this.src = filter.filter(this.src);
        return this;
    }

    @Override
    public IStriterator<I, E> addInstanceOfFilter(final Class<E> cls) {
        return this.addFilter(new Filter<I, E>(cls){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean isValid(E e) {
                return cls.isInstance(e);
            }
        });
    }

    @Override
    public IStriterator<I, E> append(I src) {
        return this.addFilter(new Appender(src));
    }

    public IStriterator<I, E> exclude(Set<E> set) {
        throw new UnsupportedOperationException();
    }

    public IStriterator<I, E> makeUnique() {
        throw new UnsupportedOperationException();
    }

    public IStriterator<I, E> map(Object client, Method method) {
        throw new UnsupportedOperationException();
    }

    public final void close() {
        if (this.src instanceof ICloseable) {
            ((ICloseable)this.src).close();
        }
    }

    @Override
    public final boolean hasMoreElements() {
        return this.src.hasNext();
    }

    @Override
    public final E nextElement() {
        return this.src.next();
    }

    public final boolean hasNext() {
        return this.src.hasNext();
    }

    public final E next() {
        return this.src.next();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

