/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.striterator;

import com.bigdata.relation.accesspath.IElementFilter;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import cutthecrap.utils.striterators.Filter;
import cutthecrap.utils.striterators.ICloseableIterator;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.Striterator;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class ChunkedWrappedIterator<E>
implements IChunkedOrderedIterator<E> {
    private static final transient Logger log = Logger.getLogger(ChunkedWrappedIterator.class);
    private volatile boolean open = true;
    private final Class<? extends E> elementClass;
    private final Iterator<E> realSource;
    private final Iterator<E> src;
    private final int chunkSize;
    private final IKeyOrder<E> keyOrder;
    private long nchunks = 0L;
    private long nelements = 0L;

    public ChunkedWrappedIterator(Iterator<E> src) {
        this(src, 100);
    }

    public ChunkedWrappedIterator(Iterator<E> src, int chunkSize) {
        this(src, chunkSize, null);
    }

    public ChunkedWrappedIterator(Iterator<E> src, int chunkSize, Class<? extends E> elementClass) {
        this(src, chunkSize, elementClass, null, null);
    }

    public ChunkedWrappedIterator(Iterator<E> src, int chunkSize, IKeyOrder<E> keyOrder, IElementFilter<E> filter) {
        this(src, chunkSize, null, keyOrder, filter);
    }

    public ChunkedWrappedIterator(Iterator<E> src, int chunkSize, Class<? extends E> elementClass, IKeyOrder<E> keyOrder, final IElementFilter<E> filter) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        if (chunkSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.elementClass = elementClass;
        this.realSource = src;
        this.src = filter == null ? src : new Striterator(src).addFilter((IFilter)new Filter(){
            private static final long serialVersionUID = 1L;

            public boolean isValid(Object arg0) {
                return filter.isValid(arg0);
            }
        });
        this.chunkSize = chunkSize;
        this.keyOrder = keyOrder;
    }

    public void close() {
        if (this.open) {
            this.open = false;
            if (this.realSource instanceof ICloseableIterator) {
                ((ICloseableIterator)this.realSource).close();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("#chunks=" + this.nchunks + ", #elements=" + this.nelements));
            }
        }
    }

    public boolean hasNext() {
        if (this.open && this.src.hasNext()) {
            return true;
        }
        this.close();
        return false;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        E e = this.src.next();
        ++this.nelements;
        return e;
    }

    @Override
    public E[] nextChunk() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int n = 0;
        Object[] chunk = null;
        while (this.open && this.src.hasNext() && n < this.chunkSize) {
            E t = this.src.next();
            if (chunk == null) {
                chunk = (Object[])Array.newInstance(this.elementClass != null ? this.elementClass : t.getClass(), this.chunkSize);
            }
            chunk[n++] = t;
        }
        if (n != this.chunkSize) {
            Object[] tmp = (Object[])Array.newInstance(this.elementClass != null ? this.elementClass : chunk[0].getClass(), n);
            System.arraycopy(chunk, 0, tmp, 0, n);
            chunk = tmp;
        }
        ++this.nchunks;
        this.nelements += (long)n;
        if (log.isDebugEnabled()) {
            log.debug((Object)("#chunks=" + this.nchunks + ", chunkSize=" + chunk.length + ", #elements=" + this.nelements));
        }
        return chunk;
    }

    @Override
    public void remove() {
        this.src.remove();
    }

    @Override
    public IKeyOrder<E> getKeyOrder() {
        return this.keyOrder;
    }

    @Override
    public E[] nextChunk(IKeyOrder<E> keyOrder) {
        if (keyOrder == null) {
            throw new IllegalArgumentException();
        }
        E[] chunk = this.nextChunk();
        if (!keyOrder.equals(this.getKeyOrder())) {
            Arrays.sort(chunk, 0, chunk.length, keyOrder.getComparator());
        }
        return chunk;
    }
}

