/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.proxy;

import com.bigdata.io.IStreamSerializer;
import com.bigdata.relation.accesspath.IAsynchronousIterator;
import com.bigdata.service.proxy.RemoteAsynchronousIterator;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.TimeUnit;

public class RemoteAsynchronousIteratorImpl<E>
implements RemoteAsynchronousIterator<E> {
    private final IAsynchronousIterator<E> itr;
    private final IStreamSerializer<E> serializer;

    public RemoteAsynchronousIteratorImpl(IAsynchronousIterator<E> itr) {
        this(itr, null);
    }

    public RemoteAsynchronousIteratorImpl(IAsynchronousIterator<E> itr, IStreamSerializer<E> serializer) {
        if (itr == null) {
            throw new IllegalArgumentException();
        }
        this.itr = itr;
        this.serializer = serializer;
    }

    @Override
    public void close() throws IOException {
        this.itr.close();
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.itr.hasNext();
    }

    @Override
    public boolean hasNext(long timeout, TimeUnit unit) throws IOException, InterruptedException {
        return this.itr.hasNext(timeout, unit);
    }

    @Override
    public boolean isExhausted() throws IOException {
        return this.itr.isExhausted();
    }

    @Override
    public E next() throws IOException {
        return (E)this.itr.next();
    }

    @Override
    public E next(long timeout, TimeUnit unit) throws IOException, InterruptedException {
        return this.itr.next(timeout, unit);
    }

    @Override
    public void remove() throws IOException {
        this.itr.remove();
    }

    @Override
    public RemoteAsynchronousIterator.RemoteElement<E> nextElement() {
        if (this.serializer == null) {
            throw new UnsupportedOperationException();
        }
        Object e = this.itr.next();
        return new RemoteElementImpl<Object>(e, this.serializer);
    }

    private static class RemoteElementImpl<E>
    implements RemoteAsynchronousIterator.RemoteElement<E>,
    Externalizable {
        private static final long serialVersionUID = -167351084165715123L;
        private transient E e;
        private transient IStreamSerializer<E> ser;
        private static final transient byte VERSION0 = 0;
        private static final transient byte VERSION = 0;

        public RemoteElementImpl() {
        }

        public RemoteElementImpl(E e, IStreamSerializer<E> ser) {
            if (e == null) {
                throw new IllegalArgumentException();
            }
            if (ser == null) {
                throw new IllegalArgumentException();
            }
            this.e = e;
            this.ser = ser;
        }

        @Override
        public E get() {
            return this.e;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            byte version = in.readByte();
            switch (version) {
                case 0: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown version: " + version);
                }
            }
            this.ser = (IStreamSerializer)in.readObject();
            this.e = this.ser.deserialize(in);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(0);
            out.writeObject(this.ser);
            this.ser.serialize(out, this.e);
        }
    }
}

