/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.fts;

import com.bigdata.bop.IBindingSet;
import com.bigdata.service.fts.FTS;
import com.bigdata.service.fts.FulltextSearchHiterator;
import com.bigdata.service.fts.IFulltextSearchHit;
import java.io.Serializable;
import org.eclipse.jetty.client.HttpClient;

public interface IFulltextSearch<A extends IFulltextSearchHit> {
    public FulltextSearchHiterator<A> search(FulltextSearchQuery var1, HttpClient var2);

    public static class FulltextSearchQuery
    implements Serializable {
        private static final long serialVersionUID = -2509557655519603130L;
        final String query;
        final String params;
        final String endpoint;
        final Integer searchTimeout;
        final String searchField;
        final String scoreField;
        final String snippetField;
        final IBindingSet incomingBindings;
        final FTS.SearchResultType searchResultType;

        public FulltextSearchQuery(String query, String params, String endpoint, Integer searchTimeout, String searchField, String scoreField, String snippetField, IBindingSet incomingBindings, FTS.SearchResultType searchResultType) {
            this.query = query;
            this.params = params;
            this.endpoint = endpoint;
            this.searchTimeout = searchTimeout;
            this.searchField = searchField;
            this.scoreField = scoreField;
            this.snippetField = snippetField;
            this.incomingBindings = incomingBindings;
            this.searchResultType = searchResultType;
        }

        public String getQuery() {
            return this.query;
        }

        public String getParams() {
            return this.params;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public Integer getSearchTimeout() {
            return this.searchTimeout;
        }

        public String getSearchField() {
            return this.searchField;
        }

        public String getSnippetField() {
            return this.snippetField;
        }

        public String getScoreField() {
            return this.scoreField;
        }

        public IBindingSet getIncomingBindings() {
            return this.incomingBindings;
        }

        public FTS.SearchResultType getSearchResultType() {
            return this.searchResultType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
            result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
            result = 31 * result + (this.endpoint == null ? 0 : this.endpoint.hashCode());
            result = 31 * result + (this.searchTimeout == null ? 0 : this.searchTimeout.hashCode());
            result = 31 * result + (this.searchResultType == null ? 0 : this.searchResultType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FulltextSearchQuery other = (FulltextSearchQuery)obj;
            if (this.query == null && other.query != null || this.query != null && other.query == null || !this.query.equals(other.query)) {
                return false;
            }
            if (this.params == null && other.params != null || this.params != null && other.params == null || !this.params.equals(other.params)) {
                return false;
            }
            if (this.endpoint == null && other.endpoint != null || this.endpoint != null && other.endpoint == null || !this.endpoint.equals(other.endpoint)) {
                return false;
            }
            if (this.searchTimeout == null && other.searchTimeout != null || this.searchTimeout != null && other.searchTimeout == null || !this.searchTimeout.equals(other.searchTimeout)) {
                return false;
            }
            return !(this.searchResultType == null && other.searchResultType != null || this.searchResultType != null && other.searchResultType == null) && this.searchResultType.equals((Object)other.searchResultType);
        }
    }
}

