/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.btree.BTreeCounters;
import java.util.Comparator;

class Score
implements Comparable<Score> {
    public final String name;
    public final BTreeCounters bTreeCounters;
    public final double rawScore;
    public final double score;
    public int rank = -1;
    public double drank = -1.0;

    public String toString() {
        return "Score{name=" + this.name + ", rawScore=" + this.rawScore + ", score=" + this.score + ", rank=" + this.rank + ", drank=" + this.drank + "}";
    }

    public Score(String name, BTreeCounters bTreeCounters, double totalRawScore) {
        assert (name != null);
        assert (bTreeCounters != null);
        this.name = name;
        this.bTreeCounters = bTreeCounters;
        this.rawScore = bTreeCounters.computeRawWriteScore();
        this.score = BTreeCounters.normalize(this.rawScore, totalRawScore);
    }

    @Override
    public int compareTo(Score arg0) {
        if (this.rawScore < arg0.rawScore) {
            return -1;
        }
        if (this.rawScore > arg0.rawScore) {
            return 1;
        }
        return this.name.compareTo(arg0.name);
    }

    public static class DESC
    implements Comparator<Score> {
        @Override
        public int compare(Score arg0, Score arg1) {
            if (arg1.rawScore < arg0.rawScore) {
                return -1;
            }
            if (arg1.rawScore > arg0.rawScore) {
                return 1;
            }
            return arg0.name.compareTo(arg1.name);
        }
    }

    public static class ASC
    implements Comparator<Score> {
        @Override
        public int compare(Score arg0, Score arg1) {
            if (arg0.rawScore < arg1.rawScore) {
                return -1;
            }
            if (arg0.rawScore > arg1.rawScore) {
                return 1;
            }
            return arg0.name.compareTo(arg1.name);
        }
    }
}

