/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.rdf.sail.sparql.ast.VisitorException;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import java.util.Map;
import org.openrdf.model.Value;

public class BigdataASTContext {
    protected final BigdataValueFactory valueFactory = BigdataValueFactoryImpl.getInstance("");
    protected final Map<Value, BigdataValue> vocab;
    private int constantVarID = 1;

    public BigdataASTContext(Map<Value, BigdataValue> values) {
        this.vocab = values;
    }

    protected VarNode createAnonVar(String varName) {
        VarNode var = new VarNode(varName + this.constantVarID++);
        var.setAnonymous(true);
        return var;
    }

    protected ConstantNode createConstVar(Value value) throws VisitorException {
        BigdataValue v = this.vocab.get(value);
        if (v == null) {
            throw new VisitorException("Undefined vocabulary: " + value);
        }
        return new ConstantNode(v.getIV());
    }

    protected VarNode createSidVar() {
        VarNode var = new VarNode("-sid-" + this.constantVarID++);
        return var;
    }
}

