/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.internal.constraints.XSDBooleanIVValueExpression;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Value;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class RegexBOp
extends XSDBooleanIVValueExpression
implements INeedsMaterialization {
    private static final long serialVersionUID = 1357420268214930143L;
    private static final transient Logger log = Logger.getLogger(RegexBOp.class);

    private static Map<String, Object> anns(IValueExpression<? extends IV> pattern, IValueExpression<? extends IV> flags) {
        block4: {
            try {
                if (pattern instanceof IConstant && (flags == null || flags instanceof IConstant)) {
                    IV farg;
                    IV parg = (IV)((IConstant)pattern).get();
                    IV iV = farg = flags != null ? (IV)((IConstant)flags).get() : null;
                    if (parg.hasValue() && (farg == null || farg.hasValue())) {
                        Object pargVal = parg.getValue();
                        Value fargVal = farg != null ? (Value)farg.getValue() : null;
                        return NV.asMap(new NV(Annotations.PATTERN, RegexBOp.getPattern(pargVal, fargVal)));
                    }
                }
            }
            catch (Exception ex) {
                if (!log.isInfoEnabled()) break block4;
                log.info((Object)("could not create pattern for: " + pattern + ", " + flags));
            }
        }
        return BOp.NOANNS;
    }

    public RegexBOp(IValueExpression<? extends IV> var, IValueExpression<? extends IV> pattern) {
        this(new BOp[]{var, pattern}, RegexBOp.anns(pattern, null));
    }

    public RegexBOp(IValueExpression<? extends IV> var, IValueExpression<? extends IV> pattern, IValueExpression<? extends IV> flags) {
        this(new BOp[]{var, pattern, flags}, RegexBOp.anns(pattern, flags));
    }

    public RegexBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length < 2 || args[0] == null || args[1] == null) {
            throw new IllegalArgumentException();
        }
    }

    public RegexBOp(RegexBOp op) {
        super(op);
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.SOMETIMES;
    }

    @Override
    public boolean accept(IBindingSet bs) {
        IV flags;
        Value var = RegexBOp.asValue(this.getAndCheckBound(0, bs));
        IV pattern = this.getAndCheckBound(1, bs);
        IV iV = flags = this.arity() > 2 ? (IV)this.get(2).get(bs) : null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("regex var: " + var));
            log.debug((Object)("regex pattern: " + pattern));
            log.debug((Object)("regex flags: " + flags));
        }
        return this.accept(var, (Value)pattern.getValue(), flags != null ? (Value)flags.getValue() : null);
    }

    private boolean accept(Value arg, Value parg, Value farg) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("regex var: " + arg));
            log.debug((Object)("regex pattern: " + parg));
            log.debug((Object)("regex flags: " + farg));
        }
        if (QueryEvaluationUtil.isSimpleLiteral((Value)arg)) {
            String text = ((Literal)arg).getLabel();
            try {
                Pattern pattern = (Pattern)this.getProperty(Annotations.PATTERN);
                if (pattern == null) {
                    pattern = RegexBOp.getPattern(parg, farg);
                }
                if (Thread.interrupted()) {
                    throw new RuntimeException(new InterruptedException());
                }
                boolean result = pattern.matcher(text).find();
                return result;
            }
            catch (IllegalArgumentException ex) {
                throw new SparqlTypeErrorException();
            }
        }
        throw new SparqlTypeErrorException();
    }

    private static Pattern getPattern(Value parg, Value farg) throws IllegalArgumentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("regex pattern: " + parg));
            log.debug((Object)("regex flags: " + farg));
        }
        if (QueryEvaluationUtil.isSimpleLiteral((Value)parg) && (farg == null || QueryEvaluationUtil.isSimpleLiteral((Value)farg))) {
            String ptn = ((Literal)parg).getLabel();
            String flags = "";
            if (farg != null) {
                flags = ((Literal)farg).getLabel();
            }
            int f = 0;
            block8: for (char c : flags.toCharArray()) {
                switch (c) {
                    case 's': {
                        f |= 0x20;
                        continue block8;
                    }
                    case 'm': {
                        f |= 8;
                        continue block8;
                    }
                    case 'i': {
                        f |= 2;
                        f |= 0x40;
                        continue block8;
                    }
                    case 'x': {
                        f |= 4;
                        continue block8;
                    }
                    case 'd': {
                        f |= 1;
                        continue block8;
                    }
                    case 'u': {
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            Pattern pattern = Pattern.compile(ptn, f);
            return pattern;
        }
        throw new IllegalArgumentException();
    }

    public static interface Annotations
    extends IVValueExpression.Annotations {
        public static final String PATTERN = RegexBOp.class.getName() + ".pattern";
    }
}

