/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.InlineURIHandler;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.FullyInlineTypedLiteralIV;
import com.bigdata.rdf.internal.impl.literal.IPv4AddrIV;
import com.bigdata.rdf.internal.impl.literal.UUIDLiteralIV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import java.util.UUID;

public class MultipurposeIDHandler
extends InlineURIHandler {
    private final int maxTextLen;

    public MultipurposeIDHandler(String namespace) {
        this(namespace, Integer.MAX_VALUE);
    }

    public MultipurposeIDHandler(String namespace, int maxTextLen) {
        super(namespace);
        this.maxTextLen = maxTextLen;
    }

    @Override
    protected AbstractLiteralIV createInlineIV(String localName) {
        try {
            return new UUIDLiteralIV(UUID.fromString(localName));
        }
        catch (Exception ex) {
            try {
                return new XSDNumericIV(Byte.parseByte(localName));
            }
            catch (Exception ex2) {
                try {
                    return new XSDNumericIV(Short.parseShort(localName));
                }
                catch (Exception ex3) {
                    try {
                        return new XSDNumericIV(Integer.parseInt(localName));
                    }
                    catch (Exception ex4) {
                        try {
                            return new XSDNumericIV(Long.parseLong(localName));
                        }
                        catch (Exception ex5) {
                            try {
                                return new XSDNumericIV(Float.parseFloat(localName));
                            }
                            catch (Exception ex6) {
                                try {
                                    return new XSDNumericIV(Double.parseDouble(localName));
                                }
                                catch (Exception ex7) {
                                    try {
                                        return new IPv4AddrIV(localName);
                                    }
                                    catch (Exception exception) {
                                        if (localName.length() < this.maxTextLen) {
                                            return new FullyInlineTypedLiteralIV(localName);
                                        }
                                        return null;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

