/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ha.msg;

import com.bigdata.ha.msg.IHASendState;
import com.bigdata.io.DataOutputBuffer;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;

public class HASendState
implements IHASendState,
Externalizable {
    private static final long serialVersionUID = 1L;
    private long messageId;
    private UUID originalSenderId;
    private UUID senderId;
    private long token;
    private int replicationFactor;
    private static final long MAGIC = 1402202338075491502L;
    private static final int MAGIC_SIZE = 8;
    private static final transient short VERSION0 = 0;
    private static final transient int VERSION0_LEN = 54;
    private static final transient short currentVersion = 0;
    private static final transient int currentVersionLen = 54;

    public HASendState() {
    }

    public HASendState(long messageId, UUID originalSenderId, UUID senderId, long token, int replicationFactor) {
        if (originalSenderId == null) {
            throw new IllegalArgumentException();
        }
        if (senderId == null) {
            throw new IllegalArgumentException();
        }
        if (replicationFactor <= 0) {
            throw new IllegalArgumentException();
        }
        this.messageId = messageId;
        this.originalSenderId = originalSenderId;
        this.senderId = senderId;
        this.token = token;
        this.replicationFactor = replicationFactor;
    }

    @Override
    public long getMessageId() {
        return this.messageId;
    }

    @Override
    public UUID getOriginalSenderId() {
        return this.originalSenderId;
    }

    @Override
    public UUID getSenderId() {
        return this.senderId;
    }

    @Override
    public long getQuorumToken() {
        return this.token;
    }

    @Override
    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    @Override
    public byte[] getMarker() {
        int len = 62;
        byte[] a = new byte[62];
        DataOutputBuffer dob = new DataOutputBuffer(0, a);
        try {
            dob.writeLong(1402202338075491502L);
            this.writeExternal2(dob);
            dob.flush();
            return a;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return super.toString() + "{messageId=" + this.messageId + ",originalSenderId=" + this.originalSenderId + ",senderId=" + this.senderId + ",token=" + this.token + ",replicationFactor=" + this.replicationFactor + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IHASendState)) {
            return false;
        }
        IHASendState t = (IHASendState)obj;
        return this.messageId == t.getMessageId() && this.originalSenderId.equals(t.getOriginalSenderId()) && this.senderId.equals(t.getSenderId()) && this.token == t.getQuorumToken() && this.replicationFactor == t.getReplicationFactor();
    }

    public int hashCode() {
        return (int)(this.messageId ^ this.messageId >>> 32) + this.senderId.hashCode();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal2(in);
    }

    private void readExternal2(DataInput in) throws IOException {
        short version = in.readShort();
        if (version != 0) {
            throw new RuntimeException("Bad version for serialization");
        }
        this.messageId = in.readLong();
        this.originalSenderId = new UUID(in.readLong(), in.readLong());
        this.senderId = new UUID(in.readLong(), in.readLong());
        this.token = in.readLong();
        this.replicationFactor = in.readInt();
    }

    public static IHASendState decode(byte[] a) throws IOException {
        if (a == null) {
            return null;
        }
        HASendState tmp = new HASendState();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(a));
        long magic = dis.readLong();
        if (magic != 1402202338075491502L) {
            throw new IOException("Bad magic: expected=1402202338075491502, actual=" + magic);
        }
        tmp.readExternal2(dis);
        return tmp;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal2(out);
    }

    private void writeExternal2(DataOutput out) throws IOException {
        out.writeShort(0);
        out.writeLong(this.messageId);
        out.writeLong(this.originalSenderId.getMostSignificantBits());
        out.writeLong(this.originalSenderId.getLeastSignificantBits());
        out.writeLong(this.senderId.getMostSignificantBits());
        out.writeLong(this.senderId.getLeastSignificantBits());
        out.writeLong(this.token);
        out.writeInt(this.replicationFactor);
    }
}

