/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ha;

import com.bigdata.concurrent.FutureTaskMon;
import com.bigdata.ha.HAGlue;
import com.bigdata.ha.QuorumService;
import com.bigdata.quorum.Quorum;
import com.bigdata.quorum.QuorumEvent;
import com.bigdata.quorum.QuorumEventEnum;
import com.bigdata.quorum.QuorumListener;
import com.bigdata.util.StackInfoReport;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

public abstract class FutureTaskInvariantMon<T>
extends FutureTaskMon<T>
implements QuorumListener {
    private static final Logger log = Logger.getLogger(FutureTaskInvariantMon.class);
    private final Quorum<HAGlue, QuorumService<HAGlue>> m_quorum;
    private final long token;
    private final List<QuorumEventInvariant> m_triggers = new CopyOnWriteArrayList<QuorumEventInvariant>();

    public FutureTaskInvariantMon(Callable<T> callable, Quorum<HAGlue, QuorumService<HAGlue>> quorum) {
        super(callable);
        if (quorum == null) {
            throw new IllegalArgumentException();
        }
        this.m_quorum = quorum;
        this.token = quorum.token();
    }

    public FutureTaskInvariantMon(Runnable runnable, T result, Quorum<HAGlue, QuorumService<HAGlue>> quorum) {
        super(runnable, result);
        if (quorum == null) {
            throw new IllegalArgumentException();
        }
        this.m_quorum = quorum;
        this.token = quorum.token();
    }

    protected abstract void establishInvariants();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean didStart = false;
        this.m_quorum.addListener(this);
        try {
            this.establishInvariants();
            didStart = true;
            super.run();
        }
        finally {
            this.m_quorum.removeListener(this);
            if (!didStart) {
                this.cancel(true);
            }
        }
    }

    public void assertMember(UUID serviceId) {
        this.m_triggers.add(new QuorumEventInvariant(QuorumEventEnum.MEMBER_REMOVE, serviceId));
        this.assertMembership(this.m_quorum.getMembers(), serviceId);
    }

    public void assertJoined(UUID serviceId) {
        this.m_triggers.add(new QuorumEventInvariant(QuorumEventEnum.SERVICE_LEAVE, serviceId));
        this.assertMembership(this.m_quorum.getJoined(), serviceId);
    }

    public void assertNotJoined(UUID serviceId) {
        this.m_triggers.add(new QuorumEventInvariant(QuorumEventEnum.SERVICE_JOIN, serviceId));
        if (this.isMember(this.m_quorum.getJoined(), serviceId)) {
            this.broken();
        }
    }

    public void assertInPipeline(UUID serviceId) {
        this.m_triggers.add(new QuorumEventInvariant(QuorumEventEnum.PIPELINE_REMOVE, serviceId));
        this.assertMembership(this.m_quorum.getPipeline(), serviceId);
    }

    public void assertQuorumMet() {
        this.m_triggers.add(new QuorumEventInvariant(QuorumEventEnum.QUORUM_BROKE, null));
        if (!this.m_quorum.isQuorumMet()) {
            this.broken();
        }
        if (this.m_quorum.token() != this.token) {
            this.broken();
        }
    }

    public void assertQuorumFullyMet() {
        this.m_triggers.add(new QuorumEventInvariant(QuorumEventEnum.SERVICE_LEAVE, null));
        if (!this.m_quorum.isQuorumFullyMet(this.m_quorum.token())) {
            this.broken();
        }
    }

    private void assertMembership(UUID[] members, UUID serviceId) {
        if (this.isMember(members, serviceId)) {
            return;
        }
        this.broken();
    }

    private boolean isMember(UUID[] members, UUID serviceId) {
        for (UUID member : members) {
            if (!member.equals(serviceId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void notify(QuorumEvent e) {
        boolean interrupt = false;
        for (QuorumEventInvariant inv : this.m_triggers) {
            if (!inv.matches(e)) continue;
            interrupt = true;
            break;
        }
        if (interrupt) {
            this.broken();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Ignoring event: " + e));
        }
    }

    private void broken() {
        log.warn((Object)"BROKEN", (Throwable)new StackInfoReport());
        this.cancel(true);
    }

    private class QuorumEventInvariant
    implements QuorumEvent,
    Serializable {
        private final QuorumEventEnum m_qe;
        private final UUID m_sid;

        public QuorumEventInvariant(QuorumEventEnum qe, UUID sid) {
            if (qe == null) {
                throw new IllegalArgumentException();
            }
            this.m_qe = qe;
            this.m_sid = sid;
        }

        @Override
        public QuorumEventEnum getEventType() {
            return this.m_qe;
        }

        @Override
        public long lastValidToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long token() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UUID getServiceId() {
            return this.m_sid;
        }

        @Override
        public long lastCommitTime() {
            throw new UnsupportedOperationException();
        }

        public boolean matches(QuorumEvent qe) {
            return qe.getEventType() == this.m_qe && (this.m_sid == null || this.m_sid.equals(qe.getServiceId()));
        }
    }
}

