/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.proc;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedure;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedureConstructor;
import com.bigdata.btree.proc.IParallelizableIndexProcedure;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.service.ndx.NopAggregator;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class BatchInsert
extends AbstractKeyArrayIndexProcedure<AbstractKeyArrayIndexProcedure.ResultBuffer>
implements IParallelizableIndexProcedure<AbstractKeyArrayIndexProcedure.ResultBuffer> {
    private static final long serialVersionUID = 6594362044816120035L;
    private boolean returnOldValues;

    public boolean getReturnOldValues() {
        return this.returnOldValues;
    }

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    public BatchInsert() {
    }

    protected BatchInsert(IRabaCoder keysCoder, IRabaCoder valsCoder, int fromIndex, int toIndex, byte[][] keys, byte[][] vals, boolean returnOldValues) {
        super(keysCoder, valsCoder, fromIndex, toIndex, keys, vals);
        if (vals == null) {
            throw new IllegalArgumentException("values is null");
        }
        this.returnOldValues = returnOldValues;
    }

    @Override
    public AbstractKeyArrayIndexProcedure.ResultBuffer applyOnce(IIndex ndx, IRaba keys, IRaba vals) {
        Object ret;
        int n = keys.size();
        Object object = ret = this.returnOldValues ? new byte[n][] : (Object)null;
        for (int i = 0; i < n; ++i) {
            byte[] key = keys.get(i);
            byte[] val = vals.get(i);
            byte[] old = ndx.insert(key, val);
            if (!this.returnOldValues) continue;
            ret[i] = old;
        }
        if (this.returnOldValues) {
            return new AbstractKeyArrayIndexProcedure.ResultBuffer(n, (byte[][])ret, ndx.getIndexMetadata().getTupleSerializer().getLeafValuesCoder());
        }
        return null;
    }

    @Override
    protected void readMetadata(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readMetadata(in);
        this.returnOldValues = in.readBoolean();
    }

    @Override
    protected void writeMetadata(ObjectOutput out) throws IOException {
        super.writeMetadata(out);
        out.writeBoolean(this.returnOldValues);
    }

    @Override
    protected IResultHandler<AbstractKeyArrayIndexProcedure.ResultBuffer, AbstractKeyArrayIndexProcedure.ResultBuffer> newAggregator() {
        if (!this.getReturnOldValues()) {
            return NopAggregator.INSTANCE;
        }
        return new AbstractKeyArrayIndexProcedure.ResultBufferHandler(this.getKeys().size(), this.getValuesCoder());
    }

    public static class BatchInsertConstructor
    extends AbstractKeyArrayIndexProcedureConstructor<BatchInsert> {
        public static final BatchInsertConstructor RETURN_OLD_VALUES = new BatchInsertConstructor(true);
        public static final BatchInsertConstructor RETURN_NO_VALUES = new BatchInsertConstructor(false);
        private boolean returnOldValues;

        private BatchInsertConstructor(boolean returnOldValues) {
            this.returnOldValues = returnOldValues;
        }

        @Override
        public final boolean sendValues() {
            return true;
        }

        @Override
        public BatchInsert newInstance(IRabaCoder keysCoder, IRabaCoder valsCoder, int fromIndex, int toIndex, byte[][] keys, byte[][] vals) {
            return new BatchInsert(keysCoder, valsCoder, fromIndex, toIndex, keys, vals, this.returnOldValues);
        }
    }
}

