/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.filter;

import com.bigdata.btree.AbstractTuple;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleCursor;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.ITupleSerializer;
import com.bigdata.btree.filter.ITupleFilter;
import cutthecrap.utils.striterators.FilterBase;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LookaheadTupleFilter<E>
extends FilterBase
implements ITupleFilter<E> {
    private static final long serialVersionUID = -5551926378159692251L;

    @Override
    public ILookaheadTupleIterator<E> filterOnce(Iterator src, Object context) {
        if (src instanceof ITupleCursor) {
            return new LookaheadTupleCursor((ITupleCursor)src, context);
        }
        return new LookaheadTupleIterator((ITupleIterator)src, context);
    }

    private static class LookaheadTupleIterator<E>
    implements ILookaheadTupleIterator<E> {
        private final ITupleIterator<E> src;
        private final Object context;
        private boolean pushbackAllowed = false;
        private AbstractTuple<E> tupleBuffer;

        public LookaheadTupleIterator(ITupleIterator<E> src, Object context) {
            this.src = src;
            this.context = context;
        }

        @Override
        public void pushback() {
            if (!this.pushbackAllowed) {
                throw new IllegalStateException();
            }
            this.pushbackAllowed = false;
        }

        @Override
        public ITuple<E> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.pushbackAllowed && this.tupleBuffer != null) {
                this.pushbackAllowed = true;
                return this.tupleBuffer;
            }
            final ITuple<E> tuple = this.src.next();
            if (this.tupleBuffer == null) {
                this.tupleBuffer = new AbstractTuple<E>(tuple.flags()){

                    @Override
                    public int getSourceIndex() {
                        return tuple.getSourceIndex();
                    }

                    @Override
                    public ITupleSerializer getTupleSerializer() {
                        return tuple.getTupleSerializer();
                    }
                };
            }
            this.tupleBuffer.copyTuple(tuple);
            this.pushbackAllowed = true;
            return this.tupleBuffer;
        }

        @Override
        public boolean hasNext() {
            if (!this.pushbackAllowed && this.tupleBuffer != null) {
                return true;
            }
            return this.src.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class LookaheadTupleCursor<E>
    implements ILookaheadTupleIterator<E> {
        private final ITupleCursor<E> src;
        private final Object context;
        private boolean pushbackAllowed = false;

        public LookaheadTupleCursor(ITupleCursor<E> src, Object context) {
            this.src = src;
            this.context = context;
        }

        @Override
        public void pushback() {
            if (!this.pushbackAllowed) {
                throw new IllegalStateException();
            }
            this.src.prior();
            this.pushbackAllowed = false;
        }

        @Override
        public ITuple<E> next() {
            ITuple<E> tuple = this.src.next();
            this.pushbackAllowed = true;
            return tuple;
        }

        @Override
        public boolean hasNext() {
            return this.src.hasNext();
        }

        @Override
        public void remove() {
            this.src.remove();
        }
    }

    public static interface ILookaheadTupleIterator<E>
    extends ITupleIterator<E> {
        public void pushback();
    }
}

