/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.BloomFilter;
import java.io.Serializable;

public class BloomFilterFactory
implements Serializable {
    private static final long serialVersionUID = -7761038651189410149L;
    public final int n;
    public final double p;
    public final double maxP;
    public final int maxN;
    public static final transient int DEFAULT_N = 1000000;
    public static final transient double DEFAULT_ERROR_RATE = 0.02;
    public static final transient double DEFAULT_MAX_ERROR_RATE = 0.15;
    public static final transient BloomFilterFactory DEFAULT = new BloomFilterFactory(1000000, 0.02, 0.15);

    public BloomFilterFactory(int n) {
        this(n, 0.02, 0.15);
    }

    public BloomFilterFactory(int n, double p, double maxP) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        if (p <= 0.0 || p > 1.0) {
            throw new IllegalArgumentException();
        }
        if (maxP <= p || maxP > 1.0) {
            throw new IllegalArgumentException();
        }
        this.n = n;
        this.p = p;
        this.maxP = maxP;
        int k = BloomFilter.getHashFunctionCount(p);
        long m = BloomFilter.getBitLength(k, n);
        this.maxN = BloomFilter.getEntryCountForErrorRate(k, m, maxP);
    }

    public BloomFilter newBloomFilter() {
        return new BloomFilter(this.n, this.p, this.maxN);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("{ n=" + this.n);
        sb.append(", p=" + this.p);
        sb.append(", maxP=" + this.maxP);
        sb.append(", maxN=" + this.maxN);
        sb.append("}");
        return sb.toString();
    }
}

