/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.rdf.join;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class VariableUnificationOp
extends PipelineOp {
    private static final long serialVersionUID = 1L;

    public VariableUnificationOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        if (this.getVars().length != 2) {
            throw new IllegalArgumentException();
        }
    }

    public VariableUnificationOp(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    public VariableUnificationOp(VariableUnificationOp op) {
        super(op);
    }

    public IVariable<?> getTargetVar() {
        return this.getVars()[0];
    }

    public IVariable<?> getTmpVar() {
        return this.getVars()[1];
    }

    protected IVariable<?>[] getVars() {
        IVariable[] vars = (IVariable[])this.getProperty(Annotations.VARS);
        assert (vars != null && vars.length == 2);
        return vars;
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new ChunkTask(this, context));
    }

    private static class ChunkTask
    implements Callable<Void> {
        private final BOpContext<IBindingSet> context;
        private final IVariable<?> targetVar;
        private final IVariable<?> tmpVar;

        ChunkTask(VariableUnificationOp op, BOpContext<IBindingSet> context) {
            this.context = context;
            this.targetVar = op.getTargetVar();
            this.tmpVar = op.getTmpVar();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            BOpStats stats = this.context.getStats();
            ICloseableIterator<IBindingSet[]> itr = this.context.getSource();
            try (IBlockingBuffer<IBindingSet[]> sink = this.context.getSink();){
                while (itr.hasNext()) {
                    IBindingSet[] chunk = (IBindingSet[])itr.next();
                    IBindingSet[] unified = new IBindingSet[chunk.length];
                    int nunified = 0;
                    stats.chunksIn.increment();
                    stats.unitsIn.add(chunk.length);
                    for (IBindingSet bs : chunk) {
                        IConstant tmpVal = bs.get(this.tmpVar);
                        IConstant targetVal = bs.get(this.targetVar);
                        IBindingSet bsUnified = null;
                        if (tmpVal != null) {
                            if (targetVal == null) {
                                bsUnified = bs.clone();
                                bsUnified.set(this.targetVar, tmpVal);
                                bsUnified.clear(this.tmpVar);
                            } else if (targetVal.equals(tmpVal)) {
                                bsUnified = bs.clone();
                                bsUnified.clear(this.tmpVar);
                            }
                        } else {
                            bsUnified = bs.clone();
                        }
                        if (bsUnified == null) continue;
                        unified[nunified++] = bsUnified;
                    }
                    if (nunified <= 0) continue;
                    if (nunified == unified.length) {
                        sink.add(unified);
                        continue;
                    }
                    sink.add(Arrays.copyOf(unified, nunified));
                }
                sink.flush();
                Void void_ = null;
                return void_;
            }
        }
    }

    public static interface Annotations
    extends PipelineOp.Annotations {
        public static final String VARS = VariableUnificationOp.class.getName() + ".vars";
    }
}

