/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.fed;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpEvaluationContext;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.engine.ChunkedRunningQuery;
import com.bigdata.bop.engine.IChunkHandler;
import com.bigdata.bop.engine.IChunkMessage;
import com.bigdata.bop.engine.IQueryClient;
import com.bigdata.bop.engine.IQueryPeer;
import com.bigdata.bop.fed.AllocationContextKey;
import com.bigdata.bop.fed.EmptyChunkMessage;
import com.bigdata.bop.fed.FederatedQueryEngine;
import com.bigdata.bop.fed.FederationChunkHandler;
import com.bigdata.io.DirectBufferPoolAllocator;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class FederatedRunningQuery
extends ChunkedRunningQuery {
    private static final transient Logger log = Logger.getLogger(FederatedRunningQuery.class);
    final UUID queryControllerUUID;
    private final IChunkHandler chunkHandler;
    private final ConcurrentHashMap<AllocationContextKey, DirectBufferPoolAllocator.IAllocationContext> allocationContexts = new ConcurrentHashMap();

    @Override
    protected void releaseNativeMemoryForOperator(int bopId) {
        for (Map.Entry<AllocationContextKey, DirectBufferPoolAllocator.IAllocationContext> e : this.allocationContexts.entrySet()) {
            if (!e.getKey().hasOperatorScope(bopId)) continue;
            e.getValue().release();
        }
    }

    @Override
    protected void releaseNativeMemoryForQuery() {
        for (DirectBufferPoolAllocator.IAllocationContext ctx : this.allocationContexts.values()) {
            ctx.release();
        }
        this.allocationContexts.clear();
        super.releaseNativeMemoryForQuery();
    }

    public FederatedRunningQuery(FederatedQueryEngine queryEngine, UUID queryId, boolean controller, IQueryClient clientProxy, UUID queryControllerId, PipelineOp query, IChunkMessage<IBindingSet> realSource) {
        super(queryEngine, queryId, controller, clientProxy, query, realSource);
        if (queryControllerId == null) {
            throw new IllegalArgumentException();
        }
        this.queryControllerUUID = queryControllerId;
        this.chunkHandler = query.getProperty(FederatedQueryEngine.Annotations.CHUNK_HANDLER, FederationChunkHandler.INSTANCE);
        if (!this.getQuery().getEvaluationContext().equals((Object)BOpEvaluationContext.CONTROLLER)) {
            throw new RuntimeException("The top-level of a query must be evaluated on the query controller: query=" + this.getQuery());
        }
    }

    @Override
    public FederatedQueryEngine getQueryEngine() {
        return (FederatedQueryEngine)super.getQueryEngine();
    }

    @Override
    protected boolean acceptChunk(IChunkMessage<IBindingSet> msg) {
        return super.acceptChunk(msg);
    }

    public IQueryPeer getQueryPeer(UUID serviceUUID) {
        if (serviceUUID == null) {
            throw new IllegalArgumentException();
        }
        FederatedQueryEngine queryEngine = this.getQueryEngine();
        IQueryPeer queryPeer = serviceUUID.equals(queryEngine.getServiceUUID()) ? queryEngine : (serviceUUID.equals(this.queryControllerUUID) ? this.getQueryController() : queryEngine.getQueryPeer(serviceUUID));
        return queryPeer;
    }

    public DirectBufferPoolAllocator.IAllocationContext getAllocationContext(AllocationContextKey key) {
        DirectBufferPoolAllocator.IAllocationContext ctx = this.getQueryEngine().getResourceService().getAllocator().getAllocationContext(key);
        DirectBufferPoolAllocator.IAllocationContext ctx2 = this.allocationContexts.putIfAbsent(key, ctx);
        if (ctx2 != null) {
            return ctx2;
        }
        return ctx;
    }

    @Override
    protected boolean cancelQueryOnPeers(Throwable cause, Set<UUID> startedOn) {
        boolean cancelled = super.cancelQueryOnPeers(cause, startedOn);
        UUID queryId = this.getQueryId();
        for (UUID serviceId : startedOn) {
            IQueryPeer peer = this.getQueryPeer(serviceId);
            try {
                peer.cancelQuery(queryId, cause);
            }
            catch (RemoteException e) {
                log.error((Object)("Could not notify: " + peer), (Throwable)e);
            }
            cancelled = true;
        }
        return cancelled;
    }

    @Override
    protected IChunkHandler getChunkHandler() {
        return this.chunkHandler;
    }

    @Override
    protected void doLastPass(int bopId, Set doneOn) {
        BOp op = this.getBOp(bopId);
        switch (op.getEvaluationContext()) {
            case CONTROLLER: {
                super.doLastPass(bopId, doneOn);
                return;
            }
            case ANY: 
            case HASHED: {
                for (UUID serviceId : doneOn) {
                    EmptyChunkMessage<IBindingSet> emptyMessage = new EmptyChunkMessage<IBindingSet>(this.getQueryController(), this.getQueryId(), bopId, -1, true);
                    try {
                        IQueryPeer queryPeer = this.getQueryPeer(serviceId);
                        queryPeer.bufferReady(emptyMessage);
                    }
                    catch (RemoteException e) {
                        throw new RuntimeException("Could not send message: serviceId=" + serviceId + " : " + e, e);
                    }
                }
                return;
            }
            case SHARDED: {
                for (Integer shardId : doneOn) {
                    EmptyChunkMessage<IBindingSet> emptyMessage = new EmptyChunkMessage<IBindingSet>(this.getQueryController(), this.getQueryId(), bopId, shardId, true);
                    this.acceptChunk(emptyMessage);
                }
                return;
            }
        }
        throw new AssertionError();
    }
}

