/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.fed;

import com.bigdata.bop.engine.QueryEngineCounters;
import com.bigdata.counters.CAT;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;

public class FederatedQueryEngineCounters
extends QueryEngineCounters {
    protected final CAT chunksIn = new CAT();
    protected final CAT chunksOut = new CAT();
    protected final CAT solutionsIn = new CAT();
    protected final CAT solutionsOut = new CAT();

    @Override
    public CounterSet getCounters() {
        CounterSet root = super.getCounters();
        root.addCounter("chunksIn", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(FederatedQueryEngineCounters.this.chunksIn.get());
            }
        });
        root.addCounter("chunksOut", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(FederatedQueryEngineCounters.this.chunksOut.get());
            }
        });
        root.addCounter("solutionsIn", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(FederatedQueryEngineCounters.this.solutionsIn.get());
            }
        });
        root.addCounter("solutionsOut", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(FederatedQueryEngineCounters.this.solutionsOut.get());
            }
        });
        root.addCounter("chunksOutPerQuery", new Instrument<Double>(){

            @Override
            public void sample() {
                long nchunks = FederatedQueryEngineCounters.this.chunksOut.get();
                long n = FederatedQueryEngineCounters.this.queryStartCount.get();
                double d = n == 0L ? 0.0 : (double)nchunks / (double)n;
                this.setValue(d);
            }
        });
        root.addCounter("chunksInPerQuery", new Instrument<Double>(){

            @Override
            public void sample() {
                long nchunks = FederatedQueryEngineCounters.this.chunksIn.get();
                long n = FederatedQueryEngineCounters.this.queryStartCount.get();
                double d = n == 0L ? 0.0 : (double)nchunks / (double)n;
                this.setValue(d);
            }
        });
        root.addCounter("solutionsOutPerQuery", new Instrument<Double>(){

            @Override
            public void sample() {
                long nsol = FederatedQueryEngineCounters.this.solutionsOut.get();
                long n = FederatedQueryEngineCounters.this.queryStartCount.get();
                double d = n == 0L ? 0.0 : (double)nsol / (double)n;
                this.setValue(d);
            }
        });
        root.addCounter("solutionsInPerQuery", new Instrument<Double>(){

            @Override
            public void sample() {
                long nsol = FederatedQueryEngineCounters.this.solutionsIn.get();
                long n = FederatedQueryEngineCounters.this.queryStartCount.get();
                double d = n == 0L ? 0.0 : (double)nsol / (double)n;
                this.setValue(d);
            }
        });
        root.addCounter("solutionsOutPerChunk", new Instrument<Double>(){

            @Override
            public void sample() {
                long nsol = FederatedQueryEngineCounters.this.solutionsOut.get();
                long nchunks = FederatedQueryEngineCounters.this.chunksOut.get();
                double d = nchunks == 0L ? 0.0 : (double)nsol / (double)nchunks;
                this.setValue(d);
            }
        });
        root.addCounter("solutionsInPerChunk", new Instrument<Double>(){

            @Override
            public void sample() {
                long nsol = FederatedQueryEngineCounters.this.solutionsIn.get();
                long nchunks = FederatedQueryEngineCounters.this.chunksIn.get();
                double d = nchunks == 0L ? 0.0 : (double)nsol / (double)nchunks;
                this.setValue(d);
            }
        });
        return root;
    }
}

