/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.cost;

import com.bigdata.bop.cost.DiskCostModel;
import java.io.Serializable;

public class IndexSegmentCostModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final DiskCostModel diskCostModel;

    public IndexSegmentCostModel(DiskCostModel diskCostModel) {
        if (diskCostModel == null) {
            throw new IllegalArgumentException();
        }
        this.diskCostModel = diskCostModel;
    }

    public double rangeScan(int rangeCount, int branchingFactor, int averageBytesPerLeaf, int xferBufferSize) {
        if (rangeCount == 0) {
            return 0.0;
        }
        if (xferBufferSize == 0) {
            throw new IllegalArgumentException();
        }
        double averageSeekTime = this.diskCostModel.seekTime;
        int expectedLeafCount = (int)Math.ceil((double)rangeCount / (double)branchingFactor);
        int leafBytesToXFer = expectedLeafCount * averageBytesPerLeaf;
        int xfers = (int)Math.ceil((double)leafBytesToXFer / (double)xferBufferSize);
        double xferTime = (double)leafBytesToXFer / (this.diskCostModel.transferRate / 1000.0);
        double seekTime = averageSeekTime * (double)xfers;
        double totalTime = seekTime + xferTime;
        return totalTime;
    }
}

