/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.AST.AbstractSimplePropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.LanguageInFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageInPropertyShape
extends AbstractSimplePropertyShape {
    private final Set<String> languageIn;
    private static final Logger logger = LoggerFactory.getLogger(LanguageInPropertyShape.class);

    LanguageInPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Resource path, Resource languageIn) {
        super(id, connection, nodeShape, deactivated, parent, path);
        this.languageIn = LanguageInPropertyShape.toList(connection, languageIn).stream().map(Value::stringValue).collect(Collectors.toSet());
    }

    @Override
    public PlanNode getPlan(ConnectionsGroup connectionsGroup, boolean printPlans, PlanNodeProvider overrideTargetNode, boolean negateThisPlan, boolean negateSubPlans) {
        if (this.deactivated) {
            return null;
        }
        assert (!negateSubPlans) : "There are no subplans!";
        PlanNode invalidValues = LanguageInPropertyShape.getGenericSingleObjectPlan(connectionsGroup, this.nodeShape, parent -> new LanguageInFilter(parent, this.languageIn), this, overrideTargetNode, negateThisPlan);
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(invalidValues, connectionsGroup);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(invalidValues, this);
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.LanguageInConstraintComponent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LanguageInPropertyShape that = (LanguageInPropertyShape)o;
        return this.languageIn.equals(that.languageIn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.languageIn);
    }

    public String toString() {
        return "LanguageInPropertyShape{languageIn=" + Arrays.toString(this.languageIn.toArray()) + ", path=" + this.getPath() + '}';
    }
}

