/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl;

import com.bigdata.rdf.graph.EdgesEnum;
import com.bigdata.rdf.graph.IGASContext;
import com.bigdata.rdf.graph.IGASProgram;
import com.bigdata.rdf.graph.IGASScheduler;
import com.bigdata.rdf.graph.IGASState;
import com.bigdata.rdf.graph.IGASStats;
import com.bigdata.rdf.graph.IGraphAccessor;
import com.bigdata.rdf.graph.IReducer;
import com.bigdata.rdf.graph.IStaticFrontier;
import com.bigdata.rdf.graph.TraversalDirectionEnum;
import com.bigdata.rdf.graph.impl.GASEngine;
import com.bigdata.rdf.graph.impl.GASStats;
import com.bigdata.rdf.graph.impl.VertexTaskFactory;
import com.bigdata.rdf.graph.util.GASUtil;
import cutthecrap.utils.striterators.Filter;
import cutthecrap.utils.striterators.IFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class GASContext<VS, ES, ST>
implements IGASContext<VS, ES, ST> {
    private static final Logger log = Logger.getLogger(GASContext.class);
    private final GASEngine gasEngine;
    private final IGraphAccessor graphAccessor;
    private final IGASState<VS, ES, ST> gasState;
    private final IGASProgram<VS, ES, ST> program;
    private final AtomicReference<TraversalDirectionEnum> traversalDirection = new AtomicReference<TraversalDirectionEnum>(TraversalDirectionEnum.Forward);
    private final AtomicInteger maxIterations = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger maxVertices = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicReference<URI> linkType = new AtomicReference<Object>(null);
    private final AtomicReference<URI> linkAttributeType = new AtomicReference<Object>(null);
    private final AtomicReference<IReducer<VS, ES, ST, ?>> afterOp = new AtomicReference<Object>(null);
    private final Set<Value> targetVertices = Collections.synchronizedSet(new LinkedHashSet());
    private final AtomicInteger maxIterationsAfterTargets = new AtomicInteger(Integer.MAX_VALUE);
    private static final Long ONE = 1L;

    public GASContext(GASEngine gasEngine, IGraphAccessor graphAccessor, IGASState<VS, ES, ST> gasState, IGASProgram<VS, ES, ST> gasProgram) {
        if (gasEngine == null) {
            throw new IllegalArgumentException();
        }
        if (graphAccessor == null) {
            throw new IllegalArgumentException();
        }
        if (gasState == null) {
            throw new IllegalArgumentException();
        }
        if (gasProgram == null) {
            throw new IllegalArgumentException();
        }
        this.gasEngine = gasEngine;
        this.graphAccessor = graphAccessor;
        this.program = gasProgram;
        this.gasState = gasState;
    }

    @Override
    public IGASState<VS, ES, ST> getGASState() {
        return this.gasState;
    }

    @Override
    public IGASProgram<VS, ES, ST> getGASProgram() {
        return this.program;
    }

    @Override
    public IGraphAccessor getGraphAccessor() {
        return this.graphAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IGASStats call() throws Exception {
        GASStats total = new GASStats();
        this.program.before(this);
        if (log.isTraceEnabled()) {
            log.trace((Object)("# of targets: " + this.targetVertices.size()));
            log.trace((Object)("max iterations after targets: " + this.maxIterationsAfterTargets.get()));
        }
        while (!this.gasState.frontier().isEmpty()) {
            if (this.targetVertices.size() > 0 && this.getMaxIterationsAfterTargets() < Integer.MAX_VALUE && this.gasState.isVisited(this.targetVertices)) {
                AtomicInteger atomicInteger = this.maxIterations;
                synchronized (atomicInteger) {
                    this.maxIterations.set(Math.min(this.getMaxIterations(), (int)total.getNRounds() + this.getMaxIterationsAfterTargets()));
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("All targets reached at round " + total.getNRounds() + ", halting at round " + this.maxIterations.get()));
                }
            }
            if (total.getNRounds() + 1L > (long)this.getMaxIterations()) {
                log.warn((Object)("Halting: maxIterations=" + this.getMaxIterations() + ", #rounds=" + total.getNRounds()));
                break;
            }
            if (total.getFrontierSize() >= (long)this.getMaxVisited()) {
                log.warn((Object)("Halting: maxVertices=" + this.getMaxVisited() + ", frontierSize=" + total.getFrontierSize()));
                break;
            }
            GASStats roundStats = new GASStats();
            this.doRound(roundStats);
            total.add(roundStats);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Done: " + total));
        }
        this.gasState.traceState();
        IReducer op = this.getRunAfterOp();
        if (op != null) {
            this.gasState.reduce(op);
        }
        return total;
    }

    @Override
    public boolean doRound(IGASStats stats) throws InterruptedException, ExecutionException, Exception {
        boolean nextRound;
        long elapsedApply;
        boolean runApplyStage;
        boolean pushDownApplyInScatter;
        boolean pushDownApplyInGather;
        IStaticFrontier f = this.gasState.frontier();
        this.gasState.traceState();
        EdgesEnum gatherEdges = this.getTraversalDirection().asTraversed(this.program.getGatherEdges());
        EdgesEnum scatterEdges = this.getTraversalDirection().asTraversed(this.program.getScatterEdges());
        if (gatherEdges != EdgesEnum.NoEdges) {
            pushDownApplyInGather = true;
            pushDownApplyInScatter = false;
            runApplyStage = false;
        } else if (scatterEdges != EdgesEnum.NoEdges) {
            pushDownApplyInGather = false;
            pushDownApplyInScatter = true;
            runApplyStage = false;
        } else {
            pushDownApplyInGather = false;
            pushDownApplyInScatter = false;
            runApplyStage = true;
        }
        long beginGather = System.nanoTime();
        long gatherEdgeCount = gatherEdges == EdgesEnum.NoEdges ? 0L : this.gatherEdges(this.graphAccessor, f, gatherEdges, pushDownApplyInGather);
        long elapsedGather = System.nanoTime() - beginGather;
        if (runApplyStage) {
            long beginApply = System.nanoTime();
            this.apply(f);
            elapsedApply = System.nanoTime() - beginApply;
        } else {
            elapsedApply = 0L;
        }
        long beginScatter = System.nanoTime();
        long scatterEdgeCount = scatterEdges == EdgesEnum.NoEdges ? 0L : this.scatterEdges(this.graphAccessor, f, this.gasState.getScheduler(), scatterEdges, pushDownApplyInScatter);
        long elapsedScatter = System.nanoTime() - beginScatter;
        long totalElapsed = elapsedGather + elapsedApply + elapsedScatter;
        long totalEdges = scatterEdgeCount + gatherEdgeCount;
        stats.add(f.size(), totalEdges, totalElapsed);
        if (log.isInfoEnabled()) {
            log.info((Object)("\ntotal: fontierSize=" + f.size() + ", ms=" + TimeUnit.NANOSECONDS.toMillis(totalElapsed) + ", edges=" + totalEdges + ", teps=" + GASUtil.getTEPS(totalEdges, totalElapsed) + "\ngather" + ": ms=" + TimeUnit.NANOSECONDS.toMillis(elapsedGather) + ", nedges=" + gatherEdgeCount + ", fanIn=" + GASUtil.fanOut(f.size(), gatherEdgeCount) + ", teps=" + GASUtil.getTEPS(gatherEdgeCount, elapsedGather) + (runApplyStage ? ", apply=" + TimeUnit.NANOSECONDS.toMillis(elapsedApply) : "") + "\nscatter" + ": ms=" + TimeUnit.NANOSECONDS.toMillis(elapsedScatter) + ", nedges=" + scatterEdgeCount + ", fanOut=" + GASUtil.fanOut(f.size(), scatterEdgeCount) + ", teps=" + GASUtil.getTEPS(scatterEdgeCount, elapsedScatter)));
        }
        this.gasState.endRound();
        boolean bl = nextRound = this.program.nextRound(this) || !this.gasState.frontier().isEmpty();
        if (nextRound) {
            this.graphAccessor.advanceView();
        }
        return nextRound;
    }

    private void apply(IStaticFrontier f) throws Exception {
        this.reduceOverFrontier(f, new ApplyReducer());
    }

    public <T> T reduceOverFrontier(IStaticFrontier f, final IReducer<VS, ES, ST, T> op) throws Exception {
        if (f == null) {
            throw new IllegalArgumentException();
        }
        if (op == null) {
            throw new IllegalArgumentException();
        }
        class ReduceVertexTaskFactory
        implements VertexTaskFactory<Long> {
            ReduceVertexTaskFactory() {
            }

            @Override
            public Callable<Long> newVertexTask(final Value u) {
                return new Callable<Long>(){

                    @Override
                    public Long call() {
                        op.visit(GASContext.this.gasState, u);
                        return ONE;
                    }
                };
            }
        }
        this.gasEngine.newFrontierStrategy(new ReduceVertexTaskFactory(), f).call();
        return op.get();
    }

    private long scatterEdges(final IGraphAccessor graphAccessor, IStaticFrontier f, final IGASScheduler sch, final EdgesEnum scatterEdges, final boolean pushDownApply) throws InterruptedException, ExecutionException, Exception {
        if (scatterEdges == null) {
            throw new IllegalArgumentException();
        }
        class ScatterVertexTaskFactory
        implements VertexTaskFactory<Long> {
            ScatterVertexTaskFactory() {
            }

            @Override
            public Callable<Long> newVertexTask(Value u) {
                return new ScatterTask(u){

                    @Override
                    protected boolean pushDownApply() {
                        return pushDownApply;
                    }

                    @Override
                    protected EdgesEnum getEdgesEnum() {
                        return scatterEdges;
                    }

                    @Override
                    protected IGASScheduler scheduler() {
                        return sch;
                    }

                    @Override
                    protected IGraphAccessor graphAccessor() {
                        return graphAccessor;
                    }
                };
            }
        }
        return this.gasEngine.newFrontierStrategy(new ScatterVertexTaskFactory(), f).call();
    }

    private long gatherEdges(final IGraphAccessor graphAccessor, IStaticFrontier f, final EdgesEnum gatherEdges, final boolean pushDownApply) throws InterruptedException, ExecutionException, Exception {
        if (gatherEdges == null) {
            throw new IllegalArgumentException();
        }
        class GatherVertexTaskFactory
        implements VertexTaskFactory<Long> {
            GatherVertexTaskFactory() {
            }

            @Override
            public Callable<Long> newVertexTask(Value u) {
                return new GatherTask(u){

                    @Override
                    protected boolean pushDownApply() {
                        return pushDownApply;
                    }

                    @Override
                    protected EdgesEnum getEdgesEnum() {
                        return gatherEdges;
                    }

                    @Override
                    protected IGASScheduler scheduler() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    protected IGraphAccessor graphAccessor() {
                        return graphAccessor;
                    }
                };
            }
        }
        return this.gasEngine.newFrontierStrategy(new GatherVertexTaskFactory(), f).call();
    }

    @Override
    public void setMaxIterations(int newValue) {
        if (newValue <= 0) {
            throw new IllegalArgumentException();
        }
        this.maxIterations.set(newValue);
    }

    @Override
    public TraversalDirectionEnum getTraversalDirection() {
        return this.traversalDirection.get();
    }

    @Override
    public void setTraversalDirection(TraversalDirectionEnum newVal) {
        if (newVal == null) {
            throw new IllegalArgumentException();
        }
        this.traversalDirection.set(newVal);
    }

    @Override
    public int getMaxIterations() {
        return this.maxIterations.get();
    }

    @Override
    public void setMaxVisited(int newValue) {
        if (newValue <= 0) {
            throw new IllegalArgumentException();
        }
        this.maxVertices.set(newValue);
    }

    @Override
    public int getMaxVisited() {
        return this.maxVertices.get();
    }

    @Override
    public URI getLinkType() {
        return this.linkType.get();
    }

    @Override
    public void setLinkType(URI linkType) {
        this.linkType.set(linkType);
    }

    @Override
    public URI getLinkAttributeType() {
        return this.linkAttributeType.get();
    }

    @Override
    public void setLinkAttributeType(URI linkAttributeType) {
        this.linkAttributeType.set(linkAttributeType);
    }

    @Override
    public void setTargetVertices(Value[] targetVertices) {
        this.targetVertices.addAll(Arrays.asList(targetVertices));
    }

    @Override
    public Set<Value> getTargetVertices() {
        return this.targetVertices;
    }

    @Override
    public void setMaxIterationsAfterTargets(int newValue) {
        if (newValue < 0) {
            throw new IllegalArgumentException();
        }
        this.maxIterationsAfterTargets.set(newValue);
    }

    @Override
    public int getMaxIterationsAfterTargets() {
        return this.maxIterationsAfterTargets.get();
    }

    protected IFilter getLinkAttribFilter(IGASContext<VS, ES, ST> ctx, URI linkAttribType) {
        return new LinkAttribFilter(ctx, linkAttribType);
    }

    @Override
    public <T> void setRunAfterOp(IReducer<VS, ES, ST, T> afterOp) {
        this.afterOp.set(afterOp);
    }

    @Override
    public <T> IReducer<VS, ES, ST, T> getRunAfterOp() {
        return this.afterOp.get();
    }

    private class LinkAttribFilter
    extends Filter {
        private static final long serialVersionUID = 1L;
        private final IGASState<VS, ES, ST> gasState;
        private final URI linkAttribType;

        public LinkAttribFilter(IGASContext<VS, ES, ST> ctx, URI linkAttribType) {
            if (linkAttribType == null) {
                throw new IllegalArgumentException();
            }
            this.gasState = ctx.getGASState();
            this.linkAttribType = linkAttribType;
        }

        public boolean isValid(Object e) {
            return this.gasState.isLinkAttrib((Statement)e, this.linkAttribType);
        }
    }

    private abstract class GatherTask
    extends VertexEdgesTask {
        public GatherTask(Value u) {
            super(u);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long call() throws Exception {
            long nedges = 0L;
            Iterator<Statement> eitr = GASContext.this.graphAccessor.getEdges(GASContext.this, this.u, this.getEdgesEnum());
            boolean first = true;
            Object left = null;
            while (eitr.hasNext()) {
                Statement e = eitr.next();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("u=" + this.u + ", e=" + GASContext.this.gasState.toString(e) + ", sum=" + left));
                }
                Object right = GASContext.this.program.gather(GASContext.this.gasState, this.u, e);
                if (first) {
                    left = right;
                    first = false;
                    continue;
                }
                left = GASContext.this.program.sum(GASContext.this.gasState, left, right);
            }
            if (this.pushDownApply()) {
                GASContext.this.program.apply(GASContext.this.gasState, this.u, left);
            }
            return nedges;
        }
    }

    private abstract class ScatterTask
    extends VertexEdgesTask {
        public ScatterTask(Value u) {
            super(u);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long call() throws Exception {
            boolean TRACE = log.isTraceEnabled();
            if (this.pushDownApply()) {
                GASContext.this.program.apply(GASContext.this.gasState, this.u, null);
            }
            if (!GASContext.this.program.isChanged(GASContext.this.gasState, this.u)) {
                return 0L;
            }
            long nedges = 0L;
            IGASScheduler sch = this.scheduler();
            Iterator<Statement> eitr = GASContext.this.graphAccessor.getEdges(GASContext.this, this.u, this.getEdgesEnum());
            while (eitr.hasNext()) {
                Statement e = eitr.next();
                ++nedges;
                if (TRACE) {
                    log.trace((Object)("e=" + GASContext.this.gasState.toString(e)));
                }
                GASContext.this.program.scatter(GASContext.this.gasState, sch, this.u, e);
            }
            return nedges;
        }
    }

    private abstract class VertexEdgesTask
    implements Callable<Long> {
        protected final Value u;

        public VertexEdgesTask(Value u) {
            this.u = u;
        }

        protected abstract IGraphAccessor graphAccessor();

        protected abstract boolean pushDownApply();

        protected abstract EdgesEnum getEdgesEnum();

        protected abstract IGASScheduler scheduler();
    }

    private class ApplyReducer<T>
    implements IReducer<VS, ES, ST, T> {
        private ApplyReducer() {
        }

        @Override
        public void visit(IGASState<VS, ES, ST> state, Value u) {
            GASContext.this.program.apply(state, u, null);
        }

        @Override
        public T get() {
            return null;
        }
    }
}

