/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph;

public enum EdgesEnum {
    NoEdges(false, false),
    InEdges(true, false),
    OutEdges(false, true),
    AllEdges(true, true);

    private final boolean inEdges;
    private final boolean outEdges;

    private EdgesEnum(boolean inEdges, boolean outEdges) {
        this.inEdges = inEdges;
        this.outEdges = outEdges;
    }

    public boolean doInEdges() {
        return this.inEdges;
    }

    public boolean doOutEdges() {
        return this.outEdges;
    }

    public boolean isDirected() {
        switch (this) {
            case NoEdges: {
                return false;
            }
            case AllEdges: {
                return false;
            }
            case InEdges: {
                return true;
            }
            case OutEdges: {
                return true;
            }
        }
        throw new UnsupportedOperationException();
    }

    public EdgesEnum asUndirectedTraversal() {
        switch (this) {
            case NoEdges: 
            case AllEdges: {
                return this;
            }
            case InEdges: 
            case OutEdges: {
                return AllEdges;
            }
        }
        throw new UnsupportedOperationException();
    }
}

