/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.owlxml.renderer;

import java.io.PrintWriter;
import java.util.Map;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.io.AbstractOWLRenderer;
import org.semanticweb.owlapi.io.OWLRendererException;
import org.semanticweb.owlapi.io.OWLRendererIOException;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.owlxml.renderer.OWLXMLObjectRenderer;
import org.semanticweb.owlapi.owlxml.renderer.OWLXMLWriter;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.Namespaces;

public class OWLXMLRenderer
extends AbstractOWLRenderer {
    public static void render(OWLOntology ontology, PrintWriter writer, OWLDocumentFormat format) throws OWLRendererException {
        OWLAPIPreconditions.checkNotNull((Object)ontology, (String)"ontology cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)writer, (String)"writer cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)format, (String)"format cannot be null");
        try {
            OWLXMLWriter w = new OWLXMLWriter(writer, ontology);
            w.startDocument(ontology);
            if (format instanceof PrefixDocumentFormat) {
                PrefixDocumentFormat fromPrefixFormat = (PrefixDocumentFormat)format;
                Map map = fromPrefixFormat.getPrefixName2PrefixMap();
                for (Map.Entry e : map.entrySet()) {
                    if (e.getValue() == null || ((String)e.getValue()).isEmpty()) continue;
                    w.writePrefix((String)e.getKey(), (String)e.getValue());
                }
                if (!map.containsKey("rdf:")) {
                    w.writePrefix("rdf:", Namespaces.RDF.toString());
                }
                if (!map.containsKey("rdfs:")) {
                    w.writePrefix("rdfs:", Namespaces.RDFS.toString());
                }
                if (!map.containsKey("xsd:")) {
                    w.writePrefix("xsd:", Namespaces.XSD.toString());
                }
                if (!map.containsKey("owl:")) {
                    w.writePrefix("owl:", Namespaces.OWL.toString());
                }
            } else {
                w.writePrefix("rdf:", Namespaces.RDF.toString());
                w.writePrefix("rdfs:", Namespaces.RDFS.toString());
                w.writePrefix("xsd:", Namespaces.XSD.toString());
                w.writePrefix("owl:", Namespaces.OWL.toString());
            }
            OWLXMLObjectRenderer ren = new OWLXMLObjectRenderer(w);
            ontology.accept((OWLObjectVisitor)ren);
            w.endDocument();
            writer.flush();
        }
        catch (OWLRuntimeException e) {
            throw new OWLRendererIOException((Exception)((Object)e));
        }
    }

    public void render(OWLOntology ontology, PrintWriter writer) throws OWLRendererException {
        OWLAPIPreconditions.checkNotNull((Object)ontology, (String)"ontology cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)writer, (String)"writer cannot be null");
        OWLXMLRenderer.render(ontology, writer, ontology.getNonnullFormat());
    }
}

