/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.config;

import com.bigdata.util.config.LogUtil;
import com.bigdata.util.config.NicUtil;
import java.io.IOException;
import net.jini.url.httpmd.HttpmdUtil;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ConfigurationUtil {
    private static final Logger logger = LogUtil.getLog4jLogger(ConfigurationUtil.class);

    public static String[] concat(String[] a, String[] b) {
        String[] result = new String[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    public static String[] createArgList(String[] prevArgList, String argString) {
        if (argString.matches("^[ \t]*$")) {
            return prevArgList;
        }
        String[] newArgs = argString.split("\u001e");
        return ConfigurationUtil.concat(prevArgList, newArgs);
    }

    public static String computeCodebase(String name, String jarFile, int port, String srcRoot, String mdAlgorithm) throws IOException {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (jarFile == null) {
            throw new NullPointerException("jarFile cannot be null");
        }
        if (port < 0) {
            throw new IllegalArgumentException("port cannot be negative");
        }
        boolean doHttpmd = true;
        if (mdAlgorithm == null || "".equals(mdAlgorithm) || "off".equals(mdAlgorithm) || "none".equals(mdAlgorithm)) {
            doHttpmd = false;
        }
        if (doHttpmd && srcRoot == null) {
            throw new NullPointerException("srcRoot cannot be null when constructing an HTTPMD codebase");
        }
        String codebase = null;
        String ipAddr = name;
        try {
            ipAddr = NicUtil.getIpAddress((String)name);
        }
        catch (Exception e) {
            logger.log((Priority)Level.TRACE, (Object)(name + " - not a valid " + "network interface, assuming host name"));
        }
        if (doHttpmd) {
            String httpmdUrl = "httpmd://" + ipAddr + ":" + port + "/" + jarFile + ";" + mdAlgorithm + "=0";
            codebase = HttpmdUtil.computeDigestCodebase((String)srcRoot, (String)httpmdUrl);
        } else {
            codebase = "http://" + ipAddr + ":" + port + "/" + jarFile;
        }
        logger.log((Priority)Level.TRACE, (Object)("codebase = " + codebase));
        return codebase;
    }

    public static String computeCodebase(String name, String jarFile, String port, String srcRoot, String mdAlgorithm) throws IOException {
        return ConfigurationUtil.computeCodebase(name, jarFile, Integer.parseInt(port), srcRoot, mdAlgorithm);
    }

    public static String computeCodebase(String name, String jarFile, int port) throws IOException {
        return ConfigurationUtil.computeCodebase(name, jarFile, port, null, null);
    }

    public static String computeCodebase(String name, String jarFile, String port) throws IOException {
        return ConfigurationUtil.computeCodebase(name, jarFile, Integer.parseInt(port));
    }
}

